DECLARE SUB Engine.InitVars ()
DECLARE SUB Engine.DoControls (Finval%)
DECLARE SUB AF.Box (DestSeg%, X1%, Y1%, X2%, Y2%, C%)
DECLARE SUB AF.BoxTransF (DestSeg%, X1%, Y1%, X2%, Y2%, C%)
DECLARE SUB Engine.DrawStatBar ()
DECLARE SUB AF.Font256 (DestSeg%, X%, Y%, Text$, Centered%, FontArray%(), FontArrayIndex%())
DECLARE SUB Engine.Main ()
DECLARE SUB Engine.MovePlayer (Player AS ANY)
DECLARE SUB Engine.DrawPlayer (Player AS ANY)
DECLARE SUB Engine.InitHero (NewObject AS ANY)
DECLARE SUB Engine.DrawScreen ()
DECLARE SUB Engine.UpdateCamera (Level AS ANY, Player AS ANY)
DECLARE SUB Engine.DrawMap ()
DECLARE SUB Engine.InitLevel ()
DECLARE FUNCTION Engine.TileCollide% (Player AS ANY)
DECLARE SUB Engine.LoadMap ()
DECLARE SUB AF.SpriteSolid (DestSeg%, X%, Y%, SPRITESEGMENT%, SPRITEOFFSET%)
DECLARE SUB Engine.LoadDATA ()
DECLARE SUB InitImageData (FileName$, ImageArray%())
DECLARE SUB MakeImageIndex (ImageArray%(), IndexArray%())
DECLARE SUB AF.LoadPalPp256 (File$)
DECLARE FUNCTION MULTIKEY% (t%)
DECLARE FUNCTION AF.Collide% (LAYER%, X%, Y%, SPRSEG%, SPROFF%)
DECLARE FUNCTION AF.CollideSpr% (X1%, Y1%, SprSeg1%, SprOff1%, X2%, Y2%, SprSeg2%, SprOff2%)
DECLARE SUB AF.Pset (DestSeg%, X%, Y%, C%)
DECLARE FUNCTION AF.Point% (DestSeg%, X%, Y%)
DECLARE SUB AF.Pcopy (DestSeg%, SRCSEG%)
DECLARE SUB AF.Sprite (DestSeg%, X%, Y%, SPRITESEGMENT%, SPRITEOFFSET%)

'January 5,2003
'Zelda type scrolling tutorial by
'Richard Eric M. Lope aka Relsoft

'Hi folks!!!! Genso Sanzo here(back from a lousy vacation ;*()
'I was asked before taking up my 2 week vacation if I could write a
'simple zelda style pixel*pixel scrolling tutorial. So here goes...

'For whom this tutorial is intended? For QB/Qbasic users who wanted
'to understand the basics of the engine.

'What you need:
'1.Any version of QB(tested only in QB 4.5 but should work fine in any ver)
'2.Load QB with the /L option(ie. QB/L  [enter]
'3.Minimum requirement is a 486(runs at an acceptable speed on a 486 dx/66)

'I've commented the code as much as I could ;*)

'PS. I'll release a version that uses external files after this and
'will make a future version with Objects/NPC's if people like it.


DEFINT A-Z
REM $DYNAMIC

'========Declare types here
TYPE SpriteType
         id             AS INTEGER              'id[unused]
         X              AS INTEGER              'World X pos
         Y              AS INTEGER
         oldX           AS INTEGER              'Snapback values
         oldY           AS INTEGER
         Xv             AS INTEGER              'X Speed
         Yv             AS INTEGER              'Y speed
         Active         AS INTEGER
         Frame          AS INTEGER              'Frame in tile where to draw
         MinFrame       AS INTEGER              '[unused]
         NumFrame       AS INTEGER              '[unused]
         Move           AS INTEGER              'if the sprite is moving?
         Counter        AS INTEGER              'misc counter
         Direction      AS INTEGER              'we will use this :)
         DirChanged     AS INTEGER              'if it changed direction
         oldDir         AS INTEGER              '
         TileX          AS INTEGER              'Tile where the Player is on
         TileY          AS INTEGER
         Collide        AS INTEGER              '[unused]
         Speed          AS INTEGER              'player stride speed
END TYPE


TYPE LevelType
        Xmax    AS INTEGER          'Maximum Number of Tiles a Map has
        Ymax    AS INTEGER
        CamX    AS INTEGER          'Pixel*Pixel Camera Position
        CamY    AS INTEGER
        TileX   AS INTEGER          'Tile postion of Camera
        TileY   AS INTEGER          'Calculated by CAMX\TileSize(16*16)
        Xpos    AS INTEGER          'Pixel position Inside the Tile
        Ypos    AS INTEGER          '0 to 15 (used for Scrolling)
END TYPE


TYPE MapLayerType
       BaseL     AS INTEGER         'Farthest layer
       FringeL   AS INTEGER         '[unused]
       TiltL  AS INTEGER            '[unused]
END TYPE


'KEY CONSTANTS
CONST KEYESC = 1, KEYENTER = 28, KEYSPACE = 57, KEYTAB = &HF
CONST KEYUP = 72, KEYDOWN = 80, KEYLEFT = 75, KEYRIGHT = 77

'Of course!!!!! :)
CONST FALSE = 0, TRUE = NOT FALSE
CONST VIDEO = &HA000

'Screen constants(Full Screen 320*200)
CONST ScrnXmax = 320, ScrnYmax = 200
CONST ScrnXmid = 160 - 8, ScrnYmid = 100 - 8
CONST ScrnXmin = 0, ScrnYmin = 0

'Tile dimensions 16*16
CONST TileW = 16
CONST TileH = 16

'Number of Tiles per screen 320\16=20,200\16=12
'Used to calculate the DrawMap sub
CONST ScrnTileXmax = ScrnXmax \ TileW
CONST ScrnTileYmax = ScrnYmax \ TileH

'Map Dimensions change this to suit your needs
'Base this on the MAPDATA dimensions
CONST MapXmax = 35, MapYmax = 26

'Directional constants for easy sprite handling
'DN=Neutral(not Moving), DR=Right...........
CONST DN = 0, DU = 1, DR = 2, DD = 3, DL = 4


RANDOMIZE TIMER

CLS
SCREEN 13
RANDOMIZE TIMER
DIM SHARED VPage(31999)                             'our buffer
DIM SHARED Map(MapXmax, MapYmax) AS MapLayerType    'Our map

REDIM SHARED HeroSpr(1) AS INTEGER                  'The HeroSprite(pp256)
REDIM SHARED HeroSprIndex(1) AS INTEGER             'The HeroSpriteIndex

REDIM SHARED Tile(1) AS INTEGER                     'The Tiles(pp256)
REDIM SHARED TileIndex(1) AS INTEGER

REDIM SHARED Font(1) AS INTEGER                     'The nifty fonts
REDIM SHARED FontIndex(1) AS INTEGER

DIM SHARED Level AS LevelType                       'Global level varialble
DIM SHARED Hero AS SpriteType                       'our hero

DIM SHARED LAYER                'For ease of referencing the draw commands
DIM SHARED VsyncOn              'if we wait for vertical refresh
DIM SHARED StatBarON            'if we want to see the statbar

LAYER = VARSEG(VPage(0))        'get the SEGMENT of our buffer

Engine.LoadDATA                 'Load tiles and palette
Engine.LoadMap                  'Load map
Engine.InitVars                 'Init some global vars
Engine.InitLevel                'Load level
Engine.InitHero Hero            'Load hero
Engine.Main                     'do the scrolling

'Back to system
CLS
SCREEN 0
WIDTH 80
END



FJPALDATA: 'Pp256 palette data(16 color gradient pal.
DATA 0,2752512,10752,2763264,42,2752554,5418,2763306
DATA 1381653,4134165,1392405,4144917,1381695,4134207,1392447,4144959
DATA 0,328965,526344,723723,921102,1118481,1315860,1579032
DATA 1842204,2105376,2368548,2631720,2960685,3289650,3684408,4144959
DATA 0,4,8,12,16,21,25,29
DATA 33,37,42,46,50,54,58,63
DATA 0,262144,524288,786432,1048576,1376256,1638400,1900544
DATA 2162688,2424832,2752512,3014656,3276800,3538944,3801088,4128768
DATA 0,1024,2048,3072,4096,5376,6400,7424
DATA 8448,9472,10752,11776,12800,13824,14848,16128
DATA 0,262148,524296,786444,1048592,1376277,1638425,1900573
DATA 2162721,2424869,2752554,3014702,3276850,3538998,3801146,4128831
DATA 0,263168,526336,789504,1052672,1381632,1644800,1907968
DATA 2171136,2434304,2763264,3026432,3289600,3552768,3815936,4144896
DATA 0,1028,2056,3084,4112,5397,6425,7453
DATA 8481,9509,10794,11822,12850,13878,14906,16191
DATA 0,516,1032,1548,2064,2581,3097,3613
DATA 4385,4901,5418,5934,6450,6966,7482,8255
DATA 0,131076,262152,393228,524304,655381,786457,917533
DATA 1114145,1245221,1376298,1507374,1638450,1769526,1900602,2097215
DATA 0,262656,525312,787968,1050624,1378816,1641472,1904128
DATA 2167040,2429696,2757888,3020544,3283200,3545856,3808512,4136960
DATA 0,131844,263688,395532,527376,659477,791321,923165
DATA 1120545,1252389,1384490,1516334,1648178,1780022,1911866,2109503
DATA 0,131588,263176,394764,526352,657941,789529,921117
DATA 1118497,1250085,1381674,1513262,1644850,1776438,1908026,2105407
DATA 0,515,1030,1545,2060,2575,3090,3605
DATA 4376,4891,5406,5921,6436,6951,7466,8238
DATA 63,2103,4143,6183,8223,10008,12048,14088
DATA 16128,13833,11538,9243,6948,4653,2358,63
DATA 32,1058,2084,3110,4136,5418,6444,7470
DATA 8496,9522,10804,11830,12856,13882,14908,16191

FONTDATA: 'EX-FNT01.PUT image data.
DATA 2752
DATA 64,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,8,31,5406,5405,5404
DATA 5403,5376,25,5376,32,8,31,31,5406,5406,5405,5405,5376,5376,0,0,0,0,0,0
DATA 0,0,48,8,7936,7936,0,7710,7710,30,7424,7445,5397,7196,7196,28,6912,6933,5397,0
DATA 21,21,0,0,0,0,0,0,48,8,0,31,0,7710,7710,30,5405,5405,5397,7196
DATA 7196,28,5376,5403,5403,6682,6682,5402,5376,5401,5397,0,5376,0,64,8,0,0,0,31
DATA 7680,30,7680,5376,7424,5405,29,21,0,7189,5376,0,0,27,6939,0,6656,5376,6682,21
DATA 25,21,5376,21,5376,0,0,0,64,8,7967,7967,31,0,5406,5397,5406,0,5405,7424
DATA 5376,0,7168,7196,21,0,27,5397,27,27,5402,0,6656,5376,6425,6425,25,25,5376,5397
DATA 5397,5376,16,8,31,5406,5405,5376,0,0,0,0,32,8,0,31,7680,5376,29,21
DATA 5404,0,5403,0,6656,0,0,25,0,5376,32,8,31,0,7680,0,0,29,0,5404
DATA 0,5403,6656,5376,25,21,5376,0,48,8,0,0,0,30,30,30,7424,7453,5376,7196
DATA 7196,28,6912,6939,5397,26,5402,26,5376,5376,5376,0,0,0,48,8,0,0,0,0
DATA 30,0,0,5405,0,7196,7196,28,5376,5403,5397,0,5402,0,0,5376,0,0,0,0
DATA 24,8,0,0,0,0,0,0,0,0,0,6400,6144,5376,48,8,0,0,0,0
DATA 0,0,0,0,0,7196,7196,28,5376,5397,5397,0,0,0,0,0,0,0,0,0
DATA 16,8,0,0,0,0,0,0,25,5376,64,8,0,0,0,31,0,0,7680,5376
DATA 0,0,29,21,0,7168,5376,0,0,27,21,0,6656,5376,0,0,25,21,0,0
DATA 5376,0,0,0,64,8,7967,7967,7967,31,5406,5397,7701,5406,5405,0,29,5405,5404,7168
DATA 5376,5404,5403,27,21,5403,6682,5376,0,5402,6425,6425,6425,5401,5376,5397,5397,5397,64,8
DATA 0,7936,0,0,0,7680,21,0,0,7424,21,0,0,7168,21,0,0,6912,21,0
DATA 0,6656,21,0,0,6400,21,0,0,0,21,0,64,8,7967,7967,7967,31,5376,5397
DATA 5397,5406,0,0,0,5405,7196,7196,7196,5404,5403,5397,5397,5397,5402,0,0,0,6425,6425
DATA 6425,25,5376,5397,5397,5397,64,8,7967,7967,7967,31,5376,5397,5397,5406,0,0,0,5405
DATA 7168,7196,7196,5404,0,5397,5397,5403,0,0,0,5402,6425,6425,6425,5401,5376,5397,5397,5397
DATA 64,8,31,0,7936,0,5406,0,7680,21,5405,0,7424,21,5404,0,7168,21,5403,0
DATA 6912,21,6682,6682,6682,26,5376,5397,6421,5397,0,0,0,21,64,8,7967,7967,7967,31
DATA 5406,5397,5397,5397,5405,0,0,0,7196,7196,7196,28,5376,5397,5397,5403,0,0,0,5402
DATA 6425,6425,6425,5401,5376,5397,5397,5397,64,8,7967,7967,7967,31,5406,5397,5397,5397,5405,0
DATA 0,0,7196,7196,7196,28,5403,5397,5397,5403,5402,0,0,5402,6425,6425,6425,5401,5376,5397
DATA 5397,5397,64,8,7967,7967,7967,31,5376,5397,5397,5406,0,0,0,5405,0,0,0,5404
DATA 0,0,0,5403,0,0,0,5402,0,0,0,5401,0,0,0,5376,64,8,7967,7967
DATA 7967,31,5406,5397,5397,5406,5405,0,0,5405,7196,7196,7196,5404,5403,5397,5397,5403,5402,0
DATA 0,5402,6425,6425,6425,5401,5376,5397,5397,5397,64,8,7967,7967,7967,31,5406,5397,5397,5406
DATA 5405,0,0,5405,7196,7196,7196,5404,5376,5397,5397,5403,0,0,0,5402,6425,6425,6425,5401
DATA 5376,5397,5397,5397,16,8,0,0,0,28,5376,0,25,5376,24,8,0,0,0,0
DATA 0,28,0,21,0,6400,6144,5376,40,8,0,7936,0,7680,5376,7424,5376,7168,5404,0
DATA 6912,21,0,6656,0,0,6400,0,0,5376,48,8,0,0,0,0,0,0,7453,7453
DATA 29,5376,5397,5397,6939,6939,27,5376,5397,5397,0,0,0,0,0,0,40,8,31,0
DATA 0,30,0,0,29,0,7168,28,0,5403,21,26,21,25,21,0,21,0,64,8
DATA 7967,7967,7967,31,5376,5397,5397,5406,0,0,0,5405,0,7168,7196,5404,0,6912,5397,5397
DATA 0,0,21,0,0,6400,0,0,0,0,21,0,64,8,7967,7967,7967,31,5406,5397
DATA 5397,5406,5405,7453,29,5405,5404,5404,5404,5404,5403,6939,6939,5403,5402,5376,5397,5397,6425,6425
DATA 6425,25,5376,5397,5397,5397,64,8,0,0,0,31,0,0,7680,5406,0,0,29,5405
DATA 0,7168,5376,5404,0,27,21,5403,6656,6682,6682,5402,25,5397,5397,5401,5376,0,0,5376
DATA 64,8,7967,7967,7967,0,5406,5397,5397,30,5405,0,0,5405,7196,7196,7196,5376,5403,5397
DATA 5397,27,5402,0,0,5402,6425,6425,6425,5401,5376,5397,5397,5397,64,8,7967,7967,7967,31
DATA 5406,5397,5397,5397,5405,0,0,0,5404,0,0,0,5403,0,0,0,5402,0,0,0
DATA 6425,6425,6425,25,5376,5397,5397,5397,64,8,7967,7967,0,0,5406,5397,30,0,5405,0
DATA 7424,0,5404,0,0,28,5403,0,6912,5376,5402,0,26,21,6425,6425,5376,0,5376,5397
DATA 21,0,64,8,7967,7967,7967,31,5406,5397,5397,5397,5405,0,0,0,7196,7196,7196,0
DATA 5403,5397,5397,21,5402,0,0,0,6425,6425,6425,25,5376,5397,5397,5397,64,8,7967,7967
DATA 7967,31,5406,5397,5397,5397,5405,0,0,0,7196,7196,7196,0,5403,5397,5397,21,5402,0
DATA 0,0,5401,0,0,0,5376,0,0,0,64,8,7967,7967,7967,31,5406,5397,5397,5397
DATA 5405,0,0,0,5404,7168,7196,28,5403,0,5397,5403,5402,0,0,5402,6425,6425,6425,5401
DATA 5376,5397,5397,5397,64,8,31,0,0,31,5406,0,0,5406,5405,0,0,5405,7196,7196
DATA 7196,5404,5403,5397,5397,5403,5402,0,0,5402,5401,0,0,5401,5376,0,0,5376,64,8
DATA 0,7967,31,0,0,7680,5397,0,0,7424,21,0,0,7168,21,0,0,6912,21,0
DATA 0,6656,21,0,0,6425,25,0,0,5376,5397,0,64,8,0,7936,7967,31,0,0
DATA 5397,5406,0,0,0,5405,0,0,0,5404,0,0,0,5403,0,0,0,5402,6425,6425
DATA 6425,5401,5376,5397,5397,5397,64,8,31,0,0,31,5406,0,7680,5376,5405,0,29,21
DATA 5404,7168,5376,0,5403,27,27,0,5402,5376,6656,0,5401,0,0,25,5376,0,0,5376
DATA 64,8,31,0,0,0,5406,0,0,0,5405,0,0,0,5404,0,0,0,5403,0
DATA 0,0,5402,0,0,0,6425,6425,6425,25,5376,5397,5397,5397,64,8,31,0,0,31
DATA 7710,0,7680,5406,5405,29,29,5405,5404,7168,5376,5404,5403,0,21,5403,5402,0,0,5402
DATA 5401,0,0,5401,5376,0,0,5376,64,8,31,0,0,31,7710,0,0,5406,5405,29
DATA 0,5405,5404,7168,0,5404,5403,0,27,5403,5402,0,6656,5402,5401,0,0,5401,5376,0
DATA 0,5376,64,8,7967,7967,7967,31,5406,5397,5397,5406,5405,0,0,5405,5404,0,0,5404
DATA 5403,0,0,5403,5402,0,0,5402,6425,6425,6425,5401,5376,5397,5397,5397,64,8,7967,7967
DATA 7967,31,5406,5397,5397,5406,5405,0,0,5405,5404,0,0,5404,6939,6939,6939,5403,5402,5397
DATA 5397,5397,5401,0,0,0,5376,0,0,0,64,8,7967,7967,7967,31,5406,5397,5397,5406
DATA 5405,0,0,5405,5404,7168,0,5404,5403,0,27,5403,5402,0,6656,5376,6425,6425,25,25
DATA 5376,5397,5397,5376,64,8,7967,7967,7967,31,5406,5397,5397,5406,5405,0,0,5405,5404,0
DATA 0,5404,5403,6939,6939,5403,5402,6656,5402,5397,5401,0,6421,25,5376,0,0,5397,64,8
DATA 7967,7967,7967,31,5406,5397,5397,5406,5405,0,0,5376,7196,7196,7196,28,5376,5397,5397,5403
DATA 26,0,0,5402,6425,6425,6425,5401,5376,5397,5397,5397,64,8,7967,7967,7967,31,5376,7701
DATA 5397,5397,0,7424,21,0,0,7168,21,0,0,6912,21,0,0,6656,21,0,0,6400
DATA 21,0,0,0,21,0,64,8,31,0,0,31,5406,0,0,5406,5405,0,0,5405
DATA 5404,0,0,5404,5403,0,0,5403,5402,0,0,5402,6425,6425,6425,5401,5376,5397,5397,5397
DATA 64,8,31,0,0,31,5406,0,7680,5376,5405,0,29,21,5404,7168,5376,0,5403,27
DATA 21,0,6682,5376,0,0,5401,21,0,0,5376,0,0,0,64,8,31,0,0,31
DATA 5406,0,0,5406,5405,7424,0,5405,5404,7168,21,5404,5403,6939,6933,5376,6682,6656,26,21
DATA 5401,6421,5397,0,5376,0,21,0,64,8,31,0,0,31,7680,0,7680,5376,0,29
DATA 29,21,0,7168,5376,0,0,27,27,0,6656,5376,6656,0,25,21,0,25,5376,0
DATA 0,5376,64,8,31,0,0,31,7680,0,7680,5376,0,29,29,21,0,7168,5376,0
DATA 0,6912,21,0,0,6656,21,0,0,6400,21,0,0,0,21,0,64,8,7967,7967
DATA 7967,31,5376,5397,7701,5397,0,0,29,21,0,7168,5376,0,0,27,21,0,6656,5376
DATA 0,0,6425,6425,6425,25,5376,5397,5397,5397,40,8,7967,7967,7680,5397,5397,5405,0,7168
DATA 21,0,5403,0,6656,21,0,6425,6425,0,5397,5397,64,8,31,0,0,0,7680,0
DATA 0,0,0,29,0,0,0,7168,0,0,0,0,27,0,0,0,6656,0,0,0
DATA 0,25,0,0,0,5376,40,8,7967,7967,0,5397,5406,0,7424,21,0,5404,0,6912
DATA 21,0,5402,6425,6425,21,5397,5397,64,8,0,7967,7967,0,7680,6168,6168,30,5917,7959
DATA 5919,7447,5660,5662,5654,7190,5403,5405,5397,6933,5146,7188,5148,6676,6400,4883,4883,25,0,6168
DATA 6168,0,64,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,6425,6425,6425,6425,6168,6168,6168,6168,64,8,7967,7967
DATA 7967,7967,7710,7710,7710,7710,7453,7453,7453,7453,7196,7196,7196,7196,6939,6939,6939,6939,6682,6682
DATA 6682,6682,6425,6425,6425,6425,6168,6168,6168,6168,48,8,0,0,0,0,0,0,0,0
DATA 29,0,7168,5404,0,27,5403,6656,6682,5402,25,5397,5401,5376,0,5376,48,8,0,0
DATA 0,0,0,0,7453,7453,0,5404,5397,28,6939,6939,5376,5402,5397,26,6425,6425,5401,5376
DATA 5397,5397,48,8,0,0,0,0,0,0,7453,7453,29,5404,5397,5397,5403,0,0,5402
DATA 0,0,6425,6425,25,5376,5397,5397,48,8,0,0,0,0,0,0,7453,29,0,5404
DATA 7189,0,5403,0,27,5402,6656,5376,6425,25,21,5376,5397,0,48,8,0,0,0,0
DATA 0,0,7453,7453,29,5404,5397,5397,6939,6939,0,5402,5397,21,6425,6425,25,5376,5397,5397
DATA 48,8,0,0,0,0,0,0,7453,7453,29,5404,5397,5397,6939,6939,0,5402,5397,21
DATA 5401,0,0,5376,0,0,48,8,0,0,0,0,0,0,7453,7453,29,5404,5397,5397
DATA 5403,6939,27,5402,5376,5402,6425,6425,5401,5376,5397,5397,48,8,0,0,0,0,0,0
DATA 29,0,29,5404,0,5404,6939,6939,5403,5402,5397,5402,5401,0,5401,5376,0,5376,48,8
DATA 0,0,0,0,0,0,7424,7453,0,0,5404,21,0,5403,0,0,5402,0,6400,6425
DATA 0,0,5397,21,48,8,0,0,0,0,0,0,0,7453,29,0,5376,5404,0,0
DATA 5403,0,0,5402,6425,6425,5401,5376,5397,5397,48,8,0,0,0,0,0,0,29,0
DATA 29,5404,7168,5376,5403,27,21,6682,6656,0,5401,21,25,5376,0,5376,48,8,0,0
DATA 0,0,0,0,29,0,0,5404,0,0,5403,0,0,5402,0,0,6425,6425,25,5376
DATA 5397,5397,48,8,0,0,0,0,0,0,29,0,29,7196,7168,5404,5403,27,5403,5402
DATA 5376,5402,5401,0,5401,5376,0,5376,48,8,0,0,0,0,0,0,29,0,29,7196
DATA 0,5404,5403,27,5403,5402,6656,5402,5401,0,5401,5376,0,5376,48,8,0,0,0,0
DATA 0,0,7453,7453,29,5404,5397,5404,5403,0,5403,5402,0,5402,6425,6425,5401,5376,5397,5397
DATA 48,8,0,0,0,0,0,0,7453,7453,29,5404,5397,5404,5403,0,5403,6682,6682,5402
DATA 5401,5397,5397,5376,0,0,48,8,0,0,0,0,0,0,7453,7453,29,5404,5397,5404
DATA 5403,27,5403,5402,6656,5376,6425,25,25,5376,5397,5376,48,8,0,0,0,0,0,0
DATA 7453,7453,29,5404,5397,5404,5403,0,5403,5402,6682,5376,5401,6400,25,5376,0,5397,48,8
DATA 0,0,0,0,0,0,7453,7453,29,5404,5397,5397,6939,6939,27,5376,5397,5402,6425,6425
DATA 5401,5376,5397,5397,48,8,0,0,0,0,0,0,7453,7453,29,5376,5404,5397,0,5403
DATA 0,0,5402,0,0,5401,0,0,5376,0,48,8,0,0,0,0,0,0,29,0
DATA 29,5404,0,5404,5403,0,5403,5402,0,5402,6425,6425,5401,5376,5397,5397,48,8,0,0
DATA 0,0,0,0,29,0,29,5404,7168,5376,5403,27,21,6682,5376,0,5401,21,0,5376
DATA 0,0,48,8,0,0,0,0,0,0,29,0,29,5404,28,5404,5403,5403,5403,6682
DATA 6682,5376,5401,5401,21,5376,5376,0,48,8,0,0,0,0,0,0,29,0,29,7168
DATA 7168,5376,0,27,21,6656,6656,0,25,21,25,5376,0,5376,48,8,0,0,0,0
DATA 0,0,29,0,29,7168,7168,5376,0,27,21,0,5402,0,0,5401,0,0,5376,0
DATA 48,8,0,0,0,0,0,0,7453,7453,29,5376,7189,5397,0,27,21,6656,5376,0
DATA 6425,6425,25,5376,5397,5397,56,8,0,7936,7967,0,7680,5376,5397,0,5405,0,7168,28
DATA 21,0,5376,27,0,0,6656,21,0,0,6400,6425,0,0,5376,5397,24,8,7967,7680
DATA 5406,7453,21,5397,6939,6656,5402,6425,21,5397,56,8,7967,31,0,0,5397,30,0,0
DATA 7424,21,0,0,7168,28,0,6912,5376,21,0,5402,0,6425,25,21,0,5397,21,0
DATA 64,8,0,31,0,31,7680,7680,7680,5376,29,21,29,21,5376,0,5376,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,8,7967,7967,0,7936
DATA 0,5406,7710,7680,5406,7424,7445,7445,7424,21,5404,5404,5376,5404,0,21,21,0,21,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0

HERODATA:   'Data for outr Sprite
DATA 2080
DATA 128,16,0,0,0,0,0,0,0,0,0,0,4096,4096,16,16,0,0,0,0
DATA 4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4122,4112,4112
DATA 0,0,0,0,4112,6672,-17648,4112,0,0,0,0,-17648,6847,-17648,4287,0,0,0,0
DATA 4112,6672,4283,4112,0,0,0,4112,3856,-17648,4287,4111,0,0,4096,-16453,4165,-17477,-16449,19216
DATA 4112,0,11536,4287,17733,4112,4112,4171,-16453,16,-17648,16,4112,18504,19272,4112,-16449,16,4096,16
DATA -10224,4112,4112,4312,4112,0,0,0,-10224,-9000,-10020,4312,0,0,0,0,4096,7896,4316,16
DATA 0,0,0,0,4096,7707,4126,0,0,0,128,16,0,0,4096,4096,16,16,0,0
DATA 0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4122
DATA 4112,4112,0,0,0,0,4112,6672,-17648,4112,0,0,0,0,-17648,6847,-17648,4287,0,0
DATA 0,0,4112,6672,4283,4112,0,0,0,0,3856,-17648,4287,4111,0,0,0,4096,4165,-16453
DATA -16449,19216,16,0,0,4112,17733,4112,4112,19275,4112,0,0,-17648,17680,17736,18504,4171,4283,0
DATA 4096,11707,4112,18501,19272,4112,-16453,16,4096,-16453,-10224,4112,4112,4316,-16453,16,0,4112,-10224,-8996
DATA -9000,4316,4112,0,0,0,-10224,-9186,7896,4316,0,0,0,0,6928,7710,7707,4126,0,0
DATA 128,16,0,0,0,0,0,0,0,0,0,0,4096,4096,16,16,0,0,0,0
DATA 4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4122,4112,4112
DATA 0,0,0,0,4112,6672,-17648,4112,0,0,0,0,-17648,6847,-17648,4287,0,0,0,0
DATA 4112,6672,4283,4112,0,0,0,4096,3856,-17648,4287,4111,4112,0,0,4112,4165,-16453,-16449,19216
DATA -16453,16,4096,-17473,17680,4112,4112,19275,-17648,4287,4096,-16449,4112,18504,19272,4112,4096,4283,0,4112
DATA -10224,4112,4112,4316,4096,16,0,0,-10224,-10024,-8996,4316,0,0,0,0,4096,-10224,-9186,16
DATA 0,0,0,0,0,6928,7710,16,0,0,128,16,0,0,4096,4096,16,16,0,0
DATA 0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4122
DATA 4112,4112,0,0,0,0,4112,6672,-17648,4112,0,0,0,0,-17648,6847,-17648,4287,0,0
DATA 0,0,4112,6672,4283,4112,0,0,0,0,3856,-17648,4287,4111,0,0,0,4096,4165,-16453
DATA -16449,19216,16,0,0,4112,17733,4112,4112,19275,4112,0,0,-17648,17680,17736,18504,4171,4283,0
DATA 4096,11707,4112,18501,19272,4112,-16453,16,4096,-16453,-10224,4112,4112,4316,-16453,16,0,4112,-10224,-8996
DATA -9000,4316,4112,0,0,0,-10224,-9186,7896,4316,0,0,0,0,6928,7710,7707,4126,0,0
DATA 128,16,0,0,0,0,0,0,0,0,0,0,4096,4112,4096,0,0,0,0,0
DATA 4112,4112,4112,16,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112
DATA 0,0,0,0,4112,4112,4112,4112,0,0,0,4096,4122,-16453,4112,4112,4096,0,0,6672
DATA -17648,4112,4283,4112,7696,16,0,26,-17648,3856,-16453,4112,4112,0,0,0,-17648,-16449,4287,-17589
DATA 4287,0,0,4096,4112,4112,19216,4168,-16453,16,0,4096,4283,18501,18501,16,-17648,16,0,4096
DATA 4283,17733,-9144,16,4112,0,0,0,-10224,-10020,-8996,4316,0,0,0,0,-10224,4316,-9000,7900
DATA 16,0,0,4096,7707,7710,6928,4126,0,0,128,16,0,0,4096,4112,4096,0,0,0
DATA 0,0,4112,4112,4112,16,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112
DATA 4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,4096,4122,-16453,4112,4112,0,0
DATA 0,6672,-17648,4112,4283,4112,16,0,0,26,-17648,3856,-16453,4112,16,0,0,0,-17648,-16449
DATA 4287,4171,4126,0,0,0,4096,4112,18448,4171,16,0,0,0,4096,17733,-17592,4287,0,0
DATA 0,0,4096,4165,-17648,4112,0,0,0,0,4096,-17648,-16449,16,0,0,0,0,4096,-17648
DATA 4287,16,0,0,0,0,4096,4312,4112,4316,0,0,0,0,6928,6928,7710,4126,0,0
DATA 128,16,0,0,0,0,0,0,0,0,0,0,4096,4112,4096,0,0,0,0,0
DATA 4112,4112,4112,16,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112
DATA 0,0,0,0,4112,4112,4112,4112,0,0,0,4096,4122,-16453,4112,4112,4096,0,0,6672
DATA -17648,4112,4283,4112,7696,16,0,26,-17648,3856,-16453,4112,16,0,0,0,-17648,-16449,4287,-17589
DATA 4283,0,0,4096,4112,4112,18448,4168,10939,16,0,4096,-16453,17680,18504,16,-17648,16,0,4096
DATA -16453,-16449,17680,16,4112,0,0,0,4112,4112,-10171,4316,0,0,0,0,-10224,-8996,4316,7896
DATA 16,0,0,4096,7707,7710,6928,4126,0,0,128,16,0,0,4096,4112,4096,0,0,0
DATA 0,0,4112,4112,4112,16,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112
DATA 4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,4096,4122,-16453,4112,4112,0,0
DATA 0,6672,-17648,4112,4283,4112,16,0,0,26,-17648,3856,-16453,4112,16,0,0,0,-17648,-16449
DATA 4287,4171,4126,0,0,0,4096,4112,18448,4171,16,0,0,0,4096,17733,-17592,4287,0,0
DATA 0,0,4096,4165,-17648,4112,0,0,0,0,4096,-17648,-16449,16,0,0,0,0,4096,-17648
DATA 4287,16,0,0,0,0,4096,4312,4112,4316,0,0,0,0,6928,6928,7710,4126,0,0
DATA 128,16,0,0,0,0,0,0,0,0,0,0,0,4112,16,16,0,0,0,0
DATA 4096,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112
DATA 0,0,0,0,4112,4112,4112,4112,0,0,0,16,4112,4112,-16453,6672,16,0,4096,4126
DATA 4112,-17648,4112,4283,4122,0,0,4096,4112,-16453,4111,4283,6656,0,0,-17648,17855,-17648,-16449,4287
DATA 0,0,4096,-16598,17680,4165,4112,4112,16,0,4096,4283,4096,18501,18504,-17648,16,0,0,4112
DATA 4096,17880,19272,-17648,16,0,0,0,-10224,-8996,-8996,4316,0,0,0,4096,-9189,-8996,-10224,4316
DATA 0,0,0,0,7696,4126,7707,7710,16,0,128,16,0,0,0,4112,16,16,0,0
DATA 0,0,4096,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112
DATA 4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,-16453,6672,16,0
DATA 0,4096,4112,-17648,4112,4283,4122,0,0,4096,4112,-16453,4111,4283,6656,0,0,7696,17680,-17648
DATA -16449,4287,0,0,0,4096,17680,4165,4112,16,0,0,0,0,-17648,18623,19272,16,0,0
DATA 0,0,4112,4283,19216,16,0,0,0,0,4096,10939,4287,16,0,0,0,0,4096,-17648
DATA 4287,16,0,0,0,0,-9200,4112,-9200,16,0,0,0,0,6928,7710,4126,4123,0,0
DATA 128,16,0,0,0,0,0,0,0,0,0,0,0,4112,16,16,0,0,0,0
DATA 4096,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112
DATA 0,0,0,0,4112,4112,4112,4112,0,0,0,16,4112,4112,-16449,6672,16,0,4096,4111
DATA 4112,-16624,4112,4287,4122,0,0,4096,4112,-16449,4111,4287,6656,0,0,-17648,17851,-16624,-16449,4287
DATA 0,0,4096,-17477,17680,4165,4112,4112,16,0,4096,4283,4096,18504,4171,-16453,16,0,0,4112
DATA 4096,4165,-16453,-16598,16,0,0,0,-10224,-9000,4112,4112,0,0,0,4096,-9189,-10224,-8996,4316
DATA 0,0,0,0,3856,4111,3867,3855,16,0,128,16,0,0,0,4112,16,16,0,0
DATA 0,0,4096,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112
DATA 4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,-16453,6672,16,0
DATA 0,4096,4112,-17648,4112,4283,4122,0,0,4096,4112,-16453,4111,4283,6656,0,0,7696,17680,-17648
DATA -16449,4287,0,0,0,4096,17680,4165,4112,16,0,0,0,0,-17648,18623,19272,16,0,0
DATA 0,0,4112,4283,19216,16,0,0,0,0,4096,10939,4287,16,0,0,0,0,4096,-17648
DATA 4287,16,0,0,0,0,-9200,4112,-9200,16,0,0,0,0,6928,7710,4126,4123,0,0
DATA 128,16,0,0,0,0,0,0,0,0,0,0,4096,4096,16,16,0,0,0,0
DATA 4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112
DATA 0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0
DATA 4112,4112,4112,4112,0,0,0,4112,4112,4112,4112,4112,0,0,4096,-16453,4165,4112,4112,19216
DATA 4112,0,-17648,4287,4165,4112,4112,4171,-17648,16,-17648,16,17680,7707,19216,4112,-17477,16,4096,16
DATA 4112,4112,4112,4316,4112,0,0,0,-10224,4112,-8996,4316,0,0,0,0,4096,-10224,-8996,16
DATA 0,0,0,0,0,6928,7710,16,0,0,128,16,0,0,4096,4096,16,16,0,0
DATA 0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112
DATA 4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0
DATA 0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,4096,4165,4112
DATA 4112,19216,16,0,0,4112,17733,4112,4112,19275,4112,0,0,-17648,17680,6984,18462,4171,4283,0
DATA 4096,-16453,4112,4165,19216,4112,-16595,16,4096,-16453,-10224,4112,4112,4316,-16453,16,0,4112,-10224,-8996
DATA -9200,4316,4112,0,0,0,-10224,-8996,-9000,4316,0,0,0,0,6928,7710,7707,4126,0,0
DATA 128,16,0,0,0,0,0,0,0,0,0,0,4096,4096,16,16,0,0,0,0
DATA 4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112
DATA 0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0
DATA 4112,4112,4112,4112,0,0,0,4096,4112,4112,4112,4112,4112,0,0,4112,4165,4112,4112,19216
DATA -16453,16,4096,4283,17680,4112,4112,19216,-17648,4141,4096,-17477,4112,4168,7707,4171,4096,4283,0,4112
DATA -10224,4112,4112,4312,4096,16,0,0,-10224,-8996,4112,4312,0,0,0,0,4096,-9000,4316,16
DATA 0,0,0,0,4096,7707,4126,0,0,0,128,16,0,0,4096,4096,16,16,0,0
DATA 0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112
DATA 4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0
DATA 0,0,4112,4112,4112,4112,0,0,0,0,4112,4112,4112,4112,0,0,0,4096,4165,4112
DATA 4112,19216,16,0,0,4112,17733,4112,4112,19275,4112,0,0,-17648,17680,6984,18462,4171,4283,0
DATA 4096,-16453,4112,4165,19216,4112,-16595,16,4096,-16453,-10224,4112,4112,4316,-16453,16,0,4112,-10224,-8996
DATA -9200,4316,4112,0,0,0,-10224,-8996,-9000,4316,0,0,0,0,6928,7710,7707,4126,0,0

TILEDATA: 'L01.PUT image data.
DATA 780
DATA 128,16,18504,19018,18761,18761,18505,19017,19017,18505,18761,18761,18505,18761,18762,18761,18760,18505,18760,18761
DATA 18762,19017,18761,19016,18761,18761,19017,19016,18505,18760,18762,18760,19017,18506,18505,18504,18762,18761,18762,19018
DATA 18504,18760,18760,18762,18761,18761,18505,18762,18760,18761,19017,18505,19017,18506,18761,19017,18506,19017,18761,19016
DATA 18762,19017,19016,18506,18760,18760,18506,18761,18761,19016,19017,19017,18760,19017,18761,18760,18761,19017,18761,19017
DATA 18761,18506,18761,18504,18761,18505,19017,18504,19016,18761,18506,19017,19016,18505,18761,18762,18761,18760,19016,18761
DATA 18504,18505,18761,18761,19016,18505,18504,18760,18762,18762,18762,18761,18505,18762,19016,18760,18762,18506,18505,18761
DATA 19016,18761,18760,19017,18504,18506,18761,18762,18760,18761,128,16,-30326,-30584,-30326,-30583,-30327,-30326,-30327,-30071
DATA -30583,-30072,-30327,-30584,-30327,-30071,-30582,-30327,-30070,-30328,-30328,-30584,-30328,-30071,-30328,-30326,-30583,-30327,-30071,-30070
DATA -30583,-30327,-30583,-30582,-30327,-30583,-30583,-30583,-30327,-30327,-30327,-30583,-30328,-30072,-30583,-30326,-30071,-30327,-30327,-30328
DATA -30327,-30584,-30583,-30584,-30071,-30327,-30327,-30071,-30071,-30583,-30326,-30583,-30327,-30071,-30582,-30326,-30326,-30326,-30328,-30328
DATA -30071,-30583,-30327,-30071,-30327,-30328,-30071,-30328,-30070,-30327,-30070,-30327,-30328,-30071,-30327,-30584,-30583,-30583,-30071,-30583
DATA -30326,-30328,-30327,-30071,-30583,-30584,-30326,-30071,-30071,-30072,-30326,-30071,-30582,-30328,-30583,-30070,-30327,-30326,-30327,-30583
DATA -30071,-30328,-30328,-30328,-30584,-30328,-30327,-30072,-30583,-30070,-30071,-30583,-30327,-30583,-30071,-30326,-30583,-30582,-30071,-30327
DATA 128,16,7708,7708,7705,7708,7198,7708,7198,7708,7196,7708,7193,7196,7196,7196,7196,7196,6939,7196
DATA 7193,6939,6940,6940,6939,7196,6425,6425,6425,6425,6425,6425,6425,6425,7198,7198,7710,7196,7708,6430
DATA 7196,7710,7196,7196,7196,7196,7196,6430,7196,7196,6940,6940,7195,7195,6939,6428,6939,7195,6425,6425
DATA 6425,6425,6425,6425,6425,6425,7196,7198,7710,6430,7198,7196,7198,7198,7196,7196,7196,6430,7196,7196
DATA 7196,7196,7195,6939,7196,6428,6939,6940,6939,6940,6425,6425,6425,6425,6425,6425,6425,6425,7710,7196
DATA 7710,7196,6430,7708,7198,7708,7196,7196,7196,7196,6430,7196,7196,7196,6939,6940,7196,6939,6428,6939
DATA 6940,6940,6425,6425,6425,6425,6425,6425,6425,6425,128,16,7708,7708,7705,7708,7198,7708,7198,7708
DATA 7196,7708,7193,7196,7196,7196,7196,7196,6939,7196,7193,6939,6940,6940,6939,7196,6425,6425,6425,6425
DATA 6425,6425,6425,6425,7198,6430,7710,7196,6428,6430,7196,7710,7196,6428,7196,7196,6428,6430,7196,7196
DATA 6940,6937,7193,7195,6937,6428,6939,7195,6425,6425,6425,6425,6425,6425,6425,6425,7196,7193,6430,6430
DATA 6430,7196,7198,7198,6428,7196,7196,6425,7196,7193,7196,7196,6427,6939,6428,6428,6939,6937,6939,6940
DATA 6425,6425,6425,6425,6425,6425,6425,6425,7710,7196,6430,7196,6430,6428,7198,7708,7196,7196,7193,7193
DATA 6425,6428,7196,7196,6939,6940,7196,6427,6428,6939,6937,6940,6425,6425,6425,6425,6425,6425,6425,6425
DATA 128,16,-31098,-31098,-31098,-31098,-30327,-30327,-30327,-30327,-31097,-31097,-31097,-31097,-30582,-30582,-30582,-30582,-31098,-31098
DATA -31098,-31098,-30327,-30327,-30327,-30327,-30842,-30842,-30842,-30842,-30072,-30072,-30072,-30072,-31098,-31098,-31098,-31098,-30327,-30327
DATA -30327,-30327,-31097,-31097,-31097,-31097,-30582,-30582,-30582,-30582,-31098,-31098,-31098,-31098,-30327,-30327,-30327,-30327,-30842,-30842
DATA -30842,-30842,-30072,-30072,-30072,-30072,-30327,-30327,-30327,-30327,-31098,-31098,-31098,-31098,-30582,-30582,-30582,-30582,-31097,-31097
DATA -31097,-31097,-30327,-30327,-30327,-30327,-31098,-31098,-31098,-31098,-30072,-30072,-30072,-30072,-30842,-30842,-30842,-30842,-30327,-30327
DATA -30327,-30327,-31098,-31098,-31098,-31098,-30582,-30582,-30582,-30582,-31097,-31097,-31097,-31097,-30327,-30327,-30327,-30327,-31098,-31098
DATA -31098,-31098,-30072,-30072,-30072,-30072,-30842,-30842,-30842,-30842,128,16,5896,5896,6168,6168,6168,6424,6425,6425
DATA 5895,6167,6168,6168,6168,6425,6425,1817,7175,6168,6168,6169,6169,6425,6425,1799,7196,6172,6425,6424
DATA 6425,6425,6937,1799,7196,7452,6168,6424,6425,6681,1799,7175,7452,7453,6172,6425,6425,1817,7196,7196
DATA 7196,7453,7453,6425,6425,7175,7196,7196,7452,7453,7453,6429,6937,6919,7196,7196,7453,7453,7710,2078
DATA 1800,7196,7196,7196,7453,7709,7709,2070,5896,7175,7452,7453,7453,7709,2078,2070,5911,7191,7452,7453
DATA 7710,7709,2056,2070,6167,6168,7196,7453,7454,2078,2071,5911,6167,6168,7448,7453,7710,2070,5896,5911
DATA 6168,6168,6424,7709,2078,2056,5911,6168,6168,6168,6425,7449,5910,5896,6167,6168,6168,6425,6424,6425



'Map Data
'I put this in a data statement since its easier to understand that way
' :)  you could put this in a file if you want
'Dimensions : 36*27
'Note: Col(X) #36 and Row(Y) #27 is not used by the Map. They are there for
'Padding purposes and to prevent errors.
BASEMAPDATA:
DATA 06,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,06
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,06,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,06,06,06,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,06,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,04,04,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,04,04,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,02,01,01,01,01,01,01,01,01,01,01,01,04,04,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,02,01,01,01,01,01,01,01,01,01,01,01,04,04,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,02,02,02,02,02,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,02,02,02,02,02,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,02,01,01,01,01,01,03,03,03,03,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,02,01,01,01,01,01,01,03,03,03,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,03,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,03,03,03,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,03,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,05,01,01,01,01,01,01,01,01,01,01,01,01,01,03,03,03,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,05,05,05,05,01,01,01,01,01,01,01,01,01,03,03,03,03,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,05,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
DATA 05,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,05

REM $STATIC
SUB AF.Box (DestSeg%, X1%, Y1%, X2%, Y2%, C%)
'Draws a box in a Layer(DestSeg%)
'Clipping supported
'parameters:
'Destseg=Layer to draw the Box(use VARSEG)
'X1,Y1,X2,Y2=Coordinates of the box
'C=Color

STATIC Asm.Box%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B46106631D28EC066528B460E8B4E0A39C87E01918B5E0C8B5608"
    Asm$ = Asm$ + "39D37E0287D33D3F010F8F970081FBC7000F8F8F003D00007D0231C083FB00"
    Asm$ = Asm$ + "7D0231DB83F9007C7C83FA007C7781F93F017E03B93F0181FAC7007E03BAC7"
    Asm$ = Asm$ + "0029C141894EFC29DA428956FA86DF89DFC1EF0201DF01C78A56FA8A4606BB"
    Asm$ = Asm$ + "400188C42B5EFC66C1E01080EA028A460688C48B4EFCC1E902F366AB8B4EFC"
    Asm$ = Asm$ + "83E103F3AA01DF268805037EFC268845FF01DFFECA75F08B4EFCC1E902F366"
    Asm$ = Asm$ + "AB8B4EFC83E103F3AA83C4041F5DCA0C00"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Box%(Size%)

    DEF SEG = VARSEG(Asm.Box%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Box%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.Box%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL C%, VARPTR(Asm.Box%(0)))
    DEF SEG

END SUB

SUB AF.BoxF (DestSeg%, X1%, Y1%, X2%, Y2%, C%)
'See AF.Box
'Draws a filled box
STATIC Asm.BoxF%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B46106631D28EC06652528B460E8B4E0A39C87E01918B5E0C8B5"
    Asm$ = Asm$ + "60839D37E0287D33D3F017F7981FBC7007F733D00007D0231C083FB007D02"
    Asm$ = Asm$ + "31DB83F9007C6083FA007C5B81F93F017E03B93F0181FAC7007E03BAC7002"
    Asm$ = Asm$ + "9C141894EFC29DA428956FA86DF89DFC1EF0201DF01C78B56FA8A4606BB40"
    Asm$ = Asm$ + "0188C42B5EFC89C166C1E01089C88B4EFCC1E902894EF88B4EF8F366AB8B4"
    Asm$ = Asm$ + "EFC83E103F3AA01DF4A75ED83C4061F5DCA0C00"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.BoxF%(Size%)

    DEF SEG = VARSEG(Asm.BoxF%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.BoxF%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.BoxF%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL C%, VARPTR(Asm.BoxF%(0)))
    DEF SEG

END SUB

SUB AF.BoxTrans (DestSeg%, X1%, Y1%, X2%, Y2%, C%)
'See AF.Box
'Draws a box Translucently!!!

STATIC Asm.BoxTrans%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B46108EC031D252528B460E8B4E0A39C87E01918B5E0C8B56083"
    Asm$ = Asm$ + "9D37E0287D33D3F010F8FD40081FBC7000F8FCC003D00007D0231C083FB00"
    Asm$ = Asm$ + "7D0231DB83F9000F8CB70083FA000F8CB00081F93F017E03B93F0181FAC70"
    Asm$ = Asm$ + "07E03BAC70029C141894EFC29DA428956FA86DF89DFC1EF0201DF01C78A56"
    Asm$ = Asm$ + "FA8A4606BB400180EA022B5EFC88C680E60F8B4EFC88F0268A2580E40F00C"
    Asm$ = Asm$ + "4D0EC2A4606F6D800E0268805474975E601DF88F0268A2580E40F00C4D0EC"
    Asm$ = Asm$ + "2A4606F6D800E0268805037EFC88F0268A65FF80E40F00C4D0EC2A4606F6D"
    Asm$ = Asm$ + "800E0268845FF01DFFECA75C98B4EFC88F0268A2580E40F00C4D0EC2A4606"
    Asm$ = Asm$ + "F6D800E0268805474975E683C4041F5DCA0C00"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.BoxTrans%(Size%)

    DEF SEG = VARSEG(Asm.BoxTrans%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.BoxTrans%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.BoxTrans%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL C%, VARPTR(Asm.BoxTrans%(0)))
    DEF SEG

END SUB

SUB AF.BoxTransF (DestSeg%, X1%, Y1%, X2%, Y2%, C%)
'See AF.Box
'Draws a filled box Translucently!!!

STATIC Asm.BoxTransF%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B46106631D28EC066528B460E8B4E0A39C87E01918B5E0C8B560"
    Asm$ = Asm$ + "839D37E0287D33D3F017F7981FBC7007F733D00007D0231C083FB007D0231"
    Asm$ = Asm$ + "DB83F9007C6083FA007C5B81F93F017E03B93F0181FAC7007E03BAC70029C"
    Asm$ = Asm$ + "141894EFC29DA428956FA86DF89DFC1EF0201DF01C78A76FABB40012B5EFC"
    Asm$ = Asm$ + "8A560680E20F8B4EFC88D0268A2580E40F00C4D0EC2A4606F6D800E026880"
    Asm$ = Asm$ + "5474975E601DFFECE75DD83C4041F5DCA0C00"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.BoxTransF%(Size%)

    DEF SEG = VARSEG(Asm.BoxTransF%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.BoxTransF%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.BoxTransF%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL C%, VARPTR(Asm.BoxTransF%(0)))
    DEF SEG

END SUB

SUB AF.Cls (DestSeg%, C%)
'Clears the Layer to a specified color
'Parameters:
'Destseg=Layer or page to clear(use VARSEG or VIDEO/&HA000)

STATIC Asm.Cls%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E58B46088CDA8EC031FF8A460688C489C166C1E01089C8B9803EF366AB8EDA5DCA0400"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Cls%(Size%)

    DEF SEG = VARSEG(Asm.Cls%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Cls%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF


    DEF SEG = VARSEG(Asm.Cls%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL C%, VARPTR(Asm.Cls%(0)))
    DEF SEG

END SUB

FUNCTION AF.Collide (LAYER%, X%, Y%, SPRSEG%, SPROFF%)
'Returns the color in the layer that the sprite collided with
'Pixel*pixel collision
'Parameters:
'Layer=Page to check collision with(use VARSEG/VIDEO/&HA000)
'X,Y=coordinates of the sprite
'SprSeg=Segment of the Sprite(use VARSEG)
'Sproff=offset of the Sprite(use VARPTR)

STATIC Asm.Collide%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B460C8ED88B56128EC28B760A3E8B1CC1EB0331C03E8B5402505"
    Asm$ = Asm$ + "383C60452508B46103D3F017F663D00007C788B4E0E81F9C7007F5883F900"
    Asm$ = Asm$ + "7C7A01C381FB3F010F8F7F0029C301CA81FAC7000F8F820029CA895EF886C"
    Asm$ = Asm$ + "DBB400189CF2B5EF8C1EF0201CF895EF601C78B5EF889D93E8A2408E47407"
    Asm$ = Asm$ + "268A0508C0751349464783F90075EA037EF60376FC4A75DF29C08B5E088EC"
    Asm$ = Asm$ + "328E48B7E0626880583C4081F5DCA0E00F7D829C37EE301C68946FC31C0E9"
    Asm$ = Asm$ + "78FFF7D929CA7ED30376FA4975FAE977FF81EB4001015EFCBB400129C3E97"
    Asm$ = Asm$ + "4FF01D181E9C80029CA8B4E0EE972FF"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Collide%(Size%)

    DEF SEG = VARSEG(Asm.Collide%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Collide%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    CLR% = 0
    AF.Collide = 0
    DEF SEG = VARSEG(Asm.Collide%(0))
    CALL ABSOLUTE(BYVAL LAYER%, BYVAL X%, BYVAL Y%, BYVAL SPRSEG%, BYVAL SPROFF%, BYVAL VARSEG(CLR%), BYVAL VARPTR(CLR%), VARPTR(Asm.Collide%(0)))
    DEF SEG
    AF.Collide = CLR%
END FUNCTION

FUNCTION AF.CollideSpr (X1%, Y1%, SprSeg1%, SprOff1%, X2%, Y2%, SprSeg2%, SprOff2%)
'Returns the color of the second sprite the first sprite collided with
'Pixel*pixel collision
'Parameters:
'Layer=Page to check collision with(use VARSEG/VIDEO/&HA000)
'X1,Y1=coordinates of the first sprite
'SprSeg1=Segment of the first Sprite(use VARSEG)
'Sproff1=offset of the first Sprite(use VARPTR)
'X2,Y2=coordinates of the second sprite
'SprSeg2=Segment of the second Sprite(use VARSEG)
'Sproff2=offset of the second Sprite(use VARPTR)


STATIC Asm.CollideSpr%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B46188B5E1029D88946188B4E168B560E29D1894E168B46148B4"
    Asm$ = Asm$ + "E0C8ED88EC18B76128B7E0A3E8B1C31C0C1EB038B5402505383C604525026"
    Asm$ = Asm$ + "8B0D268B4502C1E9034948515083C7048B46183B46F47F5E3D00007C728B4"
    Asm$ = Asm$ + "E163B4EF27F5183F9007C7501C33B5EF47F7D29C301CA3B56F20F8F820029"
    Asm$ = Asm$ + "CA895EF88B5EF4430FAFCB2B5EF8895EF601CF01C78B5EF889D93E8A04460"
    Asm$ = Asm$ + "8C0740A268A2580FC007511474975EE037EF60376FC4A75E329C086C428E4"
    Asm$ = Asm$ + "8B5E088EC38B7E0626890583C40C1F5DCA1400F7D829C37EE301C68946FC3"
    Asm$ = Asm$ + "1C0EB81F7D929CA7ED40376FA4975FDEB802B5EF44B015EFC8B5EF44329C3"
    Asm$ = Asm$ + "E97BFF01D12B4EF24929CA8B4E16E978FF8153E83401"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.CollideSpr%(Size%)

    DEF SEG = VARSEG(Asm.CollideSpr%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.CollideSpr%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    CLR% = 0
    AF.CollideSpr = 0
    DEF SEG = VARSEG(Asm.CollideSpr%(0))
    CALL ABSOLUTE(BYVAL X1%, BYVAL Y1%, BYVAL SprSeg1%, BYVAL SprOff1%, BYVAL X2%, BYVAL Y2%, BYVAL SprSeg2%, BYVAL SprOff2%, BYVAL VARSEG(CLR%), BYVAL VARPTR(CLR%), VARPTR(Asm.CollideSpr%(0)))
    DEF SEG
    AF.CollideSpr = CLR%

END FUNCTION

SUB AF.Font256 (DestSeg%, X%, Y%, Text$, Centered%, FontArray(), FontArrayIndex())

FontSeg% = VARSEG(FontArray(1))
IF NOT Centered% THEN

        FOR I% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, I%, 1)) - 31
                AF.Sprite DestSeg%, X%, Y%, FontSeg%, VARPTR(FontArray(FontArrayIndex(FontChar)))
                X% = X% + (FontArray(FontArrayIndex(FontChar%)) \ 8)
        NEXT I%

ELSE            'Centered

        StrLen% = 0
        FOR I% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, I%, 1)) - 31
                StrLen% = StrLen% + (FontArray(FontArrayIndex(FontChar%)))
        NEXT I%
        StrLen% = StrLen% \ 8  'Calculate length
        X% = (320 - StrLen%) \ 2
        FOR I% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, I%, 1)) - 31
                AF.Sprite DestSeg%, X%, Y%, FontSeg%, VARPTR(FontArray(FontArrayIndex(FontChar)))
                X% = X% + (FontArray(FontArrayIndex(FontChar%)) \ 8)
        NEXT I%

END IF


END SUB

SUB AF.Get (LAYER%, X1%, Y1%, X2%, Y2%, SPRSEG%, SPROFF%)
'Same a QB's GET statement
'Paramenters:
'Layer: the Page to GET the bounding box(VARSEG/VIDEO/&HA000)
'X1.Y1,X2,Y2:Coords of the box to get the image from
'SprSeg=Segment of the array(VARSEG)
'Sproff=offset of the array (VARPTR)

STATIC Asm.Get%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B46128B5E088ED88EC38B7E0631D252528B46108B4E0C39C87E0"
    Asm$ = Asm$ + "1918B5E0E8B560A39D37E0287D33D3F017F7081FBC7007F6A3D00007D0231"
    Asm$ = Asm$ + "C083FB007D0231DB83F9007C5783FA007C5281F93F017E03B93F0181FAC70"
    Asm$ = Asm$ + "07E03BAC70029C141894EFCC1E10326890D29DA428956FA2689550286DF89"
    Asm$ = Asm$ + "DEC1EE0201DE01C6BB40012B5EFC83C7048B4EFCC1E902F366A58B4EFC83E"
    Asm$ = Asm$ + "103F3AA01DE4A75EA83C4041F5DCA0E00"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Get%(Size%)

    DEF SEG = VARSEG(Asm.Get%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Get%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.Get%(0))
    CALL ABSOLUTE(BYVAL LAYER%, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL SPRSEG%, BYVAL SPROFF%, VARPTR(Asm.Get%(0)))
    DEF SEG

END SUB

SUB AF.LoadPalPp256 (File$) STATIC

'Loads a pp256 palette
'Changes the VGA palette on the fly
'if File$="" the data statement is used

IF File$ = "" OR File$ = " " THEN
    FOR n = 0 TO 255
        READ C&
        B = C& \ 65536: C& = C& - B * 65536
        G = C& \ 256: C& = C& - G * 256
        R = C&
        OUT &H3C8, n
        OUT &H3C9, R
        OUT &H3C9, G
        OUT &H3C9, B
     NEXT
ELSE
    FR = FREEFILE
    IF INSTR(File$, ".") = 0 THEN File$ = LEFT$(File$, 8) + ".Pal"
    OPEN File$ FOR BINARY AS #FR
        FOR n = 0 TO 255
            GET #FR, , C&
            B = C& \ 65536: C& = C& - B * 65536
            G = C& \ 256: C& = C& - G * 256
            R = C&
            OUT &H3C8, n
            OUT &H3C9, R
            OUT &H3C9, G
            OUT &H3C9, B
         NEXT
    CLOSE #FR
END IF

END SUB

SUB AF.Pcopy (DestSeg%, SRCSEG%)
'copies the sourceseg to destseg
'this acheives double buffering to eliminate flicker
'same as QB's PCOPY command
'Parameters:
'Destseg=Layer or page to copy to(usually VIDEO)
'srcseg=the source layer to copy from



STATIC Asm.Pcopy%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E58CD88B4E088B56068EC18EDA31FF31F6B9803EF366A58ED85DCA0400"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Pcopy%(Size%)

    DEF SEG = VARSEG(Asm.Pcopy%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Pcopy%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.Pcopy%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL SRCSEG%, VARPTR(Asm.Pcopy%(0)))
    DEF SEG

END SUB

FUNCTION AF.Point (DestSeg%, X%, Y%)
'Same as QB's POINT command
'Returns the color of the coordinate
'Paramenters:
'Dest seg=See AF.Box
'X,Y:coordinates of the point

STATIC Asm.Point%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E58B460E8EC08B560A7C2581FAC7007F1F8B5E0C83FB007C1781FB3F0"
    Asm$ = Asm$ + "17F1167668D1492C1E20689D701DF268A0530E48B5E088EC38B7E06268905"
    Asm$ = Asm$ + "5DCA0A00"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Point%(Size%)

    DEF SEG = VARSEG(Asm.Point%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Point%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    CLR% = 0
    AF.Point = 0
    Tseg% = VARSEG(CLR%)
    Toff% = VARPTR(CLR%)
    DEF SEG = VARSEG(Asm.Point%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL Tseg%, BYVAL Toff%, VARPTR(Asm.Point%(0)))
    DEF SEG
    AF.Point = CLR%

END FUNCTION

SUB AF.Print (Segment%, Xpos%, Ypos%, Text$, col%)
'Prints the standard 8*8 CGA font
'Paramenters:
'Segment=the Layer to print to
'Xpos,Ypos=the coordinates of the text
'Text$=the string to print
'col= is the color to print(gradient)

X% = Xpos%
Y% = Ypos%
Spacing% = 8
  FOR I% = 0 TO LEN(Text$) - 1
    X% = X% + Spacing%
    Offset% = 8 * ASC(MID$(Text$, I% + 1, 1)) + 14
    FOR J% = 0 TO 7
      DEF SEG = &HFFA6
      Bit% = PEEK(Offset% + J%)
      IF Bit% AND 1 THEN CALL AF.Pset(Segment%, X%, Y% + J%, col% + J%)
      IF Bit% AND 2 THEN CALL AF.Pset(Segment%, X% - 1, Y% + J%, col% + J%)
      IF Bit% AND 4 THEN CALL AF.Pset(Segment%, X% - 2, Y% + J%, col% + J%)
      IF Bit% AND 8 THEN CALL AF.Pset(Segment%, X% - 3, Y% + J%, col% + J%)
      IF Bit% AND 16 THEN CALL AF.Pset(Segment%, X% - 4, Y% + J%, col% + J%)
      IF Bit% AND 32 THEN CALL AF.Pset(Segment%, X% - 5, Y% + J%, col% + J%)
      IF Bit% AND 64 THEN CALL AF.Pset(Segment%, X% - 6, Y% + J%, col% + J%)
      IF Bit% AND 128 THEN CALL AF.Pset(Segment%, X% - 7, Y% + J%, col% + J%)
    NEXT J%
  NEXT I%
DEF SEG

END SUB

SUB AF.Pset (DestSeg%, X%, Y%, C%)
'Same as QB's PSET command
'Paramenters:
'Dest seg=See AF.Box
'X,Y:coordinates of the pixel
'C:color of the pixel to draw

STATIC Asm.Pset%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E58B460C8B56087C288EC081FAC7007F208B5E0A83FB007C1881FB3F01"
    Asm$ = Asm$ + "7F1267668D1492C1E20689D701DF8A4E0626880D5DCA0800"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Pset%(Size%)

    DEF SEG = VARSEG(Asm.Pset%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Pset%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.Pset%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL C%, VARPTR(Asm.Pset%(0)))
    DEF SEG

END SUB

SUB AF.PsetTrans (DestSeg%, X%, Y%, C%)
'See AF.Pset
'Draws a pixel translucently

STATIC Asm.PsetTrans%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E58B460C8B56087C3C8EC081FAC7007F348B5E0A83FB007C2C81FB3F0"
    Asm$ = Asm$ + "17F2667668D1492C1E20689D701DF8A4E0680E10F268A2D80E50F00CDD0ED"
    Asm$ = Asm$ + "2A4E06F6D900CD26882D5DCA0800"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.PsetTrans%(Size%)

    DEF SEG = VARSEG(Asm.PsetTrans%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.PsetTrans%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.PsetTrans%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL C%, VARPTR(Asm.PsetTrans%(0)))
    DEF SEG

END SUB

SUB AF.Sprite (DestSeg%, X%, Y%, SPRITESEGMENT%, SPRITEOFFSET%)
'AF.Sprite
'Draws a sprite on the Page/Layer or directly to screen
'Same as QB's PUT routine
'Skips Color 0, 197 bytes,No need for masks
'Clipping supported
'Parameters:
'Destseg:The layer to draw the sprite to(VARSEG/VIDEO/&HA000)
'X,Y:coordinates of the sprite
'SpriteSegment=the segment the of the SpriteArray(VARSEG)
'SpriteOffset=the offset the of the SpriteArray(VARPTR)

STATIC Asm.Sprite%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B56088EDA8B560E8EC28B76068B1C31C0C1EB038B5402505383"
    Asm$ = Asm$ + "C60452508B460C3D3F017F5B3D00007C5E8B4E0A81F9C7007F4D83F9007C"
    Asm$ = Asm$ + "5F01C381FB3F017F6529C301CA81FAC7007F6929CA895EF886CDBB400189"
    Asm$ = Asm$ + "CF2B5EF8C1EF0201CF895EF601C78B5EF889D93E8A0408C0740326880546"
    Asm$ = Asm$ + "474975F1037EF60376FC4A75E683C4081F5DCA0A00F7D829C37EF201C689"
    Asm$ = Asm$ + "46FC31C0EB93F7D929CA7EE30376FA4975FAEB9381EB4001015EFCBB4001"
    Asm$ = Asm$ + "29C3EB8F01D181E9C80029CA8B4E0AEB8C"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.Sprite%(Size%)

    DEF SEG = VARSEG(Asm.Sprite%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.Sprite%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

'This Draws ;*)

    DEF SEG = VARSEG(Asm.Sprite%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL SPRITESEGMENT%, BYVAL SPRITEOFFSET%, VARPTR(Asm.Sprite%(0)))
    DEF SEG

END SUB

SUB AF.SpriteColor (DestSeg%, X%, Y%, SPRITESEGMENT%, SPRITEOFFSET%, CLR%)
'See AF.Sprite
'Draws the sprites outline on a single color
'Parameter:
'Same as AF.Sprite
'C=Color to plot the outline of the sprite
STATIC Asm.SpriteColor%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B560A8EDA8B56108EC28B76088B1C31C0C1EB038B5402505383C"
    Asm$ = Asm$ + "60452508B460E3D3F017F5E3D00007C618B4E0C81F9C7007F5083F9007C62"
    Asm$ = Asm$ + "01C381FB3F017F6829C301CA81FAC7007F6C29CA895EF886CDBB400189CF2"
    Asm$ = Asm$ + "B5EF8C1EF0201CF895EF601C78B5EF88A660689D93E8A0408C07403268825"
    Asm$ = Asm$ + "46474975F1037EF60376FC4A75E683C4081F5DCA0C00F7D829C37EF201C68"
    Asm$ = Asm$ + "946FC31C0EB90F7D929CA7EE30376FA4975FAEB9081EB4001015EFCBB4001"
    Asm$ = Asm$ + "29C3EB8C01D181E9C80029CA8B4E0CEB89"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.SpriteColor%(Size%)

    DEF SEG = VARSEG(Asm.SpriteColor%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.SpriteColor%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.SpriteColor%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL SPRITESEGMENT%, BYVAL SPRITEOFFSET%, BYVAL CLR%, VARPTR(Asm.SpriteColor%(0)))
    DEF SEG

END SUB

SUB AF.SpriteGamma (DestSeg%, X%, Y%, SPRITESEGMENT%, SPRITEOFFSET%, GAMMADISP%)
'See AF.Sprite
'Draws a "LIGHTENED" or "DARKENED" sprite depending on the GammaDisp
'useful for night and day FX as well as shadows
'Paramenters:(extra)
'GammaDisp: is the light and dark controller
            'Positive(+)=Lightens
            'Negative(-)=Darkens
            'Try values of +6 or -6 for cool fx

STATIC Asm.SpriteGamma%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B560A8EDA8B56108EC28B76088B1C31C0C1EB038B5402505383C"
    Asm$ = Asm$ + "60452508B460E3D3F010F8F85003D00000F8C86008B4E0C81F9C7007F7583"
    Asm$ = Asm$ + "F9000F8C860001C381FB3F010F8F8B0029C301CA81FAC7000F8F8E0029CA8"
    Asm$ = Asm$ + "95EF886CDBB400189CF2B5EF8C1EF0201CF895EF601C731DB8A66068B4EF8"
    Asm$ = Asm$ + "3E8A0408C0742288C3240F28C300E000D838D8770526881DEB0F80C30F38D"
    Asm$ = Asm$ + "8720526881DEB0326880546474975D2037EF60376FC4A75C683C4081F5DCA"
    Asm$ = Asm$ + "0C00F7D829C37EF201C68946FC31C0E96AFFF7D929CA7EE20376FA4975FAE"
    Asm$ = Asm$ + "96BFF81EB4001015EFCBB400129C3E968FF01D181E9C80029CA8B4E0CE966"
    Asm$ = Asm$ + "FF"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.SpriteGamma%(Size%)

    DEF SEG = VARSEG(Asm.SpriteGamma%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.SpriteGamma%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1

END IF

    DEF SEG = VARSEG(Asm.SpriteGamma%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL SPRITESEGMENT%, BYVAL SPRITEOFFSET%, BYVAL GAMMADISP%, VARPTR(Asm.SpriteGamma%(0)))
    DEF SEG

END SUB

SUB AF.SpriteSolid (DestSeg%, X%, Y%, SPRITESEGMENT%, SPRITEOFFSET%)
'AF.SpriteSolid
'Solid Put plots 4 pixels at a time
'Use for speed ;*)
'Parameters: See AF.Sprite

STATIC Asm.SpriteSolid%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B56088EDA8B560E8EC28B76068B1C31C0C1EB038B5402505383C"
    Asm$ = Asm$ + "60452508B460C3D3F017F5B3D00007C5E8B4E0A81F9C7007F4D83F9007C5F"
    Asm$ = Asm$ + "01C381FB3F017F6529C301CA81FAC7007F6929CA895EF886CDBB400189CF2"
    Asm$ = Asm$ + "B5EF8C1EF0201CF895EF601C78B5EF889D8C1E80283E30389C1F366A589D9"
    Asm$ = Asm$ + "F3A4037EF60376FC4A75EE83C4081F5DCA0A00F7D829C37EF201C68946FC3"
    Asm$ = Asm$ + "1C0EB93F7D929CA7EE30376FA4975FAEB9381EB4001015EFCBB400129C3EB"
    Asm$ = Asm$ + "8F01D181E9C80029CA8B4E0AEB8C"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.SpriteSolid%(Size%)

    DEF SEG = VARSEG(Asm.SpriteSolid%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.SpriteSolid%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF


    DEF SEG = VARSEG(Asm.SpriteSolid%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL SPRITESEGMENT%, BYVAL SPRITEOFFSET%, VARPTR(Asm.SpriteSolid%(0)))
    DEF SEG

END SUB

SUB AF.SpriteTrans (DestSeg%, X%, Y%, SPRITESEGMENT%, SPRITEOFFSET%)
'See AF.Sprite
'Draws a sprite translucently!!!

STATIC Asm.SpriteTrans%(), InitDone%

IF InitDone% = 0 THEN
    Asm$ = ""
    Asm$ = Asm$ + "5589E51E8B56088EDA8B560E8EC28B76068B1C31C0C1EB038B5402505383C"
    Asm$ = Asm$ + "60452508B460C3D3F017F753D00007C788B4E0A81F9C7007F6783F9007C7A"
    Asm$ = Asm$ + "01C381FB3F010F8F7F0029C301CA81FAC7000F8F820029CA895EF886CDBB4"
    Asm$ = Asm$ + "00189CF2B5EF8C1EF0201CF895EF601C78B5EF889D93E8A0408C07416240F"
    Asm$ = Asm$ + "268A2580E40F00C4D0EC3E2A04F6D800E026880549464783F90075DB037EF"
    Asm$ = Asm$ + "60376FC4A75D083C4081F5DCA0A00F7D829C37EF201C68946FC31C0E978FF"
    Asm$ = Asm$ + "F7D929CA7EE20376FA4975FAE977FF81EB4001015EFCBB400129C3E974FF0"
    Asm$ = Asm$ + "1D181E9C80029CA8B4E0AE972FF"

    CodeLen% = LEN(Asm$)
    IF (CodeLen% MOD 2) <> 0 THEN CodeLen% = CodeLen% + 1
    Size% = CodeLen% \ 4
    REDIM Asm.SpriteTrans%(Size%)

    DEF SEG = VARSEG(Asm.SpriteTrans%(0))
    FOR I% = 0 TO CodeLen% \ 2
            Byte% = VAL("&H" + MID$(Asm$, (I% * 2) + 1, 2))
            POKE VARPTR(Asm.SpriteTrans%(0)) + I%, Byte%
    NEXT I%
    DEF SEG
    InitDone% = 1
END IF

    DEF SEG = VARSEG(Asm.SpriteTrans%(0))
    CALL ABSOLUTE(BYVAL DestSeg%, BYVAL X%, BYVAL Y%, BYVAL SPRITESEGMENT%, BYVAL SPRITEOFFSET%, VARPTR(Asm.SpriteTrans%(0)))
    DEF SEG

END SUB

SUB Engine.DoControls (Finval) STATIC

'Get the contols using multikey
'Finval is the value to set if we wanted to go out of the loop

IF MULTIKEY(KEYESC) THEN                'Quit
    Finval = TRUE
END IF
IF MULTIKEY(KEYSPACE) THEN              'Toggle WAIT
    VsyncOn = NOT VsyncOn
    WHILE MULTIKEY(KEYSPACE): WEND
END IF
IF MULTIKEY(KEYENTER) THEN              'Toggle StatBar
    StatBarON = NOT StatBarON
    WHILE MULTIKEY(KEYENTER): WEND
END IF
IF MULTIKEY(KEYTAB) THEN                'if Pressed Speed is increased
    Hero.Speed = 2
ELSE
    Hero.Speed = 1
END IF


IF MULTIKEY(KEYUP) THEN   'Pressed UP
        Hero.Direction = DU             'Direction=Up
        Hero.Yv = -Hero.Speed           'Add -Yv to go up
        Hero.Xv = 0                     'Vertical direction so 0
        Engine.MovePlayer Hero          'Update Player position
END IF
IF MULTIKEY(KEYRIGHT) THEN
        Hero.Direction = DR             'Direction=DOWN
        Hero.Xv = Hero.Speed            'Add +XV to go right
        Hero.Yv = 0                     'Horizontal so 0
        Engine.MovePlayer Hero          'Update Player position
END IF

IF MULTIKEY(KEYDOWN) THEN
        Hero.Direction = DD             'Ditto
        Hero.Yv = Hero.Speed
        Hero.Xv = 0
        Engine.MovePlayer Hero
END IF
IF MULTIKEY(KEYLEFT) THEN
        Hero.Direction = DL             'Ditto
        Hero.Xv = -Hero.Speed
        Hero.Yv = 0
        Engine.MovePlayer Hero
END IF


END SUB

SUB Engine.DrawMap STATIC

'Notes:
'1.Mod our Cam with 16 to get correct offset inside the tile
'2.Uses the constants TileH,TileW,ScrnTileXmax,ScrnTileYmax
'3.Constants are declared at the module level
'4.BaseL should be drawn with AF.SpriteSolid since its faster(4 pixels drawn at a time)
'5.LAYER is the segment we are drawing to prevent flicker.

'==========BaseLayer====================
'Formula for X.(the loop below)
'(X*TileW)=Video Screen Coord(0 to 320 Step 16)
'(X*TileW)-Level.Xpos=TileOffset that we have to show from 0 to 16-Xpos
'Assuming Level.Xpos=4
'So if X*TileW=0 then (X*TileW)-Level.Xpos=-4
'We start Drawing from -4 to -4+16
'ie,-4 to 12 then the next tile is 13 to 13+16
'Hope you understand

'Draw our Screen(No need to clear our Page)
'Baselayer
FOR Y = 0 TO ScrnTileYmax + 1     '14 tiles add 1 to prevent bad looking bottom
FOR X = 0 TO ScrnTileXmax         '21 tiles since we count 0
        Tx = X + Level.TileX
        Ty = Y + Level.TileY
        IF Tx > MapXmax THEN Tx = MapXmax       'Limit if over the dimensions
        IF Ty > MapYmax THEN Ty = MapYmax       'of the map
        Tile = Map(Tx, Ty).BaseL                'Get Tilenumber
        IF Tile > 0 THEN                        'of there is a tile draw it.
                ScreenX = (X * TileW) - Level.Xpos      'Calc where to put a
                ScreenY = (Y * TileH) - Level.Ypos      'particular tile
                AF.SpriteSolid LAYER, ScreenX, ScreenY, VARSEG(Tile(1)), VARPTR(Tile(TileIndex(Tile)))
        END IF
NEXT X
NEXT Y

END SUB

SUB Engine.DrawPlayer (Player AS SpriteType) STATIC

'Notes:
'1. Uses the Directional Constants defined at module level(DN,DR...)

'This Stops the Player from Swaying his arms very fast
'DirChanged=Is just a flag to prevent Electric legs effect and to see if
'Player changed direction

IF Player.Direction <> Player.oldDir THEN      'if Player changes direction
        Player.DirChanged = 1                  'Flag it to change BaseFrame
ELSE
        'Delays frame rotation for sprite(Electric legs :))
        Player.DirChanged = (Player.DirChanged AND 7) + 1       'Try to REM this :)
END IF

IF Player.DirChanged = 1 THEN
    IF Player.Move THEN
        Player.Frame = (Player.Frame MOD Player.NumFrame) + 1       'Frame=Current frame(1 to 3) the
                                        'Player sprite is
                                        'Frame is Added to baseFrame to locate
                                        'the True Sprite Offset
                                        'See PP256

        SELECT CASE Player.Direction
                CASE DR
                        'Calculate the Frame of the sprite to draw
                        Player.Frame = Player.Frame + 8        'Base Frame=8
                CASE DU
                        Player.Frame = Player.Frame + 12        'Base Frame=12
                CASE DL
                        Player.Frame = Player.Frame + 4        'Base Frame=4
                CASE DD
                        Player.Frame = Player.Frame            'Base Frame=1
                CASE ELSE
        END SELECT

        Player.Move = FALSE             'Stops the Player from Swaying
                                        'his arms while not moving
    ELSE                                'if the hero ain't movin'

        SELECT CASE Player.Direction
                CASE DR
                        'Calculate the Frame of the sprite to draw
                        Player.Frame = 8 + 4
                CASE DU
                        Player.Frame = 12 + 4
                CASE DL
                        Player.Frame = 4 + 4
                CASE DD
                        Player.Frame = 4
                CASE ELSE
        END SELECT

    END IF

END IF

'Formula: X(same goes for Y)
'Player.X-Level.CamX
'just puts the player at the Center of screen
'So if Player.X=500 then CamX=Player.X-ScrnYmid(ScrnYmid=Middle of 320=160)
'CamX:500-160=340
'Player.X=500
'Xcenter:500-340=160(ScrnXmid)
'Same goes for Y
'See Engine.UpdateCamera for more Details :)
'Sprite(SpriteIndex(Sprite.Frame) is the current frame of the Sprite(calculated above)
'Notes:
'1.Sprite(SpriteIndex(Sprite.Frame))=Real offset of the frame(NO ERRORS)
'2.SpriteIndex(Sprite.Frame)=Index of the real offset of the frame(ERRORS)

IF Player.Frame <> 0 THEN               'Just to be sure to prevent errors since PP256 starts at 1
        AF.Sprite LAYER, (Player.X - Level.CamX), (Player.Y - Level.CamY), VARSEG(HeroSpr(1)), VARPTR(HeroSpr(HeroSprIndex(Player.Frame)))
END IF

Player.oldDir = Player.Direction      'Save our Direction for checking above
                                      'OldDir is saved since we have declared
                                      'this SUB  as STATIC

END SUB

SUB Engine.DrawScreen STATIC
'Draw our map and player to screen

Engine.DrawMap          'Draw our map to Vpage()
Engine.DrawPlayer Hero  'Draw our Player to Vpage()

IF StatBarON THEN           'Draw Statusbar of on
    Engine.DrawStatBar
END IF

IF VsyncOn THEN             'doh?!
    WAIT &H3DA, 8  'Wait for retrace. REM this for Lightning Speed ;)
END IF

AF.Pcopy VIDEO, LAYER        'Display it to screen(VIDEO)


END SUB

SUB Engine.DrawStatBar
STATIC FPS, FPS2, StartTime&

'Calc FPS
FPS = FPS + 1
IF StartTime& + 1 < TIMER THEN
 FPS2 = FPS
 FPS = 0
 StartTime& = TIMER
END IF


'Top Statbar
'Draw some TranslucentBoxes
AF.BoxTransF LAYER, 0, 0, 319, 50, 38
AF.Box LAYER, 0, 0, 319, 50, 27
AF.Box LAYER, 1, 1, 319 - 1, 50 - 1, 31
AF.Box LAYER, 2, 2, 319 - 2, 50 - 2, 27

'Temp status check(Draw our Status for debugging purposes) ;)
AF.Font256 LAYER, 5, 5, "Hero TileX=" + STR$(Hero.TileX), 0, Font(), FontIndex()
AF.Font256 LAYER, 5, 15, "Hero TileY=" + STR$(Hero.TileY), 0, Font(), FontIndex()
AF.Font256 LAYER, 5, 25, "Tile Under=" + STR$(Map(Hero.TileX, Hero.TileY).BaseL), 0, Font(), FontIndex()
AF.Font256 LAYER, 5, 35, "Frame=" + STR$(Hero.Frame), 0, Font(), FontIndex()

AF.Font256 LAYER, 110, 5, "Level TileX=" + STR$(Hero.TileX), 0, Font(), FontIndex()
AF.Font256 LAYER, 110, 15, "Level TileY=" + STR$(Level.TileY), 0, Font(), FontIndex()
AF.Font256 LAYER, 110, 25, "FPS=" + STR$(FPS2), 0, Font(), FontIndex()
AF.Font256 LAYER, 110, 35, "VsyncON=" + STR$(VsyncOn), 0, Font(), FontIndex()

AF.Font256 LAYER, 220, 5, "<Esc>: Exit", 0, Font(), FontIndex()
AF.Font256 LAYER, 220, 15, "<Space>: Vsync", 0, Font(), FontIndex()
AF.Font256 LAYER, 220, 25, "<Enter>: Statbar", 0, Font(), FontIndex()
AF.Font256 LAYER, 220, 35, "<Tab>: Run", 0, Font(), FontIndex()


'Bottom Statbar
'Draw some TranslucentBoxes
AF.BoxTransF LAYER, 0, 160, 319, 199, 138
AF.Box LAYER, 0, 160, 319, 199, 154
AF.Box LAYER, 1, 161, 319 - 1, 199 - 1, 159
AF.Box LAYER, 2, 162, 319 - 2, 199 - 2, 154

AF.Font256 LAYER, 5, 163, "zelda scrolling tut", 0, Font(), FontIndex()
AF.Font256 LAYER, 5, 171, "coding: relsoft", 0, Font(), FontIndex()
AF.Font256 LAYER, 5, 179, "graphics: l_o_j", 0, Font(), FontIndex()
AF.Font256 LAYER, 5, 187, "fonts: adigun a. polack", 0, Font(), FontIndex()

AF.Font256 LAYER, 150, 163, "email: vic_viperph@yahoo.com", 0, Font(), FontIndex()
AF.Font256 LAYER, 150, 171, "http://relsoft.ath.cx", 0, Font(), FontIndex()
AF.Font256 LAYER, 150, 179, "http://auraflow.curvehead.com", 0, Font(), FontIndex()
AF.Font256 LAYER, 150, 187, "http://polacka.xepher.net", 0, Font(), FontIndex()


END SUB

SUB Engine.InitHero (NewObject AS SpriteType)

'Initializes the hero's attributes(characteristics)

NewObject.id = 1
NewObject.X = 18 * TileW                'Start from 18 tiles right
NewObject.Y = 15 * TileH                '15 tiles down
NewObject.oldX = 18 * TileW
NewObject.oldY = 15 * TileH
NewObject.Xv = 0
NewObject.Yv = 0
NewObject.Active = TRUE
NewObject.Frame = 1
NewObject.MinFrame = 1                  'Looking down
NewObject.NumFrame = 4                  'number of frames per face
NewObject.Move = TRUE
NewObject.Counter = 0
NewObject.Direction = DD
NewObject.TileX = NewObject.X \ TileW       'Calculate TileX
NewObject.TileY = NewObject.Y \ TileH
NewObject.Collide = FALSE
NewObject.Speed = 1                     'Set speed to 1

END SUB

SUB Engine.InitLevel

Level.Xmax = MapXmax            'Load max values
Level.Ymax = MapYmax
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

END SUB

SUB Engine.InitVars
VsyncOn = FALSE         'WAIT off
StatBarON = TRUE        'Status bar ON
END SUB

SUB Engine.LoadDATA

'Load data from DATA statements

RESTORE FJPALDATA                       'Set up Pal
AF.LoadPalPp256 ""

RESTORE HERODATA                        'Read PP256's documentation
InitImageData "", HeroSpr()
MakeImageIndex HeroSpr(), HeroSprIndex()

RESTORE TILEDATA
InitImageData "", Tile()
MakeImageIndex Tile(), TileIndex()


RESTORE FONTDATA
InitImageData "", Font()
MakeImageIndex Font(), FontIndex()

END SUB

SUB Engine.LoadMap STATIC

RESTORE BASEMAPDATA         'Read from Data label BASEmapDATA

FOR Y = 0 TO MapYmax
FOR X = 0 TO MapXmax
        READ Tile
        Map(X, Y).BaseL = Tile      'If you don't understand this.....
NEXT X
NEXT Y

END SUB

SUB Engine.Main STATIC

Finished = FALSE        'For our loop
Dummy = MULTIKEY(-1)    'Install MULTIKEY Keyboard handler

DO
    Engine.UpdateCamera Level, Hero 'Update camera position
    Engine.DrawScreen               'Draw Our  Screen to page and
                                    'Copy it to VIDEO
    Engine.DoControls Finished      'Control the player via multikey

LOOP UNTIL Finished

Dummy = MULTIKEY(-2)        'Remove the Keyboard handler


END SUB

SUB Engine.MovePlayer (Player AS SpriteType) STATIC

'Updates the players position according to its direction
'ZELDA style Pixel*Pixel free movement
'Sample Code:
'CODE: Player.X = Player.X + Player.XV
        'Add Xspeed to Player X position
        '(-)=LEFT, (+)=Right
        'Same for Y
'CODE: IF Player.X > (Level.Xmax * TileW)  THEN Player.X = (Level.Xmax * TileW)
        'Checks if player is outside of World map boudaries
        '(Level.Xmax * TileW) - TileW=(36*16)-16

'Save old player values as this is used for "Snapping" back to
'its original position if we collided with a tile.

Player.oldX = Player.X
Player.oldY = Player.Y


'***Move the player Horizontaly
'***and limit the position if its out of bounds
Player.X = Player.X + Player.Xv
IF Player.X < ScrnXmin THEN Player.X = ScrnXmin
IF Player.X > (Level.Xmax * TileW) THEN Player.X = (Level.Xmax * TileW)

'***Move the player vertically
'***and limit the position if its out of bounds
Player.Y = Player.Y + Player.Yv
IF Player.Y < ScrnYmin THEN Player.Y = ScrnYmin
IF Player.Y > (Level.Ymax * TileH) THEN Player.Y = (Level.Ymax * TileH)

'Update the player moveFlag to animate the player(REM this for no Animation)
Player.Move = TRUE

'Return Player last pos if collided with collidable tiles
IF Engine.TileCollide(Player) THEN
        Player.X = Player.oldX
        Player.Y = Player.oldY
END IF

'Calculate what Tile the player is
'Add 8 to X and Y to get center of Player since size is 16*16
Player.TileX = (Player.X + 8) \ TileW    'Center of Sprite
Player.TileY = (Player.Y + 8) \ TileH

END SUB

FUNCTION Engine.TileCollide (Player AS SpriteType) STATIC
'Crappy tile*tile collision detection ;)
'Returns TRUE if collision is detected, FALSE if not
'I didn't include a Pixel*pixel colision detection so as not to be confusing
'AF.Lib has a Pixel*pixel collision detection so don't worry ;)

'Init the function to be FALSE(no collision)
Engine.TileCollide = FALSE


'4 checks are done to be sure ;)
'Up-Left corner of hero
X = Player.X + 10        'Add 1 for 15*15 Box Collision
Y = Player.Y + 8
GOSUB CheckForTile      'check for the tile

'Up-Right corner of hero
X = Player.X + 10
Y = Player.Y + 8
GOSUB CheckForTile

'Down-Right corner of hero
X = Player.X + 10
Y = Player.Y + 15
GOSUB CheckForTile

'Down-Left corner of hero
X = Player.X + 5
Y = Player.Y + 15
GOSUB CheckForTile


EXIT FUNCTION

'Check for collision:(Bounding BoxType)
CheckForTile:
Tx = X \ TileW          'Player.X\TileW=TileX
Ty = Y \ TileH          'Player.Y\TileH=TileH

'Check the HI and LOW byte of our fringe layer
'0=No collision,else= collision

IF Map(Tx, Ty).BaseL > 1 THEN
                Engine.TileCollide = TRUE
                EXIT FUNCTION
END IF

RETURN          'Check for next Coord


END FUNCTION

SUB Engine.UpdateCamera (Level AS LevelType, Player AS SpriteType) STATIC

'Updates CAMX,CAMY in relation to Player.X,Player.Y to achieve
'ZELDA style scrolling engine.
'Sample Code:
'CODE: CASE DR
        'Right Direction of movement
'CODE: Level.CamX = Player.X - ScrnXmid
        'Center our player to the screen and Moves the camera to where
        'the player is going
        'ie, Assume: Player.X=1200,ScrnMid=Constant 160(Middle screen)
        'Level.CamX:1200-160=1040
        'to get the TileX:
        'TileX=Level.CamX\TileW=1040\16=65(This will be used with Engine.DrawMap)
'CODE: IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
        'Check if level.CamX<0, Zero it if its negative to prevent errors
        'ScrnYmin=0(Constant)
'CODE: IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        'Check if Level.CamX > (Level.Xmax * TileW) - ScrnXmax
        '(Level.Xmax * TileW) - ScrnXmax=Maximum number of PIXELS the Map has
        'Level.Xmax=Max num of tile for map(Shared Variable Level.Element)
        'TileW=Width of tile(Constant)
        'ScrnXmax=320(Constant)
        'To calculate: Level.Xmax=MapXmax
        'Formula:(Level.Xmax * TileW) - ScrnXmax
        'Level.Xmax=36
        '(36*16)-320=256
        'Level.CamX=256
        'To calculate TileX:
        'Level.CamX\TileW
        '256\16=16
        'TileX=16(Start Drawing from 16 to 36)
        '16 is the first tile to draw in X
        '36-16=20(See we have to draw 20 tiles horizontally!!!)
        'Same goes for Y
        'See Engine.DrawMap SUB for more details. ;)

'*** Update the camera
Level.CamX = Player.X - ScrnXmid

'***Limit if out of bounds
IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
IF Level.CamX > ((Level.Xmax + 1) * TileW) - ScrnXmax THEN Level.CamX = ((Level.Xmax + 1) * TileW) - ScrnXmax

Level.CamY = Player.Y - ScrnYmid

IF Level.CamY < ScrnYmin THEN Level.CamY = ScrnYmin
IF Level.CamY > ((Level.Ymax + 1) * TileH) - ScrnYmax THEN Level.CamY = ((Level.Ymax + 1) * TileH) - ScrnYmax

'Calculate the first tile to draw
Level.TileX = Level.CamX \ TileW        'First tile to draw
Level.TileY = Level.CamY \ TileH
                             
'Get the offset inside the tile use AND if its a pow of 2 tilesize
Level.Xpos = Level.CamX MOD TileW            'Position in the Tile(0 to 15)
Level.Ypos = Level.CamY MOD TileH            '16*16 tile size(change to fit your needs)


END SUB

SUB InitImageData (FileName$, ImageArray())

    IF FileName$ <> "" THEN
        '***** Read image data from file *****

        'Establish size of integer array required.
        FileNo = FREEFILE
        OPEN FileName$ FOR BINARY AS #FileNo
        Ints = (LOF(FileNo) - 7) \ 2
        CLOSE #FileNo
        REDIM ImageArray(1 TO Ints)

        'Load image data directly into array memory.
        DEF SEG = VARSEG(ImageArray(1))
        BLOAD FileName$, 0
        DEF SEG
    ELSE
        '***** Read image data from DATA statements *****

        'Establish size of integer array required.
        READ IntCount
        REDIM ImageArray(1 TO IntCount)

        'READ image DATA into array.
        FOR n = 1 TO IntCount
            READ X
            ImageArray(n) = X
        NEXT n
    END IF

END SUB

SUB MakeImageIndex (ImageArray(), IndexArray())

    'The index will initially be built in a temporary array, allowing
    'for the maximum 1000 images per file.
    DIM Temp(1 TO 1000)
    ptr& = 1: IndexNo = 1: LastInt = UBOUND(ImageArray)
    DO
        Temp(IndexNo) = ptr&
        IndexNo = IndexNo + 1

        'Evaluate descriptor of currently referenced image to
        'calculate the beginning of the next image.
        X& = (ImageArray(ptr&) \ 8) * (ImageArray(ptr& + 1)) + 4
        IF X& MOD 2 THEN X& = X& + 1
        ptr& = ptr& + (X& \ 2)
    LOOP WHILE ptr& < LastInt

    LastImage = IndexNo - 1

    'Copy the image index values into the actual index array.
    REDIM IndexArray(1 TO LastImage)
    FOR n = 1 TO LastImage
        IndexArray(n) = Temp(n)
    NEXT n

END SUB

FUNCTION MULTIKEY (t)

STATIC kbcontrol%(), kbmatrix%(), Firsttime, StatusFlag

IF Firsttime = 0 THEN          'Initalize
 DIM kbcontrol%(128)
 DIM kbmatrix%(128)
 code$ = ""
 code$ = code$ + "E91D00E93C00000000000000000000000000000000000000000000000000"
 code$ = code$ + "00001E31C08ED8BE24000E07BF1400FCA5A58CC38EC0BF2400B85600FAAB"
 code$ = code$ + "89D8ABFB1FCB1E31C08EC0BF2400BE14000E1FFCFAA5A5FB1FCBFB9C5053"
 code$ = code$ + "51521E560657E460B401A8807404B400247FD0E088C3B700B0002E031E12"
 code$ = code$ + "002E8E1E100086E08907E4610C82E661247FE661B020E6205F075E1F5A59"
 code$ = code$ + "5B589DCF"
 DEF SEG = VARSEG(kbcontrol%(0))
 FOR I% = 0 TO 155                     ' Load ASM
     d% = VAL("&h" + MID$(code$, (I% * 2) + 1, 2))
     POKE VARPTR(kbcontrol%(0)) + I%, d%
 NEXT I%
 I& = 16       ' I think this stuff connects the interrupt with kbmatrix%()
 n& = VARSEG(kbmatrix%(0)): l& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE I&, l&: POKE I& + 1, h&: I& = I& + 2
 n& = VARPTR(kbmatrix%(0)): l& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE I&, l&: POKE I& + 1, h&: I& = I& + 2
 DEF SEG
 Firsttime = 1
END IF

SELECT CASE t
 CASE -1
  IF StatusFlag = 0 THEN
   DEF SEG = VARSEG(kbcontrol%(0))
   CALL ABSOLUTE(0)                     ' Run interrupt
   DEF SEG
   StatusFlag = 1
  END IF
 CASE -2
  IF StatusFlag = 1 THEN
   DEF SEG = VARSEG(kbcontrol%(0))      ' Turn off interrupt
   CALL ABSOLUTE(3)
   DEF SEG
   StatusFlag = 0
  END IF
 CASE 1 TO 128
  MULTIKEY = kbmatrix%(t)               ' Return status
 CASE ELSE
  MULTIKEY = 0                          ' User Supidity Error
END SELECT


END FUNCTION

