'JPEG VIEWER 4.1  by Antoni Gual    agual@eic.ictnet.es
'----------------------------------------------------------------------------
DECLARE SUB SVGAPRINT (t$, xstartpos%, ystartpos%, scrxsize%, scrysize%, chspacing%, font%)
DECLARE SUB SVGAGetModeInfo (md&)
DECLARE FUNCTION SVGASelectMode% ()
DECLARE SUB SVGAGetData ()
DECLARE FUNCTION SVGAsetmode% (mode%)

DECLARE SUB DetectWinTemp ()
DECLARE FUNCTION getcurdir$ (save%)
DECLARE FUNCTION DiskReady% (d$)
DECLARE FUNCTION SelectAFile$ (header$, ext$)
DECLARE SUB menu ()

DECLARE SUB JPEGViewParms ()
DECLARE SUB JPEGGetParms (jfile%)
DECLARE SUB JPEGGet8x8 (vector%(), comp%, dcCoef%)
DECLARE FUNCTION jpeggetbyte% ()
DECLARE FUNCTION JPEGPut% (jfile%, x0%, y0%)

'interrupt calls  (no interrupt=no SVGA)
TYPE regtypeX
   ax    AS INTEGER
   bx    AS INTEGER
   cx    AS INTEGER
   dx    AS INTEGER
   bp    AS INTEGER
   SI    AS INTEGER
   DI    AS INTEGER
   flags AS INTEGER
   DS    AS INTEGER
   es    AS INTEGER
END TYPE

DECLARE SUB INTERRUPTy (intnum AS INTEGER, REG AS regtypeX)


'.............................................................................

DEFINT A-Z
CONST TOTALBUF = 2000
CONST dc = 0, AC = 1
CONST false = 0, true = NOT false
CONST white = &HFFFFFF
CONST SVGABSaveIdent = "AGV"
CONST palsize = 256 * 3


'this header is used by the bload-bsave routines

'there we save the present SVGA mode parameters we need
TYPE vesainfoblock
 VESASignature       AS STRING * 4
 VESAVersion         AS INTEGER
 OEMStringPtr        AS LONG
 Capabilities        AS STRING * 4
 VIDEOMODEPTR        AS INTEGER
 VIDEOMODESEG        AS INTEGER
 totalmemory         AS INTEGER
 Reserved            AS STRING * 236
'we manage this  part
 modenum             AS INTEGER
 modemax             AS INTEGER
 bytespixel          AS INTEGER
 xres                AS INTEGER
 yres                AS INTEGER
 BYTESROW            AS LONG
 bpp                 AS INTEGER
 winsize             AS LONG
 winseg              AS INTEGER
 numberofbanks       AS INTEGER
 bw                  AS INTEGER
 charx               AS INTEGER
 chary               AS INTEGER
 WINMASK             AS LONG
END TYPE

'this is the standard SVGA Info block returned by interrupt calls
TYPE vesaModeinfoBlock
 Modeattributes      AS INTEGER
 WinAAttributes      AS STRING * 1
 WinBAttributes      AS STRING * 1
 WinGranularity      AS INTEGER
 winsize             AS INTEGER
 winAsegment         AS INTEGER
 WinBSegment         AS INTEGER
 WinFuncPtr          AS LONG
 bytesperscanline    AS INTEGER
 xres                AS INTEGER
 yres                AS INTEGER
 XCharSize           AS STRING * 1
 YCharSize           AS STRING * 1
 NumberOfPlanes      AS STRING * 1
 bpp                 AS STRING * 1
 numberofbanks       AS STRING * 1
 MemoryModel         AS STRING * 1
 BankSize            AS STRING * 1
 numpages            AS STRING * 1
 Rsvd                AS STRING * 1
 RedMaskSize         AS STRING * 1
 RedFieldPosition    AS STRING * 1
 GreenMaskSize       AS STRING * 1
 GreenFieldPosition  AS STRING * 1
 BlueMaskSize        AS STRING * 1
 BlueFieldPosition   AS STRING * 1
 RsvdMaskSize        AS STRING * 1
 DirectColorModeInfo AS STRING * 1
 Reserved            AS STRING * 216
END TYPE

'this to store  the JPEG images parmeters
TYPE JpegType
  jfifmajor     AS STRING * 1
  jfifMinor     AS STRING * 1
  densunits     AS STRING * 1   'density units and values (not used)
  Xdens         AS INTEGER
  ydens         AS INTEGER
  ThWidth       AS STRING * 1   'thumbnail size
  Theigth       AS STRING * 1
  rows          AS INTEGER      'jpeg height
  cols          AS INTEGER      'jpeg width
  samplesy      AS INTEGER      'sampling ratios
  samplescbcr   AS INTEGER
  qty           AS INTEGER      'number of quantization tables
  qtcbr         AS INTEGER
  HDCTY         AS INTEGER      'number of huffman tables (DC and AC)
  HDCTCBR       AS INTEGER
  HaCTY         AS INTEGER
  HaCTcbr       AS INTEGER
  numcomp       AS INTEGER      'number of components
  restart       AS INTEGER      'blocks between restart marks
  size          AS LONG         'FILE SIZE
  IMAGESTART    AS LONG         'NOT USED
END TYPE

'table used to store the Huffman tree values
TYPE Huffmanentry               'a type for huffman tables
  index         AS LONG
  code          AS INTEGER
  size          AS INTEGER
END TYPE

TYPE Huffmantreeentry               'a type for huffman tables
  code          AS INTEGER
  is1          AS INTEGER
  is0          AS INTEGER
END TYPE


'lookup to store the zig-zag indexs of the JPEG
TYPE zigzagtype
 xp             AS INTEGER
 yp             AS INTEGER
END TYPE

'used by the file menu to store the file selector windows parameters
TYPE menutype
 top     AS INTEGER
 heigth  AS INTEGER
 left    AS INTEGER
 wdth    AS INTEGER
 typ     AS INTEGER
 curs    AS INTEGER
 count   AS INTEGER
 tline   AS INTEGER
 file    AS INTEGER
END TYPE

'ffix

'a few shared variables
'simple vars
DIM win, jfile, temppath$
DIM viw AS INTEGER
DIM buf$, bufptr AS LONG, endptr AS LONG, find$: find$ = CHR$(255) + CHR$(0)
DIM buf2ptr AS INTEGER
DIM curbank AS INTEGER, lasty AS INTEGER
DIM time!, bltime!
DIM nofast
DIM SHARED mcu

'UDT
DIM vesainfo  AS vesainfoblock
DIM display AS vesaModeinfoBlock
DIM regs  AS regtypeX
DIM jpeg AS JpegType

'JPEG tables
REDIM quant(0, 0, 0)
DIM Hufftree(1024) AS Huffmantreeentry
DIM huffstart(8)

'lookup tables to speed up things
'JPEG decoding
DIM SHARED zz(0 TO 63) AS zigzagtype
RESTORE zig2: FOR i = 0 TO 63: READ zz(i).xp, zz(i).yp: NEXT

'SVGA routines
DIM rlook(255), glook(255), g2look(255), blook(255)
DIM xoff(2400), yseg(1600), ybank(1600)

'converts unsigned word stored in a long to an integer
DEF fnuns2int% (u&)
  IF u& > 32767 THEN fnuns2int% = u& - 65536 ELSE fnuns2int% = u&
END DEF

'bit tables
DIM PwrsOf2(-1 TO 31) AS LONG
DIM bit3(-1 TO 15)  AS INTEGER
DIM bit4(0 TO 15) AS INTEGER, bit1(-1 TO 15) AS INTEGER
FOR i = -1 TO 30:
    TEMP& = 2& ^ i: PwrsOf2(i) = TEMP&
    IF i < 16 THEN
         bit3(i) = fnuns2int%(TEMP& - 1)
         bit1(i) = fnuns2int%(-(TEMP& - 1))
         IF i < 15 THEN bit4(i + 1) = fnuns2int%(TEMP&)
    END IF
    
    'PRINT : PRINT HEX$(pwrsof2(i)), HEX$(BIT1(i));
NEXT
PwrsOf2(31) = &H80000000


'used to convert from Y-CB-CV to RGB

CONST limrgb = 250
CONST lim2rgb = -limrgb

DIM rcrv(lim2rgb TO limrgb)
TEMP% = CINT(1.402 * 128)
FOR i% = lim2rgb TO limrgb: rcrv(i%) = CINT(1.402 * (i%))
IF ABS(i%) > 128 THEN rcrv(i%) = TEMP% * SGN(rcrv%(i%))
NEXT
DIM gcbv(lim2rgb TO limrgb)
TEMP% = CINT(-3.4414 * 128)
FOR i% = lim2rgb TO limrgb: gcbv(i%) = CINT(-.34414 * (i%))
IF ABS(i%) > 128 THEN gcbv(i%) = TEMP% * SGN(gcbv%(i%))
NEXT
DIM gcrv(lim2rgb TO limrgb)
TEMP% = CINT(-.71414 * 128)
FOR i% = lim2rgb TO limrgb: gcrv(i%) = CINT(-.71414 * (i%))
IF ABS(i%) > 128 THEN gcrv(i%) = TEMP% * SGN(gcrv%(i%))
NEXT
DIM bcbv(lim2rgb TO limrgb)
FOR i% = lim2rgb TO limrgb: bcbv(i%) = CINT(1.772 * (i%))
IF ABS(i%) > 128 THEN bcbv(i%) = TEMP% * SGN(bcbv%(i%))
NEXT


'prints bin value
DEF fnb$ (v&)
    a$ = SPACE$(32)
    FOR i% = 1 TO 32
        IF (PwrsOf2(32 - i%) AND v&) THEN
            MID$(a$, i%, 1) = "1"
        ELSE
            MID$(a$, i%, 1) = "0"
        END IF
    NEXT
    fnb$ = a$: a$ = ""
END DEF


'start

DetectWinTemp
nofast = -1
SCREEN 0: CLS
SVGAGetData
dummy$ = getcurdir(1)
bs$ = temppath$ + "jpeg.bsav"
a = SVGAsetmode(&H101)
GOSUB SelectAFile
IF f$ = "" OR f$ = CHR$(27) THEN GOTO ending
'--------- Main Loop (Menu) ----------
DO
     a = SVGAsetmode(3)
     
     JPEGViewParms
menus:
     menu
     WHILE LEN(r$) = 0: r$ = INKEY$: WEND
    
     SELECT CASE UCASE$(r$)
     CASE "F"
         GOSUB SelectAFile
         IF f$ = "" OR f$ = CHR$(27) THEN EXIT DO
    
     CASE "V"
         OPEN f$ FOR BINARY AS #jfile
         endptr = TOTALBUF: buf$ = SPACE$(endptr): bufptr = endptr + 1
         JPEGGetParms jfile
         IF vesainfo.modenum THEN
             'next line is the only way i've found to quit svga back to 50 lines mode
             a = SVGAsetmode(3)
         END IF
         
         IF vesainfo.bytespixel <> 1 THEN
                IF jpeg.numcomp = 1 THEN r$ = "M": CLOSE jfile: GOTO continue
         END IF
         a = SVGAsetmode(vesainfo.modenum)
         curbank = -1: lasty = -1
         y0 = ((vesainfo.yres - jpeg.rows) \ 2) AND &HFFF0
         x0 = ((vesainfo.xres - jpeg.cols) \ 2) AND &HFFF0
         IF y0 < 0 THEN
             yy = 0'vesainfo.chary + 0
             SVGAPRINT "The centered image is bigger than the screen", 0, yy, vesainfo.charx, vesainfo.chary, 2, 3
             yy = yy + vesainfo.chary + 2
             SVGAPRINT "and JPEGs must be decoded from the beggining", 0, yy, vesainfo.charx, vesainfo.chary, 2, 3
             yy = yy + vesainfo.chary + 2
             SVGAPRINT "Please wait until image shows or press ESC.", 0, yy, vesainfo.charx, vesainfo.chary, 2, 3
         END IF
         lasty = 4000
         time! = TIMER: DO: LOOP UNTIL time! <> TIMER: time! = TIMER
         buf2ptr = 0
         escaped = JPEGPut(jfile, x0, y0)
         CLOSE #jfile
         time! = TIMER - time!
         r$ = ""
         IF NOT escaped THEN WHILE LEN(r$) = 0: r$ = INKEY$: WEND
       
     CASE "M"
         fail = SVGASelectMode
         r$ = "V"
     CASE "A"
         nofast = NOT nofast
         r$ = ""
     CASE "X"
         EXIT DO
     CASE ELSE
         r$ = ""
     END SELECT
continue:
LOOP
ending:
a = SVGAsetmode(3)
ERASE xoff, yseg, ybank
dummy$ = getcurdir(0)
LOCATE 12, 1
PRINT " Thank you for trying JPEG VIEWER Beta by Antoni Gual (agual@eic.ictnet.es)"
DO: LOOP UNTIL LEN(INKEY$)
END


SelectAFile:
     a = SVGAsetmode(3)
     f$ = SelectAFile("Select a JPEG file to view", "jpg")
     IF f$ = "" THEN RETURN
     jfile = FREEFILE
     OPEN f$ FOR BINARY AS #jfile
     endptr = TOTALBUF: buf$ = SPACE$(endptr): bufptr = endptr + 1
     JPEGGetParms jfile
     CLOSE #jfile
     r$ = "V"
RETURN

'--------- End of Program----------

'error handlers

diskreadyerror: errata% = ERR: RESUME NEXT


anyerror: a = SVGAsetmode(3): CLOSE : RESUME

JPEGGetErrors:
  a = SVGAsetmode(3)
  CLOSE
  SELECT CASE ERR
  CASE 99: PRINT "Not a Valid JPEG/JFIF file"
  CASE 100: PRINT "Only 8x8 samples supported"
  CASE 101: PRINT "Arithmetic coding not supported"
  CASE 102: PRINT "End of jpeg Found"
  CASE 103: PRINT "Error Getting SoS marker"
  CASE 104: PRINT "File format not supported"
  CASE 105: PRINT "16 bits Quantization tables not supported"
  CASE 106: PRINT "Not a JFIF format"
  CASE ELSE: PRINT "Error "; ERR; "While getting JPEG parameters"
  END SELECT
END
  

'------------data------------------


zig2:  'Zigzag patterns for reordering quantization tables and vectors
DATA 0,0
DATA 0,1,1,0
DATA 2,0,1,1,0,2
DATA 0,3,1,2,2,1,3,0
DATA 4,0,3,1,2,2,1,3,0,4
DATA 0,5,1,4,2,3,3,2,4,1,5,0
DATA 6,0,5,1,4,2,3,3,2,4,1,5,0,6
DATA 0,7,1,6,2,5,3,4,4,3,5,2,6,1,7,0
DATA 7,1,6,2,5,3,4,4,3,5,2,6,1,7
DATA 2,7,3,6,4,5,5,4,6,3,7,2
DATA 7,3,6,4,5,5,4,6,3,7
DATA 4,7,5,6,6,5,7,4
DATA 7,5,6,6,5,7
DATA 6,7,7,6
DATA 7,7

SUB DetectWinTemp
'detect Windows 95 and the temp path, setting global variables
'used by  all routines based in SHELL commands, p.e. the file selector
'or the current dir saver

'find temp path
SHARED win, temppath$
    temppath$ = ENVIRON$("TEMP") + "\"
    IF temppath$ = "\" THEN
        PRINT "Some routines in this program require the TEMP environment variable to be set"
        PRINT "Can't continue.Please set TEMP variable to some existing directory"
        END
    END IF

    'detect windows 95 & 98
    tempfile$ = temppath$ + "detwin.txt"
    doscmd$ = "ver >" + tempfile$
    SHELL doscmd$
    f1 = FREEFILE: OPEN tempfile$ FOR INPUT AS #f1:
    win = 0
    WHILE NOT EOF(f1) AND win = 0
        LINE INPUT #f1, a$
        IF INSTR(a$, "Windows") THEN win = -1
    WEND
    CLOSE f1
    KILL tempfile$
END SUB

FUNCTION DiskReady% (d$)
'
'Nearly Self-contained drive check routine
' Use as you want, only give me credit
'
'returns:   0 if drive exists and it's ready
'           1 if drive is not ready
'           2 if drive does not exist
'           3 if drive exists and disk is an audio CD
'
'supposed to run in any dos from MSDOS 3.1. Tested in Win 95 and DOS 6.2
'detects RAM disks and it's supposed to detect network units
'Does not use interrupt calls!
'---------------------------------------------------------------------------
'To use it into your programs simply copy it and add the line
'   diskreadyerror: errata% = ERR: RESUME NEXT
'(without the leading ') after the END of the main program
'---------------------------------------------------------------------------
    SHARED errata%
    errata% = 0
    drive$ = LEFT$(UCASE$(d$), 1) + ":"
    IF drive$ = "B:" THEN
     OUT &H70, &H10
     IF (INP(&H71) AND 7) = 0 THEN DiskReady% = 2: EXIT FUNCTION
    END IF
    ON ERROR GOTO diskreadyerror
    num% = FREEFILE
    OPEN drive$ + "\track01.cda" FOR INPUT AS #num%
    SELECT CASE errata%
     CASE 53: DiskReady% = 0
     CASE 71: DiskReady% = 1
     CASE 76: DiskReady% = 2
     CASE 0: DiskReady% = 3: CLOSE num%
     CASE ELSE
      PRINT "Unexpected error value "; errata%; "in Diskready function": END
    END SELECT
    ON ERROR GOTO 0

END FUNCTION

FUNCTION getcurdir$ (save%)
'if save <>0 then save cur dir
'if save =0 then chdir to curdir
'needs the shared variables temppath$ and win to be set
SHARED win, temppath$
STATIC a$
IF save% THEN
 tempfile$ = temppath$ + "curdir.txt"
 SHELL "cd >" + tempfile$
 f% = FREEFILE: OPEN tempfile$ FOR INPUT AS f%
 LINE INPUT #f%, a$
 CLOSE f%: KILL tempfile$
 IF LEFT$(a$, 1) <> "\" THEN a$ = a$ + "\"
ELSE
 IF win THEN a1$ = CHR$(34) + a$ ELSE a1$ = a$
 SHELL a1$
 SHELL "cd " + a1$
END IF
getcurdir$ = a$
END FUNCTION

SUB ideas
'pdte
'ok   hacer que trabaje svga 24 pixels
'ok   porqu monocolor no va?
'ok   alinear en parte superior
'ok   eliminar rutinas  putpixel y putpixelgray. print debe incluir putpixel
'ok   impedir modos que no llenen pantalla
'     decodificar svga progresivos
'ok   recuperar funcionmiento con ficheros con restart marks
'     leer encabezados de todos los jpeg aunque no los decodifiquemos
'     admitir escritura en rutina file select
'     thumbnails
'ok   si leemos fichero b/n y estamos en truecolor, pasar a 8 bits y paleta
'       b-n
'ok   en ide la gosub TORGB da overflow alguna vez.
'     repasar AAN, a ver si puede hacerse mas visible
END SUB

SUB INTERRUPTy (intnum AS INTEGER, REG AS regtypeX)
'standard interrupt call compatibility with QBasic
STATIC a() AS LONG, bReady AS INTEGER, x AS INTEGER, y AS INTEGER
IF NOT bReady THEN
    i = 50: DIM a(1 TO i) AS LONG
    a(1) = &H53EC8B55: a(2) = &H1E575651: a(3) = &H5E8B9C06: a(4) = &HA078B0E
    a(5) = &HC70774E4: a(6) = &HE9FFFF07: a(7) = &HEC8300A1: a(8) = &HB3F88A0A
    a(9) = &HE85E89CD: a(10) = &HCBEA46C7: a(11) = &H74253C90: a(12) = &H75263C04
    a(13) = &HEA46C714: a(14) = &H46C701E8: a(15) = &HC7CB00EC: a(16) = &H2C2EE46
    a(17) = &HF046C7: a(18) = &H85E8B90: a(19) = &H5E8B37FF: a(20) = &HE37FF06
    a(21) = &H50008FB8: a(22) = &HE85E8D16: a(23) = &H8BDA8C53: a(24) = &H378B0A5E
    a(25) = &H8E0C5E8B: a(26) = &H10448B1F: a(27) = &H75FFFF3D: a(28) = &H50C28B02
    a(29) = &H3D12448B: a(30) = &H275FFFF: a(31) = &HC08EC28B: a(32) = &H5C8B048B
    a(33) = &H44C8B02: a(34) = &H8B06548B: a(35) = &H748B0C7C: a(36) = &H9CCB1F0A
    a(37) = &H83EC8B55: a(38) = &H1E5620C5: a(39) = &H89E476C5: a(40) = &H25C8904
    a(41) = &H89044C89: a(42) = &H7C890654: a(43) = &H12448C0C: a(44) = &H8F10448F
    a(45) = &H448F0A44: a(46) = &HE448F08: a(47) = &H9D0EC483: a(48) = &H5E5F1F07
    a(49) = &HCA5D5B59: a(50) = &H9165000A
    S1 = 0: S2 = 0: p = VARPTR(a(1)): DEF SEG = VARSEG(a(1))
    FOR i = 0 TO 199
        S1 = (S1 + PEEK(p + i)) MOD 255: S2 = (S2 + S1) MOD 255
    NEXT i
    IF S1 OR S2 THEN ERROR 2: intnum = -1: EXIT SUB ' Checksum Error
    bReady = -1
END IF
x = VARSEG(REG): y = VARPTR(REG)
DEF SEG = VARSEG(a(1))
CALL ABSOLUTE(intnum, x, y, x, y, 0)

END SUB

SUB JPEGGet8x8 (vector(), comp, dcCoef) STATIC
'reads file ,decodes, and returns a 8x8 block of a component (Y, Cb or cr)
SHARED jpeg AS JpegType
SHARED buf2ptr AS INTEGER, viw AS INTEGER
SHARED Hufftree()  AS Huffmantreeentry
SHARED quant()
SHARED bit1() AS INTEGER, bit3() AS INTEGER, bit4() AS INTEGER
SHARED PwrsOf2() AS LONG
SHARED zz() AS zigzagtype
SHARED nofast
SHARED huffstart()

DIM buf2 AS LONG
DIM z1 AS LONG, z2 AS LONG, z3 AS LONG, z4 AS LONG, z5 AS LONG
DIM z10 AS LONG, z11 AS LONG, z12 AS LONG, z13 AS LONG
DIM tmp0 AS LONG, tmp1 AS LONG, tmp2 AS LONG, tmp3 AS LONG
DIM tmp4 AS LONG, tmp5 AS LONG, tmp6 AS LONG, tmp7 AS LONG
DIM tmp10 AS LONG, tmp11 AS LONG, tmp12 AS LONG, tmp13 AS LONG
  
   SELECT CASE comp
   CASE 1
      huffdcnum = jpeg.HDCTY
      huffacnum = jpeg.HaCTY
      quantnum = jpeg.qty
      tx = 0
   CASE 2
      huffdcnum = jpeg.HDCTCBR
      huffacnum = jpeg.HaCTcbr
      quantnum = jpeg.qtcbr
      tx = 2
   CASE ELSE
   END SELECT

    'clear vector
    REDIM vector(0 TO 7, 0 TO 7)

    'Get the DC coefficient
    hstart = huffstart(tx): GOSUB dekode1
    cat = dekode: GOSUB getnbits1: dcCoef = dcCoef + getnbits
    vector(0, 0) = dcCoef
    'Get AC Coefficients
    K = 1: hstart = huffstart(tx + 1)
    DO
        GOSUB dekode1
        SELECT CASE dekode
        CASE 0 'EOB Encountered
           EXIT DO
        CASE 3270 'ZRL encountered  15*256+0
           K = K + 16
        CASE ELSE
           K = K + dekode \ 16
           cat = dekode AND 15: GOSUB getnbits1
          'zigzag!
          vector(zz(K).xp, zz(K).yp) = getnbits
           K = K + 1
        END SELECT
    LOOP UNTIL K > 63


IF NOT viw THEN EXIT SUB
IF nofast THEN

'Inverse Discrete Cosinus Transform & dequantization
'Loeffler,Ligtenberg and Moschytz algorythm  (the default one)
 
 CONST fix029 = 2446&
 CONST FIX039 = -3196&
 CONST FIX054 = 4433&
 CONST FIX076 = 6270&
 CONST FIX089 = -7373&
 CONST FIX117 = 9633&
 CONST fix150 = 12299&
 CONST FIX184 = -15137&
 CONST FIX196 = -16069&
 CONST fix205 = 16819&
 CONST FIX256 = -20995&
 CONST fix307 = 25172&
 CONST x1& = &H20000
 CONST x2& = &H2000
 CONST x = &H1000

FOR u = 7 TO 0 STEP -1
 'if all row zeros, copy first value
 IF (vector(1, u) OR vector(2, u) OR vector(3, u) OR vector(4, u) OR vector(5, u) OR vector(6, u) OR vector(7, u)) = 0 THEN
   tmp0 = vector(0, u) * quant(quantnum, 0, u) * 2
   vector(0, u) = tmp0
   vector(1, u) = tmp0
   vector(2, u) = tmp0
   vector(3, u) = tmp0
   vector(4, u) = tmp0
   vector(5, u) = tmp0
   vector(6, u) = tmp0
   vector(7, u) = tmp0
 ELSE
 z2 = vector(2, u) * quant(quantnum, 2, u)
 z3 = vector(6, u) * quant(quantnum, 6, u)
 z1 = (z2 + z3) * FIX054
 tmp2 = z1 + (z3 * FIX184)
 tmp3 = z1 + (z2 * FIX076)
 z2 = vector(0, u) * quant(quantnum, 0, u)
 z3 = vector(4, u) * quant(quantnum, 4, u)
 tmp0 = x2& * (z2 + z3)
 tmp1 = x2& * (z2 - z3)
 tmp10 = tmp0 + tmp3
 tmp13 = tmp0 - tmp3
 tmp11 = tmp1 + tmp2
 tmp12 = tmp1 - tmp2
 tmp0 = vector(7, u) * quant(quantnum, 7, u)
 tmp1 = vector(5, u) * quant(quantnum, 5, u)
 tmp2 = vector(3, u) * quant(quantnum, 3, u)
 tmp3 = vector(1, u) * quant(quantnum, 1, u)
 z1 = tmp0 + tmp3
 z2 = tmp1 + tmp2
 z3 = tmp0 + tmp2
 z4 = tmp1 + tmp3
 z5 = (z3 + z4) * FIX117
 tmp0 = tmp0 * fix029
 tmp1 = tmp1 * fix205
 tmp2 = tmp2 * fix307
 tmp3 = tmp3 * fix150
 z1 = z1 * FIX089
 z2 = z2 * FIX256
 z3 = z3 * FIX196
 z4 = z4 * FIX039
 z3 = z3 + z5
 z4 = z4 + z5
 tmp0 = tmp0 + z1 + z3
 tmp1 = tmp1 + z2 + z4
 tmp2 = tmp2 + z2 + z3
 tmp3 = tmp3 + z1 + z4
 vector(0, u) = (tmp10 + tmp3) \ x
 vector(7, u) = (tmp10 - tmp3) \ x
 vector(1, u) = (tmp11 + tmp2) \ x
 vector(6, u) = (tmp11 - tmp2) \ x
 vector(2, u) = (tmp12 + tmp1) \ x
 vector(5, u) = (tmp12 - tmp1) \ x
 vector(3, u) = (tmp13 + tmp0) \ x
 vector(4, u) = (tmp13 - tmp0) \ x
  END IF
NEXT
FOR v = 0 TO 7
 z2 = vector(v, 2)
 z3 = vector(v, 6)
 z1 = (z2 + z3) * FIX054
 tmp2 = z1 + (z3 * FIX184)
 tmp3 = z1 + (z2 * FIX076)
 tmp0 = x2& * (vector(v, 0) + vector(v, 4))
 tmp1 = x2& * (vector(v, 0) - vector(v, 4))
 tmp10 = tmp0 + tmp3
 tmp13 = tmp0 - tmp3
 tmp11 = tmp1 + tmp2
 tmp12 = tmp1 - tmp2
 tmp0 = vector(v, 7)
 tmp1 = vector(v, 5)
 tmp2 = vector(v, 3)
 tmp3 = vector(v, 1)
 z1 = tmp0 + tmp3
 z2 = tmp1 + tmp2
 z3 = tmp0 + tmp2
 z4 = tmp1 + tmp3
 z5 = (z3 + z4) * FIX117
 tmp0 = tmp0 * fix029
 tmp1 = tmp1 * fix205
 tmp2 = tmp2 * fix307
 tmp3 = tmp3 * fix150
 z1 = z1 * FIX089
 z2 = z2 * FIX256
 z3 = z3 * FIX196
 z4 = z4 * FIX039
 z3 = z3 + z5
 z4 = z4 + z5
 tmp0 = tmp0 + z1 + z3
 tmp1 = tmp1 + z2 + z4
 tmp2 = tmp2 + z2 + z3
 tmp3 = tmp3 + z1 + z4
 vector(v, 0) = (tmp10 + tmp3) \ x1&
 vector(v, 7) = (tmp10 - tmp3) \ x1&
 vector(v, 1) = (tmp11 + tmp2) \ x1&
 vector(v, 6) = (tmp11 - tmp2) \ x1&
 vector(v, 2) = (tmp12 + tmp1) \ x1&
 vector(v, 5) = (tmp12 - tmp1) \ x1&
 vector(v, 3) = (tmp13 + tmp0) \ x1&
 vector(v, 4) = (tmp13 - tmp0) \ x1&
NEXT
EXIT SUB

'Arai, Agui, and Nakajima's algorithm (less accurate, but faster)
ELSE

CONST FIX1082 = 277& '     /* FIX(1.082392200) */
CONST fix1412 = 362& '     /* FIX(1.414213562) */
CONST FIX1847 = 473& '     /* FIX(1.847759065) */
CONST FIX2613 = 669& '     /* FIX(2.613125930) */
CONST x11& = &H8&

FOR u = 7 TO 0 STEP -1
    'if all row zeros, copy first value
    IF (vector(1, u) OR vector(2, u) OR vector(3, u) OR vector(4, u) OR vector(5, u) OR vector(6, u) OR vector(7, u)) = 0 THEN
      tmp0 = vector(0, u) * quant(quantnum, 0, u)
      vector(0, u) = tmp0
      vector(1, u) = tmp0
      vector(2, u) = tmp0
      vector(3, u) = tmp0
      vector(4, u) = tmp0
      vector(5, u) = tmp0
      vector(6, u) = tmp0
      vector(7, u) = tmp0
    ELSE
    tmp0 = vector(0, u) * quant(quantnum, 0, u)'even part
    tmp1 = vector(2, u) * quant(quantnum, 2, u)
    tmp2 = vector(4, u) * quant(quantnum, 4, u)
    tmp3 = vector(6, u) * quant(quantnum, 6, u)
    tmp10 = tmp0 + tmp2
    tmp11 = tmp0 - tmp2
    tmp13 = tmp1 + tmp3
    tmp12 = (tmp1 - tmp3) * fix1412 \ 256 - tmp13
    tmp0 = tmp10 + tmp13
    tmp3 = tmp10 - tmp13
    tmp1 = tmp11 + tmp12
    tmp2 = tmp11 - tmp12
   
    tmp4 = vector(1, u) * quant(quantnum, 1, u)'odd part
    tmp5 = vector(3, u) * quant(quantnum, 3, u)
    tmp6 = vector(5, u) * quant(quantnum, 5, u)
    tmp7 = vector(7, u) * quant(quantnum, 7, u)
    z13 = tmp6 + tmp5
    z10 = tmp6 - tmp5
    z11 = tmp4 + tmp7
    z12 = tmp4 - tmp7
    tmp7 = z11 + z13
    tmp11 = (z11 - z13) * fix1412 \ 256
    z5 = (z10 + z12) * FIX1847
    tmp10 = (z12 * FIX1082 - z5) \ 256
    tmp12 = (z10 * -FIX2613 + z5) \ 256
    tmp6 = tmp12 - tmp7
    tmp5 = tmp11 - tmp6
    tmp4 = tmp10 + tmp5
    vector(0, u) = tmp0 + tmp7
    vector(7, u) = tmp0 - tmp7
    vector(1, u) = tmp1 + tmp6
    vector(6, u) = tmp1 - tmp6
    vector(2, u) = tmp2 + tmp5
    vector(5, u) = tmp2 - tmp5
    vector(4, u) = tmp3 + tmp4
    vector(3, u) = tmp3 - tmp4
    END IF
  NEXT u
  FOR v = 0 TO 7
    tmp10 = vector(v, 0) + vector(v, 4)
    tmp11 = vector(v, 0) - vector(v, 4)
    tmp13 = vector(v, 2) + vector(v, 6)
    tmp12 = (vector(v, 2) - vector(v, 6) * fix1412) \ 256 - tmp13
    tmp0 = tmp10 + tmp13
    tmp3 = tmp10 - tmp13
    tmp1 = tmp11 + tmp12
    tmp2 = tmp11 - tmp12
    z13 = vector(v, 5) + vector(v, 3)       '/* Odd part */
    z10 = vector(v, 5) - vector(v, 3)
    z11 = vector(v, 1) + vector(v, 7)
    z12 = vector(v, 1) - vector(v, 7)
    tmp7 = z11 + z13            '            /* phase 5 */
    tmp11 = (z11 - z13) * fix1412 \ 256
    z5 = (z10 + z12) * FIX1847
    tmp10 = (z12 * FIX1082 - z5) \ 256
    tmp12 = (z10 * -FIX2613 + z5) \ 256
    tmp6 = tmp12 - tmp7'                     /* phase 2 */
    tmp5 = tmp11 - tmp6
    tmp4 = tmp10 + tmp5
    '/* Final output stage: scale down by a factor of 8
    vector(v, 0) = (tmp0 + tmp7) \ x11& 'AND &HFF
    vector(v, 7) = (tmp0 - tmp7) \ x11& 'AND &HFF
    vector(v, 1) = (tmp1 + tmp6) \ x11& 'AND &HFF
    vector(v, 6) = (tmp1 - tmp6) \ x11& 'AND &HFF
    vector(v, 2) = (tmp2 + tmp5) \ x11& 'AND &HFF
    vector(v, 5) = (tmp2 - tmp5) \ x11& 'AND &HFF
    vector(v, 4) = (tmp3 + tmp4) \ x11& 'AND &HFF
    vector(v, 3) = (tmp3 - tmp4) \ x11& 'AND &HFF
NEXT v
END IF
EXIT SUB





EXIT SUB


'--------------subroutines-------------------------

'this is the new Huffman decoder using a tree structure!
dekode1:
WHILE buf2ptr < 16
    buf2 = (buf2 AND &HFFFF&) * 256 OR jpeggetbyte: buf2ptr = buf2ptr + 8
WEND
hptr = hstart
DO
    buf2ptr = buf2ptr - 1
    IF buf2 AND PwrsOf2(buf2ptr) THEN
        bptr = Hufftree(hptr).is1
    ELSE
        bptr = Hufftree(hptr).is0
    END IF
    IF bptr THEN hptr = bptr ELSE EXIT DO
LOOP
dekode = Hufftree(hptr).code 'return the appropriate code
buf2ptr = buf2ptr + 1
RETURN

getnbits1:
WHILE buf2ptr < 16
    buf2 = (buf2 AND &HFFFF&) * 256 OR jpeggetbyte: buf2ptr = buf2ptr + 8
WEND
c1 = buf2ptr - cat: buf2ptr = c1
getnbits = buf2 \ PwrsOf2(c1) AND bit3(cat)
IF getnbits AND bit4(cat) THEN  ELSE getnbits = getnbits + bit1(cat)
RETURN

END SUB

FUNCTION jpeggetbyte STATIC
'***buffered, all JPEH file access goes thru it
'gets a single byte from file. At reading, it converts the pairs FF 00 to 00's
 
SHARED buf$, bufptr AS LONG, endptr  AS LONG, find$, jfile
DEF SEG

IF bufptr > endptr THEN
 GET #jfile, , buf$: bufptr = SADD(buf$): endptr = TOTALBUF + bufptr - 1
 i0 = INSTR(buf$, find$)
 IF PEEK(endptr) = 255 THEN endptr = endptr - 1: SEEK #jfile, SEEK(jfile) - 1
 DO WHILE i0 > 0
  MID$(buf$, i0 + 1) = MID$(buf$, i0 + 2): endptr = endptr - 1
  i0 = INSTR(i0 + 1, buf$, find$)
 LOOP
END IF

jpeggetbyte = PEEK(bufptr): bufptr = bufptr + 1
END FUNCTION

SUB JPEGGetParms (jfile)
'Scans the header of a JPEG so see if we are able to display it.
'If yes get Huffman table and quantization coefs
'------------------------------------------------------------------------
SHARED jpeg AS JpegType
SHARED imgcomment$
SHARED quant()
SHARED PwrsOf2() AS LONG
SHARED Hufftree()  AS Huffmantreeentry
SHARED huffstart()


REDIM quant(0 TO 1, 0 TO 7, 0 TO 7) '2 quantization tables (Y, CbCr)
REDIM hufftbl(0)   AS Huffmanentry

DIM GETword AS LONG

ON ERROR GOTO JPEGGetErrors

tindx = 0: tni = 0
jpeg.size = LOF(jfile)
QTables = 0 'Initialize some checkpoint variables
ACTables = 0
dctables = 0
jpeg.restart = GETword
SEEK jfile, 1
GOSUB getword1
IF GETword <> 65496 THEN ERROR 99

DO  'Primary control loop for markers
  IF jpeggetbyte = 255 THEN 'Marker Found
   d = jpeggetbyte
   SELECT CASE d 'which one is it?
   CASE &HC0, &HC1  'SOF0
    'get jpeg attributes
    GOSUB getword1: temp4& = GETword   'Length of segment
    temp0 = jpeggetbyte                'Data precision
    IF temp0 <> 8 THEN ERROR 100       'we do not support 12 or 16-bit samples
    GOSUB getword1: jpeg.rows = GETword
    GOSUB getword1: jpeg.cols = GETword
    temp0 = jpeggetbyte                'Number of components
    FOR i = 1 TO temp0
     id = jpeggetbyte
     SELECT CASE id
     CASE 1
      temp1 = jpeggetbyte
      jpeg.samplesy = (temp1 AND 15) * (temp1 \ 16)
      jpeg.qty = jpeggetbyte
     CASE 2, 3
      temp1 = jpeggetbyte
      jpeg.samplescbcr = (temp1 AND 15) * (temp1 \ 16)
      jpeg.qtcbr = jpeggetbyte
     CASE ELSE
     END SELECT
    NEXT i
  
   CASE &HC9 'SOF9
        ERROR 101
  
   CASE &HC4 'DHT  'get huffman tables
    IF ACTables < 2 OR dctables < 2 THEN
    
     'get huffman tables
        GOSUB READHUFF
    END IF
    
   CASE &HCC 'DAC
  ERROR 101
   CASE &HD8 'SOI
   CASE &HD9 'EOI
  ERROR 102
   CASE &HDA 'SOS
    'get SOS
    GOSUB getword1: temp4& = GETword
    temp0 = jpeggetbyte
    IF temp0 <> 1 AND temp0 <> 3 THEN GetSOS = 0: EXIT SUB
    jpeg.numcomp = temp0
    FOR i = 1 TO temp0
     temp1 = jpeggetbyte
     SELECT CASE temp1
     CASE 1
      temp2 = jpeggetbyte
      jpeg.HaCTY = temp2 AND 15
      jpeg.HDCTY = temp2 \ 16
     CASE 2, 3
      temp2 = jpeggetbyte
      jpeg.HaCTcbr = temp2 AND 15
      jpeg.HDCTCBR = temp2 \ 16
     CASE ELSE
    ERROR 103
     END SELECT
    NEXT i
    num = 3: GOSUB getstring
    IF (dctables = 2 AND ACTables = 2 AND QTables = 2) OR jpeg.numcomp = 1 THEN
   'TABLE ENDED, IMAGE START
   
   EXIT DO
    ELSE
   ERROR 104
    END IF
   CASE &HDD 'DRI
    GOSUB getword1: temp0 = GETword
    GOSUB getword1: jpeg.restart = GETword
   CASE &HDB 'DQT
    IF QTables < 2 THEN
       GOSUB GETQTABLES
    END IF
   CASE &HE0 'APP0
    GOSUB getword1
    l& = GETword
    num = 5: GOSUB getstring
    IF getstr$ <> ("JFIF" + CHR$(0)) THEN ERROR 106
    jpeg.jfifmajor = CHR$(jpeggetbyte)
    jpeg.jfifMinor = CHR$(jpeggetbyte)
    jpeg.densunits = CHR$(jpeggetbyte)
    GOSUB getword1: jpeg.Xdens = GETword
    GOSUB getword1: jpeg.ydens = GETword
    jpeg.ThWidth = CHR$(jpeggetbyte)
    jpeg.Theigth = CHR$(jpeggetbyte)
   CASE &HFE 'COM
    GOSUB getword1: num = GETword - 2:
    GOSUB getstring: imgcomment$ = getstr$
   CASE &HE1 TO &HEF
    GOSUB getword1: num = GETword - 2
    FOR i = 1 TO num: dummy = jpeggetbyte: NEXT
   END SELECT
  END IF
  IF LEN(INKEY$) THEN EXIT SUB
LOOP

'GOSUB debughuff
ON ERROR GOTO 0
EXIT SUB


'------subroutines-------------------

'REORDER BYTES IN WORD not intel byte order!!
getword1:
temp9 = jpeggetbyte
GETword = 256& * temp9 OR jpeggetbyte
RETURN

'READS A STRING FROM HEADER
getstring:
getstr$ = SPACE$(num)
FOR i = 1 TO num
 MID$(getstr$, i, 1) = CHR$(jpeggetbyte)
NEXT
RETURN

'USED TO DEBUG HUFFMAN TREE
debughuff:
    FOR i = -1 TO 47
    PRINT USING "###  ###  \             \ ### ### #####"; i; hufftbl(i).code; fnb$(hufftbl(i).code); hufftbl(i).index
    NEXT
    a$ = INPUT$(1)
RETURN

'READS HUFFMAN DATA AND CREATES HUFFMAN TREE
READHUFF:
     GOSUB getword1
     l0 = GETword: c0 = 2
     REDIM huffamount(1 TO 16)
     DO
      temp0 = jpeggetbyte: c0 = c0 + 1
      tc = (temp0 AND 16) \ 16
      th = temp0 AND 15
      'PRINT t0, temp0: a$ = INPUT$(1)
     
      'read number of entries for each size
      total = 0
      FOR i = 1 TO 16
       temp1 = jpeggetbyte: c0 = c0 + 1
       total = total + temp1
       huffamount(i) = temp1
      NEXT i
    
      'read the codes (huffamount(i) entries of 16 sizes)
      REDIM hufftbl(0 TO 256)  AS Huffmanentry
      curnum& = 0
      curindex = 0
      FOR i = 1 TO 16               'for each length
       FOR x = 1 TO huffamount(i)   'for the nr of codes in this length
        hufftbl(curindex).index = curnum&
        hufftbl(curindex).code = jpeggetbyte: c0 = c0 + 1
        hufftbl(curindex).size = i
        curindex = curindex + 1
        curnum& = curnum& + 1
       NEXT x
       curnum& = curnum& * 2
      NEXT i
    
      'create huffman tree in a single array
      'hdebug = 1
    
      'save start of this tree
      huffstart(th * 2 + tc) = tni
      nxtfree = tni + 1
    
      IF hdebug THEN PRINT "nextfree"; nxtfree; tni
      'for each entry in table
      FOR i = 0 TO curindex - 1
        s = hufftbl(i).size
        'left align index
        xx& = hufftbl(i).index
        ptr = tni
        IF hdebug THEN
            PRINT "table entry num"; i; "code"; hufftbl(i).code;
            a$ = fnb$(xx&)
            PRINT "size "; s; "index"; hufftbl(i).index, xx&, RIGHT$(a$, 16)
        END IF
        'for each bit in entry
        FOR bit = s - 1 TO 0 STEP -1
            IF hdebug THEN PRINT "next bit"; ptr, bit, (xx& AND PwrsOf2(bit))
            'if bit is 1
            IF xx& AND PwrsOf2(bit) THEN
                nxt = Hufftree(ptr).is1
                'next exists
                IF nxt THEN
                    IF hdebug THEN PRINT "..1"; ptr, nxt
                    ptr = nxt
                'don't exist, create it
                ELSE
                   IF hdebug THEN PRINT "new1"; ptr, nxtfree
                    Hufftree(ptr).is1 = nxtfree
                    ptr = nxtfree: nxtfree = nxtfree + 1
                END IF
            'ti bit is 0
            ELSE
                nxt = Hufftree(ptr).is0
                'next exists
                IF nxt THEN
                    IF hdebug THEN PRINT "..0"; ptr, nxt
                    ptr = nxt
                'don't exist, create it
                ELSE
                    IF hdebug THEN PRINT "new0"; ptr, nxtfree
                    Hufftree(ptr).is0 = nxtfree
                    ptr = nxtfree: nxtfree = nxtfree + 1
                END IF
            END IF
        NEXT 'x
        IF hdebug THEN
            PRINT "branch ended "; ptr; " code "; hufftbl(i).code
            PRINT
            a$ = INPUT$(1)
        END IF
        'set code at the end of tree
        Hufftree(ptr).code = hufftbl(i).code
      NEXT i
      tni = ptr + 2: tindx = tindx + 1
      IF hdebug THEN PRINT "************tni"; tni: PRINT : PRINT
      'go for the new table
      IF tc THEN ACTables = ACTables + 1 ELSE dctables = dctables + 1
     LOOP UNTIL c0 >= l0
     IF hdebug THEN a$ = INPUT$(1)
     ERASE hufftbl, huffamount
RETURN

GETQTABLES:
        GOSUB getword1
        l0 = GETword
        c0 = 2
        DO
         temp0 = jpeggetbyte: c0 = c0 + 1
         IF temp0 AND &HF0 THEN ERROR 105
         temp0 = temp0 AND 15
         xp = 0: yp = 0
         FOR i = 0 TO 63
          quant(temp0, zz(i).xp, zz(i).yp) = jpeggetbyte: c0 = c0 + 1
         NEXT i
         QTables = QTables + 1
        LOOP UNTIL c0 >= l0

RETURN

END SUB

FUNCTION JPEGPut (jfile, x0, y0)
'Routine that calls the decoder for each 8X8 block,
'combines the different components to form the image,
'then puts it into the screen pixel by pixel

SHARED rcrv(), gcbv(), gcrv(), bcbv()
SHARED vesainfo AS vesainfoblock
SHARED buf2ptr AS INTEGER, viw AS INTEGER
SHARED jpeg AS JpegType
SHARED Hufftree() AS Huffmantreeentry
SHARED quant()
SHARED r$
SHARED curbank AS INTEGER, lasty AS INTEGER
SHARED rlook(), glook(), blook(), g2look()
SHARED xoff(), yseg(), ybank()

SHARED regs AS regtypeX

REDIM YVector1(0 TO 7, 0 TO 7)              '4 vectors for Y attribute
REDIM YVector2(0 TO 7, 0 TO 7)
REDIM YVector3(0 TO 7, 0 TO 7)
REDIM YVector4(0 TO 7, 0 TO 7)
REDIM CbVector(0 TO 7, 0 TO 7)              '1 vector for Cb attribute
REDIM CrVector(0 TO 7, 0 TO 7)              '1 vector for Cr attribute
'DIM mcu AS LONG

    'We initialize the dc coefficients : they are accumulative
    dcY = 0: dcCb = 0: dcCr = 0
    xindex = 0: yindex = 0
    buf2ptr = 0
    mcu = 0: lastj = -1
    xlim = vesainfo.xres - x0
    ylim = vesainfo.yres - y0
    SELECT CASE jpeg.numcomp
    'Y-Cb-Cr color jpeg
    CASE 3
        SELECT CASE jpeg.samplesy
        CASE 4
            DO
                GOSUB skip
                JPEGGet8x8 YVector1(), 1, dcY
                JPEGGet8x8 YVector2(), 1, dcY
                JPEGGet8x8 YVector3(), 1, dcY
                JPEGGet8x8 YVector4(), 1, dcY
                JPEGGet8x8 CbVector(), 2, dcCb
                JPEGGet8x8 CrVector(), 2, dcCr
                IF viw THEN
                    FOR y = 0 TO 15
                        yi = yindex + y: IF yi >= jpeg.rows THEN EXIT FOR
                        IF yi > ylim THEN EXIT FOR
                        y2 = y \ 2: y1 = yi + y0
                        IF ybank(y1) <> curbank THEN
                            regs.ax = &H4F05
                            regs.bx = 0
                            regs.dx = ybank(y1)
                            CALL INTERRUPTy(&H10, regs)
                            curbank = ybank(y1)
                        END IF
                        DEF SEG = yseg(y1)
                        FOR x = 0 TO 15
                            xj = xindex + x: IF xj >= jpeg.cols THEN EXIT FOR
                            IF xj > xlim THEN EXIT FOR
                            IF y AND 8 THEN
                                IF x AND 8 THEN
                                    yyy = YVector4(y AND 7, x AND 7) + 128
                                ELSE
                                    yyy = YVector3(y AND 7, x) + 128
                                END IF
                            ELSE
                                IF x AND 8 THEN
                                    yyy = YVector2(y, x AND 7) + 128
                                ELSE
                                    yyy = YVector1(y, x) + 128
                                END IF
                            END IF
                            GOSUB ToRGB
                        NEXT x
                    NEXT y
                END IF
                IF jpeg.restart THEN mcu = mcu + 1: IF jpeg.restart = mcu THEN GOSUB rstrt
                xindex = xindex + 16
                IF xindex >= jpeg.cols THEN
                    xindex = 0: yindex = yindex + 16
                    IF LEN(INKEY$) THEN JPEGPut = -1: GOTO cleanup
                END IF
            LOOP UNTIL yindex >= jpeg.rows OR yindex + y0 >= vesainfo.yres

        'case 2 is very uncommon. Tested thanks to a file sent by Josh Heaton
        CASE 2
            DO
                GOSUB skip
                JPEGGet8x8 YVector1(), 1, dcY
                JPEGGet8x8 YVector2(), 1, dcY
                JPEGGet8x8 CbVector(), 2, dcCb
                JPEGGet8x8 CrVector(), 2, dcCr
                IF viw THEN
                    FOR y = 0 TO 7
                        yi = yindex + y: IF yi >= jpeg.rows THEN EXIT FOR
                        IF yi >= ylim THEN EXIT FOR
                        y2 = y \ 2: y1 = yi + y0
                        xj = xindex
                        IF ybank(y1) <> curbank THEN
                            regs.ax = &H4F05
                            regs.bx = 0
                            regs.dx = ybank(y1)
                            CALL INTERRUPTy(&H10, regs)
                            curbank = ybank(y1)
                        END IF
                        DEF SEG = yseg(y1)
                        FOR x = 0 TO 15
                            xj = xj + 1: IF xj >= jpeg.cols THEN EXIT FOR
                            IF xj > xlim THEN EXIT FOR
                            IF x AND 8 THEN
                                yyy = YVector2(y, x AND 7) + 128
                            ELSE
                                yyy = YVector1(y, x) + 128
                            END IF
                            GOSUB ToRGB
                    NEXT x, y
                END IF
                IF jpeg.restart THEN mcu = mcu + 1: IF jpeg.restart = mcu THEN GOSUB rstrt
                xindex = xindex + 16
                IF xindex >= jpeg.cols THEN
                    xindex = 0: yindex = yindex + 8
                    IF LEN(INKEY$) THEN JPEGPut = -1: GOTO cleanup
                END IF
            LOOP UNTIL yindex >= jpeg.rows OR yindex + y0 >= vesainfo.yres
         
        CASE 1
            DO
                GOSUB skip
                JPEGGet8x8 YVector1(), 1, dcY
                JPEGGet8x8 CbVector(), 2, dcCb
                JPEGGet8x8 CrVector(), 2, dcCr
                IF viw THEN
                    FOR y = 0 TO 7
                        yi = yindex + y: IF yi >= jpeg.rows THEN EXIT FOR
                        IF yi >= ylim THEN EXIT FOR
                        y2 = y \ 2: y1 = yi + y0
                        IF ybank(y1) <> curbank THEN
                            regs.ax = &H4F05
                            regs.bx = 0
                            regs.dx = ybank(y1)
                            CALL INTERRUPTy(&H10, regs)
                            curbank = ybank(y1)
                        END IF
                        DEF SEG = yseg(y1)
                        FOR x = 0 TO 7
                            xj = xindex + x: IF xj >= jpeg.cols THEN EXIT FOR
                            IF xj > xlim THEN EXIT FOR
                            yyy = YVector1(y, x) + 128
                            GOSUB ToRGB
                    NEXT x, y
                END IF
                IF jpeg.restart THEN mcu = mcu + 1: IF jpeg.restart = mcu THEN GOSUB rstrt
                xindex = xindex + 8
                IF xindex >= jpeg.cols THEN
                    xindex = 0: yindex = yindex + 8
                    IF LEN(INKEY$) THEN JPEGPut = -1: GOTO cleanup
                END IF
            LOOP UNTIL yindex >= jpeg.rows OR (yindex + y0) >= vesainfo.yres
        CASE ELSE
        END SELECT

    'monochrome jpeg
    CASE 1
        DO
            GOSUB skip
            JPEGGet8x8 YVector1(), 1, dcY
            IF viw THEN
                FOR y = 0 TO 7
                    yi = yindex + y: IF yi >= jpeg.rows THEN EXIT FOR
                    IF yi >= ylim THEN EXIT FOR
                    y1 = yi + y0
                    IF ybank(y1) <> curbank THEN
                        regs.ax = &H4F05
                        regs.bx = 0
                        regs.dx = ybank(y1)
                        CALL INTERRUPTy(&H10, regs)
                        curbank = ybank(y1)
                    END IF
                    DEF SEG = yseg(y1)
                    FOR x = 0 TO 7
                        xj = xindex + x: IF xj >= jpeg.cols THEN EXIT FOR
                        IF xj > xlim THEN EXIT FOR
                        yyy = YVector1(y, x) + 128
                        IF yyy < 0 THEN
                            yyy = 0
                        ELSEIF y > 255 THEN
                            yyy = 255
                        END IF
                        offset = xoff(xj + x0)
                        POKE offset, yyy
                    NEXT x
                NEXT y
            END IF
            IF jpeg.restart THEN mcu = mcu + 1: IF jpeg.restart = mcu THEN GOSUB rstrt
            xindex = xindex + 8
            IF xindex >= jpeg.cols THEN
                xindex = 0: yindex = yindex + 8
                IF LEN(INKEY$) THEN JPEGPut = -1: GOTO cleanup
            END IF
        LOOP UNTIL yindex >= jpeg.rows OR yindex + y0 >= vesainfo.yres
    CASE ELSE
    END SELECT
cleanup:
    ERASE Hufftree, quant
    ERASE YVector1, YVector2, YVector3, YVector4, CbVector, CrVector
    buf$ = ""
    ON ERROR GOTO 0
EXIT FUNCTION


rstrt:
    buf2ptr = (buf2ptr AND &HFFF8) - 16
    dcY = 0: dcCb = 0: dcCr = 0: mcu = 0
RETURN


ToRGB:
    j2 = x \ 2
    crv = CrVector(y2, j2)
    cbv = CbVector(y2, j2)
   
    r = yyy + rcrv(crv)
    g = yyy + gcbv(cbv) + gcrv(crv)
    b = yyy + bcbv(cbv)

    IF r > 255 THEN
     r = 255
    ELSEIF r < 0 THEN
     r = 0
    END IF
    IF g > 255 THEN
     g = 255
    ELSEIF g < 0 THEN
     g = 0
    END IF
    IF b > 255 THEN
     b = 255
    ELSEIF b < 0 THEN
     b = 0
    END IF
    offset = xoff(xj + x0)
   
    SELECT CASE vesainfo.bpp
    CASE 32, 24
        POKE offset + 2, r
        POKE offset + 1, g
        POKE offset, b
    CASE 15, 16
        a = rlook(r) OR g2look(g)
        a1 = glook(g) OR blook(b)
        POKE offset, a1: POKE offset + 1, a
    CASE 8
        POKE offset, rlook(r) OR glook(g) OR blook(b)
    CASE ELSE
    END SELECT
       
RETURN



skip:
 viw = -1
 xi0 = xindex + x0
 IF xi0 >= vesainfo.xres THEN
  viw = 0
 ELSEIF xi0 < 0 THEN
  viw = 0
 ELSEIF (yindex + y0) < 0 THEN
  viw = 0
 END IF
RETURN
END FUNCTION

SUB JPEGViewParms
 'displays the info the JPEGGetParms has read from JPEG header

 SHARED f$
 SHARED imgcomment$
 SHARED jpeg AS JpegType
 PRINT "Parameters of this JPEG File"
 PRINT
 PRINT "File Name            :  "; f$
 PRINT USING "File  size           : ######,###               bytes"; jpeg.size
 PRINT "Comment              : "; imgcomment$
 PRINT USING "JFIF Format Version  :         ##     .    ##"; ASC(jpeg.jfifmajor); ASC(jpeg.jfifMinor)
 PRINT USING "Rows X Cols          :       ####     x  ####   pixel"; jpeg.rows; jpeg.cols
 TEMP& = 3& * jpeg.rows * jpeg.cols
 PRINT USING "Uncompressed size    : ######,###               bytes"; TEMP&
 PRINT USING "Compression ratio    :       ####.#   to    1"; TEMP& / jpeg.size
 SELECT CASE ASC(jpeg.densunits)
 CASE 0: unit$ = "ratio"
 CASE 1: unit$ = "dots/inch"
 CASE 2:  unit$ = "dots/cm"
 CASE ELSE
 END SELECT
 PRINT USING "Density           X/Y:       ####     /  ####   \        \"; jpeg.Xdens; jpeg.ydens; unit$
 IF jpeg.restart THEN
 PRINT USING "Restart each         :      #####               blocks"; jpeg.restart
 ELSE
 PRINT "No Restart marks in this file"
 END IF
 PRINT USING "Thumbnail w x h      :        ###     x   ###   pixel "; ASC(jpeg.ThWidth); ASC(jpeg.Theigth)
 IF jpeg.numcomp = 3 THEN a$ = " Color Y + Cb + Cr" ELSE a$ = " Black & White"
 PRINT "Color components     : "; a$
 PRINT "Num of samples      Y: "; jpeg.samplesy; : LOCATE , 49: PRINT "CbCr: "; jpeg.samplescbcr
 PRINT
 PRINT "Quantization tables Y: "; jpeg.qty + 1; : LOCATE , 49: PRINT "Cbcr: "; jpeg.qtcbr - jpeg.qty
 PRINT "Huffman tables DC   Y: "; jpeg.HDCTY + 1; : LOCATE , 49: PRINT "CbCr: "; jpeg.HDCTCBR - jpeg.HDCTY
 PRINT "Huffman tables aC   Y: "; jpeg.HaCTY + 1; : LOCATE , 49: PRINT "CbCr: "; jpeg.HaCTcbr - jpeg.HaCTY
 PRINT

END SUB

SUB menu
 'displays main menu and some timings

 SHARED vesainfo AS vesainfoblock
 SHARED time!, bltime!, nofast
 IF nofast THEN a$ = "NN&M" ELSE a$ = "AA&N"
 PRINT "      MENU"
 PRINT "      ===="
 PRINT
 PRINT "      F:  select new JPEG File"
 PRINT "      V:  View JPEG"
 PRINT "      M:  change SVGA mode"
 PRINT "      A:  Change IDCT algorithm. Now using: "; a$
 PRINT "      X:  eXit program"
 PRINT
 PRINT "      Present SVGA mode is:"
 PRINT USING "      MODE \ \H  #### x #### x ## "; HEX$(vesainfo.modenum); vesainfo.xres; vesainfo.yres; vesainfo.bpp
 PRINT
 PRINT USING "      Last Decoding time: ####.## sec "; time!
 
END SUB

FUNCTION SelectAFile$ (header$, ext$)
'
' User friendly file selector routine.Returns full path of a file
' by Antoni Gual agual@eic.ictnet.es
' Fully reprogrammed from a layout by William Yu
'
' Use as you want, only give me credit
'
' FEATURES:
' Should not display DOS error messages when disk not ready
' Tested in Win 95/98 and  DOS 6.1-Win 3.11.
' Auto detects num of screen lines set by main program.
' Tested with QBasic
' Not self contained, needs DiskReady and DetectWinTemp routines!
' No mouse!
' In W95/98 displays LFN, but returns 8.3 format
'   (QB file functions can't handle LFN)
'
' REMARKS:
' For non Win 9x users: It Runs faster if temp path is set to a RAM drive!
' Creates some auxiliar files: To do it, uses path in temp system variable
' To use it with DOS < 5.0 try changing constant DOS to 3 (Sorry..I.Can't test it)
' To avoid drive checking each time the routine is run, read comment
'    6 lines above EXIT FUNCTION
'
'-------------------------------------------------------------------------
 'PUT DOS TO 3 IF THE PROGRAM HAS TO RUN UNDER DOS BELOW 5.0
 DIM z$
 SHARED win, temppath$
 CONST dos = 5


 'keys
 CONST kpgup = -&H49, kpgdn = -&H51
 CONST kleft = -&H4B, kright = -&H4D, kup = -&H48, kdown = -&H50
 CONST kenter = &HD, kesc = &H1B

 q$ = CHR$(34)

 'colors
 CONST fgiuns = 7, bgiuns = 0, fgauns = 15, bgauns = 0
 CONST fgisel = 12, bgisel = 0, fgasel = 15, bgasel = 4

 'auxiliar files
 DIM auxf$(1 TO 3):
 auxf$(3) = temppath$ + "}{drive.lst": auxf$(2) = temppath$ + "}{dir.lst"
 auxf$(1) = temppath$ + "}{file.lst"
 tempfile$ = temppath$ + "temp.txt"
   
 'Detect Nr of lines of screen
 DEF SEG = &H40
 scrl = PEEK(&H84) + 1
 DEF SEG

 DIM wd(0 TO 4, 1 TO 3)
 'vertical window sizes
 CONST wintop = 8
 winbot = scrl - 7: winheight = winbot - wintop + 1

 'indexs ( they avoid for a type definition in the main module)
 CONST wdxpos = 0, wdwdth = 1, wdtop = 2, wdcur = 3, wdcount = 4


 'init
 wd(wdxpos, 1) = 8: wd(wdxpos, 2) = 38: wd(wdxpos, 3) = 68
 IF win THEN
  wd(wdwdth, 1) = 24: wd(wdwdth, 2) = 24: wd(wdwdth, 3) = 6
 ELSE
  wd(wdwdth, 1) = 12: wd(wdwdth, 2) = 8: wd(wdwdth, 3) = 6
 END IF
 wd(wdtop, 1) = 1: wd(wdtop, 2) = 1: wd(wdtop, 3) = 1


 'strings with windows width
 DIM t$(1 TO 3): FOR i = 1 TO 3: t$(i) = SPACE$(wd(wdwdth, i)): NEXT
 h$ = SPACE$(64)


 'prepare command strings
 IF dos = 5 THEN
  IF win THEN x$ = " /Z"
   dosdirs$ = "DIR  /AD /ON /B >>" + auxf$(2)
     dosfiles$ = "DIR *." + ext$ + " /A-D /ON /B >" + auxf$(1)
 ELSE
  dosdirs$ = "DIR *.* |FIND " + q$ + "<DIR>" + q$ + " >" + auxf$(2)
  dosfiles$ = "DIR *." + ext$ + " | FIND " + q$ + ":" + q$ + "|FIND /V " + q$
  dosfiles$ = dosfiles$ + "<DIR>" + q$ + "|FIND /V " + q$ + ":\" + q$ + " >" + auxf$(1)
 END IF

 TEMP = INSTR(ext$, "."): IF TEMP THEN ext$ = MID$(ext$, TEMP + 1)

 'check all possible drives and build a drive list
 file$ = auxf$(3): GOSUB filexist
 IF exist = false THEN
  f = FREEFILE: OPEN auxf$(3) FOR OUTPUT AS #f
  COLOR 7, 0: CLS : PRINT "Checking existing drives: please wait!"
  FOR i = ASC("A") TO ASC("Z")
   IF DiskReady(CHR$(i)) <> 2 THEN
    LSET t$(3) = "-[" + CHR$(i) + ":]-"
    PRINT #f, t$(3)
   END IF
  NEXT
  CLOSE #f
 END IF
 f = FREEFILE: OPEN auxf$(3) FOR INPUT AS #f
 w1 = 3: GOSUB ITEMCOUNT
 CLOSE f

 'init screen
 SCREEN 0: COLOR 7, 1: CLS
 COLOR 14: LOCATE 1, 40 - LEN(header$) \ 2: PRINT header$;
 'top rectangle
 LOCATE 3, 4: COLOR 9, 0: PRINT CHR$(218); STRING$(72, 196); CHR$(191)
 LOCATE 4, 4: PRINT CHR$(179); STRING$(72, 0); CHR$(179)
 LOCATE 5, 4: PRINT CHR$(192); STRING$(72, 196); CHR$(217)

 'other rectangles
 FOR x1 = 1 TO 3: GOSUB rect: NEXT
 COLOR 14, 1: LOCATE scrl - 2, 2
 PRINT "Up/Dn Pgup/PgDn Move cursor, Left/Right Change Panel, Enter Select, Esc Quit";

 'clear keyboard buffer
 WHILE LEN(INKEY$): WEND

 'init drive an dir cursor
 GOSUB curdir
   
 'cursor will start in files window
 actwin = 1
  
 'here we enter the main loop
updatedrive:
 f = FREEFILE: OPEN auxf$(3) FOR INPUT AS #f
  w1 = 3: GOSUB updatewin
 CLOSE f

'update dir list
updatedir:

 GOSUB curdir
 IF dos = 5 THEN
  f = FREEFILE: OPEN auxf$(2) FOR OUTPUT AS #f
  IF LEN(curdir$) > 3 THEN PRINT #f, ".."
  CLOSE f
 END IF

 SHELL dosdirs$
 
 OPEN auxf$(2) FOR INPUT AS #f
  w1 = 2: GOSUB ITEMCOUNT: GOSUB updatewin
 CLOSE f

 'update file list
 SHELL dosfiles$
 f = FREEFILE: OPEN auxf$(1) FOR INPUT AS #f
  w1 = 1: GOSUB ITEMCOUNT: GOSUB updatewin
  IF wd(wdcount, 1) = 0 THEN actwin = 2: w1 = 2: GOSUB updatewin
 CLOSE f

'keys loop
'program will stay in this loop unless window change or press enter or esc
movecursor:
 w1 = actwin
 OPEN auxf$(actwin) FOR INPUT AS #f
 DO
  GOSUB updatewin
  DO: v$ = INKEY$: LOOP UNTIL LEN(v$)
  v = ASC(RIGHT$(v$, 1)): IF ASC(v$) = 0 THEN v = -v
  SELECT CASE v
  CASE kup:
    wd(wdcur, w1) = wd(wdcur, w1) - 1
    IF wd(wdcur, w1) < 1 THEN wd(wdcur, w1) = 1
  CASE kdown:
    wd(wdcur, w1) = wd(wdcur, w1) + 1
    IF wd(wdcur, w1) > wd(wdcount, w1) THEN wd(wdcur, w1) = wd(wdcount, w1)
  CASE kpgup:
    wd(wdcur, w1) = wd(wdcur, w1) - winheight
    IF wd(wdcur, w1) < 1 THEN wd(wdcur, w1) = 1
  CASE kpgdn:
    wd(wdcur, w1) = wd(wdcur, w1) + winheight
    IF wd(wdcur, w1) > wd(wdcount, w1) THEN wd(wdcur, w1) = wd(wdcount, w1)
  'change active window
  CASE kleft:
   IF actwin > 1 THEN
      IF actwin <> 2 OR wd(wdcount, 1) > 0 THEN
    actwin = actwin - 1: GOSUB updatewin: CLOSE #f: GOTO movecursor
      END IF
   END IF
  'change active window
  CASE kright:
   IF actwin < 3 THEN
    actwin = actwin + 1: GOSUB updatewin: CLOSE #f: GOTO movecursor
   END IF
  'select file in file window, change dir or drive in other windows
  CASE kenter:
   WHILE DiskReady(newdrive$) = 1
    err$ = "Disk " + newdrive$ + " not ready   [R]etry/[C]ancel?": GOSUB errmsg
    IF a$ <> "R" THEN CLOSE f: SHELL "C:": GOTO updatedrive
   WEND
   SELECT CASE actwin
   'select file and exit
   CASE 1:
    IF LEN(newfile$) THEN
     CLOSE f: tmp$ = curdir$ + newfile$
     IF win THEN
      'truename fails with filenames so i use it only with dir name
      doscmd$ = "TRUENAME |find " + q$ + ":\" + q$ + ">" + tempfile$
      SHELL doscmd$
      OPEN tempfile$ FOR INPUT AS f: LINE INPUT #f, tp$: CLOSE f
      tmp$ = tp$: IF LEN(tmp$) > 3 THEN tmp$ = tmp$ + "\"
      KILL tempfile$
      doscmd$ = "DIR /A-D " + q$ + newfile$ + q$ + "|FIND " + q$ + ":" + q$ + "|FIND /V " + q$ + ":\" + q$ + ">" + tempfile$
      SHELL doscmd$
      OPEN tempfile$ FOR INPUT AS f: LINE INPUT #f, tp$: CLOSE f
      t$ = SPACE$(12): LSET t$ = tp$: MID$(t$, 9) = "."
      tmp$ = tmp$ + RTRIM$(t$)
     END IF
     SelectAFile$ = tmp$: EXIT DO
    ELSE
     actwin = actwin + 1: GOSUB updatewin
    END IF
   'change dir
   CASE 2:
    IF newdir$ <> "." THEN
     IF (LEN(curdir$) > 3) OR (newdir$ <> "..") THEN
      CLOSE f: SHELL "CD " + newdir$: GOTO updatedir
     END IF
    END IF
   'change drive
   CASE 3:
     CLOSE f: SHELL newdrive$: GOTO updatedrive
   CASE ELSE
   END SELECT
  CASE kesc:
   CLOSE #f: SelectAFile$ = "": EXIT DO
  CASE ELSE
  END SELECT
 LOOP
 KILL auxf$(1)
 KILL auxf$(2)
 'KILL auxf$(3) 'this file (}{drive.lst) keeps the list of valid drives
 '              to avoid drive testing each time the routine is run
 '              put a REM in  this line and erase the file at program's end.
 '              (Or don't erase it, if your drives are all fixed)
 IF win THEN z$ = q$ ELSE z$ = ""
 CLS
EXIT FUNCTION

'---------------------------gosubs------------------------------------------
'update window W1 from the contents of already opened file f
updatewin:
 SEEK #f, 1
 IF actwin = w1 THEN isactive = true ELSE isactive = false
 IF wd(wdcur, w1) < wd(wdtop, w1) THEN wd(wdtop, w1) = wd(wdcur, w1)
 IF wd(wdcur, w1) > (wd(wdtop, w1) + winheight - 1) THEN wd(wdtop, w1) = wd(wdcur, w1) - winheight + 1
 i = 1: x = wintop: K = wd(wdleft, w1)
 WHILE NOT EOF(f) AND x <= winbot
  LINE INPUT #f, a$
  IF i >= wd(wdtop, w1) THEN
   LSET t$(w1) = a$
   IF i = wd(wdcur, w1) THEN
    IF isactive THEN COLOR fgasel, bgasel ELSE COLOR fgisel, bgisel
    SELECT CASE w1
     CASE 1: newfile$ = RTRIM$(a$)
     'IF LEN(NEWFILE$) > 9 THEN MID$(NEWFILE$, 9) = "."
     CASE 2: newdir$ = RTRIM$(a$): IF win THEN newdir$ = q$ + newdir$
     CASE 3: newdrive$ = MID$(t$(w1), 3, 2)
    END SELECT
   ELSE
    IF isactive THEN COLOR fgauns, bgauns ELSE COLOR fgiuns, bgiuns
   END IF
   LOCATE x, K: PRINT t$(w1); : x = x + 1
  END IF
  i = i + 1
 WEND
 LSET t$(w1) = "": COLOR fgiuns, bgiuns
 FOR j1 = x TO winbot
    LOCATE j1, K: PRINT t$(w1)
 NEXT
RETURN

curdir:
 tempfile$ = temppath$ + "curr.dir"
 SHELL "CD > " + tempfile$
 f = FREEFILE: OPEN tempfile$ FOR INPUT AS #f
 LINE INPUT #f, curdir$
 IF LEN(curdir$) <> 3 THEN curdir$ = curdir$ + "\"
 curdrive$ = LEFT$(curdir$, 1)
 CLOSE f: KILL tempfile$
 OPEN auxf$(3) FOR INPUT AS #f
  i = 0
  DO: i = i + 1: LINE INPUT #f, a$: LOOP UNTIL INSTR(a$, curdrive$)
 CLOSE f
 wd(wdcur, 3) = i
 LSET h$ = curdir$ + "*." + ext$
 LOCATE 4, 6: COLOR 10: PRINT h$;
RETURN


'GUI: draw a shadowed rectangle, dimensions in wd(?,x1)
rect:
 COLOR 9, 7: LOCATE wintop - 1, wd(wdxpos, x1) - 1
 PRINT CHR$(218); STRING$(wd(wdwdth, x1), 196); CHR$(191)
 FOR x = wintop TO winbot
   LOCATE x, wd(wdxpos, x1) - 1
   PRINT CHR$(179); STRING$(wd(wdwdth, x1), 32); CHR$(179)
 NEXT x
 LOCATE winbot + 1, wd(wdxpos, x1) - 1
 PRINT CHR$(192); STRING$(wd(wdwdth, x1), 196); CHR$(217)
 FOR x = wintop TO winbot + 1
  LOCATE x, wd(wdxpos, x1) + wd(wdwdth, x1) + 1: COLOR 0
  PRINT STRING$(2, 219)
 NEXT x
 LOCATE winbot + 2, wd(wdxpos, x1) + 2: PRINT STRING$(wd(wdwdth, x1) + 1, 219)
RETURN

'check if a file exists
filexist:
 f = FREEFILE: OPEN file$ FOR BINARY AS #f
 IF LOF(f) = 0 THEN exist = false: CLOSE #f: KILL file$ ELSE exist = true: CLOSE #f
RETURN

'count items in list file
ITEMCOUNT:
 x = 0: WHILE NOT EOF(f): LINE INPUT #f, a$: x = x + 1: WEND
 wd(wdcount, w1) = x: wd(wdcur, w1) = 1
RETURN

'displays an eror message and waits for a key
errmsg:
 LSET h$ = err$
 LOCATE 4, 6: COLOR 12: PRINT h$;
 a$ = UCASE$(INPUT$(1)): LSET h$ = "": LOCATE 4, 6: PRINT h$
RETURN

END FUNCTION

SUB SVGAGetData
'get general data from the VESA API

SHARED vesainfo AS vesainfoblock
SHARED regs AS regtypeX
CONST VESAOK = &H4F
regs.ax = &H4F00
regs.es = VARSEG(vesainfo)
regs.DI = VARPTR(vesainfo)
CALL INTERRUPTy(&H10, regs)
IF regs.ax <> VESAOK THEN PRINT "SORRY...VESA CARD NOT DETECTED": END
'get amount of mode numbers
a$ = MKL$(vesainfo.VIDEOMODEPTR)
DEF SEG = vesainfo.VIDEOMODESEG
 ptr1 = vesainfo.VIDEOMODEPTR
 i = 0
 DO UNTIL md& = 65535
  i = i + 1
  TEMP = PEEK(ptr1)
  ptr1 = ptr1 + 1
  md& = PEEK(ptr1) * 256& + TEMP
  ptr1 = ptr1 + 1
 LOOP
DEF SEG
vesainfo.modemax = i - 1
END SUB

SUB SVGAGetModeInfo (md&)
  'reads from VESA API the data for a paricular SVGA mode
 
  SHARED display AS vesaModeinfoBlock
  SHARED regs AS regtypeX
  regs.ax = &H4F01
  regs.cx = md&
  regs.es = VARSEG(display)
  regs.DI = VARPTR(display)
  CALL INTERRUPTy(&H10, regs)
END SUB

SUB SVGAPRINT (t$, xstartpos, ystartpos, scrxsize, scrysize, chspacing, font)

'Uses ROM fonts (this can be changed easily) to display a scalable size text
'in the current SVGA mode. It proceeds line by line, not char by char
'so it should be fast.

'CAUTION: It does'nt check for out of screen conditions!

'positions and sizes in pixels!
'ROM font numbers valid:
' font 2: 14 pixel high x 8
' font 3: 8  pixel high x 8
' font 6: 16 pixel high x 8

SHARED regs AS regtypeX
SHARED PwrsOf2() AS LONG
SHARED rlook(), glook(), blook(), g2look()
SHARED xoff(), yseg(), ybank()
SHARED vesainfo AS vesainfoblock
SHARED curbank AS INTEGER, lasty AS INTEGER
IF LEN(t$) = 0 THEN EXIT SUB

REDIM t1a&(LEN(t$)), ta(LEN(t$)), oa&(LEN(t$)), ea&(LEN(t$))
STATIC Fontseg, fontoffset&, lf, chysize, chxsize, r, g, b
'locate charmap in bios
        IF lf <> font THEN
                'change this block if you want to use a font in an array
                chxsize = 8
                SELECT CASE font:
                CASE 2: chysize = 14
                CASE 3: chysize = 8
                CASE 6: chysize = 16
                CASE ELSE: EXIT SUB
                END SELECT
                r = 255: g = 255: b = 255
               
                regs.ax = &H1130
                regs.bx = font * 256
                CALL INTERRUPTy(&H10, regs)
                Fontseg = regs.es
                fontoffset& = regs.bp
                lf = font
        END IF
  
        oa&(0) = (Xchstart - scrxsize - chspacing) * vesainfo.bytespixel
        FOR strptr = 1 TO LEN(t$)
           t1a&(strptr) = fontoffset& + ASC(MID$(t$, strptr)) * chysize
           oa&(strptr) = oa&(strptr - 1) + CLNG(vesainfo.bytespixel) * (scrxsize + chspacing)
           ea&(strptr) = oa&(strptr) + vesainfo.bytespixel * (scrxsize - 1)
        NEXT
        YEndPos = ystartpos + scrysize - 1
        ystep = chysize - 1
        xstep = chxsize - 1
        Ycounter = -scrysize: chbyteptr = 0: lyptr = chbyteptr - 1
        'bresenham*2
        DEF SEG = Fontseg
        FOR strptr = 1 TO LEN(t$)
          ta(strptr) = PEEK(t1a&(strptr) + chbyteptr)
        NEXT
        FOR pixely = ystartpos TO YEndPos
                
                IF ybank(pixely) <> curbank THEN
                    regs.ax = &H4F05
                    regs.bx = 0
                    regs.dx = ybank(pixely)
                    CALL INTERRUPTy(&H10, regs)
                    curbank = ybank(pixely)
                END IF
                Ycounter = Ycounter + ystep
                WHILE Ycounter >= 0
                        Ycounter = Ycounter - scrysize: chbyteptr = chbyteptr + 1
                        IF lyptr <> chbyteptr THEN
                                DEF SEG = Fontseg
                                FOR strptr = 1 TO LEN(t$)
                                  ta(strptr) = PEEK(t1a&(strptr) + chbyteptr)
                                NEXT
                                lyptr = chbyteptr
                        END IF
                WEND
                DEF SEG = yseg(pixely)
                FOR strptr = 1 TO LEN(t$)
                        chbitptr = 7: XCounter = -scrxsize
                        x = x1
                        FOR x = oa&(strptr) TO ea&(strptr) STEP vesainfo.bytespixel
                                IF (ta(strptr) AND PwrsOf2(chbitptr)) THEN
                                    SELECT CASE vesainfo.bpp
                                    CASE 32, 24
                                        POKE x + 2, r
                                        POKE x + 1, g
                                        POKE x, b
                                    CASE 15, 16
                                        a = rlook(r) OR g2look(g)
                                        a1 = glook(g) OR blook(b)
                                        POKE x, a1: POKE x + 1, a
                                    CASE 8
                                        POKE x, rlook(r) OR glook(g) OR blook(b)
                                    CASE ELSE
                                    END SELECT
                                END IF
                                XCounter = XCounter + xstep
                                WHILE XCounter >= 0
                                        XCounter = XCounter - scrxsize: chbitptr = chbitptr - 1
                                WEND
                        NEXT
                NEXT
        NEXT
        ERASE t1a&, ta, oa&, ea&
END SUB

FUNCTION SVGASelectMode%
'user interface to allow user to select a SVGA mode.
'only modes allowing optimal line length ar proposed.
'For B/W images, only 8 bits modes are proposed.

SHARED f$
SHARED vesainfo AS vesainfoblock
SHARED display AS vesaModeinfoBlock
SHARED jpeg AS JpegType
CLS
PRINT "The file "; f$; " is "; jpeg.cols; " X "; jpeg.rows
PRINT
PRINT "Available VESA modes. * signals those displaying the whole picture "
COLOR 4, 0
PRINT "Be careful! Some resolution-refresh combinations could damage your monitor!"
PRINT "This program can't guess which which refresh rate each mode will use,so... "
PRINT ">>>>>>>>>>>>>   Use highest resolutions at your own risk!   <<<<<<<<<<<<<<<"
PRINT "If your monitor behaves strangely ";
COLOR 15, 4: PRINT "PRESS ESCAPE";
COLOR 4, 0: PRINT " key inmediately!!      "
COLOR 7, 0
PRINT
REDIM modes&(1 TO vesainfo.modemax)
x = 1
FOR i = 1 TO vesainfo.modemax
    'get mode numbers string
    DEF SEG = vesainfo.VIDEOMODESEG
    ptr1 = vesainfo.VIDEOMODEPTR
    ii = 2 * i - 2
    md& = PEEK(ptr1 + ii + 1) * 256& + PEEK(ptr1 + ii)
    DEF SEG
    'get info about current mode
    SVGAGetModeInfo (md&)
    IF display.Modeattributes AND 1 THEN
        
        SELECT CASE ASC(display.MemoryModel)
        CASE 4       '8 bit PALETTED MODE
            GOSUB enoughmem
            IF fit THEN
                LOCATE , 20: PRINT USING "! ##.- MODE \ \H  #### x #### x ## "; jfit$; x; HEX$(md&); display.xres; display.yres; ASC(display.bpp)
                modes&(x) = md&: x = x + 1
            END IF
        CASE 6       'TRUECOLOR MODE
            
            IF jpeg.numcomp > 1 THEN   'no color modes for monochrome images
                GOSUB enoughmem
                IF fit THEN
                   GOSUB jpegfits
                   LOCATE , 20: PRINT USING "! ##.- MODE \ \H  #### x #### x ## "; jfit$; x; HEX$(md&); display.xres; display.yres; ASC(display.bpp)
                    modes&(x) = md&: x = x + 1
                END IF
            END IF
        CASE ELSE
        END SELECT
    END IF
NEXT
x = x - 1
COLOR 15, 0
DO
LOCATE , 22: INPUT "Select a mode: ", K
LOOP UNTIL K > 0 AND K <= x
md = modes&(K)
ERASE modes&


fail = SVGAsetmode(md)

EXIT FUNCTION

'checks if the selected mode will fit into the available memory when the
'optimal line length is selected. If not, mode is discarded.

enoughmem:
    bytespixel = (ASC(display.bpp) + 7) \ 8
    IF bytespixel = 3 THEN factor = 4096 ELSE factor = 128
    a = 1
    a1 = bytespixel * display.xres
    DO UNTIL a * factor >= a1
        a = a * 2
    LOOP
    linelen& = a * factor
    IF vesainfo.totalmemory * 65536 >= linelen& * display.yres THEN fit = -1 ELSE fit = 0


RETURN

jpegfits:
    jfit$ = " "
    IF jpeg.cols > display.xres THEN RETURN
    IF jpeg.rows > display.yres THEN RETURN
    jfit$ = "*"
RETURN

END FUNCTION

FUNCTION SVGAsetmode (mode)
'Sets the VESA mode passed, selects the faster line length and
'initializes the look up tables for this mode.


SHARED rlook(), glook(), blook(), g2look()
SHARED xoff(), yseg(), ybank()
SHARED vesainfo AS vesainfoblock
SHARED display AS vesaModeinfoBlock
SHARED jpeg AS JpegType
SHARED regs AS regtypeX
' Sets an SVGA mode, and saves some useful parameters

    regs.ax = &H4F02  'Set the mode.
    regs.bx = mode
    CALL INTERRUPTy(&H10, regs)
    IF regs.ax <> &H4F THEN SVGAsetmode = 0: EXIT FUNCTION

    'if returning to text mode, do it and exit
    IF mode = 3 THEN
        SCREEN 7: WIDTH 80, 50: CLS
        EXIT FUNCTION
    END IF
    SVGAGetModeInfo (mode)
    vesainfo.modenum = mode
    vesainfo.xres = display.xres
    vesainfo.yres = display.yres
    vesainfo.bpp = ASC(display.bpp)
   
    

    vesainfo.winsize = 1024& * display.winsize
    vesainfo.WINMASK = vesainfo.winsize - 1
    vesainfo.winseg = display.winAsegment
    vesainfo.bw = false
    vesainfo.numberofbanks = (vesainfo.BYTESROW * vesainfo.yres) \ vesainfo.winsize + 1
   
    vesainfo.charx = vesainfo.xres \ 90: IF vesainfo.charx < 4 THEN vesainfo.charx = 4
    vesainfo.chary = vesainfo.yres \ 30: IF vesainfo.chary < 5 THEN vesainfo.chary = 5
    

    'calculate line length
    vesainfo.bytespixel = (vesainfo.bpp + 7) \ 8
   
    IF vesainfo.bytespixel = 3 THEN factor = 4096 ELSE factor = 128
    a = 1
    a1 = vesainfo.bytespixel * vesainfo.xres
    DO UNTIL a * factor >= a1
        a = a * 2
    LOOP
    linelen& = a * factor / vesainfo.bytespixel
   
    regs.ax = &H4F06  'Set line length
    regs.bx = 0
    regs.dx = 0
    regs.cx = linelen&
    CALL INTERRUPTy(&H10, regs)
    IF regs.cx <> linelen& THEN Setsvgamode = 0: END
    vesainfo.BYTESROW = linelen& * vesainfo.bytespixel

    SVGAsetmode = 1
    
    IF (vesainfo.bytespixel = 1) AND (jpeg.numcomp > 1) THEN
        GOSUB setaproxpal
    ELSEIF jpeg.numcomp = 1 THEN
        GOSUB setgreypal: vesainfo.bw = true
    END IF
    
    'make color lookup tables
    SELECT CASE vesainfo.bpp
    CASE 16
    FOR i% = 0 TO 255
        blook(i%) = i% \ 8
        glook(i%) = (i% AND &H38) * 8
        g2look(i%) = i% \ 32
        rlook(i%) = i% AND &HF8
    NEXT
    CASE 15
    FOR i% = 0 TO 255
        blook(i%) = i% \ 8
        glook(i%) = (i% AND &H38) * 4
        g2look(i%) = i% \ 64
        rlook(i%) = (i% \ 2) AND &H7C
    NEXT
    CASE 8
    FOR i% = 0 TO 255
        blook(i%) = i% \ 64
        glook(i%) = i% \ 8 AND &H1C
        rlook(i%) = i% AND &HE0
    NEXT
    CASE ELSE
    END SELECT
   
    'create line lookup tables
    'REDIM yseg%(0 TO vesainfo.yres), ybank%(0 TO vesainfo.yres)
    FOR i = 0 TO vesainfo.yres
        yseg(i) = &HA000 + ((i * vesainfo.BYTESROW) AND vesainfo.WINMASK) \ 16
        ybank(i) = (i * CLNG(vesainfo.BYTESROW)) \ vesainfo.winsize
    NEXT

    'REDIM xoff(0 TO vesainfo.xres)
    FOR i = 0 TO vesainfo.xres
        xoff(i) = i * vesainfo.bytespixel
    NEXT

EXIT FUNCTION


setgreypal:
OUT &H3C8, 0            'create the greyscale palette
FOR i1 = 0 TO 255
 TEMP = i1 \ 4
 OUT &H3C9, TEMP
 OUT &H3C9, TEMP
 OUT &H3C9, TEMP
NEXT
RETURN


setaproxpal:
'create approximative color palette
OUT &H3C8, 0
FOR i1 = 0 TO 7
 FOR j1 = 0 TO 7
  FOR K1 = 0 TO 3
   OUT &H3C9, i1 * 8
   OUT &H3C9, j1 * 8
   OUT &H3C9, K1 * 16
  NEXT
 NEXT
NEXT
RETURN


END FUNCTION

