DECLARE SUB CalculateRegion (sizex%, sizey%, left%, top%, right%, bottom%)
' Sample program using the CPUT routine. The routine is a replacement
' (it does call PUT!) for PUT, that allows the image to be partially,
' or fully offscreen. This way, you won't get the Illegal Function Call
' error when you try to PUT an image that does not fit on the screen.

' you are free to use this program/routine as you see fit, as long as
' you don't sell it as is. If you do use this routine, I would appreciate
' it, if you give me credit. And please e-mail me on how you like it!

' Lennaert van der Linden. July 26th 1999. Please e-mail me any questions
' or comments on this program at : luckyone@xs4all.nl

' *** UPDATE November 13th 2000
' now added CPutRgn routine, this routine also accepts the region at
' which the image is clipped (as apposed to the full screen).

DECLARE SUB CPutRgn (x%, y%, sprite() AS INTEGER, offset%, mode%, left%, top%, right%, bottom%)
DECLARE SUB DrawAndGetSprites (aSprite%(), aMask%())
DECLARE SUB CPut (x%, y%, sprite() AS INTEGER, offset%, mode%)
DECLARE SUB MemCopy (fromseg%, fromoffset%, toseg%, tooffset%, bytes%)

CONST cPSET = 0, cPRESET = 1, cAND = 2, cOR = 3, cXOR = 4

DEFINT A-Z

SCREEN 13: CLS

' create a sample sprites with a masks
DIM aSprite(11913) AS INTEGER '(holds 3 sprites)
DIM aMask(11913) AS INTEGER   '(holds 3 sprites)

DrawAndGetSprites aSprite(), aMask()

CLS

RANDOMIZE TIMER

sizex% = 200
sizey% = 120
maxsizex% = 320
maxsizey% = 200

CalculateRegion sizex%, sizey%, left%, top%, right%, bottom%

userQuit% = 0
DO WHILE NOT userQuit%
	x% = -60 + RND * 380: y% = -60 + RND * 260 ' random coordinates
	object% = INT(RND * 3) * 3971              ' random object
	WAIT &H3DA, 8                              ' wait for vertical resync
	CPutRgn x%, y%, aMask(), object, cAND, left%, top%, right%, bottom%   ' put mask
	CPutRgn x%, y%, aSprite(), object, cXOR, left%, top%, right%, bottom% ' put sprite

	aKey$ = INKEY$
	SELECT CASE aKey$
		CASE "+"
			sizex% = sizex% + 32
			sizey% = sizey% + 20
			IF (sizex% > maxsizex%) THEN sizex% = maxsizex%
			IF (sizey% > maxsizey%) THEN sizey% = maxsizey%
			CalculateRegion sizex%, sizey%, left%, top%, right%, bottom%
			LINE (0, 0)-(319, 199), 1, BF
			LINE (left%, top%)-(right%, bottom%), 0, BF
		CASE "-"
			sizex% = sizex% - 32
			sizey% = sizey% - 20
			IF (sizex% <= 0) THEN sizex% = 1
			IF (sizey% <= 0) THEN sizey% = 1
			CalculateRegion sizex%, sizey%, left%, top%, right%, bottom%
			LINE (0, 0)-(319, 199), 1, BF
			LINE (left%, top%)-(right%, bottom%), 0, BF
		CASE "*"
			left% = INT(RND * (320 - sizex%))
			top% = INT(RND * (200 - sizey%))
			right% = left% + sizex% - 1
			bottom% = top% + sizey% - 1
			LINE (0, 0)-(319, 199), 1, BF
			LINE (left%, top%)-(right%, bottom%), 0, BF
		CASE CHR$(27)
			userQuit = -1
	END SELECT
LOOP

SUB CalculateRegion (sizex%, sizey%, left%, top%, right%, bottom%)
	' calculates the region according to the given size (sizex%, sizey%)
	' the region is position in the middle
	left% = 160 - ((sizex% + 1) \ 2)
	top% = 100 - ((sizey% + 1) \ 2)
	right% = left% + sizex% - 1
	bottom% = top% + sizey% - 1
END SUB

SUB CPut (x%, y%, sprite() AS INTEGER, offset%, mode%)
	' Updated from version 1.0, see CPutRgn for more notes
	CPutRgn x%, y%, sprite(), offset%, mode%, 0, 0, 319, 199
END SUB

DEFSTR A-Z
SUB CPutRgn (x%, y%, sprite() AS INTEGER, offset%, mode%, left%, top%, right%, bottom%)
' Version 1.0 - July 26th 1999, Lennaert van der Linden

' the CPut routine. A replacement for PUT, that does not demand that
' the image fits entirely on the screen. The part that does not fit
' is clipped (as in Clipped PUT), the rest is displayed using PUT.
' This routine uses the MemCopy routine by Jonathan L. Leger.
' See the CPut.txt file for more information on usage and working.

' You may use this routine as you see fit, except sell it as is.
' If you do use it, I would appreciate it if you give me credit.
' Please e-mail me any comments and questions at : luckyone@xs4all.nl

' mode: 0 = PSET
'       1 = PRESET
'       2 = AND
'       3 = OR
'       4 = XOR

' *** UPDATE version 1.1 - November 13th 2000, Lennaert van der Linden
' This is a patched version from the original CPut, that also accepts
' the region to which the image is clipped (defined by the parameters
' left%, top%, right% and bottom%). If the parameters are incorrect,
' left% is greater than right% or top% is greater than bottom%, the
' sub exits without doing anything

IF (left% > right%) OR (top% > bottom%) THEN EXIT SUB

'** the variables that are used
DIM x1%, y1%, ll%, lx%, uy%, rx%, ly%, row%, i1%, i2%, ll2%

'** if the upperleft corner is below or next to the right of the
'** screen, it's not visible
IF x% > right% OR y% > bottom% THEN EXIT SUB

'** determine lowerright corner position
x1% = x% + (sprite(offset%) \ 8) - 1
y1% = y% + sprite(offset% + 1) - 1
ll% = (sprite(offset%) \ 8) ' length of a row in the sprite

'** if the lowerright corner is above or to the left of the
'** screen, it's not visible
IF x1% < left% OR y1% < top% THEN EXIT SUB

IF x% >= left% AND y% >= bottom% AND x1% <= right% AND y1% <= bottom% THEN
	'** We don't have to clip! We can just use PUT with the sprite
	SELECT CASE mode%
		CASE 0: PUT (x%, y%), sprite(offset%), PSET
		CASE 1: PUT (x%, y%), sprite(offset%), PRESET
		CASE 2: PUT (x%, y%), sprite(offset%), AND
		CASE 3: PUT (x%, y%), sprite(offset%), OR
		CASE 4: PUT (x%, y%), sprite(offset%), XOR
	END SELECT
ELSE
	'** We have to build a new sprite that only contains the part
	'** visible on the screen, we can then use PUT with the new sprite
	xo% = x%: yo% = y%
	lx% = 0: uy% = 0
	rx% = ll% - 1: ly% = sprite(1) - 1
	IF xo% < left% THEN lx% = left% - x%: xo% = left%
	IF yo% < top% THEN uy% = top% - y%: yo% = top%
	IF x1% > right% THEN rx% = rx% - x1% + right%
	IF y1% > bottom% THEN ly% = ly% - y1% + bottom%
	'** we now have the upperleft coordinate of the new sprite
	'** (xo%, yo%), we now the upperleft offset (lx%, uy%) and
	'** the lowerright offset (rx%, ly%). We can construct the
	'** new sprite and copy the necessary pixels from the old
	'** sprite. We only have to calculate the size.
	ll2% = (rx% - lx% + 1)
	DIM newSprite(ll2% * (ly% - uy% + 1) + 1) AS INTEGER
	newSprite(0) = ll2% * 8
	newSprite(1) = (ly% - uy% + 1)
	'** the new sprite is all set up, now we can copy pixels.
	'** we'll use the memcopy routine for speed and copy
	'** one row at a time.
	i1% = VARPTR(sprite(offset% + 2)) + uy% * ll%: i2% = VARPTR(newSprite(2))
	FOR row% = 0 TO (ly% - uy%)
		MemCopy VARSEG(sprite(0)), i1% + lx%, VARSEG(newSprite(0)), i2%, ll2%
		i1% = i1% + ll%
		i2% = i2% + ll2%
	NEXT row%
	'** all done, we can now PUT the new sprite
	SELECT CASE mode%
		CASE 0: PUT (xo%, yo%), newSprite, PSET
		CASE 1: PUT (xo%, yo%), newSprite, PRESET
		CASE 2: PUT (xo%, yo%), newSprite, AND
		CASE 3: PUT (xo%, yo%), newSprite, OR
		CASE 4: PUT (xo%, yo%), newSprite, XOR
	END SELECT
END IF
END SUB

DEFINT A-Z
SUB DrawAndGetSprites (aSprite%(), aMask%())
' this routine fills the arrays with some sample sprites
' and there masks. The masks are used to avoid the "black
' rectangle" around the sprite when you use PUT with PSET.

' sprite 1 (ball)
FOR s = 31 TO 1 STEP -1: CIRCLE (31, 31), s, 31 - s \ 2: PAINT (31, 31), 31 - s \ 2: NEXT s
GET (0, 0)-(62, 62), aSprite(0)
LINE (0, 0)-(62, 62), 255, BF
CIRCLE (31, 31), 31, 0: PAINT (31, 31), 0
GET (0, 0)-(62, 62), aMask(0)

' sprite 2 (cone)
LINE (0, 0)-(62, 62), 0, BF
FOR x = 1 TO 61: LINE (x, 62)-(31, 0), 31 - ABS(x - 32) \ 2: NEXT x
LINE (0, 62)-(31, 0), 0: LINE -(62, 62), 0: LINE -(0, 62), 0
GET (0, 0)-(62, 62), aSprite(3971)
LINE (0, 0)-(62, 62), 255, BF: LINE (0, 62)-(31, 0), 0: LINE -(62, 62), 0
LINE -(0, 62), 0: PAINT (31, 31), 0
GET (0, 0)-(62, 62), aMask(3971)

' sprite 3 (rhomb)
PALETTE 255, 40
LINE (0, 0)-(62, 62), 0, BF
FOR x = 0 TO 15
	LINE (x, 31 + x)-(x + 31, x), 16 + x
	LINE (x + 1, 31 + x)-(x + 32, x), 16 + x
	LINE (x + 16, 31 + x + 16)-(x + 47, x + 16), 31 - x
	LINE (x + 17, 31 + x + 16)-(x + 48, x + 16), 31 - x
NEXT x
LINE (31, 0)-(62, 31), 0: LINE -(31, 62), 0: LINE -(0, 31), 0: LINE -(31, 0), 0
LINE (32, 0)-(62, 30), 0: LINE (62, 32)-(32, 62), 0
GET (0, 0)-(62, 62), aSprite(7942)
LINE (0, 0)-(62, 62), 255, BF
LINE (31, 0)-(62, 31), 0: LINE -(31, 62), 0: LINE -(0, 31), 0: LINE -(31, 0), 0
PAINT (31, 31), 0
GET (0, 0)-(62, 62), aMask(7942)

END SUB

SUB MemCopy (fromseg%, fromoffset%, toseg%, tooffset%, bytes%)
'===========================================================================
' Subject: PATCHED MEMCOPY ROUTINE           Date: 02-27-98 (00:57)
'  Author: Jonathan L. Leger                 Code: QB, QBasic, PDS
'  Origin: leger@earthlink.net             Packet: MEMORY.ABC
'===========================================================================
'*** put the InitMemCopy routine inside the MemCopy routine (Juli 26 1999)
'*** Lennaert van der Linden

STATIC MemCopy.ASM AS STRING
STATIC initDone AS INTEGER

IF NOT initDone THEN
	MemCopy.ASM = ""
	MemCopy.ASM = MemCopy.ASM + CHR$(85)                             'PUSH BP
	MemCopy.ASM = MemCopy.ASM + CHR$(137) + CHR$(229)                'MOV BP,SP
	MemCopy.ASM = MemCopy.ASM + CHR$(30)                             'PUSH DS
	MemCopy.ASM = MemCopy.ASM + CHR$(139) + CHR$(70) + CHR$(10)      'MOV AX,[BP+0A]
	MemCopy.ASM = MemCopy.ASM + CHR$(142) + CHR$(192)                'MOV ES,AX
	MemCopy.ASM = MemCopy.ASM + CHR$(139) + CHR$(70) + CHR$(14)      'MOV AX,[BP+0E]
	MemCopy.ASM = MemCopy.ASM + CHR$(142) + CHR$(216)                'MOV DS,AX
	MemCopy.ASM = MemCopy.ASM + CHR$(139) + CHR$(118) + CHR$(12)     'MOV SI,[BP+0C]
	MemCopy.ASM = MemCopy.ASM + CHR$(139) + CHR$(126) + CHR$(8)      'MOV DI,[BP+08]
	MemCopy.ASM = MemCopy.ASM + CHR$(139) + CHR$(78) + CHR$(6)       'MOV CX,[BP+06]
	MemCopy.ASM = MemCopy.ASM + CHR$(243)                            'REPZ
	MemCopy.ASM = MemCopy.ASM + CHR$(164)                            'MOVSB
	MemCopy.ASM = MemCopy.ASM + CHR$(31)                             'POP DS
	MemCopy.ASM = MemCopy.ASM + CHR$(93)                             'POP BP
	MemCopy.ASM = MemCopy.ASM + CHR$(203)                            'RETF
	initDone = -1
END IF

DEF SEG = VARSEG(MemCopy.ASM)
	CALL Absolute(BYVAL fromseg%, BYVAL fromoffset%, BYVAL toseg%, BYVAL tooffset%, BYVAL bytes%, SADD(MemCopy.ASM))
DEF SEG

END SUB

