' 24to8 by Urlofus
' Vortex Illusions
' urlofus@uol.com.ar

' This is a very fast release that I'll use for my games, it's got several
' errors, week points and It's very slow. Sorry.

' The program converts a 24 bits BMP file into an 8 bits BMP file using
' a palette identic to the one under Screen 13. Modify it as you wish.

DECLARE SUB CheckError ()
DECLARE SUB Convert ()
DECLARE SUB PutPalette ()
DECLARE SUB PutInfo ()

TYPE BMPType
  Sign AS STRING * 2
  Size AS LONG
  Reserved1 AS INTEGER
  Reserved2 AS INTEGER
  OffsetBits AS LONG
  SizeInfoHeader AS LONG
  BmpW AS LONG
  BmpH AS LONG
  Planes AS INTEGER
  BitCount AS INTEGER
  Compression AS LONG
  ImageSize AS LONG
  XRes AS LONG
  YRes AS LONG
  ColIndices AS LONG
  ImportantColIndices AS LONG
END TYPE

DIM SHARED File1 AS BMPType
DIM SHARED File2 AS BMPType
DIM SHARED Byte AS STRING * 1
DIM SHARED Red(256) AS INTEGER
DIM SHARED Green(256) AS INTEGER
DIM SHARED Blue(256) AS INTEGER

CLS

INPUT "24 bits BMP file to open: ", F1$
INPUT "8 bits file output: ", F2$

IF INSTR(F1$, ".") = 0 THEN F1$ = F1$ + ".bmp"
IF INSTR(F2$, ".") = 0 THEN F2$ = F2$ + ".bmp"

OPEN F1$ FOR BINARY AS #1

IF LOF(1) = 0 THEN
  CLOSE
  KILL F1$
  PRINT "Input file doesn't exist"
  SYSTEM
END IF

OPEN F2$ FOR BINARY AS #2

GET #1, , File1

IF File1.Sign <> "BM" THEN
  CLOSE
  KILL F2$
  PRINT "Input file is not a BMP file"
  SYSTEM
ELSEIF File1.OffsetBits <> 54 OR File1.SizeInfoHeader <> 40 THEN
  CLOSE
  KILL F2$
  PRINT "Sorry, BMP file incompatible with this version"
  SYSTEM
END IF

PutInfo
PutPalette
Convert

CLOSE

SUB Convert
  DIM Dat(256) AS INTEGER
  DummyF1% = ABS(INT(-File1.BmpW * 3 / 4)) * 4 - File1.BmpW * 3
  DummyF2% = ABS(INT(-File2.BmpW / 4)) * 4 - File2.BmpW

  PRINT "Please wait..."
 
  FOR A% = 1 TO File1.BmpH
    FOR B% = 1 TO File1.BmpW
      GET #1, , Byte
      Bl% = ASC(Byte)
      GET #1, , Byte
      Gr% = ASC(Byte)
      GET #1, , Byte
      Re% = ASC(Byte)
      FOR C% = 0 TO 255
        Dat(C%) = ABS(Red(C%) - Re%) + ABS(Green(C%) - Gr%) + ABS(Blue(C%) - Bl%)
      NEXT C%
      temp% = Dat(0)
      temp2% = 0
      FOR C% = 1 TO 255
        IF temp% > Dat(C%) THEN
          temp% = Dat(C%)
          temp2% = C%
        END IF
      NEXT C%
      Byte = CHR$(temp2%)
      PUT #2, , Byte
    NEXT B%
    FOR B% = 1 TO DummyF1%
      GET #1, , Byte
    NEXT B%
    FOR B% = 1 TO DummyF2%
      PUT #2, , Byte
    NEXT B%
  NEXT A%
END SUB

SUB PutInfo
  File2.Sign = "BM"
  File2.OffsetBits = 1078
  File2.SizeInfoHeader = 40
  File2.BmpW = File1.BmpW
  File2.BmpH = File1.BmpH
  File2.Planes = 1
  File2.BitCount = 8
  File2.XRes = File1.XRes
  File2.YRes = File1.YRes
  File2.ImageSize = ABS(INT(-File2.BmpW / 4)) * 4 * File2.BmpH
  File2.Size = File2.ImageSize + File2.OffsetBits
 
  PUT #2, , File2
END SUB

SUB PutPalette
  SCREEN 13
  OUT &H3C7, 0
  FOR A% = 0 TO 255
    Red(A%) = INP(&H3C9) * 4
    Green(A%) = INP(&H3C9) * 4
    Blue(A%) = INP(&H3C9) * 4
  NEXT A%
  FOR A% = 0 TO 255
    temp$ = CHR$(Blue(A%))
    PUT #2, , temp$
    temp$ = CHR$(Green(A%))
    PUT #2, , temp$
    temp$ = CHR$(Red(A%))
    PUT #2, , temp$
    PUT #2, , Byte
  NEXT A%
END SUB

