DECLARE SUB LoopMidi ()
DECLARE SUB Options ()
DECLARE SUB Pause ()
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE SUB MissionSuccess ()
DECLARE SUB MissionFailed ()
DECLARE SUB CheckMissionObjectives ()
DECLARE SUB CleanUpMIDI ()
DECLARE SUB UnloadMIDI (Handle%)
DECLARE SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
DECLARE SUB PlayMIDI (Handle%)
DECLARE SUB StopMIDI ()
DECLARE FUNCTION GetSynth% ()
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE FUNCTION LoadMIDI% (FileName$)
DECLARE FUNCTION MemUsed& (Handle%)
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MusicDone% ()
DECLARE FUNCTION TimeMIDI! ()
DECLARE SUB CreateExplosion (H!, V!, t%)
DECLARE SUB Galatian ()
DECLARE SUB Lystra ()
DECLARE SUB Quit ()
DECLARE SUB CreateMissile (HPos!, VPos!, Tar%, Dir%, typ%)
DECLARE SUB MovePlayer (pl%, u$)
DECLARE SUB Explosions ()
DECLARE SUB PutShip (n%)
DECLARE SUB MoveAI (n%)
DECLARE SUB MoveMissiles ()
DECLARE SUB MoveShips ()
DECLARE SUB LoadMap (map$)
DECLARE SUB Intro ()
DECLARE SUB Menu ()
DECLARE SUB Engine ()
DECLARE SUB LoadGFX ()
DECLARE SUB LoadData ()

'$DYNAMIC
'$INCLUDE: 'DirectQB.bi'
'$INCLUDE: 'star.bi'
RANDOMIZE TIMER
dummy& = SETMEM(-10000)

LoadData
Mission = 1

CLS
IF DQBinit(3, 5, 0) THEN DQBclose: PRINT DQBerror$: END
IF DQBinstallSB(FALSE, 4, 22050, AUTO, AUTO, AUTO) THEN DQBclose: PRINT DQBerror$: END
IF NOT DQBmouseDetected THEN DQBclose: PRINT DQBerror$: END
DQBinitVGA

LoadGFX

Intro
Menu

REM $STATIC
SUB CheckMissionObjectives

IF MisObj.ld = 1 OR MisObj.wd = 1 THEN MisObj.waitabit = MisObj.waitabit + 1
IF MisObj.ld AND MisObj.waitabit > 250 THEN MissionFailed
IF MisObj.wd AND MisObj.waitabit > 250 THEN MissionSuccess
IF Ship(1).Alive = 0 THEN MisObj.ld = 1

SELECT CASE MisObj.w
   CASE 1
      IF Ship(MisObj.wa).Alive = 0 THEN MisObj.wd = 1
   CASE 2
      IF Ship(MisObj.wa).OffMap > 0 THEN MisObj.wd = 1
END SELECT

SELECT CASE MisObj.l
   CASE 1
      IF Ship(MisObj.la).OffMap > 0 THEN MisObj.ld = 1
   CASE 2
      IF Ship(MisObj.la).Alive = 0 THEN MisObj.ld = 1
END SELECT

END SUB

REM $DYNAMIC
DEFSNG A-Z
SUB CleanUpMIDI
FOR i% = 0 TO 255
	IF MEM.SEGMENT(i%) THEN UnloadMIDI i%
NEXT i%
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB CreateExplosion (H!, V!, t%)

SELECT CASE t%

   CASE 1
      DQBplaySound 1, 1, 22050, ONCE

   CASE 2
      DQBplaySound 1, 1, 22050, ONCE

END SELECT

FOR n% = 1 TO 20
   IF Explosion(n%).True = 0 THEN
      Explosion(n%).True = -1
      Explosion(n%).HPos = H!
      Explosion(n%).VPos = V!
      Explosion(n%).Frame = 1
      GOTO FoundExplosion
   END IF
NEXT n%

Explosion(1).True = -1
Explosion(1).HPos = H!
Explosion(1).VPos = V!
Explosion(1).Frame = 1

FoundExplosion:

END SUB

SUB CreateMissile (HPo!, VPo!, Tar, Dir, typ)

FOR n% = 1 TO 50
   IF Missile(n%).Dead = 0 THEN
      Missile(n%).Dead = -1
      Missile(n%).HPos = HPo!
      Missile(n%).VPos = VPo!
      Missile(n%).Target = Tar
      Missile(n%).Direction = Dir
      Missile(n%).Timeleft = 0
      Missile(n%).Types = typ
      GOTO FoundMissile
   END IF
NEXT n%
    
FoundMissile:

END SUB

REM $DYNAMIC
DEFSNG A-Z
'DriversLoaded - Attempt to detect if sound drivers are loaded
SUB DriversLoaded (SBMIDI%, SBSIM%)
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
NoExist% = 0
'If the file is empty, return an error.
IF FileSize& = 0 THEN
	CLOSE FF%
	KILL "DRIVERS.DAT"
	MIDI.ERROR = 1
	NoExist% = 1
'If the file is not exactly 1,024 bytes in size, return an error.
ELSEIF FileSize& <> 1024 THEN
	CLOSE FF%
	MIDI.ERROR = 9
	NoExist% = 1
END IF

'If DRIVERS.DAT exists, and is 1 kilobyte in size, read the driver
'data from it.
IF NoExist% = 0 THEN
REDIM DRIVERDATA$(1 TO 5)
FOR i% = 1 TO 4
	DRIVERDATA$(i%) = INPUT$(256, #FF%)
NEXT i%
END IF

'Close the data file.
CLOSE #FF%

'Check the interrupt handlers for int 80h-FFh, to see if they are occupied
'by either SBMIDI or SBSIM.
SBMIDI% = 0
SBSIM% = 0
FOR i% = &H80 TO &HFF
	'Get the address of the interrupt handler.
	InternalGetIntVector i%, Segment&, Offset&
	'If the segment returned is 0, that means that the current interrupt
	'is not in use.
	IF Segment& = 0 THEN GOTO Skip:

	'The following code checks for the drivers by looking for the text
	'"SBMIDI" and "SBSIM" at certain locations in the driver code.
	'If it doesn't work, a different method is used.
	IF SBMIDI% = 0 THEN
	  DEF SEG = Segment& - 17
	  TEMP$ = ""
	  FOR J% = 1 TO 6
		TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
	  NEXT
	  IF TEMP$ = "SBMIDI" THEN SBMIDI% = i%
	END IF
	IF SBSIM% = 0 AND Segment& <> 0 THEN
		DEF SEG = Segment& - 1
		TEMP$ = ""
		FOR J% = 1 TO 5
			TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
		NEXT
		IF TEMP$ = "SBSIM" THEN SBSIM% = i%
	END IF
 
	'This is the second detection method.  It's more complex than the first
	'method, but not really any more accurate.
	IF NoExist% = 0 THEN
	'Point to the segment of the interrupt handler.
	DEF SEG = Segment&
	'Read 256 bytes of code from the interrupt handler.
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		Byte% = PEEK(Offset& + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
	NEXT J%
	'Check to see if the code matches any of the data from DRIVERS.DAT.
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR k% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), k% + 1, 1) <> MID$(DRIVERDATA$(5), k% + 1, 1) THEN
				SELECT CASE k%
					CASE IS = 14, 15, 113, 114, 235, 236
					CASE ELSE
						MATCH% = 0
						EXIT FOR
				END SELECT
			END IF
		NEXT k%
		'If there was a match, find out which driver is using the interrupt.
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = i%
			IF J% <> 1 THEN SBMIDI% = i%
		END IF
		'If both SBMIDI and SBSIM have been found, exit the loop.
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
   
	'If both SBMIDI and SBSIM have been found, exit the loop.
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	END IF
Skip:
NEXT i%
IF NoExist% = 0 THEN MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB Engine

DQBsetClipBox 1, 1, 319, 199
DQBsetCollideMethod PIXEL

DO
u$ = ""
  WHILE u$ = ""
     u$ = INKEY$

     FOR n% = 1 TO AmountOfShips
	IF Ship(n%).Alive = -1 THEN PutShip n%
     NEXT
    
     FOR n% = 1 TO AmountOfShips
	IF Ship(n%).Control = 0 AND Ship(n%).Alive = -1 THEN MoveAI n%
     NEXT

     MoveShips
    
     MoveMissiles
    
     Explosions

     CheckMissionObjectives

     FOR n% = 1 TO AmountOfShips
	IF Ship(n%).FiringDelay > 0 THEN Ship(n%).FiringDelay = Ship(n%).FiringDelay - 1
     NEXT

     'DQBprint 1, STR$(Ship(2).Target), 1, 1, 13
     'DQBwait 1

     DQBcopyLayer 1, VIDEO
     DQBcopyLayer 2, 1
    
  WEND
SELECT CASE LCASE$(u$)

  CASE CHR$(27)
  Pause

  CASE "8", "4", "6", "5", "+"
  IF Ship(1).Alive = -1 THEN MovePlayer 1, u$

  CASE "w", "s", "a", "d", CHR$(9)
  IF Ship(2).Alive = -1 THEN MovePlayer 2, u$
 
END SELECT

LOOP

END SUB

SUB Explosions

FOR n% = 1 TO 20
   IF Explosion(n%).True = -1 THEN
     
      SELECT CASE Explosion(n%).Frame
	 CASE 1 TO 2
	 DQBput 1, Explosion(n%).HPos, Explosion(n%).VPos, VARSEG(exps1(0)), VARPTR(exps1(0))
	 CASE 2 TO 3
	 DQBput 1, Explosion(n%).HPos, Explosion(n%).VPos, VARSEG(exps2(0)), VARPTR(exps2(0))
	 CASE 3 TO 4
	 DQBput 1, Explosion(n%).HPos, Explosion(n%).VPos, VARSEG(exps3(0)), VARPTR(exps3(0))
	 CASE 4 TO 5
	 DQBput 1, Explosion(n%).HPos, Explosion(n%).VPos, VARSEG(exps4(0)), VARPTR(exps4(0))
	 CASE 5 TO 6
	 DQBput 1, Explosion(n%).HPos, Explosion(n%).VPos, VARSEG(exps5(0)), VARPTR(exps5(0))
	 CASE 6 TO 7
	 DQBput 1, Explosion(n%).HPos, Explosion(n%).VPos, VARSEG(exps6(0)), VARPTR(exps6(0))
      END SELECT
     
      Explosion(n%).Frame = Explosion(n%).Frame + .2
      IF Explosion(n%).Frame > 7 THEN Explosion(n%).True = 0
   END IF
NEXT n%
END SUB

SUB Galatian

END SUB

DEFSNG A-Z
FUNCTION GetSynth%
QMIDIRegs.BX = 10
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
GetSynth% = QMIDIRegs.AX
END FUNCTION

REM $DYNAMIC
SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
Segment& = QMIDIRegs.ES
Offset& = QMIDIRegs.BX
END SUB

REM $STATIC
DEFINT A-Z
SUB Intro
IF DQBloadSound(1, gamedir$ + "/data/sounds/fx/daq.wav") THEN DQBclose: PRINT DQBerror$: Quit
IF DQBloadSound(2, gamedir$ + "/data/sounds/fx/movie.wav") THEN DQBclose: PRINT DQBerror$: Quit
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/daq.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: Quit
DQBsetPal Pal
DQBplaySound 1, 1, 6050, ONCE
DQBwait 300
DQBfadeTo 0, 0, 0
MenuTrack% = LoadMIDI(gamedir$ + "/data/sounds/music/Track12.mid")
PlayMIDI MenuTrack%
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/bground1.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: Quit
DQBsetPal Pal
DQBwait 100
DO: LOOP UNTIL INKEY$ <> ""
DQBfadeTo 0, 0, 0
END SUB

DEFSNG A-Z
SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC

STATIC filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
		   
	' use fixed-length string to fix its position in memory
	' and so we don't mess up string pool before routine
	' gets its pointers from caller

DIM IntCode AS STRING * 200
IF NOT Loaded THEN                     ' loaded will be 0 first time
	RESTORE IntXCodeData:
   
	FOR k% = 1 TO 145
		READ H%
		MID$(IntCode, k%, 1) = CHR$(H%)
	NEXT

	'  determine address of interrupt no. offset in IntCode
  
	IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
	Loaded% = -1
END IF

SELECT CASE IntNum
  
	CASE &H25, &H26, IS > 255               ' ignore these interrupts
  
	CASE ELSE
		DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
		POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum     ' code block
		CALL ABSOLUTE(Regs, VARPTR(IntCode$))               ' call routine
END SELECT

END SUB

DEFINT A-Z
SUB LoadData

OPEN "game.dat" FOR INPUT AS #1

INPUT #1, gamedir$
INPUT #1, NoSound '-1=true, 0=false
IF NoSound = 0 THEN
   INPUT #1, SBFreq, SBBase, SBIrq, SBDma
END IF

CLOSE #1

END SUB

SUB LoadGFX

IF DQBloadImage(2, 0, 0, gamedir$ + "/data/graphics/space.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
IF DQBloadImage(1, 0, 0, gamedir$ + "/data/graphics/pics.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
DQBsetPal Pal

DQBget 1, 1, 1, 9, 9, VARSEG(fight(0)), VARPTR(fight(0))
DQBget 1, 11, 1, 19, 9, VARSEG(fightb(0)), VARPTR(fightb(0))
DQBget 1, 21, 1, 29, 9, VARSEG(goods(0)), VARPTR(goods(0))
DQBget 1, 31, 11, 39, 19, VARSEG(bads(0)), VARPTR(bads(0))
'DQBget 1, 31, 11, 39, 19, VARSEG(goodb(0)), VARPTR(goodb(0))
DQBget 1, 92, 1, 115, 24, VARSEG(badb(0)), VARPTR(badb(0))
DQBget 1, 31, 1, 39, 9, VARSEG(bomber(0)), VARPTR(bomber(0))
DQBget 1, 8, 11, 21, 24, VARSEG(shuttle(0)), VARPTR(shuttle(0))
DQBget 1, 1, 26, 102, 128, VARSEG(bigg(0)), VARPTR(bigg(0))
DQBget 1, 23, 11, 29, 17, VARSEG(missle(0)), VARPTR(missle(0))
DQBget 1, 209, 18, 226, 35, VARSEG(alien(0)), VARPTR(alien(0))
DQBget 1, 23, 19, 28, 24, VARSEG(photon(0)), VARPTR(photon(0))
DQBget 1, 228, 18, 245, 34, VARSEG(ast(0)), VARPTR(ast(0))

DQBget 1, 142, 1, 157, 16, VARSEG(exps1(0)), VARPTR(exps1(0))
DQBget 1, 159, 1, 174, 16, VARSEG(exps2(0)), VARPTR(exps2(0))
DQBget 1, 176, 1, 191, 16, VARSEG(exps3(0)), VARPTR(exps3(0))
DQBget 1, 193, 1, 208, 16, VARSEG(exps4(0)), VARPTR(exps4(0))
DQBget 1, 210, 1, 225, 16, VARSEG(exps5(0)), VARPTR(exps5(0))
DQBget 1, 227, 1, 242, 16, VARSEG(exps6(0)), VARPTR(exps6(0))

DQBclearLayer 1

OPEN "sc.fnt" FOR BINARY AS #1
FOR i = 1 TO 2048
   A$ = " "
   GET #1, , A$
   MID$(Font, i, 1) = A$
NEXT i
FOR i = 0 TO 256
   MID$(Font, 2049 + i, 1) = CHR$(8)
NEXT i
CLOSE #1

DQBsetFont Font
DQBsetTextSpacing -2

END SUB

SUB LoadMap (map$)

OPEN gamedir$ + "/data/maps/" + map$ FOR INPUT AS #1

StopMIDI
CleanUpMIDI
INPUT #1, Track$
Track% = LoadMIDI(gamedir$ + "/data/sounds/music/" + Track$ + ".mid")
PlayMIDI Track%
LoopMidi

INPUT #1, MisObj.w, MisObj.wa
INPUT #1, MisObj.l, MisObj.la
MisObj.waitabit = 0: MisObj.wd = 0: MisObj.ld = 0

INPUT #1, AmountOfShips

FOR n% = 1 TO AmountOfShips
   INPUT #1, Ship(n%).HPos, Ship(n%).VPos, Ship(n%).Types, Ship(n%).Team
   INPUT #1, Ship(n%).Direction, Ship(n%).Orders
	IF Ship(n%).Orders = 0 THEN INPUT #1, Ship(n%).HWant, Ship(n%).VWant
	IF Ship(n%).Orders = 1 THEN INPUT #1, Ship(n%).Target
   INPUT #1, Ship(n%).Control, Ship(n%).Weapon
   Ship(n%).Alive = -1
   Ship(n%).Moved = 0
   Ship(n%).Damage = 0
NEXT n%

FOR n% = 1 TO AmountOfShips
   SELECT CASE Ship(n%).Types

      CASE 0
      RESTORE fighter
      READ ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload
      READ ShipSpec(n%).Armour


      CASE 1
      RESTORE attack
      READ ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload, ShipSpec(n%).Armour

      CASE 2
      RESTORE bomber
      READ ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload, ShipSpec(n%).Armour

      CASE 3
      RESTORE shuttle
      READ ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload, ShipSpec(n%).Armour
    

      CASE 6
      RESTORE bigg
      READ ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload, ShipSpec(n%).Armour

      CASE 8
      RESTORE alien
      READ ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload, ShipSpec(n%).Armour

      CASE 9
      RESTORE asteriod
      READ ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload, ShipSpec(n%).Armour


   END SELECT

NEXT n%

INPUT #1, ChangesToShipSpecs
FOR i% = 1 TO ChangesToShipSpecs
   INPUT #1, n%
   INPUT #1, ShipSpec(n%).Speed, ShipSpec(n%).Turn, ShipSpec(n%).Payload, ShipSpec(n%).Armour
NEXT i%
CLOSE #1

FOR n% = 1 TO AmountOfShips
   Ship(n%).Payload = ShipSpec(n%).Payload
NEXT n%

IF DQBloadSound(1, gamedir$ + "/data/sounds/fx/boom1.wav") THEN DQBclose: PRINT DQBerror$: END
IF DQBloadSound(1, gamedir$ + "/data/sounds/fx/boom3.wav") THEN DQBclose: PRINT DQBerror$: END

END SUB

REM $DYNAMIC
DEFSNG A-Z
'LoadMIDI - loads a MIDI file into memory
FUNCTION LoadMIDI% (FileName$)
LoadMIDI% = -1
'See if an extension was supplied, and if not, add one.
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL FileName$: MIDI.ERROR = 1: EXIT FUNCTION
'Make the filename an ASCIIZ string.
FileName$ = FileName$ + CHR$(0)

'Find an empty MIDI handle
NewHandle% = -1
FOR i% = 0 TO 255
	IF MEM.SEGMENT(i%) = 0 THEN NewHandle% = i%: EXIT FOR
NEXT i%
'If there are no empty handles, return an error.
IF NewHandle% = -1 THEN MIDI.ERROR = 12: EXIT FUNCTION
'Attempt to allocate a block of conventional memory.
QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)
'If the block couldn't be allocated, it means there's not enough free
'memory.  To fix this, we need to ask BASIC to release some of the memory
'it's using:
IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
	'Find out how much memory is available, in kilobytes.
	LargestBlock& = QMIDIRegs.BX
	LargestBlock& = LargestBlock& * 16
	'Calculate the amount of memory that BASIC needs to release for us.
	MEM.ALLOCATED(NewHandle%) = (FileLen& + 2048) - LargestBlock&
	'Attempt to release the memory.
	A& = SETMEM(-MEM.ALLOCATED(NewHandle%))
	'Try again to allocate a block of memory
	QMIDIRegs.AX = &H4800
	QMIDIRegs.BX = (FileLen& \ 16) + 1
	CALL IntX(&H21, QMIDIRegs)
	'If the second attempt was unsuccessful, then there just isn't
	'enough memory, and an error needs to be returned.
	IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
		'Give any memory we took back to BASIC.
		A& = SETMEM(650000)
		'Return an error.
		MIDI.ERROR = 2
		MEM.SEGMENT(NewHandle%) = 0
		'Abort.
		EXIT FUNCTION
	END IF
END IF
'If the memory was allocated successfully, store the segment
'of the memory block.
MEM.SEGMENT(NewHandle%) = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

'Open the MIDI file using a DOS interrupt.
QMIDIRegs.AX = &H3D00
QMIDIRegs.DX = SADD(FileName$)
QMIDIRegs.DS = VARSEG(FileName$)
CALL IntX(&H21, QMIDIRegs)
'Store the file handle.
Handle% = QMIDIRegs.AX
'Read the data from the file in 16 kilobyte increments.
FOR i& = 1 TO FileLen& STEP 16384
	QMIDIRegs.AX = &H3F00
	QMIDIRegs.CX = 16384
	QMIDIRegs.DX = 0
	QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
	QMIDIRegs.BX = Handle%
	CALL IntX(&H21, QMIDIRegs)
	MIDISegment& = MIDISegment& + 1024
NEXT i&

'Close the file
QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)

MIDI.ERROR = 0
LoadMIDI% = NewHandle%
END FUNCTION

REM $STATIC
SUB LoopMidi
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN PlayMIDI CURRENTHANDLE
END SUB

DEFINT A-Z
SUB Lystra
DQBmouseHide
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/lbrief.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
DQBsetPal Pal
DQBsetClipBox 170, 5, 315, 190

'Max text length"                        "
'start of box = 170

SELECT CASE Mission

CASE 1
DQBprint VIDEO, "Welcome to the Uprising", CENTERED, 10, 15
DQBprint VIDEO, "Navy Pilot,", CENTERED, 16, 15
DQBprint VIDEO, "I'm sorry to give you", CENTERED, 22, 15
DQBprint VIDEO, "such an important first", CENTERED, 28, 15
DQBprint VIDEO, "Mission, but your the", CENTERED, 34, 15
DQBprint VIDEO, "closest squadran to", CENTERED, 40, 15
DQBprint VIDEO, "Threat.", CENTERED, 46, 15
DQBprint VIDEO, "Your mission is to", CENTERED, 52, 15
DQBprint VIDEO, "destroy the Asteroid", CENTERED, 58, 15
DQBprint VIDEO, "before it hits the", CENTERED, 64, 15
DQBprint VIDEO, "Planet Binar IIV.", CENTERED, 70, 15
DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""
LoadMap "map1.map"

CASE 2
DQBprint VIDEO, "You did good pilot.", CENTERED, 10, 15
DQBprint VIDEO, "But we have another,", CENTERED, 16, 15
DQBprint VIDEO, "mission for you.", CENTERED, 22, 15
DQBprint VIDEO, "One of our shuttles", CENTERED, 28, 15
DQBprint VIDEO, "is stranded and under", CENTERED, 34, 15
DQBprint VIDEO, "attack.", CENTERED, 40, 15

DQBprint VIDEO, "Your mission is to", CENTERED, 52, 15
DQBprint VIDEO, "protect the shuttle", CENTERED, 58, 15
DQBprint VIDEO, "until it reaches it", CENTERED, 64, 15
DQBprint VIDEO, "rendezvous with the", CENTERED, 70, 15
DQBprint VIDEO, "rest of the convoy.", CENTERED, 76, 15
DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""
LoadMap "map2.map"

CASE 3
Quit

END SELECT
Engine

END SUB

DEFSNG A-Z
FUNCTION MemUsed& (Handle%)
MemUsed& = MEM.ALLOCATED(Handle%)
MIDI.ERROR = 0
END FUNCTION

DEFINT A-Z
SUB Menu

Main:
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/bground2.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
DQBsetPal Pal
DQBmouseShow
DO: LOOP UNTIL DQBmouseLB = 0
DO: LOOP UNTIL DQBmouseLB <> 0
IF DQBmouseY > 54 AND DQBmouseY < 79 AND DQBmouseX > 118 AND DQBmouseX < 192 THEN DQBmouseHide: GOTO singl
IF DQBmouseY > 81 AND DQBmouseY < 107 AND DQBmouseX > 118 AND DQBmouseX < 192 THEN DQBmouseHide: GOTO Multi
IF DQBmouseY > 109 AND DQBmouseY < 133 AND DQBmouseX > 118 AND DQBmouseX < 192 THEN DQBmouseHide: GOTO Editor
IF DQBmouseY > 136 AND DQBmouseY < 162 AND DQBmouseX > 118 AND DQBmouseX < 192 THEN DQBmouseHide: Quit
GOTO Main


singl:
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/teamsel.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
DQBsetPal Pal
DQBmouseShow
DO: LOOP UNTIL DQBmouseLB = 0
DO: LOOP UNTIL DQBmouseLB <> 0
IF DQBmouseY > 0 AND DQBmouseY < 24 AND DQBmouseX > 272 AND DQBmouseX < 320 THEN DQBmouseHide: GOTO Main
IF DQBmouseY > 0 AND DQBmouseY < 24 AND DQBmouseX > 0 AND DQBmouseX < 52 THEN DQBmouseHide: GOTO Load
IF DQBmouseX < 142 THEN Galatian
IF DQBmouseX > 166 THEN Lystra
GOTO singl


Multi:
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/multi.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
DQBsetPal Pal
DQBmouseShow
DO: LOOP UNTIL DQBmouseLB = 0
DO: LOOP UNTIL DQBmouseLB <> 0
IF DQBmouseY > 0 AND DQBmouseY < 24 AND DQBmouseX > 272 AND DQBmouseX < 320 THEN DQBmouseHide: GOTO Main
GOTO Multi


Load:
GOTO Main

Editor:
GOTO Main
END SUB

REM $DYNAMIC
DEFSNG A-Z
'MIDIError - Translates a QMIDI error code into text
FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
		CASE 0: MIDIError$ = "NO ERROR"
		CASE 1: MIDIError$ = "FILE DOES NOT EXIST"
		CASE 2: MIDIError$ = "OUT OF MEMORY"
		CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
		CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
		CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
		CASE 6: MIDIError$ = "NO MIXER CHIP"
		CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
		CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
		CASE 9: MIDIError$ = "FILE IS CORRUPT"
		CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
		CASE 11: MIDIError$ = "COULD NOT PLAY MUSIC"
		CASE 12: MIDIError$ = "ALL HANDLES IN USE"
		CASE 13: MIDIError$ = "INVALID HANDLE NUMBER"
		CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

REM $STATIC
DEFINT A-Z
SUB MissionFailed
StopMIDI
UnloadMIDI MenuTrack%
DQBprint VIDEO, "M I S S I O N   F A I L E D", 70, 90, 15
DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""
Quit
END SUB

SUB MissionSuccess
StopMIDI
UnloadMIDI MenuTrack%
DQBprint VIDEO, "M I S S I O N   S U C C E S F U L L", 50, 90, 15
DO: LOOP UNTIL INKEY$ = ""
DO: LOOP UNTIL INKEY$ <> ""
Mission = Mission + 1
Lystra
END SUB

SUB MoveAI (n%)

FirstWantAngle = DQBangle(Ship(n%).HPos, Ship(n%).VPos, Ship(Ship(n%).Target).HPos, Ship(Ship(n%).Target).VPos)
WantAngle = FirstWantAngle * 1.4117647#

rand = INT(RND * 20) + 1
IF rand = 1 THEN
   IF Ship(n%).Direction + 10 < WantAngle THEN Ship(n%).Direction = Ship(n%).Direction + ShipSpec(n%).Turn: GOTO NoFire
   IF Ship(n%).Direction - 10 > WantAngle THEN Ship(n%).Direction = Ship(n%).Direction - ShipSpec(n%).Turn: GOTO NoFire
   frand = INT(RND * 2) + 1
   IF frand = 1 THEN
      IF Ship(n%).FiringDelay = 0 THEN
	 IF Ship(n%).Payload > 0 THEN CreateMissile Ship(n%).HPos, Ship(n%).VPos, Ship(n%).Target, Ship(n%).Direction, Ship(n%).Weapon
	 Ship(n%).Payload = Ship(n%).Payload - 1
	 Ship(n%).FiringDelay = 500
      END IF
   END IF
END IF

IF rand = 2 THEN Ship(n%).Direction = Ship(n%).Direction + ShipSpec(n%).Turn
IF rand = 3 THEN Ship(n%).Direction = Ship(n%).Direction - ShipSpec(n%).Turn

NoFire:
END SUB

SUB MoveMissiles

FOR n% = 1 TO 50

IF Missile(n%).Dead = -1 THEN

   WantAngle = DQBangle(Missile(n%).HPos, Missile(n%).VPos, Ship(Missile(n%).Target).HPos, Ship(Missile(n%).Target).VPos)
   'IF Missile(n%).HPos > 320 THEN Missile(n%).HPos = 0
   'IF Missile(n%).HPos < 0 THEN Missile(n%).HPos = 320
   'IF Missile(n%).VPos > 200 THEN Missile(n%).VPos = 0
   'IF Missile(n%).VPos < 0 THEN Missile(n%).VPos = 200
   Missile(n%).HAdd = SIN((Missile(n%).Direction) * 3.141593 / 180)
   Missile(n%).VAdd = -COS((Missile(n%).Direction) * 3.141593 / 180)
   Missile(n%).Timeleft = Missile(n%).Timeleft + 1
   Missile(n%).HPos = Missile(n%).HPos + Missile(n%).HAdd
   Missile(n%).VPos = Missile(n%).VPos + Missile(n%).VAdd
  
   SELECT CASE Missile(n%).Types
     
      CASE 1
	 mis = INT(RND * 100) + 1
	 IF mis < 5 THEN
	    IF WantAngle <> Missile(n%).Direction THEN
	       IF WantAngle < Missile(n%).Direction THEN
		  Missile(n%).Direction = Missile(n%).Direction - 1
		  ELSE Missile(n%).Direction = Missile(n%).Direction + 1
	       END IF
	    END IF
	  END IF

	 IF Missile(n%).Timeleft = 100 THEN Missile(n%).Dead = 0
      DQBrPut 1, Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), (Missile(n%).Direction / 1.4117647#), 100

      CASE 2
      DQBrPut 1, Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), (Missile(n%).Direction / 1.4117647#), 100
      IF Missile(n%).Timeleft = 250 THEN Missile(n%).Dead = 0

      CASE 3
      DQBrPut 1, Missile(n%).HPos, Missile(n%).VPos, VARSEG(photon(0)), VARPTR(photon(0)), (Missile(n%).Direction / 1.4117647#), 100
      IF Missile(n%).Timeleft = 200 THEN Missile(n%).Dead = 0

   END SELECT

   SELECT CASE Ship(Missile(n%).Target).Types

      CASE 0
      IF DQBcollide(Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), Ship(Missile(n%).Target).HPos, Ship(Missile(n%).Target).VPos, VARSEG(fight(0)), VARPTR(fight(0))) THEN
	 CreateExplosion Missile(n%).HPos, Missile(n%).VPos, Missile(n%).Types
	 Missile(n%).Dead = 0
	 IF Missile(n%).Types = 2 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 5
	 IF Missile(n%).Types = 3 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 10
      END IF


      CASE 1
      IF DQBcollide(Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), Ship(Missile(n%).Target).HPos, Ship(Missile(n%).Target).VPos, VARSEG(fightb(0)), VARPTR(fightb(0))) THEN
	 CreateExplosion Missile(n%).HPos, Missile(n%).VPos, Missile(n%).Types
	 Missile(n%).Dead = 0
	 IF Missile(n%).Types = 2 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 5
	 IF Missile(n%).Types = 3 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 10
      END IF

      CASE 3
      IF DQBcollide(Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), Ship(Missile(n%).Target).HPos, Ship(Missile(n%).Target).VPos, VARSEG(shuttle(0)), VARPTR(shuttle(0))) THEN
	 CreateExplosion Missile(n%).HPos, Missile(n%).VPos, Missile(n%).Types
	 Missile(n%).Dead = 0
	 IF Missile(n%).Types = 2 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 5
	 IF Missile(n%).Types = 3 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 10
      END IF

      CASE 6
      IF DQBcollide(Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), Ship(Missile(n%).Target).HPos, Ship(Missile(n%).Target).VPos, VARSEG(bigg(0)), VARPTR(bigg(0))) THEN
	 CreateExplosion Missile(n%).HPos, Missile(n%).VPos, 1
	 Missile(n%).Dead = 0
	 IF Missile(n%).Types = 2 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 5
	 IF Missile(n%).Types = 3 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 10
      END IF
  

      CASE 8
      IF DQBcollide(Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), Ship(Missile(n%).Target).HPos, Ship(Missile(n%).Target).VPos, VARSEG(alien(0)), VARPTR(alien(0))) THEN
	 CreateExplosion Missile(n%).HPos, Missile(n%).VPos, 1
	 Missile(n%).Dead = 0
	 IF Missile(n%).Types = 2 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 5
	 IF Missile(n%).Types = 3 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 10
      END IF

      CASE 9
      IF DQBcollide(Missile(n%).HPos, Missile(n%).VPos, VARSEG(missle(0)), VARPTR(missle(0)), Ship(Missile(n%).Target).HPos, Ship(Missile(n%).Target).VPos, VARSEG(ast(0)), VARPTR(ast(0))) THEN
	 CreateExplosion Missile(n%).HPos, Missile(n%).VPos, 1
	 Missile(n%).Dead = 0
	 IF Missile(n%).Types = 2 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 5
	 IF Missile(n%).Types = 3 THEN Ship(Missile(n%).Target).Damage = Ship(Missile(n%).Target).Damage + 10
      END IF

   END SELECT
END IF

NEXT n%

END SUB

SUB MovePlayer (n%, u$)

SELECT CASE LCASE$(u$)
  
   CASE "4", "a"
   Ship(n%).Direction = Ship(n%).Direction - ShipSpec(n%).Turn

   CASE "6", "d"
   Ship(n%).Direction = Ship(n%).Direction + ShipSpec(n%).Turn

   CASE "5", "s"
   IF Ship(n%).FiringDelay = 0 THEN
      IF Ship(n%).Payload > 0 THEN CreateMissile Ship(n%).HPos, Ship(n%).VPos, Ship(n%).Target, Ship(n%).Direction, Ship(n%).Weapon
      Ship(n%).Payload = Ship(n%).Payload - 1
      Ship(n%).FiringDelay = 500
   END IF

   CASE CHR$(9), "+"
   Ship(n%).Target = i%
   m% = 0
   DO
      m% = m% + 1
      IF Ship(i%).Alive <> 0 AND Ship(i%).Team <> Ship(n%).Team THEN
	 Ship(n%).Target = i%
	 EXIT DO
      END IF
      i% = i% + 1
      IF i% > AmountOfShips THEN i% = 1
      IF m% > AmountOfShips THEN EXIT DO
   LOOP

END SELECT

END SUB

SUB MoveShips

FOR n% = 1 TO AmountOfShips

IF Ship(n%).Alive = -1 THEN
   Ship(n%).HAdd = SIN((Ship(n%).Direction) * 3.141593 / 180)
   Ship(n%).VAdd = -COS((Ship(n%).Direction) * 3.141593 / 180)

   Ship(n%).Moved = Ship(n%).Moved + 1

   IF Ship(n%).Moved = ShipSpec(n%).Speed THEN
      Ship(n%).HPos = Ship(n%).HPos + Ship(n%).HAdd
      Ship(n%).VPos = Ship(n%).VPos + Ship(n%).VAdd
      Ship(n%).Moved = 0
   END IF

   IF Ship(n%).HPos > 320 THEN Ship(n%).OffMap = 1
   IF Ship(n%).HPos < 0 THEN Ship(n%).OffMap = 1
   IF Ship(n%).VPos > 200 THEN Ship(n%).OffMap = 1
   IF Ship(n%).VPos < 0 THEN Ship(n%).OffMap = 1

   IF n% <> MisObj.la AND n% <> MisObj.wa THEN
      IF Ship(n%).HPos > 320 THEN Ship(n%).HPos = 0: Ship(n%).OffMap = 1
      IF Ship(n%).HPos < 0 THEN Ship(n%).HPos = 320: Ship(n%).OffMap = 1
      IF Ship(n%).VPos > 200 THEN Ship(n%).VPos = 0: Ship(n%).OffMap = 1
      IF Ship(n%).VPos < 0 THEN Ship(n%).VPos = 200: Ship(n%).OffMap = 1
   END IF

   IF Ship(n%).Damage >= ShipSpec(n%).Armour THEN
      CreateExplosion Ship(n%).HPos, Ship(n%).VPos, 2
      Ship(n%).Alive = 0
   END IF

   IF Ship(Ship(n%).Target).Alive = 0 THEN Ship(n%).Target = 0
   IF Ship(Ship(n%).Target).Alive = 0 THEN
      FOR i% = 1 TO AmountOfShips
	 IF Ship(i%).Alive <> 0 AND Ship(i%).Team <> Ship(n%).Team THEN
	    Ship(n%).Target = i%
	    GOTO foundnewtarget
	 END IF
      NEXT i%
   END IF
  
foundnewtarget:
END IF

NEXT n%

END SUB

DEFSNG A-Z
FUNCTION MusicDone%
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT FUNCTION
IF MIDI.PLAYTIME = 0 THEN MIDI.ERROR = 3: EXIT FUNCTION
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN QMIDIRegs.AX = -1 ELSE QMIDIRegs.AX = 0
MusicDone% = QMIDIRegs.AX
MIDI.ERROR = 0
END FUNCTION

DEFINT A-Z
SUB Options
END SUB

SUB Pause
SELECT CASE Ship(1).Team
CASE 1
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/gamel.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
CASE 2
IF DQBloadImage(VIDEO, 0, 0, gamedir$ + "/data/graphics/gameg.bmp", Pal, A%, A%) THEN DQBclose: PRINT DQBerror$: END
END SELECT
DQBcopyLayer VIDEO, 1
DQBsetClipBox 1, 1, 255, 199
FOR n% = 1 TO AmountOfShips
   IF Ship(n%).Alive = -1 THEN PutShip n%
NEXT n%
DQBsetClipBox 1, 1, 319, 199
DQBcopyLayer 1, VIDEO
DQBmouseShow

DO: LOOP UNTIL DQBmouseLB = 0
DO: LOOP UNTIL DQBmouseLB = -1

IF DQBmouseY > 67 AND DQBmouseY < 86 AND DQBmouseX > 263 AND DQBmouseX < 287 THEN DQBmouseHide: Options
IF DQBmouseY > 67 AND DQBmouseY < 86 AND DQBmouseX > 288 AND DQBmouseX < 312 THEN DQBmouseHide: Engine

Quit
END SUB

REM $DYNAMIC
DEFSNG A-Z
'PauseMIDI - Pauses a MIDI file that is currently playing
SUB PauseMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If no MIDI file is playing, exit now
IF MIDI.PLAYTIME = 0 THEN
	MIDI.ERROR = 3
	EXIT SUB
END IF
'Call the SBSIM driver to pause the music.
QMIDIRegs.BX = 7
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
'Save the number of seconds that the MIDI file has been playing.
PAUSED = TimeMIDI!
'If the music hasn't been playing long enough for TimeMIDI! to return
'a value greater than 0, change PAUSED to a tiny positive value.
IF PAUSED = 0! THEN PAUSED = .00001
'Indicate that the file has stopped playing.
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMIDI (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If sound is not disabled....
IF SOUND.DISABLED = 0 THEN
	'Call the SBMIDI driver to begin playing the MIDI file.
	QMIDIRegs.BX = 4
	QMIDIRegs.DX = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	QMIDIRegs.BX = 5
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	'If the music could not be started, return an error.
	IF QMIDIRegs.AX <> 0 THEN MIDI.ERROR = 11: EXIT SUB
	'Start the MIDI timer.
	MIDI.PLAYTIME = TIMER
	'Set the current handle.
	CURRENTHANDLE = Handle%
END IF
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB PutShip (n%)
' Ship Type codes
' 0 = fighter
' 1 = attacker
' 2 = bomber
' 3 = shuttle

IF Ship(n%).Control = 1 THEN
   'DQBprint 1, STR$(Ship(n%).Target), 1, 1, 15
   SELECT CASE Ship(Ship(n%).Target).Types
   CASE 0, 1, 2
	 DQBput 1, Ship(Ship(n%).Target).HPos, Ship(Ship(n%).Target).VPos, VARSEG(bads(0)), VARPTR(bads(0))

   CASE 9
	 DQBput 1, Ship(Ship(n%).Target).HPos - 2, Ship(Ship(n%).Target).VPos - 3, VARSEG(badb(0)), VARPTR(badb(0))

   END SELECT
END IF

SELECT CASE Ship(n%).Types

CASE 0
DQBrPut 1, Ship(n%).HPos, Ship(n%).VPos, VARSEG(fight(0)), VARPTR(fight(0)), (Ship(n%).Direction / 1.4117647#), 100

CASE 1
DQBrPut 1, Ship(n%).HPos, Ship(n%).VPos, VARSEG(fightb(0)), VARPTR(fightb(0)), (Ship(n%).Direction / 1.4117647#), 100

CASE 2
DQBrPut 1, Ship(n%).HPos, Ship(n%).VPos, VARSEG(bomber(0)), VARPTR(bomber(0)), (Ship(n%).Direction / 1.4117647#), 100

CASE 3
DQBrPut 1, Ship(n%).HPos, Ship(n%).VPos, VARSEG(shuttle(0)), VARPTR(shuttle(0)), (Ship(n%).Direction / 1.4117647#), 100



CASE 6
DQBrPut 1, Ship(n%).HPos, Ship(n%).VPos, VARSEG(bigg(0)), VARPTR(bigg(0)), (Ship(n%).Direction / 1.4117647#), 100

CASE 8
DQBrPut 1, Ship(n%).HPos, Ship(n%).VPos, VARSEG(alien(0)), VARPTR(alien(0)), (Ship(n%).Direction / 1.4117647#), 100

CASE 9
DQBrPut 1, Ship(n%).HPos, Ship(n%).VPos, VARSEG(ast(0)), VARPTR(ast(0)), (Ship(n%).Direction / 1.4117647#), 100

END SELECT

END SUB

SUB Quit

StopMIDI
CleanUpMIDI

dummy& = SETMEM(100000)
DQBclose

END

END SUB

REM $DYNAMIC
DEFSNG A-Z
'ResumeMIDI - Starts playing a MIDI file after it has been paused
SUB ResumeMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If the MIDI file is not paused, exit now
IF PAUSED = 0! THEN EXIT SUB
'Call the SBSIM driver to resume playing.
QMIDIRegs.BX = 8
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
'Update the MIDI timer.
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
MIDI.ERROR = 0
END SUB

'StopMIDI - Stops playing MIDI file
SUB StopMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Call the SBMIDI driver to stop the music.
IF MIDI.PLAYTIME THEN
	QMIDIRegs.BX = 4
	QMIDIRegs.DX = MEM.SEGMENT(CURRENTHANDLE)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMIDI!
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
	TimeMIDI! = PAUSED
	MIDI.ERROR = 0
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
	'Get the current time
	CurrentTime! = TIMER
	'If midnight has come since the MIDI file started playing, change
	'CurrentTime! accordingly
	IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
		CurrentTime! = 86400 + CurrentTime!
	END IF
	'Get the final result
	TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
END FUNCTION

REM $STATIC
SUB UnloadMIDI (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
'If a block of memory was allocated to hold the MIDI file....
IF MEM.SEGMENT(Handle%) THEN
	'Release the block of memory.
	QMIDIRegs.ES = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = &H4900
	CALL IntX(&H21, QMIDIRegs)
	'Give back all the memory we took from BASIC.
	A& = SETMEM(650000)
END IF
MEM.SEGMENT(Handle%) = 0
MEM.ALLOCATED(Handle%) = 0
MIDI.ERROR = 0
END SUB

