DECLARE SUB LoadPal (File$)
DECLARE FUNCTION Engine.TileCollide% (Player AS ANY)
DECLARE SUB Engine.DrawPlayer (Player AS ANY)
DECLARE SUB Engine.UpdatePlayer (Player AS ANY, Direction%)
DECLARE SUB Engine.UpdateCamera (Level AS ANY, Player AS ANY)
DECLARE SUB Main ()
DECLARE SUB MainScreen ()  'Extra sub for main screen(simple and boring)
DECLARE SUB Engine.DrawFred (Fred AS ANY)   'Extra sub for moving characters
DECLARE SUB Engine.DrawGuard (Guard AS ANY)  'Extra sub for castle guards
'============================================================================
DECLARE SUB DrawCollideLayer ()          'These two subs are used
DECLARE SUB Engine.DoCollision ()        'to detect collison between
                                         'Hero and any moving/static sprite
'============================================================================
DECLARE SUB GetSpeed ()                 'delayer by Yousuf Philips
DECLARE SUB delay (MiliSeconds%)        'for fast PCs
DECLARE SUB SpeedControl () 'Menu for speed adjusting
DECLARE SUB Engine.DrawScreen ()
DECLARE SUB InitVariables ()
DECLARE SUB Engine.DrawMap ()
DECLARE SUB InitMap ()
DECLARE SUB MakeImageIndex (ImageArray%(), IndexArray%())
DECLARE SUB InitImageData (FileName$, ImageArray%())
DECLARE SUB LoadNPC ()
DECLARE SUB LoadTiles ()
'$INCLUDE: 'RelLib.BI'
DEFINT A-Z
'$DYNAMIC
COMMON SHARED speed&, speede  'variables used by delay routines,they are
                              'shared cause of simpliciy
'========Declare types here
TYPE SpriteType
         Typ            AS INTEGER              'ID
         X              AS INTEGER              'World X pos
         Y              AS INTEGER
         XC             AS INTEGER              'Screen Collision
         YC             AS INTEGER
         XV             AS INTEGER              'X Speed
         YV             AS INTEGER              'Y speed
         Frame          AS INTEGER              'Frame in tile where to draw
         Move           AS INTEGER              'if the sprite is moving?
         RANGE          AS INTEGER
         ACTIVE         AS INTEGER
         HIT            AS INTEGER
         AI             AS INTEGER
         MONEY          AS INTEGER
         HP             AS INTEGER
         ITEM           AS INTEGER
         Direction      AS INTEGER              'we will use this :)
         TileX          AS INTEGER              'Tile where the Player is on
         TileY          AS INTEGER
         Frame2         AS INTEGER
END TYPE



TYPE LevelType
        Xmax    AS INTEGER          'Maximum Number of Tiles a Map has
        Ymax    AS INTEGER
        CamX    AS INTEGER          'Pixel*Pixel Camera Position
        CamY    AS INTEGER
        TileX   AS INTEGER          'Tile postion of Camera
        TileY   AS INTEGER          'Calculated by CAMX\TileSize(20*20)
        Xpos    AS INTEGER          'Pixel position Inside the Tile
        Ypos    AS INTEGER          '0 to 15 (used for Scrolling)
END TYPE


TYPE MapLayerType
       BaseL    AS INTEGER          'Base Layer Implemented
       FringeL  AS INTEGER          'Fringe     Not Implemented
       ObjectL  AS INTEGER          'Object     Not Implemented
END TYPE


'========Declare constants here
CONST NULL = 0

'Use constants for speed!!!! :)

'Screen constants(Full Screen 320*200)
CONST ScrnXmax = 320, ScrnYmax = 200
CONST ScrnXmid = 160, ScrnYmid = 100
CONST ScrnXmin = 0, ScrnYmin = 0

'Tile dimensions 20*20
CONST TileW = 20
CONST TileH = 20

'Number of Tiles per screen 320\20=16,200\20=10
'Used to calculate the DrawMap sub
CONST ScrnTileXmax = ScrnXmax \ TileW
CONST ScrnTileYmax = ScrnYmax \ TileH

'Map Dimensions change this to suit your needs
CONST MapXmax = 35, MapYmax = 26

'Directional constants for easy sprite handling
'DN=Neutral(not Moving), DR=Right...........
CONST DN = 0, DR = 1, DU = 2, DL = 3, DD = 4

'========Declare Arrays here
REDIM SHARED Map(MapXmax, MapYmax) AS MapLayerType           '36*27 map

'Tiles and Sprites 20*20
'Note the (1 to 1) since if you Dim it like (1) then it would be 0 to 1
'and errors would occur :)
REDIM SHARED tile(1 TO 1) AS INTEGER
REDIM SHARED TileIndex(1 TO 1)  AS INTEGER
REDIM SHARED Sprite(1 TO 1) AS INTEGER
REDIM SHARED SpriteIndex(1 TO 1) AS INTEGER

'Layer or Page
REDIM SHARED Page(31999) AS INTEGER

'=========Level array
DIM SHARED Level AS LevelType
DIM SHARED Hero AS SpriteType   'Our Hero
DIM SHARED Fred AS SpriteType   'Fred
DIM SHARED Guard AS SpriteType  'Guards

'========Shared Variables
DIM SHARED Numsprite AS INTEGER
DIM SHARED Gname AS STRING
DIM SHARED Path$                'This is used to locate the dir of your files
                                'Not present in this code but easisly
                                'implemented
DIM SHARED HeroCollideOnLayer AS INTEGER    'Flag for collision
DIM SHARED OldX, OldY                       'Used to restore old Location


CLS
Gname = "Sprites.put"
CALL GetSpeed  'speed sub,should calculate same speed for every pc
MainScreen              'loads introducing screen
LoadTiles               'Load our Tileset
LoadNPC                 'Load all sprites
RelInitVGA13            'Screen 13
InitMap                 'Read our Map Array(Data StateMents)
LoadPal "map.Pal"

InitVariables           'Initialize our variables

Main                    'Main Loop

RelInitText     'Screen 0:width 80

END


'Map Data
'I put this in a data statement since its easier to understand that way
' :)  you could put this in a file if you want
'=====================================================
'A note:I changed first three lines with two digit values
'cause there i used tile numbers above 9
'Edit whole map in that mode to get nice perspective
'Eg.tile number 1 is 01,2 is 02 or 11 is 11
'=====================================================
'Dimensions : 36*27
'Note: Col(X) #36 and Row(Y) #27 is not used by the Map. They are there for
'Padding purposes and to prevent errors.
MapDATA:
DATA 07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,13,12,13,12,12,13,12,13,13,12,13,07,07,07
DATA 07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,07,12,15,13,15,12,13,12,15,13,15,13,07,07,07
DATA 07,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,11,10,11,11,11,14,11,10,10,11,11,01,07,07
DATA 7,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,8,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,9,9,1,1,1,1,7,7
DATA 7,1,1,1,8,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,9,1,1,1,1,1,7,7
DATA 7,1,8,1,1,8,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,8,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,3,3,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,3,4,3,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,3,4,4,4,3,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,4,4,4,3,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,9,3,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7
DATA 7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,9,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7
DATA 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
DATA 7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

REM $STATIC
DEFSNG A-Z
SUB delay (MiliSeconds%)
'/* This function slows down your program for the given amount of Miliseconds */'
IF speed& = 0 THEN
   PRINT " First run the GetSpeed sub"
   EXIT SUB
ELSEIF MiliSeconds% < 1 THEN
   PRINT " The sub needs a number greater than 0"
   EXIT SUB
END IF
DelayTime = (speed& * 5) * (MiliSeconds% / 1000)
FOR speed = 1 TO DelayTime
NEXT speed


END SUB

DEFINT A-Z
SUB DrawCollideLayer STATIC
'Clear our Screen
RelCLS VARSEG(Page(0)), 0

IF Fred.Frame <> 0 THEN

'We can put all moving colliding sprites below
'In this case we only used this routine on Fred
'Collision for Guards is REMed cause they are static and we can
'use a simple tile to tile colision with them(Check Engine.TileCollide)
'I left it here for example and testing purposes

  RelSpriteColor VARSEG(Page(0)), (Fred.X - Level.CamX), (Fred.Y - Level.CamY), VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Fred.Frame))), 15
  'RelSpriteColor VARSEG(Page(0)), (Guard.X - Level.CamX), (Guard.Y - Level.CamY), VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Guard.Frame))), 15
  'RelSpriteColor VARSEG(Page(0)), (Guard.X - 40 - Level.CamX), (Guard.Y - Level.CamY), VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Guard.Frame2))), 15
END IF


END SUB

SUB Engine.DoCollision STATIC
HeroCollideOnLayer = FALSE              'Init it to be false

'If Player collides with color 15 then put a TRUE value at our
'HeroCollideOn Layer.
'We define colliding sprites in DrawCollideLayer

IF RelCollide(VARSEG(Page(0)), Hero.XC, Hero.YC, VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Hero.Frame)))) = 15 THEN
        HeroCollideOnLayer = TRUE
        Hero.X = OldX           'Restore OldX and OldY
        Hero.Y = OldY           '(which means that Hero is blocked-returned
                                'to old position)
END IF
END SUB

SUB Engine.DrawFred (Fred AS SpriteType) STATIC

'Sub for drawing and moving(!) Fred
'Check DrawPlayer and EngineUpdatePlayer to fully understand
'This is a simple test sub for moving of other characters on the map
'Fred moves in one direction so we need only two frames(number 9 and 10 in
'sprites.put).We need only one file for all characters sprites!!
'This sub can be used for more characters,with AI
'Bad coding by Lachie :)


IF Fred.Frame <> 0 THEN

        RelSprite VARSEG(Page(0)), (Fred.X - Level.CamX), (Fred.Y - Level.CamY), VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Fred.Frame)))
END IF

OldDir = Fred.Direction
                                     
'======================================================================
'We use the Absolute Value difference at the center of both Sprites
'to check if they are near
'Also Hero must be infront of Fred(Hero.X > Fred.X)
'So they must be near and Hero must be infront of Fred
'In that situation Fred stops and we display a message said from Fred
'to Hero(Move away,monkey boy!)
'======================================================================
IF ABS((Fred.X + 10) - (Hero.X + 10)) < 15 AND ABS((Fred.Y + 10) - (Hero.Y + 10)) < 15 AND Hero.X > Fred.X THEN
RelPrint VARSEG(Page(0)), 50, 60, "Move away,monkey boy!", 25, TRUE
GOTO SkipFredmove:          'If Hero is infront of Fred we display
END IF                      'this message and skip movement
IF Fred.Direction <> OldDir THEN
        DirChanged2 = 1
ELSE

    
        DirChanged2 = (DirChanged2 MOD 2) + 1
END IF

IF DirChanged2 = 1 THEN

Frame = (Frame MOD 2) + 1
Fred.Frame = Frame + 8       'Fred frames are 9 and 10 is sprites.put

END IF

Fred.X = Fred.X + 1  'move Fred one point to right(Hero speed is 2 points per step)
SkipFredmove:                         'Label use to skip moving of Fred
Fred.TileX = (Fred.X + 10) \ TileW    'Tile on which is Fred
Fred.TileY = (Fred.Y + 10) \ TileH


END SUB

SUB Engine.DrawGuard (Guard AS SpriteType) STATIC

'This sub is for two guards
'They don't move,they just react on Hero being too close to the castle
'gate so the code is simple

'we draw two guards
RelSprite VARSEG(Page(0)), (Guard.X - Level.CamX), (Guard.Y - Level.CamY), VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Guard.Frame)))
RelSprite VARSEG(Page(0)), (Guard.X - 40 - Level.CamX), (Guard.Y - Level.CamY), VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Guard.Frame2)))


Guard.Frame2 = 11   'Two frame types for guards(two pictures for each guard)
Guard.Frame = 12    '4 sprites total(11,12,13,14 in sprites.put)
                         

'If the hero is infront of door(tile x is 27 and tile y is 3)
'we change the guard frames to alert mode
'and display a message said from guards to hero

IF Hero.TileX = 27 AND Hero.TileY = 3 THEN
RelPrint VARSEG(Page(0)), 68, 44, "Move along,filty boy!", 80, TRUE
Guard.Frame = 13     'Guard 1 alert frame(Frame=13)
Guard.Frame2 = 14    'Guard 2 alert frame(Frame=14)
IF RelKey(KEYUP) THEN   'If we press up
Hero.Y = Hero.Y + 2     'the move is blocked(Hero is pushed down)
END IF
END IF


'If Hero is only close to guards(tile x = 27,tile y = 4,then we only change
'guards frames to alert mode
'blocking is not necessary in this situation
'small cosmetic diddle

IF Hero.TileX = 27 AND Hero.TileY = 4 THEN
RelPrint VARSEG(Page(0)), 68, 44, "Move along,filty boy!", 80, TRUE
Guard.Frame = 13     'Guard 1 alert frame(Frame=13)
Guard.Frame2 = 14    'Guard 2 alert frame(Frame=14)
END IF



Guard.TileX = (Guard.X + 10) \ TileW    'Tile on which is Guard
Guard.TileY = (Guard.Y + 10) \ TileH


END SUB

SUB Engine.DrawMap STATIC

'Notes:
'1.Mod our Cam with 20 to get correct offset inside the tile
'2.Uses the constants TileH,TileW,ScrnTileXmax,ScrnTileYmax
'3.Constants are declared at the module level
'4.BaseL should be drawn with RelSpriteSolid since its faster(4 pixels drawn at a time)
'5.Varseg(Page(0)) is the segment we are drawing to prevent flicker.

'==========BaseLayer====================
'Calculate the first tile to draw
Level.TileX = Level.CamX \ TileW        'First tile to draw
Level.TileY = Level.CamY \ TileH
                               
'Get the offset inside the tile
Level.Xpos = Level.CamX MOD TileW            'Position in the Tile(0 to 15)
Level.Ypos = Level.CamY MOD TileH            '16*16 tile size(change to fit your needs)

'Formula for X.(the loop below)
'(X*TileW)=Video Screen Coord(0 to 320 Step 20)
'(X*TileW)-Level.Xpos=TileOffset that we have to show from 0 to 20-Xpos
'Assuming Level.Xpos=4
'So if X*TileW=0 then (X*TileW)-Level.Xpos=-4
'We start Drawing from -4 to -4+20
'ie,-4 to 16 then the next tile is 17 to 17+16
'Hope you understand

'Draw our Screen(No need to clear our Page)
FOR X = 0 TO ScrnTileXmax          '16 tiles
FOR Y = 0 TO ScrnTileYmax          '11 tiles
        tile = Map(X + Level.TileX, Y + Level.TileY).BaseL
        RelSpriteSolid VARSEG(Page(0)), (X * TileW) - Level.Xpos, (Y * TileH) - Level.Ypos, VARSEG(tile(1)), VARPTR(tile(TileIndex(tile)))
NEXT Y
NEXT X

'==========FringeLayer====================
'Use RelSprite
'==========ObjectLayer====================
'Use RelSprite
END SUB

SUB Engine.DrawPlayer (Player AS SpriteType) STATIC

'Notes:
'1. Uses the Directional Constants defined at module level(DN,DR...)


'This Stops the Player from Swaying his arms very fast
'DirChanged=Is just a flag to prevent Electric legs effect and to see if
'Player changed direction

IF Player.Direction <> OldDir THEN      'if Player changes direction
        DirChanged = 1                  'Flag it to change BaseFrame
ELSE
        'Delays frame rotation for sprite(Electric legs :))
        DirChanged = (DirChanged MOD 2) + 1      'Try to REM this :)
END IF

IF DirChanged = 1 THEN
IF Player.Move THEN                     'Flag if player has moved
        Frame = (Frame MOD 2) + 1      'Frame=Current frame(1 to 3) the
                                        'Player sprite is
                                        'Frame is Added to baseFrame to locate
                                        'the True Sprite Offset
                                        'See PP256
        SELECT CASE Player.Direction
                CASE DR
                        'Calculate the Frame of the sprite to draw
                        Player.Frame = Frame + 6       'Base Frame=6
                CASE DU
                        Player.Frame = Frame + 2
                CASE DL
                        Player.Frame = Frame + 4       'Base Frame=9
                CASE DD
                        Player.Frame = Frame           'Base Frame=1
                CASE ELSE
        END SELECT

        Player.Move = FALSE             'Stops the Player from Swaying
                                        'his arms while not moving
END IF
END IF

'Formula: X(same goes for Y)
'Player.X-Level.CamX
'just puts the player at the Center of screen
'So if Player.X=500 then CamX=Player.X-ScrnYmid(ScrnYmid=Middle of 320=160)
'CamX:500-160=340
'Player.X=500
'Xcenter:500-340=160(ScrnXmid)
'Same goes for Y
'See Engine.UpdateCamera for more Details :)
'Sprite(SpriteIndex(Sprite.Frame) is the current frame of the Sprite(calculated above)
'Notes:
'1.Sprite(SpriteIndex(Sprite.Frame))=Real offset of the frame(NO ERRORS)
'2.SpriteIndex(Sprite.Frame)=Index of the real offset of the frame(ERRORS)

IF Player.Frame <> 0 THEN               'Just to be sure to prevent errors since PP256 starts at 1
        RelSprite VARSEG(Page(0)), (Player.X - Level.CamX), (Player.Y - Level.CamY), VARSEG(Sprite(1)), VARPTR(Sprite(SpriteIndex(Player.Frame)))
END IF

OldDir = Player.Direction             'Save our Direction for checking above
                                      'OldDir is saved since we have declared
                                      'this SUB  as STATIC
END SUB

SUB Engine.DrawScreen STATIC
'Notes:
'Page() is a dynamic array we defined at module level for our page

Engine.DrawMap         'Draw our map to Page()
Engine.DrawFred Fred   'Draw Fred to Page()
Engine.DrawGuard Guard 'Draw Guard to Page()
Engine.DrawPlayer Hero 'Draw our Player to Page()


'Temp status check(Draw our Status for debugging purposes) ;)
'RelPrint is BAD!!!!(though it doesn't use arrays) :)
'Use RelFont256 for better looking fonts(see Fontsamp.exe/bas)

RelPrint VARSEG(Page(0)), 0, 0, "Hero TileX=" + STR$(Hero.TileX), 25, TRUE
RelPrint VARSEG(Page(0)), 0, 10, "Hero TileY=" + STR$(Hero.TileY), 25, TRUE
RelPrint VARSEG(Page(0)), 150, 0, "Level TileX=" + STR$(Level.TileX), 25, TRUE
RelPrint VARSEG(Page(0)), 150, 10, "Level TileY=" + STR$(Level.TileY), 25, TRUE
'RelPrint VARSEG(Page(0)), 0, 20, "Tile Under=" + STR$(Map(Hero.TileX, Hero.TileY).BaseL), 25, TRUE
RelPrint VARSEG(Page(0)), 0, 20, "Press SPACE to", 40, TRUE
RelPrint VARSEG(Page(0)), 0, 30, "change the speed", 40, TRUE

'RelWait      'Wait for retrace. REM this for Lightning Speed ;)

RelPCopy VIDEO, VARSEG(Page(0))         'Display it to screen(VIDEO)


END SUB

FUNCTION Engine.TileCollide (Player AS SpriteType) STATIC
'Crappy tile*tile collision detection ;)
'Returns TRUE if collision is detected, FALSE if not
'I didn't include a Pixel*pixel colision detection so as not to be confusing
'RelLib has a Pixel*pixel collision detection so don't worry ;)

'Init the function to be FALSE(no collision)
Engine.TileCollide = FALSE


'4 checks are done to be sure ;)
'Up-Left corner of hero
X = Player.X + 1        'Add 1 for 20*20 Box Collision
Y = Player.Y + 10
GOSUB CheckForTile      'check for the tile

'Up-Right corner of hero
X = Player.X + 19
Y = Player.Y + 10
GOSUB CheckForTile

'Down-Right corner of hero
X = Player.X + 19
Y = Player.Y + 19
GOSUB CheckForTile

'Down-Left corner of hero
X = Player.X + 1
Y = Player.Y + 19
GOSUB CheckForTile


EXIT FUNCTION

'Check for collision:(Bounding BoxType)
CheckForTile:
TX = X \ TileW          'Player.X\TileW=TileX
TY = Y \ TileH          'Player.Y\TileH=TileH


'=======================Guards to Hero colliding,by Lachie===================
'With guards I used tile to tile collision cause they are static sprites
'and using pixel to pixel collision is not so neccesary(anyway if we use
'pixel by pixel collision with guards in this example,Hero squizes between
'guards so it gives a bad effect)
'Anyway it wouldn't be normal that Hero rubs himself of the guards
'Some proper distance between guards and Hero is expected.

'There is 2 guards,don't be confused cause one guard is two tiles x
'infront of another guard(Guard.TileX - 2 = TX),we use two
'tile variables for both guards(Guard.TileX/TileY)
IF Guard.TileX = TX AND Guard.TileY = TY OR Guard.TileX - 2 = TX AND Guard.TileY = TY THEN
Engine.TileCollide = TRUE
END IF
'============================================================================


SELECT CASE Map(TX, TY).BaseL   'base layer check
        CASE 3  'Tree
                Engine.TileCollide = TRUE
        CASE 10 'Castle Walls
                Engine.TileCollide = TRUE
        CASE 11 'Castle Walls
                Engine.TileCollide = TRUE
        CASE 12 'Castle Walls
                Engine.TileCollide = TRUE
        CASE 13 'Castle Walls
                ngine.TileCollide = TRUE
        CASE 14 'Castle Door
                Engine.TileCollide = TRUE
        CASE 9  'Fruit Tree
                Engine.TileCollide = TRUE
        CASE 4  'Water
                Engine.TileCollide = TRUE
        CASE 6  'Stones
                Engine.TileCollide = TRUE
        CASE 8  'Ruins
                Engine.TileCollide = TRUE
        CASE 7  'Flowers,don't you dare stepping on them! :)
                Engine.TileCollide = TRUE

        CASE ELSE    'No collision
        END SELECT

RETURN          'Check for next Coord
END FUNCTION

SUB Engine.UpdateCamera (Level AS LevelType, Player AS SpriteType) STATIC

'Updates CAMX,CAMY in relation to Player.X,Player.Y to achieve
'ZELDA style scrolling engine.
'Sample Code:
'CODE: CASE DR
        'Right Direction of movement
'CODE: Level.CamX = Player.X - ScrnXmid
        'Center our player and Moves the camera to where
        'the player is going
        'ie, Assume: Player.X=1200,ScrnMid=Constant 160(Middle screen)
        'Level.CamX:1200-160=1040
        'to get the TileX:
        'TileX=Level.CamX\TileW=1040\16=65(This will be used with Engine.DrawMap)
'CODE: IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
        'Check if level.CamX<0, Zero it if its negative to prevent errors
        'ScrnYmin=0(Constant)
'CODE: IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        'Check if Level.CamX > (Level.Xmax * TileW) - ScrnXmax
        '(Level.Xmax * TileW) - ScrnXmax=Maximum number of PIXELS the Map has
        'Level.Xmax=Max num of tile for map(Shared Variable Level.Element)
        'TileW=Width of tile(Constant)
        'ScrnXmax=320(Constant)
        'To calculate: Level.Xmax=MapXmax
        'Formula:(Level.Xmax * TileW) - ScrnXmax
        'Level.Xmax=36
        '(36*16)-320=256
        'Level.CamX=256
        'To calculate TileX:
        'Level.CamX\TileW
        '256\16=16
        'TileX=16(Start Drawing from 16 to 36)
        '16 is the first tile to draw in X
        '36-16=20(See we have to draw 20 tiles horizontally!!!)
        'Same goes for Y
        'See Engine.DrawMap SUB for more details. ;)

SELECT CASE Player.Direction
        CASE DR
                Level.CamX = Player.X - ScrnXmid
                IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
                IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        CASE DU
                Level.CamY = Player.Y - ScrnYmid
                IF Level.CamY < ScrnYmin THEN Level.CamY = ScrnYmin
                IF Level.CamY > (Level.Ymax * TileH) - ScrnYmax THEN Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        CASE DL
                Level.CamX = Player.X - ScrnXmid
                IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
                IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        CASE DD
                Level.CamY = Player.Y - ScrnYmid
                IF Level.CamY < ScrnYmin THEN Level.CamY = ScrnYmin
                IF Level.CamY > (Level.Ymax * TileH) - ScrnYmax THEN Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        CASE ELSE
END SELECT

END SUB

SUB Engine.UpdatePlayer (Player AS SpriteType, Direction) STATIC
'Updates the players position according to its direction
'ZELDA style Pixel*Pixel free movement
'Sample Code:
'CODE: CASE DR
        'Direction of Player movement
'CODE: Player.X = Player.X + Player.XV
        'Add Xspeed to Player X position since we are moving right
'CODE: IF Engine.TileCollide(Hero) THEN Player.X = Player.X - Player.XV
        'Check for collision. If collided with valid "collidable" tile
        'Subtract Xspeed to return the player to its original place.
        'Also prevents player sticking to tiles when changing direction.
'CODE: IF Player.X > (Level.Xmax * TileW) - TileW THEN Player.X = (Level.Xmax * TileW) - TileW
        'Checks if player is outside of World map boudaries
        '(Level.Xmax * TileW) - TileW=(36*16)-16
        'Subracting 16(TileW) is necessary to prevent errors if your speed
        'is greater than 1. Also used for padding.

SELECT CASE Direction
        CASE DR
                Player.X = Player.X + Player.XV
                IF Engine.TileCollide(Hero) THEN Player.X = Player.X - Player.XV
                IF Player.X > (Level.Xmax * TileW) - TileW THEN Player.X = (Level.Xmax * TileW) - TileW
        CASE DU
                Player.Y = Player.Y - Player.YV
                IF Engine.TileCollide(Hero) THEN Player.Y = Player.Y + Player.YV
                IF Player.Y < ScrnYmin THEN Player.Y = ScrnYmin
        CASE DL
                Player.X = Player.X - Player.XV
                IF Engine.TileCollide(Hero) THEN Player.X = Player.X + Player.XV
                IF Player.X < ScrnXmin THEN Player.X = ScrnXmin
        CASE DD
                Player.Y = Player.Y + Player.YV
                IF Engine.TileCollide(Hero) THEN Player.Y = Player.Y - Player.YV
                IF Player.Y > (Level.Ymax * TileH) - TileH THEN Player.Y = (Level.Ymax * TileH) - TileH
        CASE ELSE
END SELECT

'Update the player moveFlag to animate the player(REM this for no Animation)
Player.Move = TRUE


'Calculate what Tile the player is
'Add 10 to X and Y to get center of Player since size is 20*20
Player.TileX = (Player.X + 10) \ TileW    'Center of Sprite
Player.TileY = (Player.Y + 10) \ TileH

Player.XC = (Player.X - Level.CamX)   'XC and YC are used in
Player.YC = (Player.Y - Level.CamY)   'Engine.DoCollison sub
                                      'to check Hero to Fred(or any sprite)
                                      'collision
END SUB

DEFSNG A-Z
SUB GetSpeed
'/* This function finds out the proper delay period needed for the current PC*/'
time& = TIMER: time& = time& + 1: speed& = 0
DO
LOOP UNTIL TIMER >= time&
DO
   speed& = speed& + 1
LOOP UNTIL TIMER >= time& + 1
'/* Testing to see if the Delay FUNCTION will delay 1 second correctly  */'
time! = TIMER
delay 1000
time! = TIMER - time!
'========================================================================
'Time adjusting by Lachie.On some fast PC time! = 0 and zero divide error
'occurs so i used this blind shooting value for time! variable
'but i think that can be compesated with speed adjusting menu
'========================================================================
IF time! = 0 THEN time! = .002
'/* If the Delay FUNCTION is slow then it is adjusted */'
IF time! < 1 THEN
   speed& = INT(speed& * (1 / time!))
END IF
END SUB

DEFINT A-Z
'* InitImageData() subroutine:
'* Initializes an integer array with image data - this must be done before
'* displaying an image using the PUT(graphics) statement. The calling value
'* of FileName$ dictates whether the data should be read directly from an
'* image file or from DATA statements (see below).
'*
'* Parameters:
'*    FileName$ - The name of the image file to load. This must include the
'*                path to the file if it does not reside in the current
'*                directory. If FileName$ is an empty string (""), image
'*                data is read from DATA statements.
'* ImageArray() - Dynamic, integer array to hold the image data.
'*
'* Note: Before calling InitImageData() to initialize images from DATA
'*       statements, use an appropriate RESTORE statement to ensure the
'*       correct DATA statements are read.
'*
SUB InitImageData (FileName$, ImageArray())

    IF FileName$ <> "" THEN
        '***** Read image data from file *****

        'Establish size of integer array required.
        FileNo = FREEFILE
        OPEN FileName$ FOR BINARY AS #FileNo
        Ints = (LOF(FileNo) - 7) \ 2
        CLOSE #FileNo
        REDIM ImageArray(1 TO Ints)

        'Load image data directly into array memory.
        DEF SEG = VARSEG(ImageArray(1))
        BLOAD FileName$, 0
        DEF SEG
    ELSE
        '***** Read image data from DATA statements *****

        'Establish size of integer array required.
        READ IntCount
        REDIM ImageArray(1 TO IntCount)

        'READ image DATA into array.
        FOR N = 1 TO IntCount
            READ X
            ImageArray(N) = X
        NEXT N
    END IF

END SUB

SUB InitMap STATIC
RESTORE MapDATA         'Read from Data label
FOR Y = 0 TO MapYmax
FOR X = 0 TO MapXmax
        READ tile
        Map(X, Y).BaseL = tile
NEXT X
NEXT Y

END SUB

SUB InitVariables STATIC

'Hero Starting Variables
'Center-down
Hero.Typ = 1                    'ID?????????
Hero.X = 15 * TileW             'Change this to where you want the player to
Hero.Y = 20 * TileH             'Start(Be sure not to go over the Map dimensions)
Hero.XV = 2                     'XSpeed Change this for faster movement
Hero.YV = 2                     'Yspeed
Hero.Frame = 1                  'We start at frame 1(looking-at-screen-sprite) :)
Hero.Move = FALSE               'Static(no movement) :)
Hero.RANGE = 0
Hero.ACTIVE = TRUE
Hero.HIT = FALSE
Hero.AI = 1
Hero.MONEY = 9999
Hero.HP = 9999
Hero.ITEM = 1
Hero.Direction = DU
Hero.TileX = 0
Hero.TileY = 0

'===Guards variables===
Guard.Frame = 11      'I used two frame variables because in sprites.put
Guard.Frame2 = 12     'i messed up the order of frames so using one
Guard.Move = FALSE    'frame variable is not an option.
Guard.TileX = 0       'But the fact is you would need only one frame
Guard.TileY = 0       'variable if you would put two frames for one guard
Guard.X = 28 * TileW  'and then two other frames for second guard in
Guard.Y = 3 * TileH   'sprites.put.I messed the proper order in sprites.put
'==================== 'so don't be confused with two frame variables used
                      'with guards
'===Fred variables===
Fred.Frame = 9
Fred.Move = FALSE
Fred.TileX = 0
Fred.TileY = 0
Fred.X = 10 * TileW
Fred.Y = 21 * TileH
'====================

speede = 80  'starting delay value



'Initialize Level Data
'Start from Center-Down
Level.Xmax = MapXmax
Level.Ymax = MapYmax
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

Hero.Direction = DU                     'Two directions so that engine will
Engine.UpdateCamera Level, Hero         'know where level TileX and TileY
Hero.Direction = DR                     'Positions from left to right
Engine.UpdateCamera Level, Hero         'No warping ;)



END SUB

DEFSNG A-Z
SUB LoadNPC
Gname = "Sprites.PUT"
InitImageData Gname, Sprite()
MakeImageIndex Sprite(), SpriteIndex()
END SUB

DEFINT A-Z
SUB LoadPal (File$) STATIC
OPEN File$ FOR BINARY AS #1
    FOR N = 0 TO 255
        GET #1, , C&
        b = C& \ 65536: C& = C& - b * 65536
        g = C& \ 256: C& = C& - g * 256
        r = C&
        OUT &H3C8, N
        OUT &H3C9, r
        OUT &H3C9, g
        OUT &H3C9, b
     NEXT
CLOSE
END SUB

DEFSNG A-Z
SUB LoadTiles
Gname = "map.Put"
InitImageData Gname, tile()
MakeImageIndex tile(), TileIndex()
END SUB

DEFINT A-Z
SUB Main STATIC

RelKeyBoardON           'Install MULTIKEY Keyboard handler
DO
        Engine.DrawScreen               'Draw Our  Screen to page and
                                        'Copy it to VIDEO
        DrawCollideLayer                'Draw our Collide Layer
        IF RelKey(KEYESC) THEN EXIT DO  'Emergency Exit
        

        IF RelKey(KEYUP) THEN                   'Pressed UP
                        Hero.Direction = DU     'Direction=Up
                        OldX = Hero.X           'Store our old variables
                        OldY = Hero.Y           '(used with collision routines)
                        Engine.UpdatePlayer Hero, DU    'Update Player position
                        Engine.DoCollision              'Check for collision
                        Engine.UpdateCamera Level, Hero 'Update camera position
        END IF

        IF RelKey(KEYDOWN) THEN
                        Hero.Direction = DD
                        OldX = Hero.X
                        OldY = Hero.Y
                        Engine.UpdatePlayer Hero, DD
                        Engine.DoCollision
                        Engine.UpdateCamera Level, Hero
        END IF
        IF RelKey(KEYRIGHT) THEN
                        Hero.Direction = DR
                        OldX = Hero.X
                        OldY = Hero.Y
                        Engine.UpdatePlayer Hero, DR
                        Engine.DoCollision
                        Engine.UpdateCamera Level, Hero
        END IF
        IF RelKey(KEYLEFT) THEN
                        Hero.Direction = DL
                        OldX = Hero.X
                        OldY = Hero.Y
                        Engine.UpdatePlayer Hero, DL
                        Engine.DoCollision
                        Engine.UpdateCamera Level, Hero
        END IF
        
        IF RelKey(KEYSPACE) THEN  'If space is pressed programm
        SpeedControl              'goes to speed adjusting sub
        END IF



IF speede = 1 GOTO skipdelay:
delay speede     'delayer(game runs too fast on Pentiums so we
                  'must use a delay),rem this if it behaves strangely
skipdelay:
LOOP UNTIL RelKey(KEYENTER)

RelKeyBoardOFF         'Remove the Keyboard handler

END SUB

SUB MainScreen
CLS
SCREEN 13
COLOR 9
LOCATE 4, 1
PRINT "     Pixel by pixel scrolling engine"
COLOR 4
LOCATE 6, 1
PRINT "             by R.Eric.Lope"
COLOR 9
LOCATE 10, 1
PRINT "         Tiles by Ingmar Steen"
LOCATE 11, 1
PRINT "        Extra coding by Lachie D."
COLOR 4
LOCATE 16, 1
PRINT "           Created with Rellib"
WHILE INKEY$ = ""
WEND
END SUB

'* MakeImageIndex() subroutine:
'* Constructs an image position index for the images held in an image array.
'*
'* Parameters:
'* ImageArray() - Dynamic, integer array holding images to be indexed.
'* IndexArray() - Dynamic, integer array to hold the index for images in
'*                ImageArray().
'*
SUB MakeImageIndex (ImageArray(), IndexArray())

    'The index will initially be built in a temporary array, allowing
    'for the maximum 1000 images per file.
    DIM Temp(1 TO 1000)
    Ptr& = 1: IndexNo = 1: LastInt = UBOUND(ImageArray)
    DO
        Temp(IndexNo) = Ptr&
        IndexNo = IndexNo + 1

        'Evaluate descriptor of currently referenced image to
        'calculate the beginning of the next image.
        X& = (ImageArray(Ptr&) \ 8) * (ImageArray(Ptr& + 1)) + 4
        IF X& MOD 2 THEN X& = X& + 1
        Ptr& = Ptr& + (X& \ 2)
    LOOP WHILE Ptr& < LastInt

    LastImage = IndexNo - 1

    'Copy the image index values into the actual index array.
    REDIM IndexArray(1 TO LastImage)
    FOR N = 1 TO LastImage
        IndexArray(N) = Temp(N)
    NEXT N


END SUB

SUB SpeedControl
'=========================================
'Sub for speed adjusting menu
'Basicly this sub clears the screen
'Prints the menu text
'And allows the user to adjust the
'the speed with +/- keys
'Rellib keyboard is turned off in this sub
'By Lachie Dazdarian
'===========================================
CLS
SCREEN 13
COLOR 9
RelKeyBoardOFF
LOCATE 2, 3
PRINT "        Speed control menu"
LOCATE 3, 2
PRINT "       ---------------------"
LOCATE 7, 1
PRINT "Press + for higher delay"
LOCATE 8, 1
PRINT "Press - for lower delay"
LOCATE 9, 1
PRINT "Press R to return to game."
LOCATE 15, 1
PRINT "Note:Higher delay,lower speed!"
LOCATE 11, 1
PRINT "Current delay:"; speede

WHILE INKEY$ <> "": WEND  'menu loop
DO
speedmenu:
       menu$ = LCASE$(INKEY$)
       LOOP UNTIL menu$ = "+" OR menu$ = "-" OR menu$ = "r" 'OR menu$ = "R"
       IF menu$ = "+" THEN
       IF speede < 5 THEN speede = 0
       speede = speede + 5
       LOCATE 11, 1                        'for + and -
       PRINT "Current delay:"; speede      'programm reprints the delay
       GOTO speedmenu:                     'and returns to the begining of
       END IF                              'the loop
       IF menu$ = "-" THEN
       speede = speede - 5
       IF speede < 5 THEN speede = 1
       LOCATE 11, 1
       PRINT "Current delay:"; speede
       GOTO speedmenu:
       END IF

       IF menu$ = "r" OR menu$ = "R" THEN GOTO endspeed:
       END                                    'if r is pressed then
       GOTO speedmenu:                        'programm exits the loop
endspeed:                                     '(returns to the engine loop)
        RelKeyBoardON     'We need to turn on Rellib keyboard handler now
END SUB

