'SUPER MARIO QB v.05
'-----------------------------------------------------------------------
'If you ever wanted a QBasic mario game, well, this is it! Using a
'sophisticated pure QB scrolling engine and sound blaster compatibility
'this game is the first in a new series of games by Dark Flare Software.
'Hope you have fun playing it!
'-----------------------------------------------------------------------
'email:spheresfantasy@yahoo.ca
'-----------------------------------------------------------------------

DEFINT A-Z

DECLARE SUB INTRO ()
DECLARE SUB DELAY ()
DECLARE SUB LEVELFINISH ()
DECLARE SUB ENDING ()
DECLARE SUB DRAWCOINS ()
DECLARE SUB DRAWMARIO ()
DECLARE SUB GETFONT (y)
DECLARE SUB LOADLEVEL ()
DECLARE SUB RESETDSP ()
DECLARE SUB DMAPLAY (Segment&, Offset&, Length&)
DECLARE SUB LOADGPH (n$)
DECLARE SUB CHGCOLS (r!, g!, B!)
DECLARE SUB GETGPH ()
DECLARE SUB DRAWTILES ()
DECLARE SUB CLIPTILES ()
DECLARE SUB MASK ()
DECLARE SUB CONTROL ()
DECLARE SUB CLEARKEYS ()
DECLARE SUB SETGAME ()
DECLARE SUB DRAWENEMY ()
DECLARE SUB NEWGAME ()
DECLARE SUB LOSELIFE ()
DECLARE FUNCTION DMADONE ()
DECLARE SUB GETBLASTER (DMA, BasePort, IRQ)
DECLARE SUB WRITEDSP (ibyte)
DECLARE SUB PLAYMUSIC ()
DECLARE SUB LOADFX (file$)
DECLARE SUB PLAYFX (fxnum)
DECLARE SUB PUTFONT (fontnum$, xstart)


COMMON SHARED rdir, n, xlen, dir, move, ytile, ymove AS SINGLE, curmus
COMMON SHARED ecount, eframe, lives, dotask, drop, score, musdel, muspl, mtime!
COMMON SHARED cframe, level, world, die, nextlevel
DIM SHARED snd(1 TO 4, 1 TO 13) AS STRING * 30, xdat(0 TO 1)
DIM SHARED pal(0 TO 2, 0 TO 255), byte AS STRING * 1
DIM SHARED sprites(0 TO 129, 0 TO 120), map(-1 TO 400, 0 TO 11)
DIM SHARED font(0 TO 100, 0 TO 9), plst(0 TO 6) AS LONG
DIM SHARED xpl AS LONG, ypl AS LONG, px AS SINGLE, py AS SINGLE, spframe, jump
DIM SHARED sel(0 TO 1), enemy(0 TO 40, 0 TO 5)
COMMON SHARED BasePort, LenPort, Channel, cfrdir, frcount, fps, coins, onground, jmax, xst, xnd
DIM SHARED snds(1 TO 4) AS STRING * 30
DIM SHARED WavBuffer(0 TO 0) AS STRING * 32767, ycoor(0 TO 11)
DIM SHARED coins(0 TO 100, 0 TO 2)
CONST timeconst = 256 - 1000000 \ 22050
COMMON SHARED side

'fps: 72 to 77
'fps: 34 to 37

cfrdir = 1


SCREEN 13: CLS
INTRO
DO: LOOP WHILE INKEY$ = ""
LOADGPH "graphics"
GETGPH
LOADFX "effects.snd"
LINE (0, 8)-(319, 199), 0, BF
NEWGAME
COLOR 6
DEF SEG
GETBLASTER Channel, BasePort, IRQ

t! = TIMER
DO
  SETGAME
  DO
    CLIPTILES
    DRAWTILES
    IF die = 0 THEN CONTROL
    WAIT &H3DA, 8
    DEF SEG
    IF n > 15 THEN
      n = n - 16
      xpl = xpl - 1
    ELSEIF n < 0 THEN
      n = 16 + n
      xpl = xpl + 1
    END IF
    IF TIMER - t! > .99 THEN
      fps = frame
      frame = 0
      t! = TIMER
    END IF
    frcount = frcount + 1
    IF frcount = 3 THEN
      frcount = 0
      IF eframe = 1 THEN
        eframe = 0
      ELSE
        eframe = 1
      END IF
      IF move = 1 THEN
        IF spframe = 1 THEN
          spframe = 0
        ELSE
          spframe = 1
        END IF
      ELSE
        spframe = 0
      END IF
    END IF
    frame = frame + 1
    IF xpl = 370 AND level = 2 OR xpl = 334 AND level = 3 THEN LEVELFINISH
    IF level = 4 THEN ENDING
    IF DMADONE THEN PLAYMUSIC
    'LOCATE 1, 1: PRINT fps
    
  LOOP WHILE die < 30 AND nextlevel = 0
  IF die > 0 THEN LOSELIFE
  CLOSE #2
LOOP

level1:

DATA 240,320,110, 560,608,78
DATA 720,816,110, 832,928,110, 1392,1488,62
DATA 1552,1744,142, 2336,2448,126, 2688,2704,30
DATA 3008,3200,94, 3440,3648,126, 3744,3872,94, 3744,3920,142
DATA 4320,4384,126, 4400,4464,126, 4320,4368,30, 4144,4224,126
DATA 999

level2:

DATA 576,640,142, 960,992,94, 864,1072,158
DATA 1488,1504,142, 1808,1856,30, 1856,1952,94
DATA 2560,2576,94, 2592,2608,94
DATA 2864,3008,158, 3024,3168,158, 3360,3392,78, 3680,3760,94
DATA 4432,4560,94, 4752,4832,94, 4848,4912,94, 5040,5056,142
DATA 5104,5120,110, 5296,5328,78, 5392,5424,78

DATA 999

level3:

DATA 416,528,126, 448,560,126, 480,592,126, 832,880,94
DATA 1344,1536,142, 1424,1520,110, 1968,2032,126, 2224,2256,110
DATA 2320,2352,78, 2592,2608,62, 2672,2688,94, 2816,3008,126
DATA 3088,3104,78, 3168,3264,62, 3488,3520,32
DATA 999

SUB CHGCOLS (r!, g!, B!)

'this sub controls rgb brightness and color attributes

FOR attr = 0 TO 255
  OUT &H3C8, attr
  red = pal(0, attr) * r!
  IF red > 63 THEN red = 63
  OUT &H3C9, red
  green = pal(1, attr) * g!
  IF green > 63 THEN green = 63
  OUT &H3C9, green
  blue = pal(2, attr) * B!
  IF blue > 63 THEN blue = 63
  OUT &H3C9, blue
NEXT

END SUB

SUB CLEARKEYS

  FOR B = 1 TO 10
    bad$ = INKEY$
  NEXT

END SUB

SUB CLIPTILES

  'this sub draws the pixels of tiles that are on the edges of the screen
 
  FOR x& = 0 TO 15
    plst(0) = x& - n + 4
    plst(2) = x& + 8 * 320
    FOR ypl = 0 TO 11
      IF x& < n THEN
        plst(1) = plst(0) + 260 * map(xpl - 1, ypl) + 16
        plst(3) = plst(2) + ypl * 5120
      ELSE
        plst(1) = plst(0) + 260 * map(xpl + 19, ypl)
        plst(3) = plst(2) + ypl * 5120 + 304
      END IF
      FOR y& = 0 TO 15
        DEF SEG = VARSEG(sprites(0, 0))
        attr = PEEK(plst(1) + y& * 16)
        pl& = plst(3) + y& * 320
        DEF SEG = &HA000
        POKE (pl&), attr
     NEXT
   NEXT
 NEXT

END SUB

SUB CONTROL
 
  CLEARKEYS
  sel(0) = INP(&H60)
  SELECT CASE sel(0)
  CASE 170, 200, 203, 205, 208
    sel(0) = 0
    sel(1) = 0
    move = 0
  CASE 75, 77
    sel(1) = sel(0)
  END SELECT
  IF sel(0) = 77 THEN
    dir = 0
  ELSEIF sel(0) = 75 THEN
    dir = 4
  END IF
  IF px < 112 OR px > 112 THEN
    xst = (px - 8) / 16: xnd = xst + 1
  ELSE
    xst = 6: xnd = 7
  END IF
  FOR sn = 0 TO 1
      SELECT CASE sel(sn)
      CASE 80
        IF level = 1 THEN
          IF xpl * 16 + 15 >= 4543 AND xpl * 16 <= 4559 AND ytile = 1 AND jump = 0 AND drop = 0 THEN
            LEVELFINISH
          END IF
        END IF
      CASE 75
        IF sn = 0 OR sel(1) <> sel(0) THEN
          value = 0
          IF ymove = 3 THEN
            y = 0
          ELSE
            y = 1
          END IF
          SELECT CASE map(xpl + xst, ytile + y)
          CASE 0, 1, 20 TO 28, 40, 88 TO 90, 107 TO 110, 91, 92, 111, 112
            value = 1: move = 1
          END SELECT
          IF xpl > 0 AND px = 112 AND value > 0 THEN
            n = n + 2
          ELSEIF value > 0 THEN
            IF px > 0 THEN px = px - 2
          END IF
        END IF
      CASE 77
        IF sn = 0 OR sel(1) <> sel(0) THEN
          value = 0
          IF ymove = 3 THEN
            y = 0
          ELSE
            y = 1
          END IF
          SELECT CASE map(xpl + xnd, ytile + y)
          CASE 0, 1, 20 TO 28, 40, 88 TO 90, 107 TO 110, 91, 92, 111, 112
            value = 1: move = 1
          END SELECT
          IF xpl <= xlen AND px = 112 AND value > 0 THEN
            n = n - 2
          ELSEIF value > 0 THEN
            IF px < 304 THEN px = px + 2
          END IF
        END IF
      CASE 57
        IF jump = 0 AND drop = 0 AND sn = 0 AND onground = 1 THEN
          jump = 1
          onground = 0
          PLAYFX 1
        END IF
      CASE 1
        ENDING
        SYSTEM
      END SELECT
  NEXT
  xmin = xst: xmax = xnd
  IF n = 14 AND px = 112 OR dir = 0 AND px <> 112 THEN
    xmin = xst: xmax = xst
  ELSEIF n = 0 AND px = 112 OR dir = 4 AND px <> 112 THEN
    xmin = xnd: xmax = xnd
  END IF
  FOR x = xmin TO xmax
    SELECT CASE map(xpl + x, ytile + 1)
    CASE 0, 1, 20 TO 28, 40, 88 TO 90, 107 TO 110, 91, 92, 111, 112
      IF jump = 0 THEN
        drop = 1
        onground = 0
      END IF
    CASE ELSE
      onground = 1
      drop = 0
      dotask = 0
      EXIT FOR
    END SELECT
  NEXT
  IF drop = 1 AND jump = 0 THEN
    ymove = ymove - 1
    IF ymove < 0 THEN
      ymove = 3
      ytile = ytile + 1
    END IF
    py = py + 4
    IF py > 168 THEN
      die = 1
      CLOSE #2
      OPEN "die.wav" FOR BINARY AS #2
      PLAYMUSIC
    END IF
  END IF
  IF jump > 0 AND drop = 0 AND jump < 14 THEN
    jump = jump + 1
    side = 0
    FOR x = xst TO xnd
      SELECT CASE map(xpl + x, ytile)
      CASE 0, 1, 20 TO 28, 40, 88 TO 90, 107 TO 110, 91, 92, 111, 112
        side = x
      END SELECT
    NEXT
    xmin = xst: xmax = xnd
    SELECT CASE side
    CASE xst
      IF n <> 14 AND px = 112 OR dir = 4 AND px <> 112 THEN
        xmin = xnd: xmax = xnd
      END IF
    CASE xnd
      IF n <> 0 AND px = 112 OR dir = 0 AND px <> 112 THEN
        xmin = xst: xmax = xst
      END IF
    END SELECT
    FOR x = xmin TO xmax
      SELECT CASE map(xpl + x, ytile)
      CASE 0, 1, 2, 20 TO 28, 40, 88 TO 90, 107 TO 110, 91, 92, 111, 112
        IF py > 12 THEN
          ymove = ymove + 1
          IF ymove = 4 THEN
            ymove = 0
            ytile = ytile - 1
          END IF
          py = py - 4
          EXIT FOR
        END IF
      END SELECT
    NEXT
  ELSEIF jump = 14 THEN
    jump = 0: drop = 1
  END IF
 
END SUB

SUB DELAY

  t! = TIMER
  DO: LOOP WHILE TIMER - t! < .01

END SUB

FUNCTION DMADONE

Count = INP(LenPort)
Count2 = INP(LenPort)
Count& = CLNG(Count + 1) * CLNG(Count2 + 1)
IF (Count& - 1) >= &HFFFF& THEN junk = INP(DSPDataAvail): DMADONE = -1

END FUNCTION

SUB DMAPLAY (Segment&, Offset&, Length&)

Page = 0
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel
    CASE 0
       PgPort = &H87
       AddPort = &H0
       LenPort = &H1
       ModeReg = &H48
    CASE 1
       PgPort = &H83
       AddPort = &H2
       LenPort = &H3
       ModeReg = &H49
    CASE 2
       PgPort = &H81
       AddPort = &H4
       LenPort = &H5
       ModeReg = &H4A
    CASE 3
       PgPort = &H82
       AddPort = &H6
       LenPort = &H7
       ModeReg = &H4B
END SELECT

OUT &HA, &H4 + Channel
OUT &HC, &H0
OUT &HB, ModeReg
OUT AddPort, MemLoc& AND &HFF
OUT AddPort, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page = Page + 1
IF (MemLoc& AND 131072) THEN Page = Page + 2
IF (MemLoc& AND 262144) THEN Page = Page + 4
IF (MemLoc& AND 524288) THEN Page = Page + 8
OUT PgPort, Page
OUT LenPort, Length& AND &HFF
OUT LenPort, (Length& AND &HFFFF&) \ &H100
OUT &HA, Channel
WRITEDSP &H40
WRITEDSP timeconst
WRITEDSP &H14
WRITEDSP (Length& AND &HFF)
WRITEDSP ((Length& AND &HFFFF&) \ &H100)

END SUB

SUB DRAWCOINS

  xdat(0) = xpl * 16
  xdat(1) = xpl * 16 + 300
  FOR cnum = 0 TO 100
    IF coins(cnum, 2) = 1 THEN
      IF coins(cnum, 0) >= xdat(0) AND coins(cnum, 0) <= xdat(1) THEN
        newxpl = coins(cnum, 0) - xdat(0) + n
        PUT (newxpl, coins(cnum, 1)), sprites(0, 44 + cframe), AND
        PUT (newxpl, coins(cnum, 1)), sprites(0, 40 + cframe), XOR
        IF newxpl + 15 > px AND newxpl < px + 15 THEN
          IF py + 20 > coins(cnum, 1) AND py < coins(cnum, 1) + 15 THEN
            coins = coins + 1
            IF coins = 100 THEN
              coins = 0
              lives = lives + 1
            END IF
            score = score + 50
            coins(cnum, 2) = 0
            PLAYFX 3
          END IF
        END IF
      END IF
    END IF
  NEXT

END SUB

SUB DRAWENEMY

  'enemy(enum,0)=xmax
  'enemy(enum,1)=ystart
  'enemy(enum,2)=direction
  'enemy(enum,3)=xmin
  'enemy(enum,4)=xmove
  'enemy(enum,5)=estat
 
  FOR enum = 0 TO 20
    IF enemy(enum, 3) <> 999 AND enemy(enum, 5) > 0 THEN
      IF (xpl + 19) * 16 > enemy(enum, 4) AND enemy(enum, 5) = 1 AND ((xpl - 1) * 16 < enemy(enum, 4)) THEN
        newxpl = enemy(enum, 4) + xpl * -16 + n
        IF newxpl > 0 AND newxpl < 305 THEN
          PUT (newxpl, enemy(enum, 1)), sprites(0, 51 + eframe + enemy(enum, 2)), AND
          PUT (newxpl, enemy(enum, 1)), sprites(0, 49 + eframe + enemy(enum, 2)), XOR
          PUT (newxpl, enemy(enum, 1) + 16), sprites(0, 71 + eframe + enemy(enum, 2)), AND
          PUT (newxpl, enemy(enum, 1) + 16), sprites(0, 69 + eframe + enemy(enum, 2)), XOR
        END IF
      ELSEIF enemy(enum, 5) > 1 THEN
        newxpl = enemy(enum, 4) + xpl * -16 + n
        IF newxpl > 0 AND newxpl < 305 THEN
          PUT (newxpl, enemy(enum, 1) + 4), sprites(0, 68), AND
          PUT (newxpl, enemy(enum, 1) + 4), sprites(0, 48), XOR
          IF enemy(enum, 5) < 10 THEN
            enemy(enum, 5) = enemy(enum, 5) + 1
            enemy(enum, 1) = enemy(enum, 1) + 1
          END IF
        END IF
      END IF
      IF enemy(enum, 5) = 1 THEN
        IF enemy(enum, 2) = 0 THEN
          xchg = -1
        ELSE
          xchg = 1
        END IF
        enemy(enum, 4) = enemy(enum, 4) + 2 * xchg
        IF enemy(enum, 4) = enemy(enum, 3) THEN enemy(enum, 2) = 4
        IF enemy(enum, 4) = enemy(enum, 0) THEN enemy(enum, 2) = 0
        IF py + 10 > enemy(enum, 1) AND py < enemy(enum, 1) + 15 THEN
          newxpl = enemy(enum, 4) + xpl * -16 + n
          IF newxpl + 15 > px AND newxpl < px + 15 THEN
            IF drop = 1 THEN
              enemy(enum, 5) = 2: jump = 8
              drop = 0
              PLAYFX 2
              score = score + 100
            ELSE
              IF die = 0 THEN
                die = 1
                CLOSE #2
                OPEN "die.wav" FOR BINARY AS #2
                PLAYMUSIC
              END IF
            END IF
          END IF
        END IF
      END IF
    END IF
  NEXT


END SUB

SUB DRAWMARIO

  IF die = 0 THEN
    IF jump = 0 THEN
      PUT (px, py), sprites(0, 11 + spframe + dir), AND
      PUT (px, py), sprites(0, 9 + spframe + dir), XOR
      PUT (px, py + 16), sprites(0, 31 + spframe + dir), AND
      PUT (px, py + 16), sprites(0, 29 + spframe + dir), XOR
    ELSEIF jump > 0 THEN
      PUT (px, py), sprites(0, dir / 2 * 20 + 18), AND
      PUT (px, py), sprites(0, dir / 2 * 20 + 17), XOR
      PUT (px, py + 16), sprites(0, (dir / 2 + 1) * 20 + 18), AND
      PUT (px, py + 16), sprites(0, (dir / 2 + 1) * 20 + 17), XOR
    END IF
  END IF

END SUB

SUB DRAWTILES

  'this sub draws the background tiles and then the sprites.
 
  DEF SEG = &HA000
  FOR y = 8 TO 184 STEP 16
    ymap = (y - 8) / 16
    FOR x = n TO 303 STEP 16
      xmap = (x - n) / 16 + xpl
      PUT (x, y), sprites(0, map(xmap, ymap)), PSET
    NEXT
  NEXT
  DRAWMARIO
  DRAWENEMY
  DRAWCOINS
  PUTFONT STR$(world), 42
  PUTFONT STR$(level), 64
  PUTFONT STR$(score), 124
  PUTFONT STR$(coins), 232
  PUTFONT STR$(lives), 302
  IF frcount = 0 THEN
    cframe = cframe + cfrdir
    IF cframe = 3 OR cframe = 0 THEN cfrdir = cfrdir * -1
  END IF
 
END SUB

SUB ENDING

CLOSE
SCREEN 12: CLS
COLOR 15
LOCATE 2, 2: PRINT "Thanks for playing Super Mario QB. Send your"
LOCATE 3, 2: PRINT "comments to spheresfantasy@yahoo.ca and"
LOCATE 4, 2: PRINT "be sure to watch for new releases."
DO: LOOP WHILE INKEY$ = ""
SYSTEM

END SUB

SUB GETBLASTER (DMA, BasePort, IRQ)

FOR Length = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), Length, 1)
      CASE "A"
        BasePort = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length + 1, 3))
      CASE "I"
        IRQ = VAL(MID$(ENVIRON$("BLASTER"), Length + 1, 1))
      CASE "D"
        DMA = VAL(MID$(ENVIRON$("BLASTER"), Length + 1, 1))
   END SELECT
NEXT

END SUB

SUB GETFONT (y)

FOR x = 0 TO 9
  GET (x * 8 + 1, y)-(x * 8 + 8, y + 7), font(0, x)
NEXT

END SUB

SUB GETGPH

FOR y = 0 TO 5
  FOR x = 0 TO 19
    GET (x * 16 + 1, y * 16 + 8)-(x * 16 + 16, y * 16 + 23), sprites(0, y * 20 + x)
  NEXT
NEXT

END SUB

SUB INTRO

CHGCOLS 0, 0, 0
LOADGPH "logo"
br! = 0: bdir! = .05
DO
  IF br! < 1 THEN CHGCOLS br!, br!, br!
  br! = br! + bdir!
  IF br! > 1.5 THEN bdir! = bdir! * -1
  DELAY
LOOP WHILE br! > 0
LOADGPH "title"
CHGCOLS 1, 1, 1

END SUB

SUB LEVELFINISH

cdraw = 0
DO
  FOR chg = 0 TO 2
    LINE (chg + cdraw, chg + cdraw)-(319 - cdraw - chg, 199 - cdraw - chg), 0, B
  NEXT
  DELAY
  cdraw = cdraw + 3
LOOP WHILE cdraw < 200
nextlevel = 1
level = level + 1

END SUB

SUB LOADFX (file$)

OPEN file$ FOR BINARY AS #1
DIM id AS STRING * 4
GET #1, , id
GET #1, , NumSound
FOR i = 1 TO NumSound
  IF EOF(1) THEN EXIT FOR
  GET #1, , snds(i)
  temp$ = SPACE$(20)
  GET #1, , temp$
NEXT i
CLOSE #1

END SUB

SUB LOADGPH (n$)

CHGCOLS 0, 0, 0
DEF SEG = &HA000

BLOAD n$ + ".gph", 0
OPEN n$ + ".col" FOR BINARY AS #1
FOR attr = 0 TO 255
  FOR rgb = 0 TO 2
    GET #1, attr * 3 + rgb + 1, byte
    pal(rgb, attr) = ASC(byte)
  NEXT
NEXT
CLOSE #1
IF n$ = "graphics" THEN MASK

END SUB

SUB LOADLEVEL

SELECT CASE level
CASE 1: OPEN "level1.txt" FOR BINARY AS #2: size = 310
CASE 2: OPEN "level2.txt" FOR BINARY AS #2: size = 400
CASE 3: OPEN "level3.txt" FOR BINARY AS #2: size = 355
END SELECT
FOR y = 0 TO 11
  FOR x = 0 TO size
    GET #2, , map(x, y)
  NEXT
NEXT
CLOSE #2
xlen = x - 21
SELECT CASE level
CASE 1: OPEN "coins1.txt" FOR BINARY AS #2
CASE 2: OPEN "coins2.txt" FOR BINARY AS #2
CASE 3: OPEN "coins3.txt" FOR BINARY AS #2
END SELECT
  FOR cnum = 0 TO 100
    FOR c = 0 TO 2
      GET #2, , coins(cnum, c)
    NEXT
  NEXT
CLOSE #2


END SUB

SUB LOSELIFE

  lives = lives - 1
  IF lives = 0 THEN
    CLS
    COLOR 1: LOCATE 13, 15: PRINT "GAME OVER"
    t! = TIMER
    DO: LOOP WHILE TIMER - t! < 2
    NEWGAME
  END IF
  CLOSE #2
  OPEN "music1.wav" FOR BINARY AS #2

END SUB

SUB MASK

FOR n = 0 TO 4
  IF n = 0 THEN
    xmin& = 11: xmax& = 12
    ymin& = 0: ymax& = 3
  ELSEIF n = 1 THEN
    xmin& = 15: xmax& = 16
    ymin& = 0: ymax& = 3
  ELSEIF n = 2 THEN
    xmin& = 18: xmax& = 18
    ymin& = 0: ymax& = 3
  ELSEIF n = 3 THEN
    xmin& = 4: xmax& = 7
    ymin& = 2: ymax& = 2
  ELSE
    xmin& = 8: xmax& = 8
    ymin& = 3: ymax& = 3
  END IF
  FOR y1& = ymin& TO ymax&
    FOR x1& = xmin& TO xmax&
      FOR y2& = 0 TO 15
        FOR x2& = 0 TO 15
          pl& = y1& * 5120 + (y2& + 8) * 320 + x1& * 16 + x2& + 1
          IF PEEK(pl&) = 0 THEN
            POKE (pl&), 255
          ELSE
            POKE (pl&), 0
          END IF
        NEXT
      NEXT
    NEXT
  NEXT
NEXT

END SUB

SUB NEWGAME

  lives = 3: score = 0
  curmus = 1: coins = 0
  level = 1: world = 1
 
END SUB

SUB PLAYFX (fxnum)

  IF fxnum = 0 THEN EXIT SUB
  FOR i = 1 TO 15
    OUT &H388, ASC(MID$(snds(fxnum), (i * 2) - 1, 1))
    OUT &H389, ASC(MID$(snds(fxnum), (i * 2)))
  NEXT i

END SUB

SUB PLAYMUSIC
 
  
  DEF SEG
  RESETDSP
  Length& = LOF(2) - LOC(2)
  IF Length& > 32767 THEN Length& = 32767
  GET #2, , WavBuffer(0)
  IF EOF(2) AND die = 0 THEN SEEK #2, 44
  DMAPLAY VARSEG(WavBuffer(0)), VARPTR(WavBuffer(0)), Length&
  IF die > 0 AND EOF(2) THEN die = die + 1

END SUB

SUB PUTFONT (fontnum$, xstart)

FOR x = 2 TO LEN(fontnum$)
  PUT ((x - 2) * 8 + xstart, 0), font(0, VAL(MID$(fontnum$, x, 1))), PSET
NEXT

END SUB

SUB RESETDSP

OUT BasePort + 6, 1
FOR Count = 1 TO 4
   junk = INP(BasePort + 6)
NEXT
OUT BasePort + 6, 0

END SUB

SUB SETGAME

  'enemy(enum,0)=xmax
  'enemy(enum,1)=ystart
  'enemy(enum,2)=direction
  'enemy(enum,3)=xmin
  'enemy(enum,4)=xmove
  'enemy(enum,5)=estat

  DEF SEG
  SELECT CASE level
  CASE 1: RESTORE level1
  CASE 2: RESTORE level2
  CASE 3: RESTORE level3
  END SELECT
  FOR enum = 0 TO 20
    READ enemy(enum, 3)
    IF enemy(enum, 3) = 999 THEN EXIT FOR
    READ enemy(enum, 0)
    enemy(enum, 2) = 0
    READ enemy(enum, 1)
    enemy(enum, 4) = enemy(enum, 0)
    enemy(enum, 5) = 1
  NEXT
  emax = enum - 1
  LOADLEVEL
  LOADGPH "graphics"
  dir = 0
  move = 0
  die = 0
  n = 0
  nextlevel = 0
  xpl = 0
  ymove = 3
  onground = 1
  t! = TIMER
  sel(0) = 0
  sel(1) = 0
  SELECT CASE level
  CASE 1
    OPEN "music1.wav" FOR BINARY AS #2
    py = 117: ytile = 7: px = 100
    GETFONT 192
  CASE 2
    OPEN "music2.wav" FOR BINARY AS #2
    py = 69: ytile = 4: px = 54: ymove = 3
    FOR y& = 0 TO 7
      FOR x& = 0 TO 319
        pl& = y& * 320 + x&
        IF PEEK(pl&) = 2 THEN POKE (pl&), 125
      NEXT
    NEXT
    GETFONT 184
  CASE 3
    OPEN "music3.wav" FOR BINARY AS #2
    py = 101: ytile = 6: px = 100
    GETFONT 192
  END SELECT
  GET #2, 44, WavBuffer(0)
  Length& = 32767
  DMAPLAY VARSEG(WavBuffer(0)), VARPTR(WavBuffer(0)), Length&
  CHGCOLS 1, 1, 1
 
END SUB

SUB WRITEDSP (ibyte)

DO: LOOP WHILE INP(BasePort + 12) AND &H80
OUT BasePort + 12, ibyte

END SUB

