'CATSLE.BAS
'Catsle
'vers 1.0
'created by Derek Andrews

'This is a 2-D scrolling game with a side view like Super Mario using my
'2-D scrolling engine.

'sub declarations
DECLARE SUB UpdateFrame ()
DECLARE SUB CatProg ()
DECLARE SUB CreateSprites ()
DECLARE SUB ClearBuffer ()
DECLARE SUB CreatePal ()
DECLARE SUB CreateTiles ()
DECLARE SUB InitProg ()
DECLARE SUB PalChange (Colour%, Red%, Green%, Blue%)
DECLARE SUB ReadGameMaps ()
DECLARE SUB ResetScreen ()
DECLARE SUB ResetVars ()
DECLARE SUB TranslateDown (Increment%)
DECLARE SUB TranslateLeft (Increment%)
DECLARE SUB TranslateRight (Increment%)
DECLARE SUB TranslateUp (Increment%)
DECLARE SUB UpdateScreen ()
 
'function declarations
DECLARE FUNCTION LeftSide% ()
DECLARE FUNCTION RightSide% ()
DECLARE FUNCTION Bottom% ()
DECLARE FUNCTION Top% ()
DECLARE FUNCTION HitKey% ()

'constants
CONST True% = 1         'true/false flags
CONST False% = 0
CONST NumTiles% = 2     'number of foreground tiles
CONST NumSprites% = 6   'total number of cat sprites
CONST SpriteHeight% = 20     'width and height of each sprite
CONST SpriteWidth% = 16
CONST JumpFrame% = 3     'frame of cat when jumping
CONST CatX% = 150     'cat's constant X and Y coordinates
CONST CatY% = 75
CONST MapWidth% = 88    'width of each scrolling level
CONST MapHeight% = 31   'height of each scrolling level
CONST ScrollSpeed% = 2  'increment for scrolling
CONST Left% = 0         'left and right
CONST Right% = 3
CONST NumMaps% = 1      'number of scrolling levels
CONST KeyLeft% = 75     'scancode value of left arrow key
CONST KeyRight% = 77    'scancode value of right arrow key
CONST KeyDown% = 80     'scancode value of down arrow key
CONST KeyUp% = 72       'scancode value of up arrow key
CONST Esc% = 1          'scancode value of escape key

'global variables
DIM SHARED ArrayX%, ArrayY%    'X, Y variables for index number of GameMap matrix
DIM SHARED TileX%, TileY%      'X, Y variables for position of tile on screen
DIM SHARED CatDirection%       '-1 for facing left, 1 for right
DIM SHARED JumpFlag%           '1 means jump button was pressed; 0 means not
DIM SHARED CatFrame%           '= a 1, 2 or 3 specifying animation frame.
DIM SHARED CurrentLevel%    'current level, or map number

'global arrays
DIM SHARED Tiles(21, 1 TO NumTiles%)     'array to hold tile images
DIM SHARED CatSprites(100, 1 TO NumSprites%)       'array to hold cat sprites
DIM SHARED GameMaps%(1 TO MapWidth%, 1 TO MapHeight%, 1 TO NumMaps%)     'matrix for gamemap

InitProg     'program startup---called ONCE

'-----main program block-----

DO
     ClearBuffer     'clear keyboard buffer
     ScanCode% = HitKey%     'get scancode of key hit by user
     UpdateScreen
     CatProg     'sub program which handles falling and jumping
     SELECT CASE ScanCode%     'set of conditions to respond to input
          CASE KeyRight%
               IF RightSide% = 0 THEN
                    TranslateLeft ScrollSpeed%     'translate level view to the left
                    IF Bottom% <> 0 THEN UpdateFrame
               END IF
               CatDirection% = Left%
          CASE KeyLeft%
               IF LeftSide% = 0 THEN
                    TranslateRight ScrollSpeed%    'translate level view to the right
                    IF Bottom% <> 0 THEN UpdateFrame
               END IF
               CatDirection% = Right%
          CASE KeyUp%
               JumpFlag% = True%
          CASE Esc%     'user hits escape, quit program
               ResetScreen     'reset text screen mode for DOS
               END
          CASE IS <> KeyUp%
               JumpFlag% = False%
     END SELECT
LOOP

'game map data---you can edit these or add your own, but make sure the
'matrixes are MapWidth% by MapHeight% and change the constant NumMaps% to
'play your level. a = 1, b = 2...etc. represent index numbers in Tiles
'array.
DATA bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
DATA b                                                                                      b
DATA b                                                                                      b
DATA b                                                                                      b
DATA b  ababababababababababbababaab                                                        b
DATA b                              ab                                                      b
DATA b                                ab                                                    b
DATA b                                  ab                                                  b
DATA b                                    ab                                                b
DATA b                                      ab                                              b
DATA b                                                                                      b
DATA b                                        ab                                            b
DATA b                                                                                      b
DATA b                                      aababababababa                                  b
DATA b                                                                                      b
DATA b                                                 abababababab                         b
DATA b                                                                                      b
DATA b                                          ababababababa                               b
DATA b                                                                                      b
DATA b                                                    ababababababab                    b
DATA b                                                                                      b
DATA b                                              abababababab                            b
DATA b                                                                                      b
DATA bababababababababab                                       abab                         b
DATA bbababababababababa                                                                    b
DATA ba   ab   ab    ab                                             ababa                   b
DATA b b   ab b  abab                                                                       b
DATA b  a   ba    ba                                                                        b
DATA b   b a bab    ba                                                                      b
DATA b    a     ab    b                                                                     b
DATA bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb

'tile data---you can edit these, but you will have to change the game map
'data to see them displayed.
DATA 2,2,2,2,2,2,2,2,2,2
DATA 2,1,3,3,3,3,3,3,1,12
DATA 2,3,3,3,3,3,3,3,3,12
DATA 2,3,3,3,3,3,3,3,3,12
DATA 2,3,3,3,3,3,3,3,3,12
DATA 2,3,3,3,3,3,3,3,3,12
DATA 2,3,3,3,3,3,3,3,3,12
DATA 2,3,3,3,3,3,3,3,3,12
DATA 2,1,3,3,3,3,3,3,1,12
DATA 2,12,12,12,12,12,12,12,12,12

DATA 9,9,9,9,9,9,9,9,9,9
DATA 9,10,11,11,11,11,11,11,10,8
DATA 9,11,11,11,11,11,11,11,11,8
DATA 9,11,11,11,11,11,11,11,11,8
DATA 9,11,11,11,11,11,11,11,11,8
DATA 9,11,11,11,11,11,11,11,11,8
DATA 9,11,11,11,11,11,11,11,11,8
DATA 9,11,11,11,11,11,11,11,11,8
DATA 9,10,11,11,11,11,11,11,10,8
DATA 9,8,8,8,8,8,8,8,8,8

'sprite data---you can edit these. These are the three animation sprites of
'the main character---the cat.
CatSprites:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,4,4,4,4,0,0,0,0,0,0
DATA 0,0,0,0,0,0,13,13,13,4,0,0,0,0,0,0
DATA 0,0,0,0,6,6,6,5,5,15,15,0,0,0,0,0
DATA 0,0,0,5,6,7,7,6,6,15,0,2,2,0,0,0
DATA 0,0,4,5,6,7,7,7,7,6,5,2,2,0,0,0
DATA 0,0,4,5,6,6,6,6,6,3,6,6,4,0,0,0
DATA 0,0,0,4,5,5,5,5,5,3,3,3,5,0,0,0
DATA 0,0,0,0,4,4,4,4,4,4,4,4,0,0,0,0
DATA 0,4,0,0,0,3,3,3,3,3,3,0,0,0,0,0
DATA 4,6,4,0,3,2,6,6,2,2,2,3,0,0,0,0
DATA 4,5,4,3,2,3,6,6,3,3,3,2,3,0,0,0
DATA 4,5,5,3,2,6,6,6,6,3,3,2,3,0,0,0
DATA 4,5,5,3,2,3,6,6,3,3,3,2,3,0,0,0
DATA 0,4,4,3,2,3,3,3,3,3,3,2,3,0,0,0
DATA 0,0,4,6,3,2,2,2,2,2,2,3,0,0,0,0
DATA 0,0,0,4,4,3,3,3,3,3,3,0,0,0,0,0
DATA 0,0,6,4,6,0,0,0,6,6,6,6,6,6,0,0
DATA 0,6,4,4,4,6,0,0,6,4,4,4,6,0,0,0
DATA 0,0,6,6,6,6,6,0,6,6,6,6,0,0,0,0

DATA 0,0,0,0,0,0,0,4,4,4,0,0,0,0,0,0
DATA 0,0,0,0,0,0,4,13,13,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,13,13,13,4,0,0,0,0,0,0
DATA 0,0,0,0,6,6,6,5,5,15,15,0,0,0,0,0
DATA 0,0,0,5,6,7,7,6,6,15,0,2,2,0,0,0
DATA 0,0,4,5,6,7,7,7,7,6,5,2,2,0,0,0
DATA 0,0,4,5,6,6,6,6,6,3,6,6,4,0,0,0
DATA 0,4,0,4,5,5,5,5,5,3,3,3,5,0,0,0
DATA 4,6,4,0,4,4,4,4,4,4,4,4,0,0,0,0
DATA 4,6,4,0,0,3,3,3,3,3,3,0,0,0,0,0
DATA 4,6,4,0,3,2,6,6,2,2,2,3,0,0,0,0
DATA 4,5,4,3,2,3,6,6,3,3,3,2,3,0,0,0
DATA 4,5,5,3,2,6,6,6,6,3,3,2,3,0,0,0
DATA 4,5,5,3,2,3,6,6,3,3,3,2,3,0,0,0
DATA 0,4,4,3,2,3,3,3,3,3,3,2,3,0,0,0
DATA 0,0,4,6,3,2,2,2,2,2,2,3,0,0,0,0
DATA 0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0
DATA 0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0
DATA 0,0,0,0,0,6,4,4,4,6,0,0,0,0,0,0
DATA 0,0,0,0,6,6,6,6,6,6,6,0,0,0,0,0

DATA 0,0,0,0,0,0,0,4,4,4,0,0,0,0,0,0
DATA 0,0,0,0,0,0,4,13,13,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,13,13,13,4,0,0,0,0,0,0
DATA 0,0,0,0,6,6,6,5,5,15,15,0,0,0,0,0
DATA 0,0,0,5,6,7,7,6,6,15,0,2,2,0,0,0
DATA 0,0,4,5,6,7,7,7,7,6,5,2,2,0,0,0
DATA 0,0,4,5,6,6,6,6,6,3,6,6,4,0,0,0
DATA 0,0,0,4,5,5,5,5,5,3,3,3,5,0,0,0
DATA 0,4,0,0,4,4,4,4,4,4,4,4,0,0,0,0
DATA 4,6,4,0,0,3,3,3,3,3,3,0,0,0,0,0
DATA 4,6,4,0,3,2,2,6,6,2,2,3,0,0,0,0
DATA 4,5,4,3,2,3,3,6,6,3,3,2,3,0,0,0
DATA 4,5,5,3,2,3,6,6,6,6,3,2,3,0,0,0
DATA 4,5,5,3,2,3,3,6,6,3,3,2,3,0,0,0
DATA 0,4,4,3,2,3,3,3,3,3,3,2,3,0,0,0
DATA 0,0,4,6,3,2,2,2,2,2,2,3,0,0,0,0
DATA 0,0,0,4,4,3,3,3,3,3,3,0,0,0,0,0
DATA 0,0,6,4,6,0,0,0,6,6,6,6,6,6,0,0
DATA 0,6,4,4,4,6,0,0,6,4,4,4,6,0,0,0
DATA 0,0,6,6,6,6,6,0,6,6,6,6,0,0,0,0

'This function tests the entire bottom of the cat for collision
'
FUNCTION Bottom%

Bottom% = 0
FOR X = 1 TO SpriteWidth% - 2
     IF POINT(CatX% + X, CatY% + SpriteHeight% + 2) <> 0 THEN Bottom% = POINT(CatX% + X, CatY% + SpriteHeight% + 2)
NEXT X

END FUNCTION

'This procedure handles things like falling and jumping
'
SUB CatProg

IF JumpFlag% = True% THEN
     IF Top% = 0 THEN TranslateDown ScollSpeed%
ELSE
     IF Bottom% = 0 THEN TranslateUp ScrollSpeed%
END IF

END SUB

'This procedure clears the keyboard buffer, i.e., it waits until INKEY$ is
'null.
'
SUB ClearBuffer

WHILE LEN(INKEY$): WEND

END SUB

'This procedure calls on the PalChange routine to change the
'available colors.
'
SUB CreatePal

FOR i% = 0 TO 3     'grey colors
     PalChange i%, i% * 8, i% * 8, i% * 8
NEXT i%
FOR i% = 4 TO 7     'orange colors
     PalChange i%, i% * 8, i% * 3, 0
NEXT i%
FOR i% = 8 TO 11    'blue colors
     PalChange i%, 0, 0, i% * 11
NEXT i%
PalChange 12, 32, 0, 0     'red colors
PalChange 13, 50, 0, 0
PalChange 14, 0, 32, 0     'green colors
PalChange 15, 0, 50, 0

END SUB

'This procedure reads and GETS cat sprites into CatSprites array.
'
SUB CreateSprites

FOR S = 1 TO NumSprites%
     IF S = 4 THEN RESTORE CatSprites
     FOR Y = 1 TO SpriteHeight%
          IF S < 4 THEN
               FOR X = 1 TO SpriteWidth%
                    READ Col%
                    PSET (X, Y), Col%
               NEXT X
          ELSE
               FOR X = SpriteWidth% TO 1 STEP -1
                    READ Col%
                    PSET (X, Y), Col%
               NEXT X
          END IF
     NEXT Y
     GET (1, 1)-(16, 20), CatSprites(0, S)
NEXT S

END SUB

'This procedure reads DATA onto screen, and GETs it in a tile.
'
SUB CreateTiles

FOR T = 1 TO NumTiles%     'tile index
     FOR Y = 1 TO 10        'X and Y loops scan DATA and draw it to screen.
          FOR X = 1 TO 10
               READ Col%     'read the texel color attribute
               PSET (X, Y), Col%     'draw it to screen
          NEXT X
     NEXT Y
     GET (1, 1)-(10, 10), Tiles(1, T)  'put image in Tiles array.
NEXT T
CLS

END SUB

'gets scancode from keyboard port
'The extra code here may not seem necessary, but on some computers,
'the scancode is irregular for the arrow keys. This ignores all codes
'above 215.
'
FUNCTION HitKey%

STATIC PrevCode%     'save previous scancode
ScanCode% = INP(96)
IF ScanCode% > 215 THEN HitKey% = PrevCode% ELSE HitKey% = ScanCode%
IF ScanCode% <= 215 THEN PrevCode% = ScanCode%

END FUNCTION

'This starts up the program---called only ONCE
'
SUB InitProg

SCREEN 7, 1, 1, 0     'init 320x200x16 color resolution; hide active page
ReadGameMaps          'loads side-scrolling worlds into GameMaps array
CreateTiles           'read and GET tile sprites for scrolling
CreateSprites         'read and GET cat sprites
ResetVars             'reset program variables---no default constants needed
CreatePal             'create new set of colors for screen 7

END SUB

'This function tests the entire left side of the cat for collision
'
FUNCTION LeftSide%

LeftSide% = 0
FOR Y = 1 TO SpriteHeight%
     IF POINT(CatX% - 3, CatY% + Y) <> 0 THEN LeftSide% = POINT(CatX% - 3, CatY% + Y)
NEXT Y

END FUNCTION

SUB PalChange (Colour%, Red%, Green%, Blue%)
  IF Colour% > 7 THEN Colour% = Colour% + 8
  OUT &H3C8, Colour%
  IF Colour% > 7 THEN Colour% = Colour% - 8
  OUT &H3C9, Red%
  OUT &H3C9, Green%
  OUT &H3C9, Blue%
END SUB

'This procedure reads gamemap DATA into GameMaps array.
'
SUB ReadGameMaps

FOR M = 1 TO NumMaps%     'loop to read each individual map.
     FOR Y = 1 TO MapHeight%
          READ TileVal$     'read row of characters
          FOR X = 1 TO MapWidth%
               'get number that character represents corresponding to alphabet.
               GameMaps%(X, Y, M) = ASC(MID$(TileVal$, X, 1)) - 96
               IF MID$(TileVal$, X, 1) = " " THEN GameMaps%(X, Y, M) = 0
          NEXT X
     NEXT Y
NEXT M

END SUB

'This procedure resets the text screen mode for DOS.
'
SUB ResetScreen

SCREEN 0: CLS
WIDTH 80, 25
COLOR 7, 0

END SUB

'This procedure resets all variable values to default values.
'
SUB ResetVars

ArrayX% = 0
ArrayY% = -5
TileX% = 6
TileY% = 10
CurrentLevel% = 1
CatFrame% = 1

END SUB

'This function tests the entire right side of cat sprite for collision
'
FUNCTION RightSide%

RightSide% = 0
FOR Y = 1 TO SpriteHeight%
     IF POINT(CatX% + SpriteWidth%, CatY% + Y) <> 0 THEN RightSide% = POINT(CatX% + SpriteWidth%, CatY% + Y)
NEXT Y

END FUNCTION

'This function tests the top of the cat for collision
'
FUNCTION Top%

Top% = 0
FOR X = 1 TO SpriteWidth% - 2
     IF POINT(CatX% + X, CatY% - 2) <> 0 THEN Top% = POINT(CatX% + X, CatY% - 2)
NEXT X

END FUNCTION

'This procedure translates the level view down.
'
SUB TranslateDown (Increment%)

FOR i = 1 TO ScrollSpeed%
     TileY% = TileY% + 1
     IF TileY% >= 10 THEN
          TileY% = 0
          ArrayY% = ArrayY% - 1
     END IF
NEXT i

END SUB

'This procedure translates scrolling level to the right
'
SUB TranslateLeft (Increment%)

FOR i = 1 TO ScrollSpeed%
     TileX% = TileX% - 1
     IF TileX% <= 0 THEN
          TileX% = 10
          ArrayX% = ArrayX% + 1
     END IF
NEXT i

END SUB

'This procedure translates scrolling level to the right
'
SUB TranslateRight (Increment%)

FOR i = 1 TO ScrollSpeed%
     TileX% = TileX% + 1
     IF TileX% >= 10 THEN
          TileX% = 0
          ArrayX% = ArrayX% - 1
     END IF
NEXT i

END SUB

'This procedure scrolls the view of the level up.
'
SUB TranslateUp (Increment%)

FOR i = 1 TO ScrollSpeed%
     TileY% = TileY% - 1
     IF TileY% <= 0 THEN
          TileY% = 10
          ArrayY% = ArrayY% + 1
     END IF
NEXT i

END SUB

'This procedure updates the animation frame of the cat.
'
SUB UpdateFrame

IF CatFrame% < 3 THEN CatFrame% = CatFrame% + 1 ELSE CatFrame% = 1

END SUB

'This procedure updates the screen. (no, kidding!!!)
'
SUB UpdateScreen

CLS
IndexX% = 1     'index variables for GameMaps% array.
IndexY% = 1
FOR Y = 10 TO 150 STEP 10
     IndexX% = 1
     FOR X = 30 TO 270 STEP 10
          IF (ArrayX% + IndexX%) >= 1 AND (ArrayX% + IndexX%) <= MapWidth% AND (ArrayY% + IndexY%) >= 1 AND (ArrayY% + IndexY%) <= MapHeight% THEN
               IF GameMaps%(ArrayX% + IndexX%, ArrayY% + IndexY%, CurrentLevel%) > 0 THEN
                    PUT (X + TileX%, Y + TileY%), Tiles(1, GameMaps%(ArrayX% + IndexX%, ArrayY% + IndexY%, CurrentLevel%)), PSET
               END IF
          END IF
          IndexX% = IndexX% + 1
     NEXT X
     IndexY% = IndexY% + 1
NEXT Y
'scroll-hiding borders
LINE (0, 0)-(39, 200), 3, BF     'left
LINE (280, 0)-(320, 200), 3, BF  'right
LINE (0, 0)-(320, 19), 3, BF     'top
LINE (0, 150)-(320, 200), 3, BF  'bottom
'orange borders
LINE (39, 19)-(280, 150), 4, B
LINE (38, 18)-(281, 151), 5, B
LINE (37, 17)-(282, 152), 6, B
LINE (36, 16)-(283, 153), 7, B
LINE (35, 15)-(284, 154), 6, B
LINE (34, 14)-(285, 155), 5, B
LINE (33, 13)-(286, 156), 4, B
PUT (CatX%, CatY%), CatSprites(0, CatFrame% + CatDirection%), XOR
PCOPY 1, 0

END SUB

