;#############################################################################
;
;                 pcx import routines made by Future Software
;                          for BASIC programming
;
;#############################################################################
.model medium
.386
.stack 10h

EXTRN X1VP:word
EXTRN Y1VP:word
EXTRN X2VP:word
EXTRN Y2VP:word

EXTRN Xscalesize:word
EXTRN Yscalesize:word

EXTRN ScalingOnOff:word
EXTRN paloffset:word
EXTRN Autooffset:word

EXTRN Smode:FAR
EXTRN Bitdepth:FAR
EXTRN SVGAHlineScale:FAR
EXTRN assignpalette:FAR

EXTRN DOS_Alloc:FAR
EXTRN DOS_DeAlloc:FAR
EXTRN memclear:FAR

EXTRN DISK_Read:FAR
EXTRN DISK_Write:FAR
EXTRN DISK_Open:FAR
EXTRN DISK_Close:FAR
EXTRN DISK_PointerSet:FAR
EXTRN DISK_PointerGet:FAR

EXTRN RealColor:FAR

EXTRN BppConvert:FAR
EXTRN AddToHistogram:FAR
EXTRN realign:FAR

EXTRN IsXMSinstalled:FAR
EXTRN AllocateXMS:FAR
EXTRN MoveFromXMS:FAR
EXTRN MoveToXMS:FAR
EXTRN DeallocateXMS:FAR


Convert MACRO clut,InBit,Outbits,sSeg,dSeg,pixels,bpsl
       pushw bpsl
       pushw histSeg
       pushw 0
       pushw clut
       pushw InBit
       pushw Outbits
       pushw sSeg
       pushw 0
       pushw dSeg
       pushw 0
       mov ax,pixels
       inc ax
       pushw ax
       call BppConvert
endm

FileRead MACRO handle,bytes,sg,of
        pushw handle
        pushw sg
        pushw of
        pushw bytes
        call DISK_Read
endm

             
FileSeek MACRO handle1,pos,ref     ;ref=0||1||2
        pushw handle1
        pushd pos
        pushw ref
        call DISK_PointerSet
endm


.data

Tcube STRUCT         ;holds color space info.
     x01    db   0   ;max is 32
     y01    db   0   
     z01    db   0   
     x11    db   0   
     y11    db   0   
     z11    db   0   
     vol    dw   0   ;max is 32*32*32
     Ravg   db   0
     Gavg   db   0
     Bavg   db   0
     fom    dd   0
Tcube ENDS

TfileInfoExt STRUCT
       fileXres   dw 0
       fileYres   dw 0
       fileBpp    dw 0
       fileSize   dd 0
TfileInfoExt ENDS 


TPCXheader STRUCT 
        id            db 0
        Version       db 0
        Encoding      db 0
        BitsPerPixel  db 0
        Xmin          dw 0
        Ymin          dw 0
        Xmax          dw 0
        Ymax          dw 0
        Hdpi          dw 0
        Vdpi          dw 0
        Colormap      db 48 dup(0) 
        Reserved      db 0
        Nplanes       db 0
        BytesPerLine  dw 0
        PaletteInfo   dw 0
        HscreenSize   dw 0
        Vscreensize   dw 0
;        Filler        db 54 dup(0) 
TPCXheader ENDS

PCXheader TPCXheader <>

   filehandle dw 0

   clutSeg    dw 0
   clutlen    dw 0
   dataSeg    dw 0
   datalen    dw 0
   inSeg      dw 0
   inlen      dw 0
   OutSeg     dw 0
   Outlen     dw 0

   histSeg     dw 0
   histlen     dw 0
   CubelistSeg     dw 0
   Cubelistlen     dw 0

   x          dw 0
   y          dw 0
   sx         dw 0
   sy         dw 0
   mode       dw 0
   Xres       dw 0
   Yres       dw 0

   temp       dw 0
   bufIndex   dw 0
   bpp        dw 0

   Usedcolors    dw 0

   xmshandle dw 0
   xmspos    dd 0

d1    dd 0
d2    dd 0
lx    dd 0
ly    dd 0

   x1         dw 0
   y1         dw 0
   x2         dw 0
   y2         dw 0
   j          dw 0

.code


;#############################################################################
;loadPCXext (Filename$,X%,Y%)
;
;  
;#############################################################################
PUBLIC loadPCXext
loadPCXext proc    BASIC
    push bp
    mov bp,sp
    pushad

    call IsXMSinstalled
    .if ax != -1
       jmp exiterror
    .endif

    pushd [bp+10]     ;push seg:off pointer to filename string
    Call DISK_Open    ;if no error ax=file handle
    .if ax == 0               ;
       jmp exiterror          ;
    .endif                    ;
    mov filehandle,ax
   
    mov bx,offset PCXheader.id
    mov cx,size TPCXheader
    FileRead filehandle,cx,@data,bx  ;load header

    .if (PCXheader.id != 10) || (PCXheader.BitsPerPixel != 8)
        jmp exiterror
    .endif

    mov clutSeg,0
    mov dataSeg,0
    mov inSeg,0
    mov dataSeg,0
    mov histSeg,0

    mov ax,768
    mov clutlen,ax
    pushw ax                  ;allocate buffer CLUT
    call DOS_Alloc            ;
    .if ax == 0
    jmp exiterror
    .endif
    mov clutSeg,ax            ;

    FileSeek filehandle,-768,2    ;seek to clut 
    FileRead filehandle,clutlen,clutSeg,0  ;load CLUT


    .if (PCXheader.Nplanes == 1)
            call Smode
            mov mode,ax
            .if (mode == 0) || (mode == 1)
                
                   mov ax,clutSeg
                   mov es,ax
                   xor si,si
                   xor cx,cx
                   .REPEAT    
                     mov al,es:[si+2]   ;get R component
                     mov ah,es:[si+1]   ;get G component
                     mov dl,es:[si+0]   ;get B component
        
                     mov es:[si+0],ax
                     mov es:[si+2],dl
        
                     add si,3
                     inc cx
                   .UNTIL cx >= 256
            .else
        
                 mov ax,clutSeg
                 mov es,ax
                 xor si,si
                 xor cx,cx
                .REPEAT
             
                  pushw es:[si+0]               ;get R component
                  pushw es:[si+1]               ;get G component
                  pushw es:[si+2]               ;get B component
        
                  call RealColor
        
                  mov es:[si+0],ax
                  mov es:[si+2],dl
        
                  add si,3
                  inc cx
                .UNTIL cx >= 256
        
            .endif
    .endif

    mov datalen,256              ;allocate databuffer
    pushw datalen                ;
    call DOS_Alloc               ;
    .if ax == 0                  ;
       jmp exiterror             ;
    .endif                       ;
    mov dataSeg,ax                 ;


    mov ax,PCXheader.Xmax
    sub ax,PCXheader.Xmin
    inc ax
    mov Xres,ax

    mov ax,PCXheader.Ymax
    sub ax,PCXheader.Ymin
    mov Yres,ax

    .if (PCXheader.Nplanes == 1) && (PCXheader.BitsPerPixel == 8)
       mov bpp,8
    .elseif (PCXheader.Nplanes == 3) && (PCXheader.BitsPerPixel == 8)
       mov bpp,24
    .endif

    call Bitdepth ;is screen in palette mode, then alloate histogram
    .if ax == 8 || ax == 4 || ax == 1  
        mov ax,32768
        mov Histlen,ax
        pushw Histlen           
        call DOS_Alloc          ;allocate histogram buffer 
        .if ax == 0
          jmp exiterror
        .endif
        mov HistSeg,ax
    
        push HistSeg            ;clear it
        push Histlen
        call memclear

        mov ax,256*Tcube
        mov Cubelistlen,ax
        pushw Cubelistlen       ;allocate cubelist buffer 
        call DOS_Alloc          ;
        .if ax == 0
          jmp exiterror
        .endif
        mov CubelistSeg,ax
    
        push CubelistSeg        ;clear it
        push Cubelistlen
        call memclear

    .endif

    
    movzx eax,PCXheader.Nplanes
    mul PCXheader.BytesPerLine

    mov inlen,ax                ;allocate 
    pushw inlen                 ;
    call DOS_Alloc              ;
    .if ax == 0                 ;
       jmp exiterror            ;
    .endif                      ;
    mov inSeg,ax                ;

    mov ax,inlen
    shl ax,3
    mov outlen,ax               ;allocate resultbuffer
    pushw outlen                ;
    call DOS_Alloc              ;
    .if ax == 0                 ;
       jmp exiterror            ;
    .endif                      ;
    mov outSeg,ax               ;

    movzx eax,inlen
    movzx ebx,Yres
    inc ebx
    mul ebx
    push eax
    call AllocateXMS
    mov xmshandle,ax
    
    call pcxdecode             ;decodes pcx, 
                               ;loads histogram for 8 bit modes,
                               ;and saves result in xms

    call Bitdepth
    .if ax == 8 || ax == 4 || ax == 1
           pushw histSeg
           pushw CubelistSeg
           pushw 255
           call assignpalette
           mov Usedcolors,ax
    .endif

    mov x,0
    mov y,0
    
    mov xmspos,0


    .if (PCXheader.Nplanes == 1) || (PCXheader.Nplanes == 3)

        .if ScalingOnOff == 1
          pushw Xscalesize
          pushw Yscalesize
        .else
          pushw Xres
          pushw Yres
        .endif
        pushw inSeg
        pushw Xres
        pushw Yres
        pushw [bp+08]
        pushw [bp+06]
        pushw xmshandle
        pushd 0
        call pcxScale

    .endif

exiterror:
    .if AutoOffset == 1
        mov ax,Usedcolors
        inc ax
        and ax,255
        add paloffset,ax
    .endif

    .if outSeg != 0
            pushw outlen             ;deallocate resultbuffer
            pushw outSeg             ;
            call DOS_DeAlloc         ;
    .endif
    .if inSeg != 0
            pushw inlen             ;deallocate resultbuffer
            pushw inSeg             ;
            call DOS_DeAlloc         ;
    .endif
    .if CubelistSeg != 0
            pushw Cubelistlen        ;deallocate cubelist databuffer
            pushw CubelistSeg        ;
            call DOS_DeAlloc         ;
    .endif
    .if histSeg != 0
            pushw histlen            ;deallocate histogram databuffer
            pushw histSeg            ;
            call DOS_DeAlloc         ;
    .endif
    .if dataSeg != 0
            pushw datalen            ;deallocate databuffer
            pushw dataSeg            ;
            call DOS_DeAlloc         ;
    .endif
    .if clutSeg != 0
            pushw clutlen            ;deallocate buffer CLUT
            pushw clutSeg            ;
            call DOS_DeAlloc         ;
    .endif

    push xmshandle
    call DeallocateXMS
    
    pushw filehandle                 ;close file
    call DISK_Close                  ;

done:
    popad
    pop bp
    retf 8
loadPCXext endp


pcxdecode proc    NEAR

    mov xmspos,0

    FileSeek filehandle,128,0    ;seek to start of image data

    mov x,0
    mov y,0
    

    .if (PCXheader.Nplanes == 1) || (PCXheader.Nplanes == 3)
       mov ax,dataSeg
       mov es,ax

      .WHILE 1
       FileRead filehandle,datalen,dataSeg,0  ;load imagedata
       mov bufIndex,0

       .REPEAT

        mov ax,dataSeg
        mov es,ax
        mov si,bufIndex
        movzx ebx, byte ptr es:[si]


        .if bl < 192

          mov ax,inSeg
          mov es,ax
          mov di,x
          mov es:[di],bl

          inc x

        .else

          and bl,00111111b
          mov temp,bx

          inc bufIndex

          mov ax,datalen
          dec ax
          .if bufIndex > ax
              FileRead filehandle,datalen,dataSeg,0  ;load imagedata
              mov bufIndex,0
          .endif

          mov ax,dataSeg
          mov es,ax

          mov si,bufIndex
          movzx ebx, byte ptr es:[si]

          mov ax,inSeg     ;
          mov es,ax        ;
          mov di,x         ;
          mov cx,temp      ;
          mov ax,bx        ;if (x+temp) > PCXheader.BytesPerLine == decode error.
          rep stosb        ;Will probably go belly up if code data is corrupt

          mov cx,temp
          add x,cx
        .endif

        mov ax,x
        .if ax >= inlen


                       .if PCXheader.Nplanes == 3         ;realign planes to RGB pattern
                          pushw PCXheader.BytesPerLine    ;
                          pushw bpp  ;inbpp
                          pushw inSeg  ;inSegment
                          pushw OutSeg  ;outSegmetn
                          pushw Xres  ;pixels
                          call realign
                       .endif

                       call Bitdepth                      ;add to histogram for 8 bit modes
                       .if ax == 8
                                 pushw clutSeg
                                 pushw 0
                                 pushw HistSeg
                                 pushw 0
                                 pushw bpp
                                 pushw inSeg
                                 pushw 0
                                 pushw Xres
                                 call AddToHistogram
                       .endif

                       pushw xmshandle                   ;save result in xms
                       pushw inSeg
                       pushw 0
                       movzx eax,inlen
                       pushd eax
                       pushd xmspos
                       add xmspos,eax
                       call MoveToXMS

                mov x,0
                inc y
        .endif

        mov ax,y
        .if ax > Yres
            retn
        .endif

        inc bufIndex
        mov ax,datalen
        dec ax

       .UNTIL bufIndex > ax
       
      .ENDW

    .endif

       retn
pcxdecode endp


;#############################################################################
;pcxScale (newXsize, newYsize, bufferSeg, imageX%, imageY%, X%, Y%, xmshandle%, XMSoffset&)
;          24        22        20         18       16       14  12  10          06
;
;
;#############################################################################
PUBLIC pcxScale
pcxScale proc    BASIC
        push bp
        mov bp,sp

        mov ax,[bp+14]
        mov x1,ax

        mov x2,ax
        mov ax,[bp+24]
        add x2,ax
        dec x2
        
        mov ax,[bp+12]
        mov y1,ax

        mov y2,ax
        mov ax,[bp+22]
        add y2,ax
        dec y2

        .if word ptr [bp+24] != 0
                movzx ecx,word ptr [bp+24]
                movzx eax,word ptr [bp+18]
                shl eax,16      ;eax=eax*10000h
                cdq             ;eax->edx:eax 
                idiv ecx        ;edx:eax \ ecx 
                mov d1,eax
        .else
                mov d1,0
                jmp donescale
        .endif
        
        .if word ptr [bp+22] != 0
                movzx ecx,word ptr [bp+22]
                movzx eax,word ptr [bp+16]
                shl eax,16      ;eax=eax*10000h
                cdq             ;eax->edx:eax 
                idiv ecx        ;edx:eax \ ecx 
                mov d2,eax
        .else
                mov d2,0
                jmp donescale
        .endif

        mov lx,0

        mov ax,x1
        cmp ax,X1VP
        jge @F
           sub ax,X1VP
           neg ax
           movzx eax,ax
           .if ax >= [bp+24]
             jmp donescale
           .endif
           mul d1
           mov lx, eax
           mov ax,X1VP
           mov x1,ax
        @@:
        
        mov ly,0
        
        mov ax,y1
        cmp ax,Y1VP
        jge @F
           sub ax,Y1VP
           neg ax
           movzx eax,ax
           .if ax >= [bp+22]
             jmp donescale
           .endif
           mul d2
           mov ly, eax
           mov ax,Y1VP
           mov y1,ax
        @@:

        mov ax,x2
        cmp ax,X2VP
        jl @F
         mov ax,X2VP
         dec ax
         mov x2,ax
        @@:

        mov ax,x1
        cmp ax,X2VP
        jl @F
         jmp donescale
        @@:

        mov ax,y1
        mov j,ax
        
        .WHILE ax <= y2
                movzx eax,word ptr [ly+2]
                movzx ecx,inlen;word ptr [bp+18]
                mul ecx
                mov ebx,[bp+06] ;xmsoffset
                add eax,ebx

        
                pushw [bp+10]  ;xmshandle
                pushw [bp+20]  ;segment
                pushw 0        ;offset
                movzx ecx,inlen;word ptr [bp+18]
                pushd ecx 
                pushd eax
                call MoveFromXMS
        
                call Bitdepth
                Convert clutSeg,bpp,ax,[bp+20],outSeg,[bp+18],PCXheader.BytesPerLine


                pushd lx
                pushd d1
                pushw j
                pushw x1
                pushw x2
                pushw 0
                pushw outSeg   ;segment
                call SVGAhlineScale
        
        
           mov eax,d2
           add ly,eax
           inc j
           mov ax,j
        .ENDW
donescale:

        pop bp
        retf 20
pcxScale endp


;#############################################################################
;GetPCXinfo (filename$, fileInfoExt)
;
;  
;#############################################################################
PUBLIC GetPCXinfo
GetPCXinfo proc    BASIC
    push bp
    mov bp,sp
    pushad

    pushd [bp+10]     ;push seg:off pointer to filename string
    Call DISK_Open    ;if no error ax=file handle
    .if ax == 0               ;
      jmp exitinfoerror       ;
    .endif                    ;

    mov filehandle,ax
   
    mov bx,offset PCXheader.id
    mov cx,size TPCXheader
    FileRead filehandle,cx,@data,bx  ;load header

    .if (PCXheader.id != 10) || (PCXheader.BitsPerPixel != 8)
        jmp exitinfoerror
    .endif

    les bx,[bp+06]

    mov ax,PCXheader.Xmax
    sub ax,PCXheader.Xmin
    inc ax
    mov es:[bx].fileXres,ax

    mov ax,PCXheader.Ymax
    sub ax,PCXheader.Ymin
    inc ax
    mov es:[bx].fileYres,ax

    .if (PCXheader.Nplanes == 1) && (PCXheader.BitsPerPixel == 8)
       mov bpp,8
    .elseif (PCXheader.Nplanes == 3) && (PCXheader.BitsPerPixel == 8)
       mov bpp,24
    .endif

    mov ax,bpp
    mov es:[bx].fileBpp,ax

    FileSeek filehandle,0,2 ;seek to eof

    pushw filehandle        ;
    call DISK_PointerGet    ;get file size

    les bx,[bp+06]

    mov word ptr es:[bx].fileSize,ax
    mov word ptr es:[bx+2].fileSize,dx

    pushw filehandle
    call DISK_Close

exitinfoerror:
    popad
    pop bp
    retf 8
GetPCXinfo endp



end
 
