;#############################################################################
;
;                 gif import routines made by Future Software
;                          for BASIC programming
;
;#############################################################################
.model medium
.386
.stack 10h

EXTRN ScalingOnOff:word

EXTRN XScalesize:word
EXTRN YScalesize:word

EXTRN X1VP:word
EXTRN Y1VP:word
EXTRN X2VP:word
EXTRN Y2VP:word


EXTRN UsePalcolors:word
EXTRN bmpmaxcolors:word
EXTRN paloffset:word
EXTRN Autooffset:word

EXTRN BppConvert:FAR
EXTRN Bitdepth:FAR
EXTRN SVGAhlineScale:FAR
EXTRN assignpalette:FAR
EXTRN Real2Color:FAR
EXTRN RealColor:FAR

EXTRN DOS_Alloc:FAR
EXTRN DOS_DeAlloc:FAR
EXTRN memclear:FAR

EXTRN DISK_Read:FAR
EXTRN DISK_Write:FAR
EXTRN DISK_Open:FAR
EXTRN DISK_Close:FAR
EXTRN DISK_PointerSet:FAR
EXTRN DISK_PointerGet:FAR

;EXTRN Saveit:FAR

EXTRN IsXMSinstalled:FAR
EXTRN AllocateXMS:FAR
EXTRN MoveFromXMS:FAR
EXTRN MoveToXMS:FAR
EXTRN DeallocateXMS:FAR

EXTRN AddToHistogram:FAR

Convert MACRO hist,planes,clut,InBit,Outbits,sSeg,dSeg,pixels
       pushw 0
       pushw hist
       pushw planes
       pushw clut
       pushw InBit
       pushw Outbits
       pushw sSeg
       pushw 0
       pushw dSeg
       pushw 0
       mov ax,pixels
       inc ax
       pushw ax
       call BppConvert
endm

FileRead MACRO handle,bytes,sg,of
        pushad
        pushw handle
        pushw sg
        pushw of
        pushw bytes
        call DISK_Read
        popad
endm

             
FileSeek MACRO handle1,pos,ref     ;ref=0||1||2
        pushad
        pushw handle1
        pushd pos
        pushw ref
        call DISK_PointerSet
        popad
endm


OutBytes MACRO W,ScreenDepth
    .if ScreenDepth == 8
      mov ax,W
    .elseif ScreenDepth == 15
      mov ax,W
      shl ax,1
    .elseif ScreenDepth == 16
      mov ax,W
      shl ax,1
    .elseif ScreenDepth == 24
      movzx edx,W
      lea ax,[edx*2+edx]
    .elseif ScreenDepth == 32
      mov ax,W
      shl ax,2
    .endif
endm


Tcube STRUCT         ;holds color space info.
     x01    db   0   ;max is 32
     y01    db   0   
     z01    db   0   
     x11    db   0   
     y11    db   0   
     z11    db   0   
     vol    dw   0   ;max is 32*32*32
     Ravg   db   0
     Gavg   db   0
     Bavg   db   0
     fom    dd   0
Tcube ENDS

TfileInfoExt STRUCT
       fileXres   dw 0
       fileYres   dw 0
       fileBpp    dw 0
       fileSize   dd 0
TfileInfoExt ENDS 


.data

TGIFheader STRUCT 
        Signature               db 'GIF89a' ;'GIF87a'
        Xsize                   dw 0
        Ysize                   dw 0
        ColorInfo               db 0
        BackgroungColorIndex    db 0
        PixelAspectRatio        db 0
TGIFheader ENDS
GIFheader TGIFheader <>


TGIFAppExtheader STRUCT 
        ApplExtBlockSize        db 0
        ApplIdentifier          db 8 dup(0)
        Applauthentication      db 3 dup(0)
TGIFAppExtheader ENDS
GIFAppExtheader TGIFAppExtheader <>

TGIFImgDescripter STRUCT 
       ImgLeftPos       dw 0
       ImgTopPos        dw 0
       ImgWidth         dw 0
       ImgHeight        dw 0
       ImgInfo          db 0
TGIFImgDescripter ENDS
GIFImgDescripter TGIFImgDescripter <>

TGCEblock STRUCT           ;graphic control extension block
       blocksize        db 4
       fields           db 0  ;bit 2-4 holds diposal method
       delaytime        dw 0
       transparentcolor db 0
       terminator       db 0
TGCEblock ENDS
GCE TGCEblock <>


TGIFInfo STRUCT 
       FileHandle       dw 0
       X                dw 0
       Y                dw 0
       BackgroundColor  dw 0
       Pal              dw 0
       NColor           dw 0
       loopit           dw 0
       StartFramePos    dd 0
       FramePos         dd 0
       EOFile           dw 0
       MEMHandle        dw 0
TGIFInfo ENDS


   clutSeg    dw 0
   clutlen    dw 0

   codeSeg    dw 0
   codelen    dw 0
   dataSeg    dw 0
   datalen    dw 0
   inSeg      dw 0
   inlen      dw 0
   OutSeg     dw 0
   Outlen     dw 0

   PrefixSeg  dw 0
   Prefixlen  dw 0
   SuffixSeg  dw 0
   Suffixlen  dw 0


   localclutSeg  dw 0
   localclutlen  dw 0

   inbyte        dw 0

   imagerun      dw 0
   ncolors       dw 0

   temphandle    dw 0
   temp          dw 0

   MinCodeSize   dw 0
   InitCodeSize  dw 0
   ResetDecoderCode dw 0
   EndOfStreamCode dw 0
   InitCode      dw 0
   InitCodeLimit dw 0
   CurrentCodeLimit dw 0
   CurrentCodeSize dw 0
   CurrentCode   dw 0
   previousCode  dw 0
   previousPixel dw 0
   StackPointer  dw 0
   CodeIndex     dw 0

   datapointer   dw 0
   datasize      dw 0

   bitposition   dw 0
   currentbits   db 0

   newCode       dw 0
   xpos          dw 0
   ypos          dw 0
   ystep         dw 0

   headerSeg     dw 0

   histSeg       dw 0
   histlen       dw 0

   CubelistSeg   dw 0
   Cubelistlen   dw 0

   xmspos        dd 0

   Usedcolors    dw 0

   giflenght     dw 0

   j          dw 0 
        
   d1         dd 0
   d2         dd 0
   lx         dd 0
   ly         dd 0

   x1         dw 0
   y1         dw 0
   x2         dw 0
   y2         dw 0
   tempy      dw 0

   fhandle    dw 0

.code


;#############################################################################
;OpenAGifext (Filename$, TGIFInfo stucture)
;
;  
;#############################################################################
PUBLIC OpenAGifext
OpenAGifext proc    BASIC
    push bp
    mov bp,sp
    pushad

    mov clutSeg,0

    call IsXMSinstalled
    .if ax != -1
       jmp exiterror
    .endif

    mov bx,[bp+06]     ;get gif info stucture offset

    mov ax,[bp+08]     ;get gif info stucture segment
    mov gs,ax


    pushd [bp+10]     ;filename
    Call DISK_Open    ;if no error ax=file handle
    .if ax == 0               ;
       jmp exiterror        ;
    .endif                    ;
    mov bx,[bp+06]
    mov gs:[bx].filehandle,ax
   
    mov ax,offset GIFheader
    mov cx,size TGIFheader
    FileRead gs:[bx].filehandle,cx,@data,ax  ;load header

    mov ax,GIFheader.Xsize
    mov gs:[bx].X,ax
    mov ax,GIFheader.Ysize
    mov gs:[bx].Y,ax

    movzx eax,ax                 ;allocate room for a palette and one frame
    movzx ecx,GIFheader.Xsize    ;
    mul ecx                      ;
                                 ;
    add eax,256*3                ;first 768 bytes for the the global clut
    add eax,32768                ;next 32768 bytes holds the histogram between frames
    pushd eax                    ;
    call AllocateXMS             ;
    mov bx,[bp+06]               ;
    mov gs:[bx].MEMHandle,ax     ;

    mov cl,GIFheader.ColorInfo
    and cl,0111b
    inc cl
    mov ax,1
    shl ax,cl
    mov gs:[bx].NColor,ax

    test GIFheader.ColorInfo,128
    .if zero?
       mov gs:[bx].Pal,-1
    .else
       mov gs:[bx].Pal,0
    .endif

    movzx ax,GIFheader.BackgroungColorIndex
    mov gs:[bx].BackgroundColor,ax

    mov ax,gs:[bx].NColor        ;allocate buffer CLUT
    shl ax,2                  ;
    mov clutlen,ax            ;
    pushw ax                  ;
    call DOS_Alloc            ;
    .if ax == 0               ;
       jmp exiterror          ;
    .endif                    ;
    mov clutSeg,ax            ;

    .if gs:[bx].Pal == 0
       
       movzx edx,gs:[bx].NColor
       lea dx,[edx*2+edx]

       FileRead gs:[bx].filehandle,dx,clutSeg,0   ;load color table

       pushw gs:[bx].MEMhandle
       pushw clutSeg
       pushw 0
       pushd edx       ;bytes to move
       pushd 0         ;xmsoffset
       call MoveToXMS

    .endif

    mov ax,[bp+08]     ;get gif info stucture segment
    mov gs,ax

    mov bx,[bp+06]
    pushw gs:[bx].filehandle
    call DISK_PointerGet
    rol eax,16
    mov ax,dx
    rol eax,16

    mov bx,[bp+06]
    mov gs:[bx].FramePos,eax
    mov gs:[bx].StartFramePos,eax


    ;.if dword ptr [GIFheader.Signature] != 'GIF8'
    ;    jmp exiterror
    ;.endif

exiterror:
    .if clutSeg != 0
            pushw clutlen            ;deallocate 
            pushw clutSeg            ;
            call DOS_DeAlloc         ;
    .endif


done:
    popad
    pop bp
    retf 8
OpenAGifext endp



;#############################################################################
;putAGifext  (Xpos%, Ypos%, Handle AS TGIFInfo)
;
;  
;#############################################################################
PUBLIC putAGifext 
putAGifext  proc    BASIC
    push bp
    mov bp,sp
    pushad

    call IsXMSinstalled
    .if ax != -1
       jmp @@exiterror
    .endif

    mov ax,[bp+08]     ;get gif info stucture segment
    mov gs,ax
    mov bx,[bp+06]

    .if gs:[bx].filehandle  == 0
       jmp @@exiterror
    .endif

    mov clutSeg,0
    mov PrefixSeg,0          
    mov SuffixSeg,0
    mov inSeg,0
    mov OutSeg,0
    mov histSeg,0
    mov CubelistSeg,0
    mov codeSeg,0
    mov localclutSeg,0

    mov ax,gs:[bx].filehandle 
    mov temphandle,ax

    mov ax,256                ;allocate buffer CLUT
    shl ax,2                  ;
    mov clutlen,ax            ;
    pushw ax                  ;
    call DOS_Alloc            ;
    .if ax == 0               ;
       jmp @@exiterror        ;
    .endif                    ;
    mov clutSeg,ax            ;

    mov ax,4096*2             ;allocate buffer
    mov Prefixlen,ax          ;
    pushw ax                  ;
    call DOS_Alloc            ;
    .if ax == 0               ;
       jmp @@exiterror        ;
    .endif                    ;
    mov PrefixSeg,ax          ;

    ;push PrefixSeg
    ;push Prefixlen
    ;call memclear


    mov ax,4096*2             ;allocate buffer
    mov Suffixlen,ax          ;
    pushw ax                  ;
    call DOS_Alloc            ;
    .if ax == 0               ;
       jmp @@exiterror        ;
    .endif                    ;
    mov SuffixSeg,ax          ;

    push SuffixSeg
    push Suffixlen
    call memclear

    mov ax,256                ;allocate buffer
    mov codelen,ax            ;
    pushw ax                  ;
    call DOS_Alloc            ;
    .if ax == 0               ;
       jmp @@exiterror        ;
    .endif                    ;
    mov codeSeg,ax            ;

    mov bx,[bp+06]
    mov ax,gs:[bx].X             ;allocate buffer
    mov inlen,ax              ;
    pushw ax                  ;
    call DOS_Alloc            ;
    .if ax == 0               ;
       jmp @@exiterror        ;
    .endif                    ;
    mov inSeg,ax              ;

    call Bitdepth
    OutBytes inlen,ax

    mov Outlen,ax             ;
    pushw ax                  ;
    call DOS_Alloc            ;
    .if ax == 0               ;
       jmp @@exiterror        ;
    .endif                    ;
    mov OutSeg,ax             ;

    

    mov bx,[bp+06]
    .if gs:[bx].Pal == 0
           movzx edx,gs:[bx].NColor
           lea dx,[edx*2+edx]

           pushw gs:[bx].MEMhandle
           pushw clutSeg
           pushw 0
           pushd edx       ;bytes to move
           pushd 0         ;xmsoffset
           call MoveFromXMS

           mov ax,clutSeg
           mov es,ax
           xor di,di
           xor cx,cx
           call Bitdepth
           .if ax == 4 || ax == 8
                   .REPEAT
        
                     mov al, es:[di+0]
                     ;mov ah, es:[di+1]
                     mov dl, es:[di+2]     
       
                     mov es:[di+2],al
                     ;mov es:[di+1],ah
                     mov es:[di+0],dl
        
                     add di,3
                     inc cx
                   .UNTIL cx >= gs:[bx].NColor
           .else
                   .REPEAT
        
                     pushw es:[di+0]               ;get R component
                     pushw es:[di+1]               ;get G component
                     pushw es:[di+2]               ;get B component
        
                     call RealColor
        
                     mov es:[di+0],ax
                     mov es:[di+2],dl
        
                     add di,3
                     inc cx
                   .UNTIL cx >= gs:[bx].NColor
           .endif
    .endif

    mov bx,[bp+06]
    mov eax,gs:[bx].StartFramePos

    .if (gs:[bx].EOFile == 1) && (gs:[bx].loopit == 1)
       mov gs:[bx].FramePos,eax
       mov gs:[bx].EOFile,0
    .endif

    call Bitdepth  ;get screen bit resolution
    .if (ax == 8) || (ax == 4) || (ax == 1)
        mov ax,32768
        mov Histlen,ax
        pushw Histlen           ;allocate histogram buffer 
        call DOS_Alloc          ;
        .if ax == 0
          jmp @@exiterror
        .endif
        mov HistSeg,ax
        
   
        mov eax,gs:[bx].StartFramePos
       .if gs:[bx].FramePos == eax
          push HistSeg
          push Histlen
          call memclear
       .else
          pushw gs:[bx].MEMhandle  ;move histogram out of xms memory
          pushw HistSeg            ;
          pushw 0
          pushd 32768
          pushd 256*3
          call MoveFromXMS
       .endif

        mov ax,256*Tcube
        mov Cubelistlen,ax
        pushw Cubelistlen           ;allocate cubelist buffer 
        call DOS_Alloc          ;
        .if ax == 0
          jmp @@exiterror
        .endif
        mov CubelistSeg,ax
    
        push CubelistSeg
        push Cubelistlen
        call memclear

    .endif


    mov bx,[bp+06]
    FileSeek temphandle,gs:[bx].FramePos,0 ;set filepointer to start of image frame


blockdecoder:
    .WHILE gs:[bx].EOFile == 0

     call getbyte

     .if ax == 021h  ;indicates that extension block follows
        call getbyte   ;get extension block label

        .if ax == 0f9h ;GCE label
                mov ax,offset GCE
                mov cx,size TGCEblock
                FileRead gs:[bx].FileHandle,cx,@data,ax  ;load GCE block
                .if GCE.terminator != 0                  ;GIF block Error: block terminator not found
                   jmp @@exiterror
                .endif
        .elseif ax == 0ffh ;app label
                call getbyte
                FileSeek temphandle,ax,1 ;move past block data
                call getbyte
                FileSeek temphandle,ax,1 ;move past block data
                call getbyte
                .if ax != 0           ;GIF block Error: block terminator not found
                   jmp @@exiterror
                .endif
        .elseif ax == 0feh ;comment label
                call getbyte
                FileSeek temphandle,ax,1 ;move past block data
                call getbyte
                .if ax != 0           ;GIF block Error: block terminator not found
                   jmp @@exiterror
                .endif
        .else        ;don't bother
                ;call getbyte
                ;FileSeek temphandle,ax,1 ;move past block data
                ;call getbyte
                ;.if ax != 0           ;GIF block Error: block terminator not found
                ;   jmp @@exiterror
                ;.endif
        .endif
     .elseif ax == 02ch  ;indicates an Image Separator

        mov ax,offset GIFImgDescripter          ;load image descriptor
        mov cx,size TGIFImgDescripter           ;
        FileRead gs:[bx].FileHandle,cx,@data,ax ;

        test GIFImgDescripter.ImgInfo,64        ;is image interlazed
        .if !zero?                              ;
           mov ystep,8                          ;
           mov imagerun,0                       ;
        .else                                   ;
           mov ystep,1                          ;
        .endif                                  ;

        mov ax,gs:[bx].NColor  ;
        mov ncolors,ax         ;ncolors will be # of palette colors
                               ;in the global or local palette if that is used

        test GIFImgDescripter.ImgInfo,128  ;test for a local palette
        .if !zero?
            mov cl,GIFImgDescripter.ImgInfo   ;get color size for local palette
            and cl,0111b                      ;
            inc cl                            ;
            mov eax,1                         ;
            shl ax,cl                         ;
            mov ncolors,ax                    ;

            lea ax,[eax*2+eax]                ;pal size in bytes 
            FileRead temphandle,ax,clutSeg,0  ;load local palette
            mov ax,clutSeg
            mov es,ax
            xor di,di
            xor cx,cx

                   call Bitdepth
                   .if ax == 4 || ax == 8
                           .REPEAT
                
                             mov al, es:[di+0]
                             ;mov ah, es:[di+1]
                             mov dl, es:[di+2]     
               
                             mov es:[di+2],al
                             ;mov es:[di+1],ah
                             mov es:[di+0],dl
                             

                             add di,3
                             inc cx
                           .UNTIL cx >= ncolors
                   .else
        
                            .REPEAT
                            
                             pushw es:[di+0]               ;get R component
                              pushw es:[di+1]               ;get G component
                              pushw es:[di+2]               ;get B component
                            
                              call RealColor
                            
                              mov es:[di+0],ax
                              mov es:[di+2],dl
                            
                              add di,3
                              inc cx
                            .UNTIL cx >= ncolors
                   .endif
        .endif

       mov Xpos,0
       mov Ypos,0 

       mov ax,[bp+08]     ;get gif info stucture segment and offset
       mov gs,ax
       mov bx,[bp+06]

       ;move first line from larst frame back into buffer
       movzx eax,GIFImgDescripter.ImgTopPos
       movzx ecx,gs:[bx].X
       mul ecx
       pushw gs:[bx].MEMhandle
       pushw inseg
       pushw 0
       pushd ecx
       add eax,256*3+32768
       pushd eax
       call MoveFromXMS

       mov ax,[bp+08]     ;get gif info stucture segment
       mov gs,ax
       mov bx,[bp+06]

       mov dl,GCE.fields
       shr dl,2
       and dl,0111b

       mov eax,gs:[bx].StartFramePos              ;check for first frame
       .if (eax == gs:[bx].FramePos) || (dl == 2) ;or disposal command to clear bg
           mov es,inseg                           
           xor di,di                              
           mov ax,gs:[bx].BackgroundColor         
           mov cx,gs:[bx].X                       
           rep stosb es:[di]

              mov eax,256*3+32768

              xor dx,dx

              .REPEAT
               pushw gs:[bx].MEMhandle
               pushw inseg
               pushw 0
               movzx ecx,gs:[bx].X
               pushd ecx       ;bytes to move
               pushd eax       ;xmsoffset
               call MoveToXMS

               add eax,ecx

               inc dx
              .UNTIL dx > gs:[bx].Y

       .endif


        call gifdecode                   ;decode one frame

        .if HistSeg != 0
                pushw gs:[bx].MEMhandle  ;save histogram into xms memory
                pushw HistSeg            ;
                pushw 0                  ;
                pushd 32768              ;
                pushd 256*3              ;
                call MoveToXMS           ;
        .endif

        push gs
        push bx


        call Bitdepth
        .if ax == 8
                pushw histSeg
                pushw CubelistSeg
                pushw ncolors
                call assignpalette
                mov Usedcolors,ax
        .endif

        mov ax,[bp+08]     ;get gif info stucture segment
        mov gs,ax
        mov bx,[bp+06]

        mov ax,gs:[bx].X
        mov giflenght,ax

        .if ScalingOnOff == 1
          pushw Xscalesize
          pushw Yscalesize
        .else
          pushw gs:[bx].X
          pushw gs:[bx].Y
        .endif
        pushw InSeg
        pushw gs:[bx].X
        pushw gs:[bx].Y
        pushw [bp+12]
        pushw [bp+10]
        pushw gs:[bx].MEMhandle
        pushd 256*3+32768
        call gifScale

        pop bx
        pop gs

        mov GCE.fields,0      ;erase GCE info

        call getbyte
        .if ax != 0           ;GIF block Error: block terminator not found
           jmp @@exiterror
        .endif

        jmp decoder

     .elseif ax == 03Bh ;trailer byte , indicates the end of the gif file 

                mov gs:[bx].EOFile,1

                .if gs:[bx].loopit == 1
                   FileSeek temphandle,gs:[bx].StartFramePos,0 ;set filepointer to start of image frame
                .endif
     .elseif ax == -1 ;true EOF
                mov gs:[bx].EOFile,1

                .if gs:[bx].loopit == 1
                   FileSeek temphandle,gs:[bx].StartFramePos,0 ;set filepointer to start of image frame
                .endif

                jmp decoder     ;

     .else
              ;movzx eax,ax  ;******
              ;push eax      ;******
              ;call saveit   ;******

     .endif

     mov bx,[bp+06]
    .ENDW

decoder:


     pushw temphandle
     call DISK_PointerGet

     mov bx,[bp+08] 
     mov gs,bx
     mov bx,[bp+06]

     mov word ptr gs:[bx].FramePos,ax
     mov word ptr gs:[bx+2].FramePos,dx


     .if AutoOffset == 1
         mov ax,Usedcolors
         inc ax
         and ax,255
         add paloffset,ax
     .endif


@@exiterror:

    .if CubelistSeg != 0
            pushw Cubelistlen              ;deallocate 
            pushw Cubelistseg              ;
            call DOS_DeAlloc         ;
    .endif

    .if HistSeg != 0
            pushw Histlen              ;deallocate 
            pushw Histseg              ;
            call DOS_DeAlloc         ;
    .endif

    .if OutSeg != 0
            pushw Outlen              ;deallocate 
            pushw Outseg              ;
            call DOS_DeAlloc         ;
    .endif

    .if inSeg != 0
            pushw inlen              ;deallocate 
            pushw inseg              ;
            call DOS_DeAlloc         ;
    .endif

    .if codeSeg != 0
            pushw codelen            ;deallocate 
            pushw codeSeg            ;
            call DOS_DeAlloc         ;
    .endif

    .if SuffixSeg != 0
            pushw Suffixlen          ;deallocate 
            pushw SuffixSeg          ;
            call DOS_DeAlloc         ;
    .endif

    .if PrefixSeg != 0
            pushw Prefixlen          ;deallocate 
            pushw PrefixSeg          ;
            call DOS_DeAlloc         ;
    .endif

    .if clutSeg != 0
            pushw clutlen            ;deallocate 
            pushw clutSeg            ;
            call DOS_DeAlloc         ;
    .endif
        



@@done:
    popad
    pop bp
    retf 8
putAGifext  endp


getCode proc   NEAR
        mov ax,codeSeg
        mov es,ax

        mov newCode,0
        xor cx,cx
        .REPEAT
                .if bitposition == 0
                        mov ax,datapointer
                        .if (ax == -1) || (ax >= datasize)
                           call getbyte
                           .if (ax != 0) && (ax <= 256)
                              mov datasize,ax
                              FileRead temphandle,ax,codeSeg,0
                           .endif
                           mov datapointer,0
                        .endif
                   mov si,datapointer
                   mov al,es:[si]
                   mov currentbits,al
                   inc datapointer
                .endif
        
                rcr currentbits,1
                rcr newCode,1
        
                inc bitposition
                and bitposition,0111b

                inc cx
        .UNTIL cx == CurrentCodeSize


        mov cx,CurrentCodeSize
        rol newCode,cl

        mov ax,newCode
        mov newCode,0
        ret
getCode endp


getbyte proc   NEAR
        push dx
        push bx
        push cx
        push ds

        mov inbyte,0

        mov ax,3f00h
        mov bx,temphandle
        mov dx,@data
        mov ds,dx
        mov dx,offset inbyte
        mov cx,1
        int 21h
        .if carry?
          mov inbyte,-1
        .else
          .if ax == 0
            mov inbyte,-1
          .endif
        .endif

        pop ds
        pop cx
        pop bx
        pop dx

    mov ax,inbyte
    ret
getbyte endp


drawline proc   NEAR

       call Bitdepth
       .if ax == 8
          push gs
          push bx

          pushw clutSeg
          pushw 0
          pushw HistSeg
          pushw 0
          pushw 8
          pushw inSeg
          pushw 0
          pushw gs:[bx].X;GIFImgDescripter.ImgWidth
          call AddToHistogram

          pop bx
          pop gs
       .endif

       mov bx,[bp+06]
       movzx eax,Ypos
       add ax,GIFImgDescripter.ImgTopPos
       movzx ecx,gs:[bx].X;GIFImgDescripter.ImgWidth
       mul ecx
       movzx ecx,GIFImgDescripter.ImgLeftPos
       add eax,ecx

       pushw gs:[bx].MEMhandle
       pushw inseg
       pushw GIFImgDescripter.ImgLeftPos
       movzx ecx,GIFImgDescripter.ImgWidth
       pushd ecx       ;bytes to move
       add eax,256*3+32768
       pushd eax       ;xmsoffset
       call MoveToXMS

       mov Xpos,0
       mov ax,ystep
       add Ypos,ax

       mov ax,GIFImgDescripter.ImgHeight
       .if Ypos >= ax
         inc imagerun
                              
           .if imagerun == 1
              mov ystep,8
              mov Ypos,4
           .elseif imagerun == 2
              shr ystep,1
              mov Ypos,2
           .elseif imagerun == 3
              shr ystep,1
              mov Ypos,1
           .endif
                              
       .endif

       ;move next line from larst frame back into buffer 
       mov bx,[bp+06]
       movzx eax,Ypos
       add ax,GIFImgDescripter.ImgTopPos
       movzx ecx,gs:[bx].X
       mul ecx
       pushw gs:[bx].MEMhandle
       pushw inseg
       pushw 0
       movzx ecx,gs:[bx].X
       pushd ecx
       add eax,256*3+32768
       pushd eax
       call MoveFromXMS

    ret
drawline endp


;#############################################################################
;CloseAGifext (GifHandle AS TGIFInfo)
;
;  
;#############################################################################
PUBLIC CloseAGifext
CloseAGifext proc    BASIC
    push bp
    mov bp,sp
    pusha

    mov bx,[bp+06]     ;get gif info stucture offset
    mov ax,[bp+08]     ;get gif info stucture segment
    mov gs,ax

    pushw gs:[bx].MEMhandle
    call DeallocateXMS

    mov bx,[bp+06]     
    mov ax,[bp+08]     
    mov gs,ax

    pushw gs:[bx].filehandle
    call DISK_Close         

    popa
    pop bp
    retf 4
CloseAGifext endp


;#############################################################################
;LoadGifext (Filename$, Xpos%, Ypos%)
;
;  
;#############################################################################
PUBLIC LoadGifext
LoadGifext proc    BASIC
    push bp
    mov bp,sp
    pushad

    mov headerSeg,0

    pushw size TGIFInfo
    call DOS_Alloc            
    .if ax == 0               
       jmp exiterror_loadgif
    .endif
    mov headerSeg,ax              

    pushw headerSeg
    pushw size TGIFInfo
    call memclear

    pushd [bp+10]
    pushw headerSeg
    pushw 0
    call OpenAGifext

    pushw [bp+08]
    pushw [bp+06]
    pushw headerSeg
    pushw 0
    call putAGifext

    pushw headerSeg
    pushw 0
    call CloseAGifext

    pushw size TGIFInfo  ;deallocate
    pushw headerSeg            ;
    call DOS_DeAlloc       ;

exiterror_loadgif:
    popad
    pop bp
    retf 8
LoadGifext endp



gifdecode proc    NEAR

              mov datapointer,-1
              mov bitposition,0

              call getbyte              
              mov MinCodeSize,ax

              mov dx,ax
              inc dx
              mov InitCodeSize,dx
              mov CurrentCodeSize,dx

              mov cx, MinCodeSize
              mov ax,1
              shl ax,cl
              mov ResetDecoderCode,ax

              inc ax
              mov EndOfStreamCode,ax
              inc ax
              mov InitCode,ax
              mov CodeIndex,ax

              mov cx,InitCodeSize
              mov ax,1
              shl ax,cl
              dec ax
              mov InitCodeLimit,ax
              mov CurrentCodeLimit,ax

             .WHILE 1
                   call getcode

                   .if ax == EndOfStreamCode
                      jmp exitdecoder
                   .elseif ax == ResetDecoderCode
                      mov ax,InitCode
                      mov CodeIndex,ax
                      mov ax,InitCodeSize
                      mov CurrentCodeSize,ax
                      mov ax,InitCodeLimit
                      mov CurrentCodeLimit,ax

                      call getcode

                      mov CurrentCode,ax
                      mov previousCode,ax
                      mov previousPixel,ax

                              mov dx,inSeg
                              mov es,dx
                              mov si,Xpos
                              add si,GIFImgDescripter.ImgLeftPos

                              test GCE.fields,1
                              .if !zero?           ;check transparent color
                                .if al != GCE.transparentcolor
                                    mov es:[si],al
                                .endif
                              .else
                                mov es:[si],al
                              .endif

                              inc Xpos
                              mov cx,GIFImgDescripter.ImgWidth
                              .if Xpos >= cx
                                call drawline
                              .endif

                   .else

                      mov StackPointer,0
                      mov CurrentCode,ax
                      mov temp,ax

                      .if ax == CodeIndex
                        mov ax,previousCode
                        mov CurrentCode,ax

                        mov ax,previousPixel
                        push ax            ;save pixel
                        inc StackPointer
                      .elseif ax > CodeIndex
                         jmp exitdecoder
                      .endif

                      mov ax,InitCode
                      .WHILE CurrentCode >= ax
                          mov ax,SuffixSeg
                          mov es,ax
                          mov si,CurrentCode
                          shl si,1
                          mov ax,es:[si]
                      
                          push ax          ;save pixel
                          inc StackPointer
                      
                          mov ax,PrefixSeg
                          mov es,ax
                          mov si,CurrentCode
                          shl si,1
                          mov ax,es:[si]
                          mov CurrentCode,ax
                      
                          mov ax,InitCode
                      .ENDW

                      mov ax,CurrentCode
                      push ax          ;save last pixel
                      inc StackPointer

                      mov ax,CurrentCode
                      mov previousPixel,ax

                      .REPEAT
                        pop ax
                              mov dx,inSeg
                              mov es,dx
                              mov si,Xpos
                              add si,GIFImgDescripter.ImgLeftPos

                              test GCE.fields,1
                              .if !zero?           ;check transparent color
                                .if al != GCE.transparentcolor
                                    mov es:[si],al
                                .endif
                              .else
                                mov es:[si],al
                              .endif
                             
                              inc Xpos
                              mov cx,GIFImgDescripter.ImgWidth
                              .if Xpos >= cx
                                 call drawline
                              .endif
                      
                        dec StackPointer
                      .UNTIL StackPointer == 0

                      .if CodeIndex < 4096
                          mov si,CodeIndex
                          shl si,1
                      
                          mov ax,PrefixSeg
                          mov es,ax
                          mov ax,previousCode
                          mov es:[si],ax
                      
                          mov ax,SuffixSeg
                          mov es,ax
                          mov ax,previousPixel
                          mov es:[si],ax
                      
                          inc CodeIndex
                          mov ax,CurrentCodeLimit
                          .if (CodeIndex > ax) && (CurrentCodeSize < 12)
                             inc CurrentCodeSize
                             shl CurrentCodeLimit,1
                             inc CurrentCodeLimit
                          .endif
                      .endif

                      mov ax,temp
                      mov previousCode,ax
                      mov StackPointer,0
                   .endif
             .ENDW
exitdecoder:
    retn 
gifdecode endp


;#############################################################################
;gifScale (newXsize, newYsize, bufferSeg, imageX%, imageY%, X%, Y%, xmshandle%, XMSoffset&)
;          24        22        20         18       16       14  12  10          06
;
;
;#############################################################################
PUBLIC gifScale
gifScale proc    BASIC
        push bp
        mov bp,sp

        mov ax,[bp+14]
        mov x1,ax

        mov x2,ax
        mov ax,[bp+24]
        add x2,ax
        dec x2
        
        mov ax,[bp+12]
        mov y1,ax

        mov y2,ax
        mov ax,[bp+22]
        add y2,ax
        dec y2

        .if word ptr [bp+24] != 0
                movzx ecx,word ptr [bp+24]
                movzx eax,word ptr [bp+18]
                shl eax,16      ;eax=eax*10000h
                cdq             ;eax->edx:eax 
                idiv ecx        ;edx:eax \ ecx 
                mov d1,eax
        .else
                ;mov d1,0
                jmp donescale
        .endif
        
        .if word ptr [bp+22] != 0
                movzx ecx,word ptr [bp+22]
                movzx eax,word ptr [bp+16]
                shl eax,16      ;eax=eax*10000h
                cdq             ;eax->edx:eax 
                idiv ecx        ;edx:eax \ ecx 
                mov d2,eax
        .else
                ;mov d2,0
                jmp donescale
        .endif

        mov lx,0

        mov ax,x1
        cmp ax,X1VP
        jge @F
           sub ax,X1VP
           neg ax
           movzx eax,ax
           .if ax >= [bp+24]
             jmp donescale
           .endif
           mul d1
           mov lx, eax
           mov ax,X1VP
           mov x1,ax
        @@:
        
        mov ly,0
        
        mov ax,y1
        cmp ax,Y1VP
        jge @F
           sub ax,Y1VP
           neg ax
           movzx eax,ax
           .if ax >= [bp+22]
             jmp donescale
           .endif
           mul d2
           mov ly, eax
           mov ax,Y1VP
           mov y1,ax
        @@:

        mov ax,x2
        cmp ax,X2VP
        jl @F
         mov ax,X2VP
         dec ax
         mov x2,ax
        @@:

        mov ax,x1
        cmp ax,X2VP
        jl @F
         jmp donescale
        @@:

        mov ax,y1
        mov j,ax
        mov tempy,-1
        
        .WHILE ax < y2
                movzx eax,word ptr [ly+2]

                .if tempy != ax
                        mov tempy,ax
                        movzx ecx,giflenght
                        mul ecx
                        mov edx,[bp+06] ;xmsoffset
                        add eax,edx
                
                        pushw [bp+10]  ;xmshandle
                        pushw [bp+20]  ;segment
                        pushw 0        ;offset
                        movzx ecx,giflenght
                        pushd ecx 
                        pushd eax
                        call MoveFromXMS
                
                        call Bitdepth
                        Convert histSeg,1,clutSeg,8,ax,[bp+20],OutSeg,giflenght
                        
                .endif

                pushd lx
                pushd d1
                pushw j
                pushw x1
                pushw x2
                pushw 0
                pushw OutSeg   ;segment
                call SVGAhlineScale
        
        
           mov eax,d2
           add ly,eax
           inc j
           mov ax,j
        .ENDW
donescale:

        pop bp
        retf 20
gifScale endp


;#############################################################################
;GetGIFinfo (filename$, fileInfoExt)
;
;  
;#############################################################################
PUBLIC GetGIFinfo
GetGIFinfo proc    BASIC
    push bp
    mov bp,sp
    pushad

    pushd [bp+10]     ;push seg:off pointer to filename string
    Call DISK_Open    ;if no error ax=file handle
    .if ax == 0               ;
      jmp exitinfoerror       ;
    .endif                    ;

    mov fhandle,ax
   
    mov ax,offset GIFheader
    mov cx,size TGIFheader
    FileRead fhandle,cx,@data,ax  ;load header

    les bx,[bp+06]

    mov ax,GIFheader.Xsize
    mov es:[bx].fileXres,ax

    mov ax,GIFheader.Ysize
    mov es:[bx].fileYres,ax

    mov es:[bx].fileBpp,8

    FileSeek fhandle,0,2 ;seek to eof

    pushw fhandle           ;
    call DISK_PointerGet    ;get file size

    les bx,[bp+06]

    mov word ptr es:[bx].fileSize,ax
    mov word ptr es:[bx+2].fileSize,dx

    pushw fhandle
    call DISK_Close

exitinfoerror:
    popad
    pop bp
    retf 8
GetGIFinfo endp


end
 
