;#############################################################################
;
;                    scale routine made by Future Software
;                          for BASIC programming 
;
;#############################################################################


.model medium
.stack 30h
.586
.MMX
.K3D

EXTRN X1VP:word
EXTRN Y1VP:word
EXTRN X2VP:word
EXTRN Y2VP:word

EXTRN BytesPerScanLine:word
EXTRN VideoSegment:word
EXTRN ActivePageX:word
EXTRN ActivePageY:word
EXTRN BytesPP:word
EXTRN XshiftFactor:byte
EXTRN BitsPerPixel:byte
EXTRN MaskColor:dword

EXTRN BMapStatus:word
EXTRN BMapSEG:word

EXTRN SetVESABank:FAR
EXTRN SetEMSBank:FAR

EXTRN MMXStatus:word

EXTRN MoveFromXMS:FAR


.data

X1 dw 0
X2 dw 0
Y1 dw 0
Y2 dw 0
Xsize dw 0
Ysize dw 0

d1    dd 0
d2    dd 0
lx    dd 0
ly    dd 0

x     dw 0
y     dw 0
i     dw 0
j     dw 0 

temp6 dw 0
temp4 dw 0
temp1 dw 0

bytemem dw 0

.code


;#############################################################################
;SVGAhlineScale (Y, X1, X2, offset, segment) 
;                14 12  10  08      06
;    returns nothing             (draws a horizontal bitmap line)
;#############################################################################
SVGAhlineScale  proc    BASIC
        push bp
        mov bp,sp
        push eax
        push ebx
        push ecx
        push edx

        mov ax,VideoSegment
        mov es,ax

        mov ax,[bp+06]       ;segment
        mov fs,ax
        mov si,[bp+08]       ;offset

        mov ax,[bp+14]       ;Y
        mov bx,[bp+12]       ;X1
        mov cx,[bp+10]       ;X2


        cmp bx,cx
        jl @F
        xchg bx,cx
@@:

        cmp cx,X1VP
        jl doneline1

        cmp bx,X2VP
        jge doneline1

        cmp ax,Y1VP
        jl doneline1

        cmp ax,Y2VP
        jge doneline1


        mov dx,cx
        sub dx,bx
        inc dx
        mov temp1,dx              ;temp1 = # of pixels 
        mov cl,XshiftFactor
        shl dx,cl
        .if BitsPerPixel == 24
            add dx,temp1
        .elseif BitsPerPixel == 4
            shr dx,3
        .endif
        mov temp4,dx              ;temp4 = # of bytes

        add ax,ActivePageY
        add bx,ActivePageX
        mul BytesPerScanLine
        
        mov temp6,bx
        mov cl,XshiftFactor
        shl bx,cl

        .if BitsPerPixel == 24
            add bx,temp6
        .elseif BitsPerPixel == 4
            shr bx,3
        .endif

        add ax,bx
        adc dx,0
        mov di,ax

        push dx
        .if VideoSegment == 0a000h
                Call SetVESABank
        .else
                Call SetEMSBank
        .endif
        pop dx      

        .if MMXStatus == 1
           .if BMapStatus > 0     ;init mmx blending constants

              mov al, byte ptr [BMapStatus]
              shr al,1
              movd MM3,eax
              punpcklbw MM3,MM3    ;copy byte to word 
              punpcklwd MM3,MM3    ;copy word to dword 
              ;punpckldq MM3,MM3    ;copy dword to qword   
              pxor MM7, MM7                     ;set mm7 to zero data
              punpcklbw MM3,MM7
           .endif
        .endif


        mov cx,temp1
        mov bx,BytesPP
        xor eax,eax
pixelloop1:
        movzx eax,word ptr [bp+22]

        .if bx == 1
          mov si,ax
          mov al,fs:[si]
        .elseif bx == 2
          shl ax,1
          mov si,ax
          mov ax,fs:[si]
        .elseif bx == 3
          lea ax,[eax*2+eax]
          mov si,ax
          mov eax,fs:[si]
          and eax,00ffffffh
        .elseif bx == 4
          shl ax,2
          mov si,ax
          mov eax,fs:[si]
          and eax,00ffffffh
        .endif

        cmp MaskColor,0
        jl short FilterOff111
        cmp MaskColor,eax
        jz FilerOut111
FilterOff111:

        .if bx == 1
              ;.if BMapStatus > 0
              ;   mov bx,BmapSEG
              ;   mov gs,bx
              ;   mov bl,es:[di]
              ;   mov bh,al
              ;   mov al,gs:[bx]
              ;   mov bx,1
              ;.endif
          mov es:[di],al
        .elseif bx == 2
           .if BMapStatus > 0 
              .if BitsPerPixel == 16
                      .if MMXStatus == 1
                              mov bx,word ptr es:[di]       
                              shl eax,11
                              shl ebx,11
                              shr ax,3
                              shr bx,3
                              shr eax,6
                              shr ebx,6
                              shr ax,2
                              shr bx,2
                              and eax, 000111110011111100011111b                         
                              and ebx, 000111110011111100011111b
                              movd MM1,eax                      ;mov 32 bit Foreground color data to mm1
                              movd MM2,ebx                      ;mov 32 bit Background color data to mm1
                              punpcklbw MM1,MM7                 ;unpack the 8bit data to 16bit data
                              punpcklbw MM2,MM7                 ;unpack the 8bit data to 16bit data
                              psubw MM1,MM2                     ;substract brackground from foreground
                              pmullw MM1,MM3                    ;multibly by the blend value
                              psraw MM1,7                       ;div (signed) by 128
                              paddw MM1,MM2                     ;Add Background 
                              packuswb MM1,MM1                  ;pack 16 bit down to 8bit
                              movd eax,MM1                     
                              shl ax,2
                              shl eax,6
                              shl ax,3
                              shr eax,11     
                              mov es:[di],ax                   ;draw result colors
                      .else
                              shl edx,16
                              shl ecx,16

                              mov cx,BMapStatus

                              xor ebx,ebx
                              and eax,0FFFFh
                              mov bx, es:[di];BGB              ;get background color

                              shl eax,11
                              shl ebx,11
                              shr ax,3
                              shr bx,3
                              shr eax,6
                              shr ebx,6
                              shr ax,2
                              shr bx,2
                                                       
                              and ebx, 000111110011111100011111b

                              rol eax,16      ;GB*R
                              rol ebx,16      ;GB*R
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              and al, 00011111b
                              and bl, 00011111b
                              ;shl al,3
                              ;shl bl,3
                              sub ax, bx                        ;(Signed) Subtract the Background Blue value
                              mul cx                            ;Multiply it by the alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed) Divide by 256
                              add ax, bx                        ;(Signed) Add the Background Blue value
                              ;shr al,3
                              ;shr bl,3
                              mov ah,al

                              rol eax,8       ;Br*G
                              rol ebx,8       ;Br*G
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              and al, 00111111b
                              and bl, 00111111b
                              ;shl al,2
                              ;shl bl,2
                              sub ax, bx                        ;(Signed) Subtract the Background Green value
                              mul cx                            ;Multiply it by the alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed) Divide by 256
                              add ax, bx                        ;(Signed) Add the Background Green value
                              ;shr al,2
                              ;shr bl,2
                              mov ah,al

                              rol eax,8       ;rg*B
                              rol ebx,8       ;rg*B
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              and al, 00011111b
                              and bl, 00011111b
                              ;shl al,3
                              ;shl bl,3
                              sub ax, bx                        ;(Signed)Subtract the Background Red value
                              mul cx                            ;Multiply it by the fixed alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed)Divide by 256
                              add ax, bx                        ;(Signed)Add the Background Red value
                              ;shr al,3
                              ;shr bl,3
                              mov ah,al
                              shr eax,8

                              shl ax,2
                              shl eax,6
                              shl ax,3
                              shr eax,11     

                              mov es:[di],ax                   ;draw result colors

                              shr ecx,16
                              shr edx,16
                      .endif
              .else
                      .if MMXStatus == 1
                              and eax,0FFFFh
                              mov bx, es:[di]  
                              shl eax,11  
                              shl ebx,11
                              shr ax,3    
                              shr bx,3
                              shr eax,5   
                              shr ebx,5
                              shr ax,3    
                              shr bx,3
                              and eax, 000111110011111100011111b
                              and ebx, 000111110011111100011111b
                              movd MM1,eax                      ;mov 32 bit Foreground color data to mm1
                              movd MM2,ebx                      ;mov 32 bit Background color data to mm1
                              punpcklbw MM1,MM7                 ;spread the 8bit data to 16bit data
                              punpcklbw MM2,MM7                 ;spread the 8bit data to 16bit data
                              psubw MM1,MM2                     ;substract brackground from foreground
                              pmullw MM1,MM3                    ;multibly by the blend value
                              psraw MM1,7                       ;div (signed) by 128
                              paddw MM1,MM2                     ;Add Background 
                              packuswb MM1,MM1                  ;pack 16 bit down to 8bit
                              movd eax,MM1   
                              shl ax,3
                              shl eax,5      
                              shl ax,3       
                              shr eax,11     
                              mov es:[di],ax                   ;draw result colors
                      .else

                              shl edx,16
                              shl ecx,16

                              mov cx,BMapStatus
              

                              xor ebx,ebx
                              and eax,0FFFFh
                              mov bx, es:[di];BGB              ;get background color
                              shl eax,11  
                              shl ebx,11
                              shr ax,3    
                              shr bx,3
                              shr eax,5   
                              shr ebx,5
                              shr ax,3    
                              shr bx,3

                              and ebx, 000111110001111100011111b
        
                              rol eax,16      ;GB*R
                              rol ebx,16      ;GB*R
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              and al, 00011111b
                              and bl, 00011111b
                              sub ax, bx                        ;(Signed) Subtract the Background Blue value
                              mul cx                            ;Multiply it by the alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed) Divide by 256
                              add ax, bx                        ;(Signed) Add the Background Blue value
                              mov ah,al

                              rol eax,8       ;Br*G
                              rol ebx,8       ;Br*G
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              and al, 00011111b
                              and bl, 00011111b
                              sub ax, bx                        ;(Signed) Subtract the Background Green value
                              mul cx                            ;Multiply it by the alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed) Divide by 256
                              add ax, bx                        ;(Signed) Add the Background Green value
                              mov ah,al

                              rol eax,8       ;rg*B
                              rol ebx,8       ;rg*B
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              and al, 00011111b
                              and bl, 00011111b
                              sub ax, bx                        ;(Signed)Subtract the Background Red value
                              mul cx                            ;Multiply it by the fixed alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed)Divide by 256
                              add ax, bx                        ;(Signed)Add the Background Red value
                              mov ah,al
                              shr eax,8

                              shl ax,3
                              shl eax,5      
                              shl ax,3       
                              shr eax,11     
        
                              mov es:[di],ax                   ;draw result colors

                              shr ecx,16
                              shr edx,16
                      .endif
              .endif
              mov bx,2
           .else
              mov es:[di],ax
           .endif
        .elseif bx == 3
           .if di <= 1111111111111100b
              mov es:[di],ax
              shr eax,16
              mov es:[di+2],al
           .else
              mov bytemem,3

              pixel_hlinetext24:
              mov es:[di],al
              add di,1
              jnc @F
              inc dx
              push eax
              push dx
              push bx
              push cx
              .if VideoSegment == 0a000h
                Call SetVESABank
              .else
                Call SetEMSBank
              .endif
              pop cx
              pop bx
              pop dx
              pop eax
           @@:
              ror eax,8
              dec bytemem
              jnz pixel_hlinetext24
              add si,bx
             jmp NoInc1021

           .endif
        .elseif bx == 4
           .if BMapStatus > 0 
              ;newblender
                      .if MMXStatus == 1
                              movd MM1,eax                      ;mov 32 bit Foreground color data to mm1
                              movd MM2, dword ptr es:[di]       ;mov 32 bit Background color data to mm2
                              punpcklbw MM1,MM7                 ;unpack the 8bit data to 16bit data
                              punpcklbw MM2,MM7                 ;unpack the 8bit data to 16bit data
                              psubw MM1,MM2                     ;substract brackground from foreground
                              pmullw MM1,MM3                    ;multibly by the blend value
                              psraw MM1,7                       ;div (signed) by 128
                              paddw MM1,MM2                     ;Add Background 
                              packuswb MM1,MM1                  ;pack 16 bit down to 8bit
                              movd dword ptr es:[di],MM1        ;draw the pixel
                      .else
                              shl edx,16
                              shl ecx,16
                
                              mov cx,BMapStatus

                              mov ebx, es:[di];BGB              ;get background color
                              rol eax,16      ;GB*R
                              rol ebx,16      ;GB*R
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              sub ax, bx                        ;(Signed) Subtract the Background Blue value
                              mul cx                            ;Multiply it by the alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed) Divide by 256
                              add ax, bx                        ;(Signed) Add the Background Blue value
                              mov ah,al
                
                              rol eax,8       ;Br*G
                              rol ebx,8       ;Br*G
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              sub ax, bx                        ;(Signed) Subtract the Background Green value
                              mul cx                            ;Multiply it by the alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed) Divide by 256
                              add ax, bx                        ;(Signed) Add the Background Green value
                              mov ah,al
                
                              rol eax,8       ;rg*B
                              rol ebx,8       ;rg*B
                              xor ah, ah                        ;Clear ah
                              xor bh, bh
                              sub ax, bx                        ;(Signed)Subtract the Background Red value
                              mul cx                            ;Multiply it by the fixed alpha blend (0 to 255)
                              sar ax, 8                         ;(Signed)Divide by 256
                              add ax, bx                        ;(Signed)Add the Background Red value
                              mov ah,al
                              shr eax,8
                              mov es:[di],eax                   ;draw result colors
        
                              shr ecx,16
                              shr edx,16
              
                              mov bx,4
                      .endif
           .else
              mov es:[di],eax
           .endif
        .endif
FilerOut111:

        add di,bx
        jae short NoInc1021
        inc dx
        push eax
        push bx
        push cx
        push dx
        .if VideoSegment == 0a000h
                Call SetVESABank
        .else
                Call SetEMSBank
        .endif
        pop dx
        pop cx
        pop bx
        pop eax

NoInc1021:

        mov eax,[bp+16]
        add [bp+20],eax

        dec cx
        jnz pixelloop1
doneline1:
        .if MMXStatus == 1
          emms
        .endif


        pop edx
        pop ecx
        pop ebx
        pop eax
        pop bp
        retf 18
SVGAhlineScale endp



end


