;#############################################################################
;
;                 Disk I/O routines made by Future Software
;                          for BASIC programming 
;
;#############################################################################

.model medium
.stack 10h
.386

EXTRN stringaddress:FAR
EXTRN stringlength:FAR

EXTRN DOS_Alloc:FAR
EXTRN DOS_DeAlloc:FAR

DISKError equ carry?

.data

CheckError       dw  0   ; Error Surpression Flag
ErrorCode        dw  0   ; Error code is stored in this

DTASegment       dw  0   ; DTA segment
DTAOffset        dw  0   ; DTA offset

;DTA Structure:
;DOSArea          db  19 dup(0)
;CreateTime       db  0   ;
;Attributes       dw  0   ;
;AccessTime       dw  0   ;
;AccessDate       dw  0   ;
;FileSize         dd  0   ;
;FileName         db  13 dup(0)

TRUE equ 1
FALSE equ 0

UseFar  dw TRUE

flen dw 0
fseg dw 0

tempoff dw 0
tempseg dw 0
templen dw 0

tempfilename db 128 dup(0)

.code



;#############################################################################
;DISK_Error%
;
;  AX returns the errorcode
;#############################################################################
PUBLIC DISK_Error
DISK_Error proc    BASIC
        mov ax,ErrorCode
        mov [ErrorCode],0
        retf
DISK_Error endp


;#############################################################################
;DISK_ErrorSurpress% (OnOff%)
;
;  0 = Off and return
;  1 = On and return
;  Anything else = Return only
;
;  AX returns status
;#############################################################################
PUBLIC DISK_ErrorSurpress
DISK_ErrorSurpress proc    BASIC
        push bp
        mov bp,sp

        mov dx,[bp+06]

        .if dx == 1
           mov [CheckError],dx
           mov ax,CheckError
        .elseif dx == 0
           mov [CheckError],dx
           mov ax,CheckError
        .else
           mov ax,CheckError
        .endif

        pop bp
        retf 2
DISK_ErrorSurpress endp


;#############################################################################
;DISK_Installed% 
;
;  AX returns -1 if a DISK driver is present and 0 if not
;#############################################################################
PUBLIC DISK_Installed
DISK_Installed proc    BASIC

        mov ax, 2f00h
        int 21h

        mov ax, es
        cmp ax, 0h
        je  NoDiskDriver

        mov [DTASegment], ax
        mov [DTAOffset], bx

        mov ax, -1
        jmp DoneHere

NoDISKDriver:
        xor ax, ax
DoneHere:
        retf
DISK_Installed endp


;#############################################################################
;DISK_Exit%
;
;  This is a stub function which is required by the specs.
;
;  AX returns 1
;#############################################################################
PUBLIC DISK_Exit
DISK_Exit proc    BASIC
        mov ax,1
        retf
DISK_Exit endp


;#############################################################################
;DISK_Write% (Handle%, Segment%, Offset%, Bytes%)
;
;  AX returns 0 if there is an error, 1 if OK
;#############################################################################
PUBLIC DISK_Write
DISK_Write proc    BASIC
        push bp
        mov bp,sp

        push ds

        mov ah,40h
        mov bx,[bp+12]
        mov dx,[bp+10]
        mov ds,dx
        mov dx,[bp+08]
        mov cx,[bp+06]
        int 21h

        pop ds

        mov [ErrorCode],ax
        mov ax,1h
        jnc @F
        xor ax,ax
@@:


        pop bp
        retf 8
DISK_Write endp


;#############################################################################
;DISK_Read% (Handle%, Segment%, Offset%, Bytes%)
;
;  AX returns 0 if there is an error, 1 if OK
;#############################################################################
PUBLIC DISK_Read
DISK_Read proc    BASIC
        push bp
        mov bp,sp

        push dx
        push bx
        push cx
        push ds

        mov bx,[bp+12] ;handle
        mov dx,[bp+08] ;offset
        mov cx,[bp+06] ;bytes
        mov ax,[bp+10] ;segment
        mov ds,ax         
        mov ax,3f00h
        int 21h

        pop ds

        mov ErrorCode,ax
        mov ax,1h
        jnc @F
        xor ax,ax
@@:

        pop cx
        pop bx
        pop dx

        pop bp
        retf 8
DISK_Read endp


;#############################################################################
;DISK_Open% (FileName$) (pointer to string->Seg:off)
;
;  This will open a file for I/O or create a file if it doesn't exist.
;
;  AX returns 0 if there is an error, non 0 is the file handle
;#############################################################################
PUBLIC DISK_Open
DISK_Open proc    BASIC
        push bp
        mov bp,sp
        push fs

        mov fseg,0

        lfs bx,[bp+06]     

        .if UseFar == TRUE    ;PDS callls  (needs bcl71efr.lib)
          pushw bx            ;push offset to descriptor
          call stringlength
          inc ax
          mov flen,ax         ;save filename len

          lfs bx,[bp+06]     
          pushw bx            ;push offset to descriptor
          call stringaddress
          mov si,ax
          mov fs,dx

          mov tempoff,ax
          mov tempseg,dx

        .else

          mov cx,fs:[bx]     ;length
          inc cx             ;+1 for asciiz terminator
          mov flen,cx   ;save filename len
          mov si,fs:[bx+02]  ;offset

        .endif

        ;push flen                      ;allocate buffer for the filename
        ;call DOS_Alloc
        ;.if ax == 0                  ;
        ;   jmp openerror             ;
        ;.endif                       ;
        ;mov fseg,ax
        ;mov es,ax   ;target dest.
        ;xor di,di   ;

        mov ax,@data
        mov es,ax
        mov di,offset tempfilename

        mov cx,flen
        dec cx
        rep movsb es:[di],fs:[si]
        mov byte ptr es:[di],0  ;append asciiz terminator

        push ds
        ;mov dx,0
        mov dx,offset tempfilename
        mov ax,es
        mov ds,ax
        mov ax,3d02h
        int 21h
        pop ds
        .if DISKError
          .if ax == 2
             mov cx,0h
             push ds
             mov ax,es
             mov ds,ax
             mov dx,0
             mov ax,3c00h
             int 21h
             pop ds
             .if DISKError
                ;mov [ErrorCode],ax
                jmp openerror
             .endif
          .endif
        .endif

        push ax

        ;.if fseg != 0
        ;   pushw flen         ;deallocate filename buffer
        ;   pushw fseg         ;
        ;   call DOS_DeAlloc   ;
        ;.endif

        pop ax

        ;all went well ax = DOS filehandle
        pop fs
        pop bp
        retf 4

openerror:
        ;.if fseg != 0
        ;   pushw flen         ;deallocate filename buffer
        ;   pushw fseg         ;
        ;   call DOS_DeAlloc   ;
        ;.endif

        xor ax,ax   ;no can do
        pop fs
        pop bp
        retf 4
DISK_Open endp


;#############################################################################
;DISK_Close (Handle%)
;
;  AX returns 0 if there is an error, 1 if OK
;#############################################################################
PUBLIC DISK_Close
DISK_Close proc    BASIC
        push bp
        mov bp,sp

        mov ax,3e00h
        mov bx,[bp+06]
        int 21h

        mov [ErrorCode],ax
        mov ax,1h
        jnc @F
        xor ax,ax
@@:

        pop bp
        retf 2
DISK_Close endp


;#############################################################################
;DISK_PointerSet% (Handle%, Postion&, Reference%)
;
;  AX returns 0 if there is an error, 1 if OK
;#############################################################################
PUBLIC DISK_PointerSet
DISK_PointerSet proc    BASIC
        push bp
        mov bp,sp

        mov ax,[bp+06]
        mov dx,[bp+08]
        mov cx,[bp+10]
        mov bx,[bp+12]
        mov ah,42h
        int 21h

        mov [ErrorCode],ax
        mov ax,1h
        jnc @F
        xor ax,ax
@@:
        pop bp
        retf 8
DISK_PointerSet endp


;#############################################################################
;DISK_PointerGet& (Handle%)
;
;  DX:AX returns 0 if there is an error, non 0 if OK
;#############################################################################
PUBLIC DISK_PointerGet
DISK_PointerGet proc    BASIC
        push bp
        mov bp,sp

        mov dx,0h
        mov cx,0h
        mov bx,[bp+6]
        mov ax,4201h
        int 21h

        mov [ErrorCode],ax
        jnc @F
        xor ax,ax
        xor dx,dx
@@:

        pop bp
        retf 2
DISK_PointerGet endp


;#############################################################################
;DISK_DirectoryGet% (Directory$)
;
;  Directory$ needs to be a 64-byte buffer
;
;  AX:DX returns the position of the current file pointer;
;        if the result is 0, then DISK_Error should be checked for an error.
;#############################################################################
PUBLIC DISK_DirectoryGet
DISK_DirectoryGet proc    BASIC
        push bp
        mov bp,sp

        mov dl,0
        mov bx,[bp+06]
        mov si,[bx+02]
        mov ax,4700h
        int 21h

        mov [ErrorCode],ax
        mov ax,1h
        jnc @F
        xor ax,ax
@@:

        pop bp
        retf 2
DISK_DirectoryGet endp


;#############################################################################
;DISK_DirectorySet% (Directory$)
;
;  Directory$ needs to be an ASCIIZ terminated string
;
;  AX returns 0 on error, 1 on success
;#############################################################################
PUBLIC DISK_DirectorySet
DISK_DirectorySet proc    BASIC
        push bp
        mov bp,sp

        mov bx,[bp+06]
        mov dx,[bx+02]
        mov ax,3b00h
        int 21h

        mov [ErrorCode],ax
        mov ax,1h
        jnc @F
        xor ax,ax
@@:
        pop bp
        retf 2
DISK_DirectorySet endp


;#############################################################################
;DISK_DriveGet%
;
;  AX returns 0 if there is an error, non 0 if OK
;#############################################################################
PUBLIC DISK_DriveGet
DISK_DriveGet proc    BASIC
        mov ax,1900h
        int 21h

        xor ah,ah
        inc al

        retf
DISK_DriveGet endp


;#############################################################################
;DISK_DriveSet% (Drive%)
;
;  AX returns 0 if there is an error, 1 if OK
;#############################################################################
PUBLIC DISK_DriveSet
DISK_DriveSet proc    BASIC
        mov bx,sp

        mov ax,[bx+4]
        inc ax
        mov dx,ax
        mov ax,0e00h
        int 21h

        xor ah,ah
        inc al

        retf 2
DISK_DriveSet endp


;#############################################################################
;DISK_FindFile% (Flags%, FileName$)
;
;  The full file name is put in FileName$ and should be 13 bytes long to hold
;  a full 13 character ASCIIZ file name and extension.
;
;  AX returns 0 if there is an error, 1 if OK
;#############################################################################
PUBLIC DISK_FindFile
DISK_FindFile proc    BASIC
        push bp
        mov bp,sp

        mov bx,[bp+06]
        mov dx,[bx+02]
        mov cx,[bp+08]
        mov ax,4e00h
        int 21h

        mov [ErrorCode], ax
        je NoFile

        mov ax, [DTASegment]
        mov es, ax
        mov ax, [DTAOffset+1dh]
        mov di, ax

        mov bx, [bp+06]
        mov ax, [bx+02]
        dec ax
        mov si, ax

        mov cx, 0dh
@@:
        mov ax, di
        inc ax
        mov di, ax
        mov bl, es:[di]

        mov ax, si
        inc ax
        mov si, ax
        mov ds:[si], bl

        loop @B

        xor ax, ax
        jmp DoneFind

NoFile:
        mov ax, 0
DoneFind:
        pop bp
        retf 4
DISK_FindFile endp



PUBLIC larstoff
larstoff proc    BASIC
        mov ax,tempoff
        retf 
larstoff endp

PUBLIC larstseg
larstseg proc    BASIC
        mov ax,tempseg
        retf 
larstseg endp

PUBLIC larstlen
larstlen proc    BASIC
        mov ax,flen
        retf 
larstlen endp



END
