;#############################################################################
;
;                bppconvert routine made by Future Software
;                          for BASIC programming 
;
;#############################################################################

.model medium
.stack 50h
.386


EXTRN Bitdepth:FAR

Tcube STRUCT         ;holds color space info.
     x0     db   0   ;max is 32
     y0     db   0   
     z0     db   0   
     x1     db   0   
     y1     db   0   
     z1     db   0   
     vol    dw   0   ;max is 32*32*32
     Ravg   db   0   ;avg. red in color space
     Gavg   db   0   ;avg. green in color space
     Bavg   db   0   ;avg. blue in color space
     fom    dd   0
Tcube ENDS


.data

Cube Tcube <>
newCube Tcube <>

r dw 0
g dw 0
b dw 0

k dw 0
j dw 0
i dw 0
Ravg1 dd 0
Gavg1 dd 0
Bavg1 dd 0
sum  dd 0
Rerr dw 0
Gerr dw 0
Berr dw 0
Colorerr dd 0
lasterr dd 0
deltax dw 0
deltay dw 0
deltaz dw 0
histpos dw 0
lutresult dw 0
curcubes dw 0

cubelistSeg dw 0
cubelistOff dw 0

histogramSeg dw 0
histogramOff dw 0

PALOPmethod  dw 0

maxcolors    dw 0

Usedcolors   dw 0

ScalingOnOff dw 0       ;Off=0,On=1

Yscalesize   dw 1
Xscalesize   dw 1

UsePalcolors dw 0       ;Off=0,On=1

paloffset    dw 0

bmpmaxcolors dw 256

AutoOffset  dw 0        ;Off=0,On=1

.code
;#############################################################################
;BppConvert(bpsl, histSegemnt, planes, clutSegment,InBpp, OutBpp, InSegment, InOffset, OutSegment, OutOffset, Pixels)
;           24    22           20      18          16       14       12       10         08          06        04
;  
;#############################################################################
PUBLIC BppConvert
BppConvert proc    BASIC
        mov bx,sp
        pushad

        mov ax,[bx+12]
        mov cx,[bx+10]
        mov fs,ax       ;fs = SourceSegment
        mov si,cx       ;si = SourceOffset
        mov ax,[bx+08]
        mov cx,[bx+06]
        mov es,ax       ;es = TargetSegment
        mov di,cx       ;di = TargetOffset

        mov dx,[bx+14]  ;OutBpp
        mov cx,[bx+04]  ;Pixels

        mov ax,[bx+18]  
        mov gs,ax       ;clut segment

        mov ax,[bx+16]  ;InBpp


        .if ax == 32
            .if dx == 32
                conv3232:
                  mov eax,fs:[si]
                  mov es:[di],eax
                  add si,4
                  add di,4
                dec cx
                jnz conv3232
            .elseif dx == 24
                conv3224:
                  mov eax,fs:[si]
                  mov es:[di],ax
                  shr eax,16
                  mov es:[di+2],al
                  add si,4
                  add di,3
                dec cx
                jnz conv3224
            .elseif dx == 16
                conv3216:
                  mov eax,fs:[si]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and eax,    00000000111110001111110011111000b
                  shr ah,  2 ;00000000111110000011111111111000
                  shr eax, 3 ;00000000000111110000011111111111
                  shl ax,5   ;00000000000111111111111111100000
                  shr eax,5  ;00000000000000001111111111111111
                  mov es:[di],ax
                  add si,4
                  add di,2
                dec cx
                jnz conv3216
            .elseif dx == 15
                conv3215:
                  mov eax,fs:[si]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  ;and eax,    00000000111110001111100011111000b
                  shr ah,  3 ;00000000111110000001111111111000
                  shr eax, 3 ;00000000000111110000001111111111
                  shl ax,5   ;00000000000111111111111111100000
                  shr eax,5  ;00000000000000001111111111111111
                  mov es:[di],ax
                  add si,4
                  add di,2
                dec cx
                jnz conv3215
            .elseif dx == 8
                conv328:
                   ;not implemented
                dec cx
                jnz conv328
            .elseif dx == 4
                conv324:
                   ;not implemented
                dec cx
                jnz conv324
            .elseif dx == 1
                conv321:
                   ;not implemented
                dec cx
                jnz conv321
            .endif
        .elseif ax == 24
            .if dx == 32
                conv2432:
                  mov eax,fs:[si]
                  and eax,00ffffffh
                  mov es:[di],eax
                  add si,3
                  add di,4
                dec cx
                jnz conv2432
            .elseif dx == 24
                conv2424:
                  mov ax,fs:[si]
                  mov es:[di],ax
                  mov al,fs:[si+2]
                  mov es:[di+2],al
                  add si,3
                  add di,3
                dec cx
                jnz conv2424
            .elseif dx == 16
                conv2416:
                  mov eax,fs:[si]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and eax,    00000000111110001111110011111000b
                  shr ah,  2 ;00000000RRRRR00000GGGGGGBBBBB000
                  shr eax, 3 ;00000000000RRRRR00000GGGGGGBBBBB
                  shl ax,5   ;00000000000RRRRRGGGGGGBBBBB00000
                  shr eax,5  ;0000000000000000RRRRRGGGGGGBBBBB
                  mov es:[di],ax
                  add si,3
                  add di,2
                dec cx
                jnz conv2416
            .elseif dx == 15
                conv2415:
                  mov eax,fs:[si]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and eax,    00000000111110001111100011111000b
                  shr ah,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr eax, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl ax,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr eax,6  ;00000000000000000RRRRRGGGGGBBBBB
                  mov es:[di],ax
                  add si,3
                  add di,2
                dec cx
                jnz conv2415
            .elseif dx == 8
                pushw 24          ;inBpp
                pushw ss:[bx+22]  ;histogramSegment
                pushw 0           ;histogramOffset
                pushw 8           ;outBpp
                pushw fs          ;InSegment
                pushw si          ;InOffset
                pushw es          ;OutSegment
                pushw di          ;OutOffset
                pushw cx          ;pixels
                call DoLookUp 
            .elseif dx == 4
                pushw 24          ;inBpp
                pushw ss:[bx+22]  ;histogramSegment
                pushw 0           ;histogramOffset
                pushw 4           ;outBpp
                pushw fs          ;InSegment
                pushw si          ;InOffset
                pushw es          ;OutSegment
                pushw di          ;OutOffset
                pushw cx          ;pixels
                call DoLookUp 
            .elseif dx == 1
                conv241:
                   ;not implemented
                dec cx
                jnz conv241
            .endif
        .elseif ax == 16
            .if dx == 32
                conv1632:
                  mov ax,fs:[si]             ;RRRRRGGGGGGBBBBB
                  shl eax,5  ;00000000000RRRRRGGGGGGBBBBB00000
                  shr ax,5   ;00000000000RRRRR00000GGGGGGBBBBB
                  shl eax, 3 ;00000000RRRRR00000GGGGGGBBBBB000
                  shl ah,  2 ;00000000RRRRR000GGGGGG00BBBBB000
                  and eax,    00000000111110001111110011111000b
                  mov es:[di],eax
                  add si,2
                  add di,4
                dec cx
                jnz conv1632
            .elseif dx == 24
                conv1624:
                  mov ax,fs:[si]             ;RRRRRGGGGGGBBBBB
                  shl eax,5  ;00000000000RRRRRGGGGGGBBBBB00000
                  shr ax,5   ;00000000000RRRRR00000GGGGGGBBBBB
                  shl eax, 3 ;00000000RRRRR00000GGGGGGBBBBB000
                  shl ah,  2 ;00000000RRRRR000GGGGGG00BBBBB000
                  and eax,    00000000111110001111110011111000b
                  mov es:[di],ax
                  shr eax,16
                  mov es:[di+2],al
                  add si,2
                  add di,3
                dec cx
                jnz conv1624
            .elseif dx == 16
                conv1616:
                  mov ax,fs:[si]    
                  mov es:[di],ax
                  add si,2
                  add di,2
                dec cx
                jnz conv1616
            .elseif dx == 15
                conv1615:
                  mov ax,fs:[si]     ;RRRRRGGGGGGBBBBB
                  rol eax, 2       ;RRRRRGGGGGGBBBBB00
                  shl al,1         ;RRRRRGGGGGBBBBB000
                  ror eax, 3         ;0RRRRRGGGGGBBBBB
                  mov es:[di],ax
                  add si,2
                  add di,2
                dec cx
                jnz conv1615
            .elseif dx == 8
                conv168:
                   ;implement lookuptable
                dec cx
                jnz conv168
            .elseif dx == 4
                conv164:
                   ;implement lookuptable
                dec cx
                jnz conv164
            .endif
        .elseif ax == 15
            .if dx == 32
                conv1532:
                  mov ax,fs:[si]             ;0RRRRRGGGGGBBBBB
                  shl eax,6  ;00000000000RRRRRGGGGGBBBBB000000
                  shr ax,6   ;00000000000RRRRR000000GGGGGBBBBB
                  shl eax, 3 ;00000000RRRRR000000GGGGGBBBBB000
                  shl ah,  3 ;00000000RRRRR000GGGGG000BBBBB000
                  and eax,    00000000111110001111100011111000b
                  mov es:[di],eax
                  add si,2
                  add di,4
                dec cx
                jnz conv1532
            .elseif dx == 24
                conv1524:
                  mov ax,fs:[si]             ;0RRRRRGGGGGBBBBB
                  shl eax,6  ;00000000000RRRRRGGGGGBBBBB000000
                  shr ax,6   ;00000000000RRRRR000000GGGGGBBBBB
                  shl eax, 3 ;00000000RRRRR000000GGGGGBBBBB000
                  shl ah,  3 ;00000000RRRRR000GGGGG000BBBBB000
                  and eax,    00000000111110001111100011111000b
                  mov es:[di],ax
                  shr eax,16
                  mov es:[di+2],al
                  add si,2
                  add di,3
                dec cx
                jnz conv1524
            .elseif dx == 16
                conv1516:
                  mov ax,fs:[si]   ;0RRRRRGGGGGBBBBB
                  shl eax, 3     ;RRRRRGGGGGBBBBB000
                  shr al,1       ;RRRRRGGGGG0BBBBB00
                  shr eax, 2       ;RRRRRGGGGG0BBBBB
                  mov es:[di],ax
                  add si,2
                  add di,2
                dec cx
                jnz conv1516
            .elseif dx == 15
                conv1515:
                  mov ax,fs:[si]    
                  mov es:[di],ax
                  add si,2
                  add di,2
                dec cx
                jnz conv1515
            .elseif dx == 8
                conv158:
                   ;implement lookuptable
                dec cx
                jnz conv158
            .elseif dx == 4
                conv154:
                   ;implement lookuptable
                dec cx
                jnz conv154
            .endif
        .elseif ax == 8
            .if dx == 32
                conv832:
                  movzx ebx, byte ptr fs:[si]
                  lea bx,[ebx*2+ebx]
                  mov eax,gs:[bx]
                  mov es:[di],eax
                  add di,4
                  add si,1
                dec cx
                jnz conv832
            .elseif dx == 24
                conv824:
                  movzx ebx, byte ptr fs:[si]
                  lea bx,[ebx*2+ebx]
                  mov ax,gs:[bx]
                  mov dl,gs:[bx+2]
                  mov es:[di],ax
                  mov es:[di+2],dl
                  add di,3
                  add si,1
                dec cx
                jnz conv824
            .elseif dx == 16
                conv816:
                  movzx ebx, byte ptr fs:[si]
                  lea bx,[ebx*2+ebx]
                  mov ax,gs:[bx]
                  mov es:[di],ax
                  add di,2
                  add si,1
                dec cx
                jnz conv816
            .elseif dx == 15
                conv815:
                  movzx ebx, byte ptr fs:[si]
                  lea bx,[ebx*2+ebx]
                  mov ax,gs:[bx]
                  mov es:[di],ax
                  add di,2
                  add si,1
                dec cx
                jnz conv815
            .elseif dx == 8
                push ds

                mov dx,paloffset

                mov ax,[bx+22]
                mov ds,ax

                conv88:
                  movzx ebx, byte ptr fs:[si]
                  lea bx,[ebx*2+ebx]
                
                  mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB

                  mov al,ds:[bx]
                  add al,dl   ;add palette offset

                  mov es:[di],al

                  add di,1
                  add si,1
                dec cx
                jnz conv88

               pop ds

            .elseif dx == 4
                push ds

                mov dx,paloffset

                mov ax,[bx+22]
                mov ds,ax

                xor bp,bp

                conv84:
                  movzx ebx, byte ptr fs:[si]
                  lea bx,[ebx*2+ebx]

                  mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB

                  mov al,ds:[bx]
                  add al,dl
                  and al,0fh

                  test bp, 00000001b
                  .if zero?
                     and al,0fh
                     and es:[di],0f0h
                     or es:[di],al
                  .else
                     shl al,4
                     and es:[di],00fh
                     or es:[di],al
                     inc di
                  .endif

                  inc bp
                  add si,1
                dec cx
                jnz conv84

               pop ds
            .endif
        .elseif ax == 4
            xor bp,bp
            .if dx == 32

                conv432:
                    movzx ebx, byte ptr fs:[si]
                    test bp, 00000001b
                    .if zero?
                       shr bl,4
                    .else
                       and bl,0fh
                       inc si
                    .endif
                    lea bx,[ebx*2+ebx]
                    mov eax,gs:[bx]
                    stosd

                    inc bp
                dec cx
                jnz conv432
            .elseif dx == 24
                conv424:
                    movzx ebx, byte ptr fs:[si]
                    test bp, 00000001b
                    .if zero?
                       shr bl,4
                    .else
                       and bl,0fh
                       inc si
                    .endif
                    lea bx,[ebx*2+ebx]
                    mov eax,gs:[bx]
                    stosw
                    shr eax,16
                    stosb
                    inc bp
                dec cx
                jnz conv424
            .elseif (dx == 16) || (dx == 15)
                conv416:
                    movzx ebx, byte ptr fs:[si]
                    test bp, 00000001b
                    .if zero?
                       shr bl,4
                    .else
                       and bl,0fh
                       inc si
                    .endif
                    lea bx,[ebx*2+ebx]
                    mov eax,gs:[bx]
                    stosw
                    inc bp
                dec cx
                jnz conv416
            .elseif dx == 8
                push ds

                mov dx,paloffset

                mov ax,[bx+22]
                mov ds,ax

                xor bp,bp

                conv48:
                  movzx ebx, byte ptr fs:[si]
                  test bp, 00000001b
                  .if zero?
                     shr bl,4
                  .else
                     and bl,0fh
                     inc si
                  .endif

                  lea bx,[ebx*2+ebx]

                  mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB

                  mov al,ds:[bx]
                  add al,dl      ;add pal offset

                  stosb

                  inc bp
                dec cx
                jnz conv48

                pop ds

            .elseif dx == 4
                push ds

                mov dx,paloffset

                mov ax,[bx+22]
                mov ds,ax

                xor bp,bp

                conv44:
                  movzx ebx, byte ptr fs:[si]
                  test bp, 00000001b
                  .if zero?
                     shr bl,4
                  .else
                     and bl,0fh
                     inc si
                  .endif

                  lea bx,[ebx*2+ebx]
                  add bx,dx      ;add pal offset


                  mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB

                  mov al,ds:[bx]

                  test bp, 00000001b
                  .if zero?
                     and al,0fh
                     and es:[di],0f0h
                     or es:[di],al
                  .else
                     shl al,4
                     and es:[di],00fh
                     or es:[di],al
                     inc di
                  .endif

                  inc bp
                dec cx
                jnz conv44

                pop ds

            .elseif dx == 1
                conv41:
                   ;not implemented
                dec cx
                jnz conv41
            .endif
        .elseif ax == 1

            .if dx == 32
                xor dx,dx
                conv132:
                .if dx == 0
                  mov bx,fs:[si]
                  rol bx,8
                  add si,2
                  mov dx,16
                .endif
                rol bx,1
                .if carry?
                    mov eax,gs:[3]
                .else
                    mov eax,gs:[0]
                .endif
                stosd

                dec dx
                dec cx
                jnz conv132
            .elseif dx == 24
                xor dx,dx
                conv124:
                .if dx == 0
                  mov bx,fs:[si]
                  rol bx,8
                  add si,2
                  mov dx,16
                .endif
                rol bx,1
                .if carry?
                    mov eax,gs:[3]
                .else
                    mov eax,gs:[0]
                .endif
                stosw
                shr eax,16
                stosb
                dec dx
                dec cx
                jnz conv124
            .elseif (dx == 16) || (dx == 15)
                xor dx,dx
                conv116:
                .if dx == 0
                  mov bx,fs:[si]
                  rol bx,8
                  add si,2
                  mov dx,16
                .endif
                rol bx,1
                .if carry?
                    mov eax,gs:[3]
                .else
                    mov eax,gs:[0]
                .endif
                stosw
                dec dx
                dec cx
                jnz conv116
            .elseif dx == 8
                xor dx,dx
                conv18:
                .if dx == 0
                  mov bx,fs:[si]
                  rol bx,8
                  add si,2
                  mov dx,16
                .endif
                rol bx,1
                .if carry?
                    mov al,1
                .else
                    mov al,0
                .endif
                  push ebx

                  movzx ebx,al
                  lea bx,[ebx*2+ebx]

                  mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB

                  mov al,ds:[bx]
                  add ax,paloffset      ;add pal offset

                  pop ebx

                stosb
                dec dx
                dec cx
                jnz conv18
            .elseif dx == 4
                xor dx,dx
                xor bp,bp
              conv14:
                .if dx == 0
                  mov bx,fs:[si]
                  rol bx,8
                  add si,2
                  mov dx,16
                .endif
                rol bx,1
                .if carry?
                    mov al,1
                .else
                    mov al,0
                .endif

                  test bp, 00000001b
                  .if zero?
                     and al,0fh
                     and es:[di],0f0h
                     or es:[di],al
                  .else
                     shl al,4
                     and es:[di],00fh
                     or es:[di],al
                     inc di
                  .endif

                inc bp
                dec dx
                dec cx
              jnz conv14
            .elseif dx == 1
                conv11:
                   ;implement lookuptable
                dec cx
                jnz conv11
            .endif
        .endif

        popad
        retf 22
BppConvert endp


;#############################################################################
;realign(bpsl,inbpp,inSegment,outSegment,pixels)
;          
;(used to realign planes decoded from pcx files)  
;#############################################################################
PUBLIC realign
realign proc    BASIC
        push bp
        mov bp,sp
        pushad

        xor ebx,ebx
        xor edi,edi
        xor esi,esi
        xor edx,edx


        mov ax,[bp+10]
        mov fs,ax       ;fs = SourceSegment
        mov ax,[bp+08]
        mov es,ax       ;es = targetSegment

        mov ax,[bp+12]  ;inbpp

        movzx edx, word ptr [bp+14]  ;bytes per scanline
        ;dec dx

        movzx ecx,word ptr [bp+06]  ;pixels
        ;dec cx
        mov bp,cx

        .if ax == 24
            conv:
              mov al,fs:[bx]
              mov es:[si],al

              lea edi,[edx+ebx]
              mov al,fs:[di]
              mov es:[si+1],al

              lea edi,[edx*2+ebx]
              mov al,fs:[di]
              mov es:[si+2],al

              add bx,1
              add si,3

            dec bp
            jnz conv

            mov bp,cx
            xor bx,bx

            movit:
              mov al,es:[bx+2]
              mov ah,es:[bx+1]
              mov dl,es:[bx]

              mov fs:[bx],al
              mov fs:[bx+1],ah
              mov fs:[bx+2],dl

              add bx,3

            dec bp
            jnz movit

        .endif

        popad
        pop bp
        retf 10
realign endp



;#############################################################################
;AddToHistogram(clutSeg, clutOff, HistSegment, HistOffset,InBpp, InSegment, InOffset, Pixels)
;               18       16       14           12         10     08         06        04
;  
;#############################################################################
PUBLIC AddToHistogram
AddToHistogram proc    BASIC
        mov bx,sp
        pushad

        mov ax,[bx+08]
        mov cx,[bx+06]
        mov es,ax       ;es = InSegment
        mov di,cx       ;di = InOffset
        mov ax,[bx+14]
        mov cx,[bx+12]
        mov fs,ax       ;fs = HistSegment
        mov si,cx       ;si = HistOffset
        mov ax,[bx+18]  
        mov cx,[bx+16]  
        mov gs,ax       ;gs = ClutSegment
        mov dx,cx       ;dx = ClutOffset

        mov ax,[bx+10]  ;InBpp
        mov cx,[bx+04]  ;Pixels

        .if ax == 24
                conv2415b:
                  mov ebx,es:[di]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB
                  add byte ptr fs:[si+bx],1
                  .if CARRY?
                    mov byte ptr fs:[si+bx],255
                  .endif
                  add di,3
                dec cx
                jnz conv2415b
        .elseif ax == 16
                xor ebx,ebx
                conv1615b:
                  mov bx,es:[di]     ;RRRRRGGGGGGBBBBB
                  rol ebx, 2       ;RRRRRGGGGGGBBBBB00
                  shl bl,1         ;RRRRRGGGGGBBBBB000
                  ror ebx, 3         ;0RRRRRGGGGGBBBBB
                  add byte ptr fs:[si+bx],1
                  .if CARRY?
                    mov byte ptr fs:[si+bx],255
                  .endif
                  add di,2
                dec cx
                jnz conv1615b
        .elseif ax == 15
                conv1515b:
                  mov bx,es:[di]    
                  add byte ptr fs:[si+bx],1
                  .if CARRY?
                    mov byte ptr fs:[si+bx],255
                  .endif
                  add di,2
                dec cx
                jnz conv1515b
        .elseif ax == 8

                conv8b:
                  xor bx,bx

                  movzx ebx, byte ptr es:[di]
                  lea bx,[ebx*2+ebx] ;mul 3

                  add bx,dx      ;add clut offset
                
                  mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB
                
                
                  add byte ptr fs:[si+bx],1
                  .if CARRY?
                    mov byte ptr fs:[si+bx],255
                  .endif
                
                  add di,1
                dec cx
                jnz conv8b

        .elseif ax == 4

                xor bp,bp
                conv4b:
           
                  movzx ebx, byte ptr es:[di]  ;color
                  test bp,01b
                  .if zero?
                     shr bl,4
                  .else
                     and bl,0fh
                     inc di
                  .endif

                  lea bx,[ebx*2+ebx]
                  add bx,dx      ;add clut offset
                
                  mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                  and ebx,    00000000111110001111100011111000b
                  shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                  shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                  shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                  shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB
                
                  add byte ptr fs:[si+bx],1
                  .if CARRY?
                    mov byte ptr fs:[si+bx],255
                 .endif
           
               inc bp
           
               dec cx
              jnz conv4b
        .elseif ax == 1


                xor dx,dx
                conv1b:
                .if dx == 0
                  mov ax,es:[di]
                  rol ax,8
                  add di,2
                  mov dx,16
                .endif
                rol ax,1
                .if carry?
                    mov ebx,1
                .else
                    mov ebx,0
                .endif

                lea bx,[ebx*2+ebx]

                mov ebx,gs:[bx]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                and ebx,    00000000111110001111100011111000b
                shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB

                add byte ptr fs:[si+bx],1
                .if CARRY?
                  mov byte ptr fs:[si+bx],255
               .endif


                dec dx
                dec cx
                jnz conv1b

        .endif

        popad
        retf 16
AddToHistogram endp



;#############################################################################
;DoLookUp(inBpp, HistSegment, HistOffset, OutBpp, InSegment, InOffset, OutSegment, OutOffset, Pixels)
;         20     18           16          14      12         10        08          06         04
;  
;#############################################################################
;
;
;*****************************************************************************
;This routine should be combined with the SVGAlinetext routine for easier
;access and less temporary buffer allocation. It will allso make it easier
;to support virtual 32/24/16/15 bit buffers to be used in 8bit modes, simply by
;calling SVGAlinetext. The only problem is that it needs the Histograms LUT. So
;a new version of SVGAlinetext should probably be made, or another solution could
;be to create a routine that loads and saves a pointer to the current
;Histotram LUT
;*****************************************************************************
;
;
;sofar it only supports 8bit output data.
;
;----'OutBpp' should mach the current screen depth
;
;
;***should be dropped***
;
PUBLIC DoLookUp
DoLookUp proc    BASIC
        mov bx,sp
        pushad

        mov ax,[bx+12]
        mov cx,[bx+10]
        mov es,ax       ;es = InSegment
        mov di,cx       ;di = InOffset
        mov ax,[bx+08]
        mov cx,[bx+06]
        mov gs,ax       ;gs = OutSegment
        mov bp,cx       ;bp = OutOffset
        mov ax,[bx+18]
        mov cx,[bx+16]
        mov fs,ax       ;fs = HistSegment
        mov si,cx       ;si = HistOffset


        mov ax,[bx+14]  ;OutBpp
        mov dx,[bx+20]  ;InBpp
        mov cx,[bx+04]  ;Pixels

                ;for 24bit convertion
                .if ax == 8
                        lookup8bit:
                          mov ebx,es:[di]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                          and ebx,    00000000111110001111100011111000b
                          shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                          shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                          shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                          shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB
                          mov al,fs:[si+bx]
                          add al,byte ptr paloffset
                          mov gs:[bp],al
                          add di,3
                          inc bp
                        dec cx
                        jnz lookup8bit
                .elseif ax == 4
                        xor dx,dx
                        lookup4bit:
                          mov ebx,es:[di]    ;RRRRRRRRGGGGGGGGBBBBBBBB
                          and ebx,    00000000111110001111100011111000b
                          shr bh,  3 ;00000000RRRRR000000GGGGGBBBBB000
                          shr ebx, 3 ;00000000000RRRRR000000GGGGGBBBBB
                          shl bx,6   ;00000000000RRRRRGGGGGBBBBB000000
                          shr ebx,6  ;00000000000000000RRRRRGGGGGBBBBB
                          mov al,fs:[si+bx]
                          add al,byte ptr paloffset
                          test dx, 00000001b
                          .if zero?
                             and al,0fh
                             and gs:[bp],0f0h
                             or gs:[bp],al
                          .else
                             shl al,4
                             and gs:[bp],00fh
                             or gs:[bp],al
                             inc bp
                          .endif
                          add di,3
                          inc dx
                        dec cx
                        jnz lookup4bit
                .endif

        popad
        retf 18
DoLookUp endp



;#############################################################################
;getFreq(r%,g%,b%,segmen%,offset%)
;        14 12 10 08      06
;  
;#############################################################################
PUBLIC getFreq
getFreq proc    BASIC
        push bp
        mov bp,sp
        push si

        mov bx,[bp+14] ;r
        ;and bx,5
        shl bx,10

        mov ax,[bp+12] ;g
        ;and ax,5
        shl ax,5

        mov cx,[bp+10] ;b
        ;and cx,5

        or bx,cx
        or bx,ax

        and bx,0111111111111111b

        ;les si,[bp+06]
        mov si,[bp+06]
        mov ax,[bp+08]
        mov es,ax

        movzx ax,byte ptr es:[si+bx]

        pop si
        pop bp
        retf 10
getFreq endp


;#############################################################################
;GenCubeColorStats(Cube AS Tcube, segment%, offset%)
;                  10             08      06
;  
;#############################################################################
PUBLIC GenCubeColorStats
GenCubeColorStats proc    BASIC
        push bp
        mov bp,sp

        mov si,[bp+10]
             
        mov Ravg1,0
        mov Gavg1,0
        mov Bavg1,0
        mov sum,0
        mov Colorerr,0

        ;calculate cube frequncy sum and RGB sum
        movzx ax,[si].x0
        mov k,ax
        movzx ax,[si].x1
        .while k <= ax
                movzx ax,[si].y0
                mov j,ax

                movzx ax,[si].y1
                .while j <= ax
                        movzx ax,[si].z0
                        mov i,ax

                        movzx ax,[si].z1
                        .while i <= ax
                            pushw k
                            pushw j
                            pushw i
                            pushw [bp+08]
                            pushw [bp+06]                
                            call getFreq
                             .if ax != 0
                                    movzx ecx,ax
                                    movzx eax,k
                                    mul ecx
                                    add Ravg1,eax   ;Rsum = Rsum + (k * freq)
        
                                    movzx eax,j
                                    mul ecx
                                    add Gavg1,eax   ;Gsum = Gsum + (j * freq)
        
                                    movzx eax,i
                                    mul ecx
                                    add Bavg1,eax   ;Bsum = Bsum + (i * freq)
        
                                    add sum,ecx     ;freqSum = freqSum + freq
                             .endif
                          inc i
                          movzx ax,[si].z1
                        .endw
                  inc j
                  movzx ax,[si].y1
                .endw
          inc k
          movzx ax,[si].x1
        .endw

        ;calculate cube size          ;
        movzx bx,[si].x1                ;
        sub bl,[si].x0                ;
        movzx cx,[si].y1                ;
        sub cl,[si].y0                ;
        movzx ax,[si].z1                ;
        sub al,[si].z0                ;
                                      ;
        mul bx                        ;
        mul cx                        ;
        mov ds:[si].vol,ax ;cube size ;Cube.vol = (Cube.X1 - Cube.x0) * (Cube.Y1 - Cube.y0) * (Cube.z1 - Cube.z0)

        ;calculate the Cubes RGB avarage
        .if sum != 0
          mov eax,Ravg1
          cdq
          div sum
          mov ds:[si].Ravg,al    ;Cube.Ravg = Rsum \ freqSum
        
          mov eax,Gavg1
          cdq
          div sum
          mov ds:[si].Gavg,al    ;Cube.Gavg = Gsum \ freqSum
        
          mov eax,Bavg1
          cdq
          div sum
          mov ds:[si].Bavg,al    ;Cube.Bavg = Bsum \ freqSum
        
        .else
          xor ax,ax
          xor dx,dx
          jmp donecubestats
        .endif

        ;calculate total color error of the cube (used for cube selection)
        movzx ax,[si].x0
        mov k,ax
        movzx ax,[si].x1
        .while k <= ax
                movzx ax,[si].y0
                mov j,ax

                movzx ax,[si].y1
                .while j <= ax
                        movzx ax,[si].z0
                        mov i,ax

                        movzx ax,[si].z1
                        .while i <= ax
                            pushw k
                            pushw j
                            pushw i
                            pushw [bp+08]
                            pushw [bp+06]                
                            call getFreq
                             .if ax != 0
                                movzx ecx,ax
                                movzx ax,ds:[si].Ravg
                                sub ax,k
                                mul ax
                                mov Rerr,ax 

                                movzx ax,ds:[si].Gavg
                                sub ax,j
                                mul ax
                                mov Gerr,ax 

                                movzx ax,ds:[si].Bavg
                                sub ax,i
                                mul ax
                                mov Berr,ax

                                mov ax,Rerr
                                add ax,Gerr
                                add ax,Berr

                                movzx eax,ax
                                mul ecx
                                add Colorerr,eax
;          dr% = Ravg& - k%
;          dg% = Gavg& - j%
;          db% = Bavg& - i%
;          Colorerror& = Colorerror& + ((f% * 1& * ((dr% * dr%) + (dg% * dg%) + (db% * db%))))

                             .endif
                          inc i
                          movzx ax,[si].z1
                        .endw
                  inc j
                  movzx ax,[si].y1
                .endw
          inc k
          movzx ax,[si].x1
        .endw


        mov ax,PALOPmethod
        .if ax == 0
           mov eax,Colorerr
        .elseif ax == 1
           movzx eax,ds:[si].vol
        .elseif ax == 2
           mov eax,sum
        .elseif ax == 3
           mov eax,Colorerr
           mul sum
        .elseif ax == 4
           movzx eax,ds:[si].vol
           mul sum
        .elseif ax == 5
            xor eax,eax
            mov al,ds:[si].Gavg
            mov ah,ds:[si].Ravg
            shl eax,8
            mov al, ds:[si].Bavg
        .endif

        mov [si].fom,eax

        mov ax,word ptr [sum]
        mov dx,word ptr [sum+2]
donecubestats:
        pop bp
        retf 6
GenCubeColorStats endp




;#############################################################################
;copycube(aCube, newCube)
;        
;  
;#############################################################################
PUBLIC copycube
copycube proc    BASIC
        push bp
        mov bp,sp

        push si
        push di
        push cx

        mov si,[bp+08]
        mov di,[bp+06]

        mov ax,ds
        mov es,ax
        mov cx,size Tcube
        shr cx,1
        rep movsw es:[di],ds:[si] ;copy words
        adc cx,cx                 ;add carry to cx
        rep movsb es:[di],ds:[si] ;copy remaining byte, if any

        pop cx
        pop di
        pop si

        pop bp
        retf 4
copycube endp


;#############################################################################
;copycube1(aCube segment,aCube offset,newCube segment,newCube offset)
;          12            10           08              06
;  
;#############################################################################
PUBLIC copycube1
copycube1 proc    BASIC
        push bp
        mov bp,sp

        push si
        push di
        push cx
        push es
        push fs

        mov si,[bp+10]
        mov di,[bp+06]

        mov ax,[bp+08]
        mov es,ax
        mov ax,[bp+12]
        mov fs,ax
        mov cx,size Tcube
        shr cx,1
        rep movsw es:[di],fs:[si] ;copy words
        adc cx,cx                 ;add carry to cx
        rep movsb es:[di],fs:[si] ;copy byte if any

        pop fs
        pop es
        pop cx
        pop di
        pop si

        pop bp
        retf 8
copycube1 endp


;#############################################################################
;bisectCube(aCube, newCube)
;        
;  
;#############################################################################
PUBLIC bisectCube
bisectCube proc    BASIC
        push bp
        mov bp,sp

        pushad

        mov si,[bp+08]
        mov di,[bp+06]

        push si
        push di
        call copycube

        mov al,[si].x1
        sub al,[si].x0
        mov dl,al

        mov al,[si].y1
        sub al,[si].y0
        mov cl,al

        mov al,[si].z1
        sub al,[si].z0

        .if (dl >= cl) && (dl >= al)
          mov al,[si].x1
          add al,[si].x0
          shr al,1
          mov [si].x1,al
          mov [di].x0,al
        .elseif (cl >= dl) && (cl >= al)
          mov al,[si].y1
          add al,[si].y0
          shr al,1
          mov [si].y1,al
          mov [di].y0,al
        .elseif (al >= dl) && (al >= cl)
          mov al,[si].z1
          add al,[si].z0
          shr al,1
          mov [si].z1,al
          mov [di].z0,al
        .endif

        popad

        pop bp
        retf 4
bisectCube endp


;#############################################################################
;AddCubeToList(CubesSegment%,CubesOffset%, cubetoadd, numcube%)
;
; Adds one cube to the cube list.
; 
; The list is sorted by fom number in decsending order. So the right positin
; to insert must be searched for.
;
;#############################################################################
PUBLIC AddCubeToList
AddCubeToList proc    BASIC
        push bp
        mov bp,sp
        pushad

        mov cx,[bp+06]
        mov ax,cx
        mov bx, size Tcube
        mul bx
        add ax,[bp+10]
        mov si,ax

        mov ax,[bp+12]
        mov es,ax

        mov di,[bp+08]
        mov edx,ds:[di].fom
                                                   ;cubelist[0]=top
        mov cx,[bp+06]                             ;cubelist[Size]=buttom
        .if cx > 0                                 ;
                                                   ;
          .WHILE es:[si-(size Tcube)].fom < edx   ;move cubes down in the list
                                                   ;until the new cubes .fom
            pushw es                               ;number is above or equal
            mov ax,si                              ;to the next cube below
            sub ax,size Tcube                      ;
            pushw ax                               ;
            pushw es                               ;
            pushw si                               ;
            call copycube1                         ;
            sub si,size Tcube                      ;
            dec cx                                 ;
            .BREAK .if cx == 0                     ;
          .ENDW

        .endif

        pushw ds                                   ;insert the new cube in 
        pushw di                                   ;the list
        pushw es                                   ;
        pushw si                                   ;
        call copycube1                             ;

        popad

        mov ax,[bp+06]
        inc ax

        pop bp
        retf 8
AddCubeToList endp


;#############################################################################
;DeleteCubeFromList%(CubelistSegment%, CubelistOffset%, deletethis%, CubesInList%)
;        
;  
;#############################################################################
PUBLIC DeleteCubeFromList
DeleteCubeFromList proc    BASIC
        push bp
        mov bp,sp

        mov ax,[bp+08]
        mov bx, size Tcube
        mul bx
        mov si,ax
        add si,[bp+10]
        mov ax,[bp+12]
        mov es,ax

        mov cx,[bp+06]
        dec cx
        mov dx,[bp+08]

        .if dx >= [bp+06]
           mov ax,[bp+06]   
        .else
                .WHILE dx < cx
                  mov ax,si
                  add ax,size Tcube
                  push es
                  push ax
                  push es
                  push si
                  call copycube1
                  add si,size Tcube
                  inc dx
                .ENDW
           mov ax,cx     ; return new cubelist size
        .endif

        

        pop bp
        retf 8
DeleteCubeFromList endp


;#############################################################################
;AssignLUTtoColors(Cubelistsegment%, Cubelistoffset%, histsegment%, histoffset%, Ncubes%)
;                  14                12               10            08           06
;  
;#############################################################################
PUBLIC AssignLUTtoColors
AssignLUTtoColors proc    BASIC
        push bp
        mov bp,sp
        pushad

        mov ax,[bp+10]
        mov fs,ax
        mov si,[bp+08]

        mov ax,[bp+14]
        mov es,ax

        mov Colorerr,0
        mov histpos,0
        .WHILE 1
          mov bx,histpos
          .if byte ptr fs:[si+bx] != 0
              mov b,bx
              and b,31
              mov g,bx
              shr g,5
              and g,31
              mov r,bx
              shr r,10
              and r,31

              mov lasterr,10000
              mov di,[bp+12]
              xor cx,cx
              .while cx <= [bp+06]
                                movzx ax,es:[di].Ravg
                                sub ax,r
                                mul ax
                                mov Rerr,ax 

                                movzx ax,es:[di].Gavg
                                sub ax,g
                                mul ax
                                mov Gerr,ax 

                                movzx ax,es:[di].Bavg
                                sub ax,b
                                mul ax
                                mov Berr,ax

                                mov ax,Rerr
                                add ax,Gerr
                                add ax,Berr

                                movzx eax,ax
                                 
                                .if eax <= lasterr
                                    mov lutresult,cx
                                    mov lasterr,eax
                                .endif

                add di,size Tcube
                inc cx
              .endw
              mov al,byte ptr lutresult
              mov fs:[si+bx],al

          .endif

          inc histpos
          .BREAK .if histpos > 32767
        .ENDW

        popad
        pop bp
        retf 10
AssignLUTtoColors endp


;#############################################################################
;CreateCubes(maxcubes% ,CubelistSegment%, CubelistOffset%, histsegment%, histoffset%)
;            14         12                10               08            06
;  
;#############################################################################
PUBLIC CreateCubes
CreateCubes proc    BASIC
        push bp
        mov bp,sp
        pushad

        mov ax,[bp+12]
        mov cubelistSeg,ax
        mov ax,[bp+10]
        mov cubelistOff,ax

        mov ax,[bp+08]
        mov histogramSeg,ax
        mov ax,[bp+06]
        mov histogramOff,ax

        ;.if word ptr [bp+14] > 2 ;don't add black to b/w imaging
        ;        mov Cube.x0,0                    ;make sure we have a pure black color
        ;        mov Cube.y0,0                    ;
        ;        mov Cube.z0,0                    ;
        ;        mov Cube.x1,0                    ;
        ;        mov Cube.y1,0                    ;
        ;        mov Cube.z1,0                    ;
        ;                                         ;
        ;        pushw offset Cube                ;
        ;        pushw histogramSeg               ;
        ;        pushw histogramOff               ;
        ;        call GenCubeColorStats           ;
        ;
        ;        mov Cube.fom,1000000000
        ;        pushw cubelistSeg
        ;        pushw cubelistOff
        ;        pushw offset Cube
        ;        pushw curcubes
        ;        call AddCubeToList
        ;        mov curcubes,ax
        ;
        ;.endif

        mov Cube.x0,0
        mov Cube.y0,0
        mov Cube.z0,0
        mov Cube.x1,31
        mov Cube.y1,31
        mov Cube.z1,31

        pushw offset Cube
        pushw histogramSeg
        pushw histogramOff
        call GenCubeColorStats

        pushw cubelistSeg
        pushw cubelistOff
        pushw offset Cube
        pushw 0
        call AddCubeToList
        mov curcubes,ax

        dec word ptr [bp+14]

        .WHILE ax < [bp+14]    ;not greater than max cubes

           mov ax,cubelistSeg
           mov es,ax
           mov di,cubelistOff
        
           .BREAK .if es:[di].vol <= 1
        
           pushw cubelistSeg             ;copy top cube from the list
           pushw cubelistOff             ;into 'Cube'
           pushw @data                   ;
           pushw offset Cube             ;
           call copycube1                ;
                                         ;
           pushw cubelistSeg             ;delete top cube from list
           pushw cubelistOff             ;
           pushw 0                       ;
           pushw curcubes                ;
           call DeleteCubeFromList       ;
           mov curcubes,ax               ;


           pushw offset Cube             ;bisect the cube
           pushw offset newCube          ;
           call bisectCube               ;



           pushw offset Cube             ;analyse new and old cube
           pushw histogramSeg            ;and add them to the list if sum is 
           pushw histogramOff            ;greater than zero
           call GenCubeColorStats        ;
           .if sum != 0 ;(ax != 0) || (dx != 0)
                pushw cubelistSeg
                pushw cubelistOff
                pushw offset Cube
                pushw curcubes
                call AddCubeToList
                mov curcubes,ax
           .endif
      
           pushw offset newCube
           pushw histogramSeg
           pushw histogramOff
           call GenCubeColorStats
           .if sum != 0 ;(ax != 0) || (dx != 0)
                pushw cubelistSeg
                pushw cubelistOff
                pushw offset newCube
                pushw curcubes
                call AddCubeToList
                mov curcubes,ax
           .endif
        
           mov ax,curcubes
        .ENDW


        popad
        mov ax,curcubes
        pop bp
        retf 10
CreateCubes endp


;#############################################################################
;SetPALOPmethod (m%)
;        
;  
;#############################################################################
PUBLIC SetPALOPmethod
SetPALOPmethod proc    BASIC
        push bp
        mov bp,sp

        mov ax,[bp+06]
        mov PALOPmethod,ax

        pop bp
        retf 2
SetPALOPmethod endp


;#############################################################################
;AssignPalette (histSegment%,Cubesegment%,NumColors%)
;        
;returns number of color attributes used in ax
;#############################################################################
PUBLIC AssignPalette
AssignPalette proc    BASIC
        push bp
        mov bp,sp
        pushad
                   call Bitdepth
                   .if ax == 8
                    mov ax,[bp+06]
                    mov maxcolors,ax;256
                   .elseif ax == 4
                    mov maxcolors,15;16
                   .elseif ax == 1
                    mov maxcolors,2
                   .endif
        
                   mov ax,maxcolors
                   .if bmpmaxcolors > ax
                     mov Usedcolors,ax
                   .else
                     mov ax,bmpmaxcolors
                     mov Usedcolors,ax
                   .endif
        
        
                   .if UsePalcolors == 0
                           pushw Usedcolors
                           pushw [bp+08]
                           pushw 0
                           pushw [bp+10]
                           pushw 0
                           call CreateCubes
                           mov Usedcolors,ax
                   .else
                           mov ax,[bp+08]
                           mov es,ax
                           mov si,0
                           xor cx,cx
                           .REPEAT
                             mov dx,03C7h
                             mov al,cl
                             add ax,paloffset
                             out dx,al
                    
                             mov dx,03C9h
                             in al,dx
                             shr al,1
                             mov es:[si].Ravg,al   ;get R component
                   
                             in al,dx
                             shr al,1
                             mov es:[si].Gavg,al   ;get G component
                   
                             in al,dx
                             shr al,1
                             mov es:[si].Bavg,al   ;get B component
                   
                             add si,Tcube
                             inc cx
                           .UNTIL cx > Usedcolors
                   .endif
        
                   pushw [bp+08]
                   pushw 0
                   pushw [bp+10]
                   pushw 0
                   pushw Usedcolors
                   call AssignLUTtoColors
        
                   .if UsePalcolors == 0
                           mov ax,[bp+08]
                           mov es,ax
                           mov si,0
                           xor cx,cx
                           .REPEAT
                             mov dx,03C8h
                             mov al,cl
                             add ax,paloffset
                             out dx,al
        
                             inc dx
                    
                             mov al,es:[si].Ravg   ;get R component
                             shl al,1
                             .if al > 63
                               mov al,63
                             .endif
                             out dx,al
                    
                             mov al,es:[si].Gavg   ;get G component
                             shl al,1
                             .if al > 63
                               mov al,63
                             .endif
                             out dx,al
                    
                             mov al,es:[si].Bavg   ;get B component
                             shl al,1
                             .if al > 63
                               mov al,63
                             .endif
                             out dx,al
                    
                             add si,Tcube
                             inc cx
                           .UNTIL cx > Usedcolors
                   .endif 

        popad
        pop bp
        mov ax,Usedcolors
        retf 6
AssignPalette endp


;#############################################################################
;SetScaleSize (Xsize%, Ysize%)
;
;  
;#############################################################################
PUBLIC SetScaleSize
PUBLIC Yscalesize
PUBLIC Xscalesize
SetScaleSize proc    BASIC
        mov bx,sp
        mov ax,[bx+04]
        mov Yscalesize,ax
        mov ax,[bx+06]
        mov Xscalesize,ax
        retf 4
SetScaleSize endp

;#############################################################################
;SetScale (Onoff%)    0=off,1=On
;
;  
;#############################################################################
PUBLIC SetScale
PUBLIC ScalingOnOff
SetScale proc    BASIC
        mov bx,sp
        mov ax,[bx+04]
        mov ScalingOnOff,ax
        retf 2
SetScale endp


;#############################################################################
;SetUserColors(o%)  1 or 0
;
;  
;#############################################################################
PUBLIC SetUserColors
PUBLIC UsePalcolors
SetUserColors proc    BASIC
        mov bx,sp
        mov ax,[bx+04]

        mov UsePalcolors,ax
        retf 2
SetUserColors endp


;#############################################################################
;SetPalStart(o%) 0-256 color offset
;
;  
;#############################################################################
PUBLIC SetPalStart
PUBLIC paloffset
SetPalStart proc    BASIC
        mov bx,sp
        movzx ax,byte ptr [bx+04]
        mov paloffset,ax
        retf 2
SetPalStart endp


;#############################################################################
;SetMaxColors(o%)  2-256 colors
;
;  
;#############################################################################
PUBLIC SetMaxColors
PUBLIC bmpmaxcolors
SetMaxColors proc    BASIC
        mov bx,sp
        mov ax,[bx+04]

        .if ax > 256
           mov ax,256
        .elseif ax < 2
           mov ax,2
        .endif

        mov bmpmaxcolors,ax
        retf 2
SetMaxColors endp


;#############################################################################
;SetAutoOffset(o%)  1 or 0
;
;  
;#############################################################################
PUBLIC SetAutoOffset
PUBLIC AutoOffset
SetAutoOffset proc    BASIC
        mov bx,sp
        mov ax,[bx+04]

        mov AutoOffset,ax
        retf 2
SetAutoOffset endp


END
