;#############################################################################
;
;                 import routines made by Future Software
;                          for BASIC programming
;
;#############################################################################
.model medium
.386
.stack 20h

EXTRN X1VP:word
EXTRN Y1VP:word
EXTRN X2VP:word
EXTRN Y2VP:word

EXTRN Xscalesize:word
EXTRN Yscalesize:word
EXTRN paloffset:word
EXTRN AutoOffset:word
EXTRN ScalingOnOff:word

EXTRN SVGAhlineScale:FAR
EXTRN assignpalette:FAR

EXTRN Dec2str:FAR
EXTRN Dec2hexStr:FAR
EXTRN Dec2binStr:FAR

EXTRN Bitdepth:FAR

EXTRN DOS_Alloc:FAR
EXTRN DOS_DeAlloc:FAR
EXTRN memclear:FAR

EXTRN DISK_Read:FAR
EXTRN DISK_Write:FAR
EXTRN DISK_Open:FAR
EXTRN DISK_Close:FAR
EXTRN DISK_PointerSet:FAR
EXTRN DISK_PointerGet:FAR

EXTRN SVGAhlinetext:FAR
EXTRN Scanlines:FAR
EXTRN RealColor:FAR

EXTRN BppConvert:FAR
EXTRN AddToHistogram:FAR
EXTRN CreateCubes:FAR

EXTRN AssignLUTtoColors:FAR

EXTRN IsXMSinstalled:FAR
EXTRN AllocateXMS:FAR
EXTRN MoveFromXMS:FAR
EXTRN MoveToXMS:FAR
EXTRN DeallocateXMS:FAR


Convert MACRO hist,planes,clut,InBit,Outbits,sSeg,dSeg,pixels
       pushw 0
       pushw hist
       pushw planes
       pushw clut
       pushw InBit
       pushw Outbits
       pushw sSeg
       pushw 0
       pushw dSeg
       pushw 0
       mov ax,pixels
       inc ax
       pushw ax
       ;pushw pixels
       call BppConvert
endm


FileRead MACRO handle,bytes,sg,of
        pushw handle
        pushw sg
        pushw of
        pushw bytes
        call DISK_Read
endm

FileWrite MACRO handle3,sg3,of3,bytes3
        pushw handle3
        pushw sg3
        pushw of3
        pushw bytes3
        call DISK_Write
endm
             
FileSeek MACRO handle1,pos,ref     ;ref=0||1||2
        pushw handle1
        pushd pos
        pushw ref
        call DISK_PointerSet
endm

toFile MACRO v
        pushd v
        call saveit
endm


inBytes MACRO wid,depth
         xor ax,ax
         xor ebx,ebx
    .if depth == 1
       .REPEAT
         add ax,4
         add bx,32
       .UNTIL ebx >= wid
    .elseif depth == 4
       .REPEAT
         add ax,4
         add bx,8
       .UNTIL ebx >= wid
    .elseif depth == 8
       .REPEAT
         add ax,4
         add bx,4
       .UNTIL ebx >= wid
    .elseif (depth == 15) || (depth == 16)   ;16 bit BMPs are not supported
       .REPEAT                               ;
         add ax,4                            ;
         add bx,2                            ;
       .UNTIL ebx >= wid                     ;
    .elseif depth == 24
       mov eax,wid
       lea eax,[eax*2+eax]
       mov ebx,eax
       and eax,0fffffffch
       .if ebx > eax
          add eax,4
       .endif

    .endif
endm


OutBytes MACRO BMPWid,ScreenDepth
    .if ScreenDepth == 1
      mov eax,BMPWid
      add eax,1
    .elseif ScreenDepth == 4
      mov eax,BMPWid
      shl eax,3
      ;add eax,1
    .elseif ScreenDepth == 8
      mov eax,BMPWid
      ;add eax,1
    .elseif ScreenDepth == 15
      mov eax,BMPWid
      shl eax,1
      ;add eax,2
    .elseif ScreenDepth == 16
      mov eax,BMPWid
      shl eax,1
      ;add eax,2
    .elseif ScreenDepth == 24
      mov eax,BMPWid
      lea eax,[eax*2+eax]
      ;add eax,3
    .elseif ScreenDepth == 32
      mov eax,BMPWid
      shl eax,2
    .endif
endm


DrawScanline MACRO Py,Px1,Px2,sg1,of1
        pushad
        pushw Py
        pushw Px1
        pushw Px2
        pushw of1
        pushw sg1
        call SVGAhlinetext
        popad
endm


Tcube STRUCT         ;holds color space info.
     x01     db   0   ;max is 32
     y01     db   0   
     z01     db   0   
     x11     db   0   
     y11     db   0   
     z11     db   0   
     vol1    dw   0   ;max is 32*32*32
     Ravg   db   0
     Gavg   db   0
     Bavg   db   0
     fom1    dd   0
Tcube ENDS

TfileInfoExt STRUCT
       fileXres   dw 0
       fileYres   dw 0
       fileBpp    dw 0
       fileSize   dd 0
TfileInfoExt ENDS 



.data
i     dw 0
j     dw 0 

d1    dd 0
d2    dd 0
lx    dd 0
ly    dd 0


   BType dw 19778
   BSize dd 0
   BReserved1 dw 0
   BReserved2 dw 0
   BOffset dd 0
   
   BMSize dd 40
   BMWidht dd 0
   BMHeight dd 0
   BMPlanes dw 1
   BMBitCount dw 0
   BMCompression dd 0
   BMImageSize dd 0
   BMXPPM dd 0
   BMYPPM dd 0
   BMColorUsed dd 0
   BMColorImportant dd 0

   filehandle dw 0
   fileseekstep dd 0 
   bmplength  dw 0
   ColorsUsed dw 0
   clutSeg    dw 0
   clutlen    dw 0
   bit32Seg   dw 0
   bit32len   dw 0
   x          dw 0
   y          dw 0
   x1         dw 0
   y1         dw 0
   x2         dw 0
   y2         dw 0

   h          dw 0
   w          dw 0
   lastscanline dd 0
   sx         dw 0
   sy         dw 0

   InSeg      dw 0
   Inlen      dw 0

   HistSeg     dw 0
   Histlen     dw 0

   CubelistSeg     dw 0
   Cubelistlen     dw 0

   colordepth  dw 0

fileLength   DW  sizeof file
fileOffset   DW  Offset file
file db 'output.dat', 0

NLLength   DW  sizeof NL
NLOffset   DW  Offset NL
NL db ' ',13,10


fhandel dw 0

xmshandle dw 0
xmspos    dd 0

Usedcolors    dw 0

.code


;#############################################################################
;loadBMPext (Filename$,X%,Y%)
;
;  
;#############################################################################
PUBLIC loadBMPext
loadBMPext proc    BASIC
    push bp
    mov bp,sp
    pushad

    call IsXMSinstalled
    .if ax != -1
       jmp exiterror
    .endif

    pushd [bp+10]     ;push seg:off pointer to filename string
    Call DISK_Open    ;if no error ax=file handle
    .if ax == 0               ;
      jmp exiterror           ;
    .endif                    ;

    mov filehandle,ax
   
    mov bx,offset BType
    FileRead filehandle,54,@data,bx  ;load header

    .if (BType != 19778) || (BMCompression != 0)
        jmp exiterror
    .endif


    .if BMBitCount == 8
       mov ColorsUsed,256
    .elseif BMBitCount == 4
       mov ColorsUsed,16
    .elseif BMBitCount == 1
       mov ColorsUsed,2
    .else
       mov ColorsUsed,0
    .endif

    mov HistSeg,0
    mov clutSeg,0
    mov bit32Seg,0
    mov inSeg,0
    mov CubelistSeg,0

    .if ColorsUsed != 0
        mov ax,ColorsUsed
        shl ax,2
        mov clutlen,ax
        pushw ax                  ;allocate buffer CLUT
        call DOS_Alloc            ;
        .if ax == 0
          jmp exiterror
        .endif
        mov clutSeg,ax            ;

        push clutSeg
        push clutlen
        call memclear

        FileRead filehandle,clutlen,clutSeg,0  ;load CLUT
    
        call Bitdepth
        .if (ax == 1) || (ax == 4) || (ax == 8)
        
           mov ax,clutSeg
           mov es,ax
           xor si,si
           xor di,di
           xor cx,cx
           .REPEAT    
             mov dl,es:[si+2]   ;get R component
             mov ah,es:[si+1]   ;get G component
             mov al,es:[si+0]   ;get B component

             mov es:[di+0],ax
             mov es:[di+2],dl

             add di,3
             add si,4
             inc cx
           .UNTIL cx >= ColorsUsed
        .else
    
           mov ax,clutSeg
           mov es,ax
           xor si,si
           xor di,di
           xor cx,cx
           .REPEAT
    
             pushw es:[si+2]               ;get R component
             pushw es:[si+1]               ;get G component
             pushw es:[si+0]               ;get B component
    
             call RealColor
    
             mov es:[di+0],ax
             mov es:[di+2],dl
    
             add di,3
             add si,4
             inc cx
           .UNTIL cx >= ColorsUsed
    
        .endif
    .endif

    call Bitdepth  ;get screen bit resolution
    .if (ax == 8) || (ax == 4) || (ax == 1)
        mov ax,32768
        mov Histlen,ax
        pushw Histlen           ;allocate histogram buffer 
        call DOS_Alloc          ;
        .if ax == 0
          jmp exiterror
        .endif
        mov HistSeg,ax
        
    
        push HistSeg
        push Histlen
        call memclear

        mov ax,256*Tcube
        mov Cubelistlen,ax
        pushw Cubelistlen           ;allocate cubelist buffer 
        call DOS_Alloc          ;
        .if ax == 0
          jmp exiterror
        .endif
        mov CubelistSeg,ax
    
        push CubelistSeg
        push Cubelistlen
        call memclear

    .endif


    .if (BMBitCount == 1) || (BMBitCount == 4) || (BMBitCount == 8) || (BMBitCount == 24)

        inBytes BMWidht,BMBitCount

        mov bmplength,ax

        mov inlen,ax            ;
        pushw inlen             ;allocate buffer for indata
        call DOS_Alloc          ;
        .if ax == 0
          jmp exiterror11
        .endif
        mov inSeg,ax            ;

        call Bitdepth
        OutBytes BMWidht,ax

        mov bit32len,ax
        pushw bit32len            ;allocate buffer 32bit data
        call DOS_Alloc            ;
        .if ax == 0               ;
          jmp exiterror11         ;
        .endif                    ;
        mov bit32Seg,ax           ;


        mov eax,BMHeight
        dec eax
        mov h,ax
        mov eax,BMWidht
        dec eax
        mov w,ax

        movzx eax,bmplength
        movzx ebx,h
        mul ebx
        mov ebx,eax
        add eax,BOffset
        mov lastscanline,eax     ;points to last scaline in file

        push ebx
        call AllocateXMS
        mov xmshandle,ax

        mov ax,[bp+08]      ;add x offset
        add ax,w
        mov Sx,ax

        movzx eax,bmplength
        shl eax,1
        neg eax                         
        mov fileseekstep,eax            ;-bmplength*2

        call loadhistogram

        call Bitdepth  ;get screen bit resolution
        .if (ax == 8) || (ax == 4) || (ax == 1)

           pushw histSeg
           pushw CubelistSeg
           pushw 255
           call assignpalette
           mov Usedcolors,ax
        .endif

        .if ScalingOnOff == 1
          pushw Xscalesize
          pushw Yscalesize
        .else
          pushw w
          pushw h
        .endif
        pushw inSeg
        pushw w
        pushw h
        pushw [bp+08]
        pushw [bp+06]
        pushw xmshandle
        pushd 0
        call bmpScale
        
        .if AutoOffset == 1
            mov ax,Usedcolors
            ;inc ax
            and ax,255
            add paloffset,ax
        .endif

exiterror11:
            .if bit32Seg != 0
               pushw bit32len            ;deallocate 32bit buffer
               pushw bit32Seg            ;
               call DOS_DeAlloc          ;
            .endif

            .if inSeg != 0
               pushw inlen             ;deallocate inbit buffer
               pushw inSeg             ;
               call DOS_DeAlloc        ;
            .endif

    .endif


exiterror:
    pushw filehandle
    call DISK_Close

    .if CubelistSeg != 0
       pushw Cubelistlen         ;deallocate Cubelist buffer 
       pushw CubelistSeg         ;
       call DOS_DeAlloc          ;
    .endif

    .if HistSeg != 0
       pushw Histlen             ;deallocate Histogram buffer 
       pushw HistSeg             ;
       call DOS_DeAlloc          ;
    .endif

    .if clutSeg != 0
       pushw clutlen             ;deallocate buffer CLUT
       pushw clutSeg             ;
       call DOS_DeAlloc          ;
    .endif

     push xmshandle
     call DeallocateXMS

done:
    popad
    pop bp
    retf 8;6
loadBMPext endp


;#############################################################################
;loadhistogram 
;
;  
;#############################################################################
loadhistogram proc    BASIC


        FileSeek filehandle,lastscanline,0    ;seek to first scaline

        xor cx,cx
        mov xmspos,0
        .REPEAT
                 push cx
                         
                 FileRead filehandle,bmplength,inSeg,0                 

                        call Bitdepth  ;get screen bit resolution
                         .if (ax == 8) || (ax == 4) || (ax == 1)
                                 pushw clutSeg
                                 pushw 0
                                 pushw HistSeg
                                 pushw 0
                                 pushw BMBitCount
                                 pushw inSeg
                                 pushw 0
                                 pushw w
                                 call AddToHistogram
                         .endif

                         pushw xmshandle
                         pushw inSeg
                         pushw 0
                         movzx eax,bmplength
                         pushd eax
                         pushd xmspos
                         add xmspos,eax
                         call MoveToXMS



                 FileSeek filehandle,fileseekstep,1  ;seek to start of next scanline
        
                 pop cx
        
                 inc cx
        .UNTIL cx > h


     retf
loadhistogram endp

 
;#############################################################################
;saveit (num&)  ;used internally for bug hunters to output data to a file
;
;  
;#############################################################################
public saveit
saveit proc    BASIC
    push bp
    mov bp,sp
    pushad
    push es
    push fs


    pushw offset fileLength
    Call DISK_Open
    mov fhandel,ax

    FileSeek fhandel,0,2  ;seek to end of file

    mov eax,[bp+06]
    push eax
    call Dec2Str 
    mov bx,ax

    FileWrite fhandel,@data,[bx+2],[bx]

    mov bx,offset NLLength
    FileWrite fhandel,@data,[bx+2],[bx]

;    mov bx,offset NLLength
;    FileWrite fhandel,@data,[bx+2],[bx]

    pushw fhandel
    call DISK_Close

    pop fs
    pop es
    popad
    pop bp
    retf 4
saveit endp


;#############################################################################
;bmpScale (newXsize, newYsize, bufferSeg, imageX%, imageY%, X%, Y%, xmshandle%, XMSoffset&)
;          24        22        20         18       16       14  12  10          06
;
;
;#############################################################################
PUBLIC bmpScale
bmpScale proc    BASIC
        push bp
        mov bp,sp

        mov ax,[bp+14]
        mov x1,ax

        mov x2,ax
        mov ax,[bp+24]
        add x2,ax
        dec x2
        
        mov ax,[bp+12]
        mov y1,ax

        mov y2,ax
        mov ax,[bp+22]
        add y2,ax
        dec y2

        .if word ptr [bp+24] != 0
                movzx ecx,word ptr [bp+24]
                movzx eax,word ptr [bp+18]
                shl eax,16      ;eax=eax*10000h
                cdq             ;eax->edx:eax 
                idiv ecx        ;edx:eax \ ecx 
                mov d1,eax
        .else
                mov d1,0
                jmp donescale
        .endif
        
        .if word ptr [bp+22] != 0
                movzx ecx,word ptr [bp+22]
                movzx eax,word ptr [bp+16]
                shl eax,16      ;eax=eax*10000h
                cdq             ;eax->edx:eax 
                idiv ecx        ;edx:eax \ ecx 
                mov d2,eax
        .else
                mov d2,0
                jmp donescale
        .endif

        mov lx,0

        mov ax,x1
        cmp ax,X1VP
        jge @F
           sub ax,X1VP
           neg ax
           movzx eax,ax
           .if ax >= [bp+24]
             jmp donescale
           .endif
           mul d1
           mov lx, eax
           mov ax,X1VP
           mov x1,ax
        @@:
        
        mov ly,0
        
        mov ax,y1
        cmp ax,Y1VP
        jge @F
           sub ax,Y1VP
           neg ax
           movzx eax,ax
           .if ax >= [bp+22]
             jmp donescale
           .endif
           mul d2
           mov ly, eax
           mov ax,Y1VP
           mov y1,ax
        @@:

        mov ax,x2
        cmp ax,X2VP
        jl @F
         mov ax,X2VP
         dec ax
         mov x2,ax
        @@:

        mov ax,x1
        cmp ax,X2VP
        jl @F
         jmp donescale
        @@:

        mov ax,y1
        mov j,ax
        
        .WHILE ax <= y2
                movzx eax,word ptr [ly+2]
                movzx ecx,bmplength;word ptr [bp+18]
                mul ecx
                mov ebx,[bp+06] ;xmsoffset
                add eax,ebx

        
                pushw [bp+10]  ;xmshandle
                pushw [bp+20]  ;segment
                pushw 0        ;offset
                movzx ecx,bmplength;word ptr [bp+18]
                pushd ecx 
                pushd eax
                call MoveFromXMS
        
                call Bitdepth  ;get screen bit resolution
                Convert histSeg,1,clutSeg,BMBitCount,ax,[bp+20],bit32Seg,w
        
                pushd lx
                pushd d1
                pushw j
                pushw x1
                pushw x2
                pushw 0
                pushw bit32Seg   ;segment
                call SVGAhlineScale
        
        
           mov eax,d2
           add ly,eax
           inc j
           mov ax,j
        .ENDW
donescale:

        pop bp
        retf 20
bmpScale endp


;#############################################################################
;GetBMPinfo (filename$, fileInfoExt)
;
;  
;#############################################################################
PUBLIC GetBMPinfo
GetBMPinfo proc    BASIC
    push bp
    mov bp,sp
    pushad

    pushd [bp+10]     ;push seg:off pointer to filename string
    Call DISK_Open    ;if no error ax=file handle
    .if ax == 0               ;
      jmp exitinfoerror       ;
    .endif                    ;

    mov filehandle,ax
   
    mov bx,offset BType
    FileRead filehandle,54,@data,bx  ;load header

    .if (BType != 19778) || (BMCompression != 0)
        jmp exitinfoerror
    .endif

    les bx,[bp+06]

    mov eax,BMWidht
    mov es:[bx].fileXres,ax

    mov eax,BMHeight
    mov es:[bx].fileYres,ax

    mov ax,BMBitCount
    mov es:[bx].fileBpp,ax

    FileSeek filehandle,0,2 ;seek to eof

    pushw filehandle        ;
    call DISK_PointerGet    ;get file size

    les bx,[bp+06]

    mov word ptr es:[bx].fileSize,ax
    mov word ptr es:[bx+2].fileSize,dx

    pushw filehandle
    call DISK_Close

exitinfoerror:
    popad
    pop bp
    retf 8
GetBMPinfo endp


end
