DECLARE SUB ResetPal ()
REM $INCLUDE: 'future.bi'
REM $INCLUDE: 'flimpext.bi'

'Demontrates how to optimize multiple palettes into one palette

'Optimizes to use 128 colors.

Set640x480 8

SetAutoOffset 1  'Set the library to auto increase the offset so the next image
                 'that is loaded will not use the same palette attibutes

SetMaxColors 128  'Set the maximum amount of colors an image can have

Future.LoadPCX.ext "flower.pcx", 0, 0
Future.LoadPCX.ext "fruit.pcx", 300, 0

FOR I% = 0 TO 255
  Future.LINE I%, 400, I%, 440, I%, -1
NEXT

Future.PRINT 0, 380, "Hit any key to optimize", 15, 0
SLEEP

Future.SNAPSHOT "temp.bmp" 'save the loaded images into one image


ResetPal         'resetpal so we can compare the result
SetAutoOffset 0  'turn autooffset of
SetPalStart 0    'and set the offset to 0
Future.LoadBMP.ext "temp.bmp", 0, 0 'load and optimize image again

'you can save this new optimised palette and use it
'for all the images that was loaded into the temp.bmp file
'like this:
SavePal "new.pal"

'the new palette can now be used as a userdefines palette
ResetPal
LoadPal "new.pal"
SetUserColors 1  'now the library will only use the current loaded palette

'Now the larst thing to do is to load the images again with the user palette
'
Future.LoadPCX.ext "flower.pcx", 0, 0
Future.LoadPCX.ext "fruit.pcx", 300, 0

'what you see now is that the two images is sharing the palette with 128 attributes


FOR I% = 0 TO 255
  Future.LINE I%, 400, I%, 440, I%, -1
NEXT


SLEEP
ReSetScreen

SUB ResetPal
ReSetScreen
Set640x480 8
END SUB

