DECLARE SUB DrawBox (y1%, x1%, y2%, x2%)
DECLARE SUB Dummy.Load ()
DECLARE SUB Main.Load ()
DECLARE SUB Main.Show ()

'$INCLUDE: 'menubar.bi'
'$INCLUDE: 'conio.bi'
'$DYNAMIC

OPTION BASE 0

'   create objects
DIM mnuMainIndex(0) AS MenuIdxType
DIM mnuMainItem(0) AS MenuItemType
DIM datMain AS MaxType

DIM mnuDummyIndex(0) AS MenuIdxType
DIM mnuDummyItem(0) AS MenuItemType
DIM datDummy AS MaxType

'   load menu
Main.Load
Dummy.Load

'   print initial screen
CALL Curtain

Main.Show
'Dummy.Show

DIM KeyHit AS STRING
DIM Choice AS INTEGER
LOCATE , , 0

DO
    KeyHit$ = GetKey$

    IF KeyHit$ = CHR$(ALT) THEN Choice = Main%(datMain, mnuMainIndex(), mnuMainItem())
    'IF KeyHit$ = CHR$(ALT) THEN Choice = Main%(datDummy, mnuDummyIndex(), mnuDummyItem())
  
LOOP UNTIL (Choice AND 255) = 7 OR KeyHit$ = CHR$(ESC)
END

MenuData:
DATA /&File
DATA ...&New Document...
DATA ...&Open Document...
DATA ...&Merge...
DATA ...&Save...
DATA ...Save &As...
DATA ...<brk>
DATA ...E&xit

DATA /&Edit
DATA ...Cu&t        Shift+Del
DATA ...&Copy       Shift+Ins
DATA ...&Paste
DATA ...&Search...

DATA /&View
DATA ...S&plit
DATA ...O&utput Screen     F4

DATA /&Search
DATA ...&Find...
DATA ...Repeat &Last Find
DATA ...&Replace

DATA /&Run
DATA ...&Start
DATA ...&Restart

DATA /&Debug
DATA ...&Add Watch...

DATA /&Calls
DATA ...&Previous

DATA /&Options
DATA ...&Display...
DATA ...Set &Paths...

DATA \&Help
DATA ...&Contents
DATA ...&Idx

DATA /EOF


DummyData:

DATA /&Finished
DATA ...&Add Watch...

DATA /&Call what
DATA ...&Previous

DATA /&Options
DATA ...&Display...
DATA ...Set &Paths...

DATA \&OORAH
DATA ...&Contents
DATA ...Yeah &Baby
DATA ...&Idx

DATA /EOF

REM $STATIC
'   toggles the cursor without changing it
'
SUB CursorOn (OnOff%) STATIC

DIM CursorLine AS INTEGER
DIM CursorColumn AS INTEGER
DIM Top AS INTEGER
DIM Bottom AS INTEGER
DIM Status AS INTEGER

IF OnOff THEN
   
    '   restore cursor settings
    LOCATE CursorLine, CursorColumn, Status, Top, Bottom
ELSE
   
    '   save cursor settings
    Top = PEEK(1121) AND 31
    Bottom = PEEK(1120) AND 31
    IF PEEK(1121) AND 32 THEN Status = FALSE ELSE Status = 1
    
    CursorLine = CSRLIN
    CursorColumn = POS(0)
    LOCATE , , 0
END IF

END SUB

SUB Dummy.Load

SHARED mnuDummyIndex() AS MenuIdxType
SHARED mnuDummyItem() AS MenuItemType
SHARED datDummy AS MaxType

RESTORE DummyData
CALL MaxData(datDummy)

RESTORE DummyData
CALL LoadMenu(datDummy, mnuDummyIndex(), mnuDummyItem())

END SUB

SUB Dummy.Show

SHARED mnuDummyIndex() AS MenuIdxType
SHARED mnuDummyItem() AS MenuItemType
SHARED datDummy AS MaxType

CALL PrintMenuBar(datDummy, mnuDummyIndex(), mnuDummyItem())

END SUB

'   gets user input, including ALT, CTRL, and SHIFT
'
FUNCTION GetKey$

DIM Tx AS INTEGER
DIM Rx AS STRING

Rx = INKEY$

Tx = PEEK(1047) AND 15
IF Tx AND 1 OR Tx AND 2 THEN
    Tx = SHIFT
ELSEIF Tx AND 4 THEN Tx = CTRL
ELSEIF Tx AND 8 THEN Tx = ALT
END IF

GetKey$ = Rx
IF Rx = "" AND Tx > 0 THEN GetKey$ = CHR$(Tx)

END FUNCTION

'   loads the menu from DATA into array
'
SUB LoadMenu (Max AS MaxType, MenuIdx() AS MenuIdxType, MenuItem() AS MenuItemType)

DIM Label AS STRING
DIM Alignment AS STRING * 1
DIM Idx AS INTEGER
DIM IdxColumnR AS INTEGER
DIM IdxColumnL AS INTEGER
DIM x AS INTEGER
DIM ptr AS INTEGER

'   redimension arrays
REDIM MenuIdx(1 TO Max.Idx) AS MenuIdxType
REDIM MenuItem(1 TO Max.Item) AS MenuItemType

'   initial setting for index alignment
IdxColumnL = 3
IdxColumnR = 80

READ Label
DO UNTIL Label = "/EOF"
    IF LEFT$(Label, 1) = "/" OR LEFT$(Label, 1) = "\" THEN

        Alignment = LEFT$(Label, 1)
        Idx = Idx + 1

        '   find shortcut key
        FOR x = 1 TO LEN(Label)
            IF MID$(Label, x, 1) = "&" THEN
                MenuIdx(Idx).ShortKey = x - 1
                EXIT FOR
            END IF
        NEXT x

        '   assign label and increase counter
        Label = LEFT$(Label, x - 1) + MID$(Label, x + 1)
        Label = MID$(Label, 2)
        MenuIdx(Idx).Label = Label

        '   assign menu IdxColumn
        IF Alignment = "/" THEN
            MenuIdx(Idx).IdxColumn = IdxColumnL
            IdxColumnL = IdxColumnL + LEN(Label) + 2
        ELSE
            IdxColumnR = IdxColumnR - LEN(Label) - 2
            MenuIdx(Idx).IdxColumn = IdxColumnR
        END IF
       
    '   read item
    ELSEIF LEFT$(Label, 3) = "..." THEN
       
        '   move index pointer
        ptr = ptr + 1
        IF MenuIdx(Idx).IdxStart = 0 THEN MenuIdx(Idx).IdxStart = ptr

        '   increment max items count
        MenuIdx(Idx).MaxItem = MenuIdx(Idx).MaxItem + 1
       
        '   find shortcut key
        FOR x = 1 TO LEN(Label)
            IF MID$(Label, x, 1) = "&" THEN
                MenuItem(ptr).ShortKey = x - 3
                EXIT FOR
            END IF
        NEXT x
       
        '   clean up label
        Label = LEFT$(Label, x - 1) + MID$(Label, x + 1)
        Label = MID$(Label, 4)
        MenuItem(ptr).Label = Label
       
        '   set max length
        IF LEN(Label) > MenuIdx(Idx).MaxWidth THEN MenuIdx(Idx).MaxWidth = LEN(Label)
       
        '   set items box starting column
        IF MenuIdx(Idx).IdxColumn + MenuIdx(Idx).MaxWidth > 76 THEN
            MenuIdx(Idx).StartCol = 76 - MenuIdx(Idx).MaxWidth
        ELSE
            MenuIdx(Idx).StartCol = MenuIdx(Idx).IdxColumn
        END IF
       
    END IF
    READ Label
LOOP

MenuIdx(2).Disabled = TRUE
MenuItem(2).Disabled = TRUE
MenuItem(3).Bullet = TRUE
END SUB

'   holds it all together
'
FUNCTION Main% (Max AS MaxType, MenuIdx() AS MenuIdxType, MenuItem() AS MenuItemType)

DIM KeyHit AS STRING
DIM Idx AS INTEGER
DIM State AS INTEGER
DIM Selected AS INTEGER
DIM x AS INTEGER
DIM ptr AS INTEGER

'   save screen and set initial values
PCOPY 0, 1
Idx = 1
ptr = 1
State = LOW
Selected = FALSE

'   save cursor position and turn cursor off
CALL CursorOn(FALSE)

DO

    DO
        KeyHit$ = GetKey$
    LOOP WHILE KeyHit$ = ""

    '   check for shortcut keys
    IF LEN(KeyHit$) = 1 THEN KeyHit$ = ShortKey(Idx, ptr, State, KeyHit$, MenuIdx(), MenuItem(), Max)

    '   check for ALT key pressed
    IF KeyHit$ = CHR$(ALT) THEN

        '   user pressed ALT to enter menu
        IF State = LOW THEN

            '   turn on index short keys
            FOR x = 1 TO Max.Idx
                CALL PrintItem(x, ROOT, LOMED, MenuIdx(), MenuItem())
            NEXT x
        END IF
       
        '   wait for user to release ALT key
        DO
       
            '   check for ALTed shortcut keys
            KeyHit$ = GetKey$
            IF LEN(KeyHit$) = 2 THEN
                KeyHit$ = ScanCode$(KeyHit$)
                IF LEN(KeyHit$) = 1 THEN
                    State = LOMED
                    KeyHit$ = ShortKey(Idx, ptr, State, KeyHit$, MenuIdx(), MenuItem(), Max)
                END IF
            END IF
        LOOP WHILE KeyHit$ = CHR$(ALT)

        '   user pressed ALT to exit menu
        IF State = HIMED THEN

            KeyHit$ = CHR$(27)
        ELSEIF State = HIGH THEN

            '   turn on index short keys
            PCOPY 1, 0
            FOR x = 1 TO Max.Idx
                CALL PrintItem(x, ROOT, LOMED, MenuIdx(), MenuItem())
            NEXT x
        END IF
        IF State <> HIMED THEN

            '   turn on initial index
            State = HIMED
            CALL PrintItem(Idx, ROOT, HIMED, MenuIdx(), MenuItem())
        END IF
    END IF

    '   check for regular keys
    IF LEFT$(KeyHit$, 1) = CHR$(0) THEN

        SELECT CASE RIGHT$(KeyHit$, 1)
            CASE CHR$(UP)
                CALL PrintItem(Idx, ptr, LOMED, MenuIdx(), MenuItem())
                IF State = HIMED THEN
                    KeyHit$ = CHR$(ENTER)
                ELSE
                    ptr = ptr - 1
                    IF ptr < MenuIdx(Idx).IdxStart THEN ptr = MenuIdx(Idx).IdxStart + MenuIdx(Idx).MaxItem - 1
                    IF MenuItem(ptr).ShortKey = 0 THEN ptr = ptr - 1
                END IF
                CALL PrintItem(Idx, ptr, HIMED, MenuIdx(), MenuItem())
           
            CASE CHR$(DOWN)
                CALL PrintItem(Idx, ptr, LOMED, MenuIdx(), MenuItem())
                IF State = HIMED THEN
                    KeyHit$ = CHR$(ENTER)
                ELSE
                    ptr = ptr + 1
                    IF ptr > MenuIdx(Idx).IdxStart + MenuIdx(Idx).MaxItem - 1 THEN ptr = MenuIdx(Idx).IdxStart
                    IF MenuItem(ptr).ShortKey = 0 THEN ptr = ptr + 1
                END IF
                CALL PrintItem(Idx, ptr, HIMED, MenuIdx(), MenuItem())
           
            CASE CHR$(LEFT)
                IF State = HIMED THEN
                    CALL PrintItem(Idx, ROOT, LOMED, MenuIdx(), MenuItem())
                    Idx = Idx - 1
                    IF Idx = 0 THEN Idx = Max.Idx
                    CALL PrintItem(Idx, ROOT, HIMED, MenuIdx(), MenuItem())
                ELSEIF State = HIGH THEN
                    Idx = Idx - 1
                    IF Idx = 0 THEN Idx = Max.Idx
                    CALL PrintMenu(Idx, MenuIdx(), MenuItem())
                END IF
                ptr = MenuIdx(Idx).IdxStart

            CASE CHR$(RIGHT)
                IF State = HIMED THEN
                    CALL PrintItem(Idx, ROOT, LOMED, MenuIdx(), MenuItem())
                    Idx = Idx + 1
                    IF Idx > Max.Idx THEN Idx = 1
                    CALL PrintItem(Idx, ROOT, HIMED, MenuIdx(), MenuItem())
                ELSE
                    Idx = Idx + 1
                    IF Idx > Max.Idx THEN Idx = 1
                    CALL PrintMenu(Idx, MenuIdx(), MenuItem())
                END IF
                ptr = MenuIdx(Idx).IdxStart

        END SELECT

    ELSEIF KeyHit$ = CHR$(ESC) THEN
        State = HIGH
        KeyHit$ = CHR$(ENTER)
        Main = 0
        Selected = TRUE

    END IF

    '   ENTER
    IF KeyHit$ = CHR$(ENTER) THEN

        '   made a selection
        IF State = HIGH THEN
            IF NOT MenuItem(ptr).Disabled AND NOT MenuIdx(Idx).Disabled THEN
                Main = ptr
                Selected = TRUE
            END IF

        '   turn on menu
        ELSEIF State = HIMED THEN
            State = HIGH
            CALL PrintMenu(Idx, MenuIdx(), MenuItem())
            ptr = MenuIdx(Idx).IdxStart

        END IF

        '   if user is holding ALT, wait for release
        WHILE GetKey$ = CHR$(ALT): WEND

    END IF

LOOP UNTIL Selected%

'   restore initial screen and cursor
PCOPY 1, 0
CALL CursorOn(TRUE)

END FUNCTION

SUB Main.Load

SHARED mnuMainIndex() AS MenuIdxType
SHARED mnuMainItem() AS MenuItemType
SHARED datMain AS MaxType

RESTORE MenuData
CALL MaxData(datMain)

RESTORE MenuData
CALL LoadMenu(datMain, mnuMainIndex(), mnuMainItem())

END SUB

SUB Main.Show

SHARED mnuMainIndex() AS MenuIdxType
SHARED mnuMainItem() AS MenuItemType
SHARED datMain AS MaxType

CALL PrintMenuBar(datMain, mnuMainIndex(), mnuMainItem())

END SUB

'   finds the max array bounds of the menu
'
SUB MaxData (Max AS MaxType)

DIM Label AS STRING

READ Label
DO UNTIL Label = "/EOF"
    IF LEFT$(Label, 1) = "/" OR LEFT$(Label, 1) = "\" THEN
        Max.Idx = Max.Idx + 1
    ELSEIF LEFT$(Label, 3) = "..." THEN
        Max.Item = Max.Item + 1
    END IF
    READ Label
LOOP

END SUB

'   prints menu index and item labels
'
SUB PrintItem (Idx, ptr, State, MenuIdx() AS MenuIdxType, MenuItem() AS MenuItemType)

DIM Fore AS INTEGER
DIM Back AS INTEGER
DIM Item AS INTEGER

Fore = 0
Back = 7

'   account for menu being disabled
IF MenuIdx(Idx).Disabled THEN Fore = 8
IF ptr > ROOT THEN IF MenuItem(ptr).Disabled THEN Fore = 8

'   select proper colors
IF State > LOMED THEN SWAP Fore, Back
COLOR Fore, Back

'   print item
IF ptr = ROOT THEN
   
    Item = 0
   
    '   print label
    LOCATE Item + 1, MenuIdx(Idx).IdxColumn
    PRINT " "; RTRIM$(MenuIdx(Idx).Label); " ";
   
    '   set cursor for short key
    LOCATE Item + 1, MenuIdx(Idx).IdxColumn + MenuIdx(Idx).ShortKey

ELSE
   
    Item = ptr - MenuIdx(Idx).IdxStart + 1
   
    '   print label
    LOCATE Item + 2, MenuIdx(Idx).StartCol
    IF MenuItem(ptr).ShortKey = BREAK THEN
        LOCATE , POS(0) - 1
        PRINT ""; STRING$(MenuIdx(Idx).MaxWidth + 2, ""); ""
    ELSE
        PRINT " "; LEFT$(MenuItem(ptr).Label, MenuIdx(Idx).MaxWidth); " ";
    END IF
   
    '   print bullet
    IF MenuItem(ptr).Bullet THEN
        LOCATE Item + 2, MenuIdx(Idx).StartCol
        CALL rPrint(7, Fore, Back)
    END IF
   
    '   set cursor for short key
    LOCATE Item + 2, MenuIdx(Idx).StartCol + MenuItem(ptr).ShortKey

END IF

'   select color for short key (short key only on in MED states)
SELECT CASE State
    CASE LOMED: COLOR 15, 7
    CASE HIMED: COLOR 15, 0
END SELECT

'   print short key if not disabled
IF NOT MenuIdx(Idx).Disabled THEN
    IF ptr = ROOT THEN
        PRINT MID$(MenuIdx(Idx).Label, MenuIdx(Idx).ShortKey, 1);

    ELSEIF MenuItem(ptr).ShortKey <> BREAK AND NOT MenuItem(ptr).Disabled THEN
        
        PRINT MID$(MenuItem(ptr).Label, MenuItem(ptr).ShortKey, 1);
    END IF
END IF

END SUB

'   prints specified menu
'
SUB PrintMenu (Idx, MenuIdx() AS MenuIdxType, MenuItem() AS MenuItemType)

DIM x AS INTEGER

'   turn off old menu
PCOPY 1, 0

'   print box
CALL Box(2, MenuIdx(Idx).StartCol - 1, MenuIdx(Idx).MaxItem + 3, MenuIdx(Idx).StartCol + MenuIdx(Idx).MaxWidth + 2, TRUE)

'   fill box with items
FOR x = MenuIdx(Idx).IdxStart TO MenuIdx(Idx).IdxStart + MenuIdx(Idx).MaxItem - 1
    CALL PrintItem(Idx, x, LOMED, MenuIdx(), MenuItem())
NEXT x

'   highlight index
CALL PrintItem(Idx, ROOT, HIGH, MenuIdx(), MenuItem())

'   highlight initial item
CALL PrintItem(Idx, MenuIdx(Idx).IdxStart, HIMED, MenuIdx(), MenuItem())

' "óڿ"
END SUB

'   prints menu index on top line
'
SUB PrintMenuBar (Max AS MaxType, MenuIdx() AS MenuIdxType, MenuItem() AS MenuItemType)

DIM x AS INTEGER

'   print white line on top of screen
COLOR 0, 7
LOCATE 1, 1: PRINT SPACE$(80);

FOR x = 1 TO Max.Idx
    CALL PrintItem(x, ROOT, LOW, MenuIdx(), MenuItem())
NEXT x

END SUB

'   puts a non-printable character on the screen
'
SUB rPrint (ch%, Fore%, Back%)

DEF SEG = 47104

POKE (160 * (CSRLIN - 1) + 2 * (POS(0) - 1)), ch%
POKE (160 * (CSRLIN - 1) + 2 * (POS(0) - 1) + 1), Back% * 16 + Fore%

DEF SEG = 0

END SUB

'   converts alpha scan code into ASCII
'
FUNCTION ScanCode$ (KeyHit$)

DIM i AS STRING

'   save default value
ScanCode$ = KeyHit$

'   search for new value
IF LEN(KeyHit$) = 2 THEN
    i$ = RIGHT$(KeyHit$, 1)
    IF ASC(i$) > 15 AND ASC(i$) < 51 THEN
        IF MID$(sCode$, ASC(i$) - 15, 1) <> "-" THEN ScanCode$ = MID$(sCode$, ASC(i$) - 15, 1)
    END IF
END IF

END FUNCTION

'   scans the menu for a short cut key
'
FUNCTION ShortKey$ (Idx, ptr, State, KeyHit$, MenuIdx() AS MenuIdxType, MenuItem() AS MenuItemType, Max AS MaxType)
       
DIM x AS INTEGER

'   assign default value
ShortKey = KeyHit$

'   scan for menu index keys
IF State = HIMED OR State = LOMED THEN
    FOR x = 1 TO Max.Idx
        IF LCASE$(KeyHit$) = LCASE$(MID$(MenuIdx(x).Label, MenuIdx(x).ShortKey, 1)) THEN
            Idx = x
            ShortKey = CHR$(13)
            EXIT FOR
        END IF
    NEXT x

'   scan for menu item keys
ELSEIF State = HIGH THEN
    FOR x = MenuIdx(Idx).IdxStart TO MenuIdx(Idx).IdxStart + MenuIdx(Idx).MaxItem - 1
        IF MenuItem(x).ShortKey > 0 THEN
            IF LCASE$(KeyHit$) = LCASE$(MID$(MenuItem(x).Label, MenuItem(x).ShortKey, 1)) THEN
                CALL PrintItem(Idx, ptr, LOMED, MenuIdx(), MenuItem())
                ptr = x
                CALL PrintItem(Idx, ptr, HIMED, MenuIdx(), MenuItem())
                ShortKey = CHR$(13)
                EXIT FOR
            END IF
        END IF
    NEXT x
END IF

END FUNCTION

