                .model  medium, basic
                .386
                .387
                option  proc:private

                include equ.inc
                include 3_d.inc


THREE_D_TEXT    segment word public use16 'CODE'
                assume  cs:THREE_D_TEXT, ds:DGROUP, ss:DGROUP

pi_x_2          real8   6.283185307179586       ;; pi * 2

angle_90        real4   1.570796326794897       ;; 90  * (pi / 180.0)
angle_270       real4   4.71238898038469        ;; 270 *  "  "   "

;;::::::::::::::::::
ArcTan          proc    deltax:word,\
                        deltay:word,\
                        result:near ptr real4

                mov     bx, result              ;; bx ptr to result

                ;; deltax = 0?
                cmp     deltax, 0
                je      @@deltax_zero

                ;; range: -pi to pi (all docs say -pi/2 to pi/2, but...)
                fild    deltay
                fild    deltax
                fpatan                          ;; st= atan(deltay / deltax)

                ;; convert to range: 0 to pi*2
                cmp     deltay, 0
                jge     @@done
                fadd    cs:pi_x_2

@@done:         fstp    D [bx]                  ;; store result
@@exit:         mov     ax, bx                  ;; ax ptr to result (IDE bug)
                ret

@@deltax_zero:  ;; deltay = 0?
                cmp     deltay, 0
                je      @@deltay_zero
                jl      @@deltay_neg
                ;; deltay > 0, so return angle = 90
                mov     eax, cs:angle_90                
                mov     [bx], eax
                jmp     short @@exit

@@deltay_neg:   ;; deltay < 0, so return angle = 270
                mov     eax, cs:angle_270
                mov     [bx], eax
                jmp     short @@exit

@@deltay_zero:  ;; deltay = 0, so return angle = 0
                xor     eax, eax
                mov     [bx], eax
                jmp     short @@exit
ArcTan          endp

;;::::::::::::::::::
Distance2       proc    deltax:word,\
                        deltay:word,\
                        result:near ptr real4
                
                mov     bx, result              ;; bx ptr to result

                fild    deltax
                fimul   deltax                  ;; st= deltax * deltax

                fild    deltay
                fimul   deltay                  ;; st= deltay * deltay

                fadd                            ;; st= (dx * dx) + (dy * dy)

                fsqrt                           ;; st= sqr(st)

                fstp    D [bx]                  ;; store result
                mov     ax, bx                  ;; ax ptr to result (IDE bug)
                ret
Distance2       endp

;;::::::::::::::::::
Distance3       proc    deltax:word,\
                        deltay:word,\
                        deltaz:word,\
                        result:near ptr real4
                
                mov     bx, result              ;; bx ptr to result

                fild    deltax
                fimul   deltax                  ;; st= deltax * deltax

                fild    deltay
                fimul   deltay                  ;; st= deltay * deltay

                fild    deltaz
                fimul   deltaz                  ;; st= deltaz * deltaz

                fadd
                fadd                            ;; st= (dx*dx)+(dy*dy)+(dz*dz)

                fsqrt                           ;; st= sqr(st)

                fstp    D [bx]                  ;; store result
                mov     ax, bx                  ;; ax ptr to result (IDE bug)
                ret
Distance3       endp

;;::::::::::::::::::
TurnOnAngle     proc    uses bx si,
                        deltax:near ptr word,\
                        deltay:near ptr word,\
                        turn_ang:real4
                                             
                mov     bx, deltax              ;; bx ptr to deltax
                mov     si, deltay              ;; si ptr to deltay

                ;; calculate distance
                fild    W [bx]
                fimul   W [bx]                  ;; st= deltax * deltax
                fild    W [si]
                fimul   W [si]                  ;; st= deltay * deltay
                fadd                            ;; st= (dx * dx) + (dy * dy)
                fsqrt                           ;; st= sqr(st)

                ;; calculate arcotangent
                cmp     W [bx], 0               ;; deltax = 0?
                je      @@deltax_zero
                ;; range: -pi to pi
                fild    W [si]
                fild    W [bx]
                fpatan                          ;; st= atan(deltay / deltax)
                ;; convert to range: 0 to pi*2
                cmp     W [si], 0
                jge     @@continue
                fadd    cs:pi_x_2
@@continue:     fadd    turn_ang                ;; angle+= turn_ang

                ;; deltax= cint((cos(angle) * distance)
                fld     st(0)                   ;; duplicate angle
                fcos                            ;; st= cos(angle)
                fmul    st(0), st(2)            ;; st*= distance
                fistp   W [bx]

                ;; deltay= cint((sin(angle) * distance)
                fsin                            ;; st= sin(angle)
                fmul                            ;; st*= distance
                fistp   W [si]

                ret                             ;; that is...

@@deltax_zero:  cmp     W [si], 0
                je      @@deltay_zero
                jl      @@deltay_neg                
                fld     cs:angle_90             ;; deltay > 0, so angle = 90
                jmp     short @@continue

@@deltay_neg:   fld     cs:angle_270            ;; deltay < 0, so angle = 270
                jmp     short @@continue

@@deltay_zero:  fldz                            ;; deltay = 0, so angle = 0
                jmp     short @@continue
TurnOnAngle     endp
THREE_D_TEXT    ends
                end

     x1
     |   deltax
 y1--1----;------+--
     |`\ / angle |                 270
        '\       |                /~|~\
          `\     | deltay     180|- + -|0
   distance `\   |                \_|_/
              `\ |                  90
               -`2--y2
                 |
                 x2
