                .model  medium, basic
                .386
                .387
                option  proc:private

                include equ.inc
                include fjmp.inc
                include bas.inc
                include 3_d.inc
                

.data
z_dsc           BAS_ARRAY <>


THREE_D_TEXT    segment word public use16 'CODE'
                assume  cs:THREE_D_TEXT, ds:DGROUP, ss:DGROUP

;;::::::::::::::::::
ProcessObjects  proc    uses di si es ds,\
                        objects:far ptr OBJECT,\
                        frst_obj:word,\
                        last_obj:word,\
                        viewport:far ptr PERSON

                lds     si, objects             ;; ds:si -> objects array
                les     di, viewport            ;; es:di -> viewport struct
                
                mov     cx, last_obj
                sub     cx, frst_obj
                inc     cx                      ;; loop count= (last-1st)+1

                ;; ptr to 1st object
                mov     ax, frst_obj
                imul    ax, T OBJECT
                add     si, ax                

@@loop:         ;; objects[si].outp.x= cint(objects[si].x - viewport.x)
                fld     ds:[si].OBJECT.x
                fsub    es:[di].PERSON.x
                fistp   ds:[si].OBJECT.outp.x

                ;; objects[si].outp.y= cint(objects[si].y - viewport.y)
                fld     ds:[si].OBJECT.y
                fsub    es:[di].PERSON.y
                fistp   ds:[si].OBJECT.outp.y

                ;; objects[si].outp.z= cint(objects[si].z - viewport.z)
                fld     ds:[si].OBJECT.z
                fsub    es:[di].PERSON.z
                fistp   ds:[si].OBJECT.outp.z

                ;; TurnOnAngle objects[si].outp.x, objects[si].outp.z,\
                ;;             viewport.vertical_ang
                lea     ax, [si].OBJECT.outp.x
                push    ax
                lea     ax, [si].OBJECT.outp.z
                push    ax
                push    D es:[di].PERSON.vertical_ang
                push    cs
                call    N TurnOnAngle
                
                ;; TurnOnAngle objects[si].outp.y, objects[si].outp.z,\
                ;;             viewport.width_ang
                lea     ax, [si].OBJECT.outp.y
                push    ax
                lea     ax, [si].OBJECT.outp.z
                push    ax
                push    D es:[di].PERSON.width_ang
                push    cs
                call    N TurnOnAngle
                
                ;; TurnOnAngle objects[si].outp.x, objects[si].outp.y,\
                ;;             viewport.depth_ang
                lea     ax, [si].OBJECT.outp.x
                push    ax
                lea     ax, [si].OBJECT.outp.y
                push    ax
                push    D es:[di].PERSON.depth_ang
                push    cs
                call    N TurnOnAngle
                
                add     si, T OBJECT            ;; next
                dec     cx
                jnz     @@loop                  ;; any left? loop

                ret
ProcessObjects  endp

const_150       real8   150.0
const_dot1      real8   0.1
const_dot1neg   real8   -0.1
;;::::::::::::::::::
ProcessPerspective proc uses si ds,\
                        pnts_outp:far ptr PNT3DI,\
                        frst_pnt:word,\
                        last_pnt:word

                lds     si, pnts_outp           ;; ds:si -> pnts_outp array

                mov     cx, last_pnt
                sub     cx, frst_pnt
                inc     cx                      ;; loop count= (last-1st)+1

                ;; ptr to 1st point
                mov     ax, frst_pnt
                imul    ax, T PNT3DI
                add     si, ax

@@loop:         ;; z= csng(pnts_outp[si].z) / 150
                fild    ds:[si].PNT3DI.z
                fdiv    cs:const_150

                ;; z < 0?
                ftst
                fnstsw  ax                      ;; ax= status word
                sahf                            ;; set flags
                jb      @@z_neg

                ;; z < .1? z= .1
                fcom    cs:const_dot1           ;; cmp z, .1
                FJGE    @@z_ok
                fstp    st(0)                   ;; pop z
                fld     cs:const_dot1           ;; z= .1
                jmp     short @@z_ok

@@z_neg:        ;; z > -.1? z= -.1
                fcom    cs:const_dot1neg        ;; cmp z, -.1
                FJLE    @@z_ok
                fstp    st(0)                   ;; pop z
                fld     cs:const_dot1neg        ;; z= -.1
                
@@z_ok:         fld     st(0)                   ;; duplicate z

                ;; pnts_outp[si].x= cint(csng(pnts_outp[si].x) / z)
                fidivr  ds:[si].PNT3DI.x
                fistp   ds:[si].PNT3DI.x

                ;; pnts_outp[si].y= cint(csng(pnts_outp[si].y) / z)
                fidivr  ds:[si].PNT3DI.y
                fistp   ds:[si].PNT3DI.y

                add     si, T PNT3DI            ;; next
                dec     cx
                jnz     @@loop                  ;; any left? loop

                ret
ProcessPerspective endp

;;::::::::::::::::::
ProcessPoints   proc    uses di si fs es ds,\
                        points:far ptr POINT,\
                        pnts_outp:far ptr PNT3DI,\
                        objects:far ptr OBJECT,\
                        frst_pnt:word,\
                        last_pnt:word

                lds     si, pnts_outp           ;; ds:si -> pnts_outp array
                les     di, points              ;; es:di -> points array
                mov     fs, W objects+2         ;; fs= objects array seg

                mov     cx, last_pnt
                sub     cx, frst_pnt
                inc     cx                      ;; loop count= (last-1st)+1
                
                ;; ptr to 1st point
                mov     ax, frst_pnt
                imul    ax, T PNT3DI
                add     si, ax

                ;; ptr to 1st point
                mov     ax, frst_pnt
                imul    ax, T POINT
                add     di, ax

@@loop:         ;; pnts_outp[si].x= cint(points[di].x)
                fld     es:[di].POINT.x
                fistp   ds:[si].PNT3DI.x

                ;; pnts_outp[si].y= cint(points[di].y)
                fld     es:[di].POINT.y
                fistp   ds:[si].PNT3DI.y

                ;; pnts_outp[si].z= cint(points[di].z)
                fld     es:[di].POINT.z
                fistp   ds:[si].PNT3DI.z

                ;; bx -> objects[points[di].obj]
                mov     bx, es:[di].POINT.obj
                imul    bx, T OBJECT
                add     bx, W objects

                ;; TurnOnAngle pnts_outp[si].x, pnts_outp[si].z,\
                ;;             objects[bx].vertical_ang
                lea     ax, [si].PNT3DI.x
                push    ax
                lea     ax, [si].PNT3DI.z
                push    ax
                push    D fs:[bx].OBJECT.vertical_ang
                push    cs
                call    N TurnOnAngle

                ;; TurnOnAngle pnts_outp[si].y, pnts_outp[si].z,\
                ;;             objects[bx].width_ang
                lea     ax, [si].PNT3DI.y
                push    ax
                lea     ax, [si].PNT3DI.z
                push    ax
                push    D fs:[bx].OBJECT.width_ang
                push    cs
                call    N TurnOnAngle

                ;; TurnOnAngle pnts_outp[si].x, pnts_outp[si].y,\
                ;;             objects[bx].depth_ang
                lea     ax, [si].PNT3DI.x
                push    ax  
                lea     ax, [si].PNT3DI.y
                push    ax
                push    D fs:[bx].OBJECT.depth_ang
                push    cs
                call    N TurnOnAngle

                add     si, T PNT3DI            ;; next
                add     di, T POINT             ;;  "
                dec     cx
                jnz     @@loop                  ;; any left? loop

                ret
ProcessPoints   endp

;;::::::::::::::::::
ProcessPolygons proc    uses di si gs fs es ds,\
                        points:far ptr POINT,\
                        polygon_s:far ptr POLYPNT,\
                        objects:far ptr OBJECT,\
                        frst_pnt:word,\
                        last_pnt:word,\
                        viewport:far ptr PERSON

                lds     si, polygon_s           ;; ds:si -> polygon_s array
                mov     es, W points+2          ;; es= points array seg
                mov     fs, W objects+2         ;; fs= objects array seg
                lgs     di, viewport            ;; gs:di -> viewport struct

                mov     cx, last_pnt
                sub     cx, frst_pnt
                inc     cx                      ;; loop count= (last-1st)+1
                
                ;; ptr to 1st point
                mov     ax, frst_pnt
                imul    ax, T POLYPNT
                add     si, ax

@@loop:         ;; polygon_s[si].outp.x= cint(polygon_s[si].x)
                fld     ds:[si].POLYPNT.x
                fistp   ds:[si].POLYPNT.outp.x

                ;; polygon_s[si].outp.y= cint(polygon_s[si].y)
                fld     ds:[si].POLYPNT.y
                fistp   ds:[si].POLYPNT.outp.y

                ;; polygon_s[si].outp.z= cint(polygon_s[si].z)
                fld     ds:[si].POLYPNT.z
                fistp   ds:[si].POLYPNT.outp.z

                ;; bx -> objects[points[polygon_s[si].ppoint].obj]
                mov     bx, ds:[si].POLYPNT.ppoint
                imul    bx, T POINT
                add     bx, W points

                mov     bx, es:[bx].POINT.obj
                imul    bx, T OBJECT
                add     bx, W objects

                ;; TurnOnAngle polygon_s[si].outp.x, polygon_s[si].outp.z,\
                ;;             objects[bx].vertical_ang
                lea     ax, [si].POLYPNT.outp.x
                push    ax
                lea     ax, [si].POLYPNT.outp.z
                push    ax
                push    D fs:[bx].OBJECT.vertical_ang
                push    cs
                call    N TurnOnAngle

                ;; TurnOnAngle polygon_s[si].outp.y, polygon_s[si].outp.z,\
                ;;             objects[bx].width_ang
                lea     ax, [si].POLYPNT.outp.y
                push    ax
                lea     ax, [si].POLYPNT.outp.z
                push    ax
                push    D fs:[bx].OBJECT.width_ang
                push    cs
                call    N TurnOnAngle

                ;; TurnOnAngle polygon_s[si].outp.x, polygon_s[si].outp.y,\
                ;;             objects[bx].depth_ang
                lea     ax, [si].POLYPNT.outp.x
                push    ax  
                lea     ax, [si].POLYPNT.outp.y
                push    ax
                push    D fs:[bx].OBJECT.depth_ang
                push    cs
                call    N TurnOnAngle

                ;; TurnOnAngle polygon_s[si].outp.x, polygon_s[si].outp.z,\
                ;;             viewport.vertical_ang
                lea     ax, [si].POLYPNT.outp.x
                push    ax
                lea     ax, [si].POLYPNT.outp.z
                push    ax
                push    D gs:[di].PERSON.vertical_ang
                push    cs
                call    N TurnOnAngle
                
                ;; TurnOnAngle polygon_s[si].outp.y, polygon_s[si].outp.z,\
                ;;             viewport.width_ang
                lea     ax, [si].POLYPNT.outp.y
                push    ax
                lea     ax, [si].POLYPNT.outp.z
                push    ax
                push    D gs:[di].PERSON.width_ang
                push    cs
                call    N TurnOnAngle
                
                ;; TurnOnAngle polygon_s[si].outp.x, polygon_s[si].outp.y,\
                ;;             viewport.depth_ang
                lea     ax, [si].POLYPNT.outp.x
                push    ax
                lea     ax, [si].POLYPNT.outp.y
                push    ax
                push    D gs:[di].PERSON.depth_ang
                push    cs
                call    N TurnOnAngle

                ;; polygon_s[si].outp.x += objects[bx].outp.x
                mov     ax, fs:[bx].OBJECT.outp.x
                add     ds:[si].POLYPNT.outp.x, ax

                ;; polygon_s[si].outp.y += objects[bx].outp.y
                mov     ax, fs:[bx].OBJECT.outp.y
                add     ds:[si].POLYPNT.outp.y, ax

                ;; polygon_s[si].outp.z += objects[bx].outp.z
                mov     ax, fs:[bx].OBJECT.outp.z
                add     ds:[si].POLYPNT.outp.z, ax

                add     si, T POLYPNT           ;; next
                dec     cx
                jnz     @@loop                  ;; any left? loop

                ret
ProcessPolygons endp

ubound          word    ?
;;::::::::::::::::::
ProcessSort     proc    uses di si fs es,\
                        polygon_s_dsc:near ptr BAS_ARRAY,\
                        min_distance:real4,\
                        draw_order:far ptr word
                
                push    ds                      ;; (0)

                ;; get polygon_s array upper bound
                invoke  B$UBND, polygon_s_dsc, 1
                mov     cs:ubound, ax           ;; save

                ;; alloc z array
                invoke  B$RDIM, 0, ax, T real4, 101h, O z_dsc
                
                lfs     bx, z_dsc.BAS_ARRAY.fptr;; fs:bx -> z array
                les     di, draw_order          ;; es:di -> draw_order array
                mov     si, polygon_s_dsc
                lds     si, [si].BAS_ARRAY.fptr ;; ds:si -> polygon_s array
                
                PS      bx, di                  ;; (1)

                fld     min_distance            ;; pre-load min_distance

                mov     dx, 0                   ;; poly= 0
                mov     cx, cs:ubound
                inc     cx                      ;; loop count= num of pnts

@@loop:         ;; calculate the distance
                fild    ds:[si].POLYPNT.outp.x
                fimul   ds:[si].POLYPNT.outp.x  ;; st= deltax * deltax
                fild    ds:[si].POLYPNT.outp.y
                fimul   ds:[si].POLYPNT.outp.y  ;; st= deltay * deltay
                fild    ds:[si].POLYPNT.outp.z
                fimul   ds:[si].POLYPNT.outp.z  ;; st= deltaz * deltaz
                fadd
                fadd                            ;; st= (dx*dx)+(dy*dy)+(dz*dz)
                fsqrt                           ;; st= sqr(st)
                ;; z[bx]= distance3(polygon_s[si].outp.x,\
                ;;        polygon_s[si].outp.y, polygon_s[si].outp.z)
                fstp    R fs:[bx]
                
                mov     es:[di], dx             ;; draw_order[di]= poly
                ;; min_distance >= csng(polygon_s[si].outp.z)? don't draw
                ficom   ds:[si].POLYPNT.outp.z
                FJL     @@next
                mov     W es:[di], -1           ;; draw_order[di]= -1
                
@@next:         add     si, T POLYPNT           ;; next
                add     di, T word              ;;  "
                add     bx, T real4             ;;  "
                inc     dx                      ;; ++poly
                dec     cx
                jnz     @@loop                  ;; any left? loop

                fstp    st(0)                   ;; free tos (min_distance)

                ;; sort z array
                mov     ax, fs
                mov     ds, ax                  ;; ds= fs= z array seg
                PP      di, si                  ;; (1)
                and     edi, 00000FFFFh         ;; es:edi -> draw_order array
                and     esi, 00000FFFFh         ;; ds:esi -> z array

                xor     ebx, ebx                ;; left= 0
                xor     ecx, ecx
                mov     cx, cs:ubound           ;; right= upper bound

                push    O @@exit                ;; last return

@@quick_sort:   ;;  in: es:edi -> to draw_order array
                ;;      ds:esi -> z array
                ;;      ebx= 0:left 
                ;;      ecx= 0:right

                push    cx                      ;; (1) save right
                push    bx                      ;; (2) and left

                lea     eax, [ebx + ecx]
                shr     ax, 1
                fld     R ds:[esi + eax * 4]    ;; m= z[(left + right) / 2]

                jmp     short @@test_i
@@loop_i:       inc     bx                      ;; ++i
@@test_i:       fcom    R ds:[esi + ebx * 4]
                FJL     @@loop_i                ;; m < z[i]?
                                
                jmp     short @@test_j
@@loop_j:       dec     cx                      ;; --j
@@test_j:       fcom    R ds:[esi + ecx * 4]
                FJG     @@loop_j                ;; m > z[j]?

                cmp     bx, cx
                jg      @@test                  ;; i > j?
                      
                ;; z[i] <-> z[j]
                mov     eax, ds:[esi + ebx * 4]
                mov     edx, ds:[esi + ecx * 4]
                mov     ds:[esi + ecx * 4], eax
                mov     ds:[esi + ebx * 4], edx
                
                ;; draw_order[i] <-> draw_order[j]
                mov     ax, es:[edi + ebx * 2]
                mov     dx, es:[edi + ecx * 2]
                mov     es:[edi + ecx * 2], ax
                mov     es:[edi + ebx * 2], dx

                inc     bx                      ;; ++i
                dec     cx                      ;; --j
                cmp     bx, cx
                jle     @@test_i                ;; i <= j? loop

@@test:         fstp    st(0)                   ;; free tos (m)

                pop     ax                      ;; (2)
                cmp     cx, ax
                jle     @@test_rg               ;; j <= left?
                push    bx                      ;; save i
                mov     bx, ax
                push    O @F
                jmp     short @@quick_sort      ;; quick_sort(left, j)
@@:             pop     bx                      ;; restore i

@@test_rg:      pop     ax                      ;; (1)
                cmp     bx, ax
                jge     @@done                  ;; i >= right?                
                mov     cx, ax
                ;; no need to return
                jmp     short @@quick_sort      ;; quick_sort(i, right) 

@@done:         retn

@@exit:         pop     ds                      ;; (0)

                invoke  B$ERAS, O z_dsc         ;; erase z array

                ret
ProcessSort     endp

objs_ofs        word    ?
;;::::::::::::::::::
ProcessViewport proc    uses di si gs fs es ds,\
                        points:far ptr POINT,\
                        pnts_outp:far ptr PNT3DI,\
                        objects:far ptr OBJECT,\
                        frst_pnt:word,\
                        last_pnt:word,\
                        viewport:far ptr PERSON

                lds     si, pnts_outp           ;; ds:si -> pnts_outp array
                les     di, points              ;; es:di -> points array
                mov     fs, W objects+2         ;; fs= objects array seg

                mov     cx, last_pnt
                sub     cx, frst_pnt
                inc     cx                      ;; loop count= (last-1st)+1
                
                ;; ptr to 1st point
                mov     ax, frst_pnt
                imul    ax, T PNT3DI
                add     si, ax

                ;; ptr to 1st point
                mov     ax, frst_pnt
                imul    ax, T POINT
                add     di, ax

                ;; make a copy in cs (bp will be destroyed)
                mov     ax, W objects
                mov     cs:objs_ofs, ax

                push    bp                      ;; (0)
                lgs     bp, viewport            ;; gs:bp -> viewport struct

@@loop:         ;; TurnOnAngle pnts_outp[si].x, pnts_outp[si].z,\
                ;;             viewport.vertical_ang
                lea     ax, [si].PNT3DI.x
                push    ax
                lea     ax, [si].PNT3DI.z
                push    ax
                push    D gs:[bp].PERSON.vertical_ang
                push    cs
                call    N TurnOnAngle

                ;; TurnOnAngle pnts_outp[si].outp.y, pnts_outp[si].outp.z,\
                ;;             viewport.width_ang
                lea     ax, [si].PNT3DI.y
                push    ax
                lea     ax, [si].PNT3DI.z
                push    ax
                push    D gs:[bp].PERSON.width_ang
                push    cs
                call    N TurnOnAngle

                ;; TurnOnAngle pnts_outp[si].outp.x, pnts_outp[si].outp.y,\
                ;;             viewport.depth_ang
                lea     ax, [si].PNT3DI.x
                push    ax  
                lea     ax, [si].PNT3DI.y
                push    ax
                push    D gs:[bp].PERSON.depth_ang
                push    cs
                call    N TurnOnAngle

                ;; bx -> objects[points[di].obj]
                mov     bx, es:[di].POINT.obj
                imul    bx, T OBJECT
                add     bx, cs:objs_ofs

                ;; pnts_outp[si].x += objects[bx].outp.x
                mov     ax, fs:[bx].OBJECT.outp.x
                add     ds:[si].PNT3DI.x, ax

                ;; pnts_outp[si].y += objects[bx].outp.y
                mov     ax, fs:[bx].OBJECT.outp.y
                add     ds:[si].PNT3DI.y, ax

                ;; pnts_outp[si].z += objects[bx].outp.z
                mov     ax, fs:[bx].OBJECT.outp.z
                add     ds:[si].PNT3DI.z, ax

                add     si, T PNT3DI            ;; next
                add     di, T POINT             ;;  "
                dec     cx
                jnz     @@loop                  ;; any left? loop

                pop     bp                      ;; (0)

                ret
ProcessViewport endp

                db      0,' 3*D-lib v1E-32a ',0 ;; signature ;)
THREE_D_TEXT    ends
                end

------------------------------------------------------------
bubblesort...
                PP      di, bx                  ;; (1)

                mov     dx, cs:ubound
                dec     dx                      ;; max= ubound(polygon_s[])-1
                
@@loop_sort:    mov     si, -1                  ;; flag= -1
                                
                PS      bx, di

                xor     cx, cx                  ;; c= 0
                                
@@loop_2:       fld     R fs:[bx]
                fcomp   R fs:[bx + T real4]
                FJGE    @@test                  ;; z[c] >= z[c+1]?

                mov     si, cx                  ;; flag= c

                ;; z[c] <-> z[c+1]
                push    R fs:[bx]
                mov     eax, fs:[bx + T real4]
                mov     fs:[bx], eax
                pop     R fs:[bx + T real4]
                
                ;; draw_order[c] <-> draw_order[c+1]
                push    W es:[di]
                mov     ax, es:[di + T word]
                mov     es:[di], ax
                pop     W es:[di + T word]

@@test:         add     di, T word              ;; next
                add     bx, T real4             ;;  "
                inc     cx
                cmp     cx, dx
                jle     @@loop_2                ;; c <= max? loop

                PP      di, bx

                mov     dx, si
                dec     dx                      ;; max= flag - 1

                cmp     si, -1
                jne     @@loop_sort             ;; flag= -1?
------------------------------------------------------------
