;;                          ____            ____
;;                         /~~~~\          \~~~~\
;;                         `\/~~>)   \|/    )/~~.)
;;                            <(    - o -   ||  ||
;;                         ./\__>)   /|\    )|__')
;;                         \____/   _ _ _  /____/
;;                          ~~~~    L I B   ~~~~                     
;;                                  ~ ~ ~
;;                              version 1E-32a
;;                            (c) 2000 by Badjas
;;
;;    assembly version copyleft Apr/2000 by v1ctor [av1ctor@yahoo.com.br]
;;

                ;; structs :::::
PNT3D           struct
                x               real4   ?
                y               real4   ?
                z               real4   ?
PNT3D           ends

PNT3DI          struct
                x               word    ?
                y               word    ?
                z               word    ?
PNT3DI          ends

COLCOMP         struct
                r               word    ?
                g               word    ?
                b               word    ?
COLCOMP         ends

POINT           struct
                                PNT3D   <>
                obj             word    ?       ;; <-- 2 ptr
POINT           ends

OBJECT          struct
                vertical_ang    real4   ?
                width_ang       real4   ?
                depth_ang       real4   ?
                                PNT3D   <>                
                outp            PNT3DI  <>
                outp_depth_ang  real4   ?
OBJECT          ends

LIGHT           struct
                                PNT3D   <>
                                COLCOMP <>
                strength        word    ?
LIGHT           ends

POLYPNT         struct
                ppoint          word    ?       ;; <-- 2 ptr
                                PNT3D   <>
                distance        real4   ?
                outp            PNT3DI  <>
                                COLCOMP <>
                next_point      word    ?       ;; <-- 2 ptr
                shiny_surface   word    ?
POLYPNT         ends

POLYNPNT        struct
                ppoint          word    ?       ;; <-- 2 ptr
                distance        real4   ?
                                COLCOMP <>
                next_point      word    ?       ;; <-- 2 ptr
POLYNPNT        ends
                
PERSON          struct
                                PNT3D   <>
                vertical_ang    real4   ?
                width_ang       real4   ?
                depth_ang       real4   ?
PERSON          ends


                ;; globals :::::

                ;; from math.asm:
                ;; ArcTan!     (byval deltax as integer,_
                ;;              byval deltay as integer)
                ArcTan          proto, :word, :word, :near ptr real4

                ;; Distance2!  (byval deltax as integer,_
                ;;              byval deltay as integer)
                Distance2       proto, :word, :word, :near ptr real4

                ;; Distance3!  (byval deltax as integer,_
                ;;              byval deltay as integer,_
                ;;              byval deltaz as integer)
                Distance3       proto, :word, :word, :word, :near ptr real4

                ;; TurnOnAngle (deltax as integer,_
                ;;              deltay as integer,_
                ;;              byval turnAngle as single)
                TurnOnAngle     proto, :near ptr word, :near ptr word, :real4
                
                ;; from process.asm:
                ;; ProcessObjects (seg objects as ObjectType,_
                ;;                 byval frstObj as integer,_
                ;;                 byval lastObj as integer,_
                ;;                 seg viewport as Person)
                ProcessObjects  proto, :far ptr OBJECT, :word, :word,\
                                       :far ptr PERSON

                ;; ProcessPerspective (seg pntsOutp as LoosePointType,_
                ;;                     byval frstPnt as integer,_
                ;;                     byval lastPnt as integer)
                ProcessPerspective proto, :far ptr PNT3DI, :word, :word

                ;; ProcessPoints (seg points as PointType,_
                ;;                seg pntsOutp as LoosePointType,_
                ;;                seg objects as ObjectType,_
                ;;                byval frstPnt as integer,_
                ;;                byval lastPnt as integer)
                ProcessPoints   proto, :far ptr POINT, :far ptr PNT3DI,\
                                       :far ptr OBJECT, :word, :word

                ;; ProcessPolygons (seg points as PointType,_
                ;;                  seg polygonS as PolygonPointType,_
                ;;                  seg objects as ObjectType,_
                ;;                  byval frstPnt as integer,_
                ;;                  byval lastPnt as integer,_
                ;;                  seg viewport as Person)
                ProcessPolygons proto, :far ptr POINT, :far ptr POLYPNT,\
                                       :far ptr OBJECT, :word, :word,\
                                       :far ptr PERSON

                ;; ProcessSort  (polygonS() as PolygonPointType,_
                ;;               byval minDistance as single,_
                ;;               seg drawOrder as integer)
                ProcessSort     proto, :near ptr BAS_ARRAY, :real4,\
                                       :far ptr word

                ;; ProcessViewport (seg points as PointType,_
                ;;                  seg pntsOutp as LoosePointType,_
                ;;                  seg objects as ObjectType,_
                ;;                  byval frstPnt as integer,_
                ;;                  byval lastPnt as integer,_
                ;;                  seg viewport as Person)
                ProcessViewport proto, :far ptr POINT, :far ptr PNT3DI,\
                                       :far ptr OBJECT, :word, :word,\
                                       :far ptr PERSON
