TYPE WHEELSTATE
    O As STRING * 4 '' Outside ring
    I As STRING * 4 '' Inside ring
    B As STRING * 1 '' Center segment
END TYPE

DECLARE FUNCTION Modify(Wheel As WHEELSTATE,Action As Integer)
DECLARE FUNCTION StrWheel$(Wheel As WHEELSTATE)
DECLARE FUNCTION Puzzle(Goal As WHEELSTATE,Limit As Integer)
DECLARE SUB TextWheel(Wheel As WHEELSTATE,ROW,COL)
DECLARE SUB Default(Wheel As WHEELSTATE)
DECLARE SUB Piece(X,Y,V,S As Double)
DECLARE SUB DrawWheel(X,Y,Wheel As WHEELSTATE,AN,S As Double)
DECLARE SUB Block(X,Y,S,C)
DECLARE SUB Done(WinLose)
DECLARE SUB RandomPuzzle(OutWheel As WHEELSTATE,D As Integer,PuzzID As Long)

SCREEN 12,,2
SCREENSET 1,0
DIM G As WHEELSTATE
DIM H As Integer
DIM S(21)
DO
MM:
default G
Open "DATA.INI" For Input As #1
Input #1,H
Close #1
Open "BONUS.INI" For Input As #1
FOR A = 1 TO 21
    Input #1, S(A)
NEXT A
Close #1
Locate 6,9  :Print "MAIN MENU SCREEN"
Locate 8,12 :Print "[H] UNDRED PUZZLE CONQUEST  (";H-1;" / 100 )"
IF H = 101 THEN
    Locate 8,11:PRINT "*"
    Locate 22,12:PRINT "[F] EWEST MOVE CHALLENGE"
END IF
Locate 10,12:Print "[R] ANDOM PUZZLE"
Locate 12,12:Print "[I] NFORMATION"
Locate 14,12:Print "[B] ASIC INSTRUCTIONS"
Locate 16,12:Print "[L] OAD PUZZLE CODE"
Locate 20,12:Print "[E] XIT PROGRAM"
Locate 18,12:Print "[D] ELETE CONQUEST DATA"
Locate 24,1:Print "Press the bracketed letter to access that selection."
BLOAD "title.bmp",0
PCOPY 1,0
280 DO:LOOP WHILE INKEY$ <> ""
BP: DO
        Key$ = Inkey$
    LOOP WHILE Key$ = ""
SELECT CASE UCase$(Key$)
CASE "F"
    IF H = 101 THEN
        CLS
        BLOAD "title.bmp",0
        LOCATE 6,9:PRINT "SELECT A PUZZLE A-U AND BEAT THE SCORE (FINNISH PUZZLE IN FEWEST MOVES)"
        FOR A = 8 TO 28
            LOCATE A,12:PRINT "[";CHR$(A-8+65);"] ";S(A-7)
            IF S(A-7) = 1000000 THEN LOCATE A,17:PRINT "NO RECORD"
        NEXT A
        Locate 29,12:Print "[Q] UIT FEWEST MOVE MODE"
        PCOPY 1,0:CLS
        DO
            Key$ = Inkey$
        LOOP WHILE Key$ = "":Key$=UCASE$(Key$)
        O = ASC(Key$)
        IF Key$ <> "Q" AND O>64 AND O<86 THEN
            randompuzzle g,1000,O^2/3-666
            W = puzzle(g,S(O)-64)
            IF W >=1 THEN
                done 1
                pcopy 1,0:cls
                sleep
                S(O-64)=W
                OPEN "BONUS.INI" FOR OUTPUT AS #1
                FOR A = 1 TO 21
                    WRITE #1,S(A)
                NEXT A
                CLOSE #1
            ELSE
                done 0
                pcopy 1,0:cls
                sleep
            END IF
        END IF
    END IF
CASE "L"
    CLS
    SCREENSET 1,1
    BLOAD "title.bmp",0
    PRINT:PRINT:PRINT:PRINT:PRINT:PRINT
    PRINT "WARNING: Incorrect code may cause problems with"
    PRINT "         the puzzle. Please enter carefully and"
    PRINT "         without commas."
    PRINT
    INPUT "PUZZLE CODE: ",PC$
    SCREENSET 1,0:CLS
    G.O = MID$(PC$,1,4)
    G.I = MID$(PC$,5,4)
    G.B = MID$(PC$,9,4)
    IF Puzzle(g,0)>=1 THEN
        done 1
        pcopy 1,0
        cls
        sleep
    ELSE
        done 0
        pcopy 1,0
        cls
        sleep
    END IF
CASE "B"
    CLS
    BLOAD "title.bmp",0
    Locate 6,9: Print "BASIC INSTRUCTIONS"
    Locate 8,12:Print "The object of the game is to arrange the enigma wheel"
    Locate 9,12:Print "so that it matches the 'Goal Wheel' in the top right"
    Locate 10,12:Print "corner. Use the arrow keys to swap the position of the"
    Locate 11,12:Print "empty area (black square) in a designated direction."
    Locate 12,12:Print "The outer orbit can be rotated clockwise or counter"
    Locate 13,12:Print "clockwise using 'Z' and 'X'. If you  find this confusing,"
    Locate 14,12:Print "after returning to the main menu, try a random puzzle"
    Locate 15,12:Print "to familiarize yourself with the controls. The Hundred"
    Locate 16,12:Print "Puzzle Conquest is a set of 100 puzzles that increase"
    Locate 17,12:Print "in dificulty every 10 puzzles. Beat them all for a"
    Locate 18,12:Print "surprise unlockable. Use the load puzzle command to load"
    Locate 19,12:Print "a puzzle; to load a previous random puzzle, enter the"
    Locate 20,12:Print "code displayed below the 'Goal Wheel. Press any key to"
    Locate 21,12:Print "continue..."
    Pcopy 1,0:CLS
    Sleep
CASE "I"
    CLS
    BLOAD "title.bmp",0
    Locate 6,9: Print "INFORMATION"
    Locate 8,12:Print "This puzzle was designed on July 30, 2005 and the original"
    Locate 9,12:Print "design belongs to J.P.C. MMV. If you find any bugs, errors"
    Locate 10,12:Print "or have suggestions, please e-mail me at GizmoGuy32@sbcglobal.net."
    Locate 11,12:Print "I hope this puzzles brings you hours of frustration and/or"
    Locate 12,12:Print "enjoyment. I hope to later add puzzle solutions along with"
    Locate 13,12:Print "game saves and a fewest-move challenge. Read enigma.pdf for "
    Locate 14,12:Print "more information. Press any key to continue..."
    Locate 20,9:Print "-Jimmy"
    Pcopy 1,0:CLS
    Sleep
CASE "E"
    END
CASE "D"
    Locate 24,1:Print SPACE$(80)
    Locate 24,1:Print "Are you sure you want to do this? Press 'Y' to delete..."
    PCOPY 1,0:CLS
    H = 1
    DO
        Key$ = Inkey$
    LOOP WHILE Key$ = ""
    IF Ucase$(Key$) = "Y" THEN
        Open "DATA.INI" For Output As #1
        Open "BONUS.INI" FOR Output As #2
        Print #1,H
        FOR A = 1 To 21
            Print #2,1000000
        NEXT A
        Close
    END IF
CASE "H"
    IF H<101 THEN
        PCOPY 1,0:CLS
        randompuzzle g,INT(H/10+1)*10,H^2/(H-2)
        IF puzzle(g,0)<=0 THEN
            done 0
        ELSE
            done 1
            H = H + 1
            Open "DATA.INI" For Output As #1
            Print #1,H
            Close #1
            Locate 10,45:Print "You have completed";H-1;" out of 100"
            Locate 11,45:Print "of the conquest puzzles. Keep up the"
            Locate 12,45:Print "good work."
        END IF
        pcopy 1,0:cls
        sleep
    END IF
CASE "R"
    CLS
    BLOAD "title.bmp",0
    Locate 10,12:Print "RANDOM PUZZLE"
    Locate 13,14:Print "[A] EASY"
    Locate 15,14:Print "[B] MEDIUM"
    Locate 17,14:Print "[C] HARD"
    Locate 19,14:Print "[D] EXTRA HARD"
    PCOPY 1,0:CLS
480 DO
        Key$ = Inkey$
    LOOP WHILE Key$ = ""
    SELECT CASE UCASE$(Key$)
    CASE "A"
        D = 15
    CASE "B"
        D = 30
    CASE "C"
        D = 50
    CASE "D"
        D = 70
    CASE ELSE
        GOTO 480
    END SELECT
    randompuzzle g,d,timer
    IF puzzle(g,0)<=0 THEN
        done 0
    ELSE
        done 1
    END IF
    pcopy 1,0:cls
    sleep
END SELECT
LOOP

'' The function will attempt to modify the current wheel
'' and will return a 1 if the action was succesful and a
'' 0 if the action was unseccful.
FUNCTION Puzzle(Goal As WHEELSTATE,Limit As Integer)
    DIM Game As WHEELSTATE
    DIM Moves As Integer
    DIM Key As String
    CONST SWAPOVER = 0 '' Constant for swapping up
    CONST SWAPDOWN = 1 '' Constant for swapping down
    CONST SWAPWEST = 2 '' Constant for swapping left
    CONST SWAPEAST = 3 '' Constant for swapping right
    CONST WESTEAST = 4 '' Constant for rotating clockwise
    CONST EASTWEST = 5 '' Constant for roaring counter-clockwise
    CONST ESC = Chr$(27)
    CONST LEFTARROW = Chr$(255) + Chr$(75)
    CONST UPARROW = Chr$(255) + Chr$(72)
    CONST RIGHTARROW = Chr$(255) + Chr$(77)
    CONST DOWNARROW = Chr$(255) + Chr$(80)
    default Game
    If Limit = 0 Then Limit = -1
    CLS
    DO
DF:     drawwheel 320,240,game,0,1.8
        drawwheel 585,55,goal,0,.5
        Locate 9,69:Print StrWheel$(goal)
        BLOAD "tiny.bmp",0
        PCOPY 1,0:CLS
GK:     DO
            Key = Inkey$
        LOOP WHILE Key = ""
        SELECT CASE UCase$(Key)
        CASE ESC
            Puzzle = -(Moves)
            Exit Function
        CASE LEFTARROW
            IF modify(game,SWAPWEST) <> 1 THEN GOTO GK
        CASE RIGHTARROW
            IF modify(game,SWAPEAST) <> 1 THEN GOTO GK
        CASE UPARROW
            IF modify(game,SWAPOVER) <> 1 THEN GOTO GK
        CASE DOWNARROW
            IF modify(game,SWAPDOWN) <> 1 THEN GOTO GK
        CASE "X"
            CALL modify(game,eastwest)
            FOR A = 5 TO 85 STEP 5
                drawwheel 585,55,goal,0,.5#
                drawwheel 320,240,game,-90+A,1.8
                Locate 9,69:Print StrWheel$(goal)
                BLOAD "tiny.bmp",0
                PCOPY 1,0:CLS
                sleep 10
            NEXT A
        CASE "Z"
            CALL modify(game,westeast)
            FOR A = 85 TO 5 STEP -5
                drawwheel 585,55,goal,0,.5#
                drawwheel 320,240,game,A,1.8
                Locate 9,69:Print StrWheel$(goal)
                BLOAD "tiny.bmp",0
                PCOPY 1,0:CLS
                sleep 10
            NEXT A
        END SELECT
        MOVES = MOVES + 1
        IF game.i=goal.i AND game.o=goal.o AND game.b=goal.b THEN
            drawwheel 480,240,game,0,1
            EXIT DO
        ELSEIF MOVES >= LIMIT AND NOT(MOVES>0) THEN
            drawwheel 480,240,game,0,1
            MOVES = -(MOVES)
            EXIT DO
        END IF
    LOOP
    Puzzle = Moves
END FUNCTION

FUNCTION Modify(Wheel As WHEELSTATE,Action As Integer)
    SELECT CASE Action
    CASE 0
        IF Wheel.B[0]=48 THEN
            Wheel.B=Wheel.I[0]
            Wheel.I[0]=48
            Modify=1
        ELSEIF Wheel.I[0]=48 THEN
            Wheel.I[0]=Wheel.O[0]
            Wheel.O[0]=48
            Modify=1
        ELSEIF Wheel.O[2]=48 THEN
            Wheel.O[2]=Wheel.I[2]
            Wheel.I[2]=48
            Modify=1
        ELSEIF Wheel.I[2]=48 THEN
            Wheel.I[2]=Wheel.B[0]
            Wheel.B[0]=48
            Modify=1
        ELSE
            Modify=0
        END IF
    CASE 1
        IF Wheel.B[0]=48 THEN
            Wheel.B=Wheel.I[2]
            Wheel.I[2]=48
            Modify=1
        ELSEIF Wheel.I[2]=48 THEN
            Wheel.I[2]=Wheel.O[2]
            Wheel.O[2]=48
            Modify=1
        ELSEIF Wheel.O[0]=48 THEN
            Wheel.O[0]=Wheel.I[0]
            Wheel.I[0]=48
            Modify=1
        ELSEIF Wheel.I[0]=48 THEN
            Wheel.I[0]=Wheel.B[0]
            Wheel.B[0]=48
            Modify=1
        ELSE
            Modify=0
        END IF
    CASE 2
        IF Wheel.B[0]=48 THEN
            Wheel.B=Wheel.I[3]
            Wheel.I[3]=48
            Modify=1
        ELSEIF Wheel.I[3]=48 THEN
            Wheel.I[3]=Wheel.O[3]
            Wheel.O[3]=48
            Modify=1
        ELSEIF Wheel.O[1]=48 THEN
            Wheel.O[1]=Wheel.I[1]
            Wheel.I[1]=48
            Modify=1
        ELSEIF Wheel.I[1]=48 THEN
            Wheel.I[1]=Wheel.B[0]
            Wheel.B[0]=48
            Modify=1
        ELSE
            Modify=0
        END IF
    CASE 3
        IF Wheel.B[0]=48 THEN
            Wheel.B=Wheel.I[1]
            Wheel.I[1]=48
            Modify=1
        ELSEIF Wheel.I[1]=48 THEN
            Wheel.I[1]=Wheel.O[1]
            Wheel.O[1]=48
            Modify=1
        ELSEIF Wheel.O[3]=48 THEN
            Wheel.O[3]=Wheel.I[3]
            Wheel.I[3]=48
            Modify=1
        ELSEIF Wheel.I[3]=48 THEN
            Wheel.I[3]=Wheel.B[0]
            Wheel.B[0]=48
            Modify=1
        ELSE
            Modify=0
        END IF
    CASE 4
        Wheel.O=CHR$(Wheel.O[1])+CHR$(Wheel.O[2])+CHR$(Wheel.O[3])+CHR$(Wheel.O[0])
        Modify=1
        EXIT FUNCTION
    CASE 5
        Wheel.O=CHR$(Wheel.O[3])+CHR$(Wheel.O[0])+CHR$(Wheel.O[1])+CHR$(Wheel.O[2])
        Modify=1
        EXIT FUNCTION
    CASE ELSE
        Modify=0
        EXIT FUNCTION
    END SELECT
END FUNCTION

'' This subroutine will scramble a puzzle by performing
'' a user-determined number (D,Depth) of random moves.
SUB RandomPuzzle(OutWheel As WHEELSTATE,D As Integer,PuzzID As Long)
    Randomize (-1)
    IF PuzzID <> 0 THEN
        Randomize PuzzID
    ELSE
        Randomize Timer
    End If
    DIM P As Integer
    DIM N As Integer
    DIM C AS Integer
    DO WHILE C<D
    A:  N = Int(Rnd*5+1)-1
    '' Make sure this move will not negate the previous.
        IF (Abs(N-P)=1 AND P+N<>9 AND P+N<>1) OR N=P THEN
            GOTO A
        END IF
        IF Modify(OutWheel,N)=0 THEN
            GOTO A
        ELSE
            C = C + 1
        END IF
    LOOP
END SUB

'' This routine will display the wheel as a simple text
'' cross.
SUB TextWheel(Wheel As WHEELSTATE,ROW,COL)
    ROW = ROW - 1: COL = COL - 1
    Locate 1+ROW,3+COL:PRINT Chr$(Wheel.O[0])
    Locate 3+ROW,5+COL:PRINT Chr$(Wheel.O[1])
    Locate 5+ROW,3+COL:PRINT Chr$(Wheel.O[2])
    Locate 3+ROW,1+COL:PRINT Chr$(Wheel.O[3])
    Locate 3+ROW,3+COL:PRINT Wheel.B
    Locate 2+ROW,3+COL:Print Chr$(Wheel.I[0])
    Locate 4+ROW,3+COL:Print Chr$(Wheel.I[2])
    Locate 3+ROW,4+COL:Print Chr$(Wheel.I[1])
    locate 3+ROW,2+COL:print chr$(Wheel.I[3])
    ROW = ROW + 1: COL = COL + 1
END SUB

'' Returns a comma seperated form of the wheel. The numbers
'' are clockwise for each row and are in Outer, Inner, Center
'' order.
FUNCTION StrWheel$(Wheel As WHEELSTATE)
    StrWheel$=Wheel.O+","+Wheel.I+","+Wheel.B
END FUNCTION

SUB Default(Wheel As WHEELSTATE)
    Wheel.O="1234"
    Wheel.I="5678"
    Wheel.B="0"
END SUB

'' This function is used to draw the puzzle blocks
'' but just the blocks; not the numbers.
SUB Piece(X,Y,V,S As Double)
    R = 4*S
    Block(X,Y,22*S,8)
    Block(X,Y,21*S,7)
    IF V <> 0 Then
        Block(X,Y,20*S,15)
    ELSE
        Block(X,Y,20*S,0)
    END IF
    160 SELECT CASE V
    CASE 1
        Block(X,Y,R,C)
    CASE 2
        Block(X-10*S,Y-10*S,R,C)
        Block(X+10*S,Y+10*S,R,C)
    CASE 3
        Block(X-10*S,Y-10*S,R,C)
        Block(X,Y,R,C)
        Block(X+10*S,Y+10*S,R,C)
    CASE 4
        Block(X-10*S,Y-10*S,R,C)
        Block(X+10*S,Y-10*S,R,C)
        Block(X+10*S,Y+10*S,R,C)
        Block(X-10*S,Y+10*S,R,C)
    CASE ELSE
        IF V <> 0 Then
            C = 7
            V = V MOD 4
            IF V = 0 Then V = 4
            Goto 160
        END IF
    END SELECT
END SUB

'' This is the actual routine used for drawing the wheel.
'' AN is the angle and S is the scaling factor.
SUB DrawWheel(X,Y,Wheel As WHEELSTATE,AN,S As Double)
    CONST PI = 3.141592654#
    DIM Theta As Double
    Circle(X,Y),110*S,7
    Paint(X,Y),7,7
    Circle(X,Y),66*S,8
    Paint(X,Y),8,8
    Piece X,Y,Val(Wheel.B),S
    Theta = (-AN+90)*(PI/180)
    A = X+88*Cos(Theta)*S
    B = Y-88*Sin(Theta)*S
    Piece A,B,VAL(CHR$(wheel.O[0])),S
    Theta = (-AN+180) * (PI/180)
    A = X+88*Cos(Theta)*S
    B = Y-88*Sin(Theta)*S
    Piece A,B,VAL(CHR$(wheel.O[3])),S
    Theta = (-AN+270) * (PI/180)
    A = X+88*Cos(Theta)*S
    B = Y-88*Sin(Theta)*S
    Piece A,B,VAL(CHR$(wheel.O[2])),S
    Theta = (-AN) * (PI/180)
    A = X+88*Cos(Theta)*S
    B = Y-88*Sin(Theta)*S
    Piece A,B,VAL(CHR$(wheel.O[1])),S
    Piece X,Y-44*S,VAL(CHR$(wheel.I[0])),S
    Piece X+44*S,Y,VAL(CHR$(wheel.I[1])),S
    Piece X,Y+44*S,VAL(CHR$(wheel.I[2])),S
    Piece X-44*S,Y,VAL(CHR$(wheel.I[3])),S
END SUB

SUB Done(WinLose)
    IF WinLose>0 THEN
        BLOAD "win.bmp"
        Locate 2,48:PRINT "C O N G R A T U L A T I O N S"
        Locate 5,45:PRINT "You have just completed another"
        Locate 6,45:PRINT "enigma wheel puzzle. Press any"
        Locate 7,45:PRINT "key to continue..."
    ELSE
        BLOAD "lose.bmp"
        Locate 2,43:PRINT "Y O U  D I D  N O T  F I N N I S H"
        Locate 5,45:PRINT "Sadly, you did not complete this"
        Locate 6,45:PRINT "enigma wheel puzzle. Press any"
        Locate 7,45:PRINT "key to continue..."
    END IF
END SUB
'' This is just a short sub routine to draw a filled in square.
'' but the X and Y coordinates passed are its center not its
'' top left corner.
SUB Block(X,Y,S,C)
    Line(X-S,Y-S)-(X+S,Y+S),C,BF
END SUB

