'Rambo vs. Neko-chan
'Made for the March 2005 compo
'by SJ Zero

Const Version = ".01"

DEFint A-Z

'$include: "sdl\sdl.bi"
declare sub CreateParticleExplosion (x as integer, y as integer)
declare sub ParticleBehave()
declare sub DrawNumber (number as integer, x as integer, y as integer)
declare sub LoadMapFile (Filename$)
declare sub enemyBehave ()
declare FUNCTION keyflag (x as integer)
declare FUNCTION getSingleEvent as integer
declare function Xdetect (PlayerNumber as integer, PlatformNumber as integer)
declare sub BulletBehave ()
declare sub SpawnBullet (x as integer, y as integer, kind as integer, direction as integer, owner as integer)
declare sub PlayerGravity()
declare sub BlitImage (x as Integer, y as Integer, image as SDL_Surface ptr)
declare sub DrawBackgroundAtOffset(byval x as integer, byval y as integer)
declare sub PageFlip()
declare sub loadBitmaps()
declare sub p1Control ()
declare sub p2Control 
declare sub drawall
declare function Ydetect (PlayerNumber as integer, PlatformNumber as integer)
dim shared screenSurface as SDL_Surface ptr

dim shared PlayerBitmaps(1 to 20) as SDL_Surface ptr 'all of living rambo
dim shared BulletBitmaps (0 to 9) as SDL_Surface ptr
dim shared CrateBitmaps (0 to 9) as SDL_Surface ptr
dim shared MaskBitmaps (0 to 9) as SDL_Surface ptr
dim shared platformBitmaps (0 to 9) as SDL_Surface ptr
dim shared enemyBitmaps (1 to 20, 1 to 4) as sdl_surface ptr
dim shared ParticleBitmaps (1 to 5) as sdl_Surface ptr
dim shared PlayerDeathBitmaps(1 to 20) as SDL_Surface ptr 'dying rambo
dim shared numberBitmaps(0 to 9) as SDL_Surface ptr
dim shared GameBackdropBitmap as SDL_Surface ptr ' The Game Backdrop Surface
dim shared GameOverScreen as SDL_Surface ptr
dim shared TitleScreen as SDL_Surface ptr
dim shared event as SDL_Event	
dim shared p1LeftKey
dim shared p1RightKey
dim shared p1JumpKey
dim shared p1ShootKey
const leftDirection = 1
const RightDirection = 0
const MAXOBJS = 5000
CONST MAXPLAYERHEALTH = 15
type Player
   x as integer
   y as integer
   yinertia as single
   xinertia as single
   direction as integer
   shooting as integer
   frame as integer
   solidground as integer
   lives as integer
   health as integer
   score as integer
end type
type bullet
   owner as integer
   x as integer
   y as integer
   direction as integer
   frame as integer
   life as integer
end type
type mask
   x as integer
   y as integer
   sprite as integer
end type
type Platform
   x as integer
   y as integer
   sprite as integer
end type
type particle
   x        as double
   y        as double
   life     as integer
   colour   as integer
   xaccel   as double
   yaccel   as double
   xveloc   as double
   yveloc   as double
end type

type enemy
   x as integer
   y as integer
   direction as integer
   sprite as integer
   frame as integer
   behaviour as integer
   life as integer
   tempvars(1 to 10) as integer
end type

dim shared masks (0 to 1000) as mask
dim shared platforms (0 to MAXOBJS) as platform
dim shared enemies (0 to MAXOBJS) as enemy

dim shared particles(0 to MAXOBJS) as particle
dim shared bullets (0 to MAXOBJS) as Bullet
dim shared players(1 to 2) as Player
dim shared CameraX
dim shared CameraY

players(1).health = MAXPLAYERHEALTH
 '***SDL INIT CODE***
 
   fileno = freefile
  open "config.cfg" for input as #fileno
  while not eof(fileno)
      input #fileno, x$ 
      x$ = lcase$(ltrim$(rtrim$(x$)))
      select case x$
       case "xres"
           input #fileno, x$
           xres = val(lcase$(ltrim$(rtrim$(x$))))
        case "yres"
            input #fileno, x$
            yres = val(lcase$(ltrim$(rtrim$(x$))))
        CASE "depth"
            input #fileno, x$
            depth = val(lcase$(ltrim$(rtrim$(x$))))
        case "sdl_hwsurface"
            screenoptions = screenoptions OR SDL_HWSURFACE
        case "sdl_swsurface"
            screenoptions = screenoptions OR SDL_SWSURFACE
 
         case "sdl_doublebuf"
            screenoptions = screenoptions OR SDL_DOUBLEBUF
        case "sdl_fullscreen"
            screenoptions = screenoptions OR SDL_FULLSCREEN
        case "sdl_hwaccel"
           screenoptions = screenoptions OR SDL_HWACCEL
        case "sdl_hwpalette"
           screenoptions = screenoptions OR SDL_HWPALETTE
       end select
            
        'SDL_DOUBLEBUF )'or SDL_FULLSCREEN
  wend
  close #fileno
  
  SDL_Init ( SDL_INIT_VIDEO )
  
  screenSurface = SDL_SetVideoMode( XRES, YRES, depth, screenoptions )


 if screenSurface = 0 then
      SDL_Quit
      
      END 1
  END IF
 '***BITMAP LOADING CODE***
loadBitmaps
 '***MAIN LOOP BEGINS***
players(1).frame = 1

open "input.cfg" for input as #fileno
 input #fileno, p1leftkey
 input #fileno, p1RightKey
 input #Fileno, p1JumpKey
 input #Fileno, p1ShootKey
close #fileno

LoadMapFile "map1.map"

dim oldtimer as double
dim fpstimer as double
dim fps as double
dim shared playeroneisdead
dim shared playertwoisdead
frameskip = 1
fps = 10
frameps=30
period = (1! / frameps ) * 1000!

oldtimer = SDL_GetTicks + period
'Uint32 SDL_GetTicks
while not quitted
if keyflag (sdlk_space) then quitted = 1
blitImage 0,0,TitleScreen
pageflip

wend
quitted = 0
while not quitted
 
    a = a + 1
    if oldtimer <= SDL_GetTicks then
   CameraX = -(Players(1).x - screenSurface->w / 2)
   Cameray = -((Players(1).y / 2) - ScreenSurface ->h / 2)
   if CameraY > 320 then CameraY = 320

   if players(1).health <= 0 then
      PlayerGravity()
      bulletBehave ()
      EnemyBehave ()
      
      CreateParticleExplosion Players(1).x , Players(1).y 
      ParticleBehave()
      DrawAll()
      
      blitImage 100,100, GameOverScreen
      pageFlip
      if keyflag(sdlk_escape) then quitted = 1
   else

   p1Control ()

   PlayerGravity()
   bulletBehave ()
   EnemyBehave ()
   DrawAll()
   ParticleBehave()
   pageFlip
   if keyflag(sdlk_escape) then quitted = 1
   'EDITOR SECTION -- TAKE OUT BEFORE RELEASING!!! (much!!)
   if SDL_GetMouseState(@MouseX, @MouseY ) then 
      '***SAVE THE MAP***
      if keyflag (sdlk_s) then
            input "Which filename would you like to save this under?", filename$
            fileno = freefile
            shell "del "+filename$
            open filename$ for binary as fileno
            for a = 1 to MAXOBJS
               put #fileno, ,platforms(a)
               put #fileno, ,enemies(a)
            next a
            for a = 1 to 1000
               put #fileno, ,masks(a)
            next a
            close fileno
            
      end if
      
      '***LOAD THE MAP***
      if keyflag (sdlk_l) then
            input "Which filename would you like to Load?", filename$
            LoadMapFile Filename$
            
      end if
      '***PLACE A MASK***
      if keyflag (sdlk_m) then
      input "Which mask would you like to place?";a
      if a <> 0 then
            for b = 1 to 1000
               if masks(b).sprite = 0 then exit for
            next b
             
               
            masks(b).x = Players(1).x + (MouseX - (screenSurface->w / 2))
            masks(b).y = Players(1).y + (MouseY - (screenSurface->h / 2))
            masks(b).Sprite = a
            notplaced = 1
            while notplaced = 1
               if SDL_GetMouseState(@MouseX, @MouseY ) then 
            masks(b).x = Players(1).x + (MouseX - (screenSurface->w / 2))
            masks(b).y = Players(1).y + (MouseY - (screenSurface->h / 2))
                  masks(b).Sprite = a
                  if keyflag (sdlk_space) then exit while
               end if
         
            drawall
            pageflip
               
            wend
            
            print "Placed mask";b;"to coords ";MouseX + CameraX;MouseY+CameraY;" with sprite";a
         end if
      end if
      '***PLACE A PLATFORM
      if keyflag (sdlk_p) then
      input "Which mask would you like to place?";a
      if a <> 0 then
            for b = 1 to MAXOBJS
               if platforms(b).sprite = 0 then exit for
            next b
             
               
            platforms(b).x = Players(1).x + (MouseX - (screenSurface->w / 2))
            platforms(b).y = Players(1).y + (MouseY - (screenSurface->h / 2))
            platforms(b).Sprite = a
            notplaced = 1
            while notplaced = 1
               if SDL_GetMouseState(@MouseX, @MouseY ) then 
                  platforms(b).x = Players(1).x + (MouseX - (screenSurface->w / 2))
                  platforms(b).y = Players(1).y + (MouseY - (screenSurface->h / 2))
                  platforms(b).Sprite = a
                  if keyflag (sdlk_space) then exit while
               end if
         
            drawall
            pageflip
               
            wend
            
            print "Placed platform";b;"to coords ";MouseX + CameraX;MouseY+CameraY;" with sprite";a
         end if
      end if
            '***PLACE AN ENEMY
      if keyflag (sdlk_e) then
      input "Which enemy would you like to place?";a
      input "How much health should this enemy have?";c
      if a <> 0 then
            for b = 1 to MAXOBJS
               if enemies(b).sprite = 0 then exit for
            next b
             
               
            enemies(b).x = Players(1).x + (MouseX - (screenSurface->w / 2))
            enemies(b).y = Players(1).y + (MouseY - (screenSurface->h / 2))
            enemies(b).Sprite = a
            notplaced = 1
            while notplaced = 1
               if SDL_GetMouseState(@MouseX, @MouseY ) then 
                  enemies(b).x = Players(1).x + (MouseX - (screenSurface->w / 2))
                  enemies(b).y = Players(1).y + (MouseY - (screenSurface->h / 2))
                  enemies(b).Sprite = a
                  enemies(b).life = c
                  if keyflag (sdlk_space) then exit while
               end if
         
            drawall
            pageflip
               
            wend
            
            print "Placed enemy";b;"to coords ";MouseX + CameraX;MouseY+CameraY;" with sprite";a
         end if
      end if
   end if
   
   end if
      
           
     
     else 
        SDL_Delay (oldtimer - sdl_GetTicks)
    end if     
   

     
        
wend

SDL_Quit
'result = HarmonyRelease
END

 '***MAIN LOOP ENDS***
sub LoadMapFile (Filename$)
   fileno = freefile

   open filename$ for binary as fileno

   for a = 1 to MAXOBJS
      get #fileno, ,platforms(a)
      get #fileno, ,enemies(a)
   next a

   for a = 1 to 1000
      get #fileno, ,masks(a)
   next a

   close fileno

end sub

sub ParticleBehave ()
      for a = 1 to MAXOBJS
         if Particles(a).colour <> 0 then
            particles(a).x += particles(a).xveloc
            particles(a).y += particles(a).yveloc
            particles(a).xveloc += particles(a).xaccel
            particles(a).yveloc += particles(a).yaccel
            particles(a).life -= 1
            if particles(a).life <= 0 then particles(a).colour = 0
         end if
      next a
end sub

sub CreateParticleExplosion(x, y)
      for b = 1 to int(rnd(1) * 255)
      for a = 1 to MAXOBJS
            if particles(a).colour = 0 then exit for
      next a
         particles(a).x = x
         particles(a).y = y
         particles(a).life = int(rnd(1) * 50)
         particles(a).colour = int(rnd(1)*3) + 1
         particles(a).xaccel = 0
         particles(a).yaccel = 1
         particles(a).xveloc = (rnd(1) * 10) - 5
         particles(a).yveloc = (rnd(1) * 10) - 5
      next b
      
      
end sub

sub PlayerGravity()
   static Idunno
   if Players(1).y < 170 then 
      players(1).yinertia += (9.81/30) 'replace 30 with FPS
      tuh = (9.81/30)
      players(1).solidground = 0
   else
      players(1).yinertia = 0
      tuh = 0
      players(1).solidground = 1
      players(1).y = 170
   end if
   players(1).y += players(1).yinertia
    players(1).y += players(1).yinertia
    
   
   for a = 1 to MAXOBJS
      if platforms(a).sprite then 
         if Xdetect(1,a) then 
      MyYDetect = YDetect (1,a)
      if MyYDetect = 1 then 'This is for if it comes from above
         players(1).y -= players(1).yinertia
         players(1).yinertia = 0
      end if
      if MyYDetect = 2 and solidground = 0 then 'This is for if it comes from below
         players(1).y = platforms(a).y - PlayerBitmaps(players(1).frame + (8 * (Players(1).Direction)))->h - 1 
         players(1).yinertia = 0
         
         While (Xdetect(1,a) and Ydetect(1,a))
               players(1).y -= 1
            wend
            
         
         Idunno = 1
         players(1).solidground = 1

      end if 
       end if
      end if
   next a
    players(1).y -= players(1).yinertia
end sub
function Ydetect (PlayerNumber as integer, PlatformNumber as integer)
   
   BlockY1 = platforms(PlatformNumber).y 
   BlockY2 = platforms(PlatformNumber).y + PlatformBitmaps(platforms(PlatformNumber).sprite)->h 
   
   MyY1 = players(playernumber).y
   MyY2 = players(playernumber).y + PlayerBitmaps(players(PlayerNumber).frame + (8 * (Players(PlayerNumber).Direction)))->h
   
   
      if (BlockY1 + 2) > MyY1 and (BlockY1 + 2) < MyY2 then block = 1
      if (BlockY2 + 2) > MyY1 and (BlockY2 + 2) < MyY2 then block = 1
     if MyY1 > BlockY1 and MyY1 < BlockY2 then block = 1
      if MyY2 > BlockY1 and MyY2 < BlockY2 then block = 2
      
   'else
      'This routine is for if the player is smaller than the platform.

   ydetect = block
   
end function
function Xdetect (PlayerNumber as integer, PlatformNumber as integer)
   
   BlockY1 = platforms(PlatformNumber).x 
   BlockY2 = platforms(PlatformNumber).x + PlatformBitmaps(platforms(PlatformNumber).sprite)->w 
   
   MyY1 = players(playernumber).x
   MyY2 = players(playernumber).x + PlayerBitmaps(players(PlayerNumber).frame + (8 * (Players(PlayerNumber).Direction)))->w
   
   'if PlayerBitmaps(players(PlayerNumber).frame + (8 * (Players(PlayerNumber).Direction)))->w < PlatformBitmaps(platforms(PlatformNumber).sprite)->w then
      'This routine is for if the player is bigger than the platform.
      
      
      if (BlockY1 + 2) > MyY1 and (BlockY1 + 2) < MyY2 then block = 1
      if (BlockY2 + 2) > MyY1 and (BlockY2 + 2) < MyY2 then block = 1
      if MyY1 > BlockY1 and MyY1 < BlockY2 then block = 1
      if MyY2 > BlockY1 and MyY2 < BlockY2 then block = 1
      
   'else
      'This routine is for if the player is smaller than the platform.
   'end if
   Xdetect = block
   
end function

sub p1Control
   static StepTimer
   StepTimer = StepTimer + 1
   if StepTimer = 10 then Steptimer = 0:StepActive = 1
   if stepActive then Players(1).shooting = 0

   if keyflag (p1leftkey) then
         Players(1).x += 4
            for a = 1 to MAXOBJS
         if platforms(a).sprite then
            if XDetect (1,a) then
               if YDetect (1, a) then
                  blocked = 1
               end if
            end if
         end if
            
      next a
      
      if blocked = 1 then Players(1).x -= 4:exit sub
      players(1).direction = 1
      if stepActive then
         stepped = 1
         players(1).frame = players(1).frame + 1
         if players(1).frame > 4 then players(1).frame = 1
      end if
      
   end if
   if keyflag (p1RightKey) then
            Players(1).x -= 4
      for a = 1 to MAXOBJS
         if platforms(a).sprite then
            if XDetect (1,a) then
               if YDetect (1, a) then
                  blocked = 1
               end if
            end if
         end if
            
      next a
      
      if blocked = 1 then Players(1).x += 4:exit sub

      Players(1).direction = 0
      if stepActive then
         stepped = 1
         players(1).frame = players(1).frame + 1
         if players(1).frame > 4 then players(1).frame = 1
      end if
   end if
   if keyflag(p1JumpKey) and players(1).solidground then
      Players(1).y -= 1
      players(1).yinertia -= 10

   end if
   if Keyflag (p1ShootKey) and stepActive then
      Players(1).shooting = 1
      spawnBullet players(1).x , players(1).y + (PlayerBitmaps(players(1).frame + (8 * (Players(1).Direction)))->h / 2) - 10, 1, players(1).direction, 1
      if stepActive and not stepped then
         players(1).frame = players(1).frame + 1
         if players(1).frame > 4 then players(1).frame = 1
      end if
      
   end if

end sub


sub DrawAll()
   
   DrawBackgroundAtOffset CameraX, CameraY - 320
   if players(1).health > 0 then
      if players(1).shooting = 0 then 
         BlitImage Players(1).x + CameraX, Players(1).y + CameraY, PlayerBitmaps(players(1).frame + (8 * (Players(1).Direction)))
      else
         BlitImage Players(1).x + CameraX, Players(1).y + CameraY, PlayerBitmaps(5 + (abs(players(1).frame > 2)) + (8 * (Players(1).Direction)))
      end if
   else
   end if
   for a = 1 to MAXOBJS
               if platforms(a).sprite <> 0 then BlitImage platforms(a).x + CameraX, platforms(a).y + CameraY, platformBitmaps(platforms(a).sprite)
               if enemies(a).sprite <> 0 then BlitImage enemies(a).x + CameraX, enemies(a).y + CameraY, EnemyBitmaps(enemies(a).sprite, Enemies(a).frame + 1 + (Enemies(a).direction * 2))
   next a
   
   for a = 1 to 1000
             if masks(a).sprite <> 0 then BlitImage masks(a).x + CameraX, masks(a).y + CameraY, maskBitmaps(masks(a).sprite)
   next a

   for a = 1 to MAXOBJS 
       if bullets (a).owner > 0 then BlitImage Bullets(a).x + CameraX, Bullets(a).y + CameraY, BulletBitmaps(bullets(a).frame + (3 * (bullets(a).Direction)))
       if bullets (a).owner < 0 then 
          BlitImage Bullets(a).x + CameraX, Bullets(a).y + CameraY, BulletBitmaps(7 + bullets(a).Direction)
          bullets(a).owner += 1
       end if
       if particles(a).colour <> 0 then
          BlitImage particles(a).x + CameraX, particles(a).y + CameraY, ParticleBitmaps(particles(a).colour)
       end if
       
       
          
   next a
   dim rect as SDL_Rect
        rect.x = 50
        rect.y = 25'screenSurface->h - 100
        rect.h = ( ScreenSurface->h - 170 )
        rect.w = 15
       '  dim Rectangle2 as SDL_Rect
       
        SDL_FillRect screenSurface, @rect, SDL_MapRGB(screenSurface->Format, 0, 0, 255)
        'SDL_MapRGBA( screenSurface->format, 0,0,255,128 )
     'lives
       
        rect.x = 50
        rect.y = 25'screenSurface->h - 100
        rect.h = (ScreenSurface->h - 170 ) - ((ScreenSurface->h - 170 ) * (players(1).health/MAXPLAYERHEALTH))
        rect.w = 15
       '  dim Rectangle2 as SDL_Rect
       'SDL_MapRGB(screenSurface->Format, 255, 0, 255)
        SDL_FillRect screenSurface, @rect, SDL_MapRGB(screenSurface->Format, 255, 255, 255)'SDL_MapRGBA( screenSurface->format, 255,0,0,128 )
        
        drawNumber players(1).score,20,10

end sub

sub enemyBehave ()
   static StepTimer
   StepTimer = StepTimer + 1
   if StepTimer = 10 then Steptimer = 0:StepActive = 1
   x = (steptimer mod 1 )+1
            myx1 = players(1).x 
            myx2 = players(1).x + PlayerBitmaps(players(1).frame + (8 * (Players(1).Direction)))->w 
            myy1 = players(1).y 
            myy2 = players(1).y + PlayerBitmaps(players(1).frame + (8 * (Players(1).Direction)))->h 
            
   for a = 1 to MAXOBJS step x
      if enemies(a).sprite <> 0 and StepActive then
            hisx1 = enemies(a).x 
            hisx2 = enemies(a).x + EnemyBitmaps(enemies(a).sprite, Enemies(a).frame + 1 + (Enemies(a).direction * 2))->w 

            if (myx1 > hisx1 and myx1 < hisx2) or (myx2 > hisx1 and myx2 < hisx2) then
                   hisy1 = enemies(a).y 
                   hisy2 = enemies(a).y + EnemyBitmaps(enemies(a).sprite, Enemies(a).frame + 1 + (Enemies(a).direction * 2))->h  
                   if (myy1 > hisy1 and myy1 < hisy2) or (myy2 > hisy1 and myy2 < hisy2) then
                     players(1).health -= 1
                     players(1).yinertia = -players(1).yinertia
                     if players(1).direction then direction = -1 else direction = 1
                     players(1).x += 16 * direction
                   end if
                  
            end if
            
            
            if enemies(a).frame = 0 then enemies(a).frame = 1 else enemies(a).frame=0         
      end if
      if enemies(a).sprite = 1 then 'Spear girl -- Walks on plaforms, ground.
         if enemies(a).tempvars(2) = 0 then
            enemies(a).tempvars(2) = 1
            enemies(a).tempvars(1) = 250
            enemies(a).tempvars(3) = 250
            enemies(a).tempvars(5) = -250
            enemies(a).tempvars(6) = 250
            
            if enemies(a).y > 150 then enemies(a).y = 150
            if enemies(a).y < 150 then
                  for b = 1 to MAXOBJS
                  
                     if platforms(b).sprite then
                     
                        if platforms(b).x < enemies(a).x and (platforms(b).x + PlatformBitmaps(platforms(b).sprite)->w) > enemies(a).x then
                           enemies(a).tempvars(1) = 0
                           enemies(a).tempvars(5) = Platforms(b).x - enemies(a).x 
                           
                           enemies(a).tempvars(6) = ((platforms(b).x + PlatformBitmaps(platforms(b).sprite)->w) - enemies(a).x)  - enemyBitmaps(enemies(a).sprite,1)->w 
                           enemies(a).y = platforms(b).y - EnemyBitmaps(enemies(a).sprite, 1)->h
                            exit for
                        end if
                     end if
                  next b
               
               
            end if
            
         end if
         
         if enemies(a).tempvars(1) <= enemies(a).tempvars(5) then enemies(a).tempvars(4) = 1
         if enemies(a).tempvars(1) >= enemies(a).tempvars(6) then enemies(a).tempvars(4) = 0
         
         if enemies(a).tempvars(4) = 0 then 
            enemies(a).tempvars(1) -= 3
            enemies(a).x -= 3
            enemies(a).direction = 0
            if 
         else
            enemies(a).tempvars(1) += 3
            enemies(a).x += 3
            enemies(a).direction = 1
         end if
         'print enemies(a).tempvars(1), enemies(a).x, enemies(a).direction
      end if
      if enemies(a).sprite = 2 then 'Dark knight jumps a lot.
         if enemies(a).tempvars(10) = 0 then
            enemies(a).tempvars(10) = 1
            enemies(a).tempvars(1) = -20
            enemies(a).tempvars(2) = enemies(a).y
         end if
         
         if enemies(a).tempvars(9) then
         enemies(a).tempvars(1) += 1
         enemies(a).y += enemies(a).tempvars(1)
         if enemies(a).tempvars(1) = 18 then 
            enemies(a).y = enemies(a).tempvars(2)
            enemies(a).tempvars(1) = -20
            if enemies(a).y > players(1).y then enemies(a).tempvars(9) = 1 else enemies(a).tempvars(9) = 0
         end if
      else
            if enemies(a).y > players(1).y then enemies(a).tempvars(9) = 1 else enemies(a).tempvars(9) = 0
        end if
        
         
         
         
      end if
      
      if enemies(a).sprite = 3 then
         if enemies(a).tempvars(2) = 0 then
            enemies(a).tempvars(2) = 1
            enemies(a).tempvars(1) = 350
            enemies(a).tempvars(3) = 350
         end if
         
         if enemies(a).tempvars(1) <= -350 then enemies(a).tempvars(4) = 1
         if enemies(a).tempvars(1) >=  350 then enemies(a).tempvars(4) = 0
         
         if enemies(a).tempvars(4) = 0 then 
            enemies(a).tempvars(1) -= 4
            enemies(a).x -= 4
            enemies(a).direction = 0
         else
            enemies(a).tempvars(1) += 6
            enemies(a).x += 6
            enemies(a).direction = 1
         end if
      end if
      if enemies(a).sprite = 4 then
         if enemies(a).tempvars(2) = 0 then
            enemies(a).tempvars(2) = 1
            enemies(a).tempvars(1) = 300
            enemies(a).tempvars(3) = 300
         end if
         enemies(a).tempvars(6) += 5
         if enemies(a).tempvars(6) >= 360 then enemies(a).tempvars(6) = 0
         
         if enemies(a).tempvars(1) <= -300 then enemies(a).tempvars(4) = 1
         if enemies(a).tempvars(1) >=  300 then enemies(a).tempvars(4) = 0
         
         if enemies(a).tempvars(4) = 0 then 
            enemies(a).tempvars(1) -= 2
            enemies(a).x -= 2
            enemies(a).direction = 0
         else
            enemies(a).tempvars(1) += 2
            enemies(a).x += 2
            enemies(a).direction = 1
         end if
         enemies(a).y = enemies(a).y - (sin(enemies(a).tempvars(6) * (3.141579/180)))
   end if
   
      if enemies(a).sprite = 5 then
         if enemies(a).tempvars(2) = 0 then
            enemies(a).tempvars(2) = 1
            enemies(a).tempvars(1) = 100
            enemies(a).tempvars(3) = 100
         end if
         
         if enemies(a).tempvars(1) <= -100 then enemies(a).tempvars(4) = 1
         if enemies(a).tempvars(1) >=  100 then enemies(a).tempvars(4) = 0
         
         if enemies(a).tempvars(4) = 0 then 
            enemies(a).tempvars(1) -= 2
            enemies(a).x -= 2
            enemies(a).direction = 0
         else
            enemies(a).tempvars(1) += 2
            enemies(a).x += 2
            enemies(a).direction = 1
         end if
      end if
   
   next a
   
   
end sub

sub loadBitmaps()
   '***LOADING GENERIC NUMBERS FOR SCORE***
   TitleScreen = SDL_LoadBMP("images\image2.bmp")
   GameOverScreen = SDL_LoadBMP("images\nolives.bmp")
   SDL_SetColorKey GameOverScreen, SDL_SrcColorKey, SDL_MapRGB(GameOverScreen->Format, 255, 0, 255)
     
   for a = 0 to 9
      numberBitmaps(a) = SDL_LoadBMP("images\"+str$(a)+".bmp")
      
      SDL_SetColorKey numberBitmaps(a), SDL_SrcColorKey, SDL_MapRGB(numberBitmaps(a)->Format, 255, 0, 255)

      result = SDL_SetAlpha(numberBitmaps(a), SDL_SRCALPHA, 128)
   next a
   print "loaded without crashing"
   '***LOADING THE PLAYER***
   for a = 1 to 16
      Playerbitmaps(a) = SDL_LoadBMP("images\rambo"+str$(a)+".bmp")
      SDL_SetColorKey Playerbitmaps(a), SDL_SrcColorKey, SDL_MapRGB(PlayerBitmaps(a)->Format, 255, 0, 255)
      if PlayerBitmaps(a) = 0 then print "Player bitmap loading Problem!": end 1
   next a
    '***LOADING THE BULLETS***
    for a = 1 to 8
       bulletBitmaps(a) = SDL_LoadBMP("images\bullet"+str$(a)+".bmp")
       SDL_SetColorKey bulletBitmaps(a), SDL_SrcColorKey, SDL_MapRGB(bulletBitmaps(a)->Format, 255, 0, 255)
       if BulletBitmaps(a) = 0 then print "Bitmap bitmap loading Problem on file:";"images\bullet"+str$(a)+".bmp": end 1
    next a
    '***LOADING THE MASK(ie. foreground images which block view)***
        for a = 1 to 3
       maskBitmaps(a) = SDL_LoadBMP("images\mask"+str$(a)+".bmp")
       SDL_SetColorKey maskBitmaps(a), SDL_SrcColorKey, SDL_MapRGB(maskBitmaps(a)->Format, 255, 0, 255)
       if maskBitmaps(a) = 0 then print "Bitmap bitmap loading Problem on file:";"images\mask"+str$(a)+".bmp": end 1
    next a
    '***LOADING PLATFORMS***
        for a = 1 to 5
       platformBitmaps(a) = SDL_LoadBMP("images\plat"+str$(a)+".bmp")
       SDL_SetColorKey platformBitmaps(a), SDL_SrcColorKey, SDL_MapRGB(platformBitmaps(a)->Format, 255, 0, 255)
       if platformBitmaps(a) = 0 then print "Bitmap bitmap loading Problem on file:";"images\plat"+str$(a)+".bmp": end 1
    next a
    '***LOADING ENEMIES***'
    for a = 1 to 5 'Change this one for more enemies.
       for b = 1 to 4
          enemyBitmaps (a, b) = SDL_LoadBMP("images\enemy"+str$(a)+"-"+str$(b)+".bmp")
          SDL_SetColorKey enemyBitmaps(a,b), SDL_SrcColorKey, SDL_MapRGB(enemyBitmaps(a,b)->Format, 255, 0, 255)
          if enemyBitmaps(a,b) = 0 then print "Enemy bitmap loading Problem on file:";"images\enemy"+str$(a)+"="+str$(b)+".bmp": end 1
       next b
    next a
    for a = 1 to 4
             ParticleBitmaps(a) = SDL_LoadBMP("images\particle"+str$(a)+".bmp")
       SDL_SetColorKey particleBitmaps(a), SDL_SrcColorKey, SDL_MapRGB(particleBitmaps(a)->Format, 255, 0, 255)
       if particleBitmaps(a) = 0 then print "Bitmap bitmap loading Problem on file:";"images\particle"+str$(a)+".bmp": end 1
    next a
   
    'enemyBitmaps (1 to 20, 1 to 4)
    
    '***LOADING CHEEZY BACKDROP***
   GameBackdropBitmap = SDL_LoadBMP("images\image1.bmp")

end sub

sub DrawBackgroundAtOffset(byval x as integer, byval y as integer)
   x = x mod gameBackDropBitmap->w
      BlitImage x,y,GameBackdropBitmap
      if x > 0 then BlitImage (x - gameBackDropBitmap->w),y, GameBackDropBitmap
      If x < -380 then BlitImage (x + gameBackDropBitmap->w),y, GameBackDropBitmap
end sub



sub BlitImage(x as integer,y as integer,image as sdl_surface ptr)
   dim Rectangle as SDL_Rect

         dim Rectangle2 as SDL_Rect

         
         Rectangle.X = 0
         Rectangle.Y = 0
         rectangle.w = image->w
         rectangle.h = image->h
         Rectangle2.x = x
         Rectangle2.y = y
 
         SDL_BlitSurface image, @rectangle, screenSurface, @rectangle2
      
end sub  

SUB pageflip ()
   	SDL_Flip screenSurface
      
	SDL_PumpEvents
   
   'dim rect as SDL_Rect
   'rect.x = 0
   'rect.y = 0
   'rect.w = screenSurface->w
   'rect.h = screenSurface->h
   'SDL_FillRect screenSurface, @rect, black
    
END SUB

FUNCTION keyflag (x as integer)
   static keys(0 to 1024) as short
   'HIGHEST = 319 LOWEST = 0
   'So, keyflag protocol:
   '0-320 will be keyflags
   '320-330 will be mouseFlags
   '350-370 will be Joystick 1
   '380-400 will be Joystick 2
   
   while( SDL_PollEvent ( @event ) )                   
      select case event.type
         case SDL_KeyDOWN:
           keys(event.key.keysym.sym) = -1
         case SDL_KeyUP:
            keys(event.key.keysym.sym) = 0
         case SDL_MOUSEMOTION:
            '326,327,328,329 are mouse movement events
            keys(326) = (event.motion.xrel < 0)               
            keys(327) = (event.motion.xrel > 0)                 
            keys(328) = (event.motion.yrel < 0)
            keys(329) = (event.motion.yrel > 0)
         case SDL_MOUSEBUTTONDown:
         'SDL mouse buttons 321->325
         num = 320+event.button.button
         keys(num) = -1             
         case SDL_MOUSEBUTTONUP:
            num = 320+event.button.button
         keys(num) = 0
           
         case SDL_JOYAXISMOTION
            'axis events on
            '400 + (Joysticknumber * 100) + (axis * 2)
            'There won't be more than 5 axises on a joystick, so x00-x20 are
            'reserved...
            num = 400 + (event.jaxis.which * 100) + (event.jaxis.axis * 2)
            keys(num) = (event.jaxis.value < 0)               
            keys(num + 1) = (event.jaxis.value > 0)
         
      case SDL_JoyBallMotion
                     
            'jball
            'x20-x40 are Ball events. 20 is room for 5 balls.
            'There's something @$ up if 5 balls isn't enough for you.
            'num=420 + (event.jaxis.which * 100) + (which * 4)
            num = 420 + (event.jball.which * 100) + (event.jaxis.axis * 2)
            keys(num) = (event.jball.xrel < 0)               
            keys(num+1) = (event.jball.xrel > 0)                 
            keys(num+2) = (event.jball.yrel < 0)
            keys(num+3) = (event.jball.yrel > 0)

         case SDL_JoyHatMotion
            'jhat
            'x40-x80 are Hat events.40 is room for 5 hats.
            'If you need 5 hats, I suggest surgery.
            num = 440 + (event.jhat.which * 100) + (event.jhat.hat * 8)
            for a = 1 to 8
               keys(num + a) = 0
            next a
            keys(num + event.jhat.value) = -1
           
         case SDL_JoyButtonDown
           
            'button events are x80-x99
            num = 40 + (event.jbutton.which * 100) + (event.jbutton.button)
            keys(num) = -1
         case SDL_JoyButtonUp
           
            num = 40 + (event.jbutton.which * 100) + (event.jbutton.button)
            keys(num) = 0

         end select
   
      wend
   keyflag = keys(x)

END FUNCTION

FUNCTION getSingleEvent as integer
   'This function will return 0 if no event is in the queue, otherwise it'll return
   'the keyflag protocol number.
   
   'So, keyflag protocol:
   '0-320 will be keyflags
   '321-329 will be mouseFlags
   '400-500 will be Joystick 1
   '500-600 will be Joystick 2
   '600-700 will be Joystick 3
   '700-800 will be Joystick 4
   '900-1000 will be Joystick 5
   while( SDL_PollEvent ( @event ) )                   
         select case event.type
            case SDL_KeyDOWN:
              getSingleEvent = event.key.keysym.sym
              exit function
   
            case SDL_MOUSEMOTION:
               '326,327,328,329 are mouse movement events
               if (event.motion.xrel < 0) then getSingleEvent = 326:exit function
               if (event.motion.xrel > 0) then getSingleEvent = 327:exit function
               if (event.motion.yrel < 0) then getSingleEvent = 328:exit function
               if (event.motion.yrel > 0) then getSingleEvent = 329:exit function
   
            
            case SDL_MOUSEBUTTONDown:
            'SDL mouse buttons 321->325
            getSingleEvent = 320+event.button.button
            exit function
              
            case SDL_JOYAXISMOTION
               num = 400 + (event.jaxis.which * 100) + (event.jaxis.axis * 2)
               getSingleEvent = num
               exit function
         case SDL_JoyBallMotion
                        
               'jball
               'x20-x40 are Ball events. 20 is room for 5 balls.
               'There's something @$ up if 5 balls isn't enough for you.
               'num=420 + (event.jaxis.which * 100) + (which * 4)
               num = 420 + (event.jball.which * 100) + (event.jaxis.axis * 2)
               if (event.jball.xrel < 0) then getSingleEvent = num               
               if (event.jball.xrel > 0) then getSingleEvent = num + 1
               if (event.jball.yrel < 0) then getSingleEvent = num + 2
               if (event.jball.yrel > 0) then getSingleEvent = num + 3
              
               exit function
   
            case SDL_JoyHatMotion
               'jhat
               'x40-x80 are Hat events.40 is room for 5 hats.
               'If you need 5 hats, I suggest surgery.
               num = 440 + (event.jhat.which * 100) + (event.jhat.hat * 8)
   
               getSingleEvent = num + event.jhat.value
               exit function           
            case SDL_JoyButtonDown
              
               'button events are x80-x99
               num = 40 + (event.jbutton.which * 100) + (event.jbutton.button)
               getSingleEvent = num
               exit function
            end select
      
      wend
      getSingleEvent = 0
      exit function

END FUNCTION

sub SpawnBullet (x as integer, y as integer, kind as integer, direction as integer, owner as integer)
 
 'First we find a bullet
 for a = 1 to MAXOBJS 
    if bullets (a).owner = 0 then exit for
 next a
 'now we set the parameters
 
 select case kind
 case 1
    'This is a standard bullet
    bullets(a).owner = owner
    bullets(a).x = x
    bullets(a).y = y
    bullets(a).direction = direction
    bullets(a).frame = 1
    bullets(a).life = screenSurface->w / 8 'Just a bit more than the screen / 2
 end select
 
end sub
sub BulletBehave ()
      static StepTimer
   StepTimer = StepTimer + 1
   if StepTimer = 10 then Steptimer = 0:StepActive = 1
 for a = 1 to MAXOBJS 
    if bullets (a).owner > 0 then 
       if bullets(a).direction then
          bullets(a).x = bullets(a).x + 8
       else
          bullets(a).x = bullets(a).x - 8
       end if
       if stepActive then 
          bullets(a).frame = bullets(a).frame + 1
          if bullets(a).frame = 4 then bullets(a).frame = 1
       end if
       bullets(a).life = bullets(a).life - 1
       if bullets(a).life = 0 then bullets(a).owner = 0
 
    
    if bullets(a).owner = 1 then
       bx1 = bullets(a).x
       bx2 = bullets(a).x + BulletBitmaps(bullets(a).frame + (3 * (bullets(a).Direction)))->w
       By = bullets(a).y + (BulletBitmaps(bullets(a).frame + (3 * (bullets(a).Direction)))->h / 2)
       for b = 1 to MAXOBJS
          if platforms(b).sprite then 
             if (bx1 > platforms(b).x and bx1 < (platforms(b).x + PlatformBitmaps(platforms(b).sprite)->w)) or (bx2 > platforms(b).x and bx2 < (platforms(b).x + PlatformBitmaps(platforms(b).sprite)->w)) then
                if by > platforms(b).y and by < (platforms(b).y + PlatformBitmaps(platforms(b).sprite)->h) then
                   bullets(a).owner = -10
                   exit for
                end if
             end if
          end if
          if enemies(b).sprite then 
             if (bx1 > enemies(b).x and bx1 < (enemies(b).x + EnemyBitmaps(enemies(b).sprite,1)->w)) or (bx2 > enemies(b).x and bx2 < (enemies(b).x + EnemyBitmaps(enemies(b).sprite,1)->w)) then
                if by > enemies(b).y and by < (enemies(b).y + EnemyBitmaps(enemies(b).sprite,1)->h) then
                   bullets(a).owner = -10
                   enemies(b).life -= 1
                   players(1).score += 10
                   print enemies(b).life
                   if enemies(b).life < 0 then
                      'FIXME: INITIATE BIG EXPLOSION!
                      CreateParticleExplosion (enemies(b).x + (EnemyBitmaps(enemies(b).sprite,1)->w) / 2), (enemies(b).y + (EnemyBitmaps(enemies(b).sprite,1)->h)/ 2)
                      enemies(b).sprite = 0
                   exit for
                   end if
                end if
             end if
          end if

       next b
    end if
   end if
 next a
end sub

sub DrawNumber (number as integer, x as integer, y as integer)
   MyString$ = str$(number)
   for a = 1 to len(MyString$)
      blitImage x,y,numberBitmaps(val(mid$(MyString$,a,1)))
      x = x + 57'numberBitmaps(val(mid$(MyString$,a,1))->w
   next a
   
end sub
