option explicit

const g         as single  = 9.80665       
const g2        as single  = g * 2.0
const gd2       as single  = g * 0.5
const pi        as single  = 3.141592654
const pi2       as single  = pi * 2.0
const onedegree as single  = pi/180.0

const max_particles as integer = 100000
const last_particle as integer = max_particles - 1
type PARTICLE
  bt  as single 'birth time
  scrx as integer
  scry as integer
  posx as integer
  posy as integer
  v0  as single 'speed    at time 0
  a   as single
  col as integer
end type
dim shared particles(max_particles) as PARTICLE
sub init_particle(byval i as integer,byval t as single)
  static w as single
  dim as single rc,gc,bc
  rc=cos(w)*0.5+0.5
  gc=cos(w*1.25)*0.5+0.5
  bc=cos(w*1.5)*0.5+0.5
  with particles(i)
    .posx=int(cos(w)*100)
    '.posy=int(sin(w)*240)
    .bt = t
    .v0 = sin(w)*80
    .a  = cos(w)*pi+pi2*rnd
    .col=rgb(255*rc,255*gc,255*bc)
  end with
  w=w+(1.0/max_particles)
end sub
sub update_particles(byval t as single)
  dim as single s,vs
  dim i as integer
  for i=0 to last_particle
    with particles(i)
    s=(t - .bt):vs=.v0*s
    .scrx=320 +.posx + int(vs*cos(.a))
    .scry=240 -(.posy + int(vs*sin(.a)-gd2*(s*s)))
    end with
  next
end sub   
sub render_particles(byval t as single)
  dim i as integer
  dim pageptr as uinteger ptr
  screenlock
  pageptr=screenptr
  for i =0 to last_particle
    with particles(i)
      if .scry>479 or .scrx<0 or .scrx>639 then
        init_particle i,t
      elseif .scry>-1 then
        pageptr[.scrx+.scry*640]=.col
      end if
    end with
  next
  screenunlock
end sub

'''main
dim as integer page,index
dim as single  starttime,curtime,nowtime
dim as single x,y

starttime=timer
for index=0 to last_particle
  init_particle index,starttime
next
screenres 640,480,32,2
'''loop
while inkey$=""
  screenset page,page xor 1:page = page xor 1
  nowtime=timer
  cls
  update_particles nowtime
  render_particles nowtime
wend

end