option explicit

const g         as single  = 9.80665
const g2        as single  = g * 2.0
const gd2       as single  = g * 0.5
const pi        as single  = 3.141592654
const pi2       as single  = pi * 2.0
const onedegree as single  = pi/180.0

const max_particles as integer = 10000
const last_particle as integer = max_particles - 1
type VECTOR
  x as single
  y as single
  z as single
end type
type PARTICLE
  bt  as single 'birth time 
  new as VECTOR
  old as VECTOR
  pos as vector
  v0  as single 'speed    at time 0
  a   as single
  col as integer
end type
dim shared particles(max_particles) as PARTICLE
sub init_particle(byval i as integer,byval t as single)
  static w as single
  dim as single rc,gc,bc
  rc=cos(w)*0.5+0.5
  gc=cos(w*1.5)*0.5+0.5
  bc=cos(w*3)*0.5+0.5
  with particles(i)
    .pos.x=sin(w*4)*200
    .bt = t
    .v0 = 40 + rnd * 50
    .a  =1.57 + rnd * (onedegree*20.0) - (onedegree*10.0)
    .col=rgb(255*rc,255*gc,255*bc)
  end with
  w=w+0.0001
end sub
sub update_particle(byval i as integer,byval t as single)
  dim as single s,vs
  with particles(i)
    s=(t - .bt):vs=.v0*s
    .new.x=320 +.pos.x + (vs*cos(.a))
    if .new.x<0 or .new.x>639 then init_particle i,t:exit sub
    .new.y=480.0 - (vs*sin(.a)-gd2*(s*s))
    if .new.y>479.0 then init_particle i,t:exit sub
  end with
end sub   
sub render_particle(byval i as integer)
  with particles(i)
    pset (.old.x,.old.y),0
    pset (.new.x,.new.y),.col
    .old.x=.new.x:.old.y=.new.y
  end with
end sub

'''main
dim as integer page,index
dim as single  starttime,curtime,nowtime
dim as single x,y

starttime=timer
for index=0 to last_particle
  init_particle index,starttime
next
screenres 640,480,32
'''loop 
while inkey$=""
  nowtime=timer
  for index=0 to last_particle
    update_particle index,nowtime
    render_particle index
  next 
wend

end