' 
'  T H E   N E W   F R E E B A S I C
'                  8 - B I T   P A L E T T E   M A C H I N E
'- Version 1.1 for FB v0.12b or newer!
'
'(c)2005 Adigun Azikiwe Polack.  All Rights Reserved.

' 
'  PLEASE *DO NOT* EDIT THIS SOURCE CODE IN ANY WAY   
'  AT ALL.  JUST LEAVE EVERYTHING HERE THE WAY IT IS. 
'  THANK YOU.  ^_-=b !                                
'

' 
' C H A N G E L O G  
'
'
' v1.1 - Sunday, March 13, 2005
' 
'        Updated and improved the speed on my custom-emulated version
'        of the default 256-color GFXlib 2 palette, thereby causing
'        the supporting fading/rotation/negative/crossfade/greyscale
'        routines for that palette to have at least a bit of a 
'        noticable speed increase (thank you, VonGodric!!  ^_-=b )!!
'         
'
' v1.0 - Saturday, March 12, 2005
' 
'        Initial Release, FIRST presented on QBasicNews.com forums on
'        that very morning EST!!  ^-^ !
'
'


'


'First of all, BIGGEST Special Thanks go to Almighty Jehovah God for
'first inspiring me to do this one just to be a rather special
'blessing to the whole entire QB45/QB71/FB community and to YOU, the
'FreeBASIC (FB) programmer, too!!!  d=^-^=b !!

'I was looking to implement some *real* good custom palette fading/
'manipulation routines for the wildly AWESOME QB-like graphics library
'by Angelo Mottola entitled GFXlib 2 for FreeBASIC.  I tested several
'conversions of QB code sources based on fading in/out palettes and
'stuff, but they ended up failing so miserably due to either improper
'color fades and/or messed-up colors.  Then, lo and behold, somewhere
'on the internet, I discovered the QB source code by P. Bindels about
'his palette fading routines (BIG thanks go to him for his awesome
'coding ideas to me here!!), and I was _so_ inspired then with the
'idea to just go right ahead and code in my custom palette routines
'here for GFXlib 2 for FreeBASIC!!  So why not, hmmmm?  ;*)

'Also, BIG thanks go to Sterling Christensen for his awesome coding
'ideas on how to *actually* code a greyscale palette in FB as part of
'my original routines here, too!!

'Last (but CERTAINLY not even least), thanks also to Richard Eric M.
'Lope (aka Relsoft) and to Chris Chadwick for the PP256 palette
'loading code presented in this original FreeBASIC lib, and also to
'Steve Nunnally of Acid Works Software for the 768-byte palette
'loading code presented here, too!!!

'The working code that you are about to see has been custom-created by
'Adigun Azikiwe Polack.  HERE WE GO!!!  ^_-=b !   


Defint A-Z

'
'  B L A C K   P A L E T T E   R O U T I N E S 
'
Declare Sub ZeroPal ()
Declare Sub ZeroPalRange (StartColor, EndColor)




'
'  S O L I D   C O L O R   P A L E T T E
'                                         R O U T I N E S 
'
Declare Sub SolidColorPal (R, G, B)
Declare Sub SolidColorPalRange (StartColor, EndColor, R, G, B)




'
'  P A L E T T E   F A D I N G / R O T A T I O N
'                                           R O U T I N E S 
'
'_____________________________________________________________________
' (For default 256-color GFXlib 2 palette only!)
'_____________________________________________________________________
Declare Sub FadeIn.DefaultPal (millisec)
Declare Sub FadeOut.DefaultPal (millisec)
Declare Sub FadeInX.DefaultPal (R.from, G.from, B.from, millisec)
Declare Sub FadeOutX.DefaultPal (R.to, G.to, B.to, millisec)
Declare Sub FadeInRange.DefaultPal (StartColor, EndColor, millisec)
Declare Sub FadeOutRange.DefaultPal (StartColor, EndColor, millisec)
Declare Sub FadeInRangeX.DefaultPal (StartColor, EndColor, R.from, G.from, B.from, millisec)
Declare Sub FadeOutRangeX.DefaultPal (StartColor, EndColor, R.to, G.to, B.to, millisec)
Declare Sub FadeCtrl.DefaultPal (FadeIn.Grade)
Declare Sub FadeCtrlX.DefaultPal (R.from, G.from, B.from, FadeIn.Grade)
Declare Sub FadeCtrlRangeX.DefaultPal (StartColor, EndColor, R.from, G.from, B.from, FadeIn.Grade)
Declare Sub PalRotate.DefaultPal (StartColor, EndColor, Rotate.Level)
Declare Sub PalRotateFC.DefaultPal (StartColor, EndColor, Rotate.Level, FadeIn.Grade)
Declare Sub PalRotateFCX.DefaultPal (StartColor, EndColor, R.from, G.from, B.from, Rotate.Level, FadeIn.Grade)
Declare Sub PalNeg.DefaultPal (Switch)
Declare Sub PalNegRange.DefaultPal (StartColor, EndColor, Switch)
Declare Sub PalNegRotate.DefaultPal (StartColor, EndColor, Rotate.Level)
Declare Sub PalFadeToNega.DefaultPal (millisec)
Declare Sub PalFadeFromNega.DefaultPal (millisec)
Declare Sub PalFadeRangeToNega.DefaultPal (StartColor, EndColor, millisec)
Declare Sub PalFadeRangeFromNega.DefaultPal (StartColor, EndColor, millisec)
Declare Sub PalNegaFadeCtrl.DefaultPal (FadeToNega.Grade)
Declare Sub PalNegaRangeFadeCtrl.DefaultPal (StartColor, EndColor, FadeToNega.Grade)
Declare Sub PalGreyScl.DefaultPal (Switch, NegaPalSwitch)
Declare Sub PalGreySclRange.DefaultPal (StartColor, EndColor, Switch, NegaPalSwitch)
Declare Sub PalGreySclRotate.DefaultPal (StartColor, EndColor, Rotate.Level, NegaPalSwitch)
Declare Sub PalFadeToGreyScl.DefaultPal (millisec, NegaPalSwitch)
Declare Sub PalFadeFromGreyScl.DefaultPal (millisec, NegaPalSwitch)
Declare Sub PalFadeRangeToGreyScl.DefaultPal (StartColor, EndColor, millisec, NegaPalSwitch)
Declare Sub PalFadeRangeFromGreyScl.DefaultPal (StartColor, EndColor, millisec, NegaPalSwitch)
Declare Sub PalGreyFadeCtrl.DefaultPal (FadeToGrey.Grade, NegaPalSwitch)
Declare Sub PalGreyRangeFadeCtrl.DefaultPal (StartColor, EndColor, FadeToGrey.Grade, NegaPalSwitch)


'_____________________________________________________________________
' (For custom 256-color palette files (.pal) with 768 bytes ONLY!)
'_____________________________________________________________________
Declare Sub FadeIn.768Pal (PalFile$, millisec)
Declare Sub FadeOut.768Pal (PalFile$, millisec)
Declare Sub FadeInX.768Pal (PalFile$, R.from, G.from, B.from, millisec)
Declare Sub FadeOutX.768Pal (PalFile$, R.to, G.to, B.to, millisec)
Declare Sub FadeInRange.768Pal (PalFile$, StartColor, EndColor, millisec)
Declare Sub FadeOutRange.768Pal (PalFile$, StartColor, EndColor, millisec)
Declare Sub FadeInRangeX.768Pal (PalFile$, StartColor, EndColor, R.from, G.from, B.from, millisec)
Declare Sub FadeOutRangeX.768Pal (PalFile$, StartColor, EndColor, R.to, G.to, B.to, millisec)
Declare Sub FadeCtrl.768Pal (PalFile$, FadeIn.Grade)
Declare Sub FadeCtrlX.768Pal (PalFile$, R.from, G.from, B.from, FadeIn.Grade)
Declare Sub FadeCtrlRangeX.768Pal (PalFile$, StartColor, EndColor, R.from, G.from, B.from, FadeIn.Grade)
Declare Sub PalRotate.768Pal (PalFile$, StartColor, EndColor, Rotate.Level)
Declare Sub PalRotateFC.768Pal (PalFile$, StartColor, EndColor, Rotate.Level, FadeIn.Grade)
Declare Sub PalRotateFCX.768Pal (PalFile$, StartColor, EndColor, R.from, G.from, B.from, Rotate.Level, FadeIn.Grade)
Declare Sub PalNeg.768Pal (PalFile$, Switch)
Declare Sub PalNegRange.768Pal (PalFile$, StartColor, EndColor, Switch)
Declare Sub PalNegRotate.768Pal (PalFile$, StartColor, EndColor, Rotate.Level)
Declare Sub PalFadeToNega.768Pal (PalFile$, millisec)
Declare Sub PalFadeFromNega.768Pal (PalFile$, millisec)
Declare Sub PalFadeRangeToNega.768Pal (PalFile$, StartColor, EndColor, millisec)
Declare Sub PalFadeRangeFromNega.768Pal (PalFile$, StartColor, EndColor, millisec)
Declare Sub PalNegaFadeCtrl.768Pal (PalFile$, FadeToNega.Grade)
Declare Sub PalNegaRangeFadeCtrl.768Pal (PalFile$, StartColor, EndColor, FadeToNega.Grade)
Declare Sub PalGreyScl.768Pal (PalFile$, Switch, NegaPalSwitch)
Declare Sub PalGreySclRange.768Pal (PalFile$, StartColor, EndColor, Switch, NegaPalSwitch)
Declare Sub PalGreySclRotate.768Pal (PalFile$, StartColor, EndColor, Rotate.Level, NegaPalSwitch)
Declare Sub PalFadeToGreyScl.768Pal (PalFile$, millisec, NegaPalSwitch)
Declare Sub PalFadeFromGreyScl.768Pal (PalFile$, millisec, NegaPalSwitch)
Declare Sub PalFadeRangeToGreyScl.768Pal (PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
Declare Sub PalFadeRangeFromGreyScl.768Pal (PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
Declare Sub PalGreyFadeCtrl.768Pal (PalFile$, FadeToGrey.Grade, NegaPalSwitch)
Declare Sub PalGreyRangeFadeCtrl.768Pal (PalFile$, StartColor, EndColor, FadeToGrey.Grade, NegaPalSwitch)


'_____________________________________________________________________
' (For custom PP256-based 256-color palette files (.pal) with 1,024
'  bytes ONLY!)
'_____________________________________________________________________
Declare Sub FadeIn.PP256 (PP256PalFile$, millisec)
Declare Sub FadeOut.PP256 (PP256PalFile$, millisec)
Declare Sub FadeInX.PP256 (PP256PalFile$, R.from, G.from, B.from, millisec)
Declare Sub FadeOutX.PP256 (PP256PalFile$, R.to, G.to, B.to, millisec)
Declare Sub FadeInRange.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
Declare Sub FadeOutRange.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
Declare Sub FadeInRangeX.PP256 (PP256PalFile$, StartColor, EndColor, R.from, G.from, B.from, millisec)
Declare Sub FadeOutRangeX.PP256 (PP256PalFile$, StartColor, EndColor, R.to, G.to, B.to, millisec)
Declare Sub FadeCtrl.PP256 (PP256PalFile$, FadeIn.Grade)
Declare Sub FadeCtrlX.PP256 (PP256PalFile$, R.from, G.from, B.from, FadeIn.Grade)
Declare Sub FadeCtrlRangeX.PP256 (PP256PalFile$, StartColor, EndColor, R.from, G.from, B.from, FadeIn.Grade)
Declare Sub PalRotate.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level)
Declare Sub PalRotateFC.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level, FadeIn.Grade)
Declare Sub PalRotateFCX.PP256 (PP256PalFile$, StartColor, EndColor, R.from, G.from, B.from, Rotate.Level, FadeIn.Grade)
Declare Sub PalNeg.PP256 (PP256PalFile$, Switch)
Declare Sub PalNegRange.PP256 (PP256PalFile$, StartColor, EndColor, Switch)
Declare Sub PalNegRotate.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level)
Declare Sub PalFadeToNega.PP256 (PP256PalFile$, millisec)
Declare Sub PalFadeFromNega.PP256 (PP256PalFile$, millisec)
Declare Sub PalFadeRangeToNega.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
Declare Sub PalFadeRangeFromNega.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
Declare Sub PalNegaFadeCtrl.PP256 (PP256PalFile$, FadeToNega.Grade)
Declare Sub PalNegaRangeFadeCtrl.PP256 (PP256PalFile$, StartColor, EndColor, FadeToNega.Grade)
Declare Sub PalGreyScl.PP256 (PP256PalFile$, Switch, NegaPalSwitch)
Declare Sub PalGreySclRange.PP256 (PP256PalFile$, StartColor, EndColor, Switch, NegaPalSwitch)
Declare Sub PalGreySclRotate.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level, NegaPalSwitch)
Declare Sub PalFadeToGreyScl.PP256 (PP256PalFile$, millisec, NegaPalSwitch)
Declare Sub PalFadeFromGreyScl.PP256 (PP256PalFile$, millisec, NegaPalSwitch)
Declare Sub PalFadeRangeToGreyScl.PP256 (PP256PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
Declare Sub PalFadeRangeFromGreyScl.PP256 (PP256PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
Declare Sub PalGreyFadeCtrl.PP256 (PP256PalFile$, FadeToGrey.Grade, NegaPalSwitch)
Declare Sub PalGreyRangeFadeCtrl.PP256 (PP256PalFile$, StartColor, EndColor, FadeToGrey.Grade, NegaPalSwitch)




'
'  P A L E T T E   C R O S S F A D I N G
'                                       R O U T I N E S 
'
'_____________________________________________________________________
' (For crossfading between default a 256-color GFXlib 2 palette *and*
'  a 256-color palette file (.pal) that has just 768 bytes ONLY!)
'_____________________________________________________________________
Declare Sub CrossFade.Default_to_768Pal (PalFile$, millisec)
Declare Sub CrossFade.768Pal_to_Default (PalFile$, millisec)
Declare Sub CrossFadeRange.Default_to_768Pal (StartColor, EndColor, PalFile$, millisec)
Declare Sub CrossFadeRange.768Pal_to_Default (StartColor, EndColor, PalFile$, millisec)
Declare Sub CrossFadeCtrl.Default_to_768Pal (FadeTo768Pal.Grade, PalFile$)
Declare Sub CrossFadeRangeCtrl.Default_to_768Pal (StartColor, EndColor, FadeTo768Pal.Grade, PalFile$)


'_____________________________________________________________________
' (For crossfading from one 768-byte 256-color palette file (.pal)
'  right into another one of the very same kind!!!  ^_^=b !)
'_____________________________________________________________________
Declare Sub CrossFade.768Pal_to_768Pal (PalFile.from$, PalFile.to$, millisec)
Declare Sub CrossFadeRange.768Pal_to_768Pal (StartColor, EndColor, PalFile.from$, PalFile.to$, millisec)
Declare Sub CrossFadeCtrl.768Pal_to_768Pal (FadeTo2nd768Pal.Grade, PalFile.from$, PalFile.to$)
Declare Sub CrossFadeRangeCtrl.768Pal_to_768Pal (StartColor, EndColor, FadeTo2nd768Pal.Grade, PalFile.from$, PalFile.to$)


'_____________________________________________________________________
' (For crossfading from one PP256-based 256-color palette file (.pal)
'  right into another one of the very same kind!!!  ^_^=b !)
'_____________________________________________________________________
Declare Sub CrossFade.PP256_to_PP256 (PP256PalFile.from$, PP256PalFile.to$, millisec)
Declare Sub CrossFadeRange.PP256_to_PP256 (StartColor, EndColor, PP256PalFile.from$, PP256PalFile.to$, millisec)
Declare Sub CrossFadeCtrl.PP256_to_PP256 (FadeTo2ndPP256Pal.Grade, PP256PalFile.from$, PP256PalFile.to$)
Declare Sub CrossFadeRangeCtrl.PP256_to_PP256 (StartColor, EndColor, FadeTo2ndPP256Pal.Grade, PP256PalFile.from$, PP256PalFile.to$)


'_____________________________________________________________________
' (For crossfading between a default 256-color GFXlib 2 palette *and*
'  a PP256-based 256-color palette file (.pal) that has just 1,024
'  bytes ONLY!)
'_____________________________________________________________________
Declare Sub CrossFade.Default_to_PP256 (PP256PalFile$, millisec)
Declare Sub CrossFade.PP256_to_Default (PP256PalFile$, millisec)
Declare Sub CrossFadeRange.Default_to_PP256 (StartColor, EndColor, PP256PalFile$, millisec)
Declare Sub CrossFadeRange.PP256_to_Default (StartColor, EndColor, PP256PalFile$, millisec)
Declare Sub CrossFadeCtrl.Default_to_PP256 (FadeToPP256Pal.Grade, PP256PalFile$)
Declare Sub CrossFadeRangeCtrl.Default_to_PP256 (StartColor, EndColor, FadeToPP256Pal.Grade, PP256PalFile$)


'_____________________________________________________________________
' (For crossfading between a 768-byte 256-color palette file (.pal)
'  and a PP256-based 256-color palette file (.pal) that has just 1,024
'  bytes ONLY!)
'_____________________________________________________________________
Declare Sub CrossFade.768Pal_to_PP256 (PalFile$, PP256PalFile$, millisec)
Declare Sub CrossFade.PP256_to_768Pal (PP256PalFile$, PalFile$, millisec)
Declare Sub CrossFadeRange.768Pal_to_PP256 (StartColor, EndColor, PalFile$, PP256PalFile$, millisec)
Declare Sub CrossFadeRange.PP256_to_768Pal (StartColor, EndColor, PP256PalFile$, PalFile$, millisec)
Declare Sub CrossFadeCtrl.768Pal_to_PP256 (FadeToPP256Pal.Grade, PalFile$, PP256PalFile$)
Declare Sub CrossFadeRangeCtrl.768Pal_to_PP256 (StartColor, EndColor, FadeToPP256Pal.Grade, PalFile$, PP256PalFile$)




'
'  C O L O R   A D J U S T   R O U T I N E 
'
Declare Sub WriteColor (Col, R, G, B)




'
'  7 6 8 - B Y T E   P A L E T T E   L O A D I N G
'                                             R O U T I N E 
'
'_____________________________________________________________________
' (The palette file to load here *MUST* be a 256-color palette that
'  has no more than 768 bytes only!)
'_____________________________________________________________________
Declare Sub LoadUp768Pal (PalFile$)




'
'  P P 2 5 6   P A L E T T E   L O A D I N G
'                                         R O U T I N E 
'
'_____________________________________________________________________
' (The palette file to load here *MUST* be a 256-color palette that is
'  PixelPlus 256 (or PP256)-based and has no more than 1,024 bytes!)
'_____________________________________________________________________
Declare Sub LoadUpPP256Pal (PP256PalFile$)




'
'  I M P O R T A N T   C O N S T A N T S   F O R
'               Y O U   T O   R E M E M B E R   H E R E ! ! 
'
CONST FBPM.True = 1, FBPM.False = 0 
CONST Yes = 1, No = 0



'
'  C O L O R   E X T R A C T I O N   F U N C T I O N S
'                            (For default GFXlib 2 palette) 
'
Declare Function GetDefaultPal.Red (TargetCol)
Declare Function GetDefaultPal.Green (TargetCol)
Declare Function GetDefaultPal.Blue (TargetCol)






'
'
'
'
'

'_____________________________________________________________________
Sub ZeroPal
FOR ZeroCol = 0 to 255
  Palette ZeroCol, 0
Next

END SUB

'_____________________________________________________________________
Sub ZeroPalRange (StartColor, EndColor)
If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FOR ZeroCol = StartColor to EndColor
  Palette ZeroCol, 0
Next

END SUB

'_____________________________________________________________________
Sub SolidColorPal (R, G, B)
If R < 0 then R = 0
If R > 63 then R = 63
If G < 0 then G = 0
If G > 63 then G = 63
If B < 0 then B = 0
If B > 63 then B = 63

FOR SolidCol = 0 to 255
  Palette SolidCol, R + (256 * G) + (65536 * B)
Next

END SUB

'_____________________________________________________________________
Sub SolidColorPalRange (StartColor, EndColor, R, G, B)
If R < 0 then R = 0
If R > 63 then R = 63
If G < 0 then G = 0
If G > 63 then G = 63
If B < 0 then B = 0
If B > 63 then B = 63

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FOR SolidCol = StartColor to EndColor
  Palette SolidCol, R + (256 * G) + (65536 * B)
Next

END SUB


'

'_____________________________________________________________________
Sub FadeIn.DefaultPal (millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOut.DefaultPal (millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInX.DefaultPal (R.from, G.from, B.from, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutX.DefaultPal (R.to, G.to, B.to, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.to < 0 then R.to = 0
If R.to > 63 then R.to = 63
If G.to < 0 then G.to = 0
If G.to > 63 then G.to = 63
If B.to < 0 then B.to = 0
If B.to > 63 then B.to = 63

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.to
  P.col2(Col.Entry, 2) = G.to
  P.col2(Col.Entry, 3) = B.to
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInRange.DefaultPal (StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutRange.DefaultPal (StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInRangeX.DefaultPal (StartColor, EndColor, R.from, G.from, B.from, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutRangeX.DefaultPal (StartColor, EndColor, R.to, G.to, B.to, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.to < 0 then R.to = 0
If R.to > 63 then R.to = 63
If G.to < 0 then G.to = 0
If G.to > 63 then G.to = 63
If B.to < 0 then B.to = 0
If B.to > 63 then B.to = 63

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.to
  P.col2(Col.Entry, 2) = G.to
  P.col2(Col.Entry, 3) = B.to
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrl.DefaultPal (FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrlX.DefaultPal (R.from, G.from, B.from, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrlRangeX.DefaultPal (StartColor, EndColor, R.from, G.from, B.from, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalRotate.DefaultPal (StartColor, EndColor, Rotate.Level)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  PALETTE ColorChange, P.col1(RotateColor, 1) + (256 * P.col1(RotateColor, 2)) + (65536 * P.col1(RotateColor, 3))
Next

END SUB

'_____________________________________________________________________
Sub PalRotateFC.DefaultPal (StartColor, EndColor, Rotate.Level, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  Palette ColorChange, INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 1)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 2)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 3)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalRotateFCX.DefaultPal (StartColor, EndColor, R.from, G.from, B.from, Rotate.Level, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  Palette ColorChange, INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 1)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 2)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 3)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalNeg.DefaultPal (Switch)
DIM P.col1(255, 3)

FOR Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
NEXT

FOR ColorChange = 0 TO 255
  IF Switch >= 1 then
    PALETTE ColorChange, 63 - P.col1(ColorChange, 1) + (256 * (63 - P.col1(ColorChange, 2))) + (65536 * (63 - P.col1(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col1(ColorChange, 1) + (256 * (P.col1(ColorChange, 2))) + (65536 * (P.col1(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalNegRange.DefaultPal (StartColor, EndColor, Switch)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FOR Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
NEXT

FOR ColorChange = StartColor TO EndColor
  IF Switch >= 1 then
    PALETTE ColorChange, 63 - P.col1(ColorChange, 1) + (256 * (63 - P.col1(ColorChange, 2))) + (65536 * (63 - P.col1(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col1(ColorChange, 1) + (256 * (P.col1(ColorChange, 2))) + (65536 * (P.col1(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalNegRotate.DefaultPal (StartColor, EndColor, Rotate.Level)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  PALETTE ColorChange, 63 - P.col1(RotateColor, 1) + (256 * (63 - P.col1(RotateColor, 2))) + (65536 * (63 - P.col1(RotateColor, 3)))
Next

END SUB

'_____________________________________________________________________
Sub PalFadeToNega.DefaultPal (millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeFromNega.DefaultPal (millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeToNega.DefaultPal (StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeFromNega.DefaultPal (StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalNegaFadeCtrl.DefaultPal (FadeToNega.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

IF FadeToNega.Grade < 0 then FadeToNega.Grade = 0
IF FadeToNega.Grade > 63 then FadeToNega.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalNegaRangeFadeCtrl.DefaultPal (StartColor, EndColor, FadeToNega.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToNega.Grade < 0 then FadeToNega.Grade = 0
IF FadeToNega.Grade > 63 then FadeToNega.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalGreyScl.DefaultPal (Switch, NegaPalSwitch)
DIM P.col1(255, 3), P.col2(255, 3)

FOR Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
NEXT

IF Switch >= 1 then
  FOR Col.Entry = 0 TO 255
    GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  NEXT
ELSE
  FOR Col.Entry = 0 TO 255
    P.col2(Col.Entry, 1) = P.col1(Col.Entry, 1)
    P.col2(Col.Entry, 2) = P.col1(Col.Entry, 2)
    P.col2(Col.Entry, 3) = P.col1(Col.Entry, 3)
  NEXT
END IF

FOR ColorChange = 0 TO 255
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(ColorChange, 1) + (256 * (63 - P.col2(ColorChange, 2))) + (65536 * (63 - P.col2(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col2(ColorChange, 1) + (256 * (P.col2(ColorChange, 2))) + (65536 * (P.col2(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalGreySclRange.DefaultPal (StartColor, EndColor, Switch, NegaPalSwitch)
DIM P.col1(255, 3), P.col2(255, 3)

FOR Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
NEXT

IF Switch >= 1 then
  FOR Col.Entry = 0 TO 255
    GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  NEXT
ELSE
  FOR Col.Entry = 0 TO 255
    P.col2(Col.Entry, 1) = P.col1(Col.Entry, 1)
    P.col2(Col.Entry, 2) = P.col1(Col.Entry, 2)
    P.col2(Col.Entry, 3) = P.col1(Col.Entry, 3)
  NEXT
END IF
  
If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FOR ColorChange = StartColor TO EndColor
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(ColorChange, 1) + (256 * (63 - P.col2(ColorChange, 2))) + (65536 * (63 - P.col2(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col2(ColorChange, 1) + (256 * (P.col2(ColorChange, 2))) + (65536 * (P.col2(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalGreySclRotate.DefaultPal (StartColor, EndColor, Rotate.Level, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2(255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Col.Entry = 0 TO 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

FOR Col.Entry = 0 TO 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  P.col2(Col.Entry, 1) = GreyScale
  P.col2(Col.Entry, 2) = GreyScale
  P.col2(Col.Entry, 3) = GreyScale
NEXT

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col2(RotateColor, 1) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col2(RotateColor, 2) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col2(RotateColor, 3) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(RotateColor, 1) + (256 * (63 - P.col2(RotateColor, 2))) + (65536 * (63 - P.col2(RotateColor, 3)))
  ELSE
    PALETTE ColorChange, P.col2(RotateColor, 1) + (256 * (P.col2(RotateColor, 2))) + (65536 * (P.col2(RotateColor, 3)))
  END IF
Next

END SUB

'_____________________________________________________________________
Sub PalFadeToGreyScl.DefaultPal (millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeFromGreyScl.DefaultPal (millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeToGreyScl.DefaultPal (StartColor, EndColor, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeFromGreyScl.DefaultPal (StartColor, EndColor, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalGreyFadeCtrl.DefaultPal (FadeToGrey.Grade, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

IF FadeToGrey.Grade < 0 then FadeToGrey.Grade = 0
IF FadeToGrey.Grade > 63 then FadeToGrey.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
SUB PalGreyRangeFadeCtrl.DefaultPal (StartColor, EndColor, FadeToGrey.Grade, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToGrey.Grade < 0 then FadeToGrey.Grade = 0
IF FadeToGrey.Grade > 63 then FadeToGrey.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub FadeIn.768Pal (PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOut.768Pal (PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInX.768Pal (PalFile$, R.from, G.from, B.from, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutX.768Pal (PalFile$, R.to, G.to, B.to, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.to < 0 then R.to = 0
If R.to > 63 then R.to = 63
If G.to < 0 then G.to = 0
If G.to > 63 then G.to = 63
If B.to < 0 then B.to = 0
If B.to > 63 then B.to = 63

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.to
  P.col2(Col.Entry, 2) = G.to
  P.col2(Col.Entry, 3) = B.to
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInRange.768Pal (PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutRange.768Pal (PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInRangeX.768Pal (PalFile$, StartColor, EndColor, R.from, G.from, B.from, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutRangeX.768Pal (PalFile$, StartColor, EndColor, R.to, G.to, B.to, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.to < 0 then R.to = 0
If R.to > 63 then R.to = 63
If G.to < 0 then G.to = 0
If G.to > 63 then G.to = 63
If B.to < 0 then B.to = 0
If B.to > 63 then B.to = 63

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.to
  P.col2(Col.Entry, 2) = G.to
  P.col2(Col.Entry, 3) = B.to
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrl.768Pal (PalFile$, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrlX.768Pal (PalFile$, R.from, G.from, B.from, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrlRangeX.768Pal (PalFile$, StartColor, EndColor, R.from, G.from, B.from, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalRotate.768Pal (PalFile$, StartColor, EndColor, Rotate.Level)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  PALETTE ColorChange, P.col1(RotateColor, 1) + (256 * P.col1(RotateColor, 2)) + (65536 * P.col1(RotateColor, 3))
Next

END SUB

'_____________________________________________________________________
Sub PalRotateFC.768Pal (PalFile$, StartColor, EndColor, Rotate.Level, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  Palette ColorChange, INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 1)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 2)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 3)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalRotateFCX.768Pal (PalFile$, StartColor, EndColor, R.from, G.from, B.from, Rotate.Level, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  Palette ColorChange, INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 1)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 2)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 3)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalNeg.768Pal (PalFile$, Switch)
DIM P.col1(255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FOR ColorChange = 0 TO 255
  IF Switch >= 1 then
    PALETTE ColorChange, 63 - P.col1(ColorChange, 1) + (256 * (63 - P.col1(ColorChange, 2))) + (65536 * (63 - P.col1(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col1(ColorChange, 1) + (256 * (P.col1(ColorChange, 2))) + (65536 * (P.col1(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalNegRange.768Pal (PalFile$, StartColor, EndColor, Switch)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FOR ColorChange = StartColor TO EndColor
  IF Switch >= 1 then
    PALETTE ColorChange, 63 - P.col1(ColorChange, 1) + (256 * (63 - P.col1(ColorChange, 2))) + (65536 * (63 - P.col1(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col1(ColorChange, 1) + (256 * (P.col1(ColorChange, 2))) + (65536 * (P.col1(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalNegRotate.768Pal (PalFile$, StartColor, EndColor, Rotate.Level)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  PALETTE ColorChange, 63 - P.col1(RotateColor, 1) + (256 * (63 - P.col1(RotateColor, 2))) + (65536 * (63 - P.col1(RotateColor, 3)))
Next

END SUB

'_____________________________________________________________________
Sub PalFadeToNega.768Pal (PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeFromNega.768Pal (PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeToNega.768Pal (PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeFromNega.768Pal (PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalNegaFadeCtrl.768Pal (PalFile$, FadeToNega.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

IF FadeToNega.Grade < 0 then FadeToNega.Grade = 0
IF FadeToNega.Grade > 63 then FadeToNega.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalNegaRangeFadeCtrl.768Pal (PalFile$, StartColor, EndColor, FadeToNega.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToNega.Grade < 0 then FadeToNega.Grade = 0
IF FadeToNega.Grade > 63 then FadeToNega.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalGreyScl.768Pal (PalFile$, Switch, NegaPalSwitch)
DIM P.col1(255, 3), P.col2(255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

IF Switch >= 1 then
  FOR Col.Entry = 0 TO 255
    GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  NEXT
ELSE
  FOR Col.Entry = 0 TO 255
    P.col2(Col.Entry, 1) = P.col1(Col.Entry, 1)
    P.col2(Col.Entry, 2) = P.col1(Col.Entry, 2)
    P.col2(Col.Entry, 3) = P.col1(Col.Entry, 3)
  NEXT
END IF

FOR ColorChange = 0 TO 255
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(ColorChange, 1) + (256 * (63 - P.col2(ColorChange, 2))) + (65536 * (63 - P.col2(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col2(ColorChange, 1) + (256 * (P.col2(ColorChange, 2))) + (65536 * (P.col2(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalGreySclRange.768Pal (PalFile$, StartColor, EndColor, Switch, NegaPalSwitch)
DIM P.col1(255, 3), P.col2(255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

IF Switch >= 1 then
  FOR Col.Entry = 0 TO 255
    GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  NEXT
ELSE
  FOR Col.Entry = 0 TO 255
    P.col2(Col.Entry, 1) = P.col1(Col.Entry, 1)
    P.col2(Col.Entry, 2) = P.col1(Col.Entry, 2)
    P.col2(Col.Entry, 3) = P.col1(Col.Entry, 3)
  NEXT
END IF
  
If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FOR ColorChange = StartColor TO EndColor
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(ColorChange, 1) + (256 * (63 - P.col2(ColorChange, 2))) + (65536 * (63 - P.col2(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col2(ColorChange, 1) + (256 * (P.col2(ColorChange, 2))) + (65536 * (P.col2(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalGreySclRotate.768Pal (PalFile$, StartColor, EndColor, Rotate.Level, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2(255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FOR Col.Entry = 0 TO 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  P.col2(Col.Entry, 1) = GreyScale
  P.col2(Col.Entry, 2) = GreyScale
  P.col2(Col.Entry, 3) = GreyScale
NEXT

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col2(RotateColor, 1) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col2(RotateColor, 2) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col2(RotateColor, 3) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(RotateColor, 1) + (256 * (63 - P.col2(RotateColor, 2))) + (65536 * (63 - P.col2(RotateColor, 3)))
  ELSE
    PALETTE ColorChange, P.col2(RotateColor, 1) + (256 * (P.col2(RotateColor, 2))) + (65536 * (P.col2(RotateColor, 3)))
  END IF
Next

END SUB

'_____________________________________________________________________
Sub PalFadeToGreyScl.768Pal (PalFile$, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeFromGreyScl.768Pal (PalFile$, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeToGreyScl.768Pal (PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeFromGreyScl.768Pal (PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalGreyFadeCtrl.768Pal (PalFile$, FadeToGrey.Grade, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

IF FadeToGrey.Grade < 0 then FadeToGrey.Grade = 0
IF FadeToGrey.Grade > 63 then FadeToGrey.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
SUB PalGreyRangeFadeCtrl.768Pal (PalFile$, StartColor, EndColor, FadeToGrey.Grade, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToGrey.Grade < 0 then FadeToGrey.Grade = 0
IF FadeToGrey.Grade > 63 then FadeToGrey.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub CrossFade.Default_to_768Pal (PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFade.768Pal_to_Default (PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.Default_to_768Pal (StartColor, EndColor, PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.768Pal_to_Default (StartColor, EndColor, PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeCtrl.Default_to_768Pal (FadeTo768Pal.Grade, PalFile$)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

IF FadeTo768Pal.Grade < 0 then FadeTo768Pal.Grade = 0
IF FadeTo768Pal.Grade > 63 then FadeTo768Pal.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeTo768Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeTo768Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeTo768Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeTo768Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeTo768Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeTo768Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRangeCtrl.Default_to_768Pal (StartColor, EndColor, FadeTo768Pal.Grade, PalFile$)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeTo768Pal.Grade < 0 then FadeTo768Pal.Grade = 0
IF FadeTo768Pal.Grade > 63 then FadeTo768Pal.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeTo768Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeTo768Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeTo768Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeTo768Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeTo768Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeTo768Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub CrossFade.768Pal_to_768Pal (PalFile.from$, PalFile.to$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.from$ FOR BINARY AS ff    ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.to$ FOR BINARY AS ff      ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.768Pal_to_768Pal (StartColor, EndColor, PalFile.from$, PalFile.to$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.from$ FOR BINARY AS ff    ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.to$ FOR BINARY AS ff      ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeCtrl.768Pal_to_768Pal (FadeTo2nd768Pal.Grade, PalFile.from$, PalFile.to$)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.from$ FOR BINARY AS ff    ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.to$ FOR BINARY AS ff      ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

IF FadeTo2nd768Pal.Grade < 0 then FadeTo2nd768Pal.Grade = 0
IF FadeTo2nd768Pal.Grade > 63 then FadeTo2nd768Pal.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeTo2nd768Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeTo2nd768Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeTo2nd768Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeTo2nd768Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeTo2nd768Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeTo2nd768Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRangeCtrl.768Pal_to_768Pal (StartColor, EndColor, FadeTo2nd768Pal.Grade, PalFile.from$, PalFile.to$)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.from$ FOR BINARY AS ff    ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile.to$ FOR BINARY AS ff      ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col2(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col2(Col.Entry, 2) = ASC(Green$) '   /
    P.col2(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeTo2nd768Pal.Grade < 0 then FadeTo2nd768Pal.Grade = 0
IF FadeTo2nd768Pal.Grade > 63 then FadeTo2nd768Pal.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeTo2nd768Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeTo2nd768Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeTo2nd768Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeTo2nd768Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeTo2nd768Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeTo2nd768Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub FadeIn.PP256 (PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOut.PP256 (PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInX.PP256 (PP256PalFile$, R.from, G.from, B.from, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutX.PP256 (PP256PalFile$, R.to, G.to, B.to, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.to < 0 then R.to = 0
If R.to > 63 then R.to = 63
If G.to < 0 then G.to = 0
If G.to > 63 then G.to = 63
If B.to < 0 then B.to = 0
If B.to > 63 then B.to = 63

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.to
  P.col2(Col.Entry, 2) = G.to
  P.col2(Col.Entry, 3) = B.to
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInRange.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutRange.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeInRangeX.PP256 (PP256PalFile$, StartColor, EndColor, R.from, G.from, B.from, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeOutRangeX.PP256 (PP256PalFile$, StartColor, EndColor, R.to, G.to, B.to, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.to < 0 then R.to = 0
If R.to > 63 then R.to = 63
If G.to < 0 then G.to = 0
If G.to > 63 then G.to = 63
If B.to < 0 then B.to = 0
If B.to > 63 then B.to = 63

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.to
  P.col2(Col.Entry, 2) = G.to
  P.col2(Col.Entry, 3) = B.to
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrl.PP256 (PP256PalFile$, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrlX.PP256 (PP256PalFile$, R.from, G.from, B.from, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub FadeCtrlRangeX.PP256 (PP256PalFile$, StartColor, EndColor, R.from, G.from, B.from, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 1)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 2)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(Col.Entry, 3)) / 63 + (FadeIn.Grade * P.col1(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalRotate.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  PALETTE ColorChange, P.col1(RotateColor, 1) + (256 * P.col1(RotateColor, 2)) + (65536 * P.col1(RotateColor, 3))
Next

END SUB

'_____________________________________________________________________
Sub PalRotateFC.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  Palette ColorChange, INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 1)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 2)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 3)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalRotateFCX.PP256 (PP256PalFile$, StartColor, EndColor, R.from, G.from, B.from, Rotate.Level, FadeIn.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

If R.from < 0 then R.from = 0
If R.from > 63 then R.from = 63
If G.from < 0 then G.from = 0
If G.from > 63 then G.from = 63
If B.from < 0 then B.from = 0
If B.from > 63 then B.from = 63

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = R.from
  P.col2(Col.Entry, 2) = G.from
  P.col2(Col.Entry, 3) = B.from
Next

IF FadeIn.Grade < 0 then FadeIn.Grade = 0
IF FadeIn.Grade > 63 then FadeIn.Grade = 63

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  Palette ColorChange, INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 1)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 1)) / 63) + (256 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 2)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 2)) / 63)) + (65536 * INT(((63 - FadeIn.Grade) * P.col2(ColorChange, 3)) / 63 + (FadeIn.Grade * P.col1(RotateColor, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalNeg.PP256 (PP256PalFile$, Switch)
DIM P.col1(255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

FOR ColorChange = 0 TO 255
  IF Switch >= 1 then
    PALETTE ColorChange, 63 - P.col1(ColorChange, 1) + (256 * (63 - P.col1(ColorChange, 2))) + (65536 * (63 - P.col1(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col1(ColorChange, 1) + (256 * (P.col1(ColorChange, 2))) + (65536 * (P.col1(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalNegRange.PP256 (PP256PalFile$, StartColor, EndColor, Switch)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

FOR ColorChange = StartColor TO EndColor
  IF Switch >= 1 then
    PALETTE ColorChange, 63 - P.col1(ColorChange, 1) + (256 * (63 - P.col1(ColorChange, 2))) + (65536 * (63 - P.col1(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col1(ColorChange, 1) + (256 * (P.col1(ColorChange, 2))) + (65536 * (P.col1(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalNegRotate.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level)
DIM P.col1 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col1(RotateColor, 1) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col1(RotateColor, 2) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col1(RotateColor, 3) = P.col1(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  PALETTE ColorChange, 63 - P.col1(RotateColor, 1) + (256 * (63 - P.col1(RotateColor, 2))) + (65536 * (63 - P.col1(RotateColor, 3)))
Next

END SUB

'_____________________________________________________________________
Sub PalFadeToNega.PP256 (PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeFromNega.PP256 (PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeToNega.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
  	Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeFromNega.PP256 (PP256PalFile$, StartColor, EndColor, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalNegaFadeCtrl.PP256 (PP256PalFile$, FadeToNega.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

IF FadeToNega.Grade < 0 then FadeToNega.Grade = 0
IF FadeToNega.Grade > 63 then FadeToNega.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalNegaRangeFadeCtrl.PP256 (PP256PalFile$, StartColor, EndColor, FadeToNega.Grade)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  P.col2(Col.Entry, 1) = (63 - P.col1(Col.Entry, 1))
  P.col2(Col.Entry, 2) = (63 - P.col1(Col.Entry, 2))
  P.col2(Col.Entry, 3) = (63 - P.col1(Col.Entry, 3))
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToNega.Grade < 0 then FadeToNega.Grade = 0
IF FadeToNega.Grade > 63 then FadeToNega.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToNega.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToNega.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalGreyScl.PP256 (PP256PalFile$, Switch, NegaPalSwitch)
DIM P.col1(255, 3), P.col2(255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

IF Switch >= 1 then
  FOR Col.Entry = 0 TO 255
    GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  NEXT
ELSE
  FOR Col.Entry = 0 TO 255
    P.col2(Col.Entry, 1) = P.col1(Col.Entry, 1)
    P.col2(Col.Entry, 2) = P.col1(Col.Entry, 2)
    P.col2(Col.Entry, 3) = P.col1(Col.Entry, 3)
  NEXT
END IF

FOR ColorChange = 0 TO 255
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(ColorChange, 1) + (256 * (63 - P.col2(ColorChange, 2))) + (65536 * (63 - P.col2(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col2(ColorChange, 1) + (256 * (P.col2(ColorChange, 2))) + (65536 * (P.col2(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalGreySclRange.PP256 (PP256PalFile$, StartColor, EndColor, Switch, NegaPalSwitch)
DIM P.col1(255, 3), P.col2(255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

IF Switch >= 1 then
  FOR Col.Entry = 0 TO 255
    GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  NEXT
ELSE
  FOR Col.Entry = 0 TO 255
    P.col2(Col.Entry, 1) = P.col1(Col.Entry, 1)
    P.col2(Col.Entry, 2) = P.col1(Col.Entry, 2)
    P.col2(Col.Entry, 3) = P.col1(Col.Entry, 3)
  NEXT
END IF
  
If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FOR ColorChange = StartColor TO EndColor
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(ColorChange, 1) + (256 * (63 - P.col2(ColorChange, 2))) + (65536 * (63 - P.col2(ColorChange, 3)))
  ELSE
    PALETTE ColorChange, P.col2(ColorChange, 1) + (256 * (P.col2(ColorChange, 2))) + (65536 * (P.col2(ColorChange, 3)))
  END IF
NEXT

END SUB

'_____________________________________________________________________
Sub PalGreySclRotate.PP256 (PP256PalFile$, StartColor, EndColor, Rotate.Level, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2(255, 3)

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

FOR Col.Entry = 0 TO 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  P.col2(Col.Entry, 1) = GreyScale
  P.col2(Col.Entry, 2) = GreyScale
  P.col2(Col.Entry, 3) = GreyScale
NEXT

ColRotate.Posit = Rotate.Level

For ColorChange = StartColor to EndColor
  ColRotate.Posit = (ColRotate.Posit MOD 256)
  P.col2(RotateColor, 1) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 1)
  P.col2(RotateColor, 2) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 2)
  P.col2(RotateColor, 3) = P.col2(((ColorChange + 512) + ColRotate.Posit) MOD 256, 3)
  IF NegaPalSwitch >= 1 then
    PALETTE ColorChange, 63 - P.col2(RotateColor, 1) + (256 * (63 - P.col2(RotateColor, 2))) + (65536 * (63 - P.col2(RotateColor, 3)))
  ELSE
    PALETTE ColorChange, P.col2(RotateColor, 1) + (256 * (P.col2(RotateColor, 2))) + (65536 * (P.col2(RotateColor, 3)))
  END IF
Next

END SUB

'_____________________________________________________________________
Sub PalFadeToGreyScl.PP256 (PP256PalFile$, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeFromGreyScl.PP256 (PP256PalFile$, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeToGreyScl.PP256 (PP256PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalFadeRangeFromGreyScl.PP256 (PP256PalFile$, StartColor, EndColor, millisec, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub PalGreyFadeCtrl.PP256 (PP256PalFile$, FadeToGrey.Grade, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

IF FadeToGrey.Grade < 0 then FadeToGrey.Grade = 0
IF FadeToGrey.Grade > 63 then FadeToGrey.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub PalGreyRangeFadeCtrl.PP256 (PP256PalFile$, StartColor, EndColor, FadeToGrey.Grade, NegaPalSwitch)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Col.Entry = 0 to 255
  GreyScale = (P.col1(Col.Entry, 1) + P.col1(Col.Entry, 2) + P.col1(Col.Entry, 3)) \ 3
  IF NegaPalSwitch >= 1 then
    P.col2(Col.Entry, 1) = (63 - GreyScale)
    P.col2(Col.Entry, 2) = (63 - GreyScale)
    P.col2(Col.Entry, 3) = (63 - GreyScale)
  ELSE
    P.col2(Col.Entry, 1) = GreyScale
    P.col2(Col.Entry, 2) = GreyScale
    P.col2(Col.Entry, 3) = GreyScale
  END IF
Next

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToGrey.Grade < 0 then FadeToGrey.Grade = 0
IF FadeToGrey.Grade > 63 then FadeToGrey.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToGrey.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToGrey.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub CrossFade.PP256_to_PP256 (PP256PalFile.from$, PP256PalFile.to$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile.from$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

FR = FREEFILE
OPEN PP256PalFile.to$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.PP256_to_PP256 (StartColor, EndColor, PP256PalFile.from$, PP256PalFile.to$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile.from$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

FR = FREEFILE
OPEN PP256PalFile.to$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeCtrl.PP256_to_PP256 (FadeTo2ndPP256Pal.Grade, PP256PalFile.from$, PP256PalFile.to$)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile.from$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

FR = FREEFILE
OPEN PP256PalFile.to$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

IF FadeTo2ndPP256Pal.Grade < 0 then FadeTo2ndPP256Pal.Grade = 0
IF FadeTo2ndPP256Pal.Grade > 63 then FadeTo2ndPP256Pal.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeTo2ndPP256Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeTo2ndPP256Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeTo2ndPP256Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeTo2ndPP256Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeTo2ndPP256Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeTo2ndPP256Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRangeCtrl.PP256_to_PP256 (StartColor, EndColor, FadeTo2ndPP256Pal.Grade, PP256PalFile.from$, PP256PalFile.to$)
DIM P.col1 (255, 3), P.col2 (255, 3)

FR = FREEFILE
OPEN PP256PalFile.from$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col1(Col.Entry, 1) = R
    P.col1(Col.Entry, 2) = G
    P.col1(Col.Entry, 3) = B
  NEXT
CLOSE #FR

FR = FREEFILE
OPEN PP256PalFile.to$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeTo2ndPP256Pal.Grade < 0 then FadeTo2ndPP256Pal.Grade = 0
IF FadeTo2ndPP256Pal.Grade > 63 then FadeTo2ndPP256Pal.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeTo2ndPP256Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeTo2ndPP256Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeTo2ndPP256Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeTo2ndPP256Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeTo2ndPP256Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeTo2ndPP256Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub CrossFade.Default_to_PP256 (PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFade.PP256_to_Default (PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.Default_to_PP256 (StartColor, EndColor, PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.PP256_to_Default (StartColor, EndColor, PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeCtrl.Default_to_PP256 (FadeToPP256Pal.Grade, PP256PalFile$)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

IF FadeToPP256Pal.Grade < 0 then FadeToPP256Pal.Grade = 0
IF FadeToPP256Pal.Grade > 63 then FadeToPP256Pal.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRangeCtrl.Default_to_PP256 (StartColor, EndColor, FadeToPP256Pal.Grade, PP256PalFile$)
DIM P.col1 (255, 3), P.col2 (255, 3)

For Col.Entry = 0 to 255
  P.col1(Col.Entry, 1) = GetDefaultPal.Red(Col.Entry)
  P.col1(Col.Entry, 2) = GetDefaultPal.Green(Col.Entry)
  P.col1(Col.Entry, 3) = GetDefaultPal.Blue(Col.Entry)
Next

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToPP256Pal.Grade < 0 then FadeToPP256Pal.Grade = 0
IF FadeToPP256Pal.Grade > 63 then FadeToPP256Pal.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub CrossFade.768Pal_to_PP256 (PalFile$, PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFade.PP256_to_768Pal (PP256PalFile$, PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

For Fadegrade = 0 to 63
  For Col.Entry = 0 to 255
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.768Pal_to_PP256 (StartColor, EndColor, PalFile$, PP256PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col1(Col.Entry, 1)) / 63 + (Fadegrade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 2)) / 63 + (Fadegrade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col1(Col.Entry, 3)) / 63 + (Fadegrade * P.col2(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRange.PP256_to_768Pal (StartColor, EndColor, PP256PalFile$, PalFile$, millisec)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

For Fadegrade = 0 to 63
  For Col.Entry = StartColor to EndColor
    Palette Col.Entry, INT(((63 - Fadegrade) * P.col2(Col.Entry, 1)) / 63 + (Fadegrade * P.col1(Col.Entry, 1)) / 63) + (256 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 2)) / 63 + (Fadegrade * P.col1(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - Fadegrade) * P.col2(Col.Entry, 3)) / 63 + (Fadegrade * P.col1(Col.Entry, 3)) / 63)) 
  Next
  Sleep millisec
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeCtrl.768Pal_to_PP256 (FadeToPP256Pal.Grade, PalFile$, PP256PalFile$)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

IF FadeToPP256Pal.Grade < 0 then FadeToPP256Pal.Grade = 0
IF FadeToPP256Pal.Grade > 63 then FadeToPP256Pal.Grade = 63

For Col.Entry = 0 to 255
  Palette Col.Entry, INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB

'_____________________________________________________________________
Sub CrossFadeRangeCtrl.768Pal_to_PP256 (StartColor, EndColor, FadeToPP256Pal.Grade, PalFile$, PP256PalFile$)
DIM P.col1 (255, 3), P.col2 (255, 3)

Bc$ = " ": ff = FREEFILE               '\
OPEN PalFile$ FOR BINARY AS ff         ' \
  FOR Col.Entry = 0 TO 255             '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ 
    GET #1, , Bc$: Green$ = Bc$        '    \  This .PAL entry ONLY applies
    GET #1, , Bc$: Blue$ = Bc$         '     > for palettes with 768 bytes!
    P.col1(Col.Entry, 1) = ASC(Red$)   '    /                    ~~~~~~~~~
    P.col1(Col.Entry, 2) = ASC(Green$) '   /
    P.col1(Col.Entry, 3) = ASC(Blue$)  '  /
  NEXT                                 ' /
CLOSE ff                               '/

FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR Col.Entry = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    P.col2(Col.Entry, 1) = R
    P.col2(Col.Entry, 2) = G
    P.col2(Col.Entry, 3) = B
  NEXT
CLOSE #FR

If StartColor < 0 then StartColor = 0
If StartColor > 255 then StartColor = 255
If EndColor < StartColor then EndColor = StartColor 
If EndColor > 255 then EndColor = 255 

IF FadeToPP256Pal.Grade < 0 then FadeToPP256Pal.Grade = 0
IF FadeToPP256Pal.Grade > 63 then FadeToPP256Pal.Grade = 63

For Col.Entry = StartColor to EndColor
  Palette Col.Entry, INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 1)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 1)) / 63) + (256 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 2)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 2)) / 63)) + (65536 * INT(((63 - FadeToPP256Pal.Grade) * P.col1(Col.Entry, 3)) / 63 + (FadeToPP256Pal.Grade * P.col2(Col.Entry, 3)) / 63)) 
Next

END SUB


'

'_____________________________________________________________________
Sub WriteColor (Col, R, G, B)
IF R < 0 then R = 0
IF R > 63 then R = 63
IF G < 0 then G = 0
IF G > 63 then G = 63
IF B < 0 then B = 0
IF B > 63 then B = 63

IF Col < 0 then Col = 0
IF Col > 255 then Col = 255

Palette Col, R + (256 * G) + (65536 * B)

END SUB 


'

'_____________________________________________________________________
Sub LoadUp768Pal (PalFile$)
Bc$ = " ": ff = FREEFILE               '\
OPEN PALFILE$ FOR BINARY AS ff         ' \
  FOR I% = 0 TO 255                    '  \
    GET #1, , Bc$: Red$ = Bc$          '   \ This .PAL entry ONLY applies
    GET #1, , Bc$: Green$ = Bc$        '    >for palettes with 768 bytes!
    GET #1, , Bc$: Blue$ = Bc$         '   /                    ~~~~~~~~~
    Palette I%, ASC(Red$) + (256 * ASC(Green$)) + (65536 * ASC(Blue$))
  NEXT I%                              ' /
CLOSE ff                               '/

END SUB


'

'_____________________________________________________________________
Sub LoadUpPP256Pal (PP256PalFile$)
FR = FREEFILE
OPEN PP256PalFile$ FOR BINARY AS #FR
  FOR n = 0 TO 255
    GET #FR, , C
    B = C \ 65536: C = C - B * 65536
    G = C \ 256: C = C - G * 256
    R = C
    Palette n, R + (256 * G) + (65536 * B)
  NEXT
CLOSE #FR

END SUB

'

'_____________________________________________________________________
Function GetDefaultPal.Blue (TargetCol)
Select Case as CONST TargetCol
  Case 0: GetDefaultPal.Blue = 0
  Case 1: GetDefaultPal.Blue = 42
  Case 2: GetDefaultPal.Blue = 0
  Case 3: GetDefaultPal.Blue = 42
  Case 4: GetDefaultPal.Blue = 0
  Case 5: GetDefaultPal.Blue = 42
  Case 6: GetDefaultPal.Blue = 0
  Case 7: GetDefaultPal.Blue = 42
  Case 8: GetDefaultPal.Blue = 21
  Case 9: GetDefaultPal.Blue = 63
  Case 10: GetDefaultPal.Blue = 21
  Case 11: GetDefaultPal.Blue = 63
  Case 12: GetDefaultPal.Blue = 21
  Case 13: GetDefaultPal.Blue = 63
  Case 14: GetDefaultPal.Blue = 21
  Case 15: GetDefaultPal.Blue = 63
  Case 16: GetDefaultPal.Blue = 0
  Case 17: GetDefaultPal.Blue = 5
  Case 18: GetDefaultPal.Blue = 8
  Case 19: GetDefaultPal.Blue = 11
  Case 20: GetDefaultPal.Blue = 14
  Case 21: GetDefaultPal.Blue = 17
  Case 22: GetDefaultPal.Blue = 20
  Case 23: GetDefaultPal.Blue = 24
  Case 24: GetDefaultPal.Blue = 28
  Case 25: GetDefaultPal.Blue = 32
  Case 26: GetDefaultPal.Blue = 36
  Case 27: GetDefaultPal.Blue = 40
  Case 28: GetDefaultPal.Blue = 45
  Case 29: GetDefaultPal.Blue = 50
  Case 30: GetDefaultPal.Blue = 56
  Case 31 TO 36: GetDefaultPal.Blue = 63
  Case 37: GetDefaultPal.Blue = 47
  Case 38: GetDefaultPal.Blue = 31
  Case 39: GetDefaultPal.Blue = 16
  Case 40 TO 48: GetDefaultPal.Blue = 0
  Case 49: GetDefaultPal.Blue = 16
  Case 50: GetDefaultPal.Blue = 31
  Case 51: GetDefaultPal.Blue = 47
  Case 52 TO 60: GetDefaultPal.Blue = 63
  Case 61: GetDefaultPal.Blue = 55
  Case 62: GetDefaultPal.Blue = 47
  Case 63: GetDefaultPal.Blue = 39
  Case 64 TO 72: GetDefaultPal.Blue = 31
  Case 73: GetDefaultPal.Blue = 39
  Case 74: GetDefaultPal.Blue = 47
  Case 75: GetDefaultPal.Blue = 55
  Case 76 TO 84: GetDefaultPal.Blue = 63
  Case 85: GetDefaultPal.Blue = 58
  Case 86: GetDefaultPal.Blue = 54
  Case 87: GetDefaultPal.Blue = 49
  Case 88 TO 96: GetDefaultPal.Blue = 45
  Case 97: GetDefaultPal.Blue = 49
  Case 98: GetDefaultPal.Blue = 54
  Case 99: GetDefaultPal.Blue = 58
  Case 100 TO 103: GetDefaultPal.Blue = 63
  Case 104 TO 108: GetDefaultPal.Blue = 28
  Case 109: GetDefaultPal.Blue = 21
  Case 110: GetDefaultPal.Blue = 14
  Case 111: GetDefaultPal.Blue = 7
  Case 112 TO 120: GetDefaultPal.Blue = 0
  Case 121: GetDefaultPal.Blue = 7
  Case 122: GetDefaultPal.Blue = 14
  Case 123: GetDefaultPal.Blue = 21
  Case 124 TO 132: GetDefaultPal.Blue = 28
  Case 133: GetDefaultPal.Blue = 24
  Case 134: GetDefaultPal.Blue = 21
  Case 135: GetDefaultPal.Blue = 17
  Case 136 TO 144: GetDefaultPal.Blue = 14
  Case 145: GetDefaultPal.Blue = 17
  Case 146: GetDefaultPal.Blue = 21
  Case 147: GetDefaultPal.Blue = 24
  Case 148 TO 156: GetDefaultPal.Blue = 28
  Case 157: GetDefaultPal.Blue = 26
  Case 158: GetDefaultPal.Blue = 24
  Case 159: GetDefaultPal.Blue = 22
  Case 160 TO 168: GetDefaultPal.Blue = 20
  Case 169: GetDefaultPal.Blue = 22
  Case 170: GetDefaultPal.Blue = 24
  Case 171: GetDefaultPal.Blue = 26
  Case 172 TO 175: GetDefaultPal.Blue = 28
  Case 176 TO 180: GetDefaultPal.Blue = 16
  Case 181: GetDefaultPal.Blue = 12
  Case 182: GetDefaultPal.Blue = 8
  Case 183: GetDefaultPal.Blue = 4
  Case 184 TO 192: GetDefaultPal.Blue = 0
  Case 193: GetDefaultPal.Blue = 4
  Case 194: GetDefaultPal.Blue = 8
  Case 195: GetDefaultPal.Blue = 12
  Case 196 TO 204: GetDefaultPal.Blue = 16
  Case 205: GetDefaultPal.Blue = 14
  Case 206: GetDefaultPal.Blue = 12
  Case 207: GetDefaultPal.Blue = 10
  Case 208 TO 216: GetDefaultPal.Blue = 8
  Case 217: GetDefaultPal.Blue = 10
  Case 218: GetDefaultPal.Blue = 12
  Case 219: GetDefaultPal.Blue = 14
  Case 220 TO 228: GetDefaultPal.Blue = 16
  Case 229: GetDefaultPal.Blue = 15
  Case 230: GetDefaultPal.Blue = 13
  Case 231: GetDefaultPal.Blue = 12
  Case 232 TO 240: GetDefaultPal.Blue = 11
  Case 241: GetDefaultPal.Blue = 12
  Case 242: GetDefaultPal.Blue = 13
  Case 243: GetDefaultPal.Blue = 15
  Case 244 TO 247: GetDefaultPal.Blue = 16
  Case 248 TO 255: GetDefaultPal.Blue = 0
End Select

END FUNCTION

'_____________________________________________________________________
Function GetDefaultPal.Green (TargetCol)
Select Case as CONST TargetCol
  Case 0 TO 1: GetDefaultPal.Green = 0
  Case 2 TO 3: GetDefaultPal.Green = 42
  Case 4 TO 5: GetDefaultPal.Green = 0
  Case 6: GetDefaultPal.Green = 21
  Case 7: GetDefaultPal.Green = 42
  Case 8 TO 9: GetDefaultPal.Green = 21
  Case 10 TO 11: GetDefaultPal.Green = 63
  Case 12 TO 13: GetDefaultPal.Green = 21
  Case 14 TO 15: GetDefaultPal.Green = 63
  Case 16: GetDefaultPal.Green = 0
  Case 17: GetDefaultPal.Green = 5
  Case 18: GetDefaultPal.Green = 8
  Case 19: GetDefaultPal.Green = 11
  Case 20: GetDefaultPal.Green = 14
  Case 21: GetDefaultPal.Green = 17
  Case 22: GetDefaultPal.Green = 20
  Case 23: GetDefaultPal.Green = 24
  Case 24: GetDefaultPal.Green = 28
  Case 25: GetDefaultPal.Green = 32
  Case 26: GetDefaultPal.Green = 36
  Case 27: GetDefaultPal.Green = 40
  Case 28: GetDefaultPal.Green = 45
  Case 29: GetDefaultPal.Green = 50
  Case 30: GetDefaultPal.Green = 56
  Case 31: GetDefaultPal.Green = 63
  Case 32 TO 40: GetDefaultPal.Green = 0
  Case 41: GetDefaultPal.Green = 16
  Case 42: GetDefaultPal.Green = 31
  Case 43: GetDefaultPal.Green = 47
  Case 44 TO 52: GetDefaultPal.Green = 63
  Case 53: GetDefaultPal.Green = 47
  Case 54: GetDefaultPal.Green = 31
  Case 55: GetDefaultPal.Green = 16
  Case 56 TO 64: GetDefaultPal.Green = 31
  Case 65: GetDefaultPal.Green = 39
  Case 66: GetDefaultPal.Green = 47
  Case 67: GetDefaultPal.Green = 55
  Case 68 TO 76: GetDefaultPal.Green = 63
  Case 77: GetDefaultPal.Green = 55
  Case 78: GetDefaultPal.Green = 47
  Case 79: GetDefaultPal.Green = 39
  Case 80 TO 88: GetDefaultPal.Green = 45
  Case 89: GetDefaultPal.Green = 49
  Case 90: GetDefaultPal.Green = 54
  Case 91: GetDefaultPal.Green = 58
  Case 92 TO 100: GetDefaultPal.Green = 63
  Case 101: GetDefaultPal.Green = 58
  Case 102: GetDefaultPal.Green = 54
  Case 103: GetDefaultPal.Green = 49
  Case 104 TO 112: GetDefaultPal.Green = 0
  Case 113: GetDefaultPal.Green = 7
  Case 114: GetDefaultPal.Green = 14
  Case 115: GetDefaultPal.Green = 21
  Case 116 TO 124: GetDefaultPal.Green = 28
  Case 125: GetDefaultPal.Green = 21
  Case 126: GetDefaultPal.Green = 14
  Case 127: GetDefaultPal.Green = 7
  Case 128 TO 136: GetDefaultPal.Green = 14
  Case 137: GetDefaultPal.Green = 17
  Case 138: GetDefaultPal.Green = 21
  Case 139: GetDefaultPal.Green = 24
  Case 140 TO 148: GetDefaultPal.Green = 28
  Case 149: GetDefaultPal.Green = 24
  Case 150: GetDefaultPal.Green = 21
  Case 151: GetDefaultPal.Green = 17
  Case 152 TO 160: GetDefaultPal.Green = 20
  Case 161: GetDefaultPal.Green = 22
  Case 162: GetDefaultPal.Green = 24
  Case 163: GetDefaultPal.Green = 26
  Case 164 TO 172: GetDefaultPal.Green = 28
  Case 173: GetDefaultPal.Green = 26
  Case 174: GetDefaultPal.Green = 24
  Case 175: GetDefaultPal.Green = 22
  Case 176 TO 184: GetDefaultPal.Green = 0
  Case 185: GetDefaultPal.Green = 4
  Case 186: GetDefaultPal.Green = 8
  Case 187: GetDefaultPal.Green = 12
  Case 188 TO 196: GetDefaultPal.Green = 16
  Case 197: GetDefaultPal.Green = 12
  Case 198: GetDefaultPal.Green = 8
  Case 199: GetDefaultPal.Green = 4
  Case 200 TO 208: GetDefaultPal.Green = 8
  Case 209: GetDefaultPal.Green = 10
  Case 210: GetDefaultPal.Green = 12
  Case 211: GetDefaultPal.Green = 14
  Case 212 TO 220: GetDefaultPal.Green = 16
  Case 221: GetDefaultPal.Green = 14
  Case 222: GetDefaultPal.Green = 12
  Case 223: GetDefaultPal.Green = 10
  Case 224 TO 232: GetDefaultPal.Green = 11
  Case 233: GetDefaultPal.Green = 12
  Case 234: GetDefaultPal.Green = 13
  Case 235: GetDefaultPal.Green = 15
  Case 236 TO 244: GetDefaultPal.Green = 16
  Case 245: GetDefaultPal.Green = 15
  Case 246: GetDefaultPal.Green = 13
  Case 247: GetDefaultPal.Green = 12
  Case 248 TO 255: GetDefaultPal.Green = 0
End Select

END FUNCTION

'_____________________________________________________________________
Function GetDefaultPal.Red (TargetCol)
Select Case as CONST TargetCol
  Case 0 TO 3: GetDefaultPal.Red = 0
  Case 4 TO 7: GetDefaultPal.Red = 42
  Case 8 TO 11: GetDefaultPal.Red = 21
  Case 12 TO 15: GetDefaultPal.Red = 63
  Case 16: GetDefaultPal.Red = 0
  Case 17: GetDefaultPal.Red = 5
  Case 18: GetDefaultPal.Red = 8
  Case 19: GetDefaultPal.Red = 11
  Case 20: GetDefaultPal.Red = 14
  Case 21: GetDefaultPal.Red = 17
  Case 22: GetDefaultPal.Red = 20
  Case 23: GetDefaultPal.Red = 24
  Case 24: GetDefaultPal.Red = 28
  Case 25: GetDefaultPal.Red = 32
  Case 26: GetDefaultPal.Red = 36
  Case 27: GetDefaultPal.Red = 40
  Case 28: GetDefaultPal.Red = 45
  Case 29: GetDefaultPal.Red = 50
  Case 30: GetDefaultPal.Red = 56
  Case 31: GetDefaultPal.Red = 63
  Case 32: GetDefaultPal.Red = 0
  Case 33: GetDefaultPal.Red = 16
  Case 34: GetDefaultPal.Red = 31
  Case 35: GetDefaultPal.Red = 47
  Case 36 TO 44: GetDefaultPal.Red = 63
  Case 45: GetDefaultPal.Red = 47
  Case 46: GetDefaultPal.Red = 31
  Case 47: GetDefaultPal.Red = 16
  Case 48 TO 55: GetDefaultPal.Red = 0
  Case 56: GetDefaultPal.Red = 31
  Case 57: GetDefaultPal.Red = 39
  Case 58: GetDefaultPal.Red = 47
  Case 59: GetDefaultPal.Red = 55
  Case 60 TO 68: GetDefaultPal.Red = 63
  Case 69: GetDefaultPal.Red = 55
  Case 70: GetDefaultPal.Red = 47
  Case 71: GetDefaultPal.Red = 39
  Case 72 TO 79: GetDefaultPal.Red = 31
  Case 80: GetDefaultPal.Red = 45
  Case 81: GetDefaultPal.Red = 49
  Case 82: GetDefaultPal.Red = 54
  Case 83: GetDefaultPal.Red = 58
  Case 84 TO 92: GetDefaultPal.Red = 63
  Case 93: GetDefaultPal.Red = 58
  Case 94: GetDefaultPal.Red = 54
  Case 95: GetDefaultPal.Red = 49
  Case 96 TO 103: GetDefaultPal.Red = 45
  Case 104: GetDefaultPal.Red = 0
  Case 105: GetDefaultPal.Red = 7
  Case 106: GetDefaultPal.Red = 14
  Case 107: GetDefaultPal.Red = 21
  Case 108 TO 116: GetDefaultPal.Red = 28
  Case 117: GetDefaultPal.Red = 21
  Case 118: GetDefaultPal.Red = 14
  Case 119: GetDefaultPal.Red = 7
  Case 120 TO 127: GetDefaultPal.Red = 0
  Case 128: GetDefaultPal.Red = 14
  Case 129: GetDefaultPal.Red = 17
  Case 130: GetDefaultPal.Red = 21
  Case 131: GetDefaultPal.Red = 24
  Case 132 TO 140: GetDefaultPal.Red = 28
  Case 141: GetDefaultPal.Red = 24
  Case 142: GetDefaultPal.Red = 21
  Case 143: GetDefaultPal.Red = 17
  Case 144 TO 151: GetDefaultPal.Red = 14
  Case 152: GetDefaultPal.Red = 20
  Case 153: GetDefaultPal.Red = 22
  Case 154: GetDefaultPal.Red = 24
  Case 155: GetDefaultPal.Red = 26
  Case 156 TO 164: GetDefaultPal.Red = 28
  Case 165: GetDefaultPal.Red = 26
  Case 166: GetDefaultPal.Red = 24
  Case 167: GetDefaultPal.Red = 22
  Case 168 TO 175: GetDefaultPal.Red = 20
  Case 176: GetDefaultPal.Red = 0
  Case 177: GetDefaultPal.Red = 4
  Case 178: GetDefaultPal.Red = 8
  Case 179: GetDefaultPal.Red = 12
  Case 180 TO 188: GetDefaultPal.Red = 16
  Case 189: GetDefaultPal.Red = 12
  Case 190: GetDefaultPal.Red = 8
  Case 191: GetDefaultPal.Red = 4
  Case 192 TO 199: GetDefaultPal.Red = 0
  Case 200: GetDefaultPal.Red = 8
  Case 201: GetDefaultPal.Red = 10
  Case 202: GetDefaultPal.Red = 12
  Case 203: GetDefaultPal.Red = 14
  Case 204 TO 212: GetDefaultPal.Red = 16
  Case 213: GetDefaultPal.Red = 14
  Case 214: GetDefaultPal.Red = 12
  Case 215: GetDefaultPal.Red = 10
  Case 216 TO 223: GetDefaultPal.Red = 8
  Case 224: GetDefaultPal.Red = 11
  Case 225: GetDefaultPal.Red = 12
  Case 226: GetDefaultPal.Red = 13
  Case 227: GetDefaultPal.Red = 15
  Case 228 TO 236: GetDefaultPal.Red = 16
  Case 237: GetDefaultPal.Red = 15
  Case 238: GetDefaultPal.Red = 13
  Case 239: GetDefaultPal.Red = 12
  Case 240 TO 247: GetDefaultPal.Red = 11
  Case 248 TO 255: GetDefaultPal.Red = 0
End Select

END FUNCTION
