

DEFINT A - Z

Option Explicit
#include once "vector3d.bi"

Type Quaternion
	 x		   as single
	 y		   as single
	 z		   as single
	 w		   as single
End Type

declare sub quat_multiply ( Byref Qout as Quaternion, Byref Q1 as Quaternion, Byref Q2 as Quaternion )
declare sub quat_add ( Byref Qout as Quaternion, Byref Q1 as Quaternion, Byref Q2 as Quaternion )
declare sub quat_axis2quat ( Byref Q as Quaternion, Byref axis as vector3d, Byval radians as single )
declare function quat_magnitude ( Byref Q as Quaternion ) as single
declare sub quat_normalize ( Byref Q as Quaternion )
declare sub quat_conjugate ( Byref Q as Quaternion )
declare sub quat_cross ( Byref Qout as Quaternion, Byref Q1 as Quaternion, Byref Q2 as Quaternion )
declare sub quat_rotate ( Byref Q as Quaternion, Byval degree as integer, Byval ax as single, Byval ay as single, Byval az as single )
declare sub quat_euler2quat ( Byref Q as Quaternion, Byval x as single, Byval y as single, Byval z as single )
declare sub quat_quat2mat ( Byref Q as Quaternion, matrix() as single )
declare sub quat_get_right_vec( Byref v as Vector3d, Byref q as Quaternion )
declare sub quat_get_up_vec( Byref v as Vector3d, Byref q as Quaternion )
declare sub quat_get_forward_vec( Byref v as Vector3d, Byref q as Quaternion )


'*********************************************************************************
sub quat_multiply ( Byref Qout as Quaternion, Byref Q1 as Quaternion, Byref Q2 as Quaternion )

	Qout.x = Q1.w * Q2.x + Q1.x * Q2.w + Q1.y * Q2.z - Q1.z * Q2.y
	Qout.y = Q1.w * Q2.y - Q1.x * Q2.z + Q1.y * Q2.w + Q1.z * Q2.x
	Qout.z = Q1.w * Q2.z + Q1.x * Q2.y - Q1.y * Q2.x + Q1.z * Q2.w
	Qout.w = Q1.w * Q2.w - Q1.x * Q2.x - Q1.y * Q2.y - Q1.z * Q2.z

end sub

sub quat_add ( Byref Qout as Quaternion, Byref Q1 as Quaternion, Byref Q2 as Quaternion )

	dim v1 as vector3d
	dim v2 as vector3d
	dim v3 as vector3d
	dim cross as vector3d
	v1.x = Q1.x : v1.y = Q1.y : v1.z = Q1.z
	v2.x = Q2.x : v2.y = Q2.y : v2.z = Q2.z
	v3.x = 0 : v2.y = 0 : v2.z = 0
	vector_cross ( cross, v1, v2 )

	v1.x = v1.x  * q2.w
	v1.y = v1.y  * q2.w
	v1.z = v1.z  * q2.w

	v2.x = v2.x  * q1.w
	v2.y = v2.y  * q1.w
	v2.z = v2.z  * q1.w

	'v3 = v1 + v2
	vector_add ( v3, v1, v2 )
	'v3 = cross + v3
	vector_add ( v3, cross, v3 )

    qout.w = q1.w * q2.w - (q1.x * q2.x + q1.y * q2.y + q1.z * q2.z)

    qout.x = v3.x
	qout.y = v3.y
	qout.z = v3.z


end sub


sub quat_axis2quat ( Byref Q as Quaternion, Byref axis as vector3d, Byval radians as single )
	dim sine as single
	radians = radians * 0.5
	sine = sin(radians)
	vector_normalize ( axis )
	Q.x = axis.x * sine
	Q.y = axis.y * sine
	Q.z = axis.z * sine
	Q.w = cos ( radians )
end sub

function quat_magnitude ( Byref Q as Quaternion ) as single
	quat_magnitude = sqr( Q.x^2 + Q.y^2 + Q.z^2 + Q.w^2 )
end function

sub quat_normalize ( Byref Q as Quaternion )
	dim inv_leng as single
	inv_leng = 1 / sqr( Q.x^2 + Q.y^2 + Q.z^2 + Q.w^2 )
	Q.x = Q.x * inv_leng
	Q.y = Q.y * inv_leng
	Q.z = Q.z * inv_leng
	Q.w = Q.w * inv_leng
end sub


sub quat_conjugate ( Byref Q as Quaternion )
	Q.x = -Q.x
	Q.y = -Q.y
	Q.z = -Q.z
	Q.w = -Q.w
end sub

sub quat_cross ( Byref Qout as Quaternion, Byref Q1 as Quaternion, Byref Q2 as Quaternion )

	with Qout
    	 .x = q1.w * q2.x + q1.x * q2.w + q1.y * q2.z - q1.z * q2.y
         .y = q1.w * q2.y + q1.x * q2.z + q1.y * q2.w - q1.z * q2.x
         .z = q1.w * q2.z + q1.x * q2.y + q1.y * q2.x - q1.z * q2.w
         .w = q1.w * q2.w - q1.x * q2.x - q1.y * q2.y - q1.z * q2.z
	end with

end sub


sub quat_rotate ( Byref Q as Quaternion, Byval degree as integer, Byval ax as single, Byval ay as single, Byval az as single )

	if (ax + ay + az) <> 1 then
		dim inv_leng as single
		inv_leng = 1 / sqr( ax^2 + ay^2 + az^2 )
		ax = ax * inv_leng
		ay = ay * inv_leng
		az = az * inv_leng
	end if
	'convert degrees to radians
	dim half_angle as single
	dim half_sine  as single

	half_angle = degree * 3.141592654 / 180.0
	half_angle = half_angle * 0.5
	half_sine = sin(half_angle)
    'quaternion.
	q.x = ax * half_sine
    q.y = ay * half_sine
    q.z = az * half_sine
    q.w = cos(half_angle)


end sub

sub quat_euler2quat ( Byref Q as Quaternion, Byval x as single, Byval y as single, Byval z as single )
	dim sx as single, sy as single, sz as single
	dim cx as single, cy as single, cz as single
	dim sxy as single
	dim cxy as single
	dim half_x as single, half_y as single, half_z as single
	half_x = x * 0.5
	half_y = y * 0.5
	half_z = z * 0.5

    sx = sin(half_x)
    cx = cos(half_x)

    sy = sin(half_y)
    cy = cos(half_y)

    sz = sin(half_z)
    cz = cos(half_z)

    cxy = cx * cy
    sxy = sx * sy

    q.x = sx * cy * cz - cx * sy * sz
    q.y = cx * sy * cz + sx * cy * sz
    q.z = cxy * sz - sxy * cz
    q.w = cxy * cz + sxy * sz

end sub

sub quat_quat2mat ( Byref Q as Quaternion, matrix() as single )

    matrix(0)  = 1.0 - 2.0 * (Q.y * Q.y + Q.z * Q.z)   		  'r.x
    matrix(1)  = 2.0 * (Q.x * Q.y + Q.z * Q.w)                'u.x
    matrix(2)  = 2.0 * (Q.x * Q.z - Q.y * Q.w)                'f.x
    matrix(3)  = 0.0

    matrix(4)  = 2.0 * (Q.x * Q.y - Q.z * Q.w)				  'r.y
    matrix(5)  = 1.0 - 2.0 * (Q.x * Q.x + Q.z * Q.z) 		  'u.y
    matrix(6)  = 2.0 * (Q.z * Q.y + Q.x * Q.w)				  'f.y
    matrix(7)  = 0.0

    matrix(8)  = 2.0 * (Q.x * Q.z + Q.y * Q.w)				  'r.z
    matrix(9)  = 2.0 * (Q.y * Q.z - Q.x * Q.w)				  'u.z
    matrix(10) = 1.0 - 2.0 * (Q.x * Q.x + Q.y * Q.y)		  'f.z
    matrix(11) = 0.0

	matrix(12) = 0
    matrix(13) = 0
    matrix(14) = 0
    matrix(15) = 1.0


end sub

sub quat_get_right_vec( Byref v as Vector3d, Byref q as Quaternion )
	v.x = 1.0 - 2.0 * (Q.y * Q.y + Q.z * Q.z)   	  'r.x
	v.y = 2.0 * (Q.x * Q.y - Q.z * Q.w)				  'r.y
	v.z = 2.0 * (Q.x * Q.z + Q.y * Q.w)				  'r.z
end sub

sub quat_get_up_vec( Byref v as Vector3d, Byref q as Quaternion )
	v.x = 2.0 * (Q.x * Q.y + Q.z * Q.w)               'u.x
	v.y = 1.0 - 2.0 * (Q.x * Q.x + Q.z * Q.z) 		  'u.y
	v.z = 2.0 * (Q.y * Q.z - Q.x * Q.w)				  'u.z
end sub

sub quat_get_forward_vec( Byref v as Vector3d, Byref q as Quaternion )
	v.x = 2.0 * (Q.x * Q.z - Q.y * Q.w)               'f.x
	v.y = 2.0 * (Q.z * Q.y + Q.x * Q.w)				  'f.y
	v.z = 1.0 - 2.0 * (Q.x * Q.x + Q.y * Q.y)		  'f.z
end sub

