DECLARE SUB ENGINEInit ()
DECLARE SUB ENGINEEnd ()
DECLARE SUB TERRAINLoad (filename AS STRING)
DECLARE SUB TERRAINDraw ()
DECLARE SUB TERRAINAddTexture (filename AS STRING)

'$INCLUDE: 'ugl.bi'
'$INCLUDE: 'mouse.bi'
'$INCLUDE: '..\bi\typedef.bi'
'$INCLUDE: '..\bi\clipper.bi'
'$INCLUDE: '..\bi\math3d.bi'
'$INCLUDE: '..\bi\heap.bi'
'$INCLUDE: '..\bi\graphic.bi'


TYPE RTSTERRAIN3D
	hTerrainDC AS LONG
	TerrainX AS LONG
	TerrainY AS LONG
	AnzTextures AS LONG
	TexChangeLevel AS SINGLE
	cfmt AS INTEGER
END TYPE

'//----------------------------------------------------------
'//                     Konstanten
'//----------------------------------------------------------
CONST DEGTORAD = 3.141593 / 180              '// Grad in Bogenma
CONST TILESIZE = 16                          '// Gre eines Tiles
CONST MAXPOLYS = 550

'//----------------------------------------------------------
'//                     globale Variablen
'//----------------------------------------------------------
'$DYNAMIC
DIM SHARED heap(0 TO MAXPOLYS) AS HEAPNODE             '// Heap ;)
DIM SHARED tp(0 TO MAXPOLYS) AS POLYGON3D         '// Erstellte Polys->Terrain
DIM SHARED hTexDC(10) AS LONG                 '// Array aller TextureDCs
DIM SHARED terrain AS RTSTERRAIN3D
DIM SHARED env AS ENVIRONMENT3D
DIM SHARED mouse AS MOUSEINF
DIM SHARED matView AS MATRIX3D
DIM SHARED matRotX AS MATRIX3D
DIM SHARED matRotZ AS MATRIX3D
DIM SHARED matRotXZ AS MATRIX3D
DIM SHARED matTrans AS MATRIX3D
DIM SHARED tm#
DIM SHARED fps&
DIM SHARED vx AS SINGLE, vy AS SINGLE, vz AS SINGLE
DIM SHARED angle AS SINGLE

'$STATIC
'//----------------------------------------------------------
'//                           Main
'//----------------------------------------------------------
ENGINEInit

IF LCASE$(COMMAND$) = "" THEN
	TERRAINLoad "terr.th"
ELSE
	TERRAINLoad COMMAND$
END IF

TERRAINDraw

ENGINEEnd

PRINT "fps:" + STR$(CLNG(fps& / tm#))
PRINT "vx:" + STR$(vx) + " vy:" + STR$(vy) + " vz:" + STR$(vz)
PRINT "angle:" + STR$(angle)
SLEEP
END

ErrorHandle:
	RESUME NEXT

SUB ENGINEEnd

	'// mouse deinitialsieren
	mouseend

	'// ugl etc. beenden
	GRAPHICEnd
END SUB

SUB ENGINEInit

	'// Konfigurationsdatei fnnen
	'// und Auflsung auslesen
	OPEN "config.txt" FOR INPUT AS #1
		INPUT #1, xRes%, yRes%, terrain.cfmt
	CLOSE #1

	'// ugl und environment initialisieren
	IF (GRAPHICInit(xRes%, yRes%, terrain.cfmt, 1, env) = 0) THEN
		GRAPHICEnd
		END
	END IF

	'// mouse starten
	IF (mouseInit%(env.hVideoDC, mouse) = 0) THEN
		GRAPHICEnd
		END
	END IF
	 
	'// Heap initialisieren
	HEAPInit heap(0), MAXPOLYS - 1

	'// NearClippingPlane setzen
	CLIPSetZNear 10

END SUB

SUB TERRAINAddTexture (filename AS STRING)
	hTexDC(terrain.AnzTextures) = uglNewBMP(UGL.EMS, terrain.cfmt, filename)
	IF (hTexDC(terrain.AnzTextures) = FALSE) THEN
		ENGINEEnd
		END
	END IF
	terrain.AnzTextures = terrain.AnzTextures + 1
END SUB

SUB TERRAINDraw

	ON ERROR GOTO ErrorHandle

	DIM p(0 TO 1) AS POLYGON3D
	DIM cp(0 TO 1) AS POLYGON3D
	DIM nw AS SINGLE, no AS SINGLE, so AS SINGLE, sw AS SINGLE
	DIM aHeight(MAXPOLYS) AS INTEGER
	DIM ViewTri AS TriType
	DIM mapx AS SINGLE, mapy AS SINGLE
	DIM gx AS INTEGER, gy AS INTEGER
	DIM hTexturDC AS LONG
	DIM index AS INTEGER

	vx = 123: vy = 115: vz = 204
	angle = 10

	tm# = TIMER
	DO
	fps& = fps& + 1

	'//HEAP zurck setzen
	HEAPReset

	'// Matrizen setzen

		'// Verschiebung der Welt insgesamt
		MATRIX3DIdentity matTrans
		matTrans.m41 = -vx: matTrans.m42 = -vy: matTrans.m43 = vz

		'// Rotationsmatrix setzen um Welt ein
		'// wenig nach hinten zu neigen
		MATRIX3DRotationX matRotX, DEGTORAD * angle

		'// Matrizen konkatenieren
		MATRIX3DMultiply matView, matRotX, matTrans

	taste$ = INKEY$

	IF taste$ = "w" THEN vz = vz - 1:
	IF taste$ = "s" THEN vz = vz + 1:
	IF taste$ = "a" THEN vx = vx + 1:
	IF taste$ = "d" THEN vx = vx - 1:
	IF taste$ = "o" THEN vy = vy + 1:
	IF taste$ = "l" THEN vy = vy - 1:
	IF taste$ = "p" THEN angle = angle + 1:
	IF taste$ = "" THEN angle = angle - 1:

	'// Bewegung des Viewers
	IF mouse.y < 10 THEN
		mapy = mapy + 4
	END IF
	IF mouse.y > env.screeny - 10 THEN
		mapy = mapy - 4
		IF mapy < 0 THEN
			mapy = 0
		END IF
	END IF
	IF mouse.x < 10 THEN
		mapx = mapx - 4
		IF mapx < 0 THEN
			mapx = 0
		END IF
	END IF
	IF mouse.x > env.screenx - 10 THEN
		mapx = mapx + 4
	END IF

	'// Offset auf der Terrainheightmap errechnen
	gx = mapx \ TILESIZE
	gy = mapy \ TILESIZE

	index = 0

	'// Polygone erstellen
	FOR y = 0 TO 15
		 FOR x = 15 TO 0 STEP -1
			'// hhen der Seitenvertices speichern
			nw = -uglPGet(terrain.hTerrainDC, gx + x, gy + y)
			no = -uglPGet(terrain.hTerrainDC, gx + x + 1, gy + y)
			so = -uglPGet(terrain.hTerrainDC, gx + x + 1, gy + y + 1)
			sw = -uglPGet(terrain.hTerrainDC, gx + x, gy + y + 1)
		  
			'// polygone erstellen
			p(0).v1.x = x * TILESIZE - (mapx MOD TILESIZE)
			p(0).v1.y = y * TILESIZE - (mapy MOD TILESIZE)
			p(0).v1.z = nw
			  
			p(0).v2.x = x * TILESIZE + TILESIZE - (mapx MOD TILESIZE)
			p(0).v2.y = y * TILESIZE - (mapy MOD TILESIZE)
			p(0).v2.z = no
							 
			p(0).v3.x = x * TILESIZE + TILESIZE - (mapx MOD TILESIZE)
			p(0).v3.y = y * TILESIZE + TILESIZE - (mapy MOD TILESIZE)
			p(0).v3.z = so

			'// Rotieren und in Heap einordnen
			MATRIX3DMultVertex tp(index).v1, matView, p(0).v1
			MATRIX3DMultVertex tp(index).v2, matView, p(0).v2
			MATRIX3DMultVertex tp(index).v3, matView, p(0).v3
			IF (CULLClockWise%(tp(index)) = -1) THEN
				HEAPAdd index, tp(index).v1.z + tp(index).v2.z + tp(index).v3.z
				aHeight(index) = (nw + no + so) / 3
			END IF
			index = index + 1

			'// polygone erstellen
			p(1).v1.x = x * TILESIZE - (mapx MOD TILESIZE)
			p(1).v1.y = y * TILESIZE - (mapy MOD TILESIZE)
			p(1).v1.z = nw
							 
			p(1).v2.x = x * TILESIZE + TILESIZE - (mapx MOD TILESIZE)
			p(1).v2.y = y * TILESIZE + TILESIZE - (mapy MOD TILESIZE)
			p(1).v2.z = so

			p(1).v3.x = x * TILESIZE - (mapx MOD TILESIZE)
			p(1).v3.y = y * TILESIZE + TILESIZE - (mapy MOD TILESIZE)
			p(1).v3.z = sw

			'// Rotieren und in Heap einordnen
			MATRIX3DMultVertex tp(index).v1, matView, p(1).v1
			MATRIX3DMultVertex tp(index).v2, matView, p(1).v2
			MATRIX3DMultVertex tp(index).v3, matView, p(1).v3
			IF (CULLClockWise%(tp(index)) = -1) THEN
				HEAPAdd index, tp(index).v1.z + tp(index).v2.z + tp(index).v3.z
				aHeight(index) = (nw + so + sw) / 3
			END IF
			index = index + 1
		NEXT x
	NEXT y

	'// Polygone zeichnen
	FOR j = 0 TO index - 1
			i = HEAPDel%
			IF i = -1 THEN GOTO skip
			IF (CLIPNearPlane%(tp(i), cp(0)) = 0) THEN

				'// Textur je nach hhe whlen
				ti = ABS(aHeight(i) * terrain.TexChangeLevel)
				IF (ti > terrain.AnzTextures - 1) THEN
					ti = terrain.AnzTextures - 1
				END IF
				hTexturDC = hTexDC(ti)
			  
				'// Polygon zeichnen
				ViewTri.v1.x = tp(i).v1.x * env.focusx / (tp(i).v1.z) + env.halfscreenx
				ViewTri.v1.y = -tp(i).v1.y * env.focusy / (tp(i).v1.z) + env.halfscreeny
				ViewTri.v1.u = 0
				ViewTri.v1.v = 0

				ViewTri.v2.x = tp(i).v2.x * env.focusx / (tp(i).v2.z) + env.halfscreenx
				ViewTri.v2.y = -tp(i).v2.y * env.focusy / (tp(i).v2.z) + env.halfscreeny
				ViewTri.v2.u = 1
				ViewTri.v2.v = 0

				ViewTri.v3.x = tp(i).v3.x * env.focusx / (tp(i).v3.z) + env.halfscreenx
				ViewTri.v3.y = -tp(i).v3.y * env.focusy / (tp(i).v3.z) + env.halfscreeny
				ViewTri.v3.u = 1
				ViewTri.v3.v = 1
				col = 255

				uglTriT env.hVideoDC, ViewTri, 0, hTexturDC
				'// Wireframe just in case
				'uglLine env.hVideoDC, ViewTri.v1.x, ViewTri.v1.y, ViewTri.v2.x, ViewTri.v2.y, uglColor16(255, 255, 255)
				'uglLine env.hVideoDC, ViewTri.v2.x, ViewTri.v2.y, ViewTri.v3.x, ViewTri.v3.y, uglColor16(255, 255, 255)
				'uglLine env.hVideoDC, ViewTri.v3.x, ViewTri.v3.y, ViewTri.v1.x, ViewTri.v1.y, uglColor16(255, 255, 255)
			END IF
	NEXT j
skip:
	
	'// Doublebuffering
	GRAPHICFlip TRUE
	uglClear env.hVideoDC, uglColor(terrain.cfmt, 0, 0, 0)

	LOOP UNTIL taste$ = CHR$(27)
	tm# = TIMER - tm#
END SUB

SUB TERRAINLoad (filename AS STRING)
	DIM fTerrainHMap AS STRING
	DIM fTexture AS STRING

	'// Terrain HeaderFile ffnen
	OPEN filename FOR INPUT AS #1

		'// Name der TerrainHeightmap laden
		INPUT #1, fTerrainHMap

		'// heightmap des Terrains laden
		terrain.hTerrainDC = uglNewBMP(UGL.EMS, UGL.8BIT, fTerrainHMap)
		IF (terrain.hTerrainDC = FALSE) THEN
			ENGINEEnd
			END
		END IF

		'// Level ab dem die Texture gendert wird einlesen
		INPUT #1, terrain.TexChangeLevel
		terrain.TexChangeLevel = 1 / terrain.TexChangeLevel

		'// Texturen laden
		INPUT #1, fTexture
		DO
			TERRAINAddTexture fTexture
			INPUT #1, fTexture
		LOOP UNTIL EOF(1) OR fTexture = ""
		
	'// HeaderFile schlieen
	CLOSE #1
END SUB

