#include "inc\vector3d.h"
#include "inc\asmmath.h"

void far pascal VECTOR3DAdd( VECTOR3D far *vec1, VECTOR3D far *vec2, VECTOR3D far *vres ) {
	vres->x = vec1->x + vec2->x;
	vres->y = vec1->y + vec2->y;
	vres->z = vec1->z + vec2->z;
}

void far pascal VECTOR3DSub( VECTOR3D far *vec1, VECTOR3D far *vec2, VECTOR3D far *vres ) {
	vres->x = vec1->x - vec2->x;
	vres->y = vec1->y - vec2->y;
	vres->z = vec1->z - vec2->z;
}

void far pascal VECTOR3DDotProduct( VECTOR3D far *vec1, VECTOR3D far *vec2, float far *fresult) {
	*fresult = vec1->x*vec2->x + vec1->y*vec2->y + vec1->z*vec2->z;
}

void far basic VECTOR3DCrossProduct( VECTOR3D far *vec1, VECTOR3D far *vec2, VECTOR3D far *vres) {
	vres->x = vec1->y * vec2->z - vec1->z * vec2->y;
	vres->y = vec1->z * vec2->x - vec1->x * vec2->z;
	vres->z = vec1->x * vec2->y - vec1->y * vec2->x;
}

void far basic VECTOR3DNormalize( VECTOR3D far *vec ) {
	float fnorm;

	fnorm = 1 / (float)asm_sqrt(vec->x * vec->x + vec->y*vec->y + vec->z*vec->z);

	vec->x *= fnorm;
	vec->y *= fnorm;
	vec->z *= fnorm;
}




