#include "inc\asmmath.h"
#include "inc\matrix.h"

void far pascal MATRIX3DIdentity (MATRIX3D far *mat) {
	mat->_11 = mat->_22 = mat->_33 = mat->_44 = 1.0f;
	mat->_12 = mat->_13 = mat->_14 = mat->_41 = 0.0f;
	mat->_21 = mat->_23 = mat->_24 = mat->_42 = 0.0f;
	mat->_31 = mat->_32 = mat->_34 = mat->_43 = 0.0f;
}

void far pascal MATRIX3DTranslation (MATRIX3D far *mat, VECTOR3D far *vec) {
	MATRIX3DIdentity(mat);
	mat->_41 = vec->x;
	mat->_42 = vec->y;
	mat->_43 = vec->z;
}

void far pascal MATRIX3DMultiply(MATRIX3D far *newmat, MATRIX3D far *mat1, MATRIX3D far *mat2) {
	newmat->_11 = mat1->_11 * mat2->_11 + mat1->_12 * mat2->_21 + mat1->_13 * mat2->_31 + mat1->_14 * mat2->_41;
	newmat->_12 = mat1->_11 * mat2->_12 + mat1->_12 * mat2->_22 + mat1->_13 * mat2->_32 + mat1->_14 * mat2->_42;
	newmat->_13 = mat1->_11 * mat2->_13 + mat1->_12 * mat2->_23 + mat1->_13 * mat2->_33 + mat1->_14 * mat2->_43;
	newmat->_14 = mat1->_11 * mat2->_14 + mat1->_12 * mat2->_24 + mat1->_13 * mat2->_34 + mat1->_14 * mat2->_44;

	newmat->_21 = mat1->_21 * mat2->_11 + mat1->_22 * mat2->_21 + mat1->_23 * mat2->_31 + mat1->_24 * mat2->_41;
	newmat->_22 = mat1->_21 * mat2->_12 + mat1->_22 * mat2->_22 + mat1->_23 * mat2->_32 + mat1->_24 * mat2->_42;
	newmat->_23 = mat1->_21 * mat2->_13 + mat1->_22 * mat2->_23 + mat1->_23 * mat2->_33 + mat1->_24 * mat2->_43;
	newmat->_24 = mat1->_21 * mat2->_14 + mat1->_22 * mat2->_24 + mat1->_23 * mat2->_34 + mat1->_24 * mat2->_44;

	newmat->_31 = mat1->_31 * mat2->_11 + mat1->_32 * mat2->_21 + mat1->_33 * mat2->_31 + mat1->_34 * mat2->_41;
	newmat->_32 = mat1->_31 * mat2->_12 + mat1->_32 * mat2->_22 + mat1->_33 * mat2->_32 + mat1->_34 * mat2->_42;
	newmat->_33 = mat1->_31 * mat2->_13 + mat1->_32 * mat2->_23 + mat1->_33 * mat2->_33 + mat1->_34 * mat2->_43;
	newmat->_34 = mat1->_31 * mat2->_14 + mat1->_32 * mat2->_24 + mat1->_33 * mat2->_34 + mat1->_34 * mat2->_44;

	newmat->_41 = mat1->_41 * mat2->_11 + mat1->_42 * mat2->_21 + mat1->_43 * mat2->_31 + mat1->_44 * mat2->_41;
	newmat->_42 = mat1->_41 * mat2->_12 + mat1->_42 * mat2->_22 + mat1->_43 * mat2->_32 + mat1->_44 * mat2->_42;
	newmat->_43 = mat1->_41 * mat2->_13 + mat1->_42 * mat2->_23 + mat1->_43 * mat2->_33 + mat1->_44 * mat2->_43;
	newmat->_44 = mat1->_41 * mat2->_14 + mat1->_42 * mat2->_24 + mat1->_43 * mat2->_34 + mat1->_44 * mat2->_44;
}

void far pascal MATRIX3DRotationX (MATRIX3D far *mat, float fRads) {
	MATRIX3DIdentity(mat);
	mat->_22 =  asm_cos(fRads);
	mat->_23 =  asm_sin(fRads);
	mat->_32 = -asm_sin(fRads);
	mat->_33 =  asm_cos(fRads);
}

void far pascal MATRIX3DRotationY (MATRIX3D far *mat, float fRads) {
	MATRIX3DIdentity(mat);
	mat->_11 =  asm_cos(fRads);
	mat->_13 = -asm_sin(fRads);
	mat->_31 =  asm_sin(fRads);
	mat->_33 =  asm_cos(fRads);
}

void far pascal MATRIX3DRotationZ (MATRIX3D far *mat, float fRads) {
	MATRIX3DIdentity(mat);
	mat->_11 =  asm_cos(fRads);
	mat->_12 =  asm_sin(fRads);
	mat->_21 = -asm_sin(fRads);
	mat->_22 =  asm_cos(fRads);
}

void far pascal MATRIX3DMultVector (VECTOR3D far *pvOut, MATRIX3D far *mat, VECTOR3D far *vec) {
	pvOut->x = mat->_11*vec->x + mat->_21*vec->y + mat->_31*vec->z + mat->_41;
	pvOut->y = mat->_12*vec->x + mat->_22*vec->y + mat->_32*vec->z + mat->_42;
	pvOut->z = mat->_13*vec->x + mat->_23*vec->y + mat->_33*vec->z + mat->_43;
}

void far pascal MATRIX3DMultVertex (VERTEX3D far *pvOut, MATRIX3D far *mat, VERTEX3D far *vec) {
	pvOut->x = mat->_11*vec->x + mat->_21*vec->y + mat->_31*vec->z + mat->_41;
	pvOut->y = mat->_12*vec->x + mat->_22*vec->y + mat->_32*vec->z + mat->_42;
	pvOut->z = mat->_13*vec->x + mat->_23*vec->y + mat->_33*vec->z + mat->_43;
	pvOut->u = vec->u;
	pvOut->v = vec->v;
}