typedef struct _HEAPNODE {
	int iIndex;
	float favgz;
} HEAPNODE;

HEAPNODE far *heap;
int iMaxNodes;
int iAnzNodesOnHeap;

void far Heap_Init( HEAPNODE far *pHeap, int iAnzNodes ) {

	// Pointer auf den unter Qbasic
	// allokierten Heap setzen
	heap = pHeap;

	// und hchstzulssige Zahl der Nodes
	// speichern um Arrayberlauf zu vermeiden
	iMaxNodes = iAnzNodes;
	iAnzNodesOnHeap = 0;
}

void far Heap_Reset( void ) {
	// Heap zurcksetzen
	iAnzNodesOnHeap = 0;
}

void far Heap_Add( int iIndex, float favgz ) {
	int CurrElement, CurrVater;

	// alle arrayelemente aufgebraucht?
	if(iMaxNodes == iAnzNodesOnHeap)
		return;

	// noch kein Node am Heap?
	if(iAnzNodesOnHeap == 0) {
		iAnzNodesOnHeap++;
		heap[iAnzNodesOnHeap].iIndex = iIndex;
		heap[iAnzNodesOnHeap].favgz = favgz;
		return;
	}

	// einzufgenden Node an Ende des Heaps setzen
	CurrElement = ++iAnzNodesOnHeap;
	heap[CurrElement].iIndex = iIndex;
	heap[CurrElement].favgz = favgz;

	// Node den Baum raufsenden
	while ( CurrElement != 1 ) {
		CurrVater = CurrElement >> 1;

		// ist das Element grer als sein Vater?
		// [ durschnitt Z des einen Polys grer als anderes? ]
		if ( heap[CurrElement].favgz > heap[CurrVater].favgz ) {
			// ja dann tauschen wir die beiden
			// dadurch blubbert das Element eines nach oben
			int tempIndex = heap[CurrVater].iIndex;
			float tempAvgz = heap[CurrVater].favgz;

			// Vater wird Kind
			heap[CurrVater].iIndex = heap[CurrElement].iIndex;
			heap[CurrVater].favgz = heap[CurrElement].favgz;

			// Kind wird Vater
			heap[CurrElement].iIndex = tempIndex;
			heap[CurrElement].favgz = tempAvgz;

			CurrElement = CurrVater;
		} // [ if (heap[kind] < heap[vater]) ]
		else
			return;
	} // [ while (!ErsterNode) ]
}

int far Heap_Del( void ) {
	int iReturnIndex = heap[1].iIndex;
	int tempIndex;
	float tempAvgz;
	float fscoreA = 0.0f, fscoreB = 0.0f;
	int CurrElement;
	int CurrKindA, CurrKindB;

	// wenn nur mehr ein Element am Heap ist gehen wir heim
	if( iAnzNodesOnHeap == 1 ) {
		iAnzNodesOnHeap--;
		return iReturnIndex;
	}

	if( iAnzNodesOnHeap <= 0)
		return -1;

	// letzten Node an den Anfang des Heaps setzen
	heap[1].iIndex = heap[iAnzNodesOnHeap].iIndex;
	heap[1].favgz = heap[iAnzNodesOnHeap].favgz;
	iAnzNodesOnHeap--;

	CurrElement = 1;

	do {
		CurrKindA = CurrElement << 1;
		CurrKindB = (CurrElement << 1) + 1;

		// averagez des ersten Kindes (falls vorhanden)
		// gibts kein erstes Kind gibts auch kein zweites
		// und wir verlassen die Funktion
		if(CurrKindA<=iAnzNodesOnHeap)
			fscoreA = heap[CurrKindA].favgz;
		else
			return iReturnIndex;

		// averagez des zweiten Kindes (falls vorhanden)
		if(CurrKindB<=iAnzNodesOnHeap)
			fscoreB = heap[CurrKindB].favgz;
		else
			fscoreB = 0.0f;

		if(fscoreA > fscoreB) {

			if(fscoreA > heap[CurrElement].favgz) {
				tempIndex = heap[CurrElement].iIndex;
				tempAvgz = heap[CurrElement].favgz;

				heap[CurrElement].iIndex = heap[CurrKindA].iIndex;
				heap[CurrElement].favgz = heap[CurrKindA].favgz;

				heap[CurrKindA].iIndex = tempIndex;
				heap[CurrKindA].favgz = tempAvgz;

				CurrElement = CurrKindA;
			}
			else
				return iReturnIndex;
		}
		else {
			if(fscoreB > heap[CurrElement].favgz) {
				tempIndex = heap[CurrElement].iIndex;
				tempAvgz = heap[CurrElement].favgz;

				heap[CurrElement].iIndex = heap[CurrKindB].iIndex;
				heap[CurrElement].favgz = heap[CurrKindB].favgz;

				heap[CurrKindB].iIndex = tempIndex;
				heap[CurrKindB].favgz = tempAvgz;
				CurrElement = CurrKindB;
			}
			else
				return iReturnIndex;
		}
	}while (1);
}


