DECLARE FUNCTION CLIPOnScreen% (x AS SINGLE, y AS SINGLE)
DECLARE FUNCTION CLIPIntersect% (linestart AS ANY, lineend AS ANY, intersection AS ANY, percentage AS SINGLE)
DECLARE FUNCTION CLIPNearPlane% (poly AS ANY, OutPoly() AS ANY)
'$INCLUDE: '..\bi\typedef.bi'
'$INCLUDE: '..\bi\math3d.bi'

CONST ZNEAR = 10

CLS

DIM p1 AS POLYGON3D
DIM cp(1) AS POLYGON3D

p1.v1.x = 0: p1.v1.y = -32: p1.v1.z = 128
p1.v2.x = 0: p1.v2.y = 0: p1.v2.z = 128
p1.v3.x = 0: p1.v3.y = 0: p1.v3.z = -128


PRINT CLIPNearPlane(p1, cp())
SLEEP

SCREEN 7

IF (CLIPNearPlane(p1, cp()) = 0) THEN
   LINE (p1.v1.z + 160, p1.v1.y + 100)-(p1.v2.z + 160, p1.v2.y + 100), 4
   LINE (p1.v2.z + 160, p1.v2.y + 100)-(p1.v3.z + 160, p1.v3.y + 100), 4
   LINE (p1.v1.z + 160, p1.v1.y + 100)-(p1.v3.z + 160, p1.v3.y + 100), 4
END IF

IF (CLIPNearPlane(p1, cp()) = 3) THEN
   LINE (cp(0).v1.z + 160, cp(0).v1.y + 100)-(cp(0).v2.z + 160, cp(0).v2.y + 100), 4
   LINE (cp(0).v2.z + 160, cp(0).v2.y + 100)-(cp(0).v3.z + 160, cp(0).v3.y + 100), 4
   LINE (cp(0).v1.z + 160, cp(0).v1.y + 100)-(cp(0).v3.z + 160, cp(0).v3.y + 100), 4
END IF

IF (CLIPNearPlane(p1, cp()) = 4) THEN
   FOR i = 0 TO 1
      LINE (cp(i).v1.z + 160, cp(i).v1.y + 100)-(cp(i).v2.z + 160, cp(i).v2.y + 100), 4
      LINE (cp(i).v2.z + 160, cp(i).v2.y + 100)-(cp(i).v3.z + 160, cp(i).v3.y + 100), 4
      LINE (cp(i).v1.z + 160, cp(i).v1.y + 100)-(cp(i).v3.z + 160, cp(i).v3.y + 100), 4
   NEXT i
END IF

SLEEP

FUNCTION CLIPIntersect% (linestart AS VECTOR3D, lineend AS VECTOR3D, intersection AS VECTOR3D, percentage AS SINGLE)

DIM direction AS VECTOR3D
DIM normal AS VECTOR3D
DIM l1 AS VECTOR3D

DIM linelength AS SINGLE
DIM distfromplane AS SINGLE

normal.z = 1

VECTOR3DSubtrahieren lineend, linestart, direction

VECTOR3DPunktProdukt direction, normal, linelength
IF (ABS(linelength) < .0001) THEN
   CLIPIntersect% = 0
   EXIT FUNCTION
END IF

l1.x = -linestart.x: l1.y = -linestart.y: l1.z = ZNEAR - linestart.z

VECTOR3DPunktProdukt l1, normal, distfromplane
percentage = distfromplane / linelength

IF (percentage < 0) THEN
   CLIPIntersect% = 0
   EXIT FUNCTION
END IF
IF (percentage > 1) THEN
   CLIPIntersect% = 0
   EXIT FUNCTION
END IF

intersection.x = linestart.x + direction.x * percentage
intersection.y = linestart.y + direction.y * percentage
intersection.z = linestart.z + direction.z * percentage

CLIPIntersect% = -1
END FUNCTION

FUNCTION CLIPNearPlane% (poly AS POLYGON3D, OutPoly() AS POLYGON3D)
   DIM intersection AS VECTOR3D
   DIM percentage AS SINGLE
   DIM verts(2) AS VECTOR3D
   DIM outverts(4) AS VECTOR3D
   DIM numverts AS INTEGER

   'IF poly.v1.z = 0 THEN poly.v1.z = .001
   'IF poly.v2.z = 0 THEN poly.v2.z = .001
   'IF poly.v3.z = 0 THEN poly.v3.z = .001

   IF poly.v1.z > ZNEAR AND poly.v2.z > ZNEAR AND poly.v3.z > ZNEAR THEN
      CLIPNearPlane% = 0
      EXIT FUNCTION
   END IF

   IF poly.v1.z <= ZNEAR AND poly.v2.z <= ZNEAR AND poly.v3.z <= ZNEAR THEN
      CLIPNearPlane% = -1
      EXIT FUNCTION
   END IF

   verts(0).x = poly.v1.x: verts(0).y = poly.v1.y: verts(0).z = poly.v1.z:
   verts(1).x = poly.v2.x: verts(1).y = poly.v2.y: verts(1).z = poly.v2.z:
   verts(2).x = poly.v3.x: verts(2).y = poly.v3.y: verts(2).z = poly.v3.z:

   FOR i = 0 TO 2
      IF (verts(i).z > ZNEAR) THEN
         outverts(numverts).x = verts(i).x
         outverts(numverts).y = verts(i).y
         outverts(numverts).z = verts(i).z + 1
         numverts = numverts + 1
      END IF

      IF i < 2 THEN
         IF (CLIPIntersect%(verts(i), verts(i + 1), intersection, percentage)) THEN
            outverts(numverts).x = intersection.x
            outverts(numverts).y = intersection.y
            outverts(numverts).z = 10
            numverts = numverts + 1
         END IF
      END IF
   NEXT i

   IF (CLIPIntersect%(verts(2), verts(0), intersection, percentage)) THEN
      outverts(numverts).x = intersection.x
      outverts(numverts).y = intersection.y
      outverts(numverts).z = 10
      numverts = numverts + 1
    END IF

    OutPoly(0).v1.x = outverts(0).x
    OutPoly(0).v1.y = outverts(0).y
    OutPoly(0).v1.z = outverts(0).z

    OutPoly(0).v2.x = outverts(1).x
    OutPoly(0).v2.y = outverts(1).y
    OutPoly(0).v2.z = outverts(1).z

    OutPoly(0).v3.x = outverts(2).x
    OutPoly(0).v3.y = outverts(2).y
    OutPoly(0).v3.z = outverts(2).z

    IF numverts = 4 THEN

      OutPoly(1).v1.x = outverts(0).x
      OutPoly(1).v1.y = outverts(0).y
      OutPoly(1).v1.z = outverts(0).z

      OutPoly(1).v2.x = outverts(2).x
      OutPoly(1).v2.y = outverts(2).y
      OutPoly(1).v2.z = outverts(2).z

      OutPoly(1).v3.x = outverts(3).x
      OutPoly(1).v3.y = outverts(3).y
      OutPoly(1).v3.z = outverts(3).z
       
    END IF

    CLIPNearPlane% = numverts
END FUNCTION

FUNCTION CLIPOnScreen% (x AS SINGLE, y AS SINGLE)
   IF (x < -32000) OR (x > 32000) THEN CLIPOnScreen% = -1: EXIT FUNCTION
   IF (y < -32000) OR (y > 32000) THEN CLIPOnScreen% = -1: EXIT FUNCTION

   CLIPOnScreen% = 0

END FUNCTION

