#include "c.h"

float g_znear = 0;

int far pascal CULLClockWise( POLYGON3D far *p ) {
	VECTOR3D v1, v2, vec, vecl;
	float result;

	vecl.x = p->vert[0].x; vecl.y = p->vert[0].y; vecl.z = p->vert[0].z;

	v1.x = p->vert[1].x - p->vert[0].x;
	v1.y = p->vert[1].y - p->vert[0].y;
	v1.z = p->vert[1].z - p->vert[0].z;

	v2.x = p->vert[2].x - p->vert[1].x;
	v2.y = p->vert[2].y - p->vert[1].y;
	v2.z = p->vert[2].z - p->vert[1].z;

	VECTOR3DCrossProduct (&v1, &v2, &vec);
	VECTOR3DDotProduct (&vec, &vecl, &result);

	if(result < 0)
		return 0;
	else
		return -1;
}

void far pascal CLIPSetZNear ( float z ) { g_znear = z; };

int pascal CLIPIntersect (VECTOR3D far *linestart,
										VECTOR3D far *lineend,
										VECTOR3D far *intersection,
										float far *percentage) {

	VECTOR3D direction, normal, l1;
	float linelength, distfromplane;

	normal.z = 1;

	VECTOR3DSub( lineend, linestart, &direction );
	VECTOR3DDotProduct( &direction, &normal, &linelength );

	if((linelength<0?-linelength:linelength) < 0.001)
		return 0;

	l1.x = -linestart->x;
	l1.y = -linestart->y;
	l1.z = g_znear - linestart->z;

	VECTOR3DDotProduct( &l1, &normal, &distfromplane );
	(*percentage) = distfromplane / linelength;

	if((*percentage) < 0.00001) return 0;
	if((*percentage) > 1) return 0;

	intersection->x = linestart->x + direction.x * (*percentage);
	intersection->y = linestart->y + direction.y * (*percentage);
	intersection->z = linestart->z + direction.z * (*percentage);

	return -1;
}

int far pascal CLIPNearPlane (POLYGON3D far *poly,
										POLYGON3D far *outpoly) {

	VECTOR3D intersection, verts[3];
	VERTEX3D outverts[4];
	float u[3], v[3];
	float percentage = 0.0f;
	int numverts = 0, i;

	if ((poly->vert[0].z > g_znear) && (poly->vert[1].z > g_znear) && (poly->vert[2].z > g_znear))
		return 0;

	if ((poly->vert[0].z < g_znear) && (poly->vert[1].z < g_znear) && (poly->vert[2].z < g_znear))
		return -1;

	for (i = 0; i < 3; i++) {
		verts[i].x = poly->vert[i].x;
		verts[i].y = poly->vert[i].y;
		verts[i].z = poly->vert[i].z;
		u[i] = poly->vert[i].u;
		v[i] = poly->vert[i].v;
	}

	for (i=0;i< 3; i++) {
		if(verts[i].z > g_znear) {
			outverts[numverts].x = verts[i].x;
			outverts[numverts].y = verts[i].y;
			outverts[numverts].z = verts[i].z;
			outverts[numverts].u = u[i];
			outverts[numverts].v = v[i];
			numverts++;
		}

		if(i<2) {
			if(CLIPIntersect(&verts[i],&verts[i+1], &intersection, &percentage)) {
				outverts[numverts].x = intersection.x;
				outverts[numverts].y = intersection.y;
				outverts[numverts].z = intersection.z;
				outverts[numverts].u = u[i] + ((u[i+1] - u[i]) * percentage);
				outverts[numverts].v = v[i] + ((v[i+1] - v[i]) * percentage);
				numverts++;
			}
		}
	}

	if(CLIPIntersect(&verts[2],&verts[0], &intersection, &percentage)) {
		outverts[numverts].x = intersection.x;
		outverts[numverts].y = intersection.y;
		outverts[numverts].z = intersection.z;
		outverts[numverts].u = u[2] + ((u[0] - u[2]) * percentage);
		outverts[numverts].v = v[2] + ((v[0] - v[2]) * percentage);
		numverts++;
	}

	for(i=0;i<3;i++) {
		outpoly[0].vert[i].x = outverts[i].x;
		outpoly[0].vert[i].y = outverts[i].y;
		outpoly[0].vert[i].z = outverts[i].z;
		outpoly[0].vert[i].u = outverts[i].u;
		outpoly[0].vert[i].v = outverts[i].v;
	}

	if(numverts==4) {
		outpoly[1].vert[0].x = outverts[0].x;
		outpoly[1].vert[0].y = outverts[0].y;
		outpoly[1].vert[0].z = outverts[0].z;
		outpoly[1].vert[0].u = outverts[0].u;
		outpoly[1].vert[0].v = outverts[0].v;

		outpoly[1].vert[1].x = outverts[2].x;
		outpoly[1].vert[1].y = outverts[2].y;
		outpoly[1].vert[1].z = outverts[2].z;
		outpoly[1].vert[1].u = outverts[2].u;
		outpoly[1].vert[1].v = outverts[2].v;

		outpoly[1].vert[2].x = outverts[3].x;
		outpoly[1].vert[2].y = outverts[3].y;
		outpoly[1].vert[2].z = outverts[3].z;
		outpoly[1].vert[2].u = outverts[3].u;
		outpoly[1].vert[2].v = outverts[3].v;
	}

	return numverts;
}
