DECLARE SUB BenchMath ()
DECLARE SUB BenchClip ()
DECLARE SUB BenchHeap ()
DECLARE SUB DebugPRINTVEC (vec AS ANY)
DECLARE SUB debugPrintMat (mat AS ANY)
DECLARE SUB ffix ()

'//----------------------------------------------------
'//                Header Datein
'//----------------------------------------------------

'//:: UGL Include-Dateien
'$INCLUDE: 'ugl.bi'
'$INCLUDE: 'tmr.bi'
'$INCLUDE: 'kbd.bi'
'$INCLUDE: 'mouse.bi'

'//:: 3Dlib Include-Dateien
'$INCLUDE: 'bi\typedef.bi'
'$INCLUDE: 'bi\math3d.bi'
'$INCLUDE: 'bi\heap.bi'
'$INCLUDE: 'bi\clipper.bi'

'//----------------------------------------------------
'//                 globale Variablen &
'//                  Initialisierungen
'//----------------------------------------------------
'//:: globale Variablen
DIM SHARED timer1 AS TMR

	'//:: Timer-Lib initialisieren
	tmrInit

	'//:: ffix initialisieren
	ffix
	
	'//:: schne Ausgabe um was es sich
	'//:: hier handelt
	CLS
	PRINT "///// Qbasic 3D-Library Benchmark \\\\\"
	PRINT "---------------------------------------"
	PRINT
	PRINT "ops = Operations Per Second"


'//----------------------------------------------------
'//                Heap testen
'//----------------------------------------------------
	BenchHeap

'//----------------------------------------------------
'//                Math testen
'//----------------------------------------------------
	BenchMath

'//----------------------------------------------------
'//                Clipping & Culling testen
'//----------------------------------------------------
	BenchClip
 
'//----------------------------------------------------
'//               Deinitialisierungen
'//                   der Librarys
'//----------------------------------------------------
  
	'// timer freigeben
	tmrDel timer1

	'// Timer-Lib deinitialisieren
	tmrEnd

SUB BenchClip
	'// ein random Polygon erstellen
	DIM p AS POLYGON3D
	DIM cp(0 TO 1) AS POLYGON3D
	p.v1.x = RND * 320: p.v1.y = RND * 320: p.v1.z = RND * 320 - RND * 320
	p.v2.x = RND * 320: p.v2.y = RND * 320: p.v2.z = RND * 320 - RND * 320
	p.v3.x = RND * 320: p.v3.y = RND * 320: p.v3.z = RND * 320 - RND * 320

	'// NearCLippingPlane setzen
	CLIPSetZNear 10

	PRINT
	PRINT "____Clipping & Culling-Funktionen_____"

	'//:: CLIPNearPlane testen
	PRINT "   CLIPNearPlane()... ";
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		dummy% = CLIPNearPlane(p, cp(0))
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//:: CULLClockWise testen
	PRINT "   CULLClockWise()... ";
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		dummy% = CULLClockWise%(p)
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

END SUB

SUB BenchHeap
	'//:: schne Ausgabe um was es sich
	'//:: hier handelt
	PRINT
	PRINT "____Heap-Funktionen_____"
	PRINT "   HeapAdd(), HeapDel() angewendet auf 2000 Elemente..."

	'//:: Heap Array und zu sortierenden Array
	'//:: initialisieren
	CONST NUMELEMENTS = 10000
	DIM heap(NUMELEMENTS + 1) AS HEAPNODE
	DIM Numbers(NUMELEMENTS)  AS SINGLE

	FOR i = 0 TO NUMELEMENTS
		Numbers(i) = RND * 1000
	NEXT i

	'//:: Heap-Lib initialisieren
	HEAPInit heap(0), NUMELEMENTS + 1

	'//:: Anzahl der Sortierungen pro Sekunde
	'//:: testen
	PRINT "   Sortiere...";
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO

		'//:: Elemente in Heap einsortieren
		FOR i = 0 TO NUMELEMENTS
			HEAPAdd i, Numbers(i)
		NEXT i

		'//:: und sortiere Elemente zurckholen
		FOR i = 0 TO NUMELEMENTS
			index = HEAPDel%
		NEXT i
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT " ops:" + STR$(ops&)
	SLEEP

	'//:: Funktionalitt prfen
	PRINT
	LOCATE , 4
	PRINT "Funktionalitt prfen"
	HEAPInit heap(0), 12
	FOR i = 0 TO 10
		HEAPAdd i, Numbers(i)
	NEXT i

	LOCATE , 4
	PRINT "Geordnet";
	LOCATE , 15
	PRINT "Ungeordnet"
	LOCATE , 4
	PRINT "---------------------"

	'//:: Ausgabe der geordneten und ungeordneten Nummern
	FOR i = 0 TO 10
		LOCATE , 4
		PRINT Numbers(i);

		LOCATE , 14
		PRINT "|";

		LOCATE , 15
		PRINT Numbers(HEAPDel%)
	NEXT i
	SLEEP

END SUB

SUB BenchMath
	DIM mat AS MATRIX3D
	DIM mat2 AS MATRIX3D
	DIM mat3 AS MATRIX3D
	DIM vec AS VECTOR3D
	DIM vec2 AS VECTOR3D
	DIM vec3 AS VECTOR3D

	PRINT
	PRINT "____Math3D-Funktionen_____"
 
	'//:: MatrixIdentity testen
	PRINT "   MATRIX3DIdentity()... ";
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		MATRIX3DIdentity mat
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)
		
	'//;; MatrixRotationX testen
	PRINT "   MATRIX3DRotationX()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		MATRIX3DRotationX mat, .032
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; MatrixRotationY testen
	PRINT "   MATRIX3DRotationY()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		MATRIX3DRotationY mat, .032
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; MatrixRotationZ testen
	PRINT "   MATRIX3DRotationZ()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		MATRIX3DRotationZ mat, .032
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; MatrixMultiply testen
	PRINT "   MATRIX3DMultiply()... ";
	MATRIX3DIdentity mat2
	MATRIX3DIdentity mat3

	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		MATRIX3DMultiply mat, mat2, mat3
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; MatrixMultVector testen
	vec.x = 1: vec.y = 1: vec.z = 1
	PRINT "   MATRIX3DMultVector()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		MATRIX3DMultVector vec, mat, vec
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; MatrixMultVertex testen
	DIM ver AS VERTEX3D
	ver.x = 1: ver.y = 1: ver.z = 1
	PRINT "   MATRIX3DMultVertex()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		MATRIX3DMultVertex ver, mat, ver
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; VECTOR3DAddieren testen
	PRINT "   VECTOR3DAdd()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		VECTOR3DAdd vec2, vec3, vec
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; VECTOR3DSubtrahieren testen
	PRINT "   VECTOR3DSub()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		VECTOR3DSub vec2, vec3, vec
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; VECTOR3DPunktprodukt testen
	DIM result AS SINGLE
	PRINT "   VECTOR3DDotProduct()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		VECTOR3DDotProduct vec2, vec3, result
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; VECTOR3DKreuzprodukt testen
	PRINT "   VECTOR3DCrossProduct()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		VECTOR3DCrossProduct vec2, vec3, vec
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)

	'//;; VECTOR3DNormalisieren testen
	PRINT "   VECTOR3DNormalize()... ";
	ops& = 0
	tmrNew timer1, 0, tmrSec2Freq(1)
	DO
		VECTOR3DNormalize vec
		ops& = ops& + 1
	LOOP UNTIL NOT timer1.state
	PRINT "ops:" + STR$(ops&)
	SLEEP

END SUB

SUB debugPrintMat (mat AS MATRIX3D)
	PRINT mat.m11; mat.m12; mat.m13; mat.m14
	PRINT mat.m21; mat.m22; mat.m23; mat.m24
	PRINT mat.m31; mat.m32; mat.m33; mat.m34
	PRINT mat.m41; mat.m42; mat.m43; mat.m44
END SUB

SUB DebugPRINTVEC (vec AS VECTOR3D)
	PRINT vec.x; vec.y; vec.z
END SUB

