DECLARE SUB MatrixProjection (mat AS ANY, nearp AS SINGLE, farp AS SINGLE)
DECLARE SUB MultiplyMatMatrix (mat1 AS ANY, mat2 AS ANY, newmat AS ANY)
DECLARE SUB Walk3D ()
DECLARE SUB NewPolygon (xstart!, ystart!, xend!, yend!)
DECLARE SUB DrawPolygons ()
DECLARE SUB DrawNormal (xstart AS SINGLE, ystart AS SINGLE, xend AS SINGLE, yend AS SINGLE)
DECLARE SUB DrawMouse (dc AS LONG)
DECLARE SUB ProcessMouse ()
DECLARE SUB DrawGrid (dc AS LONG)
DECLARE SUB InitGraphic (xRes AS INTEGER, yRes AS INTEGER)
DECLARE SUB EndGraphic ()
DECLARE SUB InitMouse (dc AS LONG)
DECLARE SUB EndMouse ()
DECLARE SUB ffix ()

'$INCLUDE: 'ugl.bi'
'$INCLUDE: 'mouse.bi'
'$INCLUDE: '..\..\bi\typedef.bi'
'$INCLUDE: '..\..\bi\math3d.bi'
'$INCLUDE: '..\..\bi\clipper.bi'

'//:: konstanten
CONST MAXPOLYGONS = 500
CONST DEGTORAD = 3.141593 / 180
CONST focus = 380
CONST CAMSPEED = 5

'//:: globale Variablen
DIM SHARED VideoDC AS LONG
DIM SHARED BackBufferDC AS LONG
DIM SHARED screenx, screeny
DIM SHARED mouse AS MOUSEINF
DIM SHARED polygons(MAXPOLYGONS - 1) AS POLYGON3D
DIM SHARED Transpolygons(MAXPOLYGONS - 1) AS POLYGON3D
DIM SHARED AnzPolygons
DIM SHARED fps&
DIM SHARED TextureDC AS LONG
DIM SHARED vispage%, wrkpage%

	'// graphik initialisieren
	InitGraphic 640, 480

	'// mouse initialisieren
	InitMouse VideoDC

	'// ffix
	ffix

	'// Z-Nearplane definieren
	CLIPSetZNear 10


	'// Textur laden
	TextureDC = uglNewBMP(UGL.EMS, UGL.8BIT, "..\tex\ugl64.bmp")
	IF (TextureDC = 0) THEN uglRestore: uglEnd: PRINT "uglNewBMP": END

	DO

		'// Backbuffer lschen
		uglClear VideoDC, uglColor(UGL.8BIT, 0, 0, 0)

		'// Koordinatennetz zeichnen
		DrawGrid VideoDC

		'// Polygone zeichnen
		DrawPolygons

		'// Mousepointer zeichnen
		DrawMouse VideoDC

		'// Mouseinput abwickeln
		ProcessMouse

		'// Doublebuffering
		SWAP vispage%, wrkpage%
		uglSetVisPage vispage%
		DO: LOOP UNTIL (INP(&H3DA) AND &H8)
		uglSetWrkPage wrkpage%
	  
		'// wollen wir das Modell begehen?
		taste$ = INKEY$
		IF taste$ = "w" THEN Walk3D

	LOOP UNTIL taste$ = CHR$(27)

	
	'// graphik schlieen
	EndGraphic
  
	'// mouse schlieen
	EndMouse

	PRINT "Polys:" + STR$(AnzPolygons)
	PRINT "fps:" + STR$(fps&)

	END

skip:
	RESUME NEXT

SUB DrawGrid (dc AS LONG)
	uglLine dc, screenx / 2, 0, screenx / 2, screeny, uglColor(UGL.8BIT, 0, 0, 255)
	uglLine dc, 0, screeny / 2, screenx, screeny / 2, uglColor(UGL.8BIT, 0, 0, 255)
END SUB

SUB DrawMouse (dc AS LONG)
	uglLine dc, mouse.x - 5, mouse.y, mouse.x - 1, mouse.y, uglColor(UGL.8BIT, 255, 255, 255)
	uglLine dc, mouse.x + 5, mouse.y, mouse.x + 1, mouse.y, uglColor(UGL.8BIT, 255, 255, 255)
	uglLine dc, mouse.x, mouse.y - 5, mouse.x, mouse.y - 1, uglColor(UGL.8BIT, 255, 255, 255)
	uglLine dc, mouse.x, mouse.y + 5, mouse.x, mouse.y + 1, uglColor(UGL.8BIT, 255, 255, 255)
END SUB

SUB DrawNormal (xstart AS SINGLE, ystart AS SINGLE, xend AS SINGLE, yend AS SINGLE)
	DIM pos1 AS VECTOR3D
	DIM pos2 AS VECTOR3D
	DIM vec1 AS VECTOR3D
	DIM vec2 AS VECTOR3D
	DIM veccross AS VECTOR3D

	IF xstart = xend AND ystart = yend THEN EXIT SUB

	pos1.x = xstart: pos1.y = 32: pos1.z = ystart
	pos2.x = xend: pos2.y = 32: pos2.z = yend

	'// ersten Vektor des Polygons errechnen
	VECTOR3DSubtrahieren pos2, pos1, vec1

	'// zweiten Vektor des Polygons errechnen
	vec2.x = 0: vec2.y = -64: vec2.z = 0

	'// normalVektor errechnen
	VECTOR3DKreuzProdukt vec1, vec2, veccross
	VECTOR3DNormalisieren veccross

	'// normalvektor skalieren
	veccross.x = veccross.x * 10
	veccross.z = veccross.z * 10

	'// zeichnen
	DIM vstartx AS INTEGER
	DIM vstarty AS INTEGER
	DIM vendx AS INTEGER
	DIM vendy AS INTEGER

	vstartx = xstart + (xend - xstart) / 2
	vstarty = ystart + (yend - ystart) / 2
	vendx = vstartx + veccross.x
	vendy = vstarty + veccross.z
	
	uglLine VideoDC, vstartx, vstarty, vendx, vendy, uglColor(UGL.8BIT, 255, 0, 0)

END SUB

SUB DrawPolygons

	IF AnzPolygons = 0 THEN EXIT SUB

	FOR i = 0 TO AnzPolygons - 1
		uglLine VideoDC, polygons(i).v1.x + screenx / 2, polygons(i).v1.z + screeny / 2, polygons(i).v2.x + screenx / 2, polygons(i).v2.z + screeny / 2, uglColor(UGL.8BIT, 0, 255, 0)
		DrawNormal polygons(i).v1.x + screenx / 2, polygons(i).v1.z + screeny / 2, polygons(i).v2.x + screenx / 2, polygons(i).v2.z + screeny / 2
	NEXT i
END SUB

SUB EndGraphic
	uglRestore
	uglEnd
END SUB

SUB EndMouse
	mouseHide
	mouseEnd
END SUB

SUB InitGraphic (xRes AS INTEGER, yRes AS INTEGER)
	IF (uglInit% = 0) THEN
		PRINT "FEHLER: uglInit%()"
		END
	END IF

	'//:: Videomodus initialisieren
	VideoDC = uglSetVideoDC(UGL.8BIT, xRes, yRes, 2)
	IF (VideoDC = 0) THEN
		uglRestore
		PRINT "FEHLER: uglSetVideoDC()"
		uglEnd
	END IF

	wrkpage% = 0
	vispage% = 1

	uglSetWrkPage wrkpage
	uglSetVisPage vispage


	'//:: Backbuffer erstellen
	'BackBufferDC = uglNew(UGL.EMS, UGL.8BIT, xRes, yRes)
	'IF (BackBufferDC = 0) THEN
	'   uglRestore
	'   PRINT "FEHLER: uglNew"
	'   uglEnd
	'   END
	'END IF

	screenx = xRes
	screeny = yRes

END SUB

SUB InitMouse (dc AS LONG)

	IF (NOT mouseInit(dc, mouse)) THEN
		uglRestore
		PRINT "FEHLER: MouseInit"
		uglEnd
		END
	END IF

END SUB

SUB MultiplyMatMatrix (mat1 AS MATRIX3D, mat2 AS MATRIX3D, newmat AS MATRIX3D)
	newmat.m11 = mat1.m11 * mat2.m11 + mat1.m12 * mat2.m21 + mat1.m13 * mat2.m31 + mat1.m14 * mat2.m41
	newmat.m12 = mat1.m11 * mat2.m12 + mat1.m12 * mat2.m22 + mat1.m13 * mat2.m32 + mat1.m14 * mat2.m42
	newmat.m13 = mat1.m11 * mat2.m13 + mat1.m12 * mat2.m23 + mat1.m13 * mat2.m33 + mat1.m14 * mat2.m43
	newmat.m14 = mat1.m11 * mat2.m14 + mat1.m12 * mat2.m24 + mat1.m13 * mat2.m34 + mat1.m14 * mat2.m44

	newmat.m21 = mat1.m21 * mat2.m11 + mat1.m22 * mat2.m21 + mat1.m23 * mat2.m31 + mat1.m24 * mat2.m41
	newmat.m22 = mat1.m21 * mat2.m12 + mat1.m22 * mat2.m22 + mat1.m23 * mat2.m32 + mat1.m24 * mat2.m42
	newmat.m23 = mat1.m21 * mat2.m13 + mat1.m22 * mat2.m23 + mat1.m23 * mat2.m33 + mat1.m24 * mat2.m43
	newmat.m24 = mat1.m21 * mat2.m14 + mat1.m22 * mat2.m24 + mat1.m23 * mat2.m34 + mat1.m24 * mat2.m44

	newmat.m31 = mat1.m31 * mat2.m11 + mat1.m32 * mat2.m21 + mat1.m33 * mat2.m31 + mat1.m34 * mat2.m41
	newmat.m32 = mat1.m31 * mat2.m12 + mat1.m32 * mat2.m22 + mat1.m33 * mat2.m32 + mat1.m34 * mat2.m42
	newmat.m33 = mat1.m31 * mat2.m13 + mat1.m32 * mat2.m23 + mat1.m33 * mat2.m33 + mat1.m34 * mat2.m43
	newmat.m34 = mat1.m31 * mat2.m14 + mat1.m32 * mat2.m24 + mat1.m33 * mat2.m34 + mat1.m34 * mat2.m44

	newmat.m41 = mat1.m41 * mat2.m11 + mat1.m42 * mat2.m21 + mat1.m43 * mat2.m31 + mat1.m44 * mat2.m41
	newmat.m42 = mat1.m41 * mat2.m12 + mat1.m42 * mat2.m22 + mat1.m43 * mat2.m32 + mat1.m44 * mat2.m42
	newmat.m43 = mat1.m41 * mat2.m13 + mat1.m42 * mat2.m23 + mat1.m43 * mat2.m33 + mat1.m44 * mat2.m43
	newmat.m44 = mat1.m41 * mat2.m14 + mat1.m42 * mat2.m24 + mat1.m43 * mat2.m34 + mat1.m44 * mat2.m44

END SUB

SUB NewPolygon (xstart, ystart, xend, yend)

	polygons(AnzPolygons).v1.x = xstart - screenx / 2
	polygons(AnzPolygons).v1.y = 32
	polygons(AnzPolygons).v1.z = ystart - screeny / 2
	polygons(AnzPolygons).v1.u = 0
	polygons(AnzPolygons).v1.v = 0

	polygons(AnzPolygons).v2.x = xend - screenx / 2
	polygons(AnzPolygons).v2.y = 32
	polygons(AnzPolygons).v2.z = yend - screeny / 2
	polygons(AnzPolygons).v2.u = 1
	polygons(AnzPolygons).v2.v = 0

	polygons(AnzPolygons).v3.x = xend - screenx / 2
	polygons(AnzPolygons).v3.y = -32
	polygons(AnzPolygons).v3.z = yend - screeny / 2
	polygons(AnzPolygons).v3.u = 1
	polygons(AnzPolygons).v3.v = 1


	AnzPolygons = AnzPolygons + 1

	polygons(AnzPolygons).v1.x = xstart - screenx / 2
	polygons(AnzPolygons).v1.y = 32
	polygons(AnzPolygons).v1.z = ystart - screeny / 2
	polygons(AnzPolygons).v1.u = 0
	polygons(AnzPolygons).v1.v = 0

	polygons(AnzPolygons).v2.x = xend - screenx / 2
	polygons(AnzPolygons).v2.y = -32
	polygons(AnzPolygons).v2.z = yend - screeny / 2
	polygons(AnzPolygons).v2.u = 1
	polygons(AnzPolygons).v2.v = 1

	polygons(AnzPolygons).v3.x = xstart - screenx / 2
	polygons(AnzPolygons).v3.y = -32
	polygons(AnzPolygons).v3.z = ystart - screeny / 2
	polygons(AnzPolygons).v3.u = 0
	polygons(AnzPolygons).v3.v = 1

	AnzPolygons = AnzPolygons + 1
END SUB

SUB ProcessMouse
	IF mouse.left THEN
			DIM xstart, ystart AS SINGLE

			'// Startpunkt des Polygons speichern
			xstart = mouse.x: ystart = mouse.y

			DO
				'// Polygongre beschrnken
				IF (SQR((mouse.x - xstart) ^ 2 + (mouse.y - ystart) ^ 2)) > 128 THEN
					DIM vec AS VECTOR3D

					vec.x = mouse.x - xstart: vec.y = mouse.y - ystart
					VECTOR3DNormalisieren vec

					vec.x = vec.x * 128
					vec.y = vec.y * 128

					mousePos xstart + vec.x, ystart + vec.y
				END IF

				'// BackBuffer lschen
				uglClear VideoDC, uglColor(UGL.8BIT, 0, 0, 0)

				'// Koordinatensystem zeichnen
				DrawGrid VideoDC

				'// Polygone zeichnen
				DrawPolygons

				'// Mouse zeichnen
				DrawMouse VideoDC

				'// derzeitiges Polygon von oben zeichnen
				uglLine VideoDC, xstart, ystart, mouse.x, mouse.y, uglColor(UGL.8BIT, 255, 0, 0)

				'// und Normalvektor dazu
				DrawNormal xstart, ystart, CSNG(mouse.x), CSNG(mouse.y)

				'// BackBuffer in Frontbuffer kopieren
				SWAP vispage%, wrkpage%
				uglSetVisPage vispage%
				DO: LOOP UNTIL (INP(&H3DA) AND &H8)
				uglSetWrkPage wrkpage%
				
			 
				'// bei rechter Maustaste wird
				'// das Polygon gespeichert
				IF mouse.right THEN
					NewPolygon xstart, ystart, CSNG(mouse.x), CSNG(mouse.y)
					DO: LOOP UNTIL NOT mouse.right
					EXIT DO
				END IF
			LOOP UNTIL NOT mouse.left
	END IF
END SUB

SUB Walk3D

	DIM cp(1) AS POLYGON3D
	DIM t AS TriType

	ON ERROR GOTO skip

	DIM kamera AS VECTOR3D
	DIM xrot AS SINGLE
	DIM yrot AS SINGLE
	DIM zrot AS SINGLE
	DIM matView AS MATRIX3D
	DIM matRot AS MATRIX3D
	DIM MatTrans AS MATRIX3D

	mousePos screenx / 2, screeny / 2

	stime = TIMER
	fps& = 0
	DO
		uglClear VideoDC, uglColor(UGL.8BIT, 0, 0, 0)

		taste$ = INKEY$

		IF taste$ = "w" OR mouse.left THEN
				kamera.x = kamera.x - SIN(yrot * DEGTORAD) * CAMSPEED
				kamera.z = kamera.z + COS(yrot * DEGTORAD) * CAMSPEED
		END IF
		IF taste$ = "s" OR mouse.right THEN
				kamera.x = kamera.x + SIN(yrot * DEGTORAD) * CAMSPEED
				kamera.z = kamera.z - COS(yrot * DEGTORAD) * CAMSPEED
		END IF

		IF mouse.x - screenx / 2 < screenx THEN
			yrot = yrot - (mouse.x - screenx / 2)
			mousePos screenx / 2, screeny / 2
		END IF

		IF mouse.x - screenx / 2 > screenx THEN
			yrot = yrot - (mouse.x - screenx / 2)
			mousePos screenx / 2, screeny / 2
		END IF

		MatrixIdentity matView
		MatrixRotationY matRot, yrot * DEGTORAD
		matView.m41 = -kamera.x: matView.m42 = -kamera.y: matView.m43 = -kamera.z
		MultiplyMatMatrix matView, matRot, MatTrans

		FOR i = 0 TO AnzPolygons - 1
			MatrixMultVertex Transpolygons(i).v1, MatTrans, polygons(i).v1
			MatrixMultVertex Transpolygons(i).v2, MatTrans, polygons(i).v2
			MatrixMultVertex Transpolygons(i).v3, MatTrans, polygons(i).v3

			CLippResult% = CLIPNearPlane%(Transpolygons(i), cp(0))

			IF (CLippResult% = -1) THEN
				GOTO skippoly
			END IF

			IF (CLippResult% = 0) THEN
				t.v1.x = Transpolygons(i).v1.x * focus / (Transpolygons(i).v1.z) + screenx / 2
				t.v1.y = -Transpolygons(i).v1.y * focus / (Transpolygons(i).v1.z) + screeny / 2
				t.v1.u = Transpolygons(i).v1.u
				t.v1.v = Transpolygons(i).v1.v

				t.v2.x = Transpolygons(i).v2.x * focus / (Transpolygons(i).v2.z) + screenx / 2
				t.v2.y = -Transpolygons(i).v2.y * focus / (Transpolygons(i).v2.z) + screeny / 2
				t.v2.u = Transpolygons(i).v2.u
				t.v2.v = Transpolygons(i).v2.v

				t.v3.x = Transpolygons(i).v3.x * focus / (Transpolygons(i).v3.z) + screenx / 2
				t.v3.y = -Transpolygons(i).v3.y * focus / (Transpolygons(i).v3.z) + screeny / 2
				t.v3.u = Transpolygons(i).v3.u
				t.v3.v = Transpolygons(i).v3.v

				uglTriT VideoDC, t, 0, TextureDC
			END IF

			IF (CLippResult% = 3) THEN
				t.v1.x = cp(0).v1.x * focus / (cp(0).v1.z) + screenx / 2
				t.v1.y = -cp(0).v1.y * focus / (cp(0).v1.z) + screeny / 2
				t.v1.u = cp(0).v1.u
				t.v1.v = cp(0).v1.v
			
				t.v2.x = cp(0).v2.x * focus / (cp(0).v2.z) + screenx / 2
				t.v2.y = -cp(0).v2.y * focus / (cp(0).v2.z) + screeny / 2
				t.v2.u = cp(0).v2.u
				t.v2.v = cp(0).v2.v
			
				t.v3.x = cp(0).v3.x * focus / (cp(0).v3.z) + screenx / 2
				t.v3.y = -cp(0).v3.y * focus / (cp(0).v3.z) + screeny / 2
				t.v3.u = cp(0).v3.u
				t.v3.v = cp(0).v3.v

				uglTriT VideoDC, t, 0, TextureDC
			END IF

			IF (CLippResult% = 4) THEN
				FOR j = 0 TO 1
					t.v1.x = cp(j).v1.x * focus / (cp(j).v1.z) + screenx / 2
					t.v1.y = -cp(j).v1.y * focus / (cp(j).v1.z) + screeny / 2
					t.v1.u = cp(j).v1.u
					t.v1.v = cp(j).v1.v

					t.v2.x = cp(j).v2.x * focus / (cp(j).v2.z) + screenx / 2
					t.v2.y = -cp(j).v2.y * focus / (cp(j).v2.z) + screeny / 2
					t.v2.u = cp(j).v2.u
					t.v2.v = cp(j).v2.v

					t.v3.x = cp(j).v3.x * focus / (cp(j).v3.z) + screenx / 2
					t.v3.y = -cp(j).v3.y * focus / (cp(j).v3.z) + screeny / 2
					t.v3.u = cp(j).v3.u
					t.v3.v = cp(j).v3.v

					uglTriT VideoDC, t, 0, TextureDC
			  NEXT j
			END IF
skippoly:
		NEXT i

		SWAP vispage%, wrkpage%
		uglSetVisPage vispage%
		DO: LOOP UNTIL (INP(&H3DA) AND &H8)
		uglSetWrkPage wrkpage%
		fps& = fps& + 1
	LOOP UNTIL taste$ = CHR$(13) OR mouse.middle
	fps& = fps& / (TIMER - stime)
END SUB

