DECLARE FUNCTION BasCullClockWise% (p AS ANY)
DECLARE SUB MatrixProjection (mat AS ANY, nearp AS SINGLE, farp AS SINGLE)
DECLARE SUB MultiplyMatMatrix (mat1 AS ANY, mat2 AS ANY, newmat AS ANY)
DECLARE SUB Walk3D ()
DECLARE SUB NewPolygon (xstart!, ystart!, xend!, yend!)
DECLARE SUB DrawPolygons ()
DECLARE SUB DrawNormal (xstart AS SINGLE, ystart AS SINGLE, xend AS SINGLE, yend AS SINGLE)
DECLARE SUB DrawMouse (dc AS LONG)
DECLARE SUB ProcessMouse ()
DECLARE SUB DrawGrid (dc AS LONG)
DECLARE SUB InitGraphic (xres AS INTEGER, yres AS INTEGER)
DECLARE SUB EndGraphic ()
DECLARE SUB InitMouse (dc AS LONG)
DECLARE SUB EndMouse ()
DECLARE SUB ffix ()

'$INCLUDE: 'ugl.bi'
'$INCLUDE: 'mouse.bi'
'$INCLUDE: '..\bi\typedef.bi'
'$INCLUDE: '..\bi\clipper.bi'
'$INCLUDE: '..\bi\heap.bi'
'$INCLUDE: '..\bi\math3d.bi'
'$INCLUDE: '..\bi\graphic.bi'

'//:: konstanten
CONST MAXPOLYGONS = 1092
CONST DEGTORAD = 3.141593 / 180
CONST CAMSPEED = 5

'//:: globale Variablen
DIM SHARED env AS ENVIRONMENT3D
DIM SHARED mouse AS MOUSEINF
DIM SHARED polygons(MAXPOLYGONS - 1) AS POLYGON3D
DIM SHARED Transpolygons(MAXPOLYGONS - 1) AS POLYGON3D
DIM SHARED Heap(MAXPOLYGONS + 1) AS HEAPNODE
DIM SHARED AnzPolygons
DIM SHARED fps&
DIM SHARED TextureDC AS LONG


	OPEN "config.txt" FOR INPUT AS #1
		INPUT #1, xres%, yres%
	CLOSE #1

	'// graphik initialisieren
	IF (GRAPHICInit%(xres%, yres%, UGL.8BIT, 1, env) = 0) THEN
		uglRestore
		uglend
		END
	END IF

	'// mouse initialisieren
	InitMouse env.hVideoDC

	'// Z-Nearplane definieren
	CLIPSetZNear 10

	'// Heap initialisieren
	HeapInit Heap(0), MAXPOLYGONS

	'// Textur laden
	TextureDC = uglNewBMP(UGL.EMS, UGL.8BIT, "tex\blech06.bmp")
	IF (TextureDC = 0) THEN uglRestore: uglend: PRINT "uglNewBMP": END

	DO

		'// Backbuffer lschen
		uglClear env.hVideoDC, uglColor(UGL.8BIT, 0, 0, 0)

		'// Koordinatennetz zeichnen
		DrawGrid env.hVideoDC

		'// Polygone zeichnen
		DrawPolygons

		'// Mousepointer zeichnen
		DrawMouse env.hVideoDC

		'// Mouseinput abwickeln
		ProcessMouse

		'// Doublebuffering
		GRAPHICFlip TRUE

		'// wollen wir das Modell begehen?
		taste$ = INKEY$
		IF taste$ = "w" THEN Walk3D

	LOOP UNTIL taste$ = CHR$(27)

	
	'// graphik schlieen
	GRAPHICEnd
  
	'// mouse schlieen
	EndMouse

	PRINT "Polys:" + STR$(AnzPolygons)
	PRINT "fps:" + STR$(fps&)

	END

skip:
	RESUME NEXT

SUB DrawGrid (dc AS LONG)
	uglLine dc, env.halfscreenx, 0, env.halfscreenx, env.screeny, uglColor(UGL.8BIT, 0, 0, 255)
	uglLine dc, 0, env.halfscreeny, env.screenx, env.halfscreeny, uglColor(UGL.8BIT, 0, 0, 255)
END SUB

SUB DrawMouse (dc AS LONG)
	uglLine dc, mouse.x - 5, mouse.y, mouse.x - 1, mouse.y, uglColor(UGL.8BIT, 255, 255, 255)
	uglLine dc, mouse.x + 5, mouse.y, mouse.x + 1, mouse.y, uglColor(UGL.8BIT, 255, 255, 255)
	uglLine dc, mouse.x, mouse.y - 5, mouse.x, mouse.y - 1, uglColor(UGL.8BIT, 255, 255, 255)
	uglLine dc, mouse.x, mouse.y + 5, mouse.x, mouse.y + 1, uglColor(UGL.8BIT, 255, 255, 255)
END SUB

SUB DrawNormal (xstart AS SINGLE, ystart AS SINGLE, xend AS SINGLE, yend AS SINGLE)
	DIM pos1 AS VECTOR3D
	DIM pos2 AS VECTOR3D
	DIM vec1 AS VECTOR3D
	DIM vec2 AS VECTOR3D
	DIM veccross AS VECTOR3D

	IF xstart = xend AND ystart = yend THEN EXIT SUB

	pos1.x = xstart: pos1.y = 32: pos1.z = ystart
	pos2.x = xend: pos2.y = 32: pos2.z = yend

	'// ersten Vektor des Polygons errechnen
	VECTOR3DSub pos2, pos1, vec1

	'// zweiten Vektor des Polygons errechnen
	vec2.x = 0: vec2.y = -64: vec2.z = 0

	'// normalVektor errechnen
	VECTOR3DCrossProduct vec1, vec2, veccross
	VECTOR3DNormalize veccross

	'// normalvektor skalieren
	veccross.x = veccross.x * 10
	veccross.z = veccross.z * 10

	'// zeichnen
	DIM vstartx AS INTEGER
	DIM vstarty AS INTEGER
	DIM vendx AS INTEGER
	DIM vendy AS INTEGER

	vstartx = xstart + (xend - xstart) / 2
	vstarty = ystart + (yend - ystart) / 2
	vendx = vstartx + veccross.x
	vendy = vstarty + veccross.z
	
	uglLine env.hVideoDC, vstartx, vstarty, vendx, vendy, uglColor(UGL.8BIT, 255, 0, 0)

END SUB

SUB DrawPolygons

	IF AnzPolygons = 0 THEN EXIT SUB

	FOR i = 0 TO AnzPolygons - 1
		uglLine env.hVideoDC, polygons(i).v1.x + env.halfscreenx, polygons(i).v1.z + env.halfscreeny, polygons(i).v2.x + env.halfscreenx, polygons(i).v2.z + env.halfscreeny, uglColor(UGL.8BIT, 0, 255, 0)
		DrawNormal polygons(i).v1.x + env.halfscreenx, polygons(i).v1.z + env.halfscreeny, polygons(i).v2.x + env.halfscreenx, polygons(i).v2.z + env.halfscreeny
	NEXT i
END SUB

SUB EndMouse
	mouseHide
	mouseEnd
END SUB

SUB InitMouse (dc AS LONG)

	IF (NOT mouseInit(dc, mouse)) THEN
		uglRestore
		PRINT "FEHLER: MouseInit"
		uglend
		END
	END IF

END SUB

SUB NewPolygon (xstart, ystart, xend, yend)
  
	polygons(AnzPolygons).v1.x = xstart - env.halfscreenx
	polygons(AnzPolygons).v1.y = 32
	polygons(AnzPolygons).v1.z = ystart - env.halfscreeny
	polygons(AnzPolygons).v1.u = 0
	polygons(AnzPolygons).v1.v = 0

	polygons(AnzPolygons).v2.x = xend - env.halfscreenx
	polygons(AnzPolygons).v2.y = 32
	polygons(AnzPolygons).v2.z = yend - env.halfscreeny
	polygons(AnzPolygons).v2.u = 1
	polygons(AnzPolygons).v2.v = 0

	polygons(AnzPolygons).v3.x = xend - env.halfscreenx
	polygons(AnzPolygons).v3.y = -32
	polygons(AnzPolygons).v3.z = yend - env.halfscreeny
	polygons(AnzPolygons).v3.u = 1
	polygons(AnzPolygons).v3.v = 1


	AnzPolygons = AnzPolygons + 1

	polygons(AnzPolygons).v1.x = xstart - env.halfscreenx
	polygons(AnzPolygons).v1.y = 32
	polygons(AnzPolygons).v1.z = ystart - env.halfscreeny
	polygons(AnzPolygons).v1.u = 0
	polygons(AnzPolygons).v1.v = 0

	polygons(AnzPolygons).v2.x = xend - env.halfscreenx
	polygons(AnzPolygons).v2.y = -32
	polygons(AnzPolygons).v2.z = yend - env.halfscreeny
	polygons(AnzPolygons).v2.u = 1
	polygons(AnzPolygons).v2.v = 1
  
	polygons(AnzPolygons).v3.x = xstart - env.halfscreenx
	polygons(AnzPolygons).v3.y = -32
	polygons(AnzPolygons).v3.z = ystart - env.halfscreeny
	polygons(AnzPolygons).v3.u = 0
	polygons(AnzPolygons).v3.v = 1

	AnzPolygons = AnzPolygons + 1
END SUB

SUB ProcessMouse
	IF mouse.left THEN
			DIM xstart, ystart AS SINGLE

			'// Startpunkt des Polygons speichern
			xstart = mouse.x: ystart = mouse.y

			DO
				'// Polygongre beschrnken
				IF (SQR((mouse.x - xstart) ^ 2 + (mouse.y - ystart) ^ 2)) > 64 THEN
					DIM vec AS VECTOR3D

					vec.x = mouse.x - xstart: vec.y = mouse.y - ystart
					VECTOR3DNormalize vec

					vec.x = vec.x * 64
					vec.y = vec.y * 64

					mousePos xstart + vec.x, ystart + vec.y
				END IF

				'// BackBuffer lschen
				uglClear env.hVideoDC, uglColor(UGL.8BIT, 0, 0, 0)

				'// Koordinatensystem zeichnen
				DrawGrid env.hVideoDC

				'// Polygone zeichnen
				DrawPolygons

				'// Mouse zeichnen
				DrawMouse env.hVideoDC

				'// derzeitiges Polygon von oben zeichnen
				uglLine env.hVideoDC, xstart, ystart, mouse.x, mouse.y, uglColor(UGL.8BIT, 255, 0, 0)

				'// und Normalvektor dazu
				DrawNormal xstart, ystart, CSNG(mouse.x), CSNG(mouse.y)

				'// BackBuffer in Frontbuffer kopieren
				GRAPHICFlip TRUE
			 
				'// bei rechter Maustaste wird
				'// das Polygon gespeichert
				IF mouse.right THEN
					NewPolygon xstart, ystart, CSNG(mouse.x), CSNG(mouse.y)
					DO: LOOP UNTIL NOT mouse.right
					EXIT DO
				END IF
			LOOP UNTIL NOT mouse.left
	END IF
END SUB

SUB Walk3D

	DIM cp(1) AS POLYGON3D
	DIM t AS TriType

	ON ERROR GOTO skip

	DIM kamera AS VECTOR3D
	DIM yrot AS SINGLE
	DIM matView AS MATRIX3D
	DIM MatRot AS MATRIX3D
	DIM matTrans AS MATRIX3D

	mousePos env.halfscreenx, env.halfscreeny

	stime = TIMER
	fps& = 0
	DO
		uglClear env.hVideoDC, uglColor(UGL.8BIT, 0, 0, 0)
		HeapReset

		taste$ = INKEY$

		IF taste$ = "w" OR mouse.left THEN
				kamera.x = kamera.x - SIN(yrot * DEGTORAD) * CAMSPEED
				kamera.z = kamera.z + COS(yrot * DEGTORAD) * CAMSPEED
		END IF
		IF taste$ = "s" OR mouse.right THEN
				kamera.x = kamera.x + SIN(yrot * DEGTORAD) * CAMSPEED
				kamera.z = kamera.z - COS(yrot * DEGTORAD) * CAMSPEED
		END IF

		IF mouse.x - env.halfscreenx < env.screenx THEN
			yrot = yrot - (mouse.x - env.halfscreenx)
			IF yrot < 0 THEN yrot = 360
			IF yrot > 360 THEN yrot = 0
			mousePos env.halfscreenx, env.halfscreenx
		END IF

		MATRIX3DIdentity matView
		MATRIX3DRotationY MatRot, yrot * DEGTORAD
		matView.m41 = -kamera.x: matView.m42 = -kamera.y: matView.m43 = -kamera.z
		MATRIX3DMultiply matTrans, matView, MatRot

		FOR i = 0 TO AnzPolygons - 1
			MATRIX3DMultVertex Transpolygons(i).v1, matTrans, polygons(i).v1
			MATRIX3DMultVertex Transpolygons(i).v2, matTrans, polygons(i).v2
			MATRIX3DMultVertex Transpolygons(i).v3, matTrans, polygons(i).v3
			IF (NOT CULLClockWise%(Transpolygons(i))) THEN
				HeapAdd i, Transpolygons(i).v1.z + Transpolygons(i).v2.z + Transpolygons(i).v3.z
			END IF
		NEXT i

		index = 0

		DO UNTIL index = -1
			index = HEAPDel%
			IF (index = -1) THEN GOTO skip2

			CLippResult% = CLIPNearPlane%(Transpolygons(index), cp(0))

			IF (CLippResult% = -1) THEN
				GOTO skippoly
			END IF

			IF (CLippResult% = 0) THEN
				t.v1.x = Transpolygons(index).v1.x * env.focusx / (Transpolygons(index).v1.z) + env.halfscreenx
				t.v1.y = -Transpolygons(index).v1.y * env.focusy / (Transpolygons(index).v1.z) + env.halfscreeny
				t.v1.u = Transpolygons(index).v1.u
				t.v1.v = Transpolygons(index).v1.v

				t.v2.x = Transpolygons(index).v2.x * env.focusx / (Transpolygons(index).v2.z) + env.halfscreenx
				t.v2.y = -Transpolygons(index).v2.y * env.focusy / (Transpolygons(index).v2.z) + env.halfscreeny
				t.v2.u = Transpolygons(index).v2.u
				t.v2.v = Transpolygons(index).v2.v

				t.v3.x = Transpolygons(index).v3.x * env.focusx / (Transpolygons(index).v3.z) + env.halfscreenx
				t.v3.y = -Transpolygons(index).v3.y * env.focusy / (Transpolygons(index).v3.z) + env.halfscreeny
				t.v3.u = Transpolygons(index).v3.u
				t.v3.v = Transpolygons(index).v3.v

				uglTriT env.hVideoDC, t, 0, TextureDC
			END IF

			IF (CLippResult% = 3) THEN
				t.v1.x = cp(0).v1.x * env.focusx / (cp(0).v1.z) + env.halfscreenx
				t.v1.y = -cp(0).v1.y * env.focusy / (cp(0).v1.z) + env.halfscreeny
				t.v1.u = cp(0).v1.u
				t.v1.v = cp(0).v1.v
			
				t.v2.x = cp(0).v2.x * env.focusx / (cp(0).v2.z) + env.halfscreenx
				t.v2.y = -cp(0).v2.y * env.focusy / (cp(0).v2.z) + env.halfscreeny
				t.v2.u = cp(0).v2.u
				t.v2.v = cp(0).v2.v
			
				t.v3.x = cp(0).v3.x * env.focusx / (cp(0).v3.z) + env.halfscreenx
				t.v3.y = -cp(0).v3.y * env.focusy / (cp(0).v3.z) + env.halfscreeny
				t.v3.u = cp(0).v3.u
				t.v3.v = cp(0).v3.v

				uglTriT env.hVideoDC, t, 0, TextureDC
			END IF

			IF (CLippResult% = 4) THEN
				FOR j = 0 TO 1
					t.v1.x = cp(j).v1.x * env.focusx / (cp(j).v1.z) + env.halfscreenx
					t.v1.y = -cp(j).v1.y * env.focusy / (cp(j).v1.z) + env.halfscreeny
					t.v1.u = cp(j).v1.u
					t.v1.v = cp(j).v1.v

					t.v2.x = cp(j).v2.x * env.focusx / (cp(j).v2.z) + env.halfscreenx
					t.v2.y = -cp(j).v2.y * env.focusy / (cp(j).v2.z) + env.halfscreeny
					t.v2.u = cp(j).v2.u
					t.v2.v = cp(j).v2.v

					t.v3.x = cp(j).v3.x * env.focusx / (cp(j).v3.z) + env.halfscreenx
					t.v3.y = -cp(j).v3.y * env.focusy / (cp(j).v3.z) + env.halfscreeny
					t.v3.u = cp(j).v3.u
					t.v3.v = cp(j).v3.v

					uglTriT env.hVideoDC, t, 0, TextureDC
			  NEXT j
			END IF
skippoly:
		LOOP
skip2:
		GRAPHICFlip TRUE

		fps& = fps& + 1
	LOOP UNTIL taste$ = CHR$(13) OR mouse.middle
	fps& = fps& / (TIMER - stime)
END SUB

