                include include.inc

                extrn   b$enra:far


                DGROUP  group _DATA
.data
BAS_str         dw      0, O BAS_str + 2

      
.code
                public  ProcPtr, LabelPtr, MultiLabelPtr
                public  Procedure, GoLabel, JmpLabel
                public  IntegerRet, LongRet, StringRet             

                public  SetDGroup
                public  PushAll, PopAll
                public  PushInt, PushLong
                public  PopInt, PopLong
                public  PushFlags
                public  IntrReturn, FarReturn
                public  EnableIntr, DisableIntr
                public  MakeLong, BreakLong
                public  SaveRegs, RestoreRegs

;;::::::::::::::
pptr_do_error:
                push    bp
                mov     bp, sp                  ;; BC needs bp= sp
                push    5                       ;; error 5= Illegal function call
                extrn   b$serr:far
                call    b$serr

;;::::::::::::::
ProcPtr         proc    uses di si es,\
                        ptr_addr:word

                push    ds                      ;; (0)
                les     di, [bp+2]              ;; es:di -> caller
                xor     cx, cx                  ;; cx= bytes to skip
                mov     dx, 1 shl 10            ;; max attemps

@@loop_scan:    dec     dx
                jz      pptr_error
                inc     di
                inc     cx
                cmp     B es:[di-1], 9Ah        ;; search for far call (9A)
                jne     @@loop_scan             ;; not equal?
                lds     si, es:[di]             ;; ds:si -> possible proc

                ;; all QuickBASIC & QBX SUBs & FUNCTIONs
                ;; starts with:     mov  cx, words_to_alloc
                ;;                  call far b$enra
                ;; in VisualBASIC:  mov  cx, words_to_alloc
                ;;                  mov  bx, ???
                ;;                  call far b$enra
                cmp     B ds:[si], 0B9h
                jne     @@loop_scan             
                cmp     B ds:[si+3], 0BBh       
                jne     @@check_call
                add     si, 3                   
@@check_call:   cmp     B ds:[si+3], 9Ah        
                jne     @@loop_scan             ;; signature not match?

                ;; far call is to b$enra?
                mov     ax, S b$enra
                cmp     ax, ds:[si+6]
                jne     @@loop_scan
                mov     ax, O b$enra
                cmp     ax, ds:[si+4]
                jne     @@loop_scan

                add     cx, 4
                add     [bp+2], cx              ;; caller+= cx + 4

                pop     ds                      ;; (0)     
                mov     eax, es:[di]            ;; eax= proc far ptr
                mov     bx, ptr_addr            ;; ds:bx -> pptr
                mov     ds:[bx], eax            ;; pptr= eax

                mov     ax, O BAS_str           ;; safe if proc rets a string

                ret
ProcPtr         endp
pptr_error:
                pop     ds                      ;; (0)
                PP      es, si, di
                jmp     short pptr_do_error

;;::::::::::::::
Procedure       proc
                ;; old stack frame: 0  [caller]
                ;;                  4  [offset pptr]
                ;;                  6  [parameters... ]
                ;;
                ;; new stack frame: 0  [caller]
                ;;                  4  [parameters... ]

                pop     eax
                pop     bx
                ;; call pptr and return direct to caller
                push    eax
                push    D ds:[bx]
                retf
Procedure       endp

;;::::::::::::::
IntegerRet      proc
                ret
IntegerRet      endp

;;::::::::::::::
LongRet         proc
                ret
LongRet         endp

;;::::::::::::::
StringRet       proc
                ret
StringRet       endp

;;::::::::::::::
LabelPtr        proc    uses di es,\
                        ptr_addr:word
                   
                les     di, [bp+2]              ;; es:di -> caller
                mov     cx, 3                   ;; instruction size= 3 bytes
                cmp     B es:[di], 0E8h         ;; search for call near (E8)
                je      @@match
                cmp     B es:[di], 0E9h         ;;   "     "  jmp near (E9)
                je      @@match
                cmp     B es:[di], 0EBh         ;;   "     "  jmp short (EB)
                jne     @@error
                dec     cx                      ;; size= 2 bytes

@@match:        add     [bp+2], cx              ;; caller+= cx

                mov     ax, es:[di+1]
                sub     cx, 2
                jnz     @@no_conv
                cbw                             ;; "jmp short"?, convert al to ax
@@no_conv:      add     ax, [bp+2]              ;; correct relative addressing
                mov     dx, [bp+4]
                mov     bx, ptr_addr            ;; ds:bx -> lptr
                mov     ds:[bx], ax             ;; lptr= caller ofs+es:[di+1]+cx
                mov     ds:[bx+2], dx           ;; lptr+2= caller seg

                ret

@@error:        PP      es, di
                jmp     pptr_do_error
LabelPtr        endp

;;::::::::::::::
MultiLabelPtr   proc    uses di si es ds,\
                        array_addr:dword, labels:word
      
                les     di, [bp+2]              ;; es:di -> caller                     
                lds     si, array_addr          ;; ds:si -> array

                mov     cx, labels              ;; cx= labels

@@loop:         mov     dx, 3                   ;; instruction size= 3 bytes
                cmp     B es:[di], 0E8h         ;; search for call near (E8)
                je      @@match
                cmp     B es:[di], 0E9h         ;;   "     "  jmp near (E9)
                je      @@match
                cmp     B es:[di], 0EBh         ;;   "     "  jmp short (EB)
                jne     @@error
                dec     dx                      ;; size= 2 bytes

@@match:        add     W [bp+2], dx            ;; caller+= dx

                mov     ax, es:[di+1]
                add     di, dx                  ;; next instruction
                sub     dx, 2
                jnz     @@no_conv
                cbw                             ;; "jmp short"?, convert al to ax
@@no_conv:      add     ax, [bp+2]              ;; correct relative addressing
                mov     dx, [bp+4]
                mov     ds:[si], ax             ;; array[si]= caller ofst+es:[di+1]+dx
                mov     ds:[si+2], dx           ;; array[si+2]= caller seg
                add     si, 4

                dec     cx
                jnz     @@loop

                ret

@@error:        PP      ds, es, si, di
                jmp     pptr_do_error
MultiLabelPtr   endp

;;::::::::::::::
GoLabel         proc
                push    bp
                mov     bp, sp
                PS      ax, bx, di, es

                les     di, [bp + 2]            ;; es:di -> return address
                mov     al, es:[di-5-4]
                cmp     al, 0FFh
                je      @@byte_ff               ;; al= FFh?

@@no_ff:        mov     al, es:[di-5-3]
                cmp     al, 68h
                je      @@byte_68               ;; al= 68h?

@@no_68:        ;; check for: push ?x & push ?x
                mov     ax, es:[di-5-2]
                cmp     al, 50h
                jb      @@error                 ;; not equal?, sorry :}
                cmp     al, 53h
                ja      @@error
                cmp     ah, 50h
                jb      @@error
                cmp     ah, 53h
                ja      @@error
                ;; move (push ?x & push ?x) three bytes down
                mov     es:[di-2-2], ax
                mov     ax, 1 + 1               ;; size: 2 bytes

@@patch:        mov     W es:[di-1-1], 090CBh   ;; retf, nop
                sub     di, ax
                mov     B es:[di-1-1-3], 68h    ;; push
                mov     bx, [bp + 2]
                mov     es:[di-1-1-2], bx       ;; XXXX <-- near return address
     
                add     ax, 1 + 1 + 3
                sub     [bp + 2], ax            ;; re-exec
                PP      es, di, bx, ax
                pop     bp
                ret

@@error:        PP      es, di, bx, ax
                pop     bp
                jmp     pptr_do_error

@@byte_ff:      cmp     es:[di-5-4-4], al
                jne     @@no_ff                 ;; not equal? try next
                mov     al, es:[di-5-3]
                cmp     al, 0B4h
                je      @@byte_b4               ;; maybe push [si + XXXX]?
                cmp     al, 36h
                jne     @@no_ff                 ;; or push [XXXX]?
     
@@byte_b4:      cmp     es:[di-5-4-3], al
                jne     @@no_ff                 ;; not equal? try next

                mov     eax, es:[di-5-4]        ;; move (push [?? + XXXX] &  
                mov     es:[di-2-4], eax        ;; push [?? + XXXX]) three bytes down
                mov     eax, es:[di-5-4-4]
                mov     es:[di-2-4-4], eax
                mov     ax, 4 + 4               ;; size: 8 bytes
                jmp     short @@patch

@@byte_68:      cmp     es:[di-5-3-3], al
                jne     @@no_68                 ;; not equal? try next

                ;; move (push XXXX & push XXXX) three bytes down
                mov     eax, es:[di-5-4]
                mov     es:[di-2-4], eax
                mov     ax, es:[di-5-4-2]
                mov     es:[di-2-4-2], ax
                mov     ax, 3 + 3               ;; size: 6 bytes
                jmp     short @@patch
GoLabel         endp

;;::::::::::::::
JmpLabel        proc
                mov     bx, sp
                PS      di, es

                les     di, ss:[bx]             ;; es:di -> return address
                _CLI
                mov     B es:[di-5], 0CBh       ;; retf
                mov     D es:[di-4], 0C089C089h ;; mov ax,ax, mov ax,ax
                _STI

                sub     W ss:[bx], 5            ;; re-exec

                PP      es, di
                ret
JmpLabel        endp

;;::::::::::::::
SaveRegs        proc
                push    bx
                push    bp
                push    ds
                mov     bp, sp      

                push    DGROUP
                pop     ds                      ;; ds= DGROUP

                mov     bx, ss:[bp + 10]        ;; bx= ofs(regs)

                mov     ds:[bx], ax
                mov     ds:[bx + 04], cx
                mov     ds:[bx + 06], dx      
                mov     ds:[bx + 10], si
                mov     ds:[bx + 12], di
                pushf
                pop     W ds:[bx + 14]          ;; save flags
                mov     ds:[bx + 18], es

                push    W ss:[bp]
                push    W ss:[bp+2]
                push    W ss:[bp+4]      
                pop     W ds:[bx + 02]          ;; save bx      
                pop     W ds:[bx + 08]          ;;  "   bp      
                pop     W ds:[bx + 16]          ;;  "   ds
                   
                pop     ds
                pop     bp
                pop     bx
                ret     (2)
SaveRegs        endp

;;::::::::::::::
RestoreRegs     proc
                mov     bp, sp      

                push    DGROUP
                pop     ds                      ;; ds= DGROUP

                mov     bx, ss:[bp + 4]         ;; bx= ofs(regs)

                mov     ax, ds:[bx]
                mov     cx, ds:[bx + 04]
                mov     dx, ds:[bx + 06]
                mov     bp, ds:[bx + 08]
                mov     si, ds:[bx + 10]
                mov     di, ds:[bx + 12]
                push    W ds:[bx + 14]
                popf                            ;; restore flags
                mov     es, ds:[bx + 18]

                push    W ds:[bx + 02]
                mov     ds, ds:[bx + 16]
                pop     bx
             
                ret     (2)
RestoreRegs     endp

;;::::::::::::::
PushAll         proc
                push    ebx
                mov     bx, sp
                xchg    eax, ss:[bx + 04]       ;; [caller] <-> eax
          
                ;; stack: eax, ebx, ecx, edx, edi, esi, ebp, es, ds 
                PS      ecx, edx
                PS      edi, esi, ebp
                PS      es, ds
  
                push    eax                     ;; caller

                mov     eax, ss:[bx + 04]       ;; restore eax, ebx
                mov     ebx, ss:[bx + 00]

                ret
PushAll         endp

;;::::::::::::::
PopAll          proc
                pop     eax                     ;; eax= caller

                PP      ds, es
                PP      ebp, esi, edi
                PP      edx, ecx
                mov     bx, sp
                xchg    ss:[bx + 04], eax       ;; eax <-> [caller]
                pop     ebx

                ret
PopAll          endp

;;::::::::::::::
IntrReturn      proc
                mov     bx, sp
                PS      di, es

                les     di, ss:[bx]             ;; es:di -> return address
                _CLI            
                mov     D es:[di-5], 0C089C089h ;; mov ax,ax | mov ax,ax
                mov     B es:[di-1], 0CFh       ;; iret
                _STI

                sub     W ss:[bx], 1            ;; re-exec

                PP      es, di
                ret
IntrReturn      endp

;;::::::::::::::
FarReturn       proc
                mov     bx, sp
                PS      di, es

                les     di, ss:[bx]             ;; es:di -> return address
                _CLI            
                mov     D es:[di-5], 0C089C089h ;; mov ax,ax | mov ax,ax
                mov     B es:[di-1], 0CBh       ;; retf
                _STI

                sub     W ss:[bx], 1            ;; re-exec

                PP      es, di
                ret
FarReturn       endp

;;::::::::::::::
DisableIntr     proc
                mov     bx, sp
                PS      di, es

                les     di, ss:[bx]             ;; es:di -> return address
                _CLI            
                mov     D es:[di-5], 0C089C089h ;; mov ax,ax | mov ax,ax
                mov     B es:[di-1], 0FAh       ;; cli
                _STI

                sub     W ss:[bx], 1            ;; re-exec

                PP      es, di
                ret
DisableIntr     endp 

;;::::::::::::::
EnableIntr      proc
                mov     bx, sp
                PS      di, es

                les     di, ss:[bx]             ;; es:di -> return address
                _CLI             
                mov     D es:[di-5], 0C089C089h ;; mov ax,ax | mov ax,ax
                mov     B es:[di-1], 0FBh       ;; sti
                _STI

                sub     W ss:[bx], 1            ;; re-exec

                PP      es, di
                ret
EnableIntr      endp

;;::::::::::::::
SetDGroup       proc
                push    DGROUP
                pop     ds
                ret
SetDGroup       endp

;;::::::::::::::
PushFlags       proc
                mov     bx, sp
                PS      di, es
             
                les     di, ss:[bx]             ;; es:di -> return address
                pushf
                cli
                mov     D es:[di-5], 0C089C089h ;; mov ax,ax | mov ax,ax
                mov     B es:[di-1], 9Ch        ;; pushf

                sub     W ss:[bx], 1            ;; re-exec

                popf

                PP      es, di
                ret
PushFlags       endp

;;::::::::::::::
PushInt         proc
                mov     bx, sp
                push    es

                les     bx, ss:[bx]             ;; es:bx -> return address
                _CLI
                mov     B es:[bx-5], 066h       ;; 32-bit prefix
                mov     D es:[bx-4], 0C089C089h ;; mov eax,eax + mov ax,ax
                _STI

                pop     es
                ret
PushInt         endp

;;::::::::::::::
PushLong        proc
                mov     bx, sp
                push    es

                les     bx, ss:[bx]             ;; es:bx -> return address
                _CLI
                mov     B es:[bx-5], 066h       ;; 32-bit prefix
                mov     D es:[bx-4], 0C089C089h ;; mov eax,eax + mov ax,ax
                _STI

                pop     es
                ret
PushLong        endp

;;::::::::::::::
PopInt          proc
                mov     bx, sp
                PS      di, es

                les     di, ss:[bx]             ;; es:di -> return address
                _CLI
                mov     B es:[di-5], 5Bh        ;; pop bx
                mov     D es:[di-4], 0C089078Fh ;; pop [bx] | mov ax,ax
                _STI

                sub     W ss:[bx], 5            ;; re-exec

                PP      es, di
                ret
PopInt          endp

;;::::::::::::::
PopLong         proc
                mov     bx, sp
                PS      di, es

                les     di, ss:[bx]             ;; es:di -> return address
                _CLI
                mov     D es:[di-5], 078F665Bh  ;; pop bx | pop dword ptr [bx]
                mov     B es:[di-1], 90h        ;; nop
                _STI

                sub     W ss:[bx], 5            ;; re-exec

                PP      es, di
                ret
PopLong         endp

;;::::::::::::::
MakeLong        proc
                mov     bx, sp

                mov     ax, ss:[bx + 4]
                mov     dx, ss:[bx + 6]

                ret     (4)
MakeLong        endp

;;::::::::::::::
BreakLong       proc
                push    bp
                mov     bp, sp

                mov     ax, ss:[bp + 10]        ;; dx:ax= num
                mov     dx, ss:[bp + 12]

                mov     bx, ss:[bp + 06]
                mov     ds:[bx], ax             ;; lsw= ax

                mov     bx, ss:[bp + 08]
                mov     ds:[bx], dx             ;; msw= dx

                pop     bp
                ret     (8)
BreakLong       endp
                end
