                include include.inc

                QB45            equ 1
                PDS             equ 2
                VBDOS           equ 3

;;::::::::::::::
CRACK           macro   oldp:req, newp:req

                extrn   oldp:far
                mov     ax, S oldp
                mov     es, ax                  ;; es:di -> oldp
                mov     di, O oldp

                mov     B es:[di+0], 0EAh       ;; jmp far ptr
                mov     W es:[di+1], O newp     ;; offset newp             
                mov     W es:[di+3], cs         ;; seg newp                
endm


.data
                extrn   b$seg:word              ;; def_seg, current_seg

ret_addrs       dd      0
bytes           dw      0

.code
cracked         db      FALSE
compiled        db      FALSE

                public  chk_compiled
                public  boostqb

;;::::::::::::::
chk_compiled    proc    far
                ;;  in: bp -> stack= params, caller (QB), bp | caller

                push    di
                push    es

                cmp     cs:compiled, TRUE
                je      @@done                  ;; already checked?

                les     di, [bp + 2]            ;; es:di -> caller (QB)

                ;; check if far call instruction (9A)
                cmp     B es:[di-5], 9Ah
                jne     @@error

                ;; check if segments match
                mov     ax, [bp - 2]            ;; ax= caller segment
                cmp     es:[di-2], ax
                jne     @@error

                mov     cs:compiled, TRUE

@@done:         ;; don't need to check any more
                les     di, [bp - 4]            ;; es:di -> caller
                mov     D es:[di-5], 08B90C08Bh ;; mov ax,ax; nop; mov ax,ax
                mov     B es:[di-1], 0C0h       ;; /

                pop     es
                pop     di
                ret

@@error:        push    bp
                mov     bp, sp                  ;; BC needs bp= sp
                push    5                       ;; error 5= illegal funct call
                extrn   b$serr:far
                call    b$serr
chk_compiled    endp

;;::::::::::::::
chk_compiler    proc    near uses di es

                extrn   b$cenp:far
                mov     ax, S b$cenp
                mov     es, ax
                mov     di, O b$cenp

                cmp     W es:[di+03h], 3E80h
                je      @@isqb45

                cmp     W es:[di+10h], 1574h
                je      @@ispds

                mov     ax, VBDOS
                jmp     short @@exit

@@ispds:        mov     ax, PDS
                jmp     short @@exit

@@isqb45:       mov     ax, QB45

@@exit:         ret
chk_compiler    endp

;;::::::::::::::
boostqb         proc
                push    bp
                mov     bp, sp

                call    far ptr chk_compiled    ;; check if compiled

                push    di
                push    es

                cmp     cs:cracked, TRUE
                je      @@exit                  ;; already cracked?
                mov     cs:cracked, TRUE

                CRACK   B$DSEG, new_dseg

                call    chk_compiler
                cmp     ax, QB45
                jne     @@skip_stack            ;; not QB 4.5?

                CRACK   B$ENRA, new_enra
                CRACK   B$EXSA, new_exsa

@@skip_stack:   CRACK   B$RETA, new_reta

                CRACK   B$MUI4, new_mui4
                CRACK   B$DVI4, new_dvi4
                CRACK   B$RMI4, new_rmi4
                CRACK   B$CPI4, new_cpi4

                CRACK   B$SIN4, new_sin
                CRACK   B$COS4, new_cos
                CRACK   B$TAN4, new_tan
                CRACK   B$ATN4, new_atn
                CRACK   B$SIN8, new_sin
                CRACK   B$COS8, new_cos
                CRACK   B$TAN8, new_tan
                CRACK   B$ATN8, new_atn

                call    ffix                    ;; fwait bug
                             
@@exit:         pop     es
                pop     di

                pop     bp
                ret

@@error:        jmp     short @@exit
boostqb         endp

;;::::::::::::::
new_sin         proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI 
                mov     W es:[di-5+0], 0FED9h   ;; fsin
                mov     W es:[di-5+2], 0C08Bh   ;; mov ax, ax
                mov     B es:[di-5+4], 90h      ;; nop
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_sin         endp 
;;::::::::::::::
new_cos         proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI 
                mov     W es:[di-5+0], 0FFD9h   ;; fcos
                mov     W es:[di-5+2], 0C08Bh   ;; mov ax, ax
                mov     B es:[di-5+4], 90h      ;; nop
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_cos         endp
;;::::::::::::::
new_tan         proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI 
                mov     W es:[di-5+0], 0F2D9h   ;; fptan
                mov     W es:[di-5+2], 0D8DDh   ;; fstp st(0)
                mov     B es:[di-5+4], 90h      ;; nop
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_tan         endp 
;;::::::::::::::
new_atn         proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI
                mov     W es:[di-5+0], 0E8D9h   ;; fld1
                mov     W es:[di-5+2], 0F3D9h   ;; fpatan
                mov     B es:[di-5+4], 90h      ;; nop
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_atn         endp 

;;::::::::::::::
new_mui4        proc
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI                                  ;; call
                mov     W es:[di-5+1], O do_new_mui4  ;; offset do_new_mui4
                mov     W es:[di-5+3], cs             ;; seg do_new_mui4
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_mui4        endp
;;::::::::::::::
do_new_mui4     proc
                pop     ret_addrs               ;; caller
                pop     eax                     ;; eax= multiplicator
                pop     edx                     ;; edx= multiplicand
                imul    edx
                mov     edx, eax
                shr     edx, 16                 ;; dx:ax= product

                jmp     ret_addrs               ;; return to caller
do_new_mui4     endp

;;::::::::::::::
new_dvi4        proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI                                  ;; call
                mov     W es:[di-5+1], O do_new_dvi4  ;; offset do_new_dvi4
                mov     W es:[di-5+3], cs             ;; seg do_new_dvi4
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_dvi4        endp 
;;::::::::::::::
do_new_dvi4     proc 
                pop     ret_addrs               ;; caller
                pop     eax                     ;; eax= dividend
                pop     ecx                     ;; ecx= divisor
                cdq                             ;; convert to qword
                idiv    ecx
                mov     edx, eax
                shr     edx, 16                 ;; dx:ax= quotient

                jmp     ret_addrs               ;; return to caller
do_new_dvi4     endp

;;::::::::::::::
new_rmi4        proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI                                  ;; call
                mov     W es:[di-5+1], O do_new_rmi4  ;; offset do_new_rmi4
                mov     W es:[di-5+3], cs             ;; seg do_new_rmi4
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_rmi4        endp 
;;::::::::::::::
do_new_rmi4     proc 
                pop     ret_addrs               ;; caller
                pop     eax                     ;; eax= dividend
                pop     ecx                     ;; ecx= divisor
                cdq                             ;; convert to qword
                idiv    ecx
                mov     eax, edx
                shr     edx, 16                 ;; dx:ax= reminder

                jmp     ret_addrs               ;; return to caller
do_new_rmi4     endp 

;;::::::::::::::
new_cpi4        proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI                                  ;; call
                mov     W es:[di-5+1], O do_new_cpi4  ;; offset do_new_cpi4
                mov     W es:[di-5+3], cs             ;; seg do_new_cpi4
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_cpi4        endp 
;;::::::::::::::
do_new_cpi4     proc 
                push    bp
                mov     bp, sp

                push    eax
                mov     eax, [bp + 10]          ;; eax= 1st number     
                cmp     eax, [bp + 06]          ;; compare eax with 2nd number
                pop     eax

                pop     bp
                ret     (8)                     ;; return result in flags
do_new_cpi4     endp 

;;::::::::::::::
new_dseg        proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI 
                mov     W es:[di-5+0], 068Fh    ;; pop 
                mov     W es:[di-5+2], O b$seg  ;; b$seg
                mov     B es:[di-5+4], 90h      ;; nop
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_dseg        endp 

;;::::::::::::::
new_enra        proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI 
                mov     B es:[di-5-3+0], 068h   ;; push words to alloc
                                                        ;; call
                mov     W es:[di-5-3+4], O do_new_enra  ;; offset do_new_enra
                mov     W es:[di-5-3+6], cs             ;; seg do_new_enra
                _STI 
                sub     W [bp + 2], 5+3         ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_enra        endp 
;;::::::::::::::
do_new_enra     proc
                pop     ret_addrs               ;; caller
                pop     bytes                   ;; bytes to allocate
             
                push    bp                      ;; the stack frame must
                mov     bp, sp                  ;; be in this stupid sequence
                push    di
                push    si
                push    es
                push    eax
                sub     sp, bytes
             
                push    cx
                mov     cx, bytes
                test    cx, cx
                jz      @@exit                  ;; if bytes= 0, skip

                mov     ax, ds
                mov     es, ax                  ;; es:di -> ss:sp
                mov     di, sp
                push    cx
                shr     cx, 2
                xor     eax, eax                ;; store 0
                rep     stosd                   ;; clear local symbols
                pop     cx
                and     cx, 2
                rep     stosw

@@exit:         pop     cx
                jmp     ret_addrs               ;; return to caller
do_new_enra     endp

;;::::::::::::::
new_exsa        proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI                                  ;; call
                mov     W es:[di-5+1], O do_new_exsa  ;; offset do_new_exsa
                mov     W es:[di-5+3], cs             ;; seg do_new_exsa
                _STI 
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_exsa        endp
;;::::::::::::::
do_new_exsa     proc 
                pop     ret_addrs               ;; caller

                lea     sp, [bp - (10 - 4)]     ;; see do_new_enra  sp= bp - _
                pop     es                      ;;                          <-'
                pop     si
                pop     di                      
                pop     bp

                jmp     ret_addrs               ;; return to caller
do_new_exsa     endp

;;::::::::::::::
new_reta        proc 
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> caller
                _CLI
                mov     B es:[di-5+0], 0C3h     ;; retn
                mov     W es:[di-5+1], 0C08Bh   ;; mov ax, ax
                mov     W es:[di-5+3], 0C08Bh   ;; mov ax, ax
                _STI
                sub     W [bp + 2], 5           ;; re-exec

                pop     es
                pop     di
                pop     bp
                ret
new_reta        endp

;;::::::::::::::
ffix            proc    near
                push ds

                mov     ax, cs
                mov     ds, ax
                mov     dx, O int3d
                mov     ax, 253Dh
                int     21h

                pop     ds
                ret
ffix            endp
;;::::::::::::::
int3d           proc
                push    bp
                mov     bp, sp
                push    di
                push    es

                les     di, [bp + 2]            ;; es:di -> return address                
                mov     W es:[di-2], 909Bh      ;; fwait; nop

                pop     es
                pop     di
                pop     bp
                iret
int3d           endp
                end
