''
'' kbdisr.bas -- shows how to write an interrupt service
''               routine (for keyboard's IRQ) entirely in QB
''

defint a-z
'$include: 'c:\cmp\qb45\include\qb.bi'
'$include: '..\bi\boostqb.bi'

'' some keys...
const kESC   = &H01, kBSPC  = &H0E, kTAB   = &H0F, kENTER = &H1C
const kCTRL  = &H1D, kLFSH  = &H2A, kRGSH  = &H36, kALT   = &H38
const kSPC   = &H39, kHOME  = &H47, kUP    = &H48, kPGUP  = &H49
const kMIN   = &H4A, kLEFT  = &H4B, kMID   = &H4C, kRIGHT = &H4D
const kPLUS  = &H4E, kEND   = &H4F, kDOWN  = &H50, kPGDW  = &H51
const kINS   = &H52, kDEL   = &H53

'' options to 'KbdHandler':
const INSTALL = 1, REMOVE = 2

declare sub KbdHandler (opt as integer)

dim shared kbd(0 to 127) as integer

'':::

  KbdHandler INSTALL

  cls
  do
     locate 1, 1: print kbd(kHOME); kbd(kUP); kbd(kPGUP); "   "
     locate 2, 1: print kbd(kLEFT); kbd(kSPC); kbd(kRIGHT); "   "
     locate 3, 1: print kbd(kEND); kbd(kDOWN); kbd(kPGDW); "   "
  loop until kbd(kESC)

  KbdHandler REMOVE
  
'':::
sub KbdHandler (opt as integer)
 
  static kbdflag as integer             '' \
  static old09 as long                  ''  +-- these must be in dgroup
  static scode as integer               '' /

  dim ptr as long                       '' temp variables
  dim regs as RegTypeX               
  dim i as integer                   

  '':::
  if (opt = INSTALL) then               '' install keyboard handler?
 
     if (kbdflag) then                  '' already installed?
        exit sub
     else
        kbdflag = 1
     end if

     '' get keyboardHandler label address
     labelptr ptr                       '' ptr= address of keyboardHandler
     gosub keyboardHandler              '' this line will be skipped
     '' \---> never use GOTO with VBDOS or the next lines will be skipped
                                         
     '' save current int vector
     regs.ax = &h3509                   '' service 35h (get interrupt vector)
     interruptx &h21, regs, regs
     old09 = makelong(regs.es, regs.bx)

     for i = 0 to 127                   '' clear key array
         kbd(i) = 0
     next i

     '' set new int vector
     breaklong ptr, regs.ds, regs.dx    '' ds:dx -> keyboardHandler
     regs.ax = &h2509                   '' service 25h (set interrupt vector)
     interruptx &h21, regs, regs

  '':::
  else

     if (kbdflag = 0) then              '' not installed?
        exit sub
     else
        kbdflag = 0
     end if

     def seg = &h40                     '' clear bios keyboard buffer
     poke &h1A, peek(&h1C)              '' head= tail

     '' restore old int vector
     breaklong old09, regs.ds, regs.dx  '' ds:dx -> old09
     regs.ax = &h2509                   '' service 25h (set interrupt vector)
     interruptx &h21, regs, regs
  end if

  exit sub

'':::
keyboardHandler:
  '' This must be a LABEL instead of a SUB, because:
  ''
  '' 1st) QB trashes some registers when entering in a SUB and doesn't give
  ''      the chance to first call a function to save them to us, and an 
  ''      interrupt service routine must save everything or system may crash.
  ''      
  '' 2nd) QB calls a routine to allocate and clear the local symbols when
  ''      the function is initialized, and calls a routine to free the stack
  ''      when the function finishes, making it incompatible with an ISR.
  ''
  '' 3th) QB assumes SS = DS, but it frequently (if not always) doesn't
  ''      happen (as DOS'll set a stack automatically before jumps to our ISR).

  pushall                               '' save all registers
  setdgroup                             '' ds= dgroup

  scode = inp(&h60)                     '' bit7: 1= realized 0= pressed
  kbd(scode and &h7F) = ((scode and &h80) = 0)

  out &h20, &h20                        '' non-specific eoi for PIC

  popall                                '' restore all registers
  intrreturn                            '' return from interrupt
end sub
