''
'' imgscale.bas -- scales an image using peek#, poke# and Shift functions
'' 

defint a-z
'$include: '..\bi\boostqb.bi'

const XMIN = 0, YMIN = 0
const XMAX = 319, YMAX = 199
const IMGWIDTH = 32, IMGHEIGHT = 32

declare sub imgscale (img() as integer, _
                      x1 as integer, y1 as integer, _
                      newwidth as integer, newheight as integer)

  dim img(0 to (IMGWIDTH*IMGHEIGHT)\2 + 2 - 1) as integer

  boostqb

  randomize timer

  screen 13
 
  '' set a linear pallete
  out &h3c8, 0
  for c = 0 to IMGWIDTH-1
      out &h3c9, c
      out &h3c9, c 
      out &h3c9, c * 2
  next c

  '' create an image
  for y = 0 to IMGHEIGHT-1
      for x = 0 to IMGWIDTH-1
          pset (x, y), y and x
      next x
  next y
  line (0, 0)-(IMGWIDTH-1, IMGHEIGHT-1), IMGWIDTH-1, b
  get (0, 0)-(IMGWIDTH-1, IMGHEIGHT-1), img(0)

  '' show it
  do
     for i = 0 to 15
         cx = rnd * 320
         cy = rnd * 200
         wdt = (IMGWIDTH\2) + cint(rnd * (IMGWIDTH*4))
         hgt = (IMGHEIGHT\2) + cint(rnd * (IMGHEIGHT*4))
         imgscale img(), cx - SHR(1, wdt), cy - SHR(1, hgt), wdt, hgt
     next i
  loop while (inkey$ = "")


'':::
sub imgscale (img() as integer, x1 as integer, y1 as integer, _
              newwidth as integer, newheight as integer) static

  dim x as integer, clipw as integer, xini as integer, leftgap as integer
  dim y as integer, cliph as integer, yini as integer, topgap as integer
  dim src as long, s as long
  dim dst as long, d as long
  dim oldwidth as integer, oldheight as integer, wdt as integer
  dim inc as integer, brc as integer
  dim xinctb(0 to 319) as integer, yinctb(0 to 199) as integer
  
  src = pointer(img(0)) + 4

  oldwidth = SHR(3, img(0))                     '' \ 8
  oldheight = img(1)

  '' clipping
  if (x1 > XMAX) then
     exit sub
  elseif (x1 + newwidth < XMIN) then
     exit sub
  end if

  if (y1 > YMAX) then
     exit sub
  elseif (y1 + newheight < YMIN) then
     exit sub
  end if

  '' horizontal clipping
  clipw = newwidth
  xini = 0
  if (x1 + newwidth > XMAX) then
     clipw = clipw - ((x1 + (newwidth - 1)) - XMAX)
  end if
  if (x1 < XMIN) then
     leftgap = XMIN - x1
     clipw = clipw - leftgap
     src = src + ((leftgap * oldwidth) \ newwidth)
     xini = (((leftgap * oldwidth) \ newwidth) * newwidth) - (leftgap * oldwidth)
     x1 = XMIN
  end if

  '' vertical clipping
  cliph = newheight
  yini = 0
  if (y1 + newheight > YMAX) then
     cliph = cliph - ((y1 + (newheight - 1)) - YMAX)
  end if
  if (y1 < YMIN) then
     topgap = YMIN - y1
     cliph = cliph - topgap
     src = src + (((topgap * oldheight) \ newheight) * oldwidth)
     yini = ((topgap * oldheight) - (((topgap * oldheight) \ newheight) * newheight))
     y1 = YMIN
  end if
  
  '' create xinctb()
  if (newwidth >= oldwidth) then                '' stretch width
     brc = newwidth + xini
     for x = 0 to clipw - 1
         brc = brc - oldwidth
         if (brc <= 0) then
            brc = brc + newwidth
            inc = 1
         else
            inc = 0
         end if
         xinctb(x) = inc
     next x
 
  else                                          '' shrink width
     brc = oldwidth + xini
     for x = 0 to clipw - 1
         inc = 0
         do
            inc = inc + 1
            brc = brc - newwidth
         loop while (brc >= 0)
         brc = brc + oldwidth
         xinctb(x) = inc
     next x
  end if
 
  '' create yinctb()
  if (newheight >= oldheight) then              '' stretch height
     brc = newheight - yini
     for y = 0 to cliph - 1
         brc = brc - oldheight
         if (brc <= 0) then
            brc = brc + newheight
            inc = oldwidth
         else
            inc = 0
         end if
         yinctb(y) = inc
     next y

  else                                          '' shrink height
     brc = oldheight - yini
     for y = 0 to cliph - 1
         inc = 0
         do
            inc = inc + oldwidth
            brc = brc - newheight
         loop while (brc >= 0)
         brc = brc + oldheight
         yinctb(y) = inc
     next y
  end if

  '' now... draw it :)
  dst = &hA0000000& + (y1 * 320 + x1)

  for y = 0 to cliph - 1
      s = src
      d = dst
      i = 0
        
      wdt = clipw

      '' align destine on dword boundary
      do while (cint(d and 3) > 0) and (wdt > 0)
         p0 = peekb(s)
         s = s + xinctb(i)

         i = i + 1

         pokeb d, p0
         d = d + 1
         wdt = wdt - 1
      loop

      '' draw middle (4 pixels at time)
      for x = 1 to SHR(2, wdt)
         p0 = peekb(s)
         s = s + xinctb(i + 0)
         p1 = peekb(s)
         s = s + xinctb(i + 1)
         p2 = peekb(s)
         s = s + xinctb(i + 2)
         p3 = peekb(s)
         s = s + xinctb(i + 3)

         i = i + 4

         pokel d, LSHL(24, p3) or LSHL(16, p2) or SHL(8, p1) or p0
         d = d + 4
      next x
        
      '' draw remainder
      for x = 1 to (wdt and 3)
         p0 = peekb(s)
         s = s + xinctb(i)

         i = i + 1

         pokeb d, p0
         d = d + 1
      next x
        
      dst = dst + 320                           '' next line
      src = src + yinctb(y)                     '' /
  next y
end sub
