''
'' imgrot.bas -- rotates an image using peek#, poke# and Shift functions
'' 

defint a-z
'$include: '..\bi\boostqb.bi'

const XMIN = 0, YMIN = 0
const XMAX = 319, YMAX = 199
const IMGWIDTH = 32, IMGHEIGHT = 32
const FIXMUL = 2048, FIXSFT = 11

declare sub imgrotate  (cx as integer, cy as integer, _
                        img() as integer, angle as integer, zoom as long)
declare sub maketables ()

dim shared sine(0 to 359) as integer
dim shared cosn(0 to 359) as integer
dim shared ypos(0 to 199) as integer

'':::
  dim angle as integer
  dim zoom as long, zdir as integer
  dim cx as integer, cy as integer
  dim img(0 to (IMGWIDTH*IMGHEIGHT)\2 + 2 - 1) as integer

  boostqb
  
  randomize timer
  
  maketables

  screen 13
              
  '' set a linear pallete
  out &h3c8, 0
  for c = 0 to IMGWIDTH-1
      out &h3c9, c
      out &h3c9, c
      out &h3c9, c * 2
  next c

  '' create an image
  for y = 0 to IMGHEIGHT-1
      for x = 0 to IMGWIDTH-1
          pset (x, y), y and x
      next x
  next y
  get (0, 0)-(IMGWIDTH-1, IMGHEIGHT-1), img(0)
   
  '' show it
  angle = 0
  zoom = FIXMUL
  zdir = FIXMUL\16
  cx = 160
  cy = 100
  do
     imgrotate cx, cy, img(), angle, zoom

     angle = angle + 15
     if (angle >= 360) then angle = angle - 360
     
     zoom = zoom + zdir
     if (zoom > FIXMUL*4) then
        zoom = FIXMUL*4
        zdir = -zdir
     elseif (zoom < FIXMUL\4) then
        zoom = FIXMUL\4
        zdir = -zdir
        cx = cint(rnd * 319)
        cy = cint(rnd * 199)
     end if
  loop while (inkey$ = "")

'':::
sub maketables
    
  dim i as integer
  dim l as integer
  dim rad as single

  rad = 0                              '' make integer sine &
  for i = 0 to 359                     ''  cosine tables (* FIXMUL)
      sine(i) = cint(sin(rad) * FIXMUL)
      cosn(i) = cint(cos(rad) * FIXMUL)
      rad = rad + (3.141593 / 180)     '' angle= angle + 1
  next i

  l = 0                                '' make line table 
  for i = 0 to IMGHEIGHT-1
      ypos(i) = l
      l = l + IMGWIDTH                 '' next line
  next i

end sub

'':::
sub imgrotate (cx as integer, cy as integer, _
            img() as integer, angle as integer, zoom as long) static
       
  dim rowu as long, rowv as long
  dim du as long, dv as long
  dim u as long, v as long
  dim tx as integer, ty as integer
  dim newx as integer, newy as integer
    
  dim y as integer, x as integer
  dim wdt as integer, hgt as integer
  dim x1 as integer, y1 as integer

  dim ofs as integer
  dim sa as integer, ca as integer

  dim xend as long, xini as long
  dim yend as long, yini as long

  wdt = shr(3, img(0))
  hgt = img(1)
   
  sa = LSAR(FIXSFT, abs(sine(angle) * zoom))
  ca = LSAR(FIXSFT, abs(cosn(angle) * zoom))
  newy = LSAR(FIXSFT, (clng(ca) * hgt) + (clng(sa) * wdt))
  newx = LSAR(FIXSFT, (clng(sa) * hgt) + (clng(ca) * wdt))

  clipsource = -1
  if ((angle = 0) or (angle = 90) or (angle = 180) or (angle = 270)) then
     clipsource = 0
  end if
     
  '' horizontal clipping
  x1 = cx - SAR(1, newx)
  if ((x1 > XMAX) or (x1 + newx < XMIN)) then
     exit sub
  end if
  if (x1 + newx > XMAX) then
     newx = newx - ((x1 + (newx - 1)) - XMAX)
  end if
  if (x1 < XMIN) then
     newx = newx - (XMIN - x1)
     x1 = XMIN
  end if
   
  '' vertical clipping
  y1 = cy - SAR(1, newy)
  if ((y1 > YMAX) or (y1 + newy < YMIN)) then
     exit sub
  end if
  if (y1 + newy > YMAX) then
     newy = newy - ((y1 + (newy - 1)) - YMAX)
  end if
  if (y1 < YMIN) then
     newy = newy - (YMIN - y1)
     y1 = YMIN
  end if
    
  '' calc texture indexes
  du = LSAL(FIXSFT, sine(angle)) \ zoom
  dv = LSAL(FIXSFT, cosn(angle)) \ zoom
  rowu = LSAL(FIXSFT-1, wdt) - ((cx - x1) * dv) - ((cy - y1) * du)
  rowv = LSAL(FIXSFT-1, hgt) - ((cy - y1) * dv) + ((cx - x1) * du)

  srcseg = varseg(img(0))
  srcofs = varptr(img(0)) + 4

  for y = 1 to newy
      u = rowu
      v = rowv

      ofs = (y1 * 320) + x1
      xx = newx
        
      yini = v
      yend = v - (du * newx)
        
      xini = u
      xend = u + (dv * newx)
        
      if (clipsource) then
         '' source clipping (height)
         if (yini < yend) then
            do while (cint(LSAR(FIXSFT, v)) < 0)
               u = u + dv
               v = v - du
               ofs = ofs + 1
               xx = xx - 1
            loop
            do while (cint(LSAR(FIXSFT, yend)) >= hgt)
               yend = yend + du
               xx = xx - 1
            loop
      
         elseif (yini > yend) then
            do while (cint(LSAR(FIXSFT, v)) >= hgt)
               u = u + dv
               v = v - du
               ofs = ofs + 1
               xx = xx - 1
            loop
            do while (cint(LSAR(FIXSFT, yend)) < 0)
               yend = yend + du
               xx = xx - 1
            loop
         end if
        
         '' (width)
         if (xini < xend) then
            do while (cint(LSAR(FIXSFT, u)) < 0)
               u = u + dv
               v = v - du
               ofs = ofs + 1
               xx = xx - 1
            loop
            do while (cint(LSAR(FIXSFT, xend)) >= wdt)
               xend = xend - dv
               xx = xx - 1
            loop
        
         elseif (xini > xend) then
            do while (cint(LSAR(FIXSFT, u)) >= wdt)
               u = u + dv
               v = v - du
               ofs = ofs + 1
               xx = xx - 1
            loop
            do while (cint(LSAR(FIXSFT, xend)) < 0)
               xend = xend - dv
               xx = xx - 1
            loop
         end if
      end if

      '' draw scanline
      if (xx > 0) then
         '' align destine on dword boundary
         do while ((ofs and 3) > 0) and (xx > 0)
            p0 = peekb2(srcofs + ypos(cint(LSHR(FIXSFT, v))) + _
                        cint(LSHR(FIXSFT, u)), srcseg)
            u = u + dv
            v = v - du
            
            pokeb2 ofs, &hA000, p0
            ofs = ofs + 1
            xx = xx - 1
         loop
            
         '' draw middle (4 pixels at time)
         for x = 1 to SHR(2, xx)
             p0 = peekb2(srcofs + ypos(cint(LSHR(FIXSFT, v))) + _
                         cint(LSHR(FIXSFT, u)), srcseg)
             u = u + dv
             v = v - du
             p1 = peekb2(srcofs + ypos(cint(LSHR(FIXSFT, v))) + _
                         cint(LSHR(FIXSFT, u)), srcseg)
             u = u + dv
             v = v - du
             p2 = peekb2(srcofs + ypos(cint(LSHR(FIXSFT, v))) + _
                         cint(LSHR(FIXSFT, u)), srcseg)
             u = u + dv
             v = v - du
             p3 = peekb2(srcofs + ypos(cint(LSHR(FIXSFT, v))) + _
                         cint(LSHR(FIXSFT, u)), srcseg)
             u = u + dv
             v = v - du

             pokel2 ofs, &hA000, LSHL(24, p3) or LSHL(16, p2) or _
                                 SHL(8, p1) or p0
             ofs = ofs + 4
         next x
         
         '' draw remainder
         for x = 1 to (xx and 3)
             p0 = peekb2(srcofs + ypos(cint(LSHR(FIXSFT, v))) + _
                         cint(LSHR(FIXSFT, u)), srcseg)
             u = u + dv
             v = v - du
            
             pokeb2 ofs, &hA000, p0
             ofs = ofs + 1
         next x
      end if
        
      y1 = y1 + 1
      rowu = rowu + du
      rowv = rowv + dv
  next y
end sub
