''
'' absolute.bas -- shows how to write directly to screen using an array
''

defint a-z
'$include: '..\bi\boostqb.bi'

const SCRWIDTH  = 320
const SCRHEIGHT = 200

declare sub linpal (rmax as integer, gmax as integer, bmax as integer)

  redim video(0, 0) as long
  call redimabs(SCRWIDTH \ 4, SCRHEIGHT, &hA0000000&, video())

  screen 13
  linpal 0, 64, 0

  tmr# = timer
  do
     for y = 0 to SCRHEIGHT - 1
         clr = (clr + 1) and 255
         cccc& = LSHL(24, clr) or LSHL(16, clr) or LSHL(8, clr) or clng(clr)

         for x = 0 to (SCRWIDTH \ 4) - 1
             video(x, y) = cccc&
         next x
     next y

     fps1 = fps1 + 1
  loop until (timer - tmr# >= 5)

  cls
  linpal 0, 0, 64

  def seg = &hA000
  tmr# = timer
  do
     offs = 0
     for y = 0 to SCRHEIGHT - 1
         clr = (clr + 1) and 255

         for x = 0 to SCRWIDTH - 1 step 4
             poke offs + 0, clr
             poke offs + 1, clr
             poke offs + 2, clr
             poke offs + 3, clr
             offs = offs + 4
         next x
     next y

     fps2 = fps2 + 1
  loop until (timer - tmr# >= 5)

  screen 0: width 80, 25
  print using "fps: using redimabs:###  using def seg/poke:###"; fps1\5; fps2\5

  end

'':::
sub linpal (rmax as integer, gmax as integer, bmax as integer) static

  rinc = SHL(8, rmax) \ 256
  ginc = SHL(8, gmax) \ 256
  binc = SHL(8, bmax) \ 256

  r = 0
  g = 0
  b = 0

  out &h3c8, 0
  for i = 0 to 255
      out &h3c9, SHR(8, r)
      out &h3c9, SHR(8, g)
      out &h3c9, SHR(8, b)
      r = r + rinc
      g = g + ginc
      b = b + binc
  next i
end sub
