''
'' boostqb.bi - include file for boostqb library
''
type REGS
  ax           as integer
  bx           as integer
  cx           as integer
  dx           as integer
  bp           as integer
  si           as integer
  di           as integer
  flags        as integer
  ds           as integer
  es           as integer
end type
''
declare sub      ProcPtr       (ptr as long)
declare sub      LabelPtr      (ptr as long)
declare sub      MultiLabelPtr (seg ptrArray as long, _
                                byval labels as integer)
''
declare sub      GoLabel       (byval ptr as long)
declare sub      JmpLabel      (byval ptr as long)
''
declare function IntegerRet%   ()
declare function LongRet&      ()
declare function StringRet$    ()
''
declare sub      SaveRegs      (regs as REGS)
declare sub      RestoreRegs   (regs as REGS)
''
declare sub      PushAll       ()
declare sub      PopAll        ()
declare sub      PushInt       (byval num as integer)
declare sub      PopInt        (num as integer)
declare sub      PushLong      (byval lng as long)
declare sub      PopLong       (lng as long)
declare sub      IntrReturn    ()
declare sub      FarReturn     ()
declare sub      EnableIntr    ()
declare sub      DisableIntr   ()
declare sub      SetDGroup     ()
declare sub      PushFlags     ()
''
declare function MakeLong&     (byval msw as integer, _
                                byval lsw as integer)
declare sub      BreakLong     (byval lng as long, _
                                msw as integer, _
                                lsw as integer)
''
''
declare function SHR%          cdecl (byval times as integer, _
                                byval number as integer)
declare function SHL%          cdecl (byval times as integer, _
                                byval number as integer)
declare function SAR%          cdecl (byval times as integer, _
                                byval number as integer)
declare function SAL%          cdecl alias "_SHL" (byval times as integer, _
                                byval number as integer)
declare function ROR%          cdecl (byval times as integer, _
                                byval number as integer)
declare function ROL%          cdecl (byval times as integer, _
                                byval number as integer)
declare function LSHR&         cdecl (byval times as integer, _
                                byval number as long)
declare function LSHL&         cdecl (byval times as integer, _
                                byval number as long)
declare function LSAR&         cdecl (byval times as integer, _
                                byval number as long)
declare function LSAL&         cdecl alias "_LSHL" (byval times as integer, _
                                byval number as long)
declare function LROR&         cdecl (byval times as integer, _
                                byval number as long)
declare function LROL&         cdecl (byval times as integer, _
                                byval number as long)
''
''
declare function pointer&      (seg array as any)
''
declare function peekb%        cdecl (byval src as long)
declare function peekb2%       cdecl alias "_peekb" (byval ofs as integer, _
                                byval segm as integer)
declare function peeki%        cdecl (byval src as long)
declare function peeki2%       cdecl alias "_peeki" (byval ofs as integer, _
                                byval segm as integer)
declare function peekl&        cdecl (byval src as long)
declare function peekl2&       cdecl alias "_peekl" (byval ofs as integer, _
                                byval segm as integer)
''
declare sub      pokeb         cdecl (byval dst as long, _
                                byval value as integer)
declare sub      pokeb2        cdecl alias "_pokeb" (byval ofs as integer, _
                                byval segm as integer, _
                                byval value as integer)
declare sub      pokei         cdecl (byval dst as long, _
                                byval value as integer)
declare sub      pokei2        cdecl alias "_pokei" (byval ofs as integer, _
                                byval segm as integer, _
                                byval value as integer)
declare sub      pokel         cdecl (byval dst as long, _
                                byval value as long)
declare sub      pokel2        cdecl alias "_pokel" (byval ofs as integer, _
                                byval segm as integer, _
                                byval value as long)
''
''
declare sub      boostqb       ()
''
''
''declare sub redimabs (... subscripts ..., farptr, array())
