;----------------------------------------------------------------------------
;
;  CosmoX TIMER Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

.DATA

ALIGN 2

ElapsedTicks        DD  0           ; Used to count the ticks and call BIOS
TimerCount          DD  0174Eh      ; Divisor of PIT counter (1234DDh / 200)
OldInt8Address      DD  ?           ; BIOS IRQ timer handler address
UserTImerTicks      DD  16 dup(0)   ; User timer elapsed ticks
UserTimer           DD  16 dup(-1)  ; User timers frequency (im milliseconds)
UserTimerCount      DD  16 dup(0)   ; User timers counters
UserTimerFlag       DD  16 dup(0)   ; User timers flags
TimerInstalled      DB  0           ; Is the timer installed ?

.CODE

PUBLIC  CSInstallTimer, CSRemoveTimer, CSSetTimer, CSTimerFlag, CSElapsedTicks
PUBLIC  CSResetTicks, CSWaitTimer

CSInstallTimer PROC
  MOV DL, TimerInstalled
  OR  DL, DL
  JNZ DontInstall
  XOR DX, DX
  MOV ES, DX
  CLI
  MOV EDX, ES:[20h]
  MOV OldInt8Address, EDX
  MOV AX, OFFSET TimerISR
  MOV DX, SEG TimerISR
  MOV ES:[20h], AX
  MOV ES:[22h], DX
  STI
  MOV AL, 1
  MOV TimerInstalled, AL
  XOR EBX, EBX
  MOV ElapsedTicks, EBX
  MOV EDX, TimerCount
  MOV AL, 034h
  OUT 043h, AL
  MOV AL, DL
  OUT 040h, AL
  MOV AL, DH
  OUT 040h, AL
DontInstall:
  RET
TimerISR:
  PUSH DS
  PUSHAD
  MOV AX, @DATA
  MOV DS, AX
  XOR SI, SI
UpdateTimers:
  MOV BX, SI
  SHL BX, 2
  MOV EDX, UserTimer[BX]
  CMP EDX, -1
  JE  NoUserTimer
  MOV EAX, UserTimerCount[BX]
  ADD EAX, 5
  MOV UserTimerCount[BX], EAX
  CMP EAX, EDX
  JB  NoUserTimer
  SUB EAX, EDX
  MOV ECX, 1
  MOV UserTimerCount[BX], EAX
  MOV UserTimerFlag[BX], ECX
  INC UserTImerTicks[BX]
NoUserTimer:
  INC SI
  CMP SI, 16
  JNE UpdateTimers
  MOV EAX, ElapsedTicks
  ADD EAX, TimerCount
  MOV ElapsedTicks, EAX
  CMP EAX, 10000h
  JL  TimerAcknowledge
  SUB EAX, 10000h
  MOV ElapsedTicks, EAX
  PUSHF
  CALL [OldInt8Address]
  JMP TimerFinish
TimerAcknowledge:
  MOV AL, 020h
  OUT 020h, AL
TimerFinish:
  POPAD
  POP DS
  IRET
CSInstallTimer ENDP

CSRemoveTimer PROC
  MOV AL, TimerInstalled
  OR  AL, AL
  JZ  AlreadyRemoved
  XOR DX, DX
  MOV ES, DX
  CLI
  MOV EAX, OldInt8Address
  MOV ES:[20h], EAX
  STI
  MOV AL, 034h
  OUT 043h, AL
  XOR EAX, EAX
  OUT 040h, AL
  OUT 040h, AL
  XOR EAX, EAX
  MOV TimerInstalled, AL
  MOV ECX, -1
  XOR SI, SI
ResetFlags:
  MOV BX, SI
  SHL BX, 2
  MOV UserTimer[BX], ECX
  MOV UserTimerFlag[BX], EAX
  MOV UserTImerTicks[BX], EAX
  INC SI
  CMP SI, 16
  JNE ResetFlags
AlreadyRemoved:
  RET
CSRemoveTimer ENDP

CSSetTimer PROC
  PUSH BP
  MOV BP, SP
  MOV DL, TimerInstalled
  OR  DL, DL
  JZ  EndSetTimer
  MOV BX, [BP+10]
  CMP BX, 16
  JAE EndSetTimer
  SHL BX, 2
  XOR EAX, EAX
  MOV EDX, [BP+06]
  MOV UserTimer[BX], EDX
  MOV UserTimerCount[BX], EAX
  MOV UserTimerFlag[BX], EAX
  MOV UserTimerTicks[BX], EAX
EndSetTimer:
  POP BP
  RET 6
CSSetTimer ENDP

CSTimerFlag PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV DL, TimerInstalled
  OR  DL, DL
  JZ  EndTimerFlag
  MOV BX, [BP+06]
  CMP BX, 16
  JAE EndTimerFlag
  SHL BX, 2
  MOV EAX, UserTimer[BX]
  CMP EAX, -1
  JE  EndTimerFlag
  MOV EAX, UserTimerFlag[BX]
  OR  EAX, EAX
  JZ  EndTimerFlag
  XOR EDX, EDX
  MOV UserTimerFlag[BX], EDX
  MOV AX, 1
EndTimerFlag:
  POP BP
  RET 2
CSTimerFlag ENDP

CSElapsedTicks PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  XOR DX, DX
  MOV CL, TimerInstalled
  OR  CL, CL
  JZ  EndElapsedTicks
  MOV BX, [BP+06]
  CMP BX, 16
  JAE EndElapsedTicks
  SHL BX, 2
  MOV EAX, UserTimerTicks[BX]
  MOV EDX, EAX
  SHR EDX, 16
EndElapsedTicks:
  POP BP
  RET 2
CSElapsedTicks ENDP

CSResetTicks PROC
  PUSH BP
  MOV BP, SP
  MOV DL, TimerInstalled
  OR  DL, DL
  JZ  EndResetTicks
  MOV BX, [BP+06]
  CMP BX, 16
  JAE EndResetTicks
  SHL BX, 2
  XOR EAX, EAX
  MOV UserTimerTicks[BX], EAX
EndResetTicks:
  POP BP
  RET 2
CSResetTicks ENDP

CSWaitTimer PROC
  PUSH BP
  MOV BP, SP
  MOV DL, TimerInstalled
  OR  DL, DL
  JZ  EndWait
  MOV BX, [BP+06]
  CMP BX, 16
  JAE EndWait
  SHL BX, 2
  MOV EDX, UserTimer[BX]
  CMP EDX, -1
  JE  EndWait
WaitLoop:
  MOV EAX, UserTimerFlag[BX]
  OR  EAX, EAX
  JZ  WaitLoop
  XOR EAX, EAX
  MOV UserTimerFlag[BX], EAX
EndWait:
  POP BP
  RET 2
CSWaitTimer ENDP

END
