;----------------------------------------------------------------------------
;
;  CosmoX SPRITE Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

EXTRN BMapActive  :  BYTE
EXTRN BMapSeg     :  WORD
EXTRN ClipX1      :  WORD
EXTRN ClipX2      :  WORD
EXTRN ClipY1      :  WORD
EXTRN ClipY2      :  WORD

.DATA

ALIGN 2

ScaleX              DD  ?               ;  Scaling sprites variable
ScaleY              DD  ?               ;  Scaling sprites variable
ScaleXAdd           DD  ?               ;  Scaling sprites variable
ScaleYAdd           DD  ?               ;  Scaling sprites variable
PointX              DW  ?               ;  Just some variables to help me
PointY              DW  ?               ;  Just some variables to help me
SHeight             DW  ?               ;  Sprite Height
SWidth              DW  ?               ;  Sprite Width
INCLUDE SINCOS.INC

.CODE

PUBLIC  CSSize, CSGet, CSSprite, CSSpriteC, CSSpriteB, CSSpriteF, CSSpriteO
PUBLIC  CSSpriteFlipH, CSSpriteFlipV, CSSpriteFlipped, CSSpriteS, CSSpriteR
PUBLIC  CSSpriteRZ, CSCollision, CSCollisionC, CSCollide

CSSize PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+08]
  SUB AX, [BP+12]
  INC AX
  MOV CX, [BP+06]
  SUB CX, [BP+10]
  INC CX
  MUL CX
  ADD AX, 4
  SHR AX, 1
  POP BP
  RET 8
CSSize ENDP

CSGet PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+22]
  MOV DS, AX
  MOV AX, [BP+12]
  MOV ES, AX
  MOV DI, [BP+08]
  MOV AX, [BP+18]
  MOV SI, AX
  SHL AX, 8
  SHL SI, 6
  ADD SI, AX
  ADD SI, [BP+20]
  MOV AX, [BP+14]
  SUB AX, [BP+18]
  INC AX
  MOV DX, AX
  MOV AX, [BP+16]
  SUB AX, [BP+20]
  INC AX
  SHL AX, 3
  MOV ES:[DI], AX
  ADD DI, 2
  SHR AX, 3
  MOV ES:[DI], DX
  ADD DI, 2
  MOV CX, AX
  TEST CX, 3
  JZ  DWordGet
  TEST CX, 1
  JZ  WordGet
ByteGet:
  MOV CX, AX
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
  SUB SI, AX
  ADD SI, 320
  DEC DX
  JNZ ByteGet
  JMP EndGet
DWordGet:
  MOV CX, AX
  SHR CX, 2
  REP MOVSD
  SUB SI, AX
  ADD SI, 320
  DEC DX
  JNZ DWordGet
  JMP EndGet
WordGet:
  MOV CX, AX
  SHR CX, 1
  REP MOVSW
  SUB SI, AX
  ADD SI, 320
  DEC DX
  JNZ WordGet
EndGet:
  POP DS
  POP BP
  RET 16
CSGet ENDP

CSSprite PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+16]
  MOV ES, AX
  MOV AX, [BP+10]
  MOV GS, AX
  MOV SI, [BP+06]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+12]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  MOV DX, [BP+12]
  MOV CX, [BP+14]
SpriteLoop:
  MOV AL, GS:[SI]
  INC SI
  OR  AL, AL
  JZ  SkipSpritePixel
  CMP CX, ClipX1
  JL  SkipSpritePixel
  CMP CX, ClipX2
  JG  SkipSpritePixel
  CMP DX, ClipY1
  JL  SkipSpritePixel
  CMP DX, ClipY2
  JG  SkipSpritePixel
  MOV ES:[DI], AL
SkipSpritePixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ SpriteLoop
  MOV CX, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ SpriteLoop
  POP BP
  RET 12
CSSprite ENDP

CSSpriteB PROC
  PUSH BP
  MOV BP, SP
  MOV DL, BMapActive
  OR  DL, DL
  JZ  EndSpriteB
  MOV AX, BMapSeg
  MOV FS, AX
  MOV AX, [BP+16]
  MOV ES, AX
  MOV AX, [BP+10]
  MOV GS, AX
  MOV SI, [BP+06]
  XOR AX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+12]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  MOV DX, [BP+12]
  MOV CX, [BP+14]
SpriteBLoop:
  MOV AL, GS:[SI]
  INC SI
  OR  AL, AL
  JZ  SkipSpriteBPixel
  CMP CX, ClipX1
  JL  SkipSpriteBPixel
  CMP CX, ClipX2
  JG  SkipSpriteBPixel
  CMP DX, ClipY1
  JL  SkipSpriteBPixel
  CMP DX, ClipY2
  JG  SkipSpriteBPixel
  PUSH BX
  MOV BL, ES:[DI]
  MOV BH, AL
  MOV AL, FS:[BX]
  POP BX
  MOV ES:[DI], AL
SkipSpriteBPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ SpriteBLoop
  MOV CX, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ SpriteBLoop
EndSpriteB:
  POP BP
  RET 12
CSSpriteB ENDP

CSSpriteC PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+18]
  MOV ES, AX
  MOV AX, [BP+12]
  MOV GS, AX
  MOV SI, [BP+08]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  MOV DX, [BP+14]
  MOV CX, [BP+16]
SpriteCLoop:
  MOV AL, GS:[SI]
  INC SI
  OR  AL, AL
  JZ  SkipSpriteCPixel
  CMP CX, ClipX1
  JL  SkipSpriteCPixel
  CMP CX, ClipX2
  JG  SkipSpriteCPixel
  CMP DX, ClipY1
  JL  SkipSpriteCPixel
  CMP DX, ClipY2
  JG  SkipSpriteCPixel
  MOV AL, [BP+06]
  MOV ES:[DI], AL
SkipSpriteCPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ SpriteCLoop
  MOV CX, [BP+16]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ SpriteCLoop
  POP BP
  RET 14
CSSpriteC ENDP

CSSpriteF PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV ES, AX
  MOV AX, [BP+12]
  MOV DS, AX
  MOV SI, [BP+08]
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  MOV AX, [SI]
  ADD SI, 2
  MOV DX, AX
  SHR DX, 3
  MOV BX, 320
  SUB BX, DX
  MOV AX, [SI]
  ADD SI, 2
  MOV CX, DX
FixAddressSF:
  TEST DI, 3
  JZ  NoOddPixelsSF
  MOVSB
  DEC CX
  JG  FixAddressSF
NoOddPixelsSF:
  OR  CX, CX
  JS  SkipScanLine
  MOV BP, CX
  SHR CX, 2
  REP MOVSD
  MOV CX, BP
  AND CX, 3
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
SkipScanLine:
  MOV CX, DX
  ADD DI, BX
  DEC AX
  JNZ FixAddressSF
EndPut:
  POP DS
  POP BP
  RET 12
CSSpriteF ENDP

CSSpriteO PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+18]
  MOV ES, AX
  MOV AX, [BP+12]
  MOV GS, AX
  MOV SI, [BP+08]
  XOR AX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  MOV DX, [BP+14]
  MOV CX, [BP+16]
SpriteOLoop:
  MOV AL, GS:[SI]
  INC SI
  OR  AL, AL
  JZ  SkipSpriteOPixel
  CMP CX, ClipX1
  JL  SkipSpriteOPixel
  CMP CX, ClipX2
  JG  SkipSpriteOPixel
  CMP DX, ClipY1
  JL  SkipSpriteOPixel
  CMP DX, ClipY2
  JG  SkipSpriteOPixel
  MOV AH, 1
  CMP [BP+06], AH
  JE  AndPixel
  INC AH
  CMP [BP+06], AH
  JE  OrPixel
  XOR ES:[DI], AL
  JMP SkipSpriteOPixel
AndPixel:
  INC AH
  CMP [BP+06], AH
  JE  OrPixel
  AND ES:[DI], AL
  JMP SkipSpriteOPixel
OrPixel:
  OR  ES:[DI], AL
SkipSpriteOPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ SpriteOLoop
  MOV CX, [BP+16]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ SpriteOLoop
EndSpriteO:
  POP BP
  RET 14
CSSpriteO ENDP

CSSpriteFlipH PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+16]
  MOV ES, AX
  MOV AX, [BP+10]
  MOV GS, AX
  MOV SI, [BP+06]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+12]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  ADD SI, BX
  DEC SI
  MOV DX, [BP+12]
  MOV CX, [BP+14]
SpriteFlipHLoop:
  MOV AL, GS:[SI]
  DEC SI
  OR  AL, AL
  JZ  SkipSpriteFlipHPixel
  CMP CX, ClipX1
  JL  SkipSpriteFlipHPixel
  CMP CX, ClipX2
  JA  SkipSpriteFlipHPixel
  CMP DX, ClipY1
  JL  SkipSpriteFlipHPixel
  CMP DX, ClipY2
  JA  SkipSpriteFlipHPixel
  MOV ES:[DI], AL
SkipSpriteFlipHPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ SpriteFlipHLoop
  ADD SI, BX
  ADD SI, BX
  MOV CX, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ SpriteFlipHLoop
  POP BP
  RET 12
CSSpriteFlipH ENDP

CSSpriteFlipV PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+16]
  MOV ES, AX
  MOV AX, [BP+10]
  MOV GS, AX
  MOV SI, [BP+06]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+12]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+14]
  MOV AX, SHeight
  MOV CX, BX
  MUL CX
  ADD SI, AX
  SUB SI, BX
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  MOV DX, [BP+12]
  MOV CX, [BP+14]
SpriteFlipVLoop:
  MOV AL, GS:[SI]
  INC SI
  OR  AL, AL
  JZ  SkipSpriteFlipVPixel
  CMP CX, ClipX1
  JL  SkipSpriteFlipVPixel
  CMP CX, ClipX2
  JA  SkipSpriteFlipVPixel
  CMP DX, ClipY1
  JL  SkipSpriteFlipVPixel
  CMP DX, ClipY2
  JA  SkipSpriteFlipVPixel
  MOV ES:[DI], AL
SkipSpriteFlipVPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ SpriteFlipVLoop
  SUB SI, BX
  SUB SI, BX
  MOV CX, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ SpriteFlipVLoop
  POP BP
  RET 12
CSSpriteFlipV ENDP

CSSpriteFlipped PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+16]
  MOV ES, AX
  MOV AX, [BP+10]
  MOV GS, AX
  MOV SI, [BP+06]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+12]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+14]
  MOV AX, SHeight
  MOV CX, BX
  MUL CX
  ADD SI, AX
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  DEC SI
  MOV DX, [BP+12]
  MOV CX, [BP+14]
SpriteFlippedLoop:
  MOV AL, GS:[SI]
  DEC SI
  OR  AL, AL
  JZ  SkipSpriteFlippedPixel
  CMP CX, ClipX1
  JL  SkipSpriteFlippedPixel
  CMP CX, ClipX2
  JA  SkipSpriteFlippedPixel
  CMP DX, ClipY1
  JL  SkipSpriteFlippedPixel
  CMP DX, ClipY2
  JA  SkipSpriteFlippedPixel
  MOV ES:[DI], AL
SkipSpriteFlippedPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ SpriteFlippedLoop
  MOV CX, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ SpriteFlippedLoop
  POP BP
  RET 12
CSSpriteFlipped ENDP

CSSpriteS PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+20]
  MOV ES, AX
  MOV AX, [BP+10]
  MOV GS, AX
  MOV SI, [BP+06]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV SWidth, AX
  XOR EBX, EBX
  SHL EAX, 16
  MOV BX, [BP+14]
  MOV EDX, EAX
  SAR EDX, 31
  DIV EBX
  MOV ScaleX, EAX
  MOV AX, GS:[SI]
  ADD SI, 2
  SHL EAX, 16
  MOV BX, [BP+12]
  MOV EDX, EAX
  SAR EDX, 31
  DIV EBX
  MOV ScaleY, EAX
  XOR EAX, EAX
  MOV PointX, AX
  MOV PointY, AX
  MOV ScaleYAdd, EAX
  MOV AX, [BP+16]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+18]
  MOV DX, [BP+16]
  XOR ECX, ECX
SpriteSLoop:
  MOV AX, PointX
  ADD AX, [BP+18]
  CMP AX, ClipX1
  JL  SkipScalePixel
  CMP AX, ClipX2
  JG  SkipScalePixel
  CMP DX, ClipY1
  JL  SkipScalePixel
  CMP DX, ClipY2
  JG  EndScaleSprite
  MOV AL, GS:[SI+BX]
  OR  AL, AL
  JE  SkipScalePixel
  MOV ES:[DI], AL
SkipScalePixel:
  INC DI
  ADD ECX, ScaleX
  MOV EBX, ECX
  SHR EBX, 16
  INC PointX
  MOV AX, PointX
  CMP AX, [BP+14]
  JNZ SpriteSLoop
  ADD DI, 320
  SUB DI, PointX
  MOV FS, DX
  MOV SI, [BP+06]
  ADD SI, 4
  MOV ECX, ScaleY
  ADD ScaleYAdd, ECX
  MOV EAX, ScaleYAdd
  SHR EAX, 16
  MOV BX, SWidth
  XOR DX, DX
  MUL BX
  ADD SI, AX
  XOR ECX, ECX
  MOV PointX, CX
  MOV DX, FS
  INC DX
  INC PointY
  MOV AX, PointY
  CMP AX, [BP+12]
  JNZ SpriteSLoop
EndScaleSprite:
  POP BP
  RET 16
CSSpriteS ENDP

CSSpriteR PROC
  PUSH BP
  PUSH EAX
  PUSH EAX
  MOV BP, SP
  MOV AX, [BP+26]
  MOV BX, [BP+18]
  MOV SI, [BP+20]
  MOV ES, AX
  MOV FS, BX
  SHL SI, 1
  MOV AX, Cosine[SI]
  MOV BX, Sine[SI]
  MOV [BP+02], AX
  MOV [BP], BX
  MOV SI, [BP+14]
  MOV AX, FS:[SI]
  MOV BX, FS:[SI+02]
  SHR AX, 3
  ADD SI, 4
  XOR CX, CX
  MOV SWidth, AX
  MOV SHeight, BX
  SHR AX, 1
  SHR BX, 1
  MOV PointX, CX
  MOV PointY, CX
  ADD [BP+24], AX
  ADD [BP+22], BX
LoopSpriteR:
  MOV BL, FS:[SI]
  INC SI
  OR  BL, BL
  JZ  SkipPixelR
  MOV BH, BL
  MOV GS, BX
  MOV AX, PointX
  MOV BX, SWidth
  SHR BX, 1
  SUB AX, BX
  MOV DX, PointY
  MOV BX, SHeight
  SHR BX, 1
  SUB DX, BX
  MOV BX, [BP+02]
  IMUL BX, AX
  MOV CX, [BP]
  IMUL CX, DX
  SUB BX, CX
  SAR BX, 7
  ADD BX, [BP+24]
  CMP BX, ClipX1
  JL  SkipPixelR
  CMP BX, ClipX2
  JGE SkipPixelR
  MOV CX, [BP+02]
  IMUL CX, DX
  MOV DX, [BP]
  IMUL DX, AX
  ADD CX, DX
  SAR CX, 7
  ADD CX, [BP+22]
  CMP CX, ClipY1
  JL  SkipPixelR
  CMP CX, ClipY2
  JG  SkipPixelR
  MOV DI, CX
  SHL DI, 8
  SHL CX, 6
  ADD DI, CX
  ADD DI, BX
  MOV AX, GS
  MOV ES:[DI], AX
SkipPixelR:
  MOV AX, PointX
  INC AX
  MOV PointX, AX
  CMP AX, SWidth
  JL  LoopSpriteR
  MOV BX, PointY
  INC BX
  CMP BX, SHeight
  JGE EndSpriteR
  MOV PointY, BX
  XOR AX, AX
  MOV PointX, AX
  JMP LoopSpriteR
EndSpriteR:
  POP EAX
  POP EAX
  POP BP
  RET 14
CSSpriteR ENDP

CSSpriteRZ PROC
  PUSH BP
  PUSH EAX
  MOV BP, SP
  MOV AX, [BP+26]
  MOV BX, [BP+16]
  MOV DX, [BP+14]
  MOV SI, [BP+10]
  MOV ES, AX
  MOV FS, DX
  SHL BX, 1
  MOV AX, Cosine[BX]
  MOV DX, Sine[BX]
  MOV [BP+02], AX
  MOV [BP], DX
  MOV AX, FS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV SWidth, AX
  XOR EBX, EBX
  MOV BX, [BP+20]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  DIV EBX
  MOV ScaleX, EAX
  XOR EBX, EBX
  MOV AX, FS:[SI]
  ADD SI, 2
  MOV BX, [BP+18]
  SHL EAX, 16
  MOV EDX, EAX
  SAR EDX, 31
  DIV EBX
  MOV ScaleY, EAX
  MOV AX, [BP+20]
  MOV DX, [BP+18]
  XOR ECX, ECX
  SHR AX, 1
  SHR DX, 1
  MOV ScaleXAdd, ECX
  MOV ScaleYAdd, ECX
  MOV PointX, CX
  MOV PointY, CX
  ADD [BP+24], AX
  ADD [BP+22], DX
SpriteRZLoop:
  MOV EBX, ScaleXAdd
  SHR EBX, 16
  MOV CL, FS:[SI+BX]
  OR  CL, CL
  JZ  SkipPixelRZ
  MOV CH, CL
  MOV GS, CX
  MOV AX, PointX
  MOV BX, [BP+20]
  SHR BX, 1
  SUB AX, BX
  MOV DX, PointY
  MOV BX, [BP+18]
  SHR BX, 1
  SUB DX, BX
  MOV BX, [BP+02]
  IMUL BX, AX
  MOV CX, [BP]
  IMUL CX, DX
  SUB BX, CX
  SAR BX, 7
  ADD BX, [BP+24]
  CMP BX, ClipX1
  JL  SkipPixelRZ
  CMP BX, ClipX2
  JGE SkipPixelRZ
  MOV CX, [BP+02]
  IMUL CX, DX
  MOV DX, [BP]
  IMUL DX, AX
  ADD CX, DX
  SAR CX, 7
  ADD CX, [BP+22]
  CMP CX, ClipY1
  JL  SkipPixelRZ
  CMP CX, ClipY2
  JG  SkipPixelRZ
  MOV DI, CX
  SHL DI, 8
  SHL CX, 6
  ADD DI, CX
  ADD DI, BX
  MOV AX, GS
  MOV ES:[DI], AX
SkipPixelRZ:
  MOV EAX, ScaleXAdd
  ADD EAX, ScaleX
  MOV ScaleXAdd, EAX
  INC PointX
  MOV BX, PointX
  CMP BX, [BP+20]
  JLE SpriteRZLoop
  MOV SI, [BP+10]
  XOR ECX, ECX
  MOV PointX, CX
  MOV ScaleXAdd, ECX
  ADD SI, 4
  MOV EAX, ScaleYAdd
  ADD EAX, ScaleY
  MOV ScaleYAdd, EAX
  SHR EAX, 16
  MOV BX, SWidth
  XOR DX, DX
  MUL BX
  ADD SI, AX
  INC PointY
  MOV DX, PointY
  CMP DX, [BP+18]
  JLE SpriteRZLoop
  POP EAX
  POP BP
  RET 18
CSSpriteRZ ENDP

CSCollision PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+16]
  MOV ES, AX
  MOV AX, [BP+10]
  MOV GS, AX
  MOV SI, [BP+06]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+12]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  MOV DX, [BP+12]
  MOV CX, [BP+14]
CollisionLoop:
  MOV AL, GS:[SI]
  INC SI
  OR  AL, AL
  JZ  SkipCollisionPixel
  CMP CX, ClipX1
  JL  SkipCollisionPixel
  CMP CX, ClipX2
  JA  SkipCollisionPixel
  CMP DX, ClipY1
  JL  SkipCollisionPixel
  CMP DX, ClipY2
  JA  SkipCollisionPixel
  MOV AL, ES:[DI]
  OR  AL, AL
  JNE EndCollision
SkipCollisionPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ CollisionLoop
  MOV CX, [BP+14]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ CollisionLoop
  XOR AX, AX
EndCollision:
  POP BP
  RET 12
CSCollision ENDP

CSCollisionC PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+18]
  MOV ES, AX
  MOV AX, [BP+12]
  MOV GS, AX
  MOV SI, [BP+08]
  MOV AX, GS:[SI]
  ADD SI, 2
  SHR AX, 3
  MOV BX, AX
  MOV AX, GS:[SI]
  ADD SI, 2
  MOV SHeight, AX
  MOV AX, [BP+14]
  MOV DI, AX
  SHL AX, 8
  SHL DI, 6
  ADD DI, AX
  ADD DI, [BP+16]
  XOR AX, AX
  MOV PointX, AX
  MOV PointY, AX
  MOV DX, [BP+14]
  MOV CX, [BP+16]
CollisionCLoop:
  MOV AL, GS:[SI]
  INC SI
  OR  AL, AL
  JZ  SkipCollisionCPixel
  CMP CX, ClipX1
  JL  SkipCollisionCPixel
  CMP CX, ClipX2
  JA  SkipCollisionCPixel
  CMP DX, ClipY1
  JL  SkipCollisionCPixel
  CMP DX, ClipY2
  JA  SkipCollisionCPixel
  MOV AL, ES:[DI]
  CMP AL, [BP+6]
  JZ  ColisionCTrue
SkipCollisionCPixel:
  INC DI
  INC CX
  INC PointX
  MOV AX, PointX
  CMP AX, BX
  JNZ CollisionCLoop
  MOV CX, [BP+16]
  XOR AX, AX
  MOV PointX, AX
  ADD DI, 320
  SUB DI, BX
  INC PointY
  INC DX
  MOV AX, PointY
  CMP AX, SHeight
  JNZ CollisionCLoop
  XOR AX, AX
  JMP EndCollisionC
ColisionCTrue:
  MOV AX, 1
EndCollisionC:
  POP BP
  RET 14
CSCollisionC ENDP

CSCollide PROC
  PUSH BP
  SUB SP, 8
  MOV BP, SP
  MOV AX, [BP+28]
  MOV BX, [BP+18]
  MOV ES, AX
  MOV FS, BX
  MOV DI, [BP+24]
  MOV SI, [BP+14]
  MOV AX, ES:[DI]
  MOV BX, FS:[SI]
  SHR AX, 3
  SHR BX, 3
  MOV [BP+06], AX
  MOV [BP+04], BX
  MOV AX, ES:[DI+2]
  MOV BX, FS:[SI+2]
  MOV [BP+02], AX
  MOV [BP], BX
  XOR AX, AX
  MOV BX, [BP+32]
  MOV CX, [BP+22]
  ADD BX, [BP+06]
  CMP BX, CX
  JLE EndCollide
  MOV BX, [BP+22]
  MOV CX, [BP+32]
  ADD BX, [BP+04]
  CMP BX, CX
  JLE EndCollide
  MOV BX, [BP+30]
  MOV CX, [BP+20]
  ADD BX, [BP+02]
  CMP BX, CX
  JLE EndCollide
  MOV BX, [BP+20]
  MOV CX, [BP+30]
  ADD BX, [BP]
  CMP BX, CX
  JLE EndCollide
  MOV AX, 0FFFFh
EndCollide:
  ADD SP, 8
  POP BP
  RET 20
CSCollide ENDP

END
