;----------------------------------------------------------------------------
;
;  CosmoX SOUND BLASTER Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

WAVFileHeader STRUC
  MMFileID          DD ?
  FileLenght        DD ?
  WavFileID         DD ?
  FormatID          DD ?
  FormatLenght      DD ?
  SoundFormat       DW ?
  NumberOfChannels  DW ?
  SamplesPerSec     DD ?
  AvgBytesPerSec    DD ?
  BlockAlign        DW ?
  BitsPerSample     DW ?
  DataID            DD ?
  DataLenght        DD ?
WAVFileHeader ENDS

.DATA

ALIGN 2

BaseAddr            DW  ?               ;  Sound Blaster base address
BlasterReset        DW  ?               ;  Sound Blaster reset port
BlasterRead         DW  ?               ;  Sound Blaster read port
BlasterWrite        DW  ?               ;  Sound Blaster write port
BlasterStatus       DW  ?               ;  Sound Blaster write status port
BlasterData         DW  ?               ;  Sound Blaster data ready port
WavHeader           WAVFileHeader <>    ;  .WAV file header Struct
BlasterActive       DB  ?               ;  Is the Sound Blaster active ?
SoundFlag           DB  ?               ;  Is a sound currently playing ?

.CODE

PUBLIC  CSInitBlaster, CSTurnBlasterOn, CSTurnBlasterOff, CSPlaySound
PUBLIC  xCSLoadRAWSound, xCSLoadWAVSound, CSSoundDone, CSContinueSound
PUBLIC  CSPauseSound

CSInitBlaster PROC
  XOR AX, AX
  XOR DX, DX
  MOV BX, 1
InitBlasterLoop:
  MOV AX, BX
  SHL AX, 4
  MOV DX, AX
  ADD DX, 0206h
  MOV BlasterReset, DX
  MOV DX, AX
  ADD DX, 020Ah
  MOV BlasterRead, DX
  MOV DX, AX
  ADD DX, 020Ch
  MOV BlasterWrite, DX
  MOV BlasterStatus, DX
  MOV DX, AX
  ADD DX, 020Eh
  MOV BlasterData, DX
  MOV CX, 5
  MOV DX, BlasterReset
  MOV AL, 1
  OUT DX, AL
  XOR AL, AL
ResetWait1:
  CALL WaitRetrace
  DEC CX
  JNZ ResetWait1
  MOV CX, 5
  OUT DX, AL
ResetWait2:
  CALL WaitRetrace
  DEC CX
  JNZ ResetWait2
  MOV DX, BlasterData
  IN  AL, DX
  AND AL, 80h
  CMP AL, 80h
  JNE NoBlaster
  MOV DX, BlasterRead
  IN  AL, DX
  CMP AL, 0AAh
  JNE NoBlaster
  IN  AL, 08h
  MOV AX, 1
  MOV BlasterActive, AL
  RET
NoBlaster:
  INC BX
  CMP BX, 9
  JNE InitBlasterLoop
  XOR AX, AX
  MOV BlasterActive, AL
  RET
CSInitBlaster ENDP

CSTurnBlasterOn PROC
  MOV AL, BlasterActive
  OR  AL, AL
  JZ  NoTurnOn
  MOV AH, 0D1h
  CALL WriteDSP
NoTurnOn:
  RET
CSTurnBlasterOn ENDP

CSTurnBlasterOff PROC
  MOV AL, BlasterActive
  OR  AL, AL
  JZ  NoTurnOff
  MOV AH, 0D3h
  CALL WriteDSP
NoTurnOff:
  RET
CSTurnBlasterOff ENDP

CSPauseSound PROC
  MOV AL, BlasterActive
  OR  AL, AL
  JZ  NoPause
  MOV AH, 0D0h
  CALL WriteDSP
NoPause:
  RET
CSPauseSound ENDP

CSContinueSound PROC
  MOV AL, BlasterActive
  OR  AL, AL
  JZ  NoContinue
  MOV AH, 0D4h
  CALL WriteDSP
NoContinue:
  RET
CSContinueSound ENDP

CSPlaySound PROC
  PUSH BP
  MOV BP, SP
  MOV AL, BlasterActive
  OR  AL, AL
  JZ  EndPlaySound
  MOV CX, [BP+18]
  MOV BX, [BP+14]
  SHL CX, 4
  ADD CX, BX
  MOV BX, [BP+18]
  MOV AX, [BP+14]
  SHR AX, 4
  ADD BX, AX
  SHR BX, 12
  MOV DX, 0Ah
  MOV AL, 05h
  OUT DX, AL
  MOV DX, 0Ch
  XOR AL, AL
  OUT DX, AL
  MOV DX, 0Bh
  MOV AL, 49h
  OUT DX, AL
  MOV DX, 02h
  MOV AX, CX
  OUT DX, AL
  MOV AL, AH
  OUT DX, AL
  MOV DX, 83h
  MOV AX, BX
  OUT DX, AL
  MOV DX, 03h
  MOV AX, [BP+10]
  DEC AX
  OUT DX, AL
  MOV AL, AH
  OUT DX, AL
  MOV DX, 0Ah
  MOV AL, 01h
  OUT DX, AL
  XOR EBX, EBX
  MOV BX, [BP+06]
  MOV EAX, 1000000
  XOR EDX, EDX
  DIV EBX
  MOV CX, 256
  SUB CX, AX
  MOV AH, 40h
  CALL WriteDSP
  MOV AH, CL
  CALL WriteDSP
  MOV CX, [BP+10]
  DEC CX
  MOV AH, 14h
  CALL WriteDSP
  MOV AH, CL
  CALL WriteDSP
  MOV AH, CH
  CALL WriteDSP
  MOV AL, 1
  MOV SoundFlag, AL
EndPlaySound:
  POP BP
  RET 14
CSPlaySound ENDP

xCSLoadRAWSound PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV CX, [BP+16]
  MOV DX, [BP+14]
  MOV DS, CX
  MOV AX, 3D00h
  INT 21h
  JC  ErrorOpeningRaw
  MOV BX, AX
  XOR CX, CX
  XOR DX, DX
  MOV AX, 4202h
  INT 21h
  PUSH AX
  XOR CX, CX
  XOR DX, DX
  MOV AX, 4200h
  INT 21h
  POP CX
  PUSH CX
  MOV AX, [BP+12]
  MOV DX, [BP+08]
  MOV DS, AX
  MOV AH, 3Fh
  INT 21h
  JC  ErrorReadRaw
  MOV AH, 3Eh
  INT 21h
  IN  AL, 08h
  POP AX
  XOR DX, DX
  JMP EndLoadRaw
ErrorOpeningRaw:
  MOV AX, 1
  JMP EndLoadRaw
ErrorReadRaw:
  MOV AH, 3Eh
  INT 21h
  POP CX
  MOV AX, 2
EndLoadRaw:
  POP DS
  POP BP
  RET 10
xCSLoadRAWSound ENDP

xCSLoadWAVSound PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV CX, [BP+16]
  MOV DX, [BP+14]
  MOV DS, CX
  MOV AX, 3D00h
  INT 21h
  JC  ErrorOpeningWav
  MOV BX, AX
  MOV CX, 44
  MOV AX, SEG WavHeader
  MOV DX, OFFSET WavHeader
  MOV DS, AX
  MOV AH, 3Fh
  INT 21h
  JC  ErrorReadingWav
  CMP WavHeader.MMFileID, 'FFIR'
  JNE ErrorBadWav
  CMP WavHeader.WavFileID, 'EVAW'
  JNE ErrorBadWav
  CMP WavHeader.SoundFormat, 1
  JNE ErrorBadWav
  CMP WavHeader.NumberOfChannels, 1
  JNE ErrorBadWav
  CMP WavHeader.BitsPerSample, 8
  JNE ErrorBadWav
  MOV ECX, WavHeader.DataLenght
  MOV AX, [BP+12]
  AND ECX, 0FFFFh
  MOV DX, [BP+08]
  MOV DS, AX
  MOV AH, 3Fh
  INT 21h
  JC  ErrorReadingWav
  MOV AH, 3Eh
  INT 21h
  MOV AX, SEG WavHeader
  MOV DS, AX
  IN  AL, 08h
  MOV EAX, WavHeader.DataLenght
  XOR DX, DX
  POP DS
  POP BP
  RET 10
ErrorOpeningWav:
  MOV AX, 1
  POP DS
  POP BP
  RET 10
ErrorReadingWav:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 2
  POP DS
  POP BP
  RET 10
ErrorBadWav:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 3
  POP DS
  POP BP
  RET 10
xCSLoadWAVSound ENDP

CSSoundDone PROC
  MOV AL, SoundFlag
  OR  AL, AL
  JZ  NoSoundPlaying
  IN  AL, 08h
  SHR AL, 1
  AND AL, 1
  JNZ TransferDone
  MOV AX, 1
  RET
TransferDone:
  XOR AX, AX
  MOV SoundFlag, AL
  RET
NoSoundPlaying:
  IN  AL, 08h
  XOR AX, AX
  RET
CSSoundDone ENDP

WriteDSP PROC FAR
  PUSH CX
  XOR CX, CX
  MOV DX, BlasterStatus
WaitToWriteDSP:
  DEC CX
  JZ  EndWaitToWrite
  IN  AL, DX
  OR  AL, AL
  JS  WaitToWriteDSP
EndWaitToWrite:
  MOV DX, BlasterWrite
  MOV AL, AH
  OUT DX, AL
  POP CX
  RET
WriteDSP ENDP

ReadDSP PROC FAR
  PUSH CX
  XOR CX, CX
  MOV DX, BlasterData
WaitToReadDSP:
  DEC CX
  JZ  EndWaitToRead
  IN  AL, DX
  OR  AL, AL
  JNS WaitToReadDSP
EndWaitToRead:
  MOV DX, BlasterRead
  IN  AL, DX
  MOV AH, AL
  POP CX
  RET
ReadDSP ENDP

WaitRetrace PROC
  PUSH AX
  PUSH DX
  MOV DX, 03DAh
Wait1:
  IN  AL, DX
  AND AL, 08h
  JNZ Wait1
Wait2:
  IN  AL, DX
  AND AL, 08h
  JZ  Wait2
  POP DX
  POP AX
  RET
WaitRetrace ENDP

END
