;----------------------------------------------------------------------------
;
;  CosmoX PALETTE Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

CosmoXPaletteFile STRUC
    PaletteFileTitle  DB  'CosmoX Palette File '
    LibVersion        DB  'CosmoX Library v1.6 '
CosmoXPaletteFile ENDS

.DATA

ALIGN 2

PalLoad             CosmoXPaletteFile <>
PalHeader           CosmoXPaletteFile <>
BlueHues            DB  ?               ;  Used by Palette functions
GreenHues           DB  ?               ;  Used by Palette functions
RedHues             DB  ?               ;  Used by Palette functions

.CODE

PUBLIC  CSSetCol, CSGetCol, xCSGetPal, xCSSetPal, CSBlackPal, CSNegativePal
PUBLIC  CSGrayPal, xCSFadeIn, xCSFadeInStep, CSFadeTo, CSFadeToStep, CSFindCol
PUBLIC  CSRotatePalB, CSRotatePalF, xCSSavePal, xCSLoadPal, CSWaitRetrace

CSSetCol PROC
  MOV BX, BP
  MOV BP, SP
  MOV DX, 03C8h
  MOV AX, [BP+10]
  OUT DX, AL
  INC DX
  MOV AL, [BP+08]
  OUT DX, AL
  MOV AL, [BP+06]
  OUT DX, AL
  MOV AL, [BP+04]
  OUT DX, AL
  MOV BP, BX
  RET 8
CSSetCol ENDP

CSGetCol PROC
  MOV DI, BP
  MOV BP, SP
  MOV DX, 03C7h
  MOV AL, [BP+10]
  OUT DX, AL
  XOR AX, AX
  MOV DX, 03C9h
  MOV BX, [BP+08]
  IN  AL, DX
  MOV [BX], AX
  MOV BX, [BP+06]
  IN  AL, DX
  MOV [BX], AX
  MOV BX, [BP+04]
  IN  AL, DX
  MOV [BX], AX
  MOV BP, DI
  RET 8
CSGetCol ENDP

xCSGetPal PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV ES, AX
  MOV DI, [BP+04]
  MOV DX, 03C7h
  XOR AX, AX
  OUT DX, AL
  ADD DX, 2
  MOV CX, 768
GetPalLoop:
  INSB
  DEC CX
  JNZ GetPalLoop
  MOV BP, BX
  RET 4
xCSGetPal ENDP

xCSSetPal PROC
  MOV BX, BP
  MOV DI, DS
  MOV BP, SP
  MOV AX, [BP+06]
  MOV DS, AX
  MOV SI, [BP+04]
  XOR AX, AX
  MOV DX, 03C8h
  OUT DX, AL
  INC DX
  MOV CX, 768
SetPalLoop:
  OUTSB
  DEC CX
  JNZ SetPalLoop
  MOV DS, DI
  MOV BP, BX
  RET 4
xCSSetPal ENDP

CSBlackPal PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+12]
  INC AX
  MOV [BP+12], AX
  MOV AH, [BP+10]
  MOV BH, [BP+08]
  MOV BL, [BP+06]
  MOV CX, [BP+14]
BlackPalLoop:
  MOV DX, 03C8h
  MOV AL, CL
  OUT DX, AL
  INC DX
  MOV AL, AH
  OUT DX, AL
  MOV AL, BH
  OUT DX, AL
  MOV AL, BL
  OUT DX, AL
  INC CX
  CMP CX, [BP+12]
  JL BlackPalLoop
  POP BP
  RET 10
CSBlackPal ENDP

CSNegativePal PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+06]
  INC AX
  MOV [BP+06], AX
  MOV CX, [BP+08]
NegatePalLoop:
  MOV DX, 03C7h
  MOV AL, CL
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV BH, AL
  IN  AL, DX
  MOV BL, AL
  IN  AL, DX
  MOV AH, AL
  MOV DX, 03C8h
  MOV AL, CL
  OUT DX, AL
  MOV DL, 63
  SUB DL, BH
  MOV BH, DL
  MOV DL, 63
  SUB DL, BL
  MOV BL, DL
  MOV DL, 63
  SUB DL, AH
  MOV AH, DL
  MOV DX, 03C9h
  MOV AL, BH
  OUT DX, AL
  MOV AL, BL
  OUT DX, AL
  MOV AL, AH
  OUT DX, AL
  INC CX
  CMP CX, [BP+06]
  JL NegatePalLoop
  POP BP
  RET 4
CSNegativePal ENDP

CSGrayPal PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+06]
  INC AX
  MOV [BP+06], AX
  MOV CX, [BP+08]
GrayPalLoop:
  MOV DX, 03C7h
  MOV AL, CL
  OUT DX, AL
  MOV DX, 03C9h
  XOR AH, AH
  IN  AL, DX
  MOV BX, AX
  IN  AL, DX
  MOV SI, AX
  IN  AL, DX
  MOV DI, AX
  MOV DX, 03C8h
  MOV AL, CL
  OUT DX, AL
  MOV AX, 11
  MUL BX
  MOV BX, AX
  MOV AX, 59
  MUL SI
  MOV SI, AX
  MOV AX, 30
  MUL DI
  ADD AX, BX
  ADD AX, SI
  MOV BX, 100
  DIV BX
  MOV DX, 03C9h
  OUT DX, AL
  OUT DX, AL
  OUT DX, AL
  INC CX
  CMP CX, [BP+06]
  JL  GrayPalLoop
  POP BP
  RET 4
CSGrayPal ENDP

xCSFadeIn PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV ES, AX
  MOV AX, [BP+10]
  INC AX
  MOV [BP+10], AX
  MOV CX, [BP+12]
  MOV AX, 3
  MUL CX
  ADD [BP+06], AX
  XOR SI, SI
FadeToPal:
  CALL CSWaitRetrace
  MOV DI, [BP+06]
FadeToPalLoop:
  MOV DX, 03C7h
  MOV AL, CL
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV BH, AL
  IN  AL, DX
  MOV BL, AL
  IN  AL, DX
  MOV AH, AL
  MOV DX, 03C8h
  MOV AL, CL
  OUT DX, AL
  MOV DX, 03C9h
  MOV AL, ES:[DI]
  INC DI
  CMP BH, AL
  JL  IncPalRed
  CMP BH, AL
  JG  DecPalRed
  OUT DX, AL
CheckPalGreen:
  MOV AL, ES:[DI]
  INC DI
  CMP BL, AL
  JL  IncPalGreen
  CMP BL, AL
  JG  DecPalGreen
  OUT DX, AL
CheckPalBlue:
  MOV AL, ES:[DI]
  INC DI
  CMP AH, AL
  JL  IncPalBlue
  CMP AH, AL
  JG  DecPalBlue
  OUT DX, AL
  JMP CheckPalCounters
IncPalRed:
  MOV AL, BH
  INC AL
  OUT DX, AL
  JMP CheckPalGreen
DecPalRed:
  MOV AL, BH
  DEC AL
  OUT DX, AL
  JMP CheckPalGreen
IncPalGreen:
  MOV AL, BL
  INC AL
  OUT DX, AL
  JMP CheckPalBlue
DecPalGreen:
  MOV AL, BL
  DEC AL
  OUT DX, AL
  JMP CheckPalBlue
IncPalBlue:
  MOV AL, AH
  INC AL
  OUT DX, AL
  JMP CheckPalCounters
DecPalBlue:
  MOV AL, AH
  DEC AL
  OUT DX, AL
CheckPalCounters:
  INC CX
  CMP CX, [BP+10]
  JNE FadeToPalLoop
  MOV CX, [BP+12]
  INC SI
  CMP SI, 64
  JNZ FadeToPal
  POP BP
  RET 8
xCSFadeIn ENDP

xCSFadeInStep PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV ES, AX
  MOV DI, [BP+06]
  MOV AX, [BP+10]
  INC AX
  MOV [BP+10], AX
  MOV CX, [BP+12]
  MOV AX, 3
  MUL CX
  ADD DI, AX
  CALL CSWaitRetrace
FadeToPalStepLoop:
  MOV DX, 03C7h
  MOV AL, CL
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV BH, AL
  IN  AL, DX
  MOV BL, AL
  IN  AL, DX
  MOV AH, AL
  MOV DX, 03C8h
  MOV AL, CL
  OUT DX, AL
  MOV DX, 03C9h
  MOV AL, ES:[DI]
  INC DI
  CMP BH, AL
  JL  IncPalStepRed
  CMP BH, AL
  JG  DecPalStepRed
  OUT DX, AL
CheckPalStepGreen:
  MOV AL, ES:[DI]
  INC DI
  CMP BL, AL
  JL  IncPalStepGreen
  CMP BL, AL
  JG  DecPalStepGreen
  OUT DX, AL
CheckPalStepBlue:
  MOV AL, ES:[DI]
  INC DI
  CMP AH, AL
  JL  IncPalStepBlue
  CMP AH, AL
  JG  DecPalStepBlue
  OUT DX, AL
  JMP CheckPalStepCounters
IncPalStepRed:
  INC BH
  MOV AL, BH
  OUT DX, AL
  JMP CheckPalStepGreen
DecPalStepRed:
  DEC BH
  MOV AL, BH
  OUT DX, AL
  JMP CheckPalStepGreen
IncPalStepGreen:
  INC BL
  MOV AL, BL
  OUT DX, AL
  JMP CheckPalStepBlue
DecPalStepGreen:
  DEC BL
  MOV AL, BL
  OUT DX, AL
  JMP CheckPalStepBlue
IncPalStepBlue:
  INC AH
  MOV AL, AH
  OUT DX, AL
  JMP CheckPalStepCounters
DecPalStepBlue:
  DEC AH
  MOV AL, AH
  OUT DX, AL
CheckPalStepCounters:
  INC CX
  CMP CX, [BP+10]
  JL  FadeToPalStepLoop
  POP BP
  RET 8
xCSFadeInStep ENDP

CSFadeTo PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+12]
  INC AX
  MOV [BP+12], AX
  MOV DI, [BP+14]
  XOR SI, SI
  CALL CSWaitRetrace
FadeToColLoop:
  MOV DX, 03C7h
  MOV AX, DI
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV BH, AL
  IN  AL, DX
  MOV BL, AL
  IN  AL, DX
  MOV CH, AL
  MOV DX, 03C8h
  MOV AX, DI
  OUT DX, AL
  MOV DX, 03C9h
  MOV AX, [BP+10]
  CMP BH, AL
  JL  IncColRed
  CMP BH, AL
  JG  DecColRed
  OUT DX, AL
CheckColGreen:
  MOV AX, [BP+08]
  CMP BL, AL
  JL  IncColGreen
  CMP BL, AL
  JG  DecColGreen
  OUT DX, AL
CheckColBlue:
  MOV AX, [BP+06]
  CMP CH, AL
  JL  IncColBlue
  CMP CH, AL
  JG  DecColBlue
  OUT DX, AL
  JMP CheckColCounters
IncColRed:
  INC BH
  MOV AL, BH
  OUT DX, AL
  JMP CheckColGreen
DecColRed:
  DEC BH
  MOV AL, BH
  OUT DX, AL
  JMP CheckColGreen
IncColGreen:
  INC BL
  MOV AL, BL
  OUT DX, AL
  JMP CheckColBlue
DecColGreen:
  DEC BL
  MOV AL, BL
  OUT DX, AL
  JMP CheckColBlue
IncColBlue:
  INC CH
  MOV AL, CH
  OUT DX, AL
  JMP CheckColCounters
DecColBlue:
  DEC CH
  MOV AL, CH
  OUT DX, AL
CheckColCounters:
  INC DI
  CMP DI, [BP+12]
  JNE FadeToColLoop
  CALL CSWaitRetrace
  MOV DI, [BP+14]
  INC SI
  CMP SI, 64
  JNZ FadeToColLoop
  POP BP
  RET 10
CSFadeTo ENDP

CSFadeToStep PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+12]
  INC AX
  MOV [BP+12], AX
  MOV DI, [BP+14]
  CALL CSWaitRetrace
FadeToColStepLoop:
  MOV DX, 03C7h
  MOV AX, DI
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV BH, AL
  IN  AL, DX
  MOV BL, AL
  IN  AL, DX
  MOV CH, AL
  MOV DX, 03C8h
  MOV AX, DI
  OUT DX, AL
  MOV DX, 03C9h
  MOV AX, [BP+10]
  CMP BH, AL
  JL  IncColStepRed
  CMP BH, AL
  JG  DecColStepRed
  OUT DX, AL
CheckColStepGreen:
  MOV AX, [BP+08]
  CMP BL, AL
  JL  IncColStepGreen
  CMP BL, AL
  JG  DecColStepGreen
  OUT DX, AL
CheckColStepBlue:
  MOV AX, [BP+06]
  CMP CH, AL
  JL  IncColStepBlue
  CMP CH, AL
  JG  DecColStepBlue
  OUT DX, AL
  JMP CheckColStepCounters
IncColStepRed:
  INC BH
  MOV AL, BH
  OUT DX, AL
  JMP CheckColStepGreen
DecColStepRed:
  DEC BH
  MOV AL, BH
  OUT DX, AL
  JMP CheckColStepGreen
IncColStepGreen:
  INC BL
  MOV AL, BL
  OUT DX, AL
  JMP CheckColStepBlue
DecColStepGreen:
  DEC BL
  MOV AL, BL
  OUT DX, AL
  JMP CheckColStepBlue
IncColStepBlue:
  INC CH
  MOV AL, CH
  OUT DX, AL
  JMP CheckColStepCounters
DecColStepBlue:
  DEC CH
  MOV AL, CH
  OUT DX, AL
CheckColStepCounters:
  INC DI
  CMP DI, [BP+12]
  JNE FadeToColStepLoop
  POP BP
  RET 10
CSFadeToStep ENDP

CSFindCol PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV DI, 11907
  XOR CX, CX
  MOV DX, 3C7h
  OUT DX, AL
  MOV DX, 3C9h
FindColLoop:
  MOV DX, 3C9h
  IN  AL, DX
  MOV RedHues, AL
  IN  AL, DX
  MOV GreenHues, AL
  IN  AL, DX
  MOV BlueHues, AL
  MOV AX, [BP+10]
  SUB AL, RedHues
  MOV RedHues, AL
  MOV BX, [BP+08]
  SUB BL, GreenHues
  MOV GreenHues, BL
  MOV AX, [BP+06]
  SUB AL, BlueHues
  MOV BlueHues, AL
  XOR SI, SI
  XOR AX, AX
  MOV AL, RedHues
  MOV BX, AX
  XOR DX, DX
  IMUL BX
  ADD SI, AX
  XOR AX, AX
  MOV AL, GreenHues
  MOV BX, AX
  XOR DX, DX
  IMUL BX
  ADD SI, AX
  XOR AX, AX
  MOV AL, BlueHues
  MOV BX, AX
  XOR DX, DX
  IMUL BX
  ADD SI, AX
  CMP SI, DI
  JGE SecondCheck
  MOV DI, SI
SecondCheck:
  CMP SI, 0
  JE  EndFindCol
  XOR AX, AX
  MOV DX, 3C9h
  INC CX
  CMP CX, 256
  JNZ FindColLoop
EndFindCol:
  CMP CX, 256
  JNE ColFinded
  MOV CX, 0FFFFh
ColFinded:
  MOV AX, CX
  POP BP
  RET 6
CSFindCol ENDP

CSRotatePalB PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV DX, 03C7h
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV RedHues, AL
  IN  AL, DX
  MOV GreenHues, AL
  IN  AL, DX
  MOV BlueHues, AL
  MOV SI, [BP+08]
RotateBLoop:
  MOV AX, SI
  INC AL
  MOV DX, 03C7h
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV BH, AL
  IN  AL, DX
  MOV BL, AL
  IN  AL, DX
  MOV CH, AL
  MOV AX, SI
  MOV DX, 03C8h
  OUT DX, AL
  MOV DX, 03C9h
  MOV AL, BH
  OUT DX, AL
  MOV AL, BL
  OUT DX, AL
  MOV AL, CH
  OUT DX, AL
  INC SI
  CMP SI, [BP+06]
  JL  RotateBLoop
  MOV AX, [BP+06]
  MOV DX, 03C8h
  OUT DX, AL
  MOV DX, 03C9h
  MOV AL, RedHues
  OUT DX, AL
  MOV AL, GreenHues
  OUT DX, AL
  MOV AL, BlueHues
  OUT DX, AL
EndRotateB:
  POP BP
  RET 4
CSRotatePalB ENDP

CSRotatePalF PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+06]
  MOV DX, 03C7h
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV RedHues, AL
  IN  AL, DX
  MOV GreenHues, AL
  IN  AL, DX
  MOV BlueHues, AL
  MOV SI, [BP+06]
RotateFLoop:
  MOV AX, SI
  DEC AL
  MOV DX, 03C7h
  OUT DX, AL
  MOV DX, 03C9h
  IN  AL, DX
  MOV BH, AL
  IN  AL, DX
  MOV BL, AL
  IN  AL, DX
  MOV CH, AL
  MOV AX, SI
  MOV DX, 03C8h
  OUT DX, AL
  MOV DX, 03C9h
  MOV AL, BH
  OUT DX, AL
  MOV AL, BL
  OUT DX, AL
  MOV AL, CH
  OUT DX, AL
  DEC SI
  CMP SI, [BP+08]
  JA  RotateFLoop
  MOV AX, [BP+08]
  MOV DX, 03C8h
  OUT DX, AL
  MOV DX, 03C9h
  MOV AL, RedHues
  OUT DX, AL
  MOV AL, GreenHues
  OUT DX, AL
  MOV AL, BlueHues
  OUT DX, AL
EndRotateF:
  POP BP
  RET 4
CSRotatePalF ENDP

xCSSavePal PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+10]
  MOV DS, AX
  MOV DX, [BP+08]
  XOR CX, CX
  MOV AH, 3Ch
  INT 21h
  JC  ErrorOpenPal
  MOV BX, AX
  MOV AX, SEG PalHeader
  MOV DS, AX
  MOV DX, OFFSET PalHeader
  MOV CX, 40
  MOV AH, 40h
  INT 21h
  JC  ErrorSavePal
  MOV AX, [BP+14]
  MOV DS, AX
  MOV DX, [BP+12]
  MOV CX, 768
  MOV AH, 40h
  INT 21h
  JC  ErrorSavePal
  MOV AH, 3Eh
  INT 21h
  XOR AX, AX
  JMP EndSavePal
ErrorOpenPal:
  MOV AX, 1
  JMP EndSavePal
ErrorSavePal:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 2
EndSavePal:
  POP DS
  POP BP
  RET 8
xCSSavePal ENDP

xCSLoadPal PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+10]
  MOV DS, AX
  MOV DX, [BP+08]
  XOR CX, CX
  XOR AX, AX
  MOV AH, 3Dh
  INT 21h
  JC  ErrorOpenLPal
  MOV BX, AX
  MOV AX, SEG PalLoad
  MOV DS, AX
  MOV DX, OFFSET PalLoad
  MOV CX, 40
  MOV AH, 3Fh
  INT 21h
  JC  ErrorLoadPal
  MOV AX, DS
  MOV ES, AX
  MOV SI, OFFSET PalLoad
  MOV DI, OFFSET PalHeader
  MOV CX, 20
  REPE CMPSB
  JNE ErrorNoPal
  MOV AX, [BP+14]
  MOV DS, AX
  MOV DX, [BP+12]
  MOV CX, 768
  MOV AH, 3Fh
  INT 21h
  JC  ErrorLoadPal
  MOV AH, 3Eh
  INT 21h
  XOR AX, AX
  JMP EndLoadPal
ErrorOpenLPal:
  MOV AX, 1
  JMP EndLoadPal
ErrorNoPal:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 3
  JMP EndLoadPal
ErrorLoadPal:
  MOV AH, 3Eh
  INT 21h
  MOV AX, 2
EndLoadPal:
  POP DS
  POP BP
  RET 8
xCSLoadPal ENDP

CSWaitRetrace PROC
  MOV DX, 03DAh
Wait1:
  IN  AL, DX
  AND AL, 08h
  JNZ Wait1
Wait2:
  IN  AL, DX
  AND AL,08h
  JZ  Wait2
  RET
CSWaitRetrace ENDP

END
