;----------------------------------------------------------------------------
;
;  CosmoX MOUSE Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

.DATA

ALIGN 2

MouseX              DW  0               ;  Current mouse x coordinate
MouseY              DW  0               ;  Current mouse y coordinate
MouseB              DB  0               ;  Current mouse buttons status
MouseDetected       DB  0               ;  Has the mouse been detected?
MouseOn             DB  0               ;  Is the mouse cursor visible?
MouseShape          DB  0FFh,03Fh,0FFh,01Fh,0FFh,00Fh,0FFh,007h
                    DB  0FFh,003h,0FFh,001h,0FFh,000h,07Fh,000h
                    DB  03Fh,000h,07Fh,000h,0FFh,00Fh,0FFh,0BFh
                    DB  0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                    DB  000h,000h,000h,040h,000h,060h,000h,070h
                    DB  000h,078h,000h,07Ch,000h,07Eh,000h,07Fh
                    DB  080h,07Fh,000h,070h,000h,040h,000h,000h
                    DB  000h,000h,000h,000h,000h,000h,000h,000h

.CODE

PUBLIC  CSDetectMouse, CSMouseX, CSMouseY, CSMouseLB, CSMouseRB, CSMouseOn
PUBLIC  CSMouseOff, CSSetMouseXY, CSSetMouseRange, CSSetMouseSpeed
PUBLIC  xCSSetMouseCursor, CSResetMouse, CSMouseClickOn, CSMouseOver

CSDetectMouse PROC
  XOR AX, AX
  INT 33h
  OR  AX, AX
  JNZ InstallMouse
  RET
InstallMouse:
  MOV AX, SEG MouseHandler
  MOV ES, AX
  MOV DX, OFFSET MouseHandler
  MOV CX, 31
  MOV AX, 0Ch
  INT 33h
  MOV AX, 1
  MOV MouseDetected, AL
  RET
MouseHandler:
  PUSH DS
  MOV AX, @DATA
  MOV DS, AX
  MOV MouseX, CX
  MOV MouseY, DX
  MOV MouseB, BL
  POP DS
  RET
CSDetectMouse ENDP

CSMouseX PROC
  MOV AX, MouseX
  SHR AX, 1
  RET
CSMouseX ENDP

CSMouseY PROC
  MOV AX, MouseY
  RET
CSMouseY ENDP

CSMouseLB PROC
  XOR AH, AH
  MOV AL, MouseB
  AND AL, 1
  RET
CSMouseLB ENDP

CSMouseRB PROC
  XOR AH, AH
  MOV AL, MouseB
  AND AL, 2
  SHR AX, 1
  RET
CSMouseRB ENDP

CSMouseOn PROC
  MOV BL, MouseOn
  OR  BL, BL
  JNZ EndMouseOn
  MOV AX, 1
  INT 33h
  MOV MouseOn, 1
EndMouseOn:
  RET
CSMouseOn ENDP

CSMouseOff PROC
  MOV BL, MouseOn
  OR  BL, BL
  JZ  EndMouseOff
  MOV AX, 2
  INT 33h
  MOV MouseOn, 0
EndMouseOff:
  RET
CSMouseOff ENDP

CSSetMouseXY PROC
  PUSH BP
  MOV BP, SP
  MOV CX, [BP+08]
  SHL CX, 1
  MOV MouseX, CX
  MOV DX, [BP+06]
  MOV MouseY, DX
  MOV AX, 4
  INT 33h
  POP BP
  RET 4
CSSetMouseXY ENDP

CSSetMouseRange PROC
  PUSH BP
  MOV BP, SP
  MOV BL, MouseOn
  OR  BL, BL
  JZ  SkipOff
  MOV AX, 2
  INT 33h
SkipOff:
  MOV CX, [BP+12]
  SHL CX, 1
  MOV DX, [BP+08]
  SHL DX, 1
  MOV AX, 7
  INT 33h
  MOV CX, [BP+10]
  MOV DX, [BP+06]
  MOV AX, 8
  INT 33h
  MOV BL, MouseOn
  OR  BL, BL
  JZ  SkipOn
  MOV AX, 1
  INT 33h
SkipOn:
  POP BP
  RET 8
CSSetMouseRange ENDP

CSSetMouseSpeed PROC
  PUSH BP
  MOV BP, SP
  MOV DX, [BP+06]
  MOV CX, [BP+08]
  SHL CX, 1
  MOV AX, 0Fh
  INT 33h
  POP BP
  RET 4
CSSetMouseSpeed ENDP

xCSSetMouseCursor PROC
  PUSH BP
  MOV BP, SP
  MOV BL, MouseOn
  OR  BL, BL
  JZ  SkipOff1
  MOV AX, 2
  INT 33h
SkipOff1:
  MOV BX, [BP+12]
  MOV CX, [BP+10]
  MOV ES, [BP+08]
  MOV DX, [BP+06]
  MOV AX, 9
  INT 33h
  MOV BL, MouseOn
  OR  BL, BL
  JZ  SkipOn1
  MOV AX, 1
  INT 33h
SkipOn1:
  POP BP
  RET 8
xCSSetMouseCursor ENDP

CSResetMouse PROC
  MOV BL, MouseOn
  OR  BL, BL
  JZ  SkipOff2
  MOV AX, 2
  INT 33h
SkipOff2:
  XOR CX, CX
  MOV DX, 639
  MOV AX, 7
  INT 33h
  XOR CX, CX
  MOV DX, 199
  MOV AX, 8
  INT 33h
  XOR CX, CX
  XOR BX, BX
  MOV AX, SEG MouseShape
  MOV ES, AX
  MOV DX, OFFSET MouseShape
  MOV AX, 9
  INT 33h
  MOV CX, 8
  MOV DX, 16
  MOV AX, 0Fh
  INT 33h
  MOV BL, MouseOn
  OR  BL, BL
  JZ  SkipOn2
  MOV AX, 1
  INT 33h
SkipOn2:
  RET
CSResetMouse ENDP

CSMouseClickOn PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV BX, MouseX
  SHR BX, 1
  MOV CX, MouseY
  CMP BX, [BP+12]
  JL  ClickOut
  CMP CX, [BP+10]
  JL  ClickOut
  CMP BX, [BP+08]
  JG  ClickOut
  CMP CX, [BP+06]
  JG  ClickOut
  MOV AL, MouseB
ClickOut:
  POP BP
  RET 8
CSMouseClickOn ENDP

CSMouseOver PROC
  PUSH BP
  MOV BP, SP
  XOR AX, AX
  MOV BX, MouseX
  SHR BX, 1
  MOV CX, MouseY
  CMP BX, [BP+12]
  JL  MoveOut
  CMP CX, [BP+10]
  JL  MoveOut
  CMP BX, [BP+08]
  JG  MoveOut
  CMP CX, [BP+06]
  JG  MoveOut
  MOV AX, 1
MoveOut:
  POP BP
  RET 8
CSMouseOver ENDP

END
