;----------------------------------------------------------------------------
;
;  CosmoX MMX ROUTINES Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P586
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

INCLUDE MMX.INC

.DATA

ALIGN 2

MMXDetected         DW  0               ;  Does the CPU support MMX ?

.CODE

PUBLIC  CSDetectMMX, CSClearMMX, CSPcopyMMX

CSDetectMMX PROC
  PUSHFD
  PUSHFD
  POP EAX
  OR  EAX, 00200000h
  PUSH EAX
  POPFD
  PUSHFD
  POP EAX
  POPFD
  AND EAX, 00200000h
  OR  EAX, EAX
  JZ  NoMMX
  MOV EAX, 01h
  CPUID
  AND EDX, 00800000h
  OR  EDX, EDX
  JZ  NoMMX
  MOV AX, 1
  MOV MMXDetected, AX
  RET
NoMMX:
  XOR AX, AX
  MOV MMXDetected, AX
  RET
CSDetectMMX ENDP

CSClearMMX PROC
  PUSH BP
  MOV BP, SP
  MOV DX, MMXDetected
  OR  DX, DX
  JZ  NoMMXClear
  MOV BX, [BP+08]
  MOV AX, [BP+06]
  MOV ES, BX
  MOV AH, AL
  MOV BX, AX
  SHL EAX, 16
  XOR DI, DI
  MOV AX, BX
  MOV CX, 2000
  MOV ES:[DI], EAX
  MOV ES:[DI+4], EAX
  MMX_MOVQ_REG_ESDI MM0
ClearMMXLoop:
  MMX_MOVQ_ESDI_REG MM0
  ADD DI, 8
  MMX_MOVQ_ESDI_REG MM0
  ADD DI, 8
  MMX_MOVQ_ESDI_REG MM0
  ADD DI, 8
  MMX_MOVQ_ESDI_REG MM0
  ADD DI, 8
  DEC CX
  JNZ ClearMMXLoop
  MMX_EMMS
  POP BP
  RET 4
NoMMXClear:
  MOV BX, [BP+08]
  MOV AX, [BP+06]
  MOV ES, BX
  MOV AH, AL
  MOV BX, AX
  SHL EAX, 16
  XOR DI, DI
  MOV AX, BX
  MOV CX, 16000
  REP STOSD
  POP BP
  RET 4
CSClearMMX ENDP

CSPcopyMMX PROC
  PUSH BP
  MOV BP, SP
  MOV DX, MMXDetected
  OR  DX, DX
  JZ  NoMMXPcopy
  MOV AX, [BP+08]
  MOV BX, [BP+06]
  MOV ES, AX
  MOV GS, AX
  XOR DI, DI
  MOV CX, 2000
PcopyMMXLoop:  
  MMX_MOVQ_REG_ESDI MM0
  MMX_MOVQ_GSDI_REG MM0
  ADD DI, 8
  MMX_MOVQ_REG_ESDI MM0
  MMX_MOVQ_GSDI_REG MM0
  ADD DI, 8
  MMX_MOVQ_REG_ESDI MM0
  MMX_MOVQ_GSDI_REG MM0
  ADD DI, 8
  MMX_MOVQ_REG_ESDI MM0
  MMX_MOVQ_GSDI_REG MM0
  ADD DI, 8
  DEC CX
  JNZ PcopyMMXLoop
  MMX_EMMS
  POP BP
  RET 4
NoMMXPcopy:
  MOV DX, DS
  MOV AX, [BP+08]
  MOV BX, [BP+06]
  MOV DS, AX
  MOV ES, BX
  MOV CX, 16000
  XOR DI, DI
  XOR SI, SI
  REP MOVSD
  MOV DS, DX
  POP BP
  RET 4
CSPcopyMMX ENDP

END
