;----------------------------------------------------------------------------
;
;  CosmoX MEMORY Handling Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

.CODE

PUBLIC  CSPoke, CSPeek, CSPoke16, CSPeek16, CSPoke32, CSPeek32, CSMemCopy
PUBLIC  CSMemSwap

CSPoke PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+10]
  MOV DI, [BP+06]
  MOV ES, AX
  MOV AX, [BP+04]
  MOV ES:[DI], AL
  MOV BP, BX
  RET 8
CSPoke ENDP

CSPeek PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV ES, AX
  MOV DI, [BP+04]
  MOV AL, ES:[DI]
  XOR AH, AH
  MOV BP, BX
  RET 6
CSPeek ENDP

CSPoke16 PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+10]
  MOV DI, [BP+06]
  MOV ES, AX
  MOV AX, [BP+04]
  MOV ES:[DI], AX
  MOV BP, BX
  RET 8
CSPoke16 ENDP

CSPeek16 PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV ES, AX
  MOV DI, [BP+04]
  MOV AX, ES:[DI]
  MOV BP, BX
  RET 6
CSPeek16 ENDP

CSPoke32 PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+12]
  MOV ES, AX
  MOV DI, [BP+08]
  MOV EAX, [BP+04]
  MOV ES:[DI], EAX
  MOV BP, BX
  RET 10
CSPoke32 ENDP

CSPeek32 PROC
  MOV BX, BP
  MOV BP, SP
  MOV AX, [BP+08]
  MOV ES, AX
  MOV DI, [BP+04]
  MOV AX, ES:[DI]
  MOV DX, ES:[DI+2]
  MOV BP, BX
  RET 6
CSPeek32 ENDP

CSMemCopy PROC
  MOV BX, BP
  MOV DX, DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV DS, AX
  MOV SI, [BP+14]
  MOV AX, [BP+12]
  MOV ES, AX
  MOV DI, [BP+08]
  MOV CX, [BP+04]
  TEST CX, 3
  JZ  DWordMemCopy
  TEST CX, 1
  JZ  WordMemCopy
  SHR CX, 1
  REP MOVSW
  ADC CX, CX
  REP MOVSB
  JMP EndMemCopy
DWordMemCopy:
  SHR CX, 2
  REP MOVSD
  JMP EndMemCopy
WordMemCopy:
  SHR CX, 1
  REP MOVSW
EndMemCopy:
  MOV DS, DX
  MOV BP, BX
  RET 16
CSMemCopy ENDP

CSMemSwap PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+22]
  MOV DS, AX
  MOV AX, [BP+16]
  MOV ES, AX
  MOV SI, [BP+18]
  MOV DI, [BP+12]
  MOV CX, [BP+08]
  TEST CX, 3
  JZ  DWordMemSwap
  TEST CX, 1
  JZ  WordMemSwap
ByteMemSwap:
  SHR CX, 1
  JNC ByteMemSwapW
  MOV AH, [SI]
  MOV AL, ES:[DI]
  MOV [SI], AL
  MOV ES:[DI], AH
  INC SI
  INC DI
ByteMemSwapW:
  MOV AX, [SI]
  MOV BX, ES:[DI]
  MOV [SI], BX
  MOV ES:[DI], AX
  ADD SI, 2
  ADD DI, 2
  DEC CX
  JNZ ByteMemSwapW
  JMP EndMemSwap
DWordMemSwap:
  SHR CX, 2
DWordMemSwapLoop:
  MOV EAX, [SI]
  MOV EBX, ES:[DI]
  MOV [SI], EBX
  MOV ES:[DI], EAX
  ADD SI, 4
  ADD DI, 4
  DEC CX
  JNZ DWordMemSwapLoop
  JMP EndMemSwap
WordMemSwap:
  SHR CX, 1
WordMemSwapLoop:
  MOV AX, [SI]
  MOV BX, ES:[DI]
  MOV [SI], BX
  MOV ES:[DI], AX
  ADD SI, 2
  ADD DI, 2
  DEC CX
  JNZ WordMemSwapLoop
EndMemSwap:
  POP DS
  POP BP
  RET 16
CSMemSwap ENDP

END
