;----------------------------------------------------------------------------
;
;  CosmoX MATRIX Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P386
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

.DATA

ALIGN 2

Matrix              DD  16 dup(?)       ;  Temporal Matrix
Vertex              DD  3 dup(?)        ;  Temporal Vertex

.CODE

PUBLIC  CSCopyMatrix, CSIdentityMatrix, CSInitRotXMatrix, CSInitRotYMatrix
PUBLIC  CSInitRotZMatrix, CSInitTransMatrix, CSInitScaleMatrix
PUBLIC  CSMatrixMulMatrix, CSVectorMulMatrix, CSProjectVector, CSPolyFacing
PUBLIC  CSVectorDot, CSXNormal, CSYNormal, CSZNormal, CSUnitVector

CSCopyMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV BX, [BP+12]
  MOV DS, AX
  MOV ES, BX
  MOV SI, [BP+14]
  MOV DI, [BP+08]
  MOV CX, 16
  REP MOVSD
  POP DS
  POP BP
  RET 12
CSCopyMatrix ENDP

CSIdentityMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+12]
  MOV SI, [BP+08]
  MOV DS, AX
  FLDZ
  FLD1
  FST DWORD PTR [SI]
  FST DWORD PTR [SI+20]
  FST DWORD PTR [SI+40]
  FSTP DWORD PTR [SI+60]
  FST DWORD PTR [SI+04]
  FST DWORD PTR [SI+08]
  FST DWORD PTR [SI+12]
  FST DWORD PTR [SI+16]
  FST DWORD PTR [SI+24]
  FST DWORD PTR [SI+28]
  FST DWORD PTR [SI+32]
  FST DWORD PTR [SI+36]
  FST DWORD PTR [SI+44]
  FST DWORD PTR [SI+48]
  FST DWORD PTR [SI+52]
  FSTP DWORD PTR [SI+56]
  FWAIT
  POP DS
  POP BP
  RET 6
CSIdentityMatrix ENDP

CSInitRotXMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+20]
  MOV SI, [BP+16]
  MOV DS, AX
  FLD DWORD PTR [BP+08]
  FLD DWORD PTR [BP+12]
  FLDZ
  FLD1
  FST DWORD PTR [SI]
  FSTP DWORD PTR [SI+60]
  FST DWORD PTR [SI+04]
  FST DWORD PTR [SI+08]
  FST DWORD PTR [SI+12]
  FST DWORD PTR [SI+16]
  FST DWORD PTR [SI+28]
  FST DWORD PTR [SI+32]
  FST DWORD PTR [SI+44]
  FST DWORD PTR [SI+48]
  FST DWORD PTR [SI+52]
  FSTP DWORD PTR [SI+56]
  FST DWORD PTR [SI+20]
  FSTP DWORD PTR [SI+40]
  FST DWORD PTR [SI+24]
  FCHS
  FSTP DWORD PTR [SI+36]
  FWAIT
  POP DS
  POP BP
  RET 14
CSInitRotXMatrix ENDP

CSInitRotYMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+20]
  MOV SI, [BP+16]
  MOV DS, AX
  FLD DWORD PTR [BP+08]
  FLD DWORD PTR [BP+12]
  FLDZ
  FLD1
  FST DWORD PTR [SI+20]
  FSTP DWORD PTR [SI+60]
  FST DWORD PTR [SI+04]
  FST DWORD PTR [SI+12]
  FST DWORD PTR [SI+16]
  FST DWORD PTR [SI+24]
  FST DWORD PTR [SI+28]
  FST DWORD PTR [SI+36]
  FST DWORD PTR [SI+44]
  FST DWORD PTR [SI+48]
  FST DWORD PTR [SI+52]
  FSTP DWORD PTR [SI+56]
  FST DWORD PTR [SI]
  FSTP DWORD PTR [SI+40]
  FST DWORD PTR [SI+32]
  FCHS
  FSTP DWORD PTR [SI+08]
  FWAIT
  POP DS
  POP BP
  RET 14
CSInitRotYMatrix ENDP

CSInitRotZMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+20]
  MOV SI, [BP+16]
  MOV DS, AX
  FLD DWORD PTR [BP+08]
  FLD DWORD PTR [BP+12]
  FLDZ
  FLD1
  FST DWORD PTR [SI+40]
  FSTP DWORD PTR [SI+60]
  FST DWORD PTR [SI+08]
  FST DWORD PTR [SI+12]
  FST DWORD PTR [SI+24]
  FST DWORD PTR [SI+28]
  FST DWORD PTR [SI+32]
  FST DWORD PTR [SI+36]
  FST DWORD PTR [SI+44]
  FST DWORD PTR [SI+48]
  FST DWORD PTR [SI+52]
  FSTP DWORD PTR [SI+56]
  FST DWORD PTR [SI]
  FSTP DWORD PTR [SI+20]
  FST DWORD PTR [SI+04]
  FCHS
  FSTP DWORD PTR [SI+16]
  FWAIT
  POP DS
  POP BP
  RET 14
CSInitRotZMatrix ENDP

CSInitTransMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+24]
  MOV SI, [BP+20]
  MOV DS, AX
  FLDZ
  FLD1
  FST DWORD PTR [SI]
  FST DWORD PTR [SI+20]
  FST DWORD PTR [SI+40]
  FSTP DWORD PTR [SI+60]
  FST DWORD PTR [SI+04]
  FST DWORD PTR [SI+08]
  FST DWORD PTR [SI+12]
  FST DWORD PTR [SI+16]
  FST DWORD PTR [SI+24]
  FST DWORD PTR [SI+28]
  FST DWORD PTR [SI+32]
  FST DWORD PTR [SI+36]
  FSTP DWORD PTR [SI+44]
  FLD DWORD PTR [BP+08]
  FLD DWORD PTR [BP+12]
  FLD DWORD PTR [BP+16]
  FSTP DWORD PTR [SI+48]
  FSTP DWORD PTR [SI+52]
  FSTP DWORD PTR [SI+56]
  FWAIT
  POP DS
  POP BP
  RET 18
CSInitTransMatrix ENDP

CSInitScaleMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+24]
  MOV SI, [BP+20]
  MOV DS, AX
  FLDZ
  FLD1
  FSTP DWORD PTR [SI+60]
  FST DWORD PTR [SI+04]
  FST DWORD PTR [SI+08]
  FST DWORD PTR [SI+12]
  FST DWORD PTR [SI+16]
  FST DWORD PTR [SI+24]
  FST DWORD PTR [SI+28]
  FST DWORD PTR [SI+32]
  FST DWORD PTR [SI+36]
  FST DWORD PTR [SI+44]
  FST DWORD PTR [SI+48]
  FST DWORD PTR [SI+52]
  FSTP DWORD PTR [SI+56]
  FLD DWORD PTR [BP+08]
  FLD DWORD PTR [BP+12]
  FLD DWORD PTR [BP+16]
  FSTP DWORD PTR [SI]
  FSTP DWORD PTR [SI+20]
  FSTP DWORD PTR [SI+40]
  FWAIT
  POP DS
  POP BP
  RET 18
CSInitScaleMatrix ENDP

CSMatrixMulMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+18]
  MOV BX, [BP+12]
  MOV CX, SEG Matrix
  MOV DS, AX
  MOV ES, BX
  MOV FS, CX
  XOR SI, SI
  XOR DI, DI
MatrixMul:
  MOV AX, SI
  MOV CX, [BP+14]
  SHL AX, 2
  ADD CX, AX
  MOV BX, CX
  FLD DWORD PTR [BX]
  MOV AX, DI
  MOV DX, [BP+08]
  SHL AX, 4
  ADD DX, AX
  MOV BX, DX
  FMUL DWORD PTR ES:[BX]
  MOV BX, CX
  FLD DWORD PTR [BX+16]
  MOV BX, DX
  FMUL DWORD PTR ES:[BX+4]
  FADDP
  MOV BX, CX
  FLD DWORD PTR [BX+32]
  MOV BX, DX
  FMUL DWORD PTR ES:[BX+8]
  FADDP
  MOV BX, CX
  FLD DWORD PTR [BX+48]
  MOV BX, DX
  FMUL DWORD PTR ES:[BX+12]
  FADDP
  MOV AX, SI
  MOV CX, DI
  MOV BX, OFFSET Matrix
  SHL AX, 2
  SHL CX, 4
  ADD BX, AX
  ADD BX, CX
  FSTP DWORD PTR FS:[BX]
  INC DI
  CMP DI, 4
  JL  MatrixMul
  XOR DI, DI
  INC SI
  CMP SI, 4
  JL  MatrixMul
  FWAIT
  MOV AX, [BP+18]
  MOV BX, SEG Matrix
  MOV ES, AX
  MOV DS, BX
  MOV SI, OFFSET Matrix
  MOV DI, [BP+14]
  MOV CX, 16
  REP MOVSD
  POP DS
  POP BP
  RET 12
CSMatrixMulMatrix ENDP

CSVectorMulMatrix PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+24]
  MOV BX, [BP+18]
  MOV CX, SEG Vertex
  MOV DS, AX
  MOV ES, BX
  MOV FS, CX
  MOV BX, [BP+20]
  MOV SI, [BP+14]
  MOV DI, OFFSET Vertex
  FLD DWORD PTR [BX]
  FMUL DWORD PTR ES:[SI]
  FLD DWORD PTR [BX+04]
  FMUL DWORD PTR ES:[SI+16]
  FADDP
  FLD DWORD PTR [BX+08]
  FMUL DWORD PTR ES:[SI+32]
  FADDP
  FADD DWORD PTR ES:[SI+48]
  FSTP DWORD PTR FS:[DI]
  FLD DWORD PTR [BX]
  FMUL DWORD PTR ES:[SI+04]
  FLD DWORD PTR [BX+04]
  FMUL DWORD PTR ES:[SI+20]
  FADDP
  FLD DWORD PTR [BX+08]
  FMUL DWORD PTR ES:[SI+36]
  FADDP
  FADD DWORD PTR ES:[SI+52]
  FSTP DWORD PTR FS:[DI+4]
  FLD DWORD PTR [BX]
  FMUL DWORD PTR ES:[SI+08]
  FLD DWORD PTR [BX+04]
  FMUL DWORD PTR ES:[SI+24]
  FADDP
  FLD DWORD PTR [BX+08]
  FMUL DWORD PTR ES:[SI+40]
  FADDP
  FADD DWORD PTR ES:[SI+56]
  FSTP DWORD PTR FS:[DI+8]
  FWAIT
  MOV AX, [BP+12]
  MOV SI, [BP+08]
  MOV DS, AX
  MOV EAX, FS:[DI]
  MOV EBX, FS:[DI+04]
  MOV ECX, FS:[DI+08]
  MOV [SI], EAX
  MOV [SI+04], EBX
  MOV [SI+08], ECX
  POP DS
  POP BP
  RET 18
CSVectorMulMatrix ENDP

CSProjectVector PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+22]
  MOV BX, [BP+16]
  MOV DS, AX
  MOV ES, BX
  MOV SI, [BP+18]
  MOV DI, [BP+12]
  FLD DWORD PTR [SI]
  FLD DWORD PTR [SI+8]
  FSUBR DWORD PTR [BP+08]
  FDIVR DWORD PTR [BP+08]
  FMULP
  FISTP WORD PTR ES:[DI]
  FLD DWORD PTR [SI+4]
  FLD DWORD PTR [SI+8]
  FSUBR DWORD PTR [BP+08]
  FDIVR DWORD PTR [BP+08]
  FMULP
  FCHS
  FISTP WORD PTR ES:[DI+2]
  FWAIT
  MOV AX, ES:[DI]
  MOV BX, ES:[DI+2]
  ADD AX, 160
  ADD BX, 100
  MOV ES:[DI], AX
  MOV ES:[DI+2], BX
  POP DS
  POP BP
  RET 16
CSProjectVector ENDP

CSPolyFacing PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+24]
  MOV CX, [BP+18]
  MOV DX, [BP+12]
  MOV SI, [BP+20]
  MOV DI, [BP+14]
  MOV BX, [BP+08]
  MOV DS, AX
  MOV ES, CX
  MOV GS, DX
  MOV AX, ES:[DI]
  MOV DX, [SI+02]
  SUB AX, [SI]
  SUB DX, GS:[BX+02]
  IMUL DX
  MOV CX, AX
  MOV AX, ES:[DI+02]
  MOV DX, [SI]
  SUB AX, [SI+02]
  SUB DX, GS:[BX]
  IMUL DX
  SUB CX, AX
  MOV AX, CX
  POP DS
  POP BP
  RET 18
CSPolyFacing ENDP

CSVectorDot PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+18]
  MOV DX, [BP+12]
  MOV DI, [BP+06]
  MOV SI, [BP+14]
  MOV BX, [BP+08]
  MOV ES, AX
  MOV FS, DX
  FLD DWORD PTR ES:[SI+08]
  FLD DWORD PTR ES:[SI+04]
  FLD DWORD PTR ES:[SI]
  FMUL DWORD PTR FS:[BX]
  FXCH ST(1)
  FMUL DWORD PTR FS:[BX+04]
  FADDP
  FXCH ST(1)
  FMUL DWORD PTR FS:[BX+08]
  FADDP
  FSTP DWORD PTR [DI]
  FWAIT
  MOV AX, [BP+06]
  POP BP
  RET 14
CSVectorDot ENDP

CSXNormal PROC
  PUSH BP
  MOV BP, SP
  PUSH DS
  MOV AX, [BP+24]
  MOV CX, [BP+18]
  MOV DX, [BP+12]
  MOV SI, [BP+20]
  MOV DI, [BP+14]
  MOV BX, [BP+08]
  MOV DS, AX
  MOV ES, CX
  MOV FS, DX
  FLD DWORD PTR ES:[DI+08]
  FLD DWORD PTR [SI+08]
  FSUBP
  FLD DWORD PTR [SI+04]
  FLD DWORD PTR FS:[BX+04]
  FSUBP
  FMULP
  FLD DWORD PTR ES:[DI+04]
  FLD DWORD PTR [SI+04]
  FSUBP
  FLD DWORD PTR [SI+08]
  FLD DWORD PTR FS:[BX+08]
  FSUBP
  FMULP
  FSUBP
  POP DS
  MOV AX, [BP+06]
  MOV SI, AX
  FSTP DWORD PTR [SI]
  FWAIT
  POP BP
  RET 20
CSXNormal ENDP

CSYNormal PROC
  PUSH BP
  MOV BP, SP
  PUSH DS
  MOV AX, [BP+24]
  MOV CX, [BP+18]
  MOV DX, [BP+12]
  MOV SI, [BP+20]
  MOV DI, [BP+14]
  MOV BX, [BP+08]
  MOV DS, AX
  MOV ES, CX
  MOV FS, DX
  FLD DWORD PTR ES:[DI]
  FLD DWORD PTR [SI]
  FSUBP
  FLD DWORD PTR [SI+08]
  FLD DWORD PTR FS:[BX+08]
  FSUBP
  FMULP
  FLD DWORD PTR ES:[DI+08]
  FLD DWORD PTR [SI+08]
  FSUBP
  FLD DWORD PTR [SI]
  FLD DWORD PTR FS:[BX]
  FSUBP
  FMULP
  FSUBP
  POP DS
  MOV AX, [BP+06]
  MOV SI, AX
  FSTP DWORD PTR [SI]
  FWAIT
  POP BP
  RET 20
CSYNormal ENDP

CSZNormal PROC
  PUSH BP
  MOV BP, SP
  PUSH DS
  MOV AX, [BP+24]
  MOV CX, [BP+18]
  MOV DX, [BP+12]
  MOV SI, [BP+20]
  MOV DI, [BP+14]
  MOV BX, [BP+08]
  MOV DS, AX
  MOV ES, CX
  MOV FS, DX
  FLD DWORD PTR ES:[DI+04]
  FLD DWORD PTR [SI+04]
  FSUBP
  FLD DWORD PTR [SI]
  FLD DWORD PTR FS:[BX]
  FSUBP
  FMULP
  FLD DWORD PTR ES:[DI]
  FLD DWORD PTR [SI]
  FSUBP
  FLD DWORD PTR [SI+04]
  FLD DWORD PTR FS:[BX+04]
  FSUBP
  FMULP
  FSUBP
  POP DS
  MOV AX, [BP+06]
  MOV SI, AX
  FSTP DWORD PTR [SI]
  FWAIT
  POP BP
  RET 20
CSZNormal ENDP

CSUnitVector PROC
  PUSH BP
  PUSH DS
  MOV BP, SP
  MOV AX, [BP+14]
  MOV DX, [BP+10]
  MOV SI, [BP+12]
  MOV DI, [BP+08]
  MOV DS, AX
  MOV ES, DX
  FLD DWORD PTR [SI+08]
  FLD DWORD PTR [SI+08]
  FMULP
  FLD DWORD PTR [SI+04]
  FLD DWORD PTR [SI+04]
  FMULP
  FLD DWORD PTR [SI]
  FLD DWORD PTR [SI]
  FMULP
  FADDP
  FADDP
  FSQRT
  FLD DWORD PTR [SI+08]
  FLD DWORD PTR [SI+04]
  FLD DWORD PTR [SI]
  FDIV ST, ST(3)
  FXCH ST(1)
  FDIV ST, ST(3)
  FXCH ST(2)
  FDIV ST, ST(3)
  FSTP DWORD PTR ES:[DI+08]
  FSTP DWORD PTR ES:[DI]
  FSTP DWORD PTR ES:[DI+04]
  FFREE
  FWAIT
  POP DS
  POP BP
  RET 8
CSUnitVector ENDP

END
