;----------------------------------------------------------------------------
;
;  CosmoX MAIN Module
;
;  Part of the CosmoX Library v1.6
;  by Bobby3999 - CosmoSoft 2000-2001
;
;----------------------------------------------------------------------------

 P586
.MODEL USE16 MEDIUM, BASIC
.STACK 200h

EXTRN CSDestroyBMap     : FAR
EXTRN CSRemoveKeyBoard  : FAR
EXTRN CSRemoveTimer     : FAR

BASIC_StrDescriptor STRUC
  StrLenght   DW  ?
  StrOffset   DW  ?
BASIC_StrDescriptor ENDS

.DATA

PUBLIC  BMapSeg, BMapActive, ClipX1, ClipX2, ClipY1, ClipY2

ALIGN 2

BMapSeg             DW  0               ;  Blender map segment
ClipX1              DW  0               ;  Clipping Box
ClipX2              DW  319             ;  Clipping Box
ClipY1              DW  0               ;  Clipping Box
ClipY2              DW  199             ;  Clipping Box
CpuType             DW  ?               ;  Cpu type
LibVersion          DW  0160h           ;  Library Version
BMapActive          DB  0               ;  Is the blender map active?
CpuIDString         DB  12 dup(?)       ;  CPU ID string buffer
CpuIdDescriptor     BASIC_StrDescriptor <12, OFFSET CpuIDString>
LibIDString         DB  'CosmoX v1.6 by Bobby3999, CosmoSoft 2001'
LibIDDescriptor     BASIC_StrDescriptor <40, OFFSET LibIDString>
CPU386              DB  '80386                '
CPU486              DB  '80486                '
CPU586              DB  'Pentium              '
CPU686              DB  'Pentium II, or higher'
CPUDescriptor       BASIC_StrDescriptor <21, ?>

.CODE

PUBLIC  CSVer, CSDetectCPU, CSInitVGA, CSInitText, CSDelay, CSTimerTicks
PUBLIC  CSSort, xCSGetCard, CSSetClipBox, CSGetClipBox, CSId, CSCpuID
PUBLIC  CSProcessor, CSClose

CSVer PROC
  MOV AX, LibVersion
  RET
CSVer ENDP

CSInitVGA PROC
  MOV AX, 0013h
  INT 10h
  RET
CSInitVGA ENDP

CSInitText PROC
  MOV AX, 0003h
  INT 10h
  RET
CSInitText ENDP

CSTimerTicks PROC
  MOV AX, 40h
  MOV ES, AX
  MOV DI, 6Ch
  MOV AX, ES:[DI]
  MOV DX, ES:[DI+2]
  RET
CSTimerTicks ENDP

CSDelay PROC
  MOV BX, BP
  MOV BP, SP
  MOV CX, [BP+04]
DelayLoop:
  MOV DX, 03DAh
Delay1:
  IN  AL, DX
  AND AL, 08h
  JNZ Delay1
Delay2:
  IN  AL, DX
  AND AL, 08h
  JZ  Delay2
  DEC CX
  JNZ DelayLoop
  MOV BP, BX
  RET 2
CSDelay ENDP

CSSort PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+14]
  MOV ES, AX
SortLoop:
  MOV SI, [BP+12]
  ADD SI, [BP+06]
  MOV DI, SI
  ADD DI, [BP+08]
  MOV CX, [BP+10]
  DEC CX
  XOR DX, DX
SortLoop2:
  MOV AX, ES:[SI]
  MOV BX, ES:[DI]
  CMP AX, BX
  JLE NoSwap
  MOV FS, SI
  MOV GS, DI
  MOV BX, [BP+08]
  SHR BX, 1
  SUB SI, [BP+06]
  SUB DI, [BP+06]
SwapLoop:
  MOV AX, ES:[SI]
  MOV DX, ES:[DI]
  MOV ES:[SI], DX
  MOV ES:[DI], AX
  ADD SI, 2
  ADD DI, 2
  DEC BX
  JNZ SwapLoop
  MOV DI, GS
  MOV SI, FS
  MOV DX, 1
NoSwap:
  MOV SI, DI
  ADD DI, [BP+08]
  DEC CX
  JNZ SortLoop2
  OR  DX, DX
  JNZ SortLoop
  POP BP
  RET 10
CSSort ENDP

xCSGetCard PROC
  PUSH BP
  SUB SP, 256
  MOV BP, SP
  MOV AX, SS
  MOV ES, AX
  MOV DI, BP
  MOV AX, 4F00h
  INT 10h
  MOV FS, [BP+08]
  MOV SI, [BP+06]
  ADD SP, 256
  MOV BP, SP
  MOV ES, [BP+08]
  MOV DI, [BP+06]
  MOV BX, 256
  CMP AL, 4Fh
  JNE EndCard
  OR  AH, AH
  JNZ EndCard
StoreCard:
  MOV AL, FS:[SI]
  INC SI
  OR  AL, AL
  JZ  EndCard
  MOV ES:[DI], AL
  INC DI
  DEC BX
  JNZ StoreCard
EndCard:
  POP BP
  RET 4
xCSGetCard ENDP

CSDetectCPU PROC
  MOV CpuType, 286
  PUSHF
  MOV AX, 7000h
  PUSH AX
  POPF
  PUSHF
  POP AX
  AND AX, 7000h
  POPF
  OR  AX, AX
  JZ  EndDetectCPU
  MOV CpuType, 386
  PUSHFD
  PUSHFD
  POP EAX
  OR  EAX, 00040000h
  PUSH EAX
  POPFD
  PUSHFD
  POP EAX
  POPFD
  AND EAX, 00040000h
  OR  EAX, EAX
  JZ  EndDetectCPU
  MOV CpuType, 486
  PUSHFD
  PUSHFD
  POP EAX
  OR  EAX, 00200000h
  PUSH EAX
  POPFD
  PUSHFD
  POP EAX
  POPFD
  AND EAX, 00200000h
  OR  EAX, EAX
  JZ  EndDetectCPU
  MOV EAX, 1
  CPUID
  SHR EAX, 8
  AND AX, 0Fh
  CMP AX, 4
  JE  EndDetectCPU
  CMP AX, 5
  JE  ItsAPentium
  CMP AX, 6
  JE  ItsAPentiumPro
  MOV CpuType, 786
  JMP EndDetectCPU
ItsAPentium:
  MOV CpuType, 586
  JMP EndDetectCPU
ItsAPentiumPro:
  MOV CpuType, 686
EndDetectCPU:
  MOV AX, CpuType
  RET
CSDetectCPU ENDP

CSSetClipBox PROC
  PUSH BP
  MOV BP, SP
  MOV AX, [BP+12]
  MOV BX, [BP+08]
  CMP AX, BX
  JE  BadClipping
  JL  NoSwap1
  MOV ClipX1, BX
  MOV ClipX2, AX
  JMP SetYS
NoSwap1:
  MOV ClipX2, BX
  MOV ClipX1, AX
SetYS:
  MOV AX, [BP+10]
  MOV BX, [BP+06]
  CMP AX, BX
  JE  BadClipping
  JL  NoSwap2
  MOV ClipY1, BX
  MOV ClipY2, AX
  JMP EndClip
NoSwap2:
  MOV ClipY2, BX
  MOV ClipY1, AX
EndClip:
  POP BP
  RET 8
BadClipping:
  XOR AX, AX
  MOV ClipX1, AX
  MOV ClipY1, AX
  MOV AX, 199
  MOV ClipY2, AX
  MOV AX, 319
  MOV ClipX2, AX
  POP BP
  RET 8
CSSetClipBox ENDP

CSGetClipBox PROC
  PUSH BP
  MOV BP, SP
  MOV BX, [BP+12]
  MOV AX, ClipX1
  MOV [BX], AX
  MOV BX, [BP+10]
  MOV AX, ClipY1
  MOV [BX], AX
  MOV BX, [BP+08]
  MOV AX, ClipX2
  MOV [BX], AX
  MOV BX, [BP+06]
  MOV AX, ClipY2
  MOV [BX], AX
  POP BP
  RET 8
CSGetClipBox ENDP

CSId PROC
  MOV AX, OFFSET LibIDDescriptor
  RET
CSId ENDP

CSCpuID PROC
  PUSHFD
  PUSHFD
  POP EAX
  OR  EAX, 00200000h
  PUSH EAX
  POPFD
  PUSHFD
  POP EAX
  POPFD
  AND EAX, 00200000h
  OR  EAX, EAX
  JZ  NoCpuID
  XOR EAX, EAX
  CPUID
  MOV SI, OFFSET CpuIDString
  MOV [SI], EBX
  MOV [SI+4], EDX
  MOV [SI+8], ECX
NoCpuID:
  MOV AX, OFFSET CpuIDDescriptor
  RET
CSCpuID ENDP

CSProcessor PROC
  CALL CSDetectCPU
  CMP AX, 386
  JNE Not386
  MOV DX, OFFSET CPU386
  MOV CPUDescriptor.StrOffset, DX
  MOV AX, OFFSET CPUDescriptor
  RET
Not386:
  CMP AX, 486
  JNE Not486
  MOV DX, OFFSET CPU486
  MOV CPUDescriptor.StrOffset, DX
  MOV AX, OFFSET CPUDescriptor
  RET
Not486:
  CMP AX, 586
  JNE Not586
  MOV DX, OFFSET CPU586
  MOV CPUDescriptor.StrOffset, DX
  MOV AX, OFFSET CPUDescriptor
  RET
Not586:
  MOV DX, OFFSET CPU686
  MOV CPUDescriptor.StrOffset, DX
  MOV AX, OFFSET CPUDescriptor
  RET
CSProcessor ENDP

CSClose PROC
  CALL CSDestroyBMap
  CALL CSRemoveKeyBoard
  CALL CSRemoveTimer
  CALL CSInitText
  RET
CSClose ENDP

END
